/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;

public class Name
extends Table {
    private static final long serialVersionUID = -6534023316796643941L;
    private int encoding = 0;
    private Map strings = new HashMap();
    public static final Integer COPYRIGHT_NOTICE = 0;
    public static final Integer FONT_FAMILY_NAME = 1;
    public static final Integer FONT_SUBFAMILY_NAME = 2;
    public static final Integer UNIQUE_FONT_IDENTIFIER = 3;
    public static final Integer FULL_FONT_NAME = 4;
    public static final Integer VERSION_STRING = 5;
    public static final Integer POSTSCRIPT_NAME = 6;
    public static final Integer TRADEMARK = 7;
    public static final Integer MANUFACTURER = 8;
    public static final Integer DESIGNER = 9;
    public static final Integer DESCRIPTION = 10;
    public static final Integer VENDOR_URL = 11;
    public static final Integer DESIGNER_URL = 12;
    public static final Integer LICENSE = 13;
    public static final Integer LICENSE_URL = 14;
    public static final Integer PREFERRED_FAMILY = 16;
    public static final Integer PREFERRED_SUBFAMILY = 17;
    public static final Integer COMPATIBLE = 18;
    public static final Integer SAMPLE_TEXT = 19;
    public static final String[] stringNames = new String[]{"COPYRIGHT_NOTICE", "FONT_FAMILY_NAME", "FONT_SUBFAMILY_NAME", "UNIQUE_FONT_IDENTIFIER", "FULL_FONT_NAME", "VERSION_STRING", "POSTSCRIPT_NAME", "TRADEMARK", "MANUFACTURER", "DESIGNER", "DESCRIPTION", "VENDOR_URL", "DESIGNER_URL", "LICENSE", "LICENSE_URL", "PREFERRED_FAMILY", "PREFERRED_SUBFAMILY", "COMPATIBLE", "SAMPLE_TEXT"};

    public Name(FontFile2 currentFontFile) {
        int startPointer = currentFontFile.selectTable(7);
        if (startPointer != 0) {
            currentFontFile.getNextUint16();
            int count = currentFontFile.getNextUint16();
            int offset = currentFontFile.getNextUint16();
            for (int i = 0; i < count; ++i) {
                int platformID = currentFontFile.getNextUint16();
                int platformSpecificID = currentFontFile.getNextUint16();
                int langID = currentFontFile.getNextUint16();
                int nameID = currentFontFile.getNextUint16();
                int length = currentFontFile.getNextUint16();
                int offset2 = currentFontFile.getNextUint16();
                if (!(platformID == 1 && platformSpecificID == 0 && langID == 0 || platformID == 3 && platformSpecificID == 0 && langID == 1033) && (platformID != 3 || platformSpecificID != 1 || langID != 1033)) continue;
                int oldP = currentFontFile.getPointer();
                currentFontFile.setPointer(startPointer + offset + offset2);
                if (platformID == 0 || platformID == 3) {
                    length /= 2;
                }
                StringBuilder s = new StringBuilder();
                s.setLength(length);
                for (int ii = 0; ii < length; ++ii) {
                    int nextChar = platformID == 0 || platformID == 3 ? currentFontFile.getNextUint16() : currentFontFile.getNextUint8();
                    s.setCharAt(ii, (char)nextChar);
                }
                String str = s.toString();
                if (str != null) {
                    this.strings.put(nameID, str);
                }
                currentFontFile.setPointer(oldP);
            }
        }
    }

    public Name() {
    }

    public Map getStrings() {
        return this.strings;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public String getString(Integer id) {
        return (String)this.strings.get(id);
    }
}

