/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Loca
extends Table {
    private static final long serialVersionUID = -3586162676690304168L;
    int[] glyphIndexStart;
    boolean isCorrupted = false;
    public int format;
    public int glyphCount;
    public int glyfTableLength;

    public Loca(FontFile2 currentFontFile, int glyphCount, int format) {
        if (currentFontFile == null) {
            return;
        }
        this.format = format;
        this.glyphCount = glyphCount;
        this.glyfTableLength = currentFontFile.getOffset(4);
        int startPointer = currentFontFile.selectTable(3);
        int locaLength = currentFontFile.getOffset(3);
        this.glyphIndexStart = new int[glyphCount + 1];
        if (startPointer != 0) {
            this.glyphIndexStart[0] = 0;
            if (format == 1 || format == 256) {
                if (LogWriter.isOutput() && locaLength / 4 != glyphCount + 1) {
                    LogWriter.writeLog("Incorrect length");
                }
                for (int i = 0; i < glyphCount; ++i) {
                    this.glyphIndexStart[i] = currentFontFile.getNextUint32();
                }
            } else {
                for (int i = 0; i < glyphCount; ++i) {
                    this.glyphIndexStart[i] = currentFontFile.getNextUint16() * 2;
                }
            }
            this.glyphIndexStart[glyphCount] = this.glyfTableLength;
        }
    }

    public int[] getIndices() {
        return this.glyphIndexStart;
    }

    public boolean isCorrupted() {
        return this.isCorrupted;
    }

    public int getFormat() {
        return this.format;
    }

    public int getGlyphCount() {
        return this.glyphCount;
    }

    public int getGlyfTableLength() {
        return this.glyfTableLength;
    }
}

