/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Head
extends Table {
    private static final long serialVersionUID = 628739364123537763L;
    protected int format = 0;
    protected float[] FontBBox = new float[4];
    protected int flags = 0;
    protected int unitsPerEm = 1024;

    public Head(FontFile2 currentFontFile) {
        int startPointer = currentFontFile.selectTable(0);
        if (startPointer == 0) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("No head table found");
            }
        } else {
            int i;
            currentFontFile.getNextUint32();
            for (i = 0; i < 3; ++i) {
                currentFontFile.getNextUint32();
            }
            this.flags = currentFontFile.getNextUint16();
            this.unitsPerEm = currentFontFile.getNextUint16();
            for (i = 0; i < 2; ++i) {
                currentFontFile.getNextUint64();
            }
            for (i = 0; i < 4; ++i) {
                this.FontBBox[i] = currentFontFile.getNextSignedInt16();
            }
            for (i = 0; i < 3; ++i) {
                currentFontFile.getNextUint16();
            }
            this.format = currentFontFile.getNextUint16();
        }
    }

    public Head() {
    }

    public int getFormat() {
        return this.format;
    }

    public float[] getFontBBox() {
        return this.FontBBox;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getUnitsPerEm() {
        return this.unitsPerEm;
    }
}

