/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jpedal.Display;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingMouseFunctionality;
import org.jpedal.examples.viewer.gui.swing.SwingMouseSelector;
import org.jpedal.io.PdfObjectReader;

public class SwingMousePageTurn
implements SwingMouseFunctionality {
    private PdfDecoder decode_pdf;
    private SwingGUI currentGUI;
    private Values commonValues;
    private Commands currentCommands;
    private long lastPress;
    private boolean drawingTurnover = false;
    private boolean previewTurnover = false;
    private boolean pageTurnAnimating = false;
    private int pageFlowCurrentPage;
    private double middleDragStartX;
    private double middleDragStartY;
    private double xVelocity;
    private double yVelocity;
    private Timer middleDragTimer;
    long timeOfLastPageChange;
    boolean altIsDown = false;

    public SwingMousePageTurn(PdfDecoder decode_pdf, SwingGUI currentGUI, Values commonValues, Commands currentCommands) {
        this.decode_pdf = decode_pdf;
        this.currentGUI = currentGUI;
        this.commonValues = commonValues;
        this.currentCommands = currentCommands;
    }

    public void updateRectangle() {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.decode_pdf.getDisplayView() == 1 && event.getButton() == 1 && this.decode_pdf.getExternalHandler(25) != null) {
            int[] pos = this.updateXY(event.getX(), event.getY());
            this.checkLinks(true, this.decode_pdf.getIO(), pos[0], pos[1]);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.previewTurnover && this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3 && event.getButton() == 1) {
            this.drawingTurnover = true;
            this.decode_pdf.setCursor(this.currentGUI.getCursor(2));
            this.lastPress = System.currentTimeMillis();
        }
        if (event.getButton() == 2) {
            this.middleDragStartX = (double)event.getX() - this.decode_pdf.getVisibleRect().getX();
            this.middleDragStartY = (double)event.getY() - this.decode_pdf.getVisibleRect().getY();
            this.decode_pdf.setCursor(this.currentGUI.getCursor(4));
            if (this.middleDragTimer == null) {
                this.middleDragTimer = new Timer(100, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Rectangle r = SwingMousePageTurn.this.decode_pdf.getVisibleRect();
                        r.translate((int)SwingMousePageTurn.this.xVelocity, (int)SwingMousePageTurn.this.yVelocity);
                        if (SwingMousePageTurn.this.xVelocity < -2.0) {
                            if (SwingMousePageTurn.this.yVelocity < -2.0) {
                                SwingMousePageTurn.this.decode_pdf.setCursor(SwingMousePageTurn.this.currentGUI.getCursor(6));
                            } else if (SwingMousePageTurn.this.yVelocity > 2.0) {
                                SwingMousePageTurn.this.decode_pdf.setCursor(SwingMousePageTurn.this.currentGUI.getCursor(12));
                            } else {
                                SwingMousePageTurn.this.decode_pdf.setCursor(SwingMousePageTurn.this.currentGUI.getCursor(5));
                            }
                        } else if (SwingMousePageTurn.this.xVelocity > 2.0) {
                            if (SwingMousePageTurn.this.yVelocity < -2.0) {
                                SwingMousePageTurn.this.decode_pdf.setCursor(SwingMousePageTurn.this.currentGUI.getCursor(8));
                            } else if (SwingMousePageTurn.this.yVelocity > 2.0) {
                                SwingMousePageTurn.this.decode_pdf.setCursor(SwingMousePageTurn.this.currentGUI.getCursor(10));
                            } else {
                                SwingMousePageTurn.this.decode_pdf.setCursor(SwingMousePageTurn.this.currentGUI.getCursor(9));
                            }
                        } else if (SwingMousePageTurn.this.yVelocity < -2.0) {
                            SwingMousePageTurn.this.decode_pdf.setCursor(SwingMousePageTurn.this.currentGUI.getCursor(7));
                        } else if (SwingMousePageTurn.this.yVelocity > 2.0) {
                            SwingMousePageTurn.this.decode_pdf.setCursor(SwingMousePageTurn.this.currentGUI.getCursor(11));
                        } else {
                            SwingMousePageTurn.this.decode_pdf.setCursor(SwingMousePageTurn.this.currentGUI.getCursor(4));
                        }
                        SwingMousePageTurn.this.decode_pdf.scrollRectToVisible(r);
                    }
                });
            }
            this.middleDragTimer.start();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3) {
            this.drawingTurnover = false;
            boolean dragLeft = this.currentGUI.getDragLeft();
            boolean dragTop = this.currentGUI.getDragTop();
            if (this.lastPress + 200L > System.currentTimeMillis()) {
                if (dragLeft) {
                    this.currentCommands.executeCommand(52, null);
                } else {
                    this.currentCommands.executeCommand(53, null);
                }
                this.previewTurnover = false;
                this.decode_pdf.setCursor(this.currentGUI.getCursor(3));
            } else {
                Point corner = new Point();
                corner.y = this.decode_pdf.getInsetH();
                if (!dragTop) {
                    corner.y = (int)((float)corner.y + (float)this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * this.decode_pdf.getScaling());
                }
                corner.x = dragLeft ? (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)((float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling())) : (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)((float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling()));
                this.testFall(corner, event.getPoint(), dragLeft);
            }
        }
        if (event.getButton() == 2) {
            this.xVelocity = 0.0;
            this.yVelocity = 0.0;
            this.decode_pdf.setCursor(this.currentGUI.getCursor(3));
            this.middleDragTimer.stop();
            this.decode_pdf.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (SwingUtilities.isLeftMouseButton(event)) {
            this.altIsDown = event.isAltDown();
            if (this.decode_pdf.getExternalHandler(25) != null) {
                int[] pos = this.updateXY(event.getX(), event.getY());
                this.checkLinks(true, this.decode_pdf.getIO(), pos[0], pos[1]);
            }
            if (this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && (this.drawingTurnover || this.previewTurnover) && this.decode_pdf.getDisplayView() == 3) {
                this.decode_pdf.setCursor(this.currentGUI.getCursor(2));
                if (this.currentGUI.getDragLeft()) {
                    if (this.currentGUI.getDragTop()) {
                        this.decode_pdf.setUserOffsets(event.getX(), event.getY(), 996);
                    } else {
                        this.decode_pdf.setUserOffsets(event.getX(), event.getY(), 998);
                    }
                } else if (this.currentGUI.getDragTop()) {
                    this.decode_pdf.setUserOffsets(event.getX(), event.getY(), 997);
                } else {
                    this.decode_pdf.setUserOffsets(event.getX(), event.getY(), 999);
                }
            }
        } else if (SwingUtilities.isMiddleMouseButton(event)) {
            this.xVelocity = ((double)event.getX() - this.decode_pdf.getVisibleRect().getX() - this.middleDragStartX) / 4.0;
            this.yVelocity = ((double)event.getY() - this.decode_pdf.getVisibleRect().getY() - this.middleDragStartY) / 4.0;
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.decode_pdf.getDisplayView() == 3 && this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && ((SwingGUI)this.decode_pdf.getExternalHandler(11)).getPageTurnScalingAppropriate() && !this.decode_pdf.getPdfPageData().hasMultipleSizes() && !this.pageTurnAnimating) {
            Point cursor;
            float pageH = (float)this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * this.decode_pdf.getScaling() - 1.0f;
            float pageW = (float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling() - 1.0f;
            if ((this.decode_pdf.getPdfPageData().getRotation(1) + this.currentGUI.getRotation()) % 180 == 90) {
                float temp = pageH;
                pageH = pageW + 1.0f;
                pageW = temp;
            }
            Point corner = new Point();
            if (this.commonValues.getCurrentPage() + 1 < this.commonValues.getPageCount()) {
                corner.x = (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)pageW);
                corner.y = (int)((float)this.decode_pdf.getInsetH() + pageH);
                cursor = event.getPoint();
                if (cursor.x > corner.x - 30 && cursor.x <= corner.x && (cursor.y > corner.y - 30 && cursor.y <= corner.y || (float)cursor.y >= (float)corner.y - pageH && (float)cursor.y < (float)corner.y - pageH + 30.0f)) {
                    this.decode_pdf.setCursor(this.currentGUI.getCursor(1));
                    this.previewTurnover = true;
                    if ((float)cursor.y >= (float)corner.y - pageH && (float)cursor.y < (float)corner.y - pageH + 30.0f) {
                        corner.y = (int)((float)corner.y - pageH);
                        this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 997);
                    } else {
                        this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 999);
                    }
                } else {
                    if (this.currentGUI.getDragTop()) {
                        corner.y = (int)((float)corner.y - pageH);
                    }
                    this.testFall(corner, cursor, false);
                }
            }
            if (this.commonValues.getCurrentPage() != 1) {
                corner.x = (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)pageW);
                corner.y = (int)((float)this.decode_pdf.getInsetH() + pageH);
                cursor = event.getPoint();
                if (cursor.x < corner.x + 30 && cursor.x >= corner.x && (cursor.y > corner.y - 30 && cursor.y <= corner.y || (float)cursor.y >= (float)corner.y - pageH && (float)cursor.y < (float)corner.y - pageH + 30.0f)) {
                    this.decode_pdf.setCursor(this.currentGUI.getCursor(1));
                    this.previewTurnover = true;
                    if ((float)cursor.y >= (float)corner.y - pageH && (float)cursor.y < (float)corner.y - pageH + 30.0f) {
                        corner.y = (int)((float)corner.y - pageH);
                        this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 996);
                    } else {
                        this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 998);
                    }
                } else {
                    if (this.currentGUI.getDragTop()) {
                        corner.y = (int)((float)corner.y - pageH);
                    }
                    this.testFall(corner, cursor, true);
                }
            }
        }
        if (this.currentGUI.useNewLayout) {
            int[] flag = new int[2];
            flag[0] = 1;
            if (this.decode_pdf.getDisplayView() == 1 || SwingMouseSelector.activateMultipageHighlight) {
                int rawH;
                int rawW;
                if (this.currentGUI.getRotation() % 180 == 90) {
                    rawW = this.decode_pdf.getPdfPageData().getCropBoxHeight(1);
                    rawH = this.decode_pdf.getPdfPageData().getCropBoxWidth(1);
                } else {
                    rawW = this.decode_pdf.getPdfPageData().getCropBoxWidth(1);
                    rawH = this.decode_pdf.getPdfPageData().getCropBoxHeight(1);
                }
                Point p = event.getPoint();
                int x = (int)p.getX();
                int y = (int)p.getY();
                float scaling = this.decode_pdf.getScaling();
                double pageHeight = scaling * (float)rawH;
                double pageWidth = scaling * (float)rawW;
                int yStart = this.decode_pdf.getInsetH();
                double left = (double)(this.decode_pdf.getWidth() / 2) - pageWidth / 2.0;
                flag[1] = (double)x >= left && (double)x <= left + pageWidth && y >= yStart && (double)y <= (double)yStart + pageHeight ? 1 : 0;
            } else {
                flag[1] = 0;
            }
            this.currentGUI.setMultibox(flag);
        }
        if (this.decode_pdf.getExternalHandler(25) != null) {
            int[] pos = this.updateXY(event.getX(), event.getY());
            this.checkLinks(false, this.decode_pdf.getIO(), pos[0], pos[1]);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this.decode_pdf.getDisplayView() == 5) {
            return;
        }
        if (this.currentGUI.getProperties().getValue("allowScrollwheelZoom").toLowerCase().equals("true") && event.isControlDown()) {
            int scaling;
            block18: {
                scaling = this.currentGUI.getSelectedComboIndex(252);
                if (scaling != -1) {
                    scaling = (int)this.decode_pdf.getDPIFactory().removeScaling(this.decode_pdf.getScaling() * 100.0f);
                } else {
                    String numberValue = (String)this.currentGUI.getSelectedComboItem(252);
                    try {
                        scaling = (int)Float.parseFloat(numberValue);
                    }
                    catch (Exception e) {
                        char c;
                        int ii;
                        scaling = -1;
                        int length = numberValue.length();
                        for (ii = 0; ii < length && ((c = numberValue.charAt(ii)) >= '0' && c <= '9') | c == '.'; ++ii) {
                        }
                        if (ii > 0) {
                            numberValue = numberValue.substring(0, ii);
                        }
                        if (scaling != -1) break block18;
                        try {
                            scaling = (int)Float.parseFloat(numberValue);
                        }
                        catch (Exception e1) {
                            scaling = -1;
                        }
                    }
                }
            }
            float value = event.getWheelRotation();
            if ((scaling != 1 || value < 0.0f) && !((float)scaling + (value = value < 0.0f ? 1.25f : 0.8f) < 0.0f)) {
                float currentScaling = (float)scaling * value;
                currentScaling = (int)currentScaling == scaling ? (float)(scaling + 1) : (float)((int)currentScaling);
                if (currentScaling < 1.0f) {
                    currentScaling = 1.0f;
                }
                if (currentScaling > 1000.0f) {
                    currentScaling = 1000.0f;
                }
                final Rectangle r = this.decode_pdf.getVisibleRect();
                final double x = (double)event.getX() / this.decode_pdf.getBounds().getWidth();
                final double y = (double)event.getY() / this.decode_pdf.getBounds().getHeight();
                this.currentGUI.snapScalingToDefaults(currentScaling);
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            SwingMousePageTurn.this.decode_pdf.scrollRectToVisible(new Rectangle((int)(x * (double)SwingMousePageTurn.this.decode_pdf.getWidth() - r.getWidth() / 2.0), (int)(y * (double)SwingMousePageTurn.this.decode_pdf.getHeight() - r.getHeight() / 2.0), (int)SwingMousePageTurn.this.decode_pdf.getVisibleRect().getWidth(), (int)SwingMousePageTurn.this.decode_pdf.getVisibleRect().getHeight()));
                            SwingMousePageTurn.this.decode_pdf.repaint();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                t.start();
                SwingUtilities.invokeLater(t);
            }
        } else {
            final JScrollBar scroll = ((JScrollPane)this.decode_pdf.getParent().getParent()).getVerticalScrollBar();
            if ((scroll.getValue() >= scroll.getMaximum() - scroll.getHeight() || scroll.getHeight() == 0) && event.getUnitsToScroll() > 0 && this.timeOfLastPageChange + 700L < System.currentTimeMillis() && this.currentGUI.getPageNumber() < this.decode_pdf.getPageCount()) {
                this.timeOfLastPageChange = System.currentTimeMillis();
                this.currentCommands.executeCommand(53, null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        scroll.setValue(scroll.getMinimum());
                    }
                });
            } else if (scroll.getValue() == scroll.getMinimum() && event.getUnitsToScroll() < 0 && this.timeOfLastPageChange + 700L < System.currentTimeMillis() && this.currentGUI.getPageNumber() > 1) {
                this.timeOfLastPageChange = System.currentTimeMillis();
                this.currentCommands.executeCommand(52, null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        scroll.setValue(scroll.getMaximum());
                    }
                });
            } else {
                Area rect = new Area(this.decode_pdf.getVisibleRect());
                AffineTransform transform = new AffineTransform();
                transform.translate(0.0, event.getUnitsToScroll() * this.decode_pdf.getScrollInterval());
                rect = rect.createTransformedArea(transform);
                this.decode_pdf.scrollRectToVisible(rect.getBounds());
            }
        }
    }

    public void checkLinks(boolean mouseClicked, PdfObjectReader pdfObjectReader, int x, int y) {
    }

    protected int[] updateXY(int originalX, int originalY) {
        float scaling = this.currentGUI.getScaling();
        int inset = GUI.getPDFDisplayInset();
        int rotation = this.currentGUI.getRotation();
        int x = (int)((float)(this.currentGUI.AdjustForAlignment(originalX) - inset) / scaling);
        int y = (int)((float)(originalY - inset) / scaling);
        if (this.commonValues.maxViewY != 0) {
            x = (int)((double)((float)x - (float)this.commonValues.dx * scaling) / this.commonValues.viewportScale);
            y = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)y / scaling - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)scaling);
        }
        int[] ret = new int[2];
        if (rotation == 90) {
            ret[1] = x + this.currentGUI.cropY;
            ret[0] = y + this.currentGUI.cropX;
        } else if (rotation == 180) {
            ret[0] = this.currentGUI.mediaW - (x + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
            ret[1] = y + this.currentGUI.cropY;
        } else if (rotation == 270) {
            ret[1] = this.currentGUI.mediaH - (x + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
            ret[0] = this.currentGUI.mediaW - (y + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
        } else {
            ret[0] = x + this.currentGUI.cropX;
            ret[1] = this.currentGUI.mediaH - (y + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
        }
        return ret;
    }

    public void testFall(final Point corner, final Point cursor, boolean testLeft) {
        if (!this.previewTurnover) {
            return;
        }
        float width = (float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling() - 1.0f;
        if ((this.decode_pdf.getPdfPageData().getRotation(1) + this.currentGUI.getRotation()) % 180 == 90) {
            width = (float)this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * this.decode_pdf.getScaling();
        }
        final float pageW = width;
        if (!testLeft) {
            if (!this.currentGUI.getDragLeft()) {
                this.decode_pdf.setCursor(Cursor.getDefaultCursor());
                Thread animation = new Thread(){

                    @Override
                    public void run() {
                        corner.x = (int)(SwingMousePageTurn.this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)pageW);
                        boolean fallBack = true;
                        if ((float)cursor.x < (float)corner.x - pageW) {
                            corner.x = (int)((float)corner.x - 2.0f * pageW);
                            fallBack = false;
                        }
                        int velocity = 1;
                        if (fallBack && cursor.x >= corner.x) {
                            cursor.x = corner.x - 1;
                        }
                        if (!fallBack && cursor.x <= corner.x) {
                            cursor.x = corner.x + 1;
                        }
                        if (!SwingMousePageTurn.this.currentGUI.getDragTop() && cursor.y >= corner.y) {
                            cursor.y = corner.y - 1;
                        }
                        if (SwingMousePageTurn.this.currentGUI.getDragTop() && cursor.y <= corner.y) {
                            cursor.y = corner.y + 1;
                        }
                        double distX = corner.x - cursor.x;
                        double distY = corner.y - cursor.y;
                        while (fallBack && cursor.getX() <= corner.getX() || !fallBack && cursor.getX() >= corner.getX() || !SwingMousePageTurn.this.currentGUI.getDragTop() && cursor.getY() <= corner.getY() || SwingMousePageTurn.this.currentGUI.getDragTop() && cursor.getY() >= corner.getY()) {
                            double xMove = (double)velocity * distX * 0.002;
                            double yMove = (double)velocity * distY * 0.002;
                            if (Math.abs(xMove) < 1.0) {
                                xMove /= Math.abs(xMove);
                            }
                            if (Math.abs(yMove) < 1.0) {
                                yMove /= Math.abs(yMove);
                            }
                            cursor.setLocation(cursor.getX() + xMove, cursor.getY() + yMove);
                            if (SwingMousePageTurn.this.currentGUI.getDragTop()) {
                                SwingMousePageTurn.this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 997);
                            } else {
                                SwingMousePageTurn.this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 999);
                            }
                            if (velocity < 32) {
                                velocity *= 2;
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (!fallBack) {
                            int forwardPage = SwingMousePageTurn.this.commonValues.getCurrentPage() + 1;
                            if (SwingMousePageTurn.this.currentCommands.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && forwardPage % 2 == 1) {
                                ++forwardPage;
                            } else if (!SwingMousePageTurn.this.currentCommands.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && forwardPage % 2 == 0) {
                                ++forwardPage;
                            }
                            SwingMousePageTurn.this.commonValues.setCurrentPage(forwardPage);
                            SwingMousePageTurn.this.currentGUI.setPageNumber();
                            SwingMousePageTurn.this.decode_pdf.setPageParameters(SwingMousePageTurn.this.currentGUI.getScaling(), SwingMousePageTurn.this.commonValues.getCurrentPage());
                            SwingMousePageTurn.this.currentGUI.decodePage(false);
                        }
                        SwingMousePageTurn.this.decode_pdf.setUserOffsets(0, 0, 995);
                        SwingMousePageTurn.this.setPageTurnAnimating(false);
                    }
                };
                this.setPageTurnAnimating(true);
                animation.start();
                this.previewTurnover = false;
            }
        } else if (this.previewTurnover && this.currentGUI.getDragLeft()) {
            this.decode_pdf.setCursor(Cursor.getDefaultCursor());
            Thread animation = new Thread(){

                @Override
                public void run() {
                    corner.x = (int)(SwingMousePageTurn.this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)pageW);
                    boolean fallBack = true;
                    if ((float)cursor.x > (float)corner.x + pageW) {
                        corner.x = (int)((float)corner.x + 2.0f * pageW);
                        fallBack = false;
                    }
                    int velocity = 1;
                    if (!fallBack && cursor.x >= corner.x) {
                        cursor.x = corner.x - 1;
                    }
                    if (fallBack && cursor.x <= corner.x) {
                        cursor.x = corner.x + 1;
                    }
                    if (!SwingMousePageTurn.this.currentGUI.getDragTop() && cursor.y >= corner.y) {
                        cursor.y = corner.y - 1;
                    }
                    if (SwingMousePageTurn.this.currentGUI.getDragTop() && cursor.y <= corner.y) {
                        cursor.y = corner.y + 1;
                    }
                    double distX = corner.x - cursor.x;
                    double distY = corner.y - cursor.y;
                    while (!fallBack && cursor.getX() <= corner.getX() || fallBack && cursor.getX() >= corner.getX() || !SwingMousePageTurn.this.currentGUI.getDragTop() && cursor.getY() <= corner.getY() || SwingMousePageTurn.this.currentGUI.getDragTop() && cursor.getY() >= corner.getY()) {
                        double xMove = (double)velocity * distX * 0.002;
                        double yMove = (double)velocity * distY * 0.002;
                        if (Math.abs(xMove) < 1.0) {
                            xMove /= Math.abs(xMove);
                        }
                        if (Math.abs(yMove) < 1.0) {
                            yMove /= Math.abs(yMove);
                        }
                        cursor.setLocation(cursor.getX() + xMove, cursor.getY() + yMove);
                        if (SwingMousePageTurn.this.currentGUI.getDragTop()) {
                            SwingMousePageTurn.this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 996);
                        } else {
                            SwingMousePageTurn.this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 998);
                        }
                        if (velocity < 32) {
                            velocity *= 2;
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!fallBack) {
                        int backPage = SwingMousePageTurn.this.commonValues.getCurrentPage() - 2;
                        if (backPage == 0) {
                            backPage = 1;
                        }
                        SwingMousePageTurn.this.commonValues.setCurrentPage(backPage);
                        SwingMousePageTurn.this.currentGUI.setPageNumber();
                        SwingMousePageTurn.this.decode_pdf.setPageParameters(SwingMousePageTurn.this.currentGUI.getScaling(), SwingMousePageTurn.this.commonValues.getCurrentPage());
                        SwingMousePageTurn.this.currentGUI.decodePage(false);
                    }
                    SwingMousePageTurn.this.decode_pdf.setUserOffsets(0, 0, 995);
                    SwingMousePageTurn.this.setPageTurnAnimating(false);
                }
            };
            this.setPageTurnAnimating(true);
            animation.start();
            this.previewTurnover = false;
        }
    }

    public void setPageTurnAnimating(boolean a) {
        this.pageTurnAnimating = a;
        if (a) {
            this.currentGUI.forward.setEnabled(false);
            this.currentGUI.back.setEnabled(false);
            this.currentGUI.fforward.setEnabled(false);
            this.currentGUI.fback.setEnabled(false);
            this.currentGUI.end.setEnabled(false);
            this.currentGUI.first.setEnabled(false);
        } else {
            this.currentGUI.hideRedundentNavButtons();
        }
    }

    public boolean getPageTurnAnimating() {
        return this.pageTurnAnimating;
    }
}

