/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jpedal.Display;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.MouseMode;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.generic.GUIMouseHandler;
import org.jpedal.examples.viewer.gui.swing.SwingMouseFunctionality;
import org.jpedal.examples.viewer.gui.swing.SwingMousePageTurn;
import org.jpedal.examples.viewer.gui.swing.SwingMousePanMode;
import org.jpedal.examples.viewer.gui.swing.SwingMouseSelector;
import org.jpedal.io.PdfObjectReader;

public class SwingMouseListener
implements GUIMouseHandler,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private PdfDecoder decode_pdf;
    private SwingGUI currentGUI;
    private Values commonValues;
    private Commands currentCommands;
    SwingMouseSelector selectionFunctions;
    SwingMousePanMode panningFunctions;
    SwingMousePageTurn pageTurnFunctions;
    private static SwingMouseFunctionality customMouseFunctions;
    private boolean scrollPageChanging = false;
    private int cx;
    private int cy;
    private String message = "";
    private MouseMode mouseMode = new MouseMode();
    private AutoScrollThread scrollThread = new AutoScrollThread();
    private double middleDragStartX;
    private double middleDragStartY;
    private double xVelocity;
    private double yVelocity;
    private Timer middleDragTimer;
    int scrollToPage = -1;

    public SwingMouseListener(PdfDecoder decode_pdf, SwingGUI currentGUI, Values commonValues, Commands currentCommands) {
        this.decode_pdf = decode_pdf;
        this.currentGUI = currentGUI;
        this.commonValues = commonValues;
        this.currentCommands = currentCommands;
        this.mouseMode = currentCommands.getMouseMode();
        this.selectionFunctions = new SwingMouseSelector(decode_pdf, currentGUI, commonValues, currentCommands);
        this.panningFunctions = new SwingMousePanMode(decode_pdf);
        this.pageTurnFunctions = new SwingMousePageTurn(decode_pdf, currentGUI, commonValues, currentCommands);
        if (SwingUtilities.isEventDispatchThread()) {
            this.scrollThread.init();
        } else {
            Runnable doPaintComponent = new Runnable(){

                @Override
                public void run() {
                    SwingMouseListener.this.scrollThread.init();
                }
            };
            SwingUtilities.invokeLater(doPaintComponent);
        }
        decode_pdf.addExternalHandler(this, 10);
    }

    @Override
    public void setupExtractor() {
        System.out.println("Set up extractor called");
        this.decode_pdf.addMouseMotionListener(this);
        this.decode_pdf.addMouseListener(this);
    }

    @Override
    public void setupMouse() {
        this.decode_pdf.addMouseMotionListener(this);
        this.decode_pdf.addMouseListener(this);
        this.decode_pdf.addMouseWheelListener(this);
        this.decode_pdf.setDefaultCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void updateRectangle() {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.updateRectangle();
                break;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseClicked(e);
                break;
            }
        }
        if (this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseClicked(e);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseClicked(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                break;
            }
        }
        if (this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseEntered(e);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseEntered(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        int[] flag = new int[]{1, 0};
        this.currentGUI.setMultibox(flag);
        this.scrollThread.setAutoScroll(false, 0, 0, 0);
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseExited(e);
                break;
            }
        }
        if (this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseExited(e);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseExited(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mousePressed(e);
                break;
            }
            case 1: {
                this.panningFunctions.mousePressed(e);
            }
        }
        if (e.getButton() == 2) {
            this.middleDragStartX = (double)e.getX() - this.decode_pdf.getVisibleRect().getX();
            this.middleDragStartY = (double)e.getY() - this.decode_pdf.getVisibleRect().getY();
            this.decode_pdf.setCursor(this.currentGUI.getCursor(4));
            if (this.middleDragTimer == null) {
                this.middleDragTimer = new Timer(100, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Rectangle r = SwingMouseListener.this.decode_pdf.getVisibleRect();
                        r.translate((int)SwingMouseListener.this.xVelocity, (int)SwingMouseListener.this.yVelocity);
                        if (SwingMouseListener.this.xVelocity < -2.0) {
                            if (SwingMouseListener.this.yVelocity < -2.0) {
                                SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(6));
                            } else if (SwingMouseListener.this.yVelocity > 2.0) {
                                SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(12));
                            } else {
                                SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(5));
                            }
                        } else if (SwingMouseListener.this.xVelocity > 2.0) {
                            if (SwingMouseListener.this.yVelocity < -2.0) {
                                SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(8));
                            } else if (SwingMouseListener.this.yVelocity > 2.0) {
                                SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(10));
                            } else {
                                SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(9));
                            }
                        } else if (SwingMouseListener.this.yVelocity < -2.0) {
                            SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(7));
                        } else if (SwingMouseListener.this.yVelocity > 2.0) {
                            SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(11));
                        } else {
                            SwingMouseListener.this.decode_pdf.setCursor(SwingMouseListener.this.currentGUI.getCursor(4));
                        }
                        SwingMouseListener.this.decode_pdf.scrollRectToVisible(r);
                    }
                });
            }
            this.middleDragTimer.start();
        }
        if (!SwingUtilities.isMiddleMouseButton(e) && this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mousePressed(e);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseReleased(e);
                break;
            }
            case 1: {
                this.panningFunctions.mouseReleased(e);
            }
        }
        if (e.getButton() == 2) {
            this.xVelocity = 0.0;
            this.yVelocity = 0.0;
            this.decode_pdf.setCursor(this.currentGUI.getCursor(3));
            this.middleDragTimer.stop();
            this.decode_pdf.repaint();
        }
        if (!SwingUtilities.isMiddleMouseButton(e) && this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseReleased(e);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseReleased(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.scrollAndUpdateCoords(e);
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseDragged(e);
                break;
            }
            case 1: {
                this.panningFunctions.mouseDragged(e);
            }
        }
        if (SwingUtilities.isMiddleMouseButton(e)) {
            this.xVelocity = ((double)e.getX() - this.decode_pdf.getVisibleRect().getX() - this.middleDragStartX) / 4.0;
            this.yVelocity = ((double)e.getY() - this.decode_pdf.getVisibleRect().getY() - this.middleDragStartY) / 4.0;
        }
        if (!SwingUtilities.isMiddleMouseButton(e) && this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseDragged(e);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseDragged(e);
        }
    }

    public static void setCustomMouseFunctions(SwingMouseFunctionality cmf) {
        customMouseFunctions = cmf;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int page = this.commonValues.getCurrentPage();
        Point p = this.selectionFunctions.getCoordsOnPage(e.getX(), e.getY(), page);
        int x = (int)p.getX();
        int y = (int)p.getY();
        this.updateCoords(x, y, e.isShiftDown());
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                int[] values = this.selectionFunctions.updateXY(e.getX(), e.getY());
                x = values[0];
                y = values[1];
                if (!this.currentCommands.extractingAsImage) {
                    this.getObjectUnderneath(x, y);
                }
                this.selectionFunctions.mouseMoved(e);
                break;
            }
        }
        if (this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 3) {
            this.pageTurnFunctions.mouseMoved(e);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseMoved(e);
        }
    }

    private void getObjectUnderneath(int x, int y) {
        if (this.decode_pdf.getDisplayView() == 1) {
            int type = this.decode_pdf.getDynamicRenderer().getObjectUnderneath(x, y);
            switch (type) {
                case -1: {
                    this.decode_pdf.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 1: {
                    this.decode_pdf.setCursor(Cursor.getPredefinedCursor(2));
                    break;
                }
                case 3: {
                    this.decode_pdf.setCursor(Cursor.getPredefinedCursor(1));
                    break;
                }
                case 4: {
                    this.decode_pdf.setCursor(Cursor.getPredefinedCursor(2));
                    break;
                }
                case 5: {
                    this.decode_pdf.setCursor(Cursor.getPredefinedCursor(2));
                    break;
                }
                case 6: {
                    this.decode_pdf.setCursor(Cursor.getPredefinedCursor(2));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        switch (this.decode_pdf.getDisplayView()) {
            case 5: {
                break;
            }
            case 3: {
                if (!this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON)) break;
                this.pageTurnFunctions.mouseWheelMoved(event);
                break;
            }
            case 1: {
                if (!this.currentGUI.getProperties().getValue("allowScrollwheelZoom").toLowerCase().equals("true") || !event.isMetaDown() && !event.isControlDown()) ** GOTO lbl47
                scaling = this.currentGUI.getSelectedComboIndex(252);
                if (scaling == -1) ** GOTO lbl14
                scaling = (int)this.decode_pdf.getDPIFactory().removeScaling(this.decode_pdf.getScaling() * 100.0f);
                ** GOTO lbl31
lbl14:
                // 1 sources

                numberValue = (String)this.currentGUI.getSelectedComboItem(252);
                try {
                    scaling = (int)Float.parseFloat(numberValue);
                }
                catch (Exception e) {
                    scaling = -1;
                    length = numberValue.length();
                    for (ii = 0; ii < length && ((c = numberValue.charAt(ii)) >= '0' && c <= '9') | c == '.'; ++ii) {
                    }
                    if (ii > 0) {
                        numberValue = numberValue.substring(0, ii);
                    }
                    if (scaling != -1) ** GOTO lbl31
                    try {
                        scaling = (int)Float.parseFloat(numberValue);
                    }
                    catch (Exception e1) {
                        scaling = -1;
                    }
                }
lbl31:
                // 5 sources

                value = event.getWheelRotation();
                if ((scaling != 1 || value < 0.0f) && !((float)scaling + (value = value < 0.0f ? 1.25f : 0.8f) < 0.0f)) {
                    currentScaling = (float)scaling * value;
                    currentScaling = (int)currentScaling == scaling ? (float)(scaling + 1) : (float)((int)currentScaling);
                    if (currentScaling < 1.0f) {
                        currentScaling = 1.0f;
                    }
                    if (currentScaling > 1000.0f) {
                        currentScaling = 1000.0f;
                    }
                    r = this.decode_pdf.getVisibleRect();
                    x = (double)event.getX() / this.decode_pdf.getBounds().getWidth();
                    y = (double)event.getY() / this.decode_pdf.getBounds().getHeight();
                    this.currentGUI.snapScalingToDefaults(currentScaling);
                    t = new Thread(){

                        @Override
                        public void run() {
                            try {
                                SwingMouseListener.this.decode_pdf.scrollRectToVisible(new Rectangle((int)(x * (double)SwingMouseListener.this.decode_pdf.getWidth() - r.getWidth() / 2.0), (int)(y * (double)SwingMouseListener.this.decode_pdf.getHeight() - r.getHeight() / 2.0), (int)SwingMouseListener.this.decode_pdf.getVisibleRect().getWidth(), (int)SwingMouseListener.this.decode_pdf.getVisibleRect().getHeight()));
                                SwingMouseListener.this.decode_pdf.repaint();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    t.start();
                    SwingUtilities.invokeLater(t);
                }
                ** GOTO lbl80
lbl47:
                // 1 sources

                scroll = this.currentGUI.getVerticalScrollBar();
                this.scrollToPage = scroll.getValue();
                if (scroll.getValue() < scroll.getMaximum() - scroll.getHeight() && scroll.getHeight() != 0 || event.getUnitsToScroll() <= 0 || this.scrollToPage > this.decode_pdf.getPageCount()) ** GOTO lbl65
                if (this.scrollPageChanging) {
                    return;
                }
                this.scrollPageChanging = true;
                if (this.scrollToPage < this.decode_pdf.getPageCount()) {
                    ++this.scrollToPage;
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    scroll.setValue(this.scrollToPage);
                } else {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                scroll.setValue(SwingMouseListener.this.scrollToPage);
                            }
                        });
                    }
                    catch (Exception e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                scroll.setValue(SwingMouseListener.this.scrollToPage);
                            }
                        });
                    }
                }
                this.scrollPageChanging = false;
                ** GOTO lbl80
lbl65:
                // 1 sources

                if (scroll.getValue() >= scroll.getMinimum() && event.getUnitsToScroll() < 0 && this.scrollToPage >= 1) {
                    if (this.scrollPageChanging) {
                        return;
                    }
                    this.scrollPageChanging = true;
                    if (this.scrollToPage >= 1) {
                        --this.scrollToPage;
                    }
                    if (SwingUtilities.isEventDispatchThread()) {
                        scroll.setValue(this.scrollToPage);
                    } else {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    scroll.setValue(SwingMouseListener.this.scrollToPage);
                                }
                            });
                        }
                        catch (Exception e) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    scroll.setValue(SwingMouseListener.this.scrollToPage);
                                }
                            });
                        }
                    }
                    this.scrollPageChanging = false;
                }
            }
lbl80:
            // 6 sources

            default: {
                rect = new Area(this.decode_pdf.getVisibleRect());
                transform = new AffineTransform();
                transform.translate(0.0, event.getUnitsToScroll() * this.decode_pdf.getScrollInterval());
                rect = rect.createTransformedArea(transform);
                this.decode_pdf.scrollRectToVisible(rect.getBounds());
            }
        }
    }

    protected void scrollAndUpdateCoords(MouseEvent event) {
        int interval = this.decode_pdf.getScrollInterval();
        Rectangle visible_test = new Rectangle(this.currentGUI.AdjustForAlignment(event.getX()), event.getY(), interval, interval);
        if (this.currentGUI.allowScrolling() && !this.decode_pdf.getVisibleRect().contains(visible_test)) {
            this.decode_pdf.scrollRectToVisible(visible_test);
        }
        int page = this.commonValues.getCurrentPage();
        Point p = this.selectionFunctions.getCoordsOnPage(event.getX(), event.getY(), page);
        int x = (int)p.getX();
        int y = (int)p.getY();
        this.updateCoords(x, y, event.isShiftDown());
    }

    public void updateCoords(int x, int y, boolean isShiftDown) {
        this.cx = x;
        this.cy = y;
        if (this.decode_pdf.getDisplayView() != 1) {
            if (SwingMouseSelector.activateMultipageHighlight) {
                if (this.decode_pdf.getDisplayView() == 3) {
                    this.cx = 0;
                    this.cy = 0;
                }
            } else {
                this.cx = 0;
                this.cy = 0;
            }
        }
        if (Values.isProcessing() | this.commonValues.getSelectedFile() == null) {
            this.currentGUI.setCoordText("  X:  Y:   ");
        } else {
            this.currentGUI.setCoordText("  X: " + this.cx + " Y: " + this.cy + ' ' + ' ' + this.message);
        }
    }

    public int[] getCursorLocation() {
        return new int[]{this.cx, this.cy};
    }

    public void checkLinks(boolean mouseClicked, PdfObjectReader pdfObjectReader) {
        this.pageTurnFunctions.checkLinks(mouseClicked, pdfObjectReader, this.cx, this.cy);
    }

    public void updateCordsFromFormComponent(MouseEvent e) {
        JComponent component = (JComponent)e.getSource();
        int x = component.getX() + e.getX();
        int y = component.getY() + e.getY();
        Point p = this.selectionFunctions.getCoordsOnPage(x, y, this.commonValues.getCurrentPage());
        x = (int)p.getX();
        y = (int)p.getY();
        this.updateCoords(x, y, e.isShiftDown());
    }

    public boolean getPageTurnAnimating() {
        return this.pageTurnFunctions.getPageTurnAnimating();
    }

    public void setPageTurnAnimating(boolean a) {
        this.pageTurnFunctions.setPageTurnAnimating(a);
    }

    class AutoScrollThread
    implements Runnable {
        Thread scroll = new Thread(this);
        boolean autoScroll = false;
        int x = 0;
        int y = 0;
        int interval = 0;
        int usedX;
        int usedY;

        public void setAutoScroll(boolean autoScroll, int x, int y, int interval) {
            this.autoScroll = autoScroll;
            this.x = SwingMouseListener.this.currentGUI.AdjustForAlignment(x);
            this.y = y;
            this.interval = interval;
        }

        public void init() {
            this.scroll.start();
        }

        @Override
        public void run() {
            while (Thread.currentThread().equals(this.scroll)) {
                if (this.autoScroll) {
                    final Rectangle visible_test = new Rectangle(this.x - this.interval, this.y - this.interval, this.interval * 2, this.interval * 2);
                    Rectangle currentScreen = SwingMouseListener.this.decode_pdf.getVisibleRect();
                    if (!currentScreen.contains(visible_test)) {
                        if (SwingUtilities.isEventDispatchThread()) {
                            SwingMouseListener.this.decode_pdf.scrollRectToVisible(visible_test);
                        } else {
                            Runnable doPaintComponent = new Runnable(){

                                @Override
                                public void run() {
                                    SwingMouseListener.this.decode_pdf.scrollRectToVisible(visible_test);
                                }
                            };
                            SwingUtilities.invokeLater(doPaintComponent);
                        }
                        if (this.x - this.interval * 2 < ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().x) {
                            this.x -= this.interval;
                        } else if (this.x + this.interval * 2 > ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().x + ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().width) {
                            this.x += this.interval;
                        }
                        if (this.y - this.interval * 2 < ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().y) {
                            this.y -= this.interval;
                        } else if (this.y + this.interval * 2 > ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().y + ((SwingMouseListener)SwingMouseListener.this).decode_pdf.getVisibleRect().height) {
                            this.y += this.interval;
                        }
                    }
                    this.usedX = this.x;
                    this.usedY = this.y;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

