/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.gui.popups.WizardPanelModel;
import org.jpedal.examples.viewer.objects.SignData;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class SignWizardModel
implements WizardPanelModel {
    private static final String MODE_SELECT = "0";
    private static final String PFX_PANEL = "1";
    private static final String KEYSTORE_PANEL = "3";
    private static final String COMMON_PANEL = "4";
    private static final String ENCRYPTION_PANEL = "5";
    private static final String VISIBLE_SIGNATURE_PANEL = "6";
    public static final String NO_FILE_SELECTED = Messages.getMessage("PdfSigner.NoFileSelected");
    private static final int MAXIMUM_PANELS = 5;
    private SignData signData;
    private PdfDecoder pdfDecoder;
    private String rootDir;
    private ModeSelect modeSelect;
    private PFXPanel pFXPanel;
    private KeystorePanel keystorePanel;
    private CommonPanel commonPanel;
    private EncryptionPanel encryptionPanel;
    private SignaturePanel signaturePanel;
    private Map panels;
    private String currentPanel;

    public SignWizardModel(SignData signData, String pdfFile, String rootDir) {
        String password;
        this.signData = signData;
        this.rootDir = rootDir;
        this.pdfDecoder = new PdfDecoder();
        try {
            this.pdfDecoder.openPdfFile(pdfFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.pdfDecoder.isEncrypted() && (password = System.getProperty("org.jpedal.password")) != null) {
            try {
                this.pdfDecoder.setEncryptionPassword(password);
            }
            catch (PdfException e) {
                e.printStackTrace();
            }
        }
        this.testForSignedPDF();
        this.panels = new HashMap();
        this.modeSelect = new ModeSelect();
        this.pFXPanel = new PFXPanel();
        this.keystorePanel = new KeystorePanel();
        this.commonPanel = new CommonPanel();
        this.encryptionPanel = new EncryptionPanel();
        this.signaturePanel = new SignaturePanel();
        this.panels.put(MODE_SELECT, this.modeSelect);
        this.panels.put(PFX_PANEL, this.pFXPanel);
        this.panels.put(KEYSTORE_PANEL, this.keystorePanel);
        this.panels.put(COMMON_PANEL, this.commonPanel);
        this.panels.put(ENCRYPTION_PANEL, this.encryptionPanel);
        this.panels.put(VISIBLE_SIGNATURE_PANEL, this.signaturePanel);
        this.currentPanel = MODE_SELECT;
    }

    @Override
    public Map getJPanels() {
        return this.panels;
    }

    @Override
    public String next() {
        this.updateSignData();
        if (this.currentPanel.equals(MODE_SELECT)) {
            if (!this.signData.isKeystoreSign()) {
                this.currentPanel = PFX_PANEL;
                return PFX_PANEL;
            }
            this.currentPanel = KEYSTORE_PANEL;
            return KEYSTORE_PANEL;
        }
        if (this.currentPanel.equals(PFX_PANEL)) {
            this.currentPanel = VISIBLE_SIGNATURE_PANEL;
            return VISIBLE_SIGNATURE_PANEL;
        }
        if (this.currentPanel.equals(KEYSTORE_PANEL)) {
            this.currentPanel = VISIBLE_SIGNATURE_PANEL;
            return VISIBLE_SIGNATURE_PANEL;
        }
        if (this.currentPanel.equals(VISIBLE_SIGNATURE_PANEL)) {
            this.currentPanel = ENCRYPTION_PANEL;
            return ENCRYPTION_PANEL;
        }
        if (this.currentPanel.equals(ENCRYPTION_PANEL)) {
            this.currentPanel = COMMON_PANEL;
            return COMMON_PANEL;
        }
        throw new NullPointerException("Whoops! Tried to move to a nextID where there is no nextID to be had");
    }

    @Override
    public String previous() {
        this.updateSignData();
        if (this.currentPanel.equals(PFX_PANEL) || this.currentPanel.equals(KEYSTORE_PANEL)) {
            this.currentPanel = MODE_SELECT;
            return MODE_SELECT;
        }
        if (this.currentPanel.equals(ENCRYPTION_PANEL)) {
            this.currentPanel = VISIBLE_SIGNATURE_PANEL;
            return VISIBLE_SIGNATURE_PANEL;
        }
        if (this.currentPanel.equals(VISIBLE_SIGNATURE_PANEL)) {
            if (this.signData.isKeystoreSign()) {
                this.currentPanel = KEYSTORE_PANEL;
                return KEYSTORE_PANEL;
            }
            this.currentPanel = PFX_PANEL;
            return PFX_PANEL;
        }
        if (this.currentPanel.equals(COMMON_PANEL)) {
            this.currentPanel = ENCRYPTION_PANEL;
            return ENCRYPTION_PANEL;
        }
        throw new NullPointerException("Tried to move to get a previousID where there is no previous");
    }

    @Override
    public boolean hasPrevious() {
        return !this.currentPanel.equals(MODE_SELECT);
    }

    @Override
    public String getStartPanelID() {
        return MODE_SELECT;
    }

    @Override
    public boolean isFinishPanel() {
        return this.currentPanel == COMMON_PANEL;
    }

    @Override
    public boolean canAdvance() {
        if (this.currentPanel.equals(COMMON_PANEL)) {
            return this.commonPanel.canFinish();
        }
        if (this.currentPanel.equals(PFX_PANEL)) {
            return this.pFXPanel.canAdvance();
        }
        if (this.currentPanel.equals(KEYSTORE_PANEL)) {
            return this.keystorePanel.canAdvance();
        }
        if (this.currentPanel.equals(ENCRYPTION_PANEL)) {
            return this.encryptionPanel.canAdvance();
        }
        return true;
    }

    public void updateSignData() {
        if (this.currentPanel.equals(PFX_PANEL)) {
            this.pFXPanel.collectData();
        } else if (this.currentPanel.equals(KEYSTORE_PANEL)) {
            this.keystorePanel.collectData();
        } else if (this.currentPanel.equals(COMMON_PANEL)) {
            this.commonPanel.collectData();
        } else if (this.currentPanel.equals(ENCRYPTION_PANEL)) {
            this.encryptionPanel.collectData();
        } else if (this.currentPanel.equals(MODE_SELECT)) {
            this.modeSelect.collectData();
        } else if (this.currentPanel.equals(VISIBLE_SIGNATURE_PANEL)) {
            this.signaturePanel.collectData();
        } else {
            throw new NullPointerException("Tried to update a panel which doesnt exist");
        }
    }

    @Override
    public void registerNextChangeListeners(ChangeListener wizard) {
        this.commonPanel.registerChange(wizard);
        this.pFXPanel.registerChange(wizard);
        this.keystorePanel.registerChange(wizard);
        this.encryptionPanel.registerChange(wizard);
    }

    @Override
    public void registerNextKeyListeners(KeyListener wizard) {
        this.pFXPanel.registerListener(wizard);
        this.keystorePanel.registerNextKeyListeners(wizard);
        this.encryptionPanel.registerNextKeyListeners(wizard);
    }

    @Override
    public void close() {
        this.updateSignData();
        this.pdfDecoder.closePdfFile();
    }

    private void testForSignedPDF() {
        this.signData.setAppend(false);
        for (int page = 1; page <= this.pdfDecoder.getPageCount(); ++page) {
            try {
                this.pdfDecoder.decodePage(page);
                this.pdfDecoder.waitForDecodingToFinish();
                AcroRenderer currentFormRenderer = this.pdfDecoder.getFormRenderer();
                Iterator signatureObjects = currentFormRenderer.getSignatureObjects();
                if (signatureObjects == null) continue;
                this.signData.setAppend(true);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isPdfSigned() {
        return this.signData.isAppendMode();
    }

    private static class TitlePanel
    extends JPanel {
        private static final long serialVersionUID = 4046138883517734293L;

        public TitlePanel(String title) {
            this.setBackground(Color.gray);
            this.setBorder(BorderFactory.createEtchedBorder(0));
            JLabel textLabel = new JLabel();
            textLabel.setBackground(Color.gray);
            textLabel.setFont(new Font("Dialog", 1, 14));
            textLabel.setText(title);
            textLabel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
            textLabel.setOpaque(true);
            this.add(textLabel);
        }
    }

    private static class ProgressPanel
    extends JPanel {
        private static final long serialVersionUID = 8032594741795633401L;

        public ProgressPanel(int current) {
            this.setBorder(new EtchedBorder());
            JLabel progressLabel = new JLabel("Step " + current + " of " + 5);
            progressLabel.setAlignmentX(1.0f);
            this.add(progressLabel);
        }
    }

    private class SignaturePanel
    extends JPanel {
        private static final long serialVersionUID = 6938983094179969472L;
        private JCheckBox visibleCheck;
        private JComponent sigPreviewComp;
        private JSlider pageSlider;
        private JLabel pageNumberLabel;
        private int currentPage;
        private Point signRectOrigin;
        private Point signRectEnd;
        private int offsetX;
        private int offsetY;
        private float scale;
        private int previewWidth;
        private int previewHeight;
        private volatile boolean drawRect;
        private boolean signAreaUndefined;
        private BufferedImage previewImage;

        public SignaturePanel() {
            block2: {
                this.visibleCheck = new JCheckBox(Messages.getMessage("PdfSigner.VisibleSignature"));
                this.currentPage = 1;
                this.drawRect = false;
                this.signAreaUndefined = true;
                try {
                    this.previewImage = SignWizardModel.this.pdfDecoder.getPageAsImage(this.currentPage);
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block2;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            int y = 0;
            this.setLayout(new BorderLayout());
            this.add((Component)new TitlePanel(Messages.getMessage("PdfSigner.VisibleSignature") + ' ' + Messages.getMessage("PdfViewerMenu.options")), "North");
            JPanel optionPanel = new JPanel();
            optionPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.insets = new Insets(5, 0, 0, 0);
            c.fill = 2;
            c.anchor = 19;
            this.visibleCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SignaturePanel.this.sigPreviewComp.repaint();
                    if (SignWizardModel.this.pdfDecoder.getPageCount() > 1) {
                        SignaturePanel.this.pageSlider.setEnabled(SignaturePanel.this.visibleCheck.isSelected());
                    }
                }
            });
            optionPanel.add((Component)this.visibleCheck, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.fill = 2;
            c.insets = new Insets(10, 0, 10, 0);
            optionPanel.add((Component)new JSeparator(0), c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y;
            c.fill = 2;
            optionPanel.add((Component)this.previewPanel(), c);
            this.add((Component)optionPanel, "Center");
            this.add((Component)new ProgressPanel(3), "South");
        }

        public void collectData() {
            SignWizardModel.this.signData.setVisibleSignature(this.visibleCheck.isSelected());
            if (this.visibleCheck.isSelected()) {
                int height = this.previewImage.getHeight();
                int x1 = (int)((this.signRectOrigin.getX() - (double)this.offsetX) / (double)this.scale);
                int y1 = (int)((double)height - (this.signRectOrigin.getY() - (double)this.offsetY) / (double)this.scale);
                int x2 = (int)((this.signRectEnd.getX() - (double)this.offsetX) / (double)this.scale);
                int y2 = (int)((double)height - (this.signRectEnd.getY() - (double)this.offsetY) / (double)this.scale);
                PdfPageData pageData = SignWizardModel.this.pdfDecoder.getPdfPageData();
                int cropX = pageData.getCropBoxX(this.currentPage);
                int cropY = pageData.getCropBoxY(this.currentPage);
                SignWizardModel.this.signData.setRectangle(x1 += cropX, y1 += cropY, x2 += cropX, y2 += cropY);
                SignWizardModel.this.signData.setSignPage(this.currentPage);
            }
        }

        private JPanel previewPanel() {
            JPanel result = new JPanel(new BorderLayout());
            this.sigPreviewComp = new JComponent(){
                private static final long serialVersionUID = 3489687587790924068L;

                @Override
                public void paintComponent(Graphics g) {
                    SignaturePanel.this.sigPreview(g);
                }
            };
            this.sigPreviewComp.setPreferredSize(new Dimension(200, 200));
            this.sigPreviewComp.setToolTipText(Messages.getMessage("PdfSigner.ClickAndDrag"));
            this.sigPreviewComp.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SignaturePanel.this.visibleCheck.isSelected()) {
                        SignaturePanel.this.signRectOrigin.setLocation(e.getX(), e.getY());
                        SignaturePanel.this.drawRect = true;
                        Thread rect = new Thread(SignaturePanel.this.signAreaThread());
                        rect.start();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (SignaturePanel.this.visibleCheck.isSelected()) {
                        SignaturePanel.this.drawRect = false;
                        SignaturePanel.this.sigPreviewComp.repaint();
                    }
                }
            });
            result.add((Component)this.sigPreviewComp, "Center");
            if (SignWizardModel.this.pdfDecoder.getPageCount() > 1) {
                this.pageNumberLabel = new JLabel(Messages.getMessage("PdfSigner.PageNumber") + ' ' + this.currentPage);
                this.pageNumberLabel.setHorizontalAlignment(0);
                result.add((Component)this.pageNumberLabel, "North");
                this.pageSlider = new JSlider(0, 1, SignWizardModel.this.pdfDecoder.getPageCount(), this.currentPage);
                this.pageSlider.setMajorTickSpacing(SignWizardModel.this.pdfDecoder.getPageCount() - 1);
                this.pageSlider.setPaintLabels(true);
                this.pageSlider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        block3: {
                            if (SignaturePanel.this.pageSlider.getValueIsAdjusting()) {
                                SignaturePanel.this.currentPage = SignaturePanel.this.pageSlider.getValue();
                                try {
                                    SignaturePanel.this.previewImage = SignWizardModel.this.pdfDecoder.getPageAsImage(SignaturePanel.this.currentPage);
                                    SignaturePanel.this.sigPreviewComp.repaint();
                                    SignaturePanel.this.pageNumberLabel.setText(Messages.getMessage("PdfSigner.PageNumber") + ' ' + SignaturePanel.this.currentPage);
                                }
                                catch (Exception ex) {
                                    if (!LogWriter.isOutput()) break block3;
                                    LogWriter.writeLog("Exception: " + ex.getMessage());
                                }
                            }
                        }
                    }
                });
                result.add((Component)this.pageSlider, "South");
                this.pageSlider.setEnabled(false);
            }
            return result;
        }

        private void sigPreview(Graphics g) {
            int panelWidth = this.sigPreviewComp.getWidth();
            int panelHeight = this.sigPreviewComp.getHeight();
            this.previewWidth = this.previewImage.getWidth();
            this.previewHeight = this.previewImage.getHeight();
            this.scale = this.previewWidth > this.previewHeight ? (float)panelWidth / (float)this.previewWidth : (float)panelHeight / (float)this.previewHeight;
            this.previewWidth = (int)((float)this.previewWidth * this.scale);
            this.previewHeight = (int)((float)this.previewHeight * this.scale);
            this.offsetX = (panelWidth - this.previewWidth) / 2;
            this.offsetY = (panelHeight - this.previewHeight) / 2;
            g.drawImage(this.previewImage, this.offsetX, this.offsetY, this.previewWidth, this.previewHeight, null);
            if (this.visibleCheck.isSelected()) {
                g.clipRect(this.offsetX, this.offsetY, this.previewWidth, this.previewHeight);
                this.drawSignBox(g);
            }
        }

        private void drawSignBox(Graphics g) {
            int temp;
            if (this.signAreaUndefined) {
                PdfPageData pageData = SignWizardModel.this.pdfDecoder.getPdfPageData();
                this.signRectOrigin = new Point(this.offsetX, this.offsetY);
                this.signRectEnd = new Point((int)((float)pageData.getCropBoxWidth(this.currentPage) * this.scale) - 1 + this.offsetX, (int)((float)pageData.getCropBoxHeight(this.currentPage) * this.scale) - 1 + this.offsetY);
                this.signAreaUndefined = false;
            }
            int xO = (int)this.signRectOrigin.getX();
            int yO = (int)this.signRectOrigin.getY();
            int xE = (int)this.signRectEnd.getX();
            int yE = (int)this.signRectEnd.getY();
            if (xO > xE) {
                temp = xE;
                xE = xO;
                xO = temp;
            }
            if (yO > yE) {
                temp = yO;
                yO = yE;
                yE = temp;
            }
            g.drawRect(xO, yO, xE - xO, yE - yO);
            g.drawLine(xO, yO, xE, yE);
            g.drawLine(xO, yE, xE, yO);
        }

        private Runnable signAreaThread() {
            return new Runnable(){

                @Override
                public void run() {
                    Point origin = SignaturePanel.this.sigPreviewComp.getLocationOnScreen();
                    while (SignaturePanel.this.drawRect) {
                        block3: {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception e) {
                                if (!LogWriter.isOutput()) break block3;
                                LogWriter.writeLog("Exception: " + e.getMessage());
                            }
                        }
                        double x = MouseInfo.getPointerInfo().getLocation().getX() - origin.getX();
                        double y = MouseInfo.getPointerInfo().getLocation().getY() - origin.getY();
                        SignaturePanel.this.signRectEnd.setLocation(x, y);
                        SignaturePanel.this.sigPreviewComp.repaint();
                    }
                }
            };
        }
    }

    private class EncryptionPanel
    extends JPanel {
        private static final long serialVersionUID = -6371040190955762586L;
        private JCheckBox encryptionCheck = new JCheckBox("Encrypt");
        private JCheckBox allowPrinting = new JCheckBox("Allow Printing");
        private JCheckBox allowModifyContent = new JCheckBox("Allow Content Modification");
        private JCheckBox allowCopy = new JCheckBox("Allow Copy");
        private JCheckBox allowModifyAnnotation = new JCheckBox("Allow Annotation Modification");
        private JCheckBox allowFillIn = new JCheckBox("Allow Fill In");
        private JCheckBox allowScreenReader = new JCheckBox("Allow Screen Reader");
        private JCheckBox allowAssembly = new JCheckBox("Allow Assembly");
        private JCheckBox allowDegradedPrinting = new JCheckBox("Allow Degraded Printing");
        private JPasswordField userPassword = new JPasswordField();
        private JPasswordField ownerPassword = new JPasswordField();
        private JCheckBox flatten = new JCheckBox("Flatten PDF");
        private JCheckBox visiblePassUserCheck = new JCheckBox();
        private JCheckBox visiblePassOwnerCheck = new JCheckBox();
        private boolean ownerAdvance = false;
        private volatile boolean canAdvance = true;

        public EncryptionPanel() {
            int y = 0;
            this.setLayout(new BorderLayout());
            this.add((Component)new TitlePanel(Messages.getMessage("PdfSigner.EncryptionOptions")), "North");
            JPanel optionPanel = new JPanel();
            optionPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y;
            c.fill = 2;
            c.anchor = 19;
            this.encryptionCheck.setEnabled(!SignWizardModel.this.isPdfSigned());
            this.encryptionCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EncryptionPanel.this.canAdvance = !EncryptionPanel.this.encryptionCheck.isSelected() || EncryptionPanel.this.ownerAdvance;
                }
            });
            optionPanel.add((Component)this.encryptionCheck, c);
            this.encryptionCheck.setSelected(false);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = y;
            c.fill = 2;
            c.anchor = 24;
            this.flatten.setEnabled(!SignWizardModel.this.isPdfSigned());
            optionPanel.add((Component)this.flatten, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            ++y;
            c.gridy = y++;
            c.gridwidth = 3;
            c.fill = 2;
            optionPanel.add((Component)new JSeparator(0), c);
            this.allowPrinting.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y;
            c.fill = 2;
            optionPanel.add((Component)this.allowPrinting, c);
            this.allowModifyContent.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = y++;
            c.fill = 2;
            c.gridwidth = 2;
            optionPanel.add((Component)this.allowModifyContent, c);
            this.allowCopy.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y;
            c.fill = 2;
            optionPanel.add((Component)this.allowCopy, c);
            this.allowModifyAnnotation.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = y++;
            c.fill = 2;
            c.gridwidth = 2;
            optionPanel.add((Component)this.allowModifyAnnotation, c);
            this.allowFillIn.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y;
            c.fill = 2;
            optionPanel.add((Component)this.allowFillIn, c);
            this.allowScreenReader.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = y++;
            c.fill = 2;
            c.gridwidth = 2;
            optionPanel.add((Component)this.allowScreenReader, c);
            this.allowAssembly.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y;
            c.fill = 2;
            optionPanel.add((Component)this.allowAssembly, c);
            this.allowDegradedPrinting.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = y++;
            c.fill = 2;
            c.gridwidth = 2;
            optionPanel.add((Component)this.allowDegradedPrinting, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 3;
            c.fill = 2;
            optionPanel.add((Component)new JSeparator(0), c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            optionPanel.add((Component)new JLabel(Messages.getMessage("PdfSigner.UserPassword")), c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = y;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            this.userPassword.setEnabled(false);
            this.userPassword.setPreferredSize(new Dimension(100, 20));
            this.userPassword.addKeyListener(new KeyListener(){

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    EncryptionPanel.this.ownerAdvance = true;
                    EncryptionPanel.this.canAdvance = true;
                }
            });
            optionPanel.add((Component)this.userPassword, c);
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 2;
            c.gridy = y++;
            c.insets = new Insets(0, 0, 0, 0);
            this.visiblePassUserCheck.setToolTipText(Messages.getMessage("PdfSigner.ShowPassword"));
            this.visiblePassUserCheck.addActionListener(new ActionListener(){
                private char defaultChar;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EncryptionPanel.this.visiblePassUserCheck.isSelected()) {
                        this.defaultChar = EncryptionPanel.this.userPassword.getEchoChar();
                        EncryptionPanel.this.userPassword.setEchoChar('\u0000');
                    } else {
                        EncryptionPanel.this.userPassword.setEchoChar(this.defaultChar);
                    }
                }
            });
            this.visiblePassUserCheck.setEnabled(false);
            optionPanel.add((Component)this.visiblePassUserCheck, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            optionPanel.add((Component)new JLabel(Messages.getMessage("PdfSigner.OwnerPassword")), c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = y;
            c.fill = 2;
            c.insets = new Insets(5, 0, 0, 0);
            this.ownerPassword.setEnabled(false);
            this.ownerPassword.setPreferredSize(new Dimension(100, 20));
            optionPanel.add((Component)this.ownerPassword, c);
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 2;
            c.gridy = y++;
            c.insets = new Insets(0, 0, 0, 0);
            this.visiblePassOwnerCheck.setToolTipText(Messages.getMessage("PdfSigner.ShowPassword"));
            this.visiblePassOwnerCheck.addActionListener(new ActionListener(){
                private char defaultChar;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EncryptionPanel.this.visiblePassOwnerCheck.isSelected()) {
                        this.defaultChar = EncryptionPanel.this.ownerPassword.getEchoChar();
                        EncryptionPanel.this.ownerPassword.setEchoChar('\u0000');
                    } else {
                        EncryptionPanel.this.ownerPassword.setEchoChar(this.defaultChar);
                    }
                }
            });
            this.visiblePassOwnerCheck.setEnabled(false);
            optionPanel.add((Component)this.visiblePassOwnerCheck, c);
            if (SignWizardModel.this.isPdfSigned()) {
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridx = 0;
                c.gridy = y;
                c.gridwidth = 3;
                c.insets = new Insets(25, 0, 0, 0);
                JLabel notAvailable = new JLabel(Messages.getMessage("PdfSigner.DisabledSigned"), 0);
                notAvailable.setForeground(Color.red);
                optionPanel.add((Component)notAvailable, c);
            }
            this.encryptionCheck.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean enable = e.getStateChange() == 1;
                    EncryptionPanel.this.allowPrinting.setEnabled(enable);
                    EncryptionPanel.this.allowModifyContent.setEnabled(enable);
                    EncryptionPanel.this.allowCopy.setEnabled(enable);
                    EncryptionPanel.this.allowModifyAnnotation.setEnabled(enable);
                    EncryptionPanel.this.allowFillIn.setEnabled(enable);
                    EncryptionPanel.this.allowScreenReader.setEnabled(enable);
                    EncryptionPanel.this.allowAssembly.setEnabled(enable);
                    EncryptionPanel.this.allowDegradedPrinting.setEnabled(enable);
                    EncryptionPanel.this.userPassword.setEnabled(enable);
                    EncryptionPanel.this.ownerPassword.setEnabled(enable);
                    EncryptionPanel.this.visiblePassUserCheck.setEnabled(enable);
                    EncryptionPanel.this.visiblePassOwnerCheck.setEnabled(enable);
                }
            });
            this.add((Component)optionPanel, "Center");
            this.add((Component)new ProgressPanel(4), "South");
        }

        public void registerChange(ChangeListener wizard) {
            this.encryptionCheck.addChangeListener(wizard);
        }

        public void registerNextKeyListeners(KeyListener wizard) {
            this.userPassword.addKeyListener(wizard);
        }

        public boolean canAdvance() {
            return this.canAdvance;
        }

        public void collectData() {
            SignWizardModel.this.signData.setFlatten(this.flatten.isSelected());
            SignWizardModel.this.signData.setEncrypt(this.encryptionCheck.isSelected());
            if (this.encryptionCheck.isSelected()) {
                SignWizardModel.this.signData.setEncryptUserPass(this.userPassword.getPassword());
                SignWizardModel.this.signData.setEncryptOwnerPass(this.ownerPassword.getPassword());
                int result = 0;
                if (this.allowPrinting.isSelected()) {
                    result |= 0xFFFFFFFF;
                }
                if (this.allowModifyContent.isSelected()) {
                    result |= 0xFFFFFFFF;
                }
                if (this.allowCopy.isSelected()) {
                    result |= 0xFFFFFFFF;
                }
                if (this.allowModifyAnnotation.isSelected()) {
                    result |= 0xFFFFFFFF;
                }
                if (this.allowFillIn.isSelected()) {
                    result |= 0xFFFFFFFF;
                }
                if (this.allowScreenReader.isSelected()) {
                    result |= 0xFFFFFFFF;
                }
                if (this.allowAssembly.isSelected()) {
                    result |= 0xFFFFFFFF;
                }
                if (this.allowDegradedPrinting.isSelected()) {
                    result |= 0xFFFFFFFF;
                }
                SignWizardModel.this.signData.setEncryptPermissions(result);
            }
        }
    }

    private class CommonPanel
    extends JPanel {
        private static final long serialVersionUID = 3825885785941603037L;
        private JLabel reasonLabel = new JLabel();
        private JTextField signerReasonArea = new JTextField();
        private JLabel locationLabel = new JLabel();
        private JTextField signerLocationField = new JTextField();
        private JLabel outputFileLabel = new JLabel();
        private JLabel currentOutputFilePath = new JLabel();
        private JButton browseOutputButton = new JButton();
        private volatile boolean canAdvance = false;

        public CommonPanel() {
            try {
                this.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void init() {
            this.setLayout(new BorderLayout());
            this.add((Component)new TitlePanel(Messages.getMessage("PdfSigner.ReasonAndLocation")), "North");
            JPanel inputPanel = new JPanel(new GridBagLayout());
            inputPanel.setBorder(BorderFactory.createEtchedBorder(1));
            GridBagConstraints c = new GridBagConstraints();
            this.reasonLabel.setText(Messages.getMessage("PdfSigner.Reason") + ':');
            this.reasonLabel.setFont(new Font("Dialog", 1, 14));
            c.anchor = 23;
            c.fill = 2;
            c.gridy = 0;
            c.gridx = 0;
            c.insets = new Insets(10, 0, 0, 0);
            inputPanel.add((Component)this.reasonLabel, c);
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 3;
            c.insets = new Insets(10, 0, 10, 0);
            this.signerReasonArea.setPreferredSize(new Dimension(200, 20));
            inputPanel.add((Component)this.signerReasonArea, c);
            this.locationLabel.setText(Messages.getMessage("PdfSigner.Location") + ':');
            this.locationLabel.setFont(new Font("Dialog", 1, 14));
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 2;
            inputPanel.add((Component)this.locationLabel, c);
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 3;
            c.insets = new Insets(10, 0, 0, 0);
            c.gridwidth = 3;
            this.signerLocationField.setPreferredSize(new Dimension(200, 20));
            inputPanel.add((Component)this.signerLocationField, c);
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 4;
            c.gridwidth = 3;
            c.insets = new Insets(10, 0, 0, 0);
            inputPanel.add((Component)new JSeparator(0), c);
            this.outputFileLabel.setText(Messages.getMessage("PdfSigner.OutputFile"));
            this.outputFileLabel.setFont(new Font("Dialog", 1, 14));
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 5;
            c.insets = new Insets(5, 10, 0, 0);
            inputPanel.add((Component)this.outputFileLabel, c);
            this.currentOutputFilePath.setText(NO_FILE_SELECTED);
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 6;
            c.insets = new Insets(10, 0, 0, 0);
            c.gridwidth = 3;
            this.currentOutputFilePath.setPreferredSize(new Dimension(100, 20));
            inputPanel.add((Component)this.currentOutputFilePath, c);
            this.browseOutputButton.setText(Messages.getMessage("PdfViewerOption.Browse"));
            this.browseOutputButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(SignWizardModel.this.rootDir);
                    int state = chooser.showSaveDialog(null);
                    File file = chooser.getSelectedFile();
                    if (file != null && state == 0) {
                        if (file.exists()) {
                            JOptionPane.showMessageDialog(null, Messages.getMessage("PdfSigner.PleaseChooseAnotherFile"), Messages.getMessage("PdfViewerGeneralError.message"), 0);
                            CommonPanel.this.canAdvance = false;
                            CommonPanel.this.currentOutputFilePath.setText(NO_FILE_SELECTED);
                            SignWizardModel.this.signData.setOutputFilePath(null);
                        } else if (file.isDirectory()) {
                            JOptionPane.showMessageDialog(null, Messages.getMessage("PdfSigner.NoFileSelected"), Messages.getMessage("PdfViewerGeneralError.message"), 0);
                            CommonPanel.this.canAdvance = false;
                            CommonPanel.this.currentOutputFilePath.setText(NO_FILE_SELECTED);
                        } else {
                            CommonPanel.this.currentOutputFilePath.setText(file.getAbsolutePath());
                            CommonPanel.this.canAdvance = true;
                        }
                    }
                }
            });
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 2;
            c.gridy = 5;
            c.insets = new Insets(5, 25, 0, 25);
            c.anchor = 26;
            inputPanel.add((Component)this.browseOutputButton, c);
            this.add((Component)inputPanel, "Center");
            this.add((Component)new ProgressPanel(5), "South");
        }

        public boolean canFinish() {
            return this.canAdvance;
        }

        public void registerChange(ChangeListener e) {
            this.browseOutputButton.addChangeListener(e);
        }

        public void collectData() {
            SignWizardModel.this.signData.setReason(this.signerReasonArea.getText());
            SignWizardModel.this.signData.setLocation(this.signerLocationField.getText());
            SignWizardModel.this.signData.setOutputFilePath(this.currentOutputFilePath.getText());
        }
    }

    private class KeystorePanel
    extends JPanel {
        private static final long serialVersionUID = -1708113426345065086L;
        private JLabel keyStoreLabel = new JLabel();
        private JLabel currentKeyStorePath = new JLabel(NO_FILE_SELECTED);
        private JButton browseKeyStoreButton = new JButton();
        private JLabel passwordKeyStoreLabel = new JLabel();
        private JPasswordField passwordKeyStoreField = new JPasswordField();
        private JCheckBox visiblePassKeyCheck = new JCheckBox();
        private JLabel aliasNameLabel = new JLabel();
        private JTextField aliasNameField = new JTextField();
        private JLabel aliasPasswordLabel = new JLabel();
        private JPasswordField aliasPasswordField = new JPasswordField();
        private JCheckBox visiblePassAliasCheck = new JCheckBox();
        private volatile boolean storeAdvance;
        private volatile boolean storePassAdvance;
        private volatile boolean aliasAdvance;
        private volatile boolean aliasPassAdvance = false;

        public KeystorePanel() {
            try {
                this.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void init() {
            this.setLayout(new BorderLayout());
            this.add((Component)new TitlePanel(Messages.getMessage("PdfSigner.KeyStoreMode")), "North");
            JPanel inputPanel = new JPanel(new GridBagLayout());
            inputPanel.setBorder(BorderFactory.createEtchedBorder(1));
            GridBagConstraints c = new GridBagConstraints();
            this.keyStoreLabel.setText(Messages.getMessage("PdfSigner.SelectKeyStore"));
            this.keyStoreLabel.setFont(new Font("Dialog", 1, 14));
            c.anchor = 23;
            c.fill = 2;
            c.gridy = 0;
            c.gridx = 0;
            c.insets = new Insets(0, 10, 10, 0);
            inputPanel.add((Component)this.keyStoreLabel, c);
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 3;
            c.insets = new Insets(0, 20, 0, 10);
            this.currentKeyStorePath.setPreferredSize(new Dimension(250, 20));
            inputPanel.add((Component)this.currentKeyStorePath, c);
            this.browseKeyStoreButton.setText(Messages.getMessage("PdfViewerOption.Browse"));
            this.browseKeyStoreButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(SignWizardModel.this.rootDir);
                    chooser.setFileHidingEnabled(false);
                    int state = chooser.showOpenDialog(null);
                    File file = chooser.getSelectedFile();
                    if (file != null && state == 0) {
                        KeystorePanel.this.currentKeyStorePath.setText(file.getAbsolutePath());
                        KeystorePanel.this.storeAdvance = true;
                    }
                }
            });
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 1;
            c.gridy = 0;
            c.insets = new Insets(0, 30, 0, 0);
            inputPanel.add((Component)this.browseKeyStoreButton, c);
            this.passwordKeyStoreLabel.setText(Messages.getMessage("PdfSigner.Password"));
            this.passwordKeyStoreLabel.setFont(new Font("Dialog", 1, 14));
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 2;
            c.insets = new Insets(30, 10, 0, 10);
            inputPanel.add((Component)this.passwordKeyStoreLabel, c);
            this.passwordKeyStoreField.addKeyListener(new KeyListener(){

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    KeystorePanel.this.storePassAdvance = true;
                }
            });
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 1;
            c.gridy = 2;
            c.gridwidth = 1;
            c.insets = new Insets(30, 10, 0, 10);
            inputPanel.add((Component)this.passwordKeyStoreField, c);
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 2;
            c.gridy = 2;
            c.insets = new Insets(30, 0, 0, 0);
            this.visiblePassKeyCheck.setToolTipText(Messages.getMessage("PdfSigner.ShowPassword"));
            this.visiblePassKeyCheck.addActionListener(new ActionListener(){
                private char defaultChar;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (KeystorePanel.this.visiblePassKeyCheck.isSelected()) {
                        this.defaultChar = KeystorePanel.this.passwordKeyStoreField.getEchoChar();
                        KeystorePanel.this.passwordKeyStoreField.setEchoChar('\u0000');
                    } else {
                        KeystorePanel.this.passwordKeyStoreField.setEchoChar(this.defaultChar);
                    }
                }
            });
            inputPanel.add((Component)this.visiblePassKeyCheck, c);
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 4;
            c.gridwidth = 4;
            c.insets = new Insets(10, 0, 10, 0);
            inputPanel.add((Component)new JSeparator(0), c);
            this.aliasNameLabel.setText(Messages.getMessage("PdfSigner.AliasName"));
            this.aliasNameLabel.setFont(new Font("Dialog", 1, 14));
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 5;
            c.insets = new Insets(0, 10, 10, 0);
            inputPanel.add((Component)this.aliasNameLabel, c);
            this.aliasNameField.addKeyListener(new KeyListener(){

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    KeystorePanel.this.aliasAdvance = true;
                }
            });
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 1;
            c.gridy = 5;
            c.gridwidth = 2;
            c.insets = new Insets(0, 10, 0, 10);
            this.aliasNameField.setPreferredSize(new Dimension(150, 20));
            inputPanel.add((Component)this.aliasNameField, c);
            this.aliasPasswordLabel.setText(Messages.getMessage("PdfSigner.AliasPassword"));
            this.aliasPasswordLabel.setFont(new Font("Dialog", 1, 14));
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 7;
            c.insets = new Insets(10, 10, 0, 10);
            inputPanel.add((Component)this.aliasPasswordLabel, c);
            this.aliasPasswordField.addKeyListener(new KeyListener(){

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    KeystorePanel.this.aliasPassAdvance = true;
                }
            });
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 1;
            c.gridy = 7;
            c.insets = new Insets(0, 10, 0, 10);
            c.anchor = 20;
            this.aliasPasswordField.setPreferredSize(new Dimension(100, 20));
            inputPanel.add((Component)this.aliasPasswordField, c);
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 2;
            c.gridy = 7;
            c.insets = new Insets(10, 0, 0, 0);
            this.visiblePassAliasCheck.setToolTipText(Messages.getMessage("PdfSigner.ShowPassword"));
            this.visiblePassAliasCheck.addActionListener(new ActionListener(){
                private char defaultChar;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (KeystorePanel.this.visiblePassAliasCheck.isSelected()) {
                        this.defaultChar = KeystorePanel.this.aliasPasswordField.getEchoChar();
                        KeystorePanel.this.aliasPasswordField.setEchoChar('\u0000');
                    } else {
                        KeystorePanel.this.aliasPasswordField.setEchoChar(this.defaultChar);
                    }
                }
            });
            inputPanel.add((Component)this.visiblePassAliasCheck, c);
            this.add((Component)inputPanel, "Center");
            this.add((Component)new ProgressPanel(2), "South");
        }

        public void registerChange(ChangeListener e) {
            this.browseKeyStoreButton.addChangeListener(e);
        }

        public void registerNextKeyListeners(KeyListener e) {
            this.passwordKeyStoreField.addKeyListener(e);
            this.aliasNameField.addKeyListener(e);
            this.aliasPasswordField.addKeyListener(e);
        }

        public boolean canAdvance() {
            return this.storeAdvance && this.storePassAdvance && this.aliasAdvance && this.aliasPassAdvance;
        }

        public void collectData() {
            SignWizardModel.this.signData.setKeyStorePath(this.currentKeyStorePath.getText());
            SignWizardModel.this.signData.setKeystorePassword(this.passwordKeyStoreField.getPassword());
            SignWizardModel.this.signData.setAlias(this.aliasNameField.getText());
            SignWizardModel.this.signData.setAliasPassword(this.aliasPasswordField.getPassword());
        }
    }

    private class ModeSelect
    extends JPanel {
        private static final long serialVersionUID = 6239826095260699312L;
        private String selfString = Messages.getMessage("PdfSigner.HaveKeystore");
        private String otherString = Messages.getMessage("PdfSigner.HavePfx");
        private int y = 0;
        private JRadioButton selfButton = new JRadioButton(this.selfString);
        private String[] certifyOptions = new String[]{Messages.getMessage("PdfSigner.NotCertified"), Messages.getMessage("PdfSigner.NoChangesAllowed"), Messages.getMessage("PdfSigner.FormFilling"), Messages.getMessage("PdfSigner.FormFillingAndAnnotations")};
        private JComboBox certifyCombo = new JComboBox<String>(this.certifyOptions);
        private int certifyMode = -1;

        public ModeSelect() {
            if (!SignWizardModel.this.signData.isAppendMode()) {
                this.certifyCombo = new JComboBox<String>(this.certifyOptions);
            } else {
                String[] s = new String[]{"Not Allowed..."};
                this.certifyCombo = new JComboBox<String>(s);
            }
            this.setLayout(new BorderLayout());
            this.add((Component)new TitlePanel(Messages.getMessage("PdfSigner.SelectSigningMode")), "North");
            JPanel optionPanel = new JPanel();
            optionPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            this.selfButton.setActionCommand(this.selfString);
            c.gridx = 0;
            c.gridy = this.y++;
            c.anchor = 23;
            c.fill = 2;
            c.insets = new Insets(10, 0, 20, 0);
            this.selfButton.setFont(new Font("Dialog", 1, 12));
            optionPanel.add((Component)this.selfButton, c);
            JRadioButton otherButton = new JRadioButton(this.otherString);
            otherButton.setActionCommand(this.otherString);
            otherButton.setSelected(true);
            SignWizardModel.this.signData.setSignMode(false);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = this.y++;
            c.fill = 2;
            otherButton.setFont(new Font("Dialog", 1, 12));
            optionPanel.add((Component)otherButton, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = this.y++;
            c.fill = 2;
            c.insets = new Insets(30, 0, 30, 0);
            optionPanel.add((Component)new JSeparator(0), c);
            JLabel certifyLabel = new JLabel(Messages.getMessage("PdfSigner.CertificationAuthor"));
            certifyLabel.setFont(new Font("Dialog", 1, 12));
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = this.y++;
            c.fill = 10;
            optionPanel.add((Component)certifyLabel, c);
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = this.y;
            c.insets = new Insets(10, 0, 0, 0);
            c.anchor = 20;
            this.certifyCombo.setEnabled(!SignWizardModel.this.isPdfSigned());
            this.certifyCombo.setSelectedIndex(0);
            this.certifyCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String mode = (String)ModeSelect.this.certifyCombo.getSelectedItem();
                    if (mode.equals(Messages.getMessage("PdfSigner.NotCertified"))) {
                        ModeSelect.this.certifyMode = -1;
                    } else if (mode.equals(Messages.getMessage("PdfSigner.NoChangesAllowed"))) {
                        ModeSelect.this.certifyMode = -1;
                    } else if (mode.equals(Messages.getMessage("PdfSigner.FormFilling"))) {
                        ModeSelect.this.certifyMode = -1;
                    } else if (mode.equals(Messages.getMessage("PdfSigner.FormFillingAndAnnotations"))) {
                        ModeSelect.this.certifyMode = -1;
                    } else {
                        throw new NullPointerException("The certifyCombo box is sending a string that is not recognised.");
                    }
                }
            });
            optionPanel.add((Component)this.certifyCombo, c);
            if (SignWizardModel.this.isPdfSigned()) {
                this.certifyCombo.setToolTipText(Messages.getMessage("PdfSigner.NotPermittedOnSigned"));
            }
            this.add((Component)optionPanel, "Center");
            ButtonGroup group = new ButtonGroup();
            group.add(this.selfButton);
            group.add(otherButton);
            this.add((Component)new ProgressPanel(1), "South");
        }

        public void collectData() {
            SignWizardModel.this.signData.setSignMode(this.selfButton.isSelected());
            SignWizardModel.this.signData.setCertifyMode(this.certifyMode);
        }
    }

    private class PFXPanel
    extends JPanel {
        private static final long serialVersionUID = 5362079107382052293L;
        private JLabel keyFileLabel = new JLabel();
        private JButton browseKeyButton = new JButton();
        private JLabel currentKeyFilePath = new JLabel(NO_FILE_SELECTED);
        private JCheckBox visiblePassCheck = new JCheckBox();
        private JLabel passwordLabel = new JLabel();
        private JPasswordField passwordField = new JPasswordField();
        private volatile boolean keyNext = false;
        private volatile boolean passNext = false;
        private int y = 0;

        public PFXPanel() {
            try {
                this.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void init() throws Exception {
            this.setLayout(new BorderLayout());
            this.add((Component)new TitlePanel(Messages.getMessage("PdfSigner.PfxSignMode")), "North");
            JPanel inputPanel = new JPanel(new GridBagLayout());
            inputPanel.setBorder(BorderFactory.createEtchedBorder(1));
            GridBagConstraints c = new GridBagConstraints();
            this.keyFileLabel.setText(Messages.getMessage("PdfSigner.KeyFile"));
            this.keyFileLabel.setFont(new Font("Dialog", 1, 14));
            c.anchor = 23;
            c.fill = 2;
            c.gridy = 0;
            c.gridx = 0;
            c.insets = new Insets(0, 10, 10, 0);
            inputPanel.add((Component)this.keyFileLabel, c);
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            ++this.y;
            c.gridy = this.y++;
            c.gridwidth = 3;
            this.currentKeyFilePath.setPreferredSize(new Dimension(250, 20));
            c.insets = new Insets(10, 10, 10, 10);
            inputPanel.add((Component)this.currentKeyFilePath, c);
            this.browseKeyButton.setText(Messages.getMessage("PdfViewerOption.Browse"));
            this.browseKeyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(SignWizardModel.this.rootDir);
                    String[] pfx = new String[]{"pfx"};
                    chooser.addChoosableFileFilter(new FileFilterer(pfx, "Key (pfx)"));
                    int state = chooser.showOpenDialog(null);
                    File file = chooser.getSelectedFile();
                    if (file != null && state == 0) {
                        PFXPanel.this.currentKeyFilePath.setText(file.getAbsolutePath());
                        PFXPanel.this.keyNext = true;
                    }
                }
            });
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 2;
            c.gridy = 0;
            c.insets = new Insets(0, 25, 0, 10);
            inputPanel.add((Component)this.browseKeyButton, c);
            this.passwordLabel.setText(Messages.getMessage("PdfSigner.Password"));
            this.passwordLabel.setFont(new Font("Dialog", 1, 14));
            c.fill = 2;
            c.gridx = 0;
            c.gridy = this.y;
            c.insets = new Insets(20, 10, 10, 10);
            inputPanel.add((Component)this.passwordLabel, c);
            this.passwordField.addKeyListener(new KeyListener(){

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    PFXPanel.this.passNext = true;
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 1;
            c.gridy = this.y;
            c.gridwidth = 1;
            c.insets = new Insets(20, 10, 0, 10);
            this.passwordField.setPreferredSize(new Dimension(100, 20));
            inputPanel.add((Component)this.passwordField, c);
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 2;
            c.gridy = this.y;
            c.insets = new Insets(20, 0, 0, 0);
            this.visiblePassCheck.setToolTipText(Messages.getMessage("PdfSigner.ShowPassword"));
            this.visiblePassCheck.addActionListener(new ActionListener(){
                private char defaultChar;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PFXPanel.this.visiblePassCheck.isSelected()) {
                        this.defaultChar = PFXPanel.this.passwordField.getEchoChar();
                        PFXPanel.this.passwordField.setEchoChar('\u0000');
                    } else {
                        PFXPanel.this.passwordField.setEchoChar(this.defaultChar);
                    }
                }
            });
            inputPanel.add((Component)this.visiblePassCheck, c);
            this.add((Component)inputPanel, "Center");
            this.add((Component)new ProgressPanel(2), "South");
        }

        public void registerChange(ChangeListener e) {
            this.browseKeyButton.addChangeListener(e);
        }

        public void registerListener(KeyListener e) {
            this.passwordField.addKeyListener(e);
        }

        public boolean canAdvance() {
            return this.passNext && this.keyNext;
        }

        public void collectData() {
            SignWizardModel.this.signData.setKeyFilePassword(this.passwordField.getPassword());
            SignWizardModel.this.signData.setKeyFilePath(this.currentKeyFilePath.getText());
        }
    }
}

