/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jpedal.Display;
import org.jpedal.PageOffsets;
import org.jpedal.PdfDecoder;
import org.jpedal.SingleDisplay;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.gui.CheckNode;
import org.jpedal.examples.viewer.gui.CheckRenderer;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.SignaturesTreeCellRenderer;
import org.jpedal.examples.viewer.gui.VTextIcon;
import org.jpedal.examples.viewer.gui.generic.GUIButton;
import org.jpedal.examples.viewer.gui.generic.GUICombo;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.viewer.gui.popups.SwingProperties;
import org.jpedal.examples.viewer.gui.swing.CommandListener;
import org.jpedal.examples.viewer.gui.swing.FrameCloser;
import org.jpedal.examples.viewer.gui.swing.SearchList;
import org.jpedal.examples.viewer.gui.swing.SwingButton;
import org.jpedal.examples.viewer.gui.swing.SwingCheckBoxMenuItem;
import org.jpedal.examples.viewer.gui.swing.SwingCombo;
import org.jpedal.examples.viewer.gui.swing.SwingMenuItem;
import org.jpedal.examples.viewer.gui.swing.SwingOutline;
import org.jpedal.examples.viewer.gui.swing.SwingSearchWindow;
import org.jpedal.examples.viewer.paper.PaperSizes;
import org.jpedal.examples.viewer.utils.Printer;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.external.CustomMessageHandler;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.gui.GUIFactory;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.StatusBar;
import org.jpedal.linear.LinearThread;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.formData.GUIData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.ImageCommands;
import org.jpedal.render.BaseDisplay;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;
import org.jpedal.utils.repositories.Vector_Int;
import org.w3c.dom.Node;

public class SwingGUI
extends GUI
implements GUIFactory {
    private boolean previewOnSingleScroll = true;
    private Timer memoryMonitor = null;
    private boolean debugThumbnail = false;
    ScrollListener scrollListener;
    ScrollMouseListener scrollMouseListener;
    JScrollBar thumbscroll = null;
    private boolean isMultiPageTiff = false;
    private static final boolean enableShowSign = true;
    boolean finishedDecoding = false;
    static int startSize = 30;
    static int expandedSize = 190;
    public boolean useNewLayout = true;
    public static String windowTitle;
    String pageTitle;
    String bookmarksTitle;
    String signaturesTitle;
    String layersTitle;
    boolean hasListener = false;
    private boolean isSetup = false;
    int lastTabSelected = -1;
    public boolean messageShown = false;
    private Cursor grabCursor;
    private Cursor grabbingCursor;
    private Cursor panCursor;
    private Cursor panCursorL;
    private Cursor panCursorTL;
    private Cursor panCursorT;
    private Cursor panCursorTR;
    private Cursor panCursorR;
    private Cursor panCursorBR;
    private Cursor panCursorB;
    private Cursor panCursorBL;
    public static final int GRAB_CURSOR = 1;
    public static final int GRABBING_CURSOR = 2;
    public static final int DEFAULT_CURSOR = 3;
    public static final int PAN_CURSOR = 4;
    public static final int PAN_CURSORL = 5;
    public static final int PAN_CURSORTL = 6;
    public static final int PAN_CURSORT = 7;
    public static final int PAN_CURSORTR = 8;
    public static final int PAN_CURSORR = 9;
    public static final int PAN_CURSORBR = 10;
    public static final int PAN_CURSORB = 11;
    public static final int PAN_CURSORBL = 12;
    private PaperSizes paperSizes;
    private JPanel multibox = new JPanel();
    public static final int CURSOR = 1;
    ButtonGroup layoutGroup = new ButtonGroup();
    ButtonGroup searchLayoutGroup = new ButtonGroup();
    ButtonGroup borderGroup = new ButtonGroup();
    public int glowThickness = 11;
    public Color glowOuterColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    public Color glowInnerColor = new Color(0.8f, 0.75f, 0.45f, 0.8f);
    private boolean pageTurnScalingAppropriate = true;
    private boolean dragLeft = false;
    private boolean dragTop = false;
    private CommandListener currentCommandListener;
    private JToolBar topButtons = new JToolBar();
    private JToolBar navButtons = new JToolBar();
    private JToolBar comboBoxBar = new JToolBar();
    private JMenuBar currentMenu = new JMenuBar();
    private boolean firstTimeFormMessage = true;
    private JLabel coords = new JLabel();
    private Container frame = new JFrame();
    private JDesktopPane desktopPane = new JDesktopPane();
    boolean isSingle = true;
    private JTabbedPane navOptionsPanel = new JTabbedPane();
    private JSplitPane displayPane;
    private JScrollPane scrollPane = new JScrollPane();
    private Font headFont = new Font("SansSerif", 1, 14);
    private Font textFont1 = new Font("SansSerif", 0, 12);
    private Font textFont = new Font("Serif", 0, 12);
    private StatusBar statusBar = new StatusBar(new Color(235, 154, 0));
    private StatusBar downloadBar = new StatusBar(new Color(185, 209, 0));
    private JLabel pageCounter1;
    CustomMessageHandler customMessageHandler = null;
    public JTextField pageCounter2 = new JTextField(4);
    private JLabel pageCounter3;
    private JLabel optimizationLabel;
    private JTree signaturesTree;
    private JPanel layersPanel = new JPanel();
    private String user_dir = System.getProperty("user.dir");
    private boolean tabsNotInitialised = true;
    private JToolBar navToolBar = new JToolBar();
    private JToolBar pagesToolBar = new JToolBar();
    public GUIButton nextSearch;
    public GUIButton previousSearch;
    PdfLayerList layersObject;
    private final JProgressBar memoryBar = new JProgressBar();
    JToolBar cursor = new JToolBar();
    private GUIButton openButton;
    private GUIButton printButton;
    private GUIButton searchButton;
    private GUIButton docPropButton;
    private GUIButton infoButton;
    public GUIButton mouseMode;
    private JMenu fileMenu;
    private JMenu openMenu;
    private JMenuItem open;
    private JMenuItem openUrl;
    private JMenuItem save;
    private JMenuItem reSaveAsForms;
    private JMenuItem find;
    private JMenuItem documentProperties;
    private JMenuItem signPDF;
    private JMenuItem print;
    private JMenuItem exit;
    private JMenu editMenu;
    private JMenuItem copy;
    private JMenuItem selectAll;
    private JMenuItem deselectAll;
    private JMenuItem preferences;
    private JMenu viewMenu;
    private JMenu goToMenu;
    private JMenuItem firstPage;
    private JMenuItem backPage;
    private JMenuItem forwardPage;
    private JMenuItem lastPage;
    private JMenuItem goTo;
    private JMenuItem previousDocument;
    private JMenuItem nextDocument;
    private JMenu pageLayoutMenu;
    private JMenuItem single;
    private JMenuItem continuous;
    private JMenuItem facing;
    private JMenuItem continuousFacing;
    private JMenuItem pageFlow;
    private JMenuItem textSelect;
    private JCheckBoxMenuItem separateCover;
    private JMenuItem panMode;
    private JMenuItem fullscreen;
    private JMenu windowMenu;
    private JMenuItem cascade;
    private JMenuItem tile;
    private JMenu exportMenu;
    private JMenu pdfMenu;
    private JMenuItem onePerPage;
    private JMenuItem nup;
    private JMenuItem handouts;
    private JMenu contentMenu;
    private JMenuItem images;
    private JMenuItem text;
    private JMenuItem bitmap;
    private JMenu pageToolsMenu;
    private JMenuItem rotatePages;
    private JMenuItem deletePages;
    private JMenuItem addPage;
    private JMenuItem addHeaderFooter;
    private JMenuItem stampText;
    private JMenuItem stampImage;
    private JMenuItem crop;
    private JMenu helpMenu;
    private JMenuItem visitWebsite;
    private JMenuItem tipOfTheDay;
    private JMenuItem checkUpdates;
    private JMenuItem about;
    private DefaultMutableTreeNode topLayer = new DefaultMutableTreeNode("Layers");
    JScrollPane fontScrollPane = new JScrollPane();
    boolean sortFontsByDir = true;
    GUISearchWindow searchFrame = null;
    boolean addSearchTab = false;
    boolean searchInMenu = false;
    JTextField searchText = null;
    SearchList results = null;
    public Commands currentCommands;
    JToggleButton options;
    JPopupMenu menu;
    private String iconLocation = "/org/jpedal/examples/viewer/res/";
    private boolean cursorOverPage = false;

    public JScrollBar getThumbnailScrollBar() {
        return this.thumbscroll;
    }

    public static void setStartSize(int startSize) {
        SwingGUI.startSize = startSize;
    }

    public SwingGUI(PdfDecoder decode_pdf, Values commonValues, GUIThumbnailPanel thumbnails, PropertiesFile properties) {
        this.decode_pdf = decode_pdf;
        this.commonValues = commonValues;
        this.thumbnails = thumbnails;
        this.properties = properties;
        decode_pdf.addExternalHandler(this, 11);
        if (this.isSingle) {
            this.desktopPane.setBackground(this.frame.getBackground());
            this.desktopPane.setVisible(true);
            if (this.frame instanceof JFrame) {
                ((JFrame)this.frame).getContentPane().add((Component)this.desktopPane, "Center");
            } else {
                this.frame.add((Component)this.desktopPane, "Center");
            }
        }
    }

    public JComponent getDisplayPane() {
        return this.displayPane;
    }

    public JDesktopPane getMultiViewerFrames() {
        return this.desktopPane;
    }

    public void setPdfDecoder(PdfDecoder decode_pdf) {
        this.decode_pdf = decode_pdf;
    }

    public void closeMultiViewerWindow(String selectedFile) {
        JInternalFrame[] allFrames;
        for (JInternalFrame internalFrame : allFrames = this.desktopPane.getAllFrames()) {
            if (!internalFrame.getTitle().equals(selectedFile)) continue;
            try {
                internalFrame.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
            break;
        }
    }

    public int AdjustForAlignment(int cx) {
        if (this.decode_pdf.getPageAlignment() == 2) {
            int width = this.decode_pdf.getBounds().width;
            int pdfWidth = this.decode_pdf.getPDFWidth();
            if (this.decode_pdf.getDisplayView() != 1) {
                pdfWidth = (int)this.decode_pdf.getMaximumSize().getWidth();
            }
            if (width > pdfWidth) {
                cx -= (width - pdfWidth) / 2;
            }
        }
        return cx;
    }

    public String getBookmark(String bookmark) {
        return this.tree.getPage(bookmark);
    }

    public void reinitialiseTabs(boolean showVisible) {
        if (this.commonValues.getModeOfOperation() == 4) {
            return;
        }
        if (this.properties.getValue("ShowSidetabbar").toLowerCase().equals("true")) {
            if (!this.isSingle) {
                return;
            }
            if (!showVisible) {
                this.displayPane.setDividerLocation(startSize);
            }
            this.lastTabSelected = -1;
            if (!this.commonValues.isPDF()) {
                this.navOptionsPanel.setVisible(false);
            } else {
                int outlineTab;
                this.navOptionsPanel.setVisible(true);
                if (!this.decode_pdf.hasOutline()) {
                    int jj;
                    outlineTab = -1;
                    if (DecoderOptions.isRunningOnMac) {
                        for (jj = 0; jj < this.navOptionsPanel.getTabCount(); ++jj) {
                            if (!this.navOptionsPanel.getTitleAt(jj).equals(this.bookmarksTitle)) continue;
                            outlineTab = jj;
                        }
                    } else {
                        for (jj = 0; jj < this.navOptionsPanel.getTabCount(); ++jj) {
                            if (!this.navOptionsPanel.getIconAt(jj).toString().equals(this.bookmarksTitle)) continue;
                            outlineTab = jj;
                        }
                    }
                    if (outlineTab != -1) {
                        this.navOptionsPanel.remove(outlineTab);
                    }
                } else if (this.properties.getValue("Bookmarkstab").toLowerCase().equals("true")) {
                    outlineTab = -1;
                    if (DecoderOptions.isRunningOnMac) {
                        for (int jj = 0; jj < this.navOptionsPanel.getTabCount(); ++jj) {
                            if (!this.navOptionsPanel.getTitleAt(jj).equals(this.bookmarksTitle)) continue;
                            outlineTab = jj;
                        }
                        if (outlineTab == -1) {
                            this.navOptionsPanel.addTab(this.bookmarksTitle, (SwingOutline)this.tree);
                        }
                    } else {
                        for (int jj = 0; jj < this.navOptionsPanel.getTabCount(); ++jj) {
                            if (!this.navOptionsPanel.getIconAt(jj).toString().equals(this.bookmarksTitle)) continue;
                            outlineTab = jj;
                        }
                        if (outlineTab == -1) {
                            VTextIcon textIcon2 = new VTextIcon(this.navOptionsPanel, this.bookmarksTitle, 2);
                            this.navOptionsPanel.addTab(null, textIcon2, (SwingOutline)this.tree);
                        }
                    }
                }
                AcroRenderer currentFormRenderer = this.decode_pdf.getFormRenderer();
                Iterator signatureObjects = currentFormRenderer.getSignatureObjects();
                if (signatureObjects != null) {
                    DefaultMutableTreeNode root = new DefaultMutableTreeNode("Signatures");
                    DefaultMutableTreeNode signed = new DefaultMutableTreeNode("The following have digitally counter-signed this document");
                    DefaultMutableTreeNode blank = new DefaultMutableTreeNode("The following signature fields are not signed");
                    while (signatureObjects.hasNext()) {
                        FormObject formObj = (FormObject)signatureObjects.next();
                        PdfObject sigObject = formObj.getDictionary(38);
                        this.decode_pdf.getIO().checkResolved(formObj);
                        if (sigObject == null) {
                            if (!blank.isNodeChild(root)) {
                                root.add(blank);
                            }
                            DefaultMutableTreeNode blankNode = new DefaultMutableTreeNode(formObj.getTextStreamValue(36) + " on page " + formObj.getPageNumber());
                            blank.add(blankNode);
                            continue;
                        }
                        if (!signed.isNodeChild(root)) {
                            root.add(signed);
                        }
                        String name = sigObject.getTextStreamValue(506543413);
                        DefaultMutableTreeNode owner = new DefaultMutableTreeNode("Signed by " + name);
                        signed.add(owner);
                        DefaultMutableTreeNode type = new DefaultMutableTreeNode("Type");
                        owner.add(type);
                        String filter = null;
                        PdfArrayIterator filters = sigObject.getMixedArray(1011108731);
                        if (filters != null && filters.hasMoreTokens()) {
                            filter = filters.getNextValueAsString(true);
                        }
                        DefaultMutableTreeNode filterNode = new DefaultMutableTreeNode("Filter: " + filter);
                        type.add(filterNode);
                        String subFilter = sigObject.getName(-2122953826);
                        DefaultMutableTreeNode subFilterNode = new DefaultMutableTreeNode("Sub Filter: " + subFilter);
                        type.add(subFilterNode);
                        DefaultMutableTreeNode details = new DefaultMutableTreeNode("Details");
                        owner.add(details);
                        String rawDate = sigObject.getTextStreamValue(29);
                        StringBuilder date = new StringBuilder(rawDate);
                        date.delete(0, 2);
                        date.insert(4, '/');
                        date.insert(7, '/');
                        date.insert(10, ' ');
                        date.insert(13, ':');
                        date.insert(16, ':');
                        date.insert(19, ' ');
                        DefaultMutableTreeNode time = new DefaultMutableTreeNode("Time: " + date);
                        details.add(time);
                        String reason = sigObject.getTextStreamValue(826499443);
                        DefaultMutableTreeNode reasonNode = new DefaultMutableTreeNode("Reason: " + reason);
                        details.add(reasonNode);
                        String location = sigObject.getTextStreamValue(1618506351);
                        DefaultMutableTreeNode locationNode = new DefaultMutableTreeNode("Location: " + location);
                        details.add(locationNode);
                        DefaultMutableTreeNode field = new DefaultMutableTreeNode("Field: " + formObj.getTextStreamValue(36) + " on page " + formObj.getPageNumber());
                        details.add(field);
                    }
                    if (this.signaturesTree == null) {
                        this.signaturesTree = new JTree();
                        SignaturesTreeCellRenderer treeCellRenderer = new SignaturesTreeCellRenderer();
                        this.signaturesTree.setCellRenderer(treeCellRenderer);
                    }
                    ((DefaultTreeModel)this.signaturesTree.getModel()).setRoot(root);
                    this.checkTabShown(this.signaturesTitle);
                } else {
                    this.removeTab(this.signaturesTitle);
                }
                this.layersObject = (PdfLayerList)this.decode_pdf.getJPedalObject(826881374);
                if (this.layersObject != null && this.layersObject.getLayersCount() > 0) {
                    this.layersPanel.removeAll();
                    this.layersPanel.setLayout(new BorderLayout());
                    this.checkTabShown(this.layersTitle);
                    DefaultMutableTreeNode top = new DefaultMutableTreeNode("Info");
                    Map metaData = this.layersObject.getMetaData();
                    for (Object nextKey : metaData.keySet()) {
                        Object value = metaData.get(nextKey);
                        top.add(new DefaultMutableTreeNode(nextKey + "=" + value));
                    }
                    JTree infoTree = new JTree(top);
                    infoTree.setToolTipText("Double click to see any metadata");
                    infoTree.setRootVisible(true);
                    infoTree.collapseRow(0);
                    this.layersPanel.add((Component)infoTree, "North");
                    Object[] layerNames = this.layersObject.getDisplayTree();
                    if (layerNames != null) {
                        this.topLayer.removeAllChildren();
                        final JTree layersTree = new JTree(this.topLayer);
                        layersTree.setName("LayersTree");
                        layersTree.addTreeSelectionListener(new TreeSelectionListener(){

                            @Override
                            public void valueChanged(TreeSelectionEvent e) {
                                final DefaultMutableTreeNode node = (DefaultMutableTreeNode)layersTree.getLastSelectedPathComponent();
                                if (node == null) {
                                    return;
                                }
                                String rawName = (String)node.getUserObject();
                                Object[] patentNames = ((DefaultMutableTreeNode)node.getParent()).getUserObjectPath();
                                int size = patentNames.length;
                                for (int jj = size - 1; jj > 0; --jj) {
                                    rawName = rawName + PdfLayerList.deliminator + patentNames[jj].toString();
                                }
                                final String name = rawName;
                                if (SwingGUI.this.layersObject.isLayerName(name) && !SwingGUI.this.layersObject.isLocked(name)) {
                                    Runnable updateAComponent = new Runnable(){

                                        @Override
                                        public void run() {
                                            SwingGUI.this.decode_pdf.setCursor(Cursor.getPredefinedCursor(3));
                                            SwingGUI.this.decode_pdf.invalidate();
                                            SwingGUI.this.decode_pdf.updateUI();
                                            SwingGUI.this.decode_pdf.validate();
                                            SwingGUI.this.scrollPane.invalidate();
                                            SwingGUI.this.scrollPane.updateUI();
                                            SwingGUI.this.scrollPane.validate();
                                            CheckNode checkNode = (CheckNode)node;
                                            if (!checkNode.isEnabled()) {
                                                checkNode.setSelected(checkNode.isSelected());
                                                ShowGUIMessage.showstaticGUIMessage(new StringBuffer("This layer has been disabled because its parent layer is disabled"), "Parent Layer disabled");
                                            } else {
                                                boolean reversedStatus = !checkNode.isSelected();
                                                checkNode.setSelected(reversedStatus);
                                                SwingGUI.this.layersObject.setVisiblity(name, reversedStatus);
                                                SwingGUI.this.syncTreeDisplay(SwingGUI.this.topLayer, true);
                                                try {
                                                    SwingGUI.this.decode_pdf.decodePage(SwingGUI.this.commonValues.getCurrentPage());
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                            layersTree.invalidate();
                                            layersTree.clearSelection();
                                            layersTree.repaint();
                                            SwingGUI.this.decode_pdf.setCursor(Cursor.getPredefinedCursor(0));
                                        }
                                    };
                                    SwingUtilities.invokeLater(updateAComponent);
                                }
                            }
                        });
                        this.topLayer.removeAllChildren();
                        this.addLayersToTree(layerNames, this.topLayer, true);
                        layersTree.setRootVisible(true);
                        layersTree.expandRow(0);
                        layersTree.setCellRenderer(new CheckRenderer());
                        layersTree.getSelectionModel().setSelectionMode(1);
                        this.layersPanel.add((Component)layersTree, "Center");
                    }
                } else {
                    this.removeTab(this.layersTitle);
                }
                this.setBookmarks(false);
            }
            int orig = this.displayPane.getDividerLocation();
            this.displayPane.setDividerLocation(0);
            this.displayPane.validate();
            this.displayPane.setDividerLocation(orig);
        }
    }

    private void syncTreeDisplay(DefaultMutableTreeNode topLayer, boolean isEnabled) {
        int count = topLayer.getChildCount();
        boolean parentIsEnabled = isEnabled;
        String childName = "";
        int ii = 0;
        do {
            CheckNode cc;
            isEnabled = parentIsEnabled;
            boolean isSelected = true;
            TreeNode childNode = count == 0 ? topLayer : topLayer.getChildAt(ii);
            if (childNode instanceof CheckNode && this.layersObject.isLayerName(childName = (String)(cc = (CheckNode)childNode).getText())) {
                if (isEnabled) {
                    isEnabled = !this.layersObject.isLocked(childName);
                }
                isSelected = this.layersObject.isVisible(childName);
                cc.setSelected(isSelected);
                cc.setEnabled(isEnabled);
            }
            if (childNode.getChildCount() <= 0) continue;
            Enumeration<? extends TreeNode> children = childNode.children();
            while (children.hasMoreElements()) {
                this.syncTreeDisplay((DefaultMutableTreeNode)children.nextElement(), isEnabled && isSelected);
            }
        } while (++ii < count);
    }

    private void addLayersToTree(Object[] layerNames, DefaultMutableTreeNode topLayer, boolean isEnabled) {
        DefaultMutableTreeNode currentNode = topLayer;
        boolean parentEnabled = isEnabled;
        boolean parentIsSelected = true;
        for (Object layerName : layerNames) {
            if (layerName instanceof Object[]) {
                DefaultMutableTreeNode oldNode = currentNode;
                this.addLayersToTree((Object[])layerName, currentNode, isEnabled && parentIsSelected);
                currentNode = oldNode;
                isEnabled = parentEnabled;
                continue;
            }
            parentEnabled = isEnabled;
            if (layerName == null) continue;
            String name = layerName instanceof String ? (String)layerName : new String((byte[])layerName);
            String title = name;
            int ptr = name.indexOf(PdfLayerList.deliminator);
            if (ptr != -1) {
                title = title.substring(0, ptr);
            }
            if (name.endsWith(" R")) continue;
            if (!this.layersObject.isLayerName(name)) {
                currentNode = new DefaultMutableTreeNode(title);
                topLayer.add(currentNode);
                topLayer = currentNode;
                parentIsSelected = true;
                continue;
            }
            if (topLayer == null) continue;
            currentNode = new CheckNode(title);
            topLayer.add(currentNode);
            if (this.layersObject.isVisible(name)) {
                ((CheckNode)currentNode).setSelected(true);
                parentIsSelected = true;
            } else {
                parentIsSelected = false;
            }
            if (isEnabled) {
                isEnabled = !this.layersObject.isLocked(name);
            }
            ((CheckNode)currentNode).setEnabled(isEnabled);
        }
    }

    private void checkTabShown(String title) {
        int outlineTab = -1;
        if (DecoderOptions.isRunningOnMac) {
            for (int jj = 0; jj < this.navOptionsPanel.getTabCount(); ++jj) {
                if (!this.navOptionsPanel.getTitleAt(jj).equals(title)) continue;
                outlineTab = jj;
            }
            if (outlineTab == -1) {
                if (title.equals(this.signaturesTitle) && this.properties.getValue("Signaturestab").toLowerCase().equals("true")) {
                    if (this.signaturesTree == null) {
                        this.signaturesTree = new JTree();
                        SignaturesTreeCellRenderer treeCellRenderer = new SignaturesTreeCellRenderer();
                        this.signaturesTree.setCellRenderer(treeCellRenderer);
                    }
                    this.navOptionsPanel.addTab(this.signaturesTitle, this.signaturesTree);
                    this.navOptionsPanel.setTitleAt(this.navOptionsPanel.getTabCount() - 1, this.signaturesTitle);
                } else if (title.equals(this.layersTitle) && this.properties.getValue("Layerstab").toLowerCase().equals("true")) {
                    JScrollPane scrollPane = new JScrollPane();
                    scrollPane.getViewport().add(this.layersPanel);
                    scrollPane.setVerticalScrollBarPolicy(20);
                    scrollPane.setHorizontalScrollBarPolicy(30);
                    this.navOptionsPanel.addTab(this.layersTitle, scrollPane);
                    this.navOptionsPanel.setTitleAt(this.navOptionsPanel.getTabCount() - 1, this.layersTitle);
                }
            }
        } else {
            for (int jj = 0; jj < this.navOptionsPanel.getTabCount(); ++jj) {
                if (!this.navOptionsPanel.getIconAt(jj).toString().equals(title)) continue;
                outlineTab = jj;
            }
            if (outlineTab == -1) {
                if (title.equals(this.signaturesTitle) && this.properties.getValue("Signaturestab").toLowerCase().equals("true")) {
                    VTextIcon textIcon2 = new VTextIcon(this.navOptionsPanel, this.signaturesTitle, 2);
                    this.navOptionsPanel.addTab(null, textIcon2, this.signaturesTree);
                } else if (title.equals(this.layersTitle) && this.properties.getValue("Layerstab").toLowerCase().equals("true")) {
                    VTextIcon textIcon = new VTextIcon(this.navOptionsPanel, this.layersTitle, 2);
                    JScrollPane scrollPane = new JScrollPane();
                    scrollPane.getViewport().add(this.layersPanel);
                    scrollPane.setVerticalScrollBarPolicy(20);
                    scrollPane.setHorizontalScrollBarPolicy(30);
                    this.navOptionsPanel.addTab(null, textIcon, scrollPane);
                }
            }
        }
    }

    private void removeTab(String title) {
        int outlineTab = -1;
        if (DecoderOptions.isRunningOnMac) {
            for (int jj = 0; jj < this.navOptionsPanel.getTabCount(); ++jj) {
                if (!this.navOptionsPanel.getTitleAt(jj).equals(title)) continue;
                outlineTab = jj;
            }
        } else {
            for (int jj = 0; jj < this.navOptionsPanel.getTabCount(); ++jj) {
                if (!this.navOptionsPanel.getIconAt(jj).toString().equals(title)) continue;
                outlineTab = jj;
            }
        }
        if (outlineTab != -1) {
            this.navOptionsPanel.remove(outlineTab);
        }
    }

    public void stopThumbnails() {
        if (!this.isSingle) {
            return;
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.terminateDrawing();
            this.thumbnails.removeAllListeners();
        }
    }

    public void reinitThumbnails() {
        this.isSetup = false;
    }

    @Override
    public void resetNavBar() {
        if (!this.properties.getValue("consistentTabBar").toLowerCase().equals("true")) {
            if (!this.isSingle) {
                return;
            }
            this.displayPane.setDividerLocation(startSize);
            this.tabsNotInitialised = true;
            this.topLayer.removeAllChildren();
            this.setPageLayoutButtonsEnabled(false);
        }
    }

    @Override
    public void setNoPagesDecoded() {
        this.bookmarksGenerated = false;
        this.resetNavBar();
        if (this.scrollListener != null) {
            this.scrollListener.lastImage = null;
        }
        this.pagesDecoded.clear();
    }

    public void setBackNavigationButtonsEnabled(boolean flag) {
        this.back.setEnabled(flag);
        this.first.setEnabled(flag);
        this.fback.setEnabled(flag);
    }

    public void setForwardNavigationButtonsEnabled(boolean flag) {
        this.forward.setEnabled(flag);
        this.end.setEnabled(flag);
        this.fforward.setEnabled(flag);
    }

    public void setPageLayoutButtonsEnabled(boolean flag) {
        if (!this.isSingle) {
            return;
        }
        this.continuousButton.setEnabled(flag);
        this.continuousFacingButton.setEnabled(flag);
        this.facingButton.setEnabled(flag);
        this.pageFlowButton.setEnabled(flag);
        Enumeration<AbstractButton> menuOptions = this.layoutGroup.getElements();
        if (menuOptions.hasMoreElements()) {
            ((JMenuItem)menuOptions.nextElement()).setEnabled(true);
            while (menuOptions.hasMoreElements()) {
                ((JMenuItem)menuOptions.nextElement()).setEnabled(flag);
            }
        }
    }

    public void setSearchLayoutButtonsEnabled() {
        Enumeration<AbstractButton> menuOptions = this.searchLayoutGroup.getElements();
        ((JMenuItem)menuOptions.nextElement()).setEnabled(true);
        while (menuOptions.hasMoreElements()) {
            ((JMenuItem)menuOptions.nextElement()).setEnabled(true);
        }
    }

    public void alignLayoutMenuOption(int mode) {
        Enumeration<AbstractButton> menuOptions = this.layoutGroup.getElements();
        for (int i = 1; menuOptions.hasMoreElements() && i != mode; ++i) {
            menuOptions.nextElement();
        }
        ((JMenuItem)menuOptions.nextElement()).setSelected(true);
    }

    public void setDisplayMode(Integer mode) {
        if (mode.equals(GUIFactory.MULTIPAGE)) {
            this.isSingle = false;
        }
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public Object getThumbnailPanel() {
        return this.thumbnails;
    }

    public Object getOutlinePanel() {
        return this.tree;
    }

    public JScrollBar getVerticalScrollBar() {
        if (this.scrollPane.getVerticalScrollBar().isVisible()) {
            return this.scrollPane.getVerticalScrollBar();
        }
        return this.thumbscroll;
    }

    @Override
    public void initLayoutMenus(JMenu pageLayout, String[] descriptions, int[] value) {
        int count = value.length;
        block6: for (int i = 0; i < count; ++i) {
            JCheckBoxMenuItem pageView = new JCheckBoxMenuItem(descriptions[i]);
            pageView.setBorder(BorderFactory.createEmptyBorder());
            this.layoutGroup.add(pageView);
            if (i == 0) {
                pageView.setSelected(true);
            }
            if (pageLayout == null) continue;
            switch (value[i]) {
                case 1: {
                    this.single = pageView;
                    this.single.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SwingGUI.this.currentCommands.executeCommand(57, null);
                        }
                    });
                    pageLayout.add(this.single);
                    continue block6;
                }
                case 2: {
                    this.continuous = pageView;
                    this.continuous.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SwingGUI.this.currentCommands.executeCommand(58, null);
                        }
                    });
                    pageLayout.add(this.continuous);
                    continue block6;
                }
                case 3: {
                    this.facing = pageView;
                    this.facing.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SwingGUI.this.currentCommands.executeCommand(60, null);
                        }
                    });
                    pageLayout.add(this.facing);
                    continue block6;
                }
                case 4: {
                    this.continuousFacing = pageView;
                    this.continuousFacing.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SwingGUI.this.currentCommands.executeCommand(59, null);
                        }
                    });
                    pageLayout.add(this.continuousFacing);
                }
            }
        }
        if (!this.isSingle) {
            return;
        }
        this.setPageLayoutButtonsEnabled(false);
    }

    private static JScrollPane getFontsAliasesInfoBox() {
        JPanel details = new JPanel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(400, 300));
        scrollPane.getViewport().add(details);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        details.setOpaque(true);
        details.setBackground(Color.white);
        details.setEnabled(false);
        details.setLayout(new BoxLayout(details, 3));
        StringBuilder fullList = new StringBuilder();
        for (String nextFont : FontMappings.fontSubstitutionAliasTable.keySet()) {
            fullList.append((Object)nextFont);
            fullList.append(" ==> ");
            fullList.append(FontMappings.fontSubstitutionAliasTable.get(nextFont));
            fullList.append('\n');
        }
        String xmlText = fullList.toString();
        if (xmlText.length() > 0) {
            JTextArea xml = new JTextArea();
            xml.setLineWrap(false);
            xml.setText(xmlText);
            details.add(xml);
            xml.setCaretPosition(0);
            xml.setOpaque(false);
            details.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        return scrollPane;
    }

    private JPanel getFontsFoundInfoBox() {
        JPanel fontDetails = new JPanel(new BorderLayout());
        fontDetails.setBackground(Color.WHITE);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.WHITE);
        this.fontScrollPane.setBackground(Color.WHITE);
        this.fontScrollPane.getViewport().setBackground(Color.WHITE);
        this.fontScrollPane.setPreferredSize(new Dimension(400, 300));
        this.fontScrollPane.getViewport().add(fontDetails);
        this.fontScrollPane.setVerticalScrollBarPolicy(20);
        this.fontScrollPane.setHorizontalScrollBarPolicy(30);
        JPanel filterTitlePane = new JPanel();
        filterTitlePane.setBackground(Color.WHITE);
        JLabel filterTitle = new JLabel("Filter Font List");
        filterTitlePane.add(filterTitle);
        ButtonGroup bg = new ButtonGroup();
        JRadioButton folder = new JRadioButton("Sort By Folder");
        folder.setBackground(Color.WHITE);
        JRadioButton name = new JRadioButton("Sort By Name");
        name.setBackground(Color.WHITE);
        final JTextField filter = new JTextField();
        if (this.sortFontsByDir) {
            folder.setSelected(true);
        } else {
            name.setSelected(true);
        }
        bg.add(folder);
        bg.add(name);
        JPanel buttons = new JPanel(new BorderLayout());
        buttons.setBackground(Color.WHITE);
        buttons.add((Component)filterTitlePane, "North");
        buttons.add((Component)folder, "West");
        buttons.add((Component)filter, "Center");
        buttons.add((Component)name, "East");
        folder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SwingGUI.this.sortFontsByDir) {
                    DefaultMutableTreeNode fontlist = new DefaultMutableTreeNode("Fonts");
                    SwingGUI.this.sortFontsByDir = true;
                    fontlist = SwingGUI.this.populateAvailableFonts(fontlist, filter.getText());
                    SwingGUI.this.displayAvailableFonts(fontlist);
                }
            }
        });
        name.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SwingGUI.this.sortFontsByDir) {
                    DefaultMutableTreeNode fontlist = new DefaultMutableTreeNode("Fonts");
                    SwingGUI.this.sortFontsByDir = false;
                    fontlist = SwingGUI.this.populateAvailableFonts(fontlist, filter.getText());
                    SwingGUI.this.displayAvailableFonts(fontlist);
                }
            }
        });
        filter.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DefaultMutableTreeNode fontlist = new DefaultMutableTreeNode("Fonts");
                SwingGUI.this.populateAvailableFonts(fontlist, ((JTextField)e.getSource()).getText());
                SwingGUI.this.displayAvailableFonts(fontlist);
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Fonts");
        top = this.populateAvailableFonts(top, null);
        JTree fontTree = new JTree(top);
        fontDetails.add((Component)fontTree, "West");
        panel.add((Component)buttons, "North");
        panel.add((Component)this.fontScrollPane, "Center");
        panel.setPreferredSize(new Dimension(400, 300));
        return panel;
    }

    private void displayAvailableFonts(DefaultMutableTreeNode fontlist) {
        this.fontScrollPane.getViewport().removeAll();
        JPanel jp = new JPanel(new BorderLayout());
        jp.setBackground(Color.WHITE);
        jp.add((Component)new JTree(fontlist), "West");
        this.fontScrollPane.getViewport().add(jp);
    }

    private DefaultMutableTreeNode populateAvailableFonts(DefaultMutableTreeNode top, String filter) {
        block10: {
            if (FontMappings.fontSubstitutionTable == null) break block10;
            Set<String> fonts = FontMappings.fontSubstitutionTable.keySet();
            Iterator<String> fontList = FontMappings.fontSubstitutionTable.keySet().iterator();
            int fontCount = fonts.size();
            ArrayList<String> fontNames = new ArrayList<String>(fontCount);
            while (fontList.hasNext()) {
                fontNames.add(fontList.next().toString());
            }
            Collections.sort(fontNames);
            if (this.sortFontsByDir) {
                ArrayList<String> Location2 = new ArrayList<String>();
                ArrayList<DefaultMutableTreeNode> LocationNode = new ArrayList<DefaultMutableTreeNode>();
                for (int ii = 0; ii < fontCount; ++ii) {
                    Object nextFont = fontNames.get(ii);
                    String current = FontMappings.fontSubstitutionLocation.get(nextFont);
                    int ptr = current.lastIndexOf(System.getProperty("file.separator"));
                    if (ptr == -1 && current.indexOf(47) != -1) {
                        ptr = current.lastIndexOf(47);
                    }
                    if (ptr != -1) {
                        current = current.substring(0, ptr);
                    }
                    if (filter != null && !((String)nextFont).toLowerCase().contains(filter.toLowerCase())) continue;
                    if (!Location2.contains(current)) {
                        Location2.add(current);
                        DefaultMutableTreeNode loc = new DefaultMutableTreeNode(new DefaultMutableTreeNode(current));
                        top.add(loc);
                        LocationNode.add(loc);
                    }
                    DefaultMutableTreeNode FontTop = new DefaultMutableTreeNode(nextFont + " = " + FontMappings.fontSubstitutionLocation.get(nextFont));
                    int pos = Location2.indexOf(current);
                    ((DefaultMutableTreeNode)LocationNode.get(pos)).add(FontTop);
                    String loc = (String)FontMappings.fontPropertiesTable.get(nextFont + "_path");
                    Integer type = (Integer)FontMappings.fontPropertiesTable.get(nextFont + "_type");
                    Map properties = StandardFonts.getFontDetails(type, loc);
                    if (properties == null) continue;
                    for (Object key : properties.keySet()) {
                        Object value = properties.get(key);
                        DefaultMutableTreeNode FontDetails = new DefaultMutableTreeNode(key + " = " + value);
                        FontTop.add(FontDetails);
                    }
                }
            } else {
                for (int ii = 0; ii < fontCount; ++ii) {
                    Object nextFont = fontNames.get(ii);
                    if (filter != null && !((String)nextFont).toLowerCase().contains(filter.toLowerCase())) continue;
                    DefaultMutableTreeNode FontTop = new DefaultMutableTreeNode(nextFont + " = " + FontMappings.fontSubstitutionLocation.get(nextFont));
                    top.add(FontTop);
                    Map properties = (Map)FontMappings.fontPropertiesTable.get(nextFont);
                    if (properties == null) continue;
                    for (Object key : properties.keySet()) {
                        Object value = properties.get(key);
                        DefaultMutableTreeNode FontDetails = new DefaultMutableTreeNode(key + " = " + value);
                        FontTop.add(FontDetails);
                    }
                }
            }
        }
        return top;
    }

    private JScrollPane getFontInfoBox() {
        JPanel details = new JPanel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(400, 300));
        scrollPane.getViewport().add(details);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        details.setOpaque(true);
        details.setBackground(Color.white);
        details.setEnabled(false);
        details.setLayout(new BoxLayout(details, 3));
        String xmlTxt = this.decode_pdf.getInfo(373243460);
        String xmlText = "Font Substitution mode: ";
        switch (FontMappings.getFontSubstitutionMode()) {
            case 1: {
                xmlText = xmlText + "using file name";
                break;
            }
            case 2: {
                xmlText = xmlText + "using PostScript name";
                break;
            }
            case 3: {
                xmlText = xmlText + "using family name";
                break;
            }
            case 4: {
                xmlText = xmlText + "using the full font name";
                break;
            }
            default: {
                xmlText = xmlText + "Unknown FontSubstitutionMode";
            }
        }
        xmlText = xmlText + '\n';
        if (xmlTxt.length() > 0) {
            JTextArea xml = new JTextArea();
            JLabel mode = new JLabel();
            mode.setAlignmentX(0.5f);
            mode.setText(xmlText);
            mode.setForeground(Color.BLUE);
            xml.setLineWrap(false);
            xml.setForeground(Color.BLACK);
            xml.setText('\n' + xmlTxt);
            details.add(mode);
            details.add(xml);
            xml.setCaretPosition(0);
            xml.setOpaque(false);
        }
        return scrollPane;
    }

    private JScrollPane getImageInfoBox() {
        JPanel details = new JPanel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(400, 300));
        scrollPane.getViewport().add(details);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        details.setOpaque(true);
        details.setBackground(Color.white);
        details.setEnabled(false);
        details.setLayout(new BoxLayout(details, 3));
        String xmlTxt = this.decode_pdf.getInfo(1026635598);
        if (xmlTxt.length() > 0) {
            JTextArea xml = new JTextArea();
            xml.setLineWrap(false);
            xml.setForeground(Color.BLACK);
            xml.setText('\n' + xmlTxt);
            details.add(xml);
            xml.setCaretPosition(0);
            xml.setOpaque(false);
        }
        return scrollPane;
    }

    @Override
    public void getInfoBox() {
        final JPanel details = new JPanel();
        details.setPreferredSize(new Dimension(400, 260));
        details.setOpaque(false);
        details.setLayout(new BoxLayout(details, 1));
        JLabel header1 = new JLabel(Messages.getMessage("PdfViewerInfo.title"));
        header1.setOpaque(false);
        header1.setFont(this.headFont);
        header1.setAlignmentX(0.5f);
        details.add(header1);
        details.add(Box.createRigidArea(new Dimension(0, 15)));
        String xmlText = Messages.getMessage("PdfViewerInfo1");
        if (xmlText.length() > 0) {
            JTextArea xml = new JTextArea();
            xml.setFont(this.textFont1);
            xml.setOpaque(false);
            xml.setText(xmlText + "\n\nVersions\n JPedal: " + "4.92b23-OS" + "          Java: " + System.getProperty("java.version"));
            xml.setLineWrap(true);
            xml.setWrapStyleWord(true);
            xml.setEditable(false);
            details.add(xml);
            xml.setAlignmentX(0.5f);
        }
        ImageIcon logo = new ImageIcon(this.getClass().getResource("/org/jpedal/examples/viewer/res/logo.gif"));
        details.add(Box.createRigidArea(new Dimension(0, 25)));
        JLabel idr = new JLabel(logo);
        idr.setAlignmentX(0.5f);
        details.add(idr);
        final JLabel url = new JLabel("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress"));
        url.setForeground(Color.blue);
        url.setHorizontalAlignment(0);
        url.setAlignmentX(0.5f);
        url.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SingleDisplay.allowChangeCursor) {
                    details.setCursor(new Cursor(12));
                }
                url.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Link") + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress") + "</a></center>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (SingleDisplay.allowChangeCursor) {
                    details.setCursor(new Cursor(0));
                }
                url.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress"));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    BrowserLauncher.openURL(Messages.getMessage("PdfViewer.VisitWebsite"));
                }
                catch (IOException e1) {
                    SwingGUI.this.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        details.add(url);
        details.add(Box.createRigidArea(new Dimension(0, 5)));
        details.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.showMessageDialog((Object)details, Messages.getMessage("PdfViewerInfo3"), -1);
    }

    @Override
    public void resetRotationBox() {
        PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
        if (this.decode_pdf.getDisplayView() == 1) {
            this.rotation = currentPageData.getRotation(this.commonValues.getCurrentPage());
        }
        if (this.getSelectedComboIndex(251) != this.rotation / 90) {
            this.setSelectedComboIndex(251, this.rotation / 90);
        } else if (!Values.isProcessing()) {
            this.decode_pdf.repaint();
        }
    }

    private JScrollPane getPropertiesBox(String file, String path, String user_dir, long size, int pageCount, int currentPage) {
        PdfFileInformation currentFileInformation = this.decode_pdf.getFileInformationData();
        if (currentFileInformation != null) {
            JPanel details = new JPanel();
            details.setOpaque(true);
            details.setBackground(Color.white);
            details.setLayout(new BoxLayout(details, 1));
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setPreferredSize(new Dimension(400, 300));
            scrollPane.getViewport().add(details);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            JLabel header1 = new JLabel(Messages.getMessage("PdfViewerGeneral"));
            header1.setFont(this.headFont);
            header1.setOpaque(false);
            details.add(header1);
            JLabel g1 = new JLabel(Messages.getMessage("PdfViewerFileName") + file);
            g1.setFont(this.textFont);
            g1.setOpaque(false);
            details.add(g1);
            JLabel g2 = new JLabel(Messages.getMessage("PdfViewerFilePath") + path);
            g2.setFont(this.textFont);
            g2.setOpaque(false);
            details.add(g2);
            JLabel g3 = new JLabel(Messages.getMessage("PdfViewerCurrentWorkingDir") + ' ' + user_dir);
            g3.setFont(this.textFont);
            g3.setOpaque(false);
            details.add(g3);
            JLabel g4 = new JLabel(Messages.getMessage("PdfViewerFileSize") + size + " K");
            g4.setFont(this.textFont);
            g4.setOpaque(false);
            details.add(g4);
            JLabel g5 = new JLabel(Messages.getMessage("PdfViewerPageCount") + pageCount);
            g5.setOpaque(false);
            g5.setFont(this.textFont);
            details.add(g5);
            String g6Text = "PDF " + this.decode_pdf.getPDFVersion();
            if (this.decode_pdf.getJPedalObject(2004845231) != null) {
                g6Text = g6Text + " (" + Messages.getMessage("PdfViewerLinearized.text") + ") ";
            }
            JLabel g6 = new JLabel(g6Text);
            g6.setOpaque(false);
            g6.setFont(this.textFont);
            details.add(g6);
            details.add(Box.createVerticalStrut(10));
            JLabel header2 = new JLabel(Messages.getMessage("PdfViewerProperties"));
            header2.setFont(this.headFont);
            header2.setOpaque(false);
            details.add(header2);
            String[] values = currentFileInformation.getFieldValues();
            String[] fields = PdfFileInformation.getFieldNames();
            int count = fields.length;
            JLabel[] displayValues = new JLabel[count];
            for (int i = 0; i < count; ++i) {
                if (values[i].length() <= 0) continue;
                displayValues[i] = new JLabel(fields[i] + " = " + values[i]);
                displayValues[i].setFont(this.textFont);
                displayValues[i].setOpaque(false);
                details.add(displayValues[i]);
            }
            details.add(Box.createVerticalStrut(10));
            PdfPageData currentPageSize = this.decode_pdf.getPdfPageData();
            if (currentPageSize != null) {
                JLabel header3 = new JLabel(Messages.getMessage("PdfViewerCoords.text"));
                header3.setFont(this.headFont);
                details.add(header3);
                JLabel g7 = new JLabel(Messages.getMessage("PdfViewermediaBox.text") + currentPageSize.getMediaValue(currentPage));
                g7.setFont(this.textFont);
                details.add(g7);
                JLabel g8 = new JLabel(Messages.getMessage("PdfViewercropBox.text") + currentPageSize.getCropValue(currentPage));
                g8.setFont(this.textFont);
                details.add(g8);
                JLabel g9 = new JLabel(Messages.getMessage("PdfViewerLabel.Rotation") + currentPageSize.getRotation(currentPage));
                g9.setFont(this.textFont);
                details.add(g9);
            }
            details.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            return scrollPane;
        }
        return new JScrollPane();
    }

    private static JScrollPane getXMLInfoBox(String xmlText) {
        JPanel details = new JPanel();
        details.setLayout(new BoxLayout(details, 3));
        details.setOpaque(true);
        details.setBackground(Color.white);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(400, 300));
        scrollPane.getViewport().add(details);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        JTextArea xml = new JTextArea();
        xml.setRows(5);
        xml.setColumns(15);
        xml.setLineWrap(true);
        xml.setText(xmlText);
        details.add(new JScrollPane(xml));
        xml.setCaretPosition(0);
        xml.setOpaque(true);
        xml.setBackground(Color.white);
        return scrollPane;
    }

    @Override
    public void showDocumentProperties(String selectedFile, String inputDir, long size, int pageCount, int currentPage) {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBackground(Color.WHITE);
        if (selectedFile == null) {
            this.showMessageDialog((Object)Messages.getMessage("PdfVieweremptyFile.message"), Messages.getMessage("PdfViewerTooltip.pageSize"), -1);
        } else {
            PdfFileInformation currentFileInformation;
            String xmlText;
            String filename = selectedFile;
            int ptr = filename.lastIndexOf(92);
            if (ptr == -1) {
                ptr = filename.lastIndexOf(47);
            }
            String file = filename.substring(ptr + 1, filename.length());
            String path = filename.substring(0, ptr + 1);
            int ii = 0;
            tabbedPane.add(this.getPropertiesBox(file, path, this.user_dir, size, pageCount, currentPage));
            tabbedPane.setTitleAt(ii++, Messages.getMessage("PdfViewerTab.Properties"));
            tabbedPane.add(this.getFontInfoBox());
            tabbedPane.setTitleAt(ii++, Messages.getMessage("PdfViewerTab.Fonts"));
            if (ImageCommands.trackImages) {
                tabbedPane.add(this.getImageInfoBox());
                tabbedPane.setTitleAt(ii++, Messages.getMessage("PdfViewerTab.Images"));
            }
            tabbedPane.add(this.getFontsFoundInfoBox());
            tabbedPane.setTitleAt(ii++, "Available");
            tabbedPane.add(SwingGUI.getFontsAliasesInfoBox());
            tabbedPane.setTitleAt(ii++, "Aliases");
            int nextTab = ii;
            JScrollPane scroll = this.getFormList();
            if (scroll != null) {
                tabbedPane.add(scroll);
                tabbedPane.setTitleAt(nextTab, "Forms");
                ++nextTab;
            }
            if ((xmlText = (currentFileInformation = this.decode_pdf.getFileInformationData()).getFileXMLMetaData()).length() > 0) {
                tabbedPane.add(SwingGUI.getXMLInfoBox(xmlText));
                tabbedPane.setTitleAt(nextTab, "XML");
            }
            this.showMessageDialog((Object)tabbedPane, Messages.getMessage("PdfViewerTab.DocumentProperties"), -1);
        }
    }

    private JScrollPane getFormList() {
        JScrollPane scroll = null;
        AcroRenderer formRenderer = this.decode_pdf.getFormRenderer();
        if (formRenderer != null) {
            List formsOnPage = null;
            try {
                formsOnPage = formRenderer.getComponentNameList(this.commonValues.getCurrentPage());
            }
            catch (PdfException e) {
                LogWriter.writeLog("Exception " + e + " reading component list");
            }
            if (formsOnPage != null) {
                int formCount = formsOnPage.size();
                JPanel formPanel = new JPanel();
                scroll = new JScrollPane();
                scroll.setPreferredSize(new Dimension(400, 300));
                scroll.getViewport().add(formPanel);
                scroll.setVerticalScrollBarPolicy(20);
                scroll.setHorizontalScrollBarPolicy(30);
                formPanel.setLayout(new BoxLayout(formPanel, 1));
                JLabel formHeader = new JLabel("This page contains " + formCount + " form objects");
                formHeader.setFont(this.headFont);
                formPanel.add(formHeader);
                formPanel.add(Box.createRigidArea(new Dimension(10, 10)));
                Collections.sort(formsOnPage);
                AcroRenderer renderer = this.decode_pdf.getFormRenderer();
                if (renderer == null) {
                    return scroll;
                }
                GUIData formData = renderer.getCompData();
                for (Object aFormsOnPage : formsOnPage) {
                    Object[] rawFormData;
                    String formName = (String)aFormsOnPage;
                    Component[] comp = (Component[])formRenderer.getComponentsByName(formName);
                    if (comp == null) continue;
                    FormObject formObj = null;
                    String PDFrefs = "PDF ref=";
                    JLabel ref = new JLabel();
                    for (Object aRawFormData : rawFormData = formData.getRawForm(formName)) {
                        formObj = (FormObject)aRawFormData;
                        PDFrefs = PDFrefs + ' ' + formObj.getObjectRefAsString();
                    }
                    ref.setText(PDFrefs);
                    String formDescription = formName;
                    JLabel header = new JLabel(formDescription);
                    JLabel type = new JLabel();
                    type.setText("Type=" + PdfDictionary.showAsConstant(formObj.getParameterConstant(608780341)) + " Subtype=" + PdfDictionary.showAsConstant(formObj.getParameterConstant(1147962727)));
                    String standardDetails = "java class=" + comp[0].getClass();
                    JLabel details = new JLabel(standardDetails);
                    header.setFont(this.headFont);
                    header.setForeground(Color.blue);
                    type.setFont(this.textFont);
                    type.setForeground(Color.blue);
                    details.setFont(this.textFont);
                    details.setForeground(Color.blue);
                    ref.setFont(this.textFont);
                    ref.setForeground(Color.blue);
                    formPanel.add(header);
                    formPanel.add(type);
                    formPanel.add(details);
                    formPanel.add(ref);
                }
            }
        }
        return scroll;
    }

    public void searchInTab(GUISearchWindow searchFrame) {
        this.searchFrame = searchFrame;
        this.searchFrame.init(this.decode_pdf, this.commonValues);
        if (DecoderOptions.isRunningOnMac) {
            if (this.thumbnails.isShownOnscreen()) {
                this.navOptionsPanel.addTab("Search", searchFrame.getContentPanel());
            }
        } else {
            VTextIcon textIcon2 = new VTextIcon(this.navOptionsPanel, "Search", 2);
            this.navOptionsPanel.addTab(null, textIcon2, searchFrame.getContentPanel());
        }
        this.addSearchTab = true;
    }

    private JToggleButton createMenuBarSearchOptions() {
        if (this.options == null) {
            this.options = new JToggleButton(new ImageIcon(this.getURLForImage(this.iconLocation + "menuSearchOptions.png")));
            this.menu = new JPopupMenu();
            this.options.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        SwingGUI.this.menu.show((JComponent)e.getSource(), 0, ((JComponent)e.getSource()).getHeight());
                    }
                }
            });
            this.options.setFocusable(false);
            this.options.setToolTipText(Messages.getMessage("PdfViewerSearch.Options"));
            JCheckBoxMenuItem wholeWords = new JCheckBoxMenuItem(Messages.getMessage("PdfViewerSearch.WholeWords"));
            wholeWords.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingGUI.this.searchFrame.setWholeWords(((JCheckBoxMenuItem)e.getSource()).isSelected());
                }
            });
            JCheckBoxMenuItem caseSense = new JCheckBoxMenuItem(Messages.getMessage("PdfViewerSearch.CaseSense"));
            caseSense.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingGUI.this.searchFrame.setCaseSensitive(((JCheckBoxMenuItem)e.getSource()).isSelected());
                }
            });
            JCheckBoxMenuItem multiLine = new JCheckBoxMenuItem(Messages.getMessage("PdfViewerSearch.MultiLine"));
            multiLine.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingGUI.this.searchFrame.setMultiLine(((JCheckBoxMenuItem)e.getSource()).isSelected());
                }
            });
            this.menu.add(wholeWords);
            this.menu.add(caseSense);
            this.menu.add(multiLine);
            this.menu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    SwingGUI.this.options.setSelected(false);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    SwingGUI.this.options.setSelected(false);
                }
            });
        }
        return this.options;
    }

    public void searchInMenu(GUISearchWindow searchFrame) {
        this.searchFrame = searchFrame;
        this.searchInMenu = true;
        searchFrame.find(this.decode_pdf, this.commonValues);
        this.topButtons.add(this.searchText);
        this.topButtons.add(this.createMenuBarSearchOptions());
        this.addButton(0, Messages.getMessage("PdfViewerSearch.Previous"), this.iconLocation + "search_previous.gif", 18);
        this.addButton(0, Messages.getMessage("PdfViewerSearch.Next"), this.iconLocation + "search_next.gif", 19);
        this.nextSearch.setVisible(false);
        this.previousSearch.setVisible(false);
    }

    public Commands getCommand() {
        return this.currentCommands;
    }

    public void clearRecentDocuments() {
        this.currentCommands.clearRecentDocuments();
    }

    public void addPageChangeListener(DocumentListener docListener) {
        if (this.pageCounter2 != null) {
            this.pageCounter2.getDocument().addDocumentListener(docListener);
        }
    }

    @Override
    public void init(String[] scalingValues, final Object currentCommands, Object currentPrinter) {
        JSeparator sep;
        URL path;
        String propValue;
        this.customMessageHandler = (CustomMessageHandler)this.decode_pdf.getExternalHandler(15);
        if (this.customMessageHandler != null) {
            PdfDecoder.showErrorMessages = false;
            Viewer.showMessages = false;
        }
        try {
            String val;
            propValue = this.properties.getValue("pageInsets");
            if (propValue.length() > 0) {
                inset = Integer.parseInt(propValue);
            }
            propValue = this.properties.getValue("useHinting");
            String propValue2 = System.getProperty("org.jpedal.useTTFontHinting");
            if (propValue2 != null) {
                if (propValue.length() > 0 && !propValue2.toLowerCase().equals(propValue.toLowerCase())) {
                    JOptionPane.showMessageDialog(null, Messages.getMessage("PdfCustomGui.hintingFlagFileConflict"));
                }
                TTGlyph.useHinting = propValue2.toLowerCase().equals("true");
            } else {
                TTGlyph.useHinting = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            }
            propValue = this.properties.getValue("changeTextAndLineart");
            if (propValue.length() > 0 && propValue.toLowerCase().equals("true")) {
                ((Commands)currentCommands).executeCommand(713, new Object[]{Boolean.parseBoolean(propValue)});
            }
            if ((propValue = this.properties.getValue("vbgColor")).length() > 0) {
                ((Commands)currentCommands).executeCommand(709, new Object[]{Integer.parseInt(propValue)});
            }
            if ((propValue = this.properties.getValue("sbbgColor")).length() > 0) {
                // empty if block
            }
            if ((propValue = this.properties.getValue("replaceDocumentTextColors")).length() > 0 && propValue.toLowerCase().equals("true") && (propValue = this.properties.getValue("vfgColor")).length() > 0) {
                ((Commands)currentCommands).executeCommand(712, new Object[]{Integer.parseInt(propValue)});
            }
            if ((propValue = this.properties.getValue("TextColorThreshold")).length() > 0) {
                ((Commands)currentCommands).executeCommand(715, new Object[]{Integer.parseInt(propValue)});
            }
            if ((propValue = this.properties.getValue("iconLocation")).length() > 0) {
                this.iconLocation = propValue;
            }
            if ((propValue = this.properties.getValue("borderType")).length() > 0) {
                SingleDisplay.CURRENT_BORDER_STYLE = Integer.parseInt(propValue);
            }
            if ((propValue = this.properties.getValue("autoScroll")).length() > 0) {
                this.allowScrolling = Boolean.getBoolean(propValue);
            }
            if ((propValue = this.properties.getValue("confirmClose")).length() > 0) {
                this.confirmClose = propValue.equals("true");
            }
            if ((propValue = this.properties.getValue("resolution")).length() > 0) {
                this.decode_pdf.getDPIFactory().setDpi(Integer.parseInt(propValue));
            }
            if ((propValue = this.properties.getValue("allowCursorToChange")).length() > 0) {
                SingleDisplay.allowChangeCursor = propValue.toLowerCase().equals("true");
            }
            if ((propValue = this.properties.getValue("pageMode")).length() > 0) {
                int pageMode = Integer.parseInt(propValue);
                if (pageMode < 1 || pageMode > 5) {
                    pageMode = 1;
                }
                this.decode_pdf.setPageMode(pageMode);
            }
            if ((propValue = this.properties.getValue("maxmuliviewers")).length() > 0) {
                this.commonValues.setMaxMiltiViewers(Integer.parseInt(propValue));
            }
            if ((propValue = this.properties.getValue("showDownloadWindow")).length() > 0) {
                this.useDownloadWindow = Boolean.valueOf(propValue);
            }
            if ((propValue = this.properties.getValue("useHiResPrinting")).length() > 0) {
                this.hiResPrinting = Boolean.valueOf(propValue);
            }
            if ((val = this.properties.getValue("highlightBoxColor")).length() > 0) {
                DecoderOptions.highlightColor = new Color(Integer.parseInt(val));
            }
            if ((propValue = this.properties.getValue("highlightTextColor")).length() > 0) {
                DecoderOptions.backgroundColor = new Color(Integer.parseInt(propValue));
            }
            if ((propValue = this.properties.getValue("invertHighlights")).length() > 0) {
                BaseDisplay.invertHighlight = Boolean.valueOf(propValue);
            }
            if ((propValue = this.properties.getValue("showMouseSelectionBox")).length() > 0) {
                PdfDecoder.showMouseBox = Boolean.valueOf(propValue);
            }
            if ((propValue = this.properties.getValue("enhancedViewerMode")).length() > 0) {
                this.decode_pdf.useNewGraphicsMode = Boolean.valueOf(propValue);
            }
            if ((propValue = this.properties.getValue("enhancedFacingMode")).length() > 0) {
                SingleDisplay.default_turnoverOn = Boolean.valueOf(propValue);
            }
            if ((propValue = this.properties.getValue("enhancedGUI")).length() > 0) {
                this.useNewLayout = Boolean.valueOf(propValue);
            }
            if ((propValue = this.properties.getValue("highlightComposite")).length() > 0) {
                float value = Float.parseFloat(propValue);
                if (value > 1.0f) {
                    value = 1.0f;
                }
                if (value < 0.0f) {
                    value = 0.0f;
                }
                PdfDecoder.highlightComposite = value;
            }
            windowTitle = (propValue = this.properties.getValue("windowTitle")).length() > 0 ? propValue : Messages.getMessage("PdfViewer.titlebar") + ' ' + "4.92b23-OS";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.currentCommands = (Commands)currentCommands;
        this.currentCommandListener = new CommandListener((Commands)currentCommands);
        this.setViewerTitle(windowTitle);
        if (this.frame instanceof JFrame && (path = this.getURLForImage(this.iconLocation + "icon.png")) != null) {
            try {
                BufferedImage fontIcon = ImageIO.read(path);
                ((JFrame)this.frame).setIconImage(fontIcon);
            }
            catch (Exception fontIcon) {
                // empty catch block
            }
        }
        this.decode_pdf.setInset(inset, inset);
        propValue = this.properties.getValue("replacePdfDisplayBackground");
        if (propValue.length() > 0 && propValue.toLowerCase().equals("true")) {
            propValue = this.properties.getValue("pdfDisplayBackground");
            if (propValue.length() > 0) {
                ((Commands)currentCommands).executeCommand(714, new Object[]{Integer.parseInt(propValue)});
            }
            this.decode_pdf.setBackground(new Color(Integer.parseInt(propValue)));
        } else if (this.decode_pdf.getDecoderOptions().getDisplayBackgroundColor() != null) {
            this.decode_pdf.setBackground(this.decode_pdf.getDecoderOptions().getDisplayBackgroundColor());
        } else if (this.decode_pdf.useNewGraphicsMode) {
            this.decode_pdf.setBackground(new Color(55, 55, 65));
        } else {
            this.decode_pdf.setBackground(new Color(190, 190, 190));
        }
        String choosenScaling = System.getProperty("org.jpedal.defaultViewerScaling");
        if (choosenScaling != null) {
            int total = scalingValues.length;
            for (int aa = 0; aa < total; ++aa) {
                if (!scalingValues[aa].equals(choosenScaling)) continue;
                defaultSelection = aa;
                aa = total;
            }
        }
        this.scalingBox = new SwingCombo(scalingValues);
        this.scalingBox.setBackground(Color.white);
        this.scalingBox.setEditable(true);
        this.scalingBox.setSelectedIndex(defaultSelection);
        this.rotationBox = new SwingCombo(this.rotationValues);
        this.rotationBox.setBackground(Color.white);
        this.rotationBox.setSelectedIndex(0);
        JPanel containerForThumbnails = new JPanel();
        if (this.isSingle) {
            this.previewOnSingleScroll = this.properties.getValue("previewOnSingleScroll").toLowerCase().equals("true");
            if (this.previewOnSingleScroll) {
                this.thumbscroll = new JScrollBar(1, 0, 1, 0, 1);
                if (this.scrollListener == null) {
                    this.scrollListener = new ScrollListener();
                    this.scrollMouseListener = new ScrollMouseListener();
                }
                this.thumbscroll.addAdjustmentListener(this.scrollListener);
                this.thumbscroll.addMouseListener(this.scrollMouseListener);
                containerForThumbnails.setLayout(new BorderLayout());
                containerForThumbnails.add((Component)this.thumbscroll, "East");
                this.scrollPane.getViewport().add(this.decode_pdf);
                containerForThumbnails.add((Component)this.scrollPane, "Center");
                this.scrollPane.setVerticalScrollBarPolicy(21);
                this.scrollPane.setHorizontalScrollBarPolicy(31);
            } else {
                this.scrollPane.getViewport().add(this.decode_pdf);
                this.scrollPane.setVerticalScrollBarPolicy(20);
                this.scrollPane.setHorizontalScrollBarPolicy(30);
            }
            this.scrollPane.getVerticalScrollBar().setUnitIncrement(80);
            this.scrollPane.getHorizontalScrollBar().setUnitIncrement(80);
            this.decode_pdf.addKeyListener(new KeyAdapter(){
                int count = 0;

                @Override
                public void keyPressed(KeyEvent e) {
                    final JScrollBar scroll = SwingGUI.this.scrollPane.getVerticalScrollBar();
                    if (this.count == 0) {
                        if (e.getKeyCode() == 38 && scroll.getValue() == scroll.getMinimum() && SwingGUI.this.getCurrentPage() > 1) {
                            ((Commands)currentCommands).executeCommand(52, null);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    scroll.setValue(scroll.getMaximum());
                                }
                            });
                        } else if (e.getKeyCode() == 40 && (scroll.getValue() == scroll.getMaximum() - scroll.getHeight() || scroll.getHeight() == 0) && SwingGUI.this.getCurrentPage() < SwingGUI.this.decode_pdf.getPageCount()) {
                            ((Commands)currentCommands).executeCommand(53, null);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    scroll.setValue(scroll.getMinimum());
                                }
                            });
                        }
                    }
                    ++this.count;
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    this.count = 0;
                }
            });
        }
        this.comboBoxBar.setBorder(BorderFactory.createEmptyBorder());
        this.comboBoxBar.setLayout(new FlowLayout(3));
        this.comboBoxBar.setFloatable(false);
        this.comboBoxBar.setFont(new Font("SansSerif", 0, 8));
        if (this.isSingle) {
            this.navOptionsPanel.setTabPlacement(2);
            this.navOptionsPanel.setOpaque(true);
            this.navOptionsPanel.setMinimumSize(new Dimension(0, 100));
            this.navOptionsPanel.setName("NavPanel");
            this.pageTitle = Messages.getMessage("PdfViewerJPanel.thumbnails");
            this.bookmarksTitle = Messages.getMessage("PdfViewerJPanel.bookmarks");
            this.layersTitle = Messages.getMessage("PdfViewerJPanel.layers");
            this.signaturesTitle = "Signatures";
            this.displayPane = this.previewOnSingleScroll ? new JSplitPane(1, this.navOptionsPanel, containerForThumbnails) : new JSplitPane(1, this.navOptionsPanel, this.scrollPane);
            this.displayPane.setOneTouchExpandable(false);
            this.displayPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    SwingGUI.this.scrollPane.getViewport().setSize(SwingGUI.this.scrollPane.getViewport().getWidth() + (Integer)e.getOldValue() - (Integer)e.getNewValue(), SwingGUI.this.scrollPane.getViewport().getHeight());
                    SwingGUI.this.desktopPane.setSize(SwingGUI.this.desktopPane.getWidth() + (Integer)e.getOldValue() - (Integer)e.getNewValue(), SwingGUI.this.desktopPane.getHeight());
                    SwingGUI.this.zoom(false);
                }
            });
            if (DecoderOptions.isRunningOnMac) {
                this.navOptionsPanel.addTab(this.pageTitle, (Component)((Object)this.thumbnails));
                this.navOptionsPanel.setTitleAt(this.navOptionsPanel.getTabCount() - 1, this.pageTitle);
                if (this.thumbnails.isShownOnscreen()) {
                    this.navOptionsPanel.addTab(this.bookmarksTitle, (SwingOutline)this.tree);
                    this.navOptionsPanel.setTitleAt(this.navOptionsPanel.getTabCount() - 1, this.bookmarksTitle);
                }
            } else {
                if (this.thumbnails.isShownOnscreen()) {
                    VTextIcon textIcon1 = new VTextIcon(this.navOptionsPanel, this.pageTitle, 2);
                    this.navOptionsPanel.addTab(null, textIcon1, (Component)((Object)this.thumbnails));
                }
                VTextIcon textIcon2 = new VTextIcon(this.navOptionsPanel, this.bookmarksTitle, 2);
                this.navOptionsPanel.addTab(null, textIcon2, (SwingOutline)this.tree);
            }
            this.displayPane.setDividerLocation(startSize);
            if (!this.hasListener) {
                this.hasListener = true;
                this.navOptionsPanel.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        SwingGUI.this.handleTabbedPanes();
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                    }
                });
            }
        }
        this.first = new SwingButton();
        this.fback = new SwingButton();
        this.back = new SwingButton();
        this.forward = new SwingButton();
        this.fforward = new SwingButton();
        this.end = new SwingButton();
        this.snapshotButton = new SwingButton();
        this.singleButton = new SwingButton();
        this.continuousButton = new SwingButton();
        this.continuousFacingButton = new SwingButton();
        this.facingButton = new SwingButton();
        this.pageFlowButton = new SwingButton();
        this.openButton = new SwingButton();
        this.printButton = new SwingButton();
        this.searchButton = new SwingButton();
        this.docPropButton = new SwingButton();
        this.infoButton = new SwingButton();
        this.mouseMode = new SwingButton();
        this.previousSearch = new SwingButton();
        this.nextSearch = new SwingButton();
        this.pageCounter2.setEditable(true);
        this.pageCounter2.setToolTipText(Messages.getMessage("PdfViewerTooltip.goto"));
        this.pageCounter2.setBorder(BorderFactory.createLineBorder(Color.black));
        this.pageCounter2.setColumns(4);
        this.pageCounter2.setMaximumSize(this.pageCounter2.getPreferredSize());
        this.pageCounter2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String value = SwingGUI.this.pageCounter2.getText().trim();
                ((Commands)currentCommands).gotoPage(value);
            }
        });
        this.pageCounter2.setHorizontalAlignment(0);
        this.pageCounter2.setForeground(Color.black);
        this.setPageNumber();
        this.pageCounter3 = new JLabel(Messages.getMessage("PdfViewerOfLabel.text") + ' ');
        this.pageCounter3.setOpaque(false);
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        if (this.frame instanceof JFrame) {
            ((JFrame)this.frame).getContentPane().add((Component)top, "North");
        } else {
            this.frame.add((Component)top, "North");
        }
        this.navToolBar.setLayout(new BoxLayout(this.navToolBar, 2));
        this.navToolBar.setFloatable(false);
        this.pagesToolBar.setFloatable(false);
        this.navButtons.setBorder(BorderFactory.createEmptyBorder());
        this.navButtons.setLayout(new BorderLayout());
        this.navButtons.setFloatable(false);
        this.navButtons.setPreferredSize(new Dimension(5, 24));
        top.add((Component)this.currentMenu, "North");
        this.topButtons.setBorder(BorderFactory.createEmptyBorder());
        this.topButtons.setLayout(new FlowLayout(3));
        this.topButtons.setFloatable(false);
        this.topButtons.setFont(new Font("SansSerif", 0, 8));
        top.add((Component)this.topButtons, "Center");
        if (!this.useNewLayout) {
            top.add((Component)this.comboBoxBar, "South");
        }
        if (this.frame instanceof JFrame) {
            ((JFrame)this.frame).getContentPane().add((Component)this.navButtons, "South");
        } else {
            this.frame.add((Component)this.navButtons, "South");
        }
        if (this.displayPane != null) {
            if (this.frame instanceof JFrame) {
                ((JFrame)this.frame).getContentPane().add((Component)this.displayPane, "Center");
            } else {
                this.frame.add((Component)this.displayPane, "Center");
            }
        }
        this.createMainMenu(true);
        this.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.openFile"), this.iconLocation + "open.gif", 10);
        if (this.searchFrame != null && this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_EXTERNAL_WINDOW) {
            this.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.search"), this.iconLocation + "find.gif", 12);
        }
        this.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.properties"), this.iconLocation + "properties.gif", 9);
        if (!this.useNewLayout || this.commonValues.getModeOfOperation() == 4) {
            this.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.about"), this.iconLocation + "about.gif", 1);
        }
        this.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.snapshot"), this.iconLocation + "snapshot.gif", 13);
        if (this.useNewLayout) {
            sep = new JSeparator(1);
            sep.setPreferredSize(new Dimension(5, 32));
            this.topButtons.add(sep);
        }
        this.addCombo(Messages.getMessage("PdfViewerToolbarScaling.text"), Messages.getMessage("PdfViewerToolbarTooltip.zoomin"), 252);
        this.addCombo(Messages.getMessage("PdfViewerToolbarRotation.text"), Messages.getMessage("PdfViewerToolbarTooltip.rotation"), 251);
        this.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.mouseMode"), this.iconLocation + "mouse_select.png", 29);
        if (this.useNewLayout) {
            sep = new JSeparator(1);
            sep.setPreferredSize(new Dimension(5, 32));
            this.topButtons.add(sep);
        }
        this.createNavbar();
        this.addCursor();
        if (this.searchFrame != null && this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_MENU_BAR) {
            this.searchInMenu(this.searchFrame);
        }
        this.initStatus();
        this.frame.invalidate();
        this.frame.validate();
        this.frame.repaint();
        try {
            this.loadProperties();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.commonValues.getModeOfOperation() != 1) {
            String customWindowSize;
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            int width = d.width / 2;
            int height = d.height / 2;
            if (width < 700) {
                width = 700;
            }
            if ((customWindowSize = System.getProperty("org.jpedal.startWindowSize")) != null) {
                StringTokenizer values = new StringTokenizer(customWindowSize, "x");
                System.out.println(values.countTokens());
                if (values.countTokens() != 2) {
                    throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + customWindowSize + "\nValue should be in format org.jpedal.startWindowSize=200x300");
                }
                try {
                    width = Integer.parseInt(values.nextToken().trim());
                    height = Integer.parseInt(values.nextToken().trim());
                }
                catch (Exception ee) {
                    throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + customWindowSize + "\nValue should be in format org.jpedal.startWindowSize=200x300");
                }
            }
            if (this.frame instanceof JFrame) {
                this.frame.setSize(width, height);
                ((JFrame)this.frame).setLocationRelativeTo(null);
                ((JFrame)this.frame).setDefaultCloseOperation(0);
                ((JFrame)this.frame).addWindowListener(new FrameCloser((Commands)currentCommands, this, this.decode_pdf, (Printer)currentPrinter, this.thumbnails, this.commonValues, this.properties));
                this.frame.setVisible(true);
            }
        }
        this.frame.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (SwingGUI.this.decode_pdf.getParent() != null && (SwingGUI.this.getSelectedComboIndex(252) < 3 || SwingGUI.this.decode_pdf.getDisplayView() == 3)) {
                    SwingGUI.this.zoom(false);
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        if (this.decode_pdf.useNewGraphicsMode) {
            this.decode_pdf.setPDFBorder(new AbstractBorder(){
                private static final long serialVersionUID = -5113144261774718512L;

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    Graphics2D g2 = (Graphics2D)g;
                    int cornerDepth = SwingGUI.this.glowThickness / 2 + 1;
                    g2.setPaint(new GradientPaint(x - SwingGUI.this.glowThickness, 0.0f, SwingGUI.this.glowOuterColor, x, 0.0f, SwingGUI.this.glowInnerColor));
                    g2.fillRect(x - SwingGUI.this.glowThickness, y, SwingGUI.this.glowThickness, height);
                    g2.setPaint(new GradientPaint(x - cornerDepth, y + height + cornerDepth, SwingGUI.this.glowOuterColor, x, y + height, SwingGUI.this.glowInnerColor));
                    g2.fillRect(x - SwingGUI.this.glowThickness, y + height, SwingGUI.this.glowThickness, SwingGUI.this.glowThickness);
                    g2.setPaint(new GradientPaint(0.0f, y + height + SwingGUI.this.glowThickness, SwingGUI.this.glowOuterColor, 0.0f, y + height, SwingGUI.this.glowInnerColor));
                    g2.fillRect(x, y + height, width, SwingGUI.this.glowThickness);
                    g2.setPaint(new GradientPaint(x + width + cornerDepth, y + height + cornerDepth, SwingGUI.this.glowOuterColor, x + width, y + height, SwingGUI.this.glowInnerColor));
                    g2.fillRect(x + width, y + height, SwingGUI.this.glowThickness, SwingGUI.this.glowThickness);
                    g2.setPaint(new GradientPaint(x + width + SwingGUI.this.glowThickness, 0.0f, SwingGUI.this.glowOuterColor, x + width, 0.0f, SwingGUI.this.glowInnerColor));
                    g2.fillRect(x + width, y, SwingGUI.this.glowThickness, height);
                    g2.setPaint(new GradientPaint(x + width + cornerDepth, y - cornerDepth, SwingGUI.this.glowOuterColor, x + width, y, SwingGUI.this.glowInnerColor));
                    g2.fillRect(x + width, y - SwingGUI.this.glowThickness, SwingGUI.this.glowThickness, SwingGUI.this.glowThickness);
                    g2.setPaint(new GradientPaint(0.0f, y - SwingGUI.this.glowThickness, SwingGUI.this.glowOuterColor, 0.0f, y, SwingGUI.this.glowInnerColor));
                    g2.fillRect(x, y - SwingGUI.this.glowThickness, width, SwingGUI.this.glowThickness);
                    g2.setPaint(new GradientPaint(x - cornerDepth, y - cornerDepth, SwingGUI.this.glowOuterColor, x, y, SwingGUI.this.glowInnerColor));
                    g2.fillRect(x - SwingGUI.this.glowThickness, y - SwingGUI.this.glowThickness, SwingGUI.this.glowThickness, SwingGUI.this.glowThickness);
                    g2.setPaint(Color.black);
                    g2.drawRect(x, y, width, height);
                }

                @Override
                public Insets getBorderInsets(Component c, Insets insets) {
                    insets.set(SwingGUI.this.glowThickness, SwingGUI.this.glowThickness, SwingGUI.this.glowThickness, SwingGUI.this.glowThickness);
                    return insets;
                }
            });
        } else {
            this.decode_pdf.setPDFBorder(BorderFactory.createLineBorder(Color.black, 1));
        }
    }

    public PdfDecoder getPdfDecoder() {
        return this.decode_pdf;
    }

    private void handleTabbedPanes() {
        if (this.tabsNotInitialised) {
            return;
        }
        int currentSize = this.displayPane.getDividerLocation();
        int tabSelected = this.navOptionsPanel.getSelectedIndex();
        if (tabSelected == -1) {
            return;
        }
        if (currentSize == startSize) {
            this.setupThumbnailPanel();
            this.setBookmarks(true);
            this.displayPane.setDividerLocation(expandedSize);
        } else if (tabSelected == this.lastTabSelected) {
            this.displayPane.setDividerLocation(startSize);
        }
        this.lastTabSelected = tabSelected;
    }

    @Override
    public void addCursor() {
        if (!this.useNewLayout) {
            this.cursor.setBorder(BorderFactory.createEmptyBorder());
            this.cursor.setLayout(new FlowLayout(3));
            this.cursor.setFloatable(false);
            this.cursor.setFont(new Font("SansSerif", 2, 10));
            this.cursor.add(new JLabel(Messages.getMessage("PdfViewerToolbarCursorLoc.text")));
            this.cursor.add(this.initCoordBox());
            this.cursor.setPreferredSize(new Dimension(200, 32));
            this.topButtons.add(this.cursor);
        } else {
            this.initCoordBox();
        }
    }

    public void setMultibox(int[] flags) {
        if (flags.length > 1 && flags[0] == 1) {
            if (this.cursorOverPage != (flags[1] == 1)) {
                this.cursorOverPage = flags[1] == 1;
            } else {
                return;
            }
        }
        if (this.statusBar.isEnabled() && this.statusBar.isVisible() && !this.statusBar.isDone()) {
            this.multibox.removeAll();
            this.statusBar.getStatusObject().setSize(this.multibox.getSize());
            this.multibox.add(this.statusBar.getStatusObject(), "Center");
            this.multibox.repaint();
            return;
        }
        if (this.cursor.isEnabled() && this.cursor.isVisible() && this.cursorOverPage && this.decode_pdf.isOpen()) {
            this.multibox.removeAll();
            this.multibox.add((Component)this.coords, "Center");
            this.multibox.repaint();
            return;
        }
        if (this.downloadBar.isEnabled() && this.downloadBar.isVisible() && !this.downloadBar.isDone() && (this.decode_pdf.isLoadingLinearizedPDF() || !this.decode_pdf.isOpen())) {
            this.multibox.removeAll();
            this.downloadBar.getStatusObject().setSize(this.multibox.getSize());
            this.multibox.add(this.downloadBar.getStatusObject(), "Center");
            this.multibox.repaint();
            return;
        }
        if (this.memoryBar.isEnabled() && this.memoryBar.isVisible()) {
            this.multibox.removeAll();
            this.memoryBar.setSize(this.multibox.getSize());
            this.memoryBar.setForeground(new Color(125, 145, 255));
            this.multibox.add((Component)this.memoryBar, "Center");
            this.multibox.repaint();
            return;
        }
    }

    private void setKeyAccelerators(int ID, JMenuItem menuItem) {
        int systemMask = 2;
        if (DecoderOptions.isRunningOnMac) {
            systemMask = 4;
        }
        switch (ID) {
            case 12: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(70, systemMask));
                break;
            }
            case 5: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(83, systemMask));
                break;
            }
            case 6: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(80, systemMask));
                break;
            }
            case 7: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(81, systemMask));
                break;
            }
            case 9: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(68, systemMask));
                break;
            }
            case 10: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(79, systemMask));
                break;
            }
            case 14: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(85, systemMask));
                break;
            }
            case 16: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(37, 9));
                break;
            }
            case 17: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(39, 9));
                break;
            }
            case 50: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(36, systemMask));
                break;
            }
            case 52: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(38, 2));
                break;
            }
            case 53: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(40, 2));
                break;
            }
            case 55: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(35, systemMask));
                break;
            }
            case 56: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(78, systemMask | 1));
                break;
            }
            case 2: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(66, 8));
                break;
            }
            case 25: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(67, systemMask));
                break;
            }
            case 26: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(65, systemMask));
                break;
            }
            case 27: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(65, systemMask + 64));
                break;
            }
            case 24: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(75, systemMask));
            }
        }
    }

    @Override
    public void addButton(int line, String toolTip, String path, int ID) {
        GUIButton newButton = new SwingButton();
        switch (ID) {
            case 50: {
                newButton = this.first;
                break;
            }
            case 51: {
                newButton = this.fback;
                break;
            }
            case 52: {
                newButton = this.back;
                break;
            }
            case 53: {
                newButton = this.forward;
                break;
            }
            case 54: {
                newButton = this.fforward;
                break;
            }
            case 55: {
                newButton = this.end;
                break;
            }
            case 13: {
                newButton = this.snapshotButton;
                break;
            }
            case 57: {
                newButton = this.singleButton;
                newButton.setName("SINGLE");
                break;
            }
            case 58: {
                newButton = this.continuousButton;
                newButton.setName("CONTINUOUS");
                break;
            }
            case 59: {
                newButton = this.continuousFacingButton;
                newButton.setName("CONTINUOUS_FACING");
                break;
            }
            case 60: {
                newButton = this.facingButton;
                newButton.setName("FACING");
                break;
            }
            case 62: {
                newButton = this.pageFlowButton;
                newButton.setName("PAGEFLOW");
                break;
            }
            case 18: {
                newButton = this.previousSearch;
                newButton.setName("PREVIOUSRESULT");
                break;
            }
            case 19: {
                newButton = this.nextSearch;
                newButton.setName("NEXTRESULT");
                break;
            }
            case 10: {
                newButton = this.openButton;
                newButton.setName("open");
                break;
            }
            case 6: {
                newButton = this.printButton;
                newButton.setName("print");
                break;
            }
            case 12: {
                newButton = this.searchButton;
                newButton.setName("search");
                break;
            }
            case 9: {
                newButton = this.docPropButton;
                break;
            }
            case 1: {
                newButton = this.infoButton;
                break;
            }
            case 29: {
                newButton = this.mouseMode;
                newButton.setName("mousemode");
            }
        }
        ((Component)((Object)newButton)).addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SingleDisplay.allowChangeCursor) {
                    ((SwingButton)e.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (SingleDisplay.allowChangeCursor) {
                    ((SwingButton)e.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        newButton.init(this.getURLForImage(path), ID, toolTip);
        ((AbstractButton)((Object)newButton)).addActionListener(this.currentCommandListener);
        int mode = this.commonValues.getModeOfOperation();
        if (mode == 1) {
            ((AbstractButton)((Object)newButton)).setContentAreaFilled(false);
        }
        if (line == 0 || mode == 4) {
            this.topButtons.add((AbstractButton)((Object)newButton));
            if (mode == 4 && (mode == 55 || mode == 62)) {
                this.topButtons.add(Box.createHorizontalGlue());
            }
        } else if (line == 1) {
            this.navToolBar.add((AbstractButton)((Object)newButton));
        } else if (line == 2) {
            this.pagesToolBar.add((Component)((AbstractButton)((Object)newButton)), "Center");
        }
    }

    @Override
    public void addMenuItem(JMenu parentMenu, String text, String toolTip, int ID) {
        this.addMenuItem(parentMenu, text, toolTip, ID, false);
    }

    public void addMenuItem(JMenu parentMenu, String text, String toolTip, int ID, boolean isCheckBox) {
        JMenuItem menuItem = isCheckBox ? new SwingCheckBoxMenuItem(text) : new SwingMenuItem(text);
        if (toolTip.length() > 0) {
            menuItem.setToolTipText(toolTip);
        }
        menuItem.setID(ID);
        this.setKeyAccelerators(ID, menuItem);
        menuItem.addActionListener(this.currentCommandListener);
        switch (ID) {
            case 10: {
                this.open = menuItem;
                parentMenu.add(this.open);
                break;
            }
            case 14: {
                this.openUrl = menuItem;
                parentMenu.add(this.openUrl);
                break;
            }
            case 5: {
                this.save = menuItem;
                parentMenu.add(this.save);
                break;
            }
            case 500: {
                this.reSaveAsForms = menuItem;
                this.reSaveAsForms.setName("resaveForms");
                parentMenu.add(this.reSaveAsForms);
                break;
            }
            case 12: {
                this.find = menuItem;
                parentMenu.add(this.find);
                break;
            }
            case 9: {
                this.documentProperties = menuItem;
                parentMenu.add(this.documentProperties);
                break;
            }
            case 512: {
                this.signPDF = menuItem;
                parentMenu.add(this.signPDF);
                break;
            }
            case 6: {
                this.print = menuItem;
                parentMenu.add(this.print);
                break;
            }
            case 7: {
                this.exit = menuItem;
                this.exit.setName("exit");
                parentMenu.add(this.exit);
                break;
            }
            case 25: {
                this.copy = menuItem;
                parentMenu.add(this.copy);
                break;
            }
            case 26: {
                this.selectAll = menuItem;
                parentMenu.add(this.selectAll);
                break;
            }
            case 27: {
                this.deselectAll = menuItem;
                parentMenu.add(this.deselectAll);
                break;
            }
            case 24: {
                this.preferences = menuItem;
                parentMenu.add(this.preferences);
                break;
            }
            case 50: {
                this.firstPage = menuItem;
                parentMenu.add(this.firstPage);
                break;
            }
            case 52: {
                this.backPage = menuItem;
                parentMenu.add(this.backPage);
                break;
            }
            case 53: {
                this.forwardPage = menuItem;
                parentMenu.add(this.forwardPage);
                break;
            }
            case 55: {
                this.lastPage = menuItem;
                parentMenu.add(this.lastPage);
                break;
            }
            case 56: {
                this.goTo = menuItem;
                parentMenu.add(this.goTo);
                break;
            }
            case 16: {
                this.previousDocument = menuItem;
                parentMenu.add(this.previousDocument);
                break;
            }
            case 17: {
                this.nextDocument = menuItem;
                parentMenu.add(this.nextDocument);
                break;
            }
            case 61: {
                this.fullscreen = menuItem;
                parentMenu.add(this.fullscreen);
                break;
            }
            case 29: {
                this.fullscreen = menuItem;
                parentMenu.add(this.fullscreen);
                break;
            }
            case 30: {
                this.panMode = menuItem;
                parentMenu.add(this.panMode);
                break;
            }
            case 31: {
                this.textSelect = menuItem;
                parentMenu.add(this.textSelect);
                break;
            }
            case 32: {
                this.separateCover = (JCheckBoxMenuItem)menuItem;
                boolean separateCoverOn = this.properties.getValue("separateCoverOn").toLowerCase().equals("true");
                this.separateCover.setState(separateCoverOn);
                SingleDisplay.default_separateCover = separateCoverOn;
                parentMenu.add(this.separateCover);
                break;
            }
            case 21: {
                this.cascade = menuItem;
                parentMenu.add(this.cascade);
                break;
            }
            case 22: {
                this.tile = menuItem;
                parentMenu.add(this.tile);
                break;
            }
            case 501: {
                this.onePerPage = menuItem;
                parentMenu.add(this.onePerPage);
                break;
            }
            case 510: {
                this.nup = menuItem;
                parentMenu.add(this.nup);
                break;
            }
            case 511: {
                this.handouts = menuItem;
                parentMenu.add(this.handouts);
                break;
            }
            case 3: {
                this.images = menuItem;
                parentMenu.add(this.images);
                break;
            }
            case 4: {
                this.text = menuItem;
                parentMenu.add(this.text);
                break;
            }
            case 2: {
                this.bitmap = menuItem;
                parentMenu.add(this.bitmap);
                break;
            }
            case 502: {
                this.rotatePages = menuItem;
                parentMenu.add(this.rotatePages);
                break;
            }
            case 503: {
                this.deletePages = menuItem;
                parentMenu.add(this.deletePages);
                break;
            }
            case 504: {
                this.addPage = menuItem;
                parentMenu.add(this.addPage);
                break;
            }
            case 506: {
                this.addHeaderFooter = menuItem;
                parentMenu.add(this.addHeaderFooter);
                break;
            }
            case 507: {
                this.stampText = menuItem;
                parentMenu.add(this.stampText);
                break;
            }
            case 508: {
                this.stampImage = menuItem;
                parentMenu.add(this.stampImage);
                break;
            }
            case 509: {
                this.crop = menuItem;
                parentMenu.add(this.crop);
                break;
            }
            case 15: {
                this.visitWebsite = menuItem;
                parentMenu.add(this.visitWebsite);
                break;
            }
            case 20: {
                this.tipOfTheDay = menuItem;
                parentMenu.add(this.tipOfTheDay);
                break;
            }
            case 23: {
                this.checkUpdates = menuItem;
                parentMenu.add(this.checkUpdates);
                break;
            }
            case 1: {
                this.about = menuItem;
                parentMenu.add(this.about);
                break;
            }
            default: {
                if (menuItem instanceof JMenuItem) {
                    parentMenu.add(menuItem);
                    break;
                }
                if (!(menuItem instanceof JCheckBoxMenuItem)) break;
                parentMenu.add((JCheckBoxMenuItem)menuItem);
            }
        }
    }

    public String getIconLocation() {
        return this.iconLocation;
    }

    public URL getURLForImage(String path) {
        String file = path.substring(path.lastIndexOf(47) + 1);
        path = path.substring(0, path.indexOf(46)) + ".gif";
        File p = new File(path);
        URL url = this.getClass().getResource(path);
        if (p.exists()) {
            try {
                url = p.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (url == null) {
            path = path.substring(0, path.indexOf(46)) + ".png";
            p = new File(path);
            url = this.getClass().getResource(path);
            if (p.exists()) {
                try {
                    url = p.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (url != null) {
            return url;
        }
        path = "/org/jpedal/examples/viewer/res/" + file;
        url = this.getClass().getResource(path);
        return url;
    }

    @Override
    public void addCombo(String title, String tooltip, int ID) {
        GUICombo combo = null;
        switch (ID) {
            case 252: {
                combo = this.scalingBox;
                break;
            }
            case 251: {
                combo = this.rotationBox;
            }
        }
        combo.setID(ID);
        this.optimizationLabel = new JLabel(title);
        if (tooltip.length() > 0) {
            combo.setToolTipText(tooltip);
        }
        if (this.useNewLayout) {
            this.topButtons.add((SwingCombo)combo);
        } else {
            this.comboBoxBar.add(this.optimizationLabel);
            this.comboBoxBar.add((SwingCombo)combo);
        }
        ((SwingCombo)combo).addActionListener(this.currentCommandListener);
    }

    @Override
    public void setViewerTitle(String title) {
        if (title != null) {
            title = "LGPL " + title;
            if (this.frame instanceof JFrame) {
                ((JFrame)this.frame).setTitle(title);
            }
        } else {
            String finalMessage = "";
            finalMessage = this.titleMessage == null ? windowTitle + ' ' + this.commonValues.getSelectedFile() : this.titleMessage + this.commonValues.getSelectedFile();
            PdfObject linearObj = (PdfObject)this.decode_pdf.getJPedalObject(2004845231);
            if (linearObj != null) {
                LinearThread linearizedBackgroundReaderer = (LinearThread)this.decode_pdf.getJPedalObject(-1276915978);
                finalMessage = linearizedBackgroundReaderer != null && linearizedBackgroundReaderer.isAlive() ? finalMessage + " (still loading)" : finalMessage + " (Linearized)";
            }
            finalMessage = "LGPL " + finalMessage;
            if (this.commonValues.isFormsChanged()) {
                finalMessage = "* " + finalMessage;
            }
            if (this.frame instanceof JFrame) {
                ((JFrame)this.frame).setTitle(finalMessage);
            }
        }
    }

    @Override
    public void resetComboBoxes(boolean value) {
        this.scalingBox.setEnabled(value);
        this.rotationBox.setEnabled(value);
    }

    @Override
    public final JScrollPane createPane(JTextPane text_pane, String content, boolean useXML) throws BadLocationException {
        text_pane.setEditable(true);
        text_pane.setFont(new Font("Lucida", 0, 14));
        text_pane.setToolTipText(Messages.getMessage("PdfViewerTooltip.text"));
        Document doc = text_pane.getDocument();
        text_pane.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), Messages.getMessage("PdfViewerTitle.text")));
        text_pane.setForeground(Color.black);
        SimpleAttributeSet token_attribute = new SimpleAttributeSet();
        SimpleAttributeSet text_attribute = new SimpleAttributeSet();
        SimpleAttributeSet plain_attribute = new SimpleAttributeSet();
        StyleConstants.setForeground(token_attribute, Color.blue);
        StyleConstants.setForeground(text_attribute, Color.black);
        StyleConstants.setForeground(plain_attribute, Color.black);
        int pointer = 0;
        if (useXML && content != null) {
            StringTokenizer data_As_tokens = new StringTokenizer(content, "<>", true);
            while (data_As_tokens.hasMoreTokens()) {
                String next_item = data_As_tokens.nextToken();
                if (next_item.equals("<") && data_As_tokens.hasMoreTokens()) {
                    String current_token = next_item + data_As_tokens.nextToken() + data_As_tokens.nextToken();
                    doc.insertString(pointer, current_token, token_attribute);
                    pointer += current_token.length();
                    continue;
                }
                doc.insertString(pointer, next_item, text_attribute);
                pointer += next_item.length();
            }
        } else {
            doc.insertString(pointer, content, plain_attribute);
        }
        JScrollPane text_scroll = new JScrollPane();
        text_scroll.getViewport().add(text_pane);
        text_scroll.setHorizontalScrollBarPolicy(31);
        text_scroll.setVerticalScrollBarPolicy(20);
        return text_scroll;
    }

    @Override
    public int getSelectedComboIndex(int ID) {
        switch (ID) {
            case 252: {
                return this.scalingBox.getSelectedIndex();
            }
            case 251: {
                return this.rotationBox.getSelectedIndex();
            }
        }
        return -1;
    }

    @Override
    public void setSelectedComboIndex(int ID, int index) {
        switch (ID) {
            case 252: {
                this.scalingBox.setSelectedIndex(index);
                break;
            }
            case 251: {
                this.rotationBox.setSelectedIndex(index);
            }
        }
    }

    public GUICombo getCombo(int ID) {
        switch (ID) {
            case 252: {
                return this.scalingBox;
            }
            case 251: {
                return this.rotationBox;
            }
        }
        return null;
    }

    @Override
    public void setSelectedComboItem(int ID, String index) {
        switch (ID) {
            case 252: {
                this.scalingBox.setSelectedItem(index + '%');
                break;
            }
            case 251: {
                this.rotationBox.setSelectedItem(index);
            }
        }
    }

    @Override
    public Object getSelectedComboItem(int ID) {
        switch (ID) {
            case 252: {
                return this.scalingBox.getSelectedItem();
            }
            case 251: {
                return this.rotationBox.getSelectedItem();
            }
        }
        return null;
    }

    @Override
    public void zoom(boolean Rotated) {
        this.scaleAndRotate(this.scaling, this.rotation);
    }

    private void scaleAndRotate(float scalingValue, int rotationValue) {
        float height;
        float width;
        if (this.decode_pdf.getDisplayView() == 5) {
            this.decode_pdf.setPageParameters(this.scaling, this.commonValues.getCurrentPage(), this.rotation);
            return;
        }
        if (!this.decode_pdf.isOpen() && this.currentCommands.isPDF()) {
            return;
        }
        if (this.isSingle) {
            width = this.scrollPane.getViewport().getWidth() - inset - inset;
            height = this.scrollPane.getViewport().getHeight() - inset - inset;
        } else {
            width = this.desktopPane.getWidth();
            height = this.desktopPane.getHeight();
        }
        if (this.decode_pdf != null) {
            int index = this.getSelectedComboIndex(252);
            if (this.decode_pdf.getDisplayView() == 5) {
                this.setSelectedComboIndex(252, 0);
                index = 0;
                this.scalingBox.setEnabled(false);
            } else if (this.decode_pdf.getDisplayView() != 5) {
                this.scalingBox.setEnabled(true);
            }
            if (index == -1) {
                String numberValue = (String)this.getSelectedComboItem(252);
                float zoom = -1.0f;
                if (numberValue != null && numberValue.length() > 0) {
                    block48: {
                        try {
                            zoom = Float.parseFloat(numberValue);
                        }
                        catch (Exception e) {
                            char c;
                            int ii;
                            zoom = -1.0f;
                            int length = numberValue.length();
                            for (ii = 0; ii < length && ((c = numberValue.charAt(ii)) >= '0' && c <= '9') | c == '.'; ++ii) {
                            }
                            if (ii > 0) {
                                numberValue = numberValue.substring(0, ii);
                            }
                            if (zoom != -1.0f) break block48;
                            try {
                                zoom = Float.parseFloat(numberValue);
                            }
                            catch (Exception e1) {
                                zoom = -1.0f;
                            }
                        }
                    }
                    if (zoom > 1000.0f) {
                        zoom = 1000.0f;
                    }
                }
                if (zoom == -1.0f) {
                    index = defaultSelection;
                    this.setSelectedComboIndex(252, index);
                } else {
                    this.scaling = this.decode_pdf.getDPIFactory().adjustScaling(zoom / 100.0f);
                    this.setSelectedComboItem(252, String.valueOf(zoom));
                }
            }
            int page = this.commonValues.getCurrentPage();
            if (this.isMultiPageTiff) {
                page = 1;
            }
            if (index != -1 || this.decode_pdf.getDisplayView() == 1 || this.decode_pdf.getDisplayView() == 3 && this.currentCommands.getPages().getBoolean(Display.BoolValue.TURNOVER_ON)) {
                int ch;
                int cw;
                PdfPageData pageData = this.decode_pdf.getPdfPageData();
                int raw_rotation = 0;
                if (this.decode_pdf.getDisplayView() == 3) {
                    raw_rotation = pageData.getRotation(page);
                }
                boolean isRotated = (this.rotation + raw_rotation) % 180 == 90;
                PageOffsets offsets = (PageOffsets)this.decode_pdf.getExternalHandler(17);
                switch (this.decode_pdf.getDisplayView()) {
                    case 4: {
                        if (isRotated) {
                            cw = offsets.getMaxH() * 2;
                            ch = offsets.getMaxW();
                            break;
                        }
                        cw = offsets.getMaxW() * 2;
                        ch = offsets.getMaxH();
                        break;
                    }
                    case 2: {
                        if (isRotated) {
                            cw = offsets.getMaxH();
                            ch = offsets.getMaxW();
                            break;
                        }
                        cw = offsets.getMaxW();
                        ch = offsets.getMaxH();
                        break;
                    }
                    case 3: {
                        int leftPage;
                        if (this.currentCommands.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER)) {
                            leftPage = page / 2 * 2;
                            if (this.commonValues.getPageCount() == 2) {
                                leftPage = 1;
                            }
                        } else {
                            leftPage = page;
                            if ((leftPage & 1) == 0) {
                                --leftPage;
                            }
                        }
                        if (isRotated) {
                            cw = pageData.getCropBoxHeight(leftPage);
                            cw = leftPage + 1 > this.commonValues.getPageCount() || leftPage == 1 ? (cw *= 2) : (cw += pageData.getCropBoxHeight(leftPage + 1));
                            ch = pageData.getCropBoxWidth(leftPage);
                            if (leftPage + 1 > this.commonValues.getPageCount() || ch >= pageData.getCropBoxWidth(leftPage + 1)) break;
                            ch = pageData.getCropBoxWidth(leftPage + 1);
                            break;
                        }
                        cw = pageData.getCropBoxWidth(leftPage);
                        cw = leftPage + 1 > this.commonValues.getPageCount() ? (cw *= 2) : (cw += pageData.getCropBoxWidth(leftPage + 1));
                        ch = pageData.getCropBoxHeight(leftPage);
                        if (leftPage + 1 > this.commonValues.getPageCount() || ch >= pageData.getCropBoxHeight(leftPage + 1)) break;
                        ch = pageData.getCropBoxHeight(leftPage + 1);
                        break;
                    }
                    default: {
                        if (isRotated) {
                            cw = pageData.getCropBoxHeight(page);
                            ch = pageData.getCropBoxWidth(page);
                            break;
                        }
                        cw = pageData.getCropBoxWidth(page);
                        ch = pageData.getCropBoxHeight(page);
                    }
                }
                if (this.isSingle && this.displayPane != null) {
                    width -= (float)this.displayPane.getDividerSize();
                }
                float x_factor = 0.0f;
                float y_factor = 0.0f;
                float window_factor = 0.0f;
                x_factor = width / (float)cw;
                y_factor = height / (float)ch;
                window_factor = x_factor < y_factor ? x_factor : y_factor;
                if (index != -1) {
                    if (index < 3) {
                        if (index == 0) {
                            this.scaling = window_factor;
                        } else if (index == 1) {
                            this.scaling = y_factor;
                        } else if (index == 2) {
                            this.scaling = x_factor;
                        }
                    } else {
                        this.scaling = this.decode_pdf.getDPIFactory().adjustScaling(this.scalingFloatValues[index]);
                    }
                }
                if (this.decode_pdf.getDisplayView() == 3) {
                    this.pageTurnScalingAppropriate = this.scaling <= window_factor;
                }
                if (this.thumbscroll != null) {
                    if (this.decode_pdf.getDisplayView() == 1 && this.scaling <= window_factor) {
                        this.scrollPane.setVerticalScrollBarPolicy(21);
                        this.scrollPane.setHorizontalScrollBarPolicy(31);
                        this.thumbscroll.setVisible(true);
                    } else {
                        this.scrollPane.setVerticalScrollBarPolicy(20);
                        this.scrollPane.setHorizontalScrollBarPolicy(30);
                        this.thumbscroll.setVisible(false);
                    }
                }
            }
            this.decode_pdf.setPageParameters(this.scaling, page, this.rotation);
            this.setRotation();
            Runnable updateAComponent = new Runnable(){

                @Override
                public void run() {
                    SwingGUI.this.decode_pdf.invalidate();
                    SwingGUI.this.decode_pdf.updateUI();
                    SwingGUI.this.decode_pdf.validate();
                    SwingGUI.this.scrollPane.invalidate();
                    SwingGUI.this.scrollPane.updateUI();
                    SwingGUI.this.scrollPane.validate();
                }
            };
            SwingUtilities.invokeLater(updateAComponent);
        }
    }

    public void snapScalingToDefaults(float newScaling) {
        float window_factor;
        float y_factor;
        float x_factor;
        int ch;
        int cw;
        float height;
        float width;
        newScaling = this.decode_pdf.getDPIFactory().adjustScaling(newScaling / 100.0f);
        if (this.isSingle) {
            width = this.scrollPane.getViewport().getWidth() - inset - inset;
            height = this.scrollPane.getViewport().getHeight() - inset - inset;
        } else {
            width = this.desktopPane.getWidth();
            height = this.desktopPane.getHeight();
        }
        PdfPageData pageData = this.decode_pdf.getPdfPageData();
        int raw_rotation = 0;
        if (this.decode_pdf.getDisplayView() == 3) {
            raw_rotation = pageData.getRotation(this.commonValues.getCurrentPage());
        }
        boolean isRotated = (this.rotation + raw_rotation) % 180 == 90;
        PageOffsets offsets = (PageOffsets)this.decode_pdf.getExternalHandler(17);
        switch (this.decode_pdf.getDisplayView()) {
            case 4: {
                if (isRotated) {
                    cw = offsets.getMaxH() * 2;
                    ch = offsets.getMaxW();
                    break;
                }
                cw = offsets.getMaxW() * 2;
                ch = offsets.getMaxH();
                break;
            }
            case 2: {
                if (isRotated) {
                    cw = offsets.getMaxH();
                    ch = offsets.getMaxW();
                    break;
                }
                cw = offsets.getMaxW();
                ch = offsets.getMaxH();
                break;
            }
            case 3: {
                int leftPage;
                if (this.currentCommands.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER)) {
                    leftPage = this.commonValues.getCurrentPage() / 2 * 2;
                    if (this.commonValues.getPageCount() == 2) {
                        leftPage = 1;
                    }
                } else {
                    leftPage = this.commonValues.getCurrentPage();
                    if ((leftPage & 1) == 0) {
                        --leftPage;
                    }
                }
                if (isRotated) {
                    cw = pageData.getCropBoxHeight(leftPage);
                    cw = leftPage + 1 > this.commonValues.getPageCount() || leftPage == 1 ? (cw *= 2) : (cw += pageData.getCropBoxHeight(leftPage + 1));
                    ch = pageData.getCropBoxWidth(leftPage);
                    if (leftPage + 1 > this.commonValues.getPageCount() || ch >= pageData.getCropBoxWidth(leftPage + 1)) break;
                    ch = pageData.getCropBoxWidth(leftPage + 1);
                    break;
                }
                cw = pageData.getCropBoxWidth(leftPage);
                cw = leftPage + 1 > this.commonValues.getPageCount() ? (cw *= 2) : (cw += pageData.getCropBoxWidth(leftPage + 1));
                ch = pageData.getCropBoxHeight(leftPage);
                if (leftPage + 1 > this.commonValues.getPageCount() || ch >= pageData.getCropBoxHeight(leftPage + 1)) break;
                ch = pageData.getCropBoxHeight(leftPage + 1);
                break;
            }
            default: {
                if (isRotated) {
                    cw = pageData.getCropBoxHeight(this.commonValues.getCurrentPage());
                    ch = pageData.getCropBoxWidth(this.commonValues.getCurrentPage());
                    break;
                }
                cw = pageData.getCropBoxWidth(this.commonValues.getCurrentPage());
                ch = pageData.getCropBoxHeight(this.commonValues.getCurrentPage());
            }
        }
        if (this.isSingle && this.displayPane != null) {
            width -= (float)this.displayPane.getDividerSize();
        }
        if ((x_factor = width / (float)cw) < (y_factor = height / (float)ch)) {
            window_factor = x_factor;
            x_factor = -1.0f;
        } else {
            window_factor = y_factor;
            y_factor = -1.0f;
        }
        if (this.getSelectedComboIndex(252) != 0 && ((double)newScaling < (double)window_factor * 1.1 && (double)newScaling > (double)window_factor * 0.91 || window_factor > this.scaling && window_factor < newScaling || window_factor < this.scaling && window_factor > newScaling)) {
            this.setSelectedComboIndex(252, 0);
            this.scaling = window_factor;
        } else if (y_factor != -1.0f && this.getSelectedComboIndex(252) != 1 && ((double)newScaling < (double)y_factor * 1.1 && (double)newScaling > (double)y_factor * 0.91 || y_factor > this.scaling && y_factor < newScaling || y_factor < this.scaling && y_factor > newScaling)) {
            this.setSelectedComboIndex(252, 1);
            this.scaling = y_factor;
        } else if (x_factor != -1.0f && this.getSelectedComboIndex(252) != 2 && ((double)newScaling < (double)x_factor * 1.1 && (double)newScaling > (double)x_factor * 0.91 || x_factor > this.scaling && x_factor < newScaling || x_factor < this.scaling && x_factor > newScaling)) {
            this.setSelectedComboIndex(252, 2);
            this.scaling = x_factor;
        } else {
            this.setSelectedComboItem(252, String.valueOf((int)this.decode_pdf.getDPIFactory().removeScaling(newScaling * 100.0f)));
            this.scaling = newScaling;
        }
    }

    @Override
    public void rotate() {
        this.rotation = Integer.parseInt((String)this.getSelectedComboItem(251));
        this.scaleAndRotate(this.scaling, this.rotation);
        this.decode_pdf.updateUI();
    }

    public void scrollToPage(int page) {
        this.commonValues.setCurrentPage(page);
        if (this.commonValues.getCurrentPage() > 0) {
            int yCord = 0;
            int xCord = 0;
            if (this.decode_pdf.getDisplayView() != 1) {
                yCord = this.currentCommands.pages.getYCordForPage(this.commonValues.getCurrentPage(), this.scaling);
                xCord = 0;
            }
            PdfPageData pageData = this.decode_pdf.getPdfPageData();
            int ch = (int)((float)pageData.getCropBoxHeight(this.commonValues.getCurrentPage()) * this.scaling);
            int cw = (int)((float)pageData.getCropBoxWidth(this.commonValues.getCurrentPage()) * this.scaling);
            int centerH = xCord + (cw - this.scrollPane.getHorizontalScrollBar().getVisibleAmount()) / 2;
            int centerV = yCord + (ch - this.scrollPane.getVerticalScrollBar().getVisibleAmount()) / 2;
            this.scrollPane.getHorizontalScrollBar().setValue(centerH);
            this.scrollPane.getVerticalScrollBar().setValue(centerV);
        }
        if (this.decode_pdf.getPageCount() > 1) {
            this.setPageLayoutButtonsEnabled(true);
        }
    }

    @Override
    public void decodePage(boolean resizePanel) {
        LinearThread linearizedBackgroundRenderer;
        this.currentCommands.getPages().setHighlightedImage(null);
        this.resetRotationBox();
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.terminateDrawing();
        }
        if (this.thumbnails.isShownOnscreen() && ((linearizedBackgroundRenderer = (LinearThread)this.decode_pdf.getJPedalObject(-1276915978)) == null || linearizedBackgroundRenderer != null && !linearizedBackgroundRenderer.isAlive())) {
            this.setupThumbnailPanel();
        }
        if (this.decode_pdf.getDisplayView() == 1) {
            this.pageCounter2.setForeground(Color.black);
            this.pageCounter2.setText(String.valueOf(this.commonValues.getCurrentPage()));
            this.pageCounter3.setText(Messages.getMessage("PdfViewerOfLabel.text") + ' ' + this.commonValues.getPageCount());
        }
        int col = ("/" + this.commonValues.getPageCount()).length();
        if (this.decode_pdf.getDisplayView() == 3 || this.decode_pdf.getDisplayView() == 4) {
            col *= 2;
        }
        if (col < 4) {
            col = 4;
        }
        if (col > 10) {
            col = 10;
        }
        this.pageCounter2.setColumns(col);
        this.pageCounter2.setMaximumSize(this.pageCounter2.getPreferredSize());
        this.navToolBar.invalidate();
        this.navToolBar.doLayout();
        this.tabsNotInitialised = false;
        this.decode_pdf.unsetScaling();
        this.decode_pdf.setExtractionMode(65);
        this.decode_pdf.getTextLines().clearHighlights();
        this.resetComboBoxes(false);
        this.setPageLayoutButtonsEnabled(false);
        Values.setProcessing(true);
        this.decode_pdf.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String status;
            this.statusBar.updateStatus("Decoding Page", 0);
            try {
                this.decode_pdf.decodePage(this.commonValues.getCurrentPage());
                this.decode_pdf.waitForDecodingToFinish();
                if (!this.decode_pdf.getPageDecodeStatus(2)) {
                    status = Messages.getMessage("PdfViewer.ImageDisplayError") + Messages.getMessage("PdfViewer.ImageDisplayError1") + Messages.getMessage("PdfViewer.ImageDisplayError2") + Messages.getMessage("PdfViewer.ImageDisplayError3") + Messages.getMessage("PdfViewer.ImageDisplayError4") + Messages.getMessage("PdfViewer.ImageDisplayError5") + Messages.getMessage("PdfViewer.ImageDisplayError6") + Messages.getMessage("PdfViewer.ImageDisplayError7");
                    this.showMessageDialog(status);
                }
                if (this.decode_pdf.getPageDecodeStatus(32)) {
                    status = Messages.getMessage("PdfCustomGui.ttHintingRequired");
                    this.showMessageDialog(status);
                }
                if (this.decode_pdf.getPageDecodeStatus(4)) {
                    status = "This page contains non-embedded CID fonts \n" + this.decode_pdf.getPageDecodeStatusReport(4) + "\nwhich may need mapping to display correctly.\nSee http://www.idrsolutions.com/how-do-fonts-work";
                    this.showMessageDialog(status);
                }
                PdfPageData page_data = this.decode_pdf.getPdfPageData();
                this.mediaW = page_data.getMediaBoxWidth(this.commonValues.getCurrentPage());
                this.mediaH = page_data.getMediaBoxHeight(this.commonValues.getCurrentPage());
                this.mediaX = page_data.getMediaBoxX(this.commonValues.getCurrentPage());
                this.mediaY = page_data.getMediaBoxY(this.commonValues.getCurrentPage());
                this.cropX = page_data.getCropBoxX(this.commonValues.getCurrentPage());
                this.cropY = page_data.getCropBoxY(this.commonValues.getCurrentPage());
                this.cropW = page_data.getCropBoxWidth(this.commonValues.getCurrentPage());
                this.cropH = page_data.getCropBoxHeight(this.commonValues.getCurrentPage());
                if (this.decode_pdf.getExternalHandler(25) != null) {
                    FormFactory formfactory = this.decode_pdf.getFormRenderer().getFormFactory();
                    if (formfactory.getType() == 1) {
                        Runnable doPaintComponent2 = new Runnable(){

                            @Override
                            public void run() {
                                SwingGUI.this.createUniqueAnnotationIcons();
                            }
                        };
                        SwingUtilities.invokeLater(doPaintComponent2);
                    } else {
                        this.createUniqueAnnotationIcons();
                    }
                }
                this.statusBar.updateStatus("Displaying Page", 0);
            }
            catch (Exception e) {
                System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + e + ' ' + Messages.getMessage("PdfViewerError.DecodePage"));
                e.printStackTrace();
                Values.setProcessing(false);
            }
            if (PdfDecoder.showErrorMessages) {
                Object[] options;
                int n;
                status = this.decode_pdf.getPageDecodeReport();
                if (status.contains("java.lang.OutOfMemoryError")) {
                    status = Messages.getMessage("PdfViewer.OutOfMemoryDisplayError") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError1") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError2") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError3") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError4") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError5");
                    this.showMessageDialog(status);
                } else if (status.contains("JPeg 2000") && (n = this.showMessageDialog((Object)(status = Messages.getMessage("PdfViewer.jpeg2000") + Messages.getMessage("PdfViewer.jpeg2000_1") + Messages.getMessage("PdfViewer.jpeg2000_2") + Messages.getMessage("PdfViewer.jpeg2000_3") + Messages.getMessage("PdfViewer.jpeg2000_4")), options = new Object[]{"Ok", "Open website help page"}, 0)) == 1) {
                    try {
                        BrowserLauncher.openURL("http://www.idrsolutions.com/additional-jars/");
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            }
            Values.setProcessing(false);
            this.setViewerTitle(null);
            this.currentCommands.setPageProperties(this.getSelectedComboItem(251), this.getSelectedComboItem(252));
            if (this.decode_pdf.getPageCount() > 0 && this.thumbnails.isShownOnscreen() && this.decode_pdf.getDisplayView() == 1) {
                this.thumbnails.generateOtherVisibleThumbnails(this.commonValues.getCurrentPage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Values.setProcessing(false);
            this.setViewerTitle(null);
        }
        this.selectBookmark();
        this.statusBar.setProgress(100);
        if (this.useNewLayout) {
            try {
                Thread.sleep(800L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setMultibox(new int[0]);
        }
        this.resetComboBoxes(true);
        if (this.decode_pdf.getPageCount() > 1) {
            this.setPageLayoutButtonsEnabled(true);
        }
        this.addFormsListeners();
        if (this.displayPane != null) {
            this.reinitialiseTabs(this.displayPane.getDividerLocation() > startSize);
        }
        this.finishedDecoding = true;
        this.zoom(false);
        this.decode_pdf.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void addFormsListeners() {
        AcroRenderer formRenderer;
        this.commonValues.setFormsChanged(false);
        boolean showMessage = false;
        String formsFlag = System.getProperty("org.jpedal.listenforms");
        if (formsFlag != null) {
            showMessage = true;
        }
        if ((formRenderer = this.decode_pdf.getFormRenderer()) == null) {
            return;
        }
        List formsOnPage = null;
        try {
            formsOnPage = formRenderer.getComponentNameList(this.commonValues.getCurrentPage());
        }
        catch (PdfException e) {
            LogWriter.writeLog("Exception " + e + " reading component list");
        }
        if (formsOnPage == null) {
            if (showMessage) {
                this.showMessageDialog(Messages.getMessage("PdfViewer.NoFields"));
            }
            return;
        }
        int formCount = formsOnPage.size();
        JPanel formPanel = new JPanel();
        if (showMessage) {
            formPanel.setLayout(new BoxLayout(formPanel, 1));
            JLabel formHeader = new JLabel("This page contains " + formCount + " form objects");
            formHeader.setFont(this.headFont);
            formPanel.add(formHeader);
            formPanel.add(Box.createRigidArea(new Dimension(10, 10)));
            JTextPane instructions = new JTextPane();
            instructions.setPreferredSize(new Dimension(450, 180));
            instructions.setEditable(false);
            instructions.setText("This provides a simple example of Forms handling. We have added a listener to each form so clicking on it shows the form name.\n\nCode is in addExampleListeners() in org.examples.viewer.Viewer\n\nThis could be easily be extended to interface with a database directly or collect results on an action and write back using itext.\n\nForms have been converted into Swing components and are directly accessible (as is the original data).\n\nIf you don't like the standard SwingSet you can replace with your own set.");
            instructions.setFont(this.textFont);
            formPanel.add(instructions);
            formPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        }
        if (showMessage) {
            final JDialog displayFrame = new JDialog((Frame)null, true);
            if (this.commonValues.getModeOfOperation() != 1) {
                displayFrame.setLocationRelativeTo(null);
                displayFrame.setLocation(this.frame.getLocationOnScreen().x + 10, this.frame.getLocationOnScreen().y + 10);
            }
            JScrollPane scroll = new JScrollPane();
            scroll.getViewport().add(formPanel);
            scroll.setHorizontalScrollBarPolicy(30);
            scroll.setVerticalScrollBarPolicy(20);
            displayFrame.setSize(500, 500);
            displayFrame.setTitle("List of forms on this page");
            displayFrame.getContentPane().setLayout(new BorderLayout());
            displayFrame.getContentPane().add((Component)scroll, "Center");
            JPanel buttonBar = new JPanel();
            buttonBar.setLayout(new BorderLayout());
            displayFrame.getContentPane().add((Component)buttonBar, "South");
            JButton no = new JButton(Messages.getMessage("PdfViewerButton.Close"));
            no.setFont(new Font("SansSerif", 0, 12));
            buttonBar.add((Component)no, "East");
            no.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    displayFrame.dispose();
                }
            });
            displayFrame.setVisible(true);
        }
    }

    public void setupThumbnailPanel() {
        this.decode_pdf.addExternalHandler(this.thumbnails, 8);
        if (this.isSetup) {
            return;
        }
        this.isSetup = true;
        if (this.thumbnails.isShownOnscreen()) {
            int pages = this.decode_pdf.getPageCount();
            this.thumbnails.setupThumbnails(pages, this.textFont, Messages.getMessage("PdfViewerPageLabel.text"), this.decode_pdf.getPdfPageData());
            Object[] buttons = this.thumbnails.getButtons();
            for (int i = 0; i < pages; ++i) {
                ((JButton)buttons[i]).addActionListener(new PageChanger(i));
            }
            this.thumbnails.addComponentListener();
        }
    }

    public void setBookmarks(boolean alwaysGenerate) {
        int currentSize = this.displayPane.getDividerLocation();
        if (currentSize == startSize && !alwaysGenerate) {
            return;
        }
        if (this.bookmarksGenerated) {
            return;
        }
        this.bookmarksGenerated = true;
        org.w3c.dom.Document doc = this.decode_pdf.getOutlineAsXML();
        Node rootNode = null;
        if (doc != null) {
            rootNode = doc.getFirstChild();
        }
        if (rootNode != null) {
            this.tree.reset(rootNode);
            ((JTree)this.tree.getTree()).addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node = SwingGUI.this.tree.getLastSelectedPathComponent();
                    if (node == null) {
                        return;
                    }
                    JTree jtree = (JTree)SwingGUI.this.tree.getTree();
                    DefaultTreeModel treeModel = (DefaultTreeModel)jtree.getModel();
                    ArrayList flattenedTree = new ArrayList();
                    SwingGUI.getFlattenedTreeNodes((TreeNode)treeModel.getRoot(), flattenedTree);
                    flattenedTree.remove(0);
                    int index = flattenedTree.indexOf(node);
                    String ref = SwingGUI.this.tree.convertNodeIDToRef(index);
                    PdfObject Aobj = SwingGUI.this.decode_pdf.getOutlineData().getAobj(ref);
                    if (Aobj != null) {
                        SwingGUI.this.decode_pdf.getFormRenderer().getActionHandler().gotoDest(Aobj, 3, 339034948);
                    }
                }
            });
        } else {
            this.tree.reset(null);
        }
    }

    private static void getFlattenedTreeNodes(TreeNode theNode, List<TreeNode> items) {
        items.add(theNode);
        Enumeration<? extends TreeNode> theChildren = theNode.children();
        while (theChildren.hasMoreElements()) {
            SwingGUI.getFlattenedTreeNodes(theChildren.nextElement(), items);
        }
    }

    private void selectBookmark() {
        if (this.decode_pdf.hasOutline() && this.tree != null) {
            this.tree.selectBookmark();
        }
    }

    @Override
    public void initStatus() {
        this.decode_pdf.setStatusBarObject(this.statusBar);
        if (!this.useNewLayout) {
            this.comboBoxBar.add(this.statusBar.getStatusObject());
        } else {
            this.setMultibox(new int[0]);
        }
    }

    @Override
    public void initThumbnails(int itemSelectedCount, Vector_Int pageUsed) {
        this.navOptionsPanel.removeAll();
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.setupThumbnails(itemSelectedCount - 1, pageUsed.get(), this.commonValues.getPageCount());
        }
        if (DecoderOptions.isRunningOnMac) {
            this.navOptionsPanel.add((Component)((Object)this.thumbnails), "Extracted items");
        } else {
            VTextIcon textIcon2 = new VTextIcon(this.navOptionsPanel, "Extracted items", 2);
            this.navOptionsPanel.addTab(null, textIcon2, (Component)((Object)this.thumbnails));
        }
        this.displayPane.setDividerLocation(150);
    }

    public void checkformSavedMessage() {
        String propValue = this.properties.getValue("showsaveformsmessage");
        boolean showSaveFormsMessage = false;
        if (propValue.length() > 0) {
            showSaveFormsMessage = propValue.equals("true");
        }
        if (showSaveFormsMessage && this.firstTimeFormMessage && !this.commonValues.isFormsChanged()) {
            this.firstTimeFormMessage = false;
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints p = new GridBagConstraints();
            p.anchor = 17;
            p.gridx = 0;
            p.gridy = 0;
            String str = Messages.getMessage("PdfViewerFormsWarning.ChangedFormsValue");
            if (!this.commonValues.isItextOnClasspath()) {
                str = Messages.getMessage("PdfViewerFormsWarning.ChangedFormsValueNoItext");
            }
            JCheckBox cb = new JCheckBox();
            cb.setText(Messages.getMessage("PdfViewerFormsWarning.CheckBox"));
            Font font = cb.getFont();
            JTextArea ta = new JTextArea(str);
            ta.setOpaque(false);
            ta.setFont(font);
            p.ipady = 20;
            panel.add((Component)ta, p);
            p.ipady = 0;
            p.gridy = 1;
            panel.add((Component)cb, p);
            JOptionPane.showMessageDialog(this.frame, panel);
            if (cb.isSelected()) {
                this.properties.setValue("showsaveformsmessage", "false");
            }
        }
        this.commonValues.setFormsChanged(true);
        this.setViewerTitle(null);
    }

    @Override
    public void setCoordText(String string) {
        this.coords.setText(string);
    }

    private JLabel initCoordBox() {
        this.coords.setBackground(Color.white);
        this.coords.setOpaque(true);
        if (this.useNewLayout) {
            this.coords.setBorder(BorderFactory.createEtchedBorder());
            this.coords.setPreferredSize(this.memoryBar.getPreferredSize());
        } else {
            this.coords.setPreferredSize(new Dimension(120, 20));
            this.coords.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        }
        this.coords.setText("  X:  Y:   ");
        return this.coords;
    }

    public void hideRedundentNavButtons() {
        int maxPages = this.decode_pdf.getPageCount();
        if (this.commonValues.isMultiTiff()) {
            maxPages = this.commonValues.getPageCount();
        }
        if ((this.decode_pdf.getDisplayView() == 3 && this.currentCommands.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || this.decode_pdf.getDisplayView() == 4) && (maxPages & 1) == 1) {
            --maxPages;
        }
        if (this.commonValues.getCurrentPage() == 1) {
            this.setBackNavigationButtonsEnabled(false);
        } else {
            this.setBackNavigationButtonsEnabled(true);
        }
        if (this.commonValues.getCurrentPage() == maxPages) {
            this.setForwardNavigationButtonsEnabled(false);
        } else {
            this.setForwardNavigationButtonsEnabled(true);
        }
        if (this.thumbscroll != null) {
            if (this.decode_pdf.getDisplayView() == 1) {
                this.scrollPane.setVerticalScrollBarPolicy(21);
                this.scrollPane.setHorizontalScrollBarPolicy(31);
                this.thumbscroll.setVisible(true);
            } else if (this.decode_pdf.getDisplayView() == 5) {
                this.scrollPane.setVerticalScrollBarPolicy(21);
                this.scrollPane.setHorizontalScrollBarPolicy(31);
                this.thumbscroll.setVisible(false);
            } else {
                this.scrollPane.setVerticalScrollBarPolicy(20);
                this.scrollPane.setHorizontalScrollBarPolicy(30);
                this.thumbscroll.setVisible(false);
            }
        }
    }

    @Override
    public void setPageNumber() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setPageNumberWorker();
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    SwingGUI.this.setPageNumberWorker();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    public boolean isMultiPageTiff() {
        return this.isMultiPageTiff;
    }

    public void setMultiPageTiff(boolean isMultiPageTiff) {
        this.isMultiPageTiff = isMultiPageTiff;
    }

    private void setPageNumberWorker() {
        if (!this.decode_pdf.isOpen() && !this.isMultiPageTiff) {
            this.pageCounter2.setText(" ");
        } else {
            if (this.previewOnSingleScroll && this.thumbscroll != null) {
                this.scrollListener.ignoreChange = true;
                this.thumbscroll.setMaximum(this.decode_pdf.getPageCount());
                this.scrollListener.ignoreChange = true;
                this.thumbscroll.setValue(this.commonValues.getCurrentPage() - 1);
                this.scrollListener.ignoreChange = false;
                if (this.debugThumbnail) {
                    System.out.println("setpage=" + this.commonValues.getCurrentPage());
                }
            }
            int currentPage = this.commonValues.getCurrentPage();
            if (this.decode_pdf.getDisplayView() == 3 || this.decode_pdf.getDisplayView() == 4) {
                if (this.decode_pdf.getPageCount() == 2) {
                    this.pageCounter2.setText("1/2");
                } else if (this.currentCommands.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || this.decode_pdf.getDisplayView() == 4) {
                    int base = currentPage & 0xFFFFFFFE;
                    if (base != this.decode_pdf.getPageCount() && base != 0) {
                        this.pageCounter2.setText(base + "/" + (base + 1));
                    } else {
                        this.pageCounter2.setText(String.valueOf(currentPage));
                    }
                } else {
                    int base = currentPage - (1 - (currentPage & 1));
                    if (base != this.decode_pdf.getPageCount()) {
                        this.pageCounter2.setText(base + "/" + (base + 1));
                    } else {
                        this.pageCounter2.setText(String.valueOf(currentPage));
                    }
                }
            } else {
                this.pageCounter2.setText(String.valueOf(currentPage));
            }
            this.pageCounter3.setText(Messages.getMessage("PdfViewerOfLabel.text") + ' ' + this.commonValues.getPageCount());
            this.hideRedundentNavButtons();
        }
    }

    public int getPageNumber() {
        return this.commonValues.getCurrentPage();
    }

    private void createNavbar() {
        ArrayList v = new ArrayList();
        if (this.memoryMonitor == null) {
            this.memoryMonitor = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    int free = (int)(Runtime.getRuntime().freeMemory() / 0x100000L);
                    int total = (int)(Runtime.getRuntime().totalMemory() / 0x100000L);
                    if (SwingGUI.this.finishedDecoding) {
                        SwingGUI.this.finishedDecoding = false;
                    }
                    SwingGUI.this.memoryBar.setMaximum(total);
                    SwingGUI.this.memoryBar.setValue(total - free);
                    SwingGUI.this.memoryBar.setStringPainted(true);
                    SwingGUI.this.memoryBar.setString(total - free + "M of " + total + 'M');
                }
            });
            this.memoryMonitor.start();
        }
        if (!this.useNewLayout) {
            this.navButtons.add((Component)this.memoryBar, "West");
        } else {
            this.multibox.setLayout(new BorderLayout());
            if (this.commonValues.getModeOfOperation() != 4) {
                this.navButtons.add((Component)this.multibox, "West");
            }
        }
        this.navButtons.add(Box.createHorizontalGlue());
        this.navToolBar.add(Box.createHorizontalGlue());
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.RewindToStart"), this.iconLocation + "start.gif", 50);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Rewind10"), this.iconLocation + "fback.gif", 51);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Rewind1"), this.iconLocation + "back.gif", 52);
        this.pageCounter1 = new JLabel(Messages.getMessage("PdfViewerPageLabel.text"));
        this.pageCounter1.setOpaque(false);
        this.navToolBar.add(this.pageCounter1);
        this.navToolBar.add(this.pageCounter2);
        this.navToolBar.add(this.pageCounter3);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Forward1"), this.iconLocation + "forward.gif", 53);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Forward10"), this.iconLocation + "fforward.gif", 54);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.ForwardLast"), this.iconLocation + "end.gif", 55);
        this.navToolBar.add(Box.createHorizontalGlue());
        Dimension size = new Dimension(110, 0);
        Box.Filler filler = new Box.Filler(size, size, size);
        this.navButtons.add((Component)filler, "East");
        if (this.useNewLayout) {
            this.multibox.setPreferredSize(size);
        } else {
            this.memoryBar.setPreferredSize(size);
        }
        boolean[] defaultValues = new boolean[v.size()];
        for (int i = 0; i != v.size(); ++i) {
            defaultValues[i] = v.get(i).equals(Boolean.TRUE);
        }
        if (this.commonValues.getModeOfOperation() == 4) {
            this.topButtons.add((Component)this.navToolBar, "Center");
        } else {
            this.navButtons.add((Component)this.navToolBar, "Center");
        }
    }

    @Override
    public void setPage(int page) {
        if ((this.decode_pdf.getDisplayView() == 3 && this.currentCommands.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || this.decode_pdf.getDisplayView() == 4) && (page & 1) == 1 && page != 1) {
            --page;
        } else if (this.decode_pdf.getDisplayView() == 3 && !this.currentCommands.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && (page & 1) == 0) {
            --page;
        }
        this.commonValues.setCurrentPage(page);
        this.setPageNumber();
        this.setThumbnails();
    }

    public void resetPageNav() {
        this.pageCounter2.setText("");
        this.pageCounter3.setText("");
    }

    public void setRotation() {
        if (this.rotation > 360) {
            this.rotation -= 360;
        }
        if (this.getSelectedComboIndex(251) != this.rotation / 90) {
            this.setSelectedComboIndex(251, this.rotation / 90);
        } else if (!Values.isProcessing()) {
            this.decode_pdf.repaint();
        }
    }

    public void setRotationFromExternal(int rot) {
        this.rotation = rot;
        this.rotationBox.setSelectedIndex(this.rotation / 90);
        if (!Values.isProcessing()) {
            this.decode_pdf.repaint();
        }
    }

    public void setScalingFromExternal(String scale) {
        if (scale.startsWith("Fit ")) {
            this.scalingBox.setSelectedItem(scale);
        } else {
            this.scaling = Float.parseFloat(scale);
            this.scalingBox.setSelectedItem(scale + '%');
        }
        if (!Values.isProcessing()) {
            this.decode_pdf.repaint();
        }
    }

    public void createMainMenu(boolean includeAll) {
        String addSeparator = "";
        this.fileMenu = new JMenu(Messages.getMessage("PdfViewerFileMenu.text"));
        this.addToMainMenu(this.fileMenu);
        this.openMenu = new JMenu(Messages.getMessage("PdfViewerFileMenuOpen.text"));
        this.fileMenu.add(this.openMenu);
        this.addMenuItem(this.openMenu, Messages.getMessage("PdfViewerFileMenuOpen.text"), Messages.getMessage("PdfViewerFileMenuTooltip.open"), 10);
        this.addMenuItem(this.openMenu, Messages.getMessage("PdfViewerFileMenuOpenurl.text"), Messages.getMessage("PdfViewerFileMenuTooltip.openurl"), 14);
        addSeparator = this.properties.getValue("Save") + this.properties.getValue("Resaveasforms") + this.properties.getValue("Find");
        if (addSeparator.length() > 0 && addSeparator.toLowerCase().contains("true")) {
            this.fileMenu.addSeparator();
        }
        this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuSave.text"), Messages.getMessage("PdfViewerFileMenuTooltip.save"), 5);
        if (includeAll && this.commonValues.isItextOnClasspath()) {
            this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuResaveForms.text"), Messages.getMessage("PdfViewerFileMenuTooltip.saveForms"), 500);
        }
        this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuFind.text"), Messages.getMessage("PdfViewerFileMenuTooltip.find"), 12);
        addSeparator = this.properties.getValue("Documentproperties");
        if (addSeparator.length() > 0 && addSeparator.toLowerCase().equals("true")) {
            this.fileMenu.addSeparator();
        }
        this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuDocProperties.text"), Messages.getMessage("PdfViewerFileMenuTooltip.props"), 9);
        addSeparator = this.properties.getValue("Print");
        if (addSeparator.length() > 0 && addSeparator.toLowerCase().equals("true")) {
            this.fileMenu.addSeparator();
        }
        this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuPrint.text"), Messages.getMessage("PdfViewerFileMenuTooltip.print"), 6);
        addSeparator = this.properties.getValue("Recentdocuments");
        if (addSeparator.length() > 0 && addSeparator.toLowerCase().equals("true")) {
            this.fileMenu.addSeparator();
            this.currentCommands.recentDocumentsOption(this.fileMenu);
        }
        if ((addSeparator = this.properties.getValue("Exit")).length() > 0 && addSeparator.toLowerCase().equals("true")) {
            this.fileMenu.addSeparator();
        }
        this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuExit.text"), Messages.getMessage("PdfViewerFileMenuTooltip.exit"), 7);
        this.editMenu = new JMenu(Messages.getMessage("PdfViewerEditMenu.text"));
        this.addToMainMenu(this.editMenu);
        this.addMenuItem(this.editMenu, Messages.getMessage("PdfViewerEditMenuCopy.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Copy"), 25);
        this.addMenuItem(this.editMenu, Messages.getMessage("PdfViewerEditMenuSelectall.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Selectall"), 26);
        this.addMenuItem(this.editMenu, Messages.getMessage("PdfViewerEditMenuDeselectall.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Deselectall"), 27);
        addSeparator = this.properties.getValue("Preferences");
        if (addSeparator.length() > 0 && addSeparator.toLowerCase().equals("true")) {
            this.editMenu.addSeparator();
        }
        this.addMenuItem(this.editMenu, Messages.getMessage("PdfViewerEditMenuPreferences.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Preferences"), 24);
        this.viewMenu = new JMenu(Messages.getMessage("PdfViewerViewMenu.text"));
        this.addToMainMenu(this.viewMenu);
        this.goToMenu = new JMenu(Messages.getMessage("GoToViewMenuGoto.text"));
        this.viewMenu.add(this.goToMenu);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.FirstPage"), "", 50);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.BackPage"), "", 52);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.ForwardPage"), "", 53);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.LastPage"), "", 55);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.GoTo"), "", 56);
        addSeparator = this.properties.getValue("Previousdocument") + this.properties.getValue("Nextdocument");
        if (addSeparator.length() > 0 && addSeparator.toLowerCase().contains("true")) {
            this.goToMenu.addSeparator();
        }
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.PreviousDoucment"), "", 16);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.NextDoucment"), "", 17);
        String[] descriptions = new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.Facing"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing"), Messages.getMessage("PageLayoutViewMenu.PageFlow")};
        int[] value = new int[]{1, 2, 3, 4, 5};
        if (this.isSingle) {
            this.initLayoutMenus(this.pageLayoutMenu, descriptions, value);
        }
        if (this.properties.getValue("separateCover").equals("true")) {
            this.addMenuItem(this.viewMenu, Messages.getMessage("PdfViewerViewMenuSeparateCover.text"), Messages.getMessage("PdfViewerViewMenuTooltip.separateCover"), 32, true);
        }
        if (this.properties.getValue("panMode").equals("true")) {
            this.addMenuItem(this.viewMenu, Messages.getMessage("PdfViewerViewMenuPanMode.text"), Messages.getMessage("PdfViewerViewMenuTooltip.panMode"), 30);
        }
        if (this.properties.getValue("textSelect").equals("true")) {
            this.addMenuItem(this.viewMenu, Messages.getMessage("PdfViewerViewMenuTextSelectMode.text"), Messages.getMessage("PdfViewerViewMenuTooltip.textSelect"), 31);
        }
        if ((addSeparator = this.properties.getValue("Fullscreen")).length() > 0 && addSeparator.toLowerCase().contains("true")) {
            this.goToMenu.addSeparator();
        }
        this.addMenuItem(this.viewMenu, Messages.getMessage("PdfViewerViewMenuFullScreenMode.text"), Messages.getMessage("PdfViewerViewMenuTooltip.fullScreenMode"), 61);
        if (!this.isSingle) {
            this.windowMenu = new JMenu(Messages.getMessage("PdfViewerWindowMenu.text"));
            this.addToMainMenu(this.windowMenu);
            this.addMenuItem(this.windowMenu, Messages.getMessage("PdfViewerWindowMenuCascade.text"), "", 21);
            this.addMenuItem(this.windowMenu, Messages.getMessage("PdfViewerWindowMenuTile.text"), "", 22);
        }
        if (this.commonValues.isItextOnClasspath()) {
            this.pageToolsMenu = new JMenu(Messages.getMessage("PdfViewerPageToolsMenu.text"));
            this.addToMainMenu(this.pageToolsMenu);
            this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuRotate.text"), "", 502);
            this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuDelete.text"), "", 503);
            this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuAddPage.text"), "", 504);
            this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuAddHeaderFooter.text"), "", 506);
            this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuStampText.text"), "", 507);
            this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuStampImage.text"), "", 508);
            this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuSetCrop.text"), "", 509);
        }
        this.helpMenu = new JMenu(Messages.getMessage("PdfViewerHelpMenu.text"));
        this.addToMainMenu(this.helpMenu);
        this.addMenuItem(this.helpMenu, Messages.getMessage("PdfViewerHelpMenu.VisitWebsite"), "", 15);
        this.addMenuItem(this.helpMenu, Messages.getMessage("PdfViewerHelpMenuTip.text"), "", 20);
        this.addMenuItem(this.helpMenu, Messages.getMessage("PdfViewerHelpMenuUpdates.text"), "", 23);
        this.addMenuItem(this.helpMenu, Messages.getMessage("PdfViewerHelpMenuabout.text"), Messages.getMessage("PdfViewerHelpMenuTooltip.about"), 1);
    }

    @Override
    public void addToMainMenu(JMenu fileMenuList) {
        this.currentMenu.add(fileMenuList);
    }

    @Override
    public Container getFrame() {
        return this.frame;
    }

    @Override
    public JToolBar getTopButtonBar() {
        return this.topButtons;
    }

    public JToolBar getDisplaySettingsBar() {
        return this.comboBoxBar;
    }

    public JMenuBar getMenuBar() {
        return this.currentMenu;
    }

    @Override
    public void showMessageDialog(Object message1) {
        boolean showMessage = true;
        if (this.customMessageHandler != null) {
            showMessage = this.customMessageHandler.showMessage(message1);
        }
        if (showMessage) {
            JOptionPane.showMessageDialog(this.frame, message1);
        }
    }

    public int showMessageDialog(Object message1, Object[] options, int selectedChoice) {
        int n = 0;
        boolean showMessage = true;
        if (this.customMessageHandler != null) {
            showMessage = this.customMessageHandler.showMessage(message1);
        }
        if (showMessage) {
            n = JOptionPane.showOptionDialog(this.frame, message1, "Message", 1, 3, null, options, options[selectedChoice]);
        }
        return n;
    }

    @Override
    public void showMessageDialog(Object message, String title, int type) {
        boolean showMessage = true;
        if (this.customMessageHandler != null) {
            showMessage = this.customMessageHandler.showMessage(message);
        }
        if (showMessage) {
            JOptionPane.showMessageDialog(this.frame, message, title, type);
        }
    }

    @Override
    public String showInputDialog(Object message, String title, int type) {
        String returnMessage = null;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestInput(new Object[]{message, title, title});
        }
        if (returnMessage == null) {
            return JOptionPane.showInputDialog(this.frame, message, title, type);
        }
        return returnMessage;
    }

    @Override
    public String showInputDialog(String message) {
        String returnMessage = null;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestInput(new String[]{message});
        }
        if (returnMessage == null) {
            return JOptionPane.showInputDialog(this.frame, (Object)message);
        }
        return returnMessage;
    }

    @Override
    public int showOptionDialog(Object displayValue, String message, int option, int type, Object icon, Object[] options, Object initial) {
        int returnMessage = -1;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestConfirm(new Object[]{displayValue, message, String.valueOf(option), String.valueOf(type), icon, options, initial});
        }
        if (returnMessage == -1) {
            return JOptionPane.showOptionDialog(this.frame, displayValue, message, option, type, (Icon)icon, options, initial);
        }
        return returnMessage;
    }

    @Override
    public int showConfirmDialog(String message, String message2, int option) {
        int returnMessage = -1;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestConfirm(new Object[]{message, message2, String.valueOf(option)});
        }
        if (returnMessage == -1) {
            return JOptionPane.showConfirmDialog(this.frame, message, message2, option);
        }
        return returnMessage;
    }

    @Override
    public int showOverwriteDialog(String file, boolean yesToAllPresent) {
        int n = -1;
        int returnMessage = -1;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestConfirm(new Object[]{file, String.valueOf(yesToAllPresent)});
        }
        if (returnMessage != -1) {
            return returnMessage;
        }
        if (yesToAllPresent) {
            Object[] buttonRowObjects = new Object[]{Messages.getMessage("PdfViewerConfirmButton.Yes"), Messages.getMessage("PdfViewerConfirmButton.YesToAll"), Messages.getMessage("PdfViewerConfirmButton.No"), Messages.getMessage("PdfViewerConfirmButton.Cancel")};
            n = JOptionPane.showOptionDialog(this.frame, file + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Overwrite"), -1, 3, null, buttonRowObjects, buttonRowObjects[0]);
        } else {
            n = JOptionPane.showOptionDialog(this.frame, file + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Overwrite"), 0, 3, null, null, null);
        }
        return n;
    }

    @Override
    public void showMessageDialog(JTextArea info) {
        boolean showMessage = true;
        if (this.customMessageHandler != null) {
            showMessage = this.customMessageHandler.showMessage(info);
        }
        if (showMessage) {
            JOptionPane.showMessageDialog(this.frame, info);
        }
    }

    @Override
    public void showItextPopup() {
        JEditorPane p = new JEditorPane("text/html", "Itext is not on the classpath.<BR>JPedal includes code to take advantage of itext and<BR>provide additional functionality with options<BR>to spilt pdf files, and resave forms data<BR>\nItext website - <a href=http://itextpdf.com/>http://itextpdf.com</a>");
        p.setEditable(false);
        p.setOpaque(false);
        p.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        BrowserLauncher.openURL("http://itextpdf.com/");
                    }
                    catch (IOException e1) {
                        SwingGUI.this.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                    }
                }
            }
        });
        boolean showMessage = true;
        if (this.customMessageHandler != null) {
            showMessage = this.customMessageHandler.showMessage(p);
        }
        if (showMessage) {
            this.showMessageDialog(p);
        }
    }

    @Override
    public void showFirstTimePopup() {
        boolean showMessage;
        boolean bl = showMessage = this.customMessageHandler != null && this.customMessageHandler.showMessage("first time popup") || this.customMessageHandler == null;
        if (!showMessage || this.commonValues.getModeOfOperation() == 1) {
            return;
        }
        try {
            final JPanel a = new JPanel();
            a.setLayout(new BoxLayout(a, 1));
            JLabel m1 = new JLabel(Messages.getMessage("PdfViewerGPL.message1"));
            JLabel m2 = new JLabel(Messages.getMessage("PdfViewerGPL.message2"));
            JLabel m3 = new JLabel(Messages.getMessage("PdfViewerGPL.message3"));
            m1.setFont(m1.getFont().deriveFont(1));
            m1.setAlignmentX(0.5f);
            m2.setAlignmentX(0.5f);
            m3.setAlignmentX(0.5f);
            a.add(m1);
            a.add(Box.createRigidArea(new Dimension(14, 14)));
            a.add(m2);
            a.add(m3);
            a.add(Box.createRigidArea(new Dimension(10, 10)));
            MouseAdapter supportListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (SingleDisplay.allowChangeCursor) {
                        a.setCursor(new Cursor(12));
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (SingleDisplay.allowChangeCursor) {
                        a.setCursor(new Cursor(0));
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        BrowserLauncher.openURL(Messages.getMessage("PdfViewer.SupportLink.Link"));
                    }
                    catch (IOException e1) {
                        SwingGUI.this.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                    }
                }
            };
            JLabel img = new JLabel(new ImageIcon(this.getClass().getResource("/org/jpedal/examples/viewer/res/supportScreenshot.png")));
            img.setBorder(BorderFactory.createRaisedBevelBorder());
            img.setAlignmentX(0.5f);
            img.addMouseListener(supportListener);
            a.add(img);
            JLabel supportLink = new JLabel("<html><center><u>" + Messages.getMessage("PdfViewer.SupportLink.Text1") + ' ' + Messages.getMessage("PdfViewer.SupportLink.Text2") + "</u></html>");
            supportLink.setMaximumSize(new Dimension(245, 60));
            supportLink.setForeground(Color.BLUE);
            supportLink.addMouseListener(supportListener);
            supportLink.setAlignmentX(0.5f);
            a.add(supportLink);
            a.add(Box.createRigidArea(new Dimension(10, 10)));
            JOptionPane.showMessageDialog(this.frame, a, Messages.getMessage("PdfViewerTitle.RunningFirstTime"), -1);
        }
        catch (Exception e) {
            System.err.println(Messages.getMessage("PdfViewerFirstRunDialog.Error"));
        }
        catch (Error e) {
            System.err.println(Messages.getMessage("PdfViewerFirstRunDialog.Error"));
        }
    }

    @Override
    public int showConfirmDialog(Object message, String title, int optionType, int messageType) {
        int returnMessage = -1;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestConfirm(new Object[]{message, title, String.valueOf(optionType), String.valueOf(messageType)});
        }
        if (returnMessage == -1) {
            return JOptionPane.showConfirmDialog(this.frame, message, title, optionType, messageType);
        }
        return returnMessage;
    }

    public void setDownloadProgress(String message, int percentage) {
        this.downloadBar.setProgress(message, percentage);
        if (this.useNewLayout) {
            this.setMultibox(new int[0]);
        }
    }

    @Override
    public void updateStatusMessage(String message) {
        this.statusBar.updateStatus(message, 0);
    }

    @Override
    public void resetStatusMessage(String message) {
        this.statusBar.resetStatus(message);
    }

    @Override
    public void setStatusProgress(int size) {
        this.statusBar.setProgress(size);
        if (this.useNewLayout) {
            this.setMultibox(new int[0]);
        }
    }

    @Override
    public boolean isPDFOutlineVisible() {
        return this.navOptionsPanel.isVisible();
    }

    @Override
    public void setPDFOutlineVisible(boolean visible) {
        this.navOptionsPanel.setVisible(visible);
    }

    @Override
    public void setSplitDividerLocation(int size) {
        this.displayPane.setDividerLocation(size);
    }

    @Override
    public void setQualityBoxVisible(boolean visible) {
    }

    private void setThumbnails() {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                if (SwingGUI.this.thumbnails.isShownOnscreen()) {
                    SwingGUI.this.setupThumbnailPanel();
                    if (SwingGUI.this.decode_pdf.getDisplayView() == 1) {
                        SwingGUI.this.thumbnails.generateOtherVisibleThumbnails(SwingGUI.this.commonValues.getCurrentPage());
                    }
                }
                return null;
            }
        };
        worker.start();
    }

    public void setSearchText(JTextField searchText) {
        this.searchText = searchText;
    }

    public void setResults(SearchList results) {
        this.results = results;
    }

    public SearchList getResults() {
        return this.results;
    }

    public JToolBar getNavigationBar() {
        return this.navButtons;
    }

    public JTabbedPane getSideTabBar() {
        return this.navOptionsPanel;
    }

    public ButtonGroup getSearchLayoutGroup() {
        return this.searchLayoutGroup;
    }

    public void setSearchFrame(GUISearchWindow searchFrame) {
        this.searchFrame = searchFrame;
    }

    public void removeSearchWindow(boolean justHide) {
        this.searchFrame.removeSearchWindow(justHide);
    }

    public void showPreferencesDialog() {
        SwingProperties p = new SwingProperties();
        p.setParent(this.frame);
        p.showPreferenceWindow(this);
    }

    public void setFrame(Container frame) {
        this.frame = frame;
    }

    public void getRSSBox() {
        final JPanel panel = new JPanel();
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 1));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel label = new JLabel("Click on the link below to load a web browser and sign up to our RSS feed.");
        label.setAlignmentX(0.0f);
        labelPanel.add(label);
        labelPanel.add(Box.createHorizontalGlue());
        top.add(labelPanel);
        JPanel linkPanel = new JPanel();
        linkPanel.setLayout(new BoxLayout(linkPanel, 0));
        linkPanel.add(Box.createHorizontalGlue());
        linkPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        final JLabel url = new JLabel("<html><center>http://www.jpedal.org/jpedal.rss");
        url.setAlignmentX(0.0f);
        url.setForeground(Color.blue);
        url.setHorizontalAlignment(0);
        url.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SingleDisplay.allowChangeCursor) {
                    panel.getTopLevelAncestor().setCursor(new Cursor(12));
                }
                url.setText("<html><center><a>http://www.jpedal.org/jpedal.rss</a></center>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (SingleDisplay.allowChangeCursor) {
                    panel.getTopLevelAncestor().setCursor(new Cursor(0));
                }
                url.setText("<html><center>http://www.jpedal.org/jpedal.rss");
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    BrowserLauncher.openURL("http://www.jpedal.org/jpedal.rss");
                }
                catch (IOException e1) {
                    JPanel errorPanel = new JPanel();
                    errorPanel.setLayout(new BoxLayout(errorPanel, 1));
                    JLabel errorMessage = new JLabel("Your web browser could not be successfully loaded.  Please copy and paste the URL below, manually into your web browser.");
                    errorMessage.setAlignmentX(0.0f);
                    errorMessage.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    JTextArea textArea = new JTextArea("http://www.jpedal.org/jpedal.rss");
                    textArea.setEditable(false);
                    textArea.setRows(5);
                    textArea.setBorder(BorderFactory.createBevelBorder(1));
                    textArea.setAlignmentX(0.0f);
                    errorPanel.add(errorMessage);
                    errorPanel.add(textArea);
                    SwingGUI.this.showMessageDialog((Object)errorPanel, "Error loading web browser", -1);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        linkPanel.add(url);
        linkPanel.add(Box.createHorizontalGlue());
        top.add(linkPanel);
        JLabel image = new JLabel(new ImageIcon(this.getClass().getResource("/org/jpedal/examples/viewer/res/rss.png")));
        image.setBorder(BorderFactory.createBevelBorder(1));
        JPanel imagePanel = new JPanel();
        imagePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        imagePanel.setLayout(new BoxLayout(imagePanel, 0));
        imagePanel.add(Box.createHorizontalGlue());
        imagePanel.add(image);
        imagePanel.add(Box.createHorizontalGlue());
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(top);
        panel.add(imagePanel);
        this.showMessageDialog((Object)panel, "Subscribe to JPedal RSS Feed", -1);
    }

    private void loadProperties() {
        try {
            int i;
            Component[] c = this.comboBoxBar.getComponents();
            boolean set = false;
            String propValue = "";
            propValue = this.properties.getValue("sideTabBarCollapseLength");
            if (propValue.length() > 0) {
                int value;
                startSize = value = Integer.parseInt(propValue);
                this.reinitialiseTabs(false);
            }
            set = (propValue = this.properties.getValue("ShowMenubar")).length() > 0 && propValue.toLowerCase().equals("true");
            this.currentMenu.setEnabled(set);
            this.currentMenu.setVisible(set);
            propValue = this.properties.getValue("ShowButtons");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.topButtons.setEnabled(set);
            this.topButtons.setVisible(set);
            propValue = this.properties.getValue("ShowDisplayoptions");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.comboBoxBar.setEnabled(set);
            this.comboBoxBar.setVisible(set);
            propValue = this.properties.getValue("ShowNavigationbar");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.navButtons.setEnabled(set);
            this.navButtons.setVisible(set);
            if (this.displayPane != null) {
                propValue = this.properties.getValue("ShowSidetabbar");
                boolean bl = set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                if (!set) {
                    this.displayPane.setDividerSize(0);
                } else {
                    this.displayPane.setDividerSize(5);
                }
                this.displayPane.getLeftComponent().setEnabled(set);
                this.displayPane.getLeftComponent().setVisible(set);
            }
            set = (propValue = this.properties.getValue("Firstbottom")).length() > 0 && propValue.toLowerCase().equals("true");
            this.first.setEnabled(set);
            this.first.setVisible(set);
            propValue = this.properties.getValue("Back10bottom");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.fback.setEnabled(set);
            this.fback.setVisible(set);
            propValue = this.properties.getValue("Backbottom");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.back.setEnabled(set);
            this.back.setVisible(set);
            propValue = this.properties.getValue("Gotobottom");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.pageCounter1.setEnabled(set);
            this.pageCounter1.setVisible(set);
            this.pageCounter2.setEnabled(set);
            this.pageCounter2.setVisible(set);
            this.pageCounter3.setEnabled(set);
            this.pageCounter3.setVisible(set);
            propValue = this.properties.getValue("Forwardbottom");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.forward.setEnabled(set);
            this.forward.setVisible(set);
            propValue = this.properties.getValue("Forward10bottom");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.fforward.setEnabled(set);
            this.fforward.setVisible(set);
            propValue = this.properties.getValue("Lastbottom");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.end.setEnabled(set);
            this.end.setVisible(set);
            propValue = this.properties.getValue("Singlebottom");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.singleButton.setVisible(set);
            propValue = this.properties.getValue("Continuousbottom");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.continuousButton.setVisible(set);
            propValue = this.properties.getValue("Continuousfacingbottom");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.continuousFacingButton.setVisible(set);
            propValue = this.properties.getValue("Facingbottom");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.facingButton.setVisible(set);
            propValue = this.properties.getValue("PageFlowbottom");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.pageFlowButton.setVisible(set);
            propValue = this.properties.getValue("Memorybottom");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.memoryBar.setEnabled(set);
            this.memoryBar.setVisible(set);
            propValue = this.properties.getValue("Scalingdisplay");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.scalingBox.setEnabled(set);
            this.scalingBox.setVisible(set);
            for (i = 0; i != c.length; ++i) {
                if (!(c[i] instanceof JLabel) || !((JLabel)c[i]).getText().equals(Messages.getMessage("PdfViewerToolbarScaling.text"))) continue;
                c[i].setEnabled(set);
                c[i].setVisible(set);
            }
            propValue = this.properties.getValue("Rotationdisplay");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.rotationBox.setEnabled(set);
            this.rotationBox.setVisible(set);
            for (i = 0; i != c.length; ++i) {
                if (!(c[i] instanceof JLabel) || !((JLabel)c[i]).getText().equals(Messages.getMessage("PdfViewerToolbarRotation.text"))) continue;
                c[i].setEnabled(set);
                c[i].setVisible(set);
            }
            propValue = this.properties.getValue("Imageopdisplay");
            boolean bl = set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            if (this.qualityBox != null) {
                this.qualityBox.setVisible(set);
                this.qualityBox.setEnabled(set);
            }
            for (i = 0; i != c.length; ++i) {
                if (!(c[i] instanceof JLabel) || !((JLabel)c[i]).getText().equals(Messages.getMessage("PdfViewerToolbarImageOp.text"))) continue;
                c[i].setVisible(set);
                c[i].setEnabled(set);
            }
            propValue = this.properties.getValue("Progressdisplay");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.statusBar.setEnabled(set);
            this.statusBar.setVisible(set);
            propValue = this.properties.getValue("Downloadprogressdisplay");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.downloadBar.setEnabled(set);
            this.downloadBar.setVisible(set);
            propValue = this.properties.getValue("Openfilebutton");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.openButton.setEnabled(set);
            this.openButton.setVisible(set);
            propValue = this.properties.getValue("Printbutton");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.printButton.setEnabled(set);
            this.printButton.setVisible(set);
            propValue = this.properties.getValue("Searchbutton");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.searchButton.setEnabled(set);
            this.searchButton.setVisible(set);
            propValue = this.properties.getValue("Propertiesbutton");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.docPropButton.setEnabled(set);
            this.docPropButton.setVisible(set);
            propValue = this.properties.getValue("Aboutbutton");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.infoButton.setEnabled(set);
            this.infoButton.setVisible(set);
            propValue = this.properties.getValue("Snapshotbutton");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.snapshotButton.setEnabled(set);
            this.snapshotButton.setVisible(set);
            propValue = this.properties.getValue("CursorButton");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.cursor.setEnabled(set);
            this.cursor.setVisible(set);
            propValue = this.properties.getValue("MouseModeButton");
            set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
            this.mouseMode.setEnabled(set);
            this.mouseMode.setVisible(set);
            if (DecoderOptions.isRunningOnMac) {
                propValue = this.properties.getValue("Pagetab");
                set = this.properties.getValue("Pagetab").toLowerCase().equals("true") && this.navOptionsPanel.getTabCount() != 0;
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getTitleAt(i).equals(this.pageTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
                propValue = this.properties.getValue("Bookmarkstab");
                set = this.properties.getValue("Bookmarkstab").toLowerCase().equals("true") && this.navOptionsPanel.getTabCount() != 0;
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getTitleAt(i).equals(this.bookmarksTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
                propValue = this.properties.getValue("Layerstab");
                set = this.properties.getValue("Layerstab").toLowerCase().equals("true") && this.navOptionsPanel.getTabCount() != 0;
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getTitleAt(i).equals(this.layersTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
                propValue = this.properties.getValue("Signaturestab");
                set = this.properties.getValue("Signaturestab").toLowerCase().equals("true") && this.navOptionsPanel.getTabCount() != 0;
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getTitleAt(i).equals(this.signaturesTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
            } else {
                propValue = this.properties.getValue("Pagetab");
                set = this.properties.getValue("Pagetab").toLowerCase().equals("true") && this.navOptionsPanel.getTabCount() != 0;
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getIconAt(i).toString().equals(this.pageTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
                propValue = this.properties.getValue("Bookmarkstab");
                set = this.properties.getValue("Bookmarkstab").toLowerCase().equals("true") && this.navOptionsPanel.getTabCount() != 0;
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getIconAt(i).toString().equals(this.bookmarksTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
                propValue = this.properties.getValue("Layerstab");
                set = this.properties.getValue("Layerstab").toLowerCase().equals("true") && this.navOptionsPanel.getTabCount() != 0;
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getIconAt(i).toString().equals(this.layersTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
                propValue = this.properties.getValue("Signaturestab");
                set = this.properties.getValue("Signaturestab").toLowerCase().equals("true") && this.navOptionsPanel.getTabCount() != 0;
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getIconAt(i).toString().equals(this.signaturesTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
            }
            if (this.fileMenu != null) {
                int k;
                propValue = this.properties.getValue("FileMenu");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.fileMenu.setEnabled(set);
                this.fileMenu.setVisible(set);
                propValue = this.properties.getValue("OpenMenu");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.openMenu.setEnabled(set);
                this.openMenu.setVisible(set);
                propValue = this.properties.getValue("Open");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.open.setEnabled(set);
                this.open.setVisible(set);
                propValue = this.properties.getValue("Openurl");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.openUrl.setEnabled(set);
                this.openUrl.setVisible(set);
                propValue = this.properties.getValue("Save");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.save.setEnabled(set);
                this.save.setVisible(set);
                propValue = this.properties.getValue("Find");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.find.setEnabled(set);
                this.find.setVisible(set);
                propValue = this.properties.getValue("Documentproperties");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.documentProperties.setEnabled(set);
                this.documentProperties.setVisible(set);
                if (this.signPDF != null) {
                    propValue = this.properties.getValue("Signpdf");
                    set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                    this.signPDF.setEnabled(this.commonValues.isItextOnClasspath() && this.commonValues.isEncrypOnClasspath());
                    this.signPDF.setVisible(set);
                }
                set = (propValue = this.properties.getValue("Print")).length() > 0 && propValue.toLowerCase().equals("true");
                this.print.setEnabled(set);
                this.print.setVisible(set);
                propValue = this.properties.getValue("Recentdocuments");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.currentCommands.enableRecentDocuments(set);
                propValue = this.properties.getValue("Exit");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.exit.setEnabled(set);
                this.exit.setVisible(set);
                propValue = this.properties.getValue("EditMenu");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.editMenu.setEnabled(set);
                this.editMenu.setVisible(set);
                propValue = this.properties.getValue("Copy");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.copy.setEnabled(set);
                this.copy.setVisible(set);
                propValue = this.properties.getValue("Selectall");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.selectAll.setEnabled(set);
                this.selectAll.setVisible(set);
                propValue = this.properties.getValue("Deselectall");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.deselectAll.setEnabled(set);
                this.deselectAll.setVisible(set);
                propValue = this.properties.getValue("Preferences");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true") && !this.properties.getValue("readOnly").toLowerCase().equals("true");
                this.preferences.setEnabled(set);
                this.preferences.setVisible(set);
                propValue = this.properties.getValue("ViewMenu");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.viewMenu.setEnabled(set);
                this.viewMenu.setVisible(set);
                propValue = this.properties.getValue("GotoMenu");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.goToMenu.setEnabled(set);
                this.goToMenu.setVisible(set);
                propValue = this.properties.getValue("Firstpage");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.firstPage.setEnabled(set);
                this.firstPage.setVisible(set);
                propValue = this.properties.getValue("Backpage");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.backPage.setEnabled(set);
                this.backPage.setVisible(set);
                propValue = this.properties.getValue("Forwardpage");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.forwardPage.setEnabled(set);
                this.forwardPage.setVisible(set);
                propValue = this.properties.getValue("Lastpage");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.lastPage.setEnabled(set);
                this.lastPage.setVisible(set);
                propValue = this.properties.getValue("Goto");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.goTo.setEnabled(set);
                this.goTo.setVisible(set);
                propValue = this.properties.getValue("Previousdocument");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.previousDocument.setEnabled(set);
                this.previousDocument.setVisible(set);
                propValue = this.properties.getValue("Nextdocument");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.nextDocument.setEnabled(set);
                this.nextDocument.setVisible(set);
                if (this.pageLayoutMenu != null) {
                    propValue = this.properties.getValue("PagelayoutMenu");
                    set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                    this.pageLayoutMenu.setEnabled(set);
                    this.pageLayoutMenu.setVisible(set);
                }
                if (this.single != null) {
                    propValue = this.properties.getValue("Single");
                    set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                    this.single.setEnabled(set);
                    this.single.setVisible(set);
                }
                if (this.continuous != null) {
                    propValue = this.properties.getValue("Continuous");
                    set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                    this.continuous.setEnabled(set);
                    this.continuous.setVisible(set);
                }
                if (this.facing != null) {
                    propValue = this.properties.getValue("Facing");
                    set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                    this.facing.setEnabled(set);
                    this.facing.setVisible(set);
                }
                if (this.continuousFacing != null) {
                    propValue = this.properties.getValue("Continuousfacing");
                    set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                    this.continuousFacing.setEnabled(set);
                    this.continuousFacing.setVisible(set);
                }
                if (this.pageFlow != null) {
                    propValue = this.properties.getValue("PageFlow");
                    set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                    this.pageFlow.setEnabled(set);
                    this.pageFlow.setVisible(set);
                }
                if (this.textSelect != null) {
                    propValue = this.properties.getValue("textSelect");
                    set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                    this.textSelect.setEnabled(set);
                    this.textSelect.setVisible(set);
                }
                if (this.separateCover != null) {
                    propValue = this.properties.getValue("separateCover");
                    set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                    this.separateCover.setEnabled(set);
                    this.separateCover.setVisible(set);
                }
                if (this.panMode != null) {
                    propValue = this.properties.getValue("panMode");
                    set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                    this.panMode.setEnabled(set);
                    this.panMode.setVisible(set);
                }
                if (this.fullscreen != null) {
                    propValue = this.properties.getValue("Fullscreen");
                    set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                    this.fullscreen.setEnabled(set);
                    this.fullscreen.setVisible(set);
                }
                if (this.windowMenu != null) {
                    propValue = this.properties.getValue("WindowMenu");
                    set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                    this.windowMenu.setEnabled(set);
                    this.windowMenu.setVisible(set);
                    propValue = this.properties.getValue("Cascade");
                    set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                    this.cascade.setEnabled(set);
                    this.cascade.setVisible(set);
                    propValue = this.properties.getValue("Tile");
                    set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                    this.tile.setEnabled(set);
                    this.tile.setVisible(set);
                }
                if (this.commonValues.isItextOnClasspath()) {
                    // empty if block
                }
                set = (propValue = this.properties.getValue("HelpMenu")).length() > 0 && propValue.toLowerCase().equals("true");
                this.helpMenu.setEnabled(set);
                this.helpMenu.setVisible(set);
                propValue = this.properties.getValue("Visitwebsite");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.visitWebsite.setEnabled(set);
                this.visitWebsite.setVisible(set);
                propValue = this.properties.getValue("Tipoftheday");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.tipOfTheDay.setEnabled(set);
                this.tipOfTheDay.setVisible(set);
                propValue = this.properties.getValue("Checkupdates");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.checkUpdates.setEnabled(set);
                this.checkUpdates.setVisible(set);
                propValue = this.properties.getValue("About");
                set = propValue.length() > 0 && propValue.toLowerCase().equals("true");
                this.about.setEnabled(set);
                this.about.setVisible(set);
                for (k = 0; k != this.fileMenu.getMenuComponentCount(); ++k) {
                    if (!this.fileMenu.getMenuComponent(k).isVisible()) continue;
                    if (!(this.fileMenu.getMenuComponent(k) instanceof JSeparator)) break;
                    this.fileMenu.remove(this.fileMenu.getMenuComponent(k));
                    break;
                }
                for (k = 0; k != this.editMenu.getMenuComponentCount(); ++k) {
                    if (!this.editMenu.getMenuComponent(k).isVisible()) continue;
                    if (!(this.editMenu.getMenuComponent(k) instanceof JSeparator)) break;
                    this.editMenu.remove(this.editMenu.getMenuComponent(k));
                    break;
                }
                for (k = 0; k != this.viewMenu.getMenuComponentCount(); ++k) {
                    if (!this.viewMenu.getMenuComponent(k).isVisible()) continue;
                    if (!(this.viewMenu.getMenuComponent(k) instanceof JSeparator)) break;
                    this.viewMenu.remove(this.viewMenu.getMenuComponent(k));
                    break;
                }
                for (k = 0; k != this.goToMenu.getMenuComponentCount(); ++k) {
                    if (!this.goToMenu.getMenuComponent(k).isVisible()) continue;
                    if (!(this.goToMenu.getMenuComponent(k) instanceof JSeparator)) break;
                    this.goToMenu.remove(this.goToMenu.getMenuComponent(k));
                    break;
                }
            }
            this.checkButtonSeparators();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public void alterProperty(String value, boolean set) {
        int i;
        Component[] c = this.comboBoxBar.getComponents();
        if (value.equals("ShowMenubar")) {
            this.currentMenu.setEnabled(set);
            this.currentMenu.setVisible(set);
            this.properties.setValue("ShowMenubar", String.valueOf(set));
        }
        if (value.equals("ShowButtons")) {
            this.topButtons.setEnabled(set);
            this.topButtons.setVisible(set);
            this.properties.setValue("ShowButtons", String.valueOf(set));
        }
        if (value.equals("ShowDisplayoptions")) {
            this.comboBoxBar.setEnabled(set);
            this.comboBoxBar.setVisible(set);
            this.properties.setValue("ShowDisplayoptions", String.valueOf(set));
        }
        if (value.equals("ShowNavigationbar")) {
            this.navButtons.setEnabled(set);
            this.navButtons.setVisible(set);
            this.properties.setValue("ShowNavigationbar", String.valueOf(set));
        }
        if (value.equals("ShowSidetabbar")) {
            if (!set) {
                this.displayPane.setDividerSize(0);
            } else {
                this.displayPane.setDividerSize(5);
            }
            this.displayPane.getLeftComponent().setEnabled(set);
            this.displayPane.getLeftComponent().setVisible(set);
            this.properties.setValue("ShowSidetabbar", String.valueOf(set));
        }
        if (value.equals("Firstbottom")) {
            this.first.setEnabled(set);
            this.first.setVisible(set);
        }
        if (value.equals("Back10bottom")) {
            this.fback.setEnabled(set);
            this.fback.setVisible(set);
        }
        if (value.equals("Backbottom")) {
            this.back.setEnabled(set);
            this.back.setVisible(set);
        }
        if (value.equals("Gotobottom")) {
            this.pageCounter1.setEnabled(set);
            this.pageCounter1.setVisible(set);
            this.pageCounter2.setEnabled(set);
            this.pageCounter2.setVisible(set);
            this.pageCounter3.setEnabled(set);
            this.pageCounter3.setVisible(set);
        }
        if (value.equals("Forwardbottom")) {
            this.forward.setEnabled(set);
            this.forward.setVisible(set);
        }
        if (value.equals("Forward10bottom")) {
            this.fforward.setEnabled(set);
            this.fforward.setVisible(set);
        }
        if (value.equals("Lastbottom")) {
            this.end.setEnabled(set);
            this.end.setVisible(set);
        }
        if (value.equals("Singlebottom")) {
            this.singleButton.setVisible(set);
        }
        if (value.equals("Continuousbottom")) {
            this.continuousButton.setVisible(set);
        }
        if (value.equals("Continuousfacingbottom")) {
            this.continuousFacingButton.setVisible(set);
        }
        if (value.equals("Facingbottom")) {
            this.facingButton.setVisible(set);
        }
        if (value.equals("PageFlowbottom")) {
            this.pageFlowButton.setVisible(set);
        }
        if (value.equals("Memorybottom")) {
            this.memoryBar.setEnabled(set);
            this.memoryBar.setVisible(set);
        }
        if (value.equals("Scalingdisplay")) {
            this.scalingBox.setEnabled(set);
            this.scalingBox.setVisible(set);
            for (i = 0; i != c.length; ++i) {
                if (!(c[i] instanceof JLabel) || !((JLabel)c[i]).getText().equals(Messages.getMessage("PdfViewerToolbarScaling.text"))) continue;
                c[i].setEnabled(set);
                c[i].setVisible(set);
                this.properties.setValue("Scalingdisplay", String.valueOf(set));
            }
        }
        if (value.equals("Rotationdisplay")) {
            this.rotationBox.setEnabled(set);
            this.rotationBox.setVisible(set);
            for (i = 0; i != c.length; ++i) {
                if (!(c[i] instanceof JLabel) || !((JLabel)c[i]).getText().equals(Messages.getMessage("PdfViewerToolbarRotation.text"))) continue;
                c[i].setEnabled(set);
                c[i].setVisible(set);
                this.properties.setValue("Rotationdisplay", String.valueOf(set));
            }
        }
        if (value.equals("Imageopdisplay")) {
            this.qualityBox.setVisible(set);
            this.qualityBox.setEnabled(set);
            for (i = 0; i != c.length; ++i) {
                if (!(c[i] instanceof JLabel) || !((JLabel)c[i]).getText().equals(Messages.getMessage("PdfViewerToolbarImageOp.text"))) continue;
                c[i].setVisible(set);
                c[i].setEnabled(set);
                this.properties.setValue("Imageopdisplay", String.valueOf(set));
            }
        }
        if (value.equals("Progressdisplay")) {
            this.statusBar.setEnabled(set);
            this.statusBar.setVisible(set);
            this.properties.setValue("Progressdisplay", String.valueOf(set));
        }
        if (value.equals("Downloadprogressdisplay")) {
            this.downloadBar.setEnabled(set);
            this.downloadBar.setVisible(set);
            this.properties.setValue("Downloadprogressdisplay", String.valueOf(set));
        }
        if (value.equals("Openfilebutton")) {
            this.openButton.setEnabled(set);
            this.openButton.setVisible(set);
        }
        if (value.equals("Printbutton")) {
            this.printButton.setEnabled(set);
            this.printButton.setVisible(set);
        }
        if (value.equals("Searchbutton")) {
            this.searchButton.setEnabled(set);
            this.searchButton.setVisible(set);
        }
        if (value.equals("Propertiesbutton")) {
            this.docPropButton.setEnabled(set);
            this.docPropButton.setVisible(set);
        }
        if (value.equals("Aboutbutton")) {
            this.infoButton.setEnabled(set);
            this.infoButton.setVisible(set);
        }
        if (value.equals("Snapshotbutton")) {
            this.snapshotButton.setEnabled(set);
            this.snapshotButton.setVisible(set);
        }
        if (value.equals("CursorButton")) {
            this.cursor.setEnabled(set);
            this.cursor.setVisible(set);
        }
        if (value.equals("MouseModeButton")) {
            this.mouseMode.setEnabled(set);
            this.mouseMode.setVisible(set);
        }
        if (DecoderOptions.isRunningOnMac) {
            if (value.equals("Pagetab") && this.navOptionsPanel.getTabCount() != 0) {
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getTitleAt(i).equals(this.pageTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
            }
            if (value.equals("Bookmarkstab") && this.navOptionsPanel.getTabCount() != 0) {
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getTitleAt(i).equals(this.bookmarksTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
            }
            if (value.equals("Layerstab") && this.navOptionsPanel.getTabCount() != 0) {
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getTitleAt(i).equals(this.layersTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
            }
            if (value.equals("Signaturestab") && this.navOptionsPanel.getTabCount() != 0) {
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getTitleAt(i).equals(this.signaturesTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
            }
        } else {
            if (value.equals("Pagetab") && this.navOptionsPanel.getTabCount() != 0) {
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getIconAt(i).toString().equals(this.pageTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
            }
            if (value.equals("Bookmarkstab") && this.navOptionsPanel.getTabCount() != 0) {
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getIconAt(i).toString().equals(this.bookmarksTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
            }
            if (value.equals("Layerstab") && this.navOptionsPanel.getTabCount() != 0) {
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getIconAt(i).toString().equals(this.layersTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
            }
            if (value.equals("Signaturestab") && this.navOptionsPanel.getTabCount() != 0) {
                for (i = 0; i < this.navOptionsPanel.getTabCount(); ++i) {
                    if (!this.navOptionsPanel.getIconAt(i).toString().equals(this.signaturesTitle) || set) continue;
                    this.navOptionsPanel.remove(i);
                }
            }
        }
        if (value.equals("FileMenu")) {
            this.fileMenu.setEnabled(set);
            this.fileMenu.setVisible(set);
        }
        if (value.equals("OpenMenu")) {
            this.openMenu.setEnabled(set);
            this.openMenu.setVisible(set);
        }
        if (value.equals("Open")) {
            this.open.setEnabled(set);
            this.open.setVisible(set);
        }
        if (value.equals("Openurl")) {
            this.openUrl.setEnabled(set);
            this.openUrl.setVisible(set);
        }
        if (value.equals("Save")) {
            this.save.setEnabled(set);
            this.save.setVisible(set);
        }
        if (value.equals("Resaveasforms") && this.reSaveAsForms != null) {
            this.reSaveAsForms.setEnabled(set);
            this.reSaveAsForms.setVisible(set);
        }
        if (value.equals("Find")) {
            this.find.setEnabled(set);
            this.find.setVisible(set);
        }
        if (value.equals("Documentproperties")) {
            this.documentProperties.setEnabled(set);
            this.documentProperties.setVisible(set);
        }
        if (value.equals("Signpdf")) {
            this.signPDF.setEnabled(set);
            this.signPDF.setVisible(set);
        }
        if (value.equals("Print")) {
            this.print.setEnabled(set);
            this.print.setVisible(set);
        }
        if (value.equals("Recentdocuments")) {
            this.currentCommands.enableRecentDocuments(set);
        }
        if (value.equals("Exit")) {
            this.exit.setEnabled(set);
            this.exit.setVisible(set);
        }
        if (value.equals("EditMenu")) {
            this.editMenu.setEnabled(set);
            this.editMenu.setVisible(set);
        }
        if (value.equals("Copy")) {
            this.copy.setEnabled(set);
            this.copy.setVisible(set);
        }
        if (value.equals("Selectall")) {
            this.selectAll.setEnabled(set);
            this.selectAll.setVisible(set);
        }
        if (value.equals("Deselectall")) {
            this.deselectAll.setEnabled(set);
            this.deselectAll.setVisible(set);
        }
        if (value.equals("Preferences")) {
            this.preferences.setEnabled(set);
            this.preferences.setVisible(set);
        }
        if (value.equals("ViewMenu")) {
            this.viewMenu.setEnabled(set);
            this.viewMenu.setVisible(set);
        }
        if (value.equals("GotoMenu")) {
            this.goToMenu.setEnabled(set);
            this.goToMenu.setVisible(set);
        }
        if (value.equals("Firstpage")) {
            this.firstPage.setEnabled(set);
            this.firstPage.setVisible(set);
        }
        if (value.equals("Backpage")) {
            this.backPage.setEnabled(set);
            this.backPage.setVisible(set);
        }
        if (value.equals("Forwardpage")) {
            this.forwardPage.setEnabled(set);
            this.forwardPage.setVisible(set);
        }
        if (value.equals("Lastpage")) {
            this.lastPage.setEnabled(set);
            this.lastPage.setVisible(set);
        }
        if (value.equals("Goto")) {
            this.goTo.setEnabled(set);
            this.goTo.setVisible(set);
        }
        if (value.equals("Previousdocument")) {
            this.previousDocument.setEnabled(set);
            this.previousDocument.setVisible(set);
        }
        if (value.equals("Nextdocument")) {
            this.nextDocument.setEnabled(set);
            this.nextDocument.setVisible(set);
        }
        if (value.equals("PagelayoutMenu")) {
            this.pageLayoutMenu.setEnabled(set);
            this.pageLayoutMenu.setVisible(set);
        }
        if (value.equals("Single")) {
            this.single.setEnabled(set);
            this.single.setVisible(set);
        }
        if (value.equals("Continuous")) {
            this.continuous.setEnabled(set);
            this.continuous.setVisible(set);
        }
        if (value.equals("Facing")) {
            this.facing.setEnabled(set);
            this.facing.setVisible(set);
        }
        if (value.equals("Continuousfacing")) {
            this.continuousFacing.setEnabled(set);
            this.continuousFacing.setVisible(set);
        }
        if (this.pageFlow != null && value.equals("PageFlow")) {
            this.pageFlow.setEnabled(set);
            this.pageFlow.setVisible(set);
        }
        if (this.panMode != null && value.equals("panMode")) {
            this.panMode.setEnabled(set);
            this.panMode.setVisible(set);
        }
        if (this.textSelect != null && value.equals("textSelect")) {
            this.textSelect.setEnabled(set);
            this.textSelect.setVisible(set);
        }
        if (value.equals("Fullscreen")) {
            this.fullscreen.setEnabled(set);
            this.fullscreen.setVisible(set);
        }
        if (this.separateCover != null && value.equals("separateCover")) {
            this.separateCover.setEnabled(set);
            this.separateCover.setVisible(set);
        }
        if (this.windowMenu != null) {
            if (value.equals("WindowMenu")) {
                this.windowMenu.setEnabled(set);
                this.windowMenu.setVisible(set);
            }
            if (value.equals("Cascade")) {
                this.cascade.setEnabled(set);
                this.cascade.setVisible(set);
            }
            if (value.equals("Tile")) {
                this.tile.setEnabled(set);
                this.tile.setVisible(set);
            }
        }
        if (this.commonValues.isItextOnClasspath()) {
            if (value.equals("ExportMenu")) {
                this.exportMenu.setEnabled(set);
                this.exportMenu.setVisible(set);
            }
            if (value.equals("PdfMenu")) {
                this.pdfMenu.setEnabled(set);
                this.pdfMenu.setVisible(set);
            }
            if (value.equals("Oneperpage")) {
                this.onePerPage.setEnabled(set);
                this.onePerPage.setVisible(set);
            }
            if (value.equals("Nup")) {
                this.nup.setEnabled(set);
                this.nup.setVisible(set);
            }
            if (value.equals("Handouts")) {
                this.handouts.setEnabled(set);
                this.handouts.setVisible(set);
            }
            if (value.equals("ContentMenu")) {
                this.contentMenu.setEnabled(set);
                this.contentMenu.setVisible(set);
            }
            if (value.equals("Images")) {
                this.images.setEnabled(set);
                this.images.setVisible(set);
            }
            if (value.equals("Text")) {
                this.text.setEnabled(set);
                this.text.setVisible(set);
            }
            if (value.equals("Bitmap")) {
                this.bitmap.setEnabled(set);
                this.bitmap.setVisible(set);
            }
            if (value.equals("PagetoolsMenu")) {
                this.pageToolsMenu.setEnabled(set);
                this.pageToolsMenu.setVisible(set);
            }
            if (value.equals("Rotatepages")) {
                this.rotatePages.setEnabled(set);
                this.rotatePages.setVisible(set);
            }
            if (value.equals("Deletepages")) {
                this.deletePages.setEnabled(set);
                this.deletePages.setVisible(set);
            }
            if (value.equals("Addpage")) {
                this.addPage.setEnabled(set);
                this.addPage.setVisible(set);
            }
            if (value.equals("Addheaderfooter")) {
                this.addHeaderFooter.setEnabled(set);
                this.addHeaderFooter.setVisible(set);
            }
            if (value.equals("Stamptext")) {
                this.stampText.setEnabled(set);
                this.stampText.setVisible(set);
            }
            if (value.equals("Stampimage")) {
                this.stampImage.setEnabled(set);
                this.stampImage.setVisible(set);
            }
            if (value.equals("Crop")) {
                this.crop.setEnabled(set);
                this.crop.setVisible(set);
            }
        }
        if (value.equals("HelpMenu")) {
            this.helpMenu.setEnabled(set);
            this.helpMenu.setVisible(set);
        }
        if (value.equals("Visitwebsite")) {
            this.visitWebsite.setEnabled(set);
            this.visitWebsite.setVisible(set);
        }
        if (value.equals("Tipoftheday")) {
            this.tipOfTheDay.setEnabled(set);
            this.tipOfTheDay.setVisible(set);
        }
        if (value.equals("Checkupdates")) {
            this.checkUpdates.setEnabled(set);
            this.checkUpdates.setVisible(set);
        }
        if (value.equals("About")) {
            this.about.setEnabled(set);
            this.about.setVisible(set);
        }
        this.checkButtonSeparators();
    }

    private void checkButtonSeparators() {
        boolean before = false;
        boolean after = false;
        JComponent currentSep = null;
        for (int k = 0; k != this.topButtons.getComponentCount(); ++k) {
            if (this.topButtons.getComponent(k) instanceof JSeparator) {
                if (currentSep == null) {
                    currentSep = (JSeparator)this.topButtons.getComponent(k);
                    continue;
                }
                if (!before || !after) {
                    currentSep.setVisible(false);
                } else {
                    currentSep.setVisible(true);
                }
                before = before || after;
                after = false;
                currentSep = (JSeparator)this.topButtons.getComponent(k);
                continue;
            }
            if (!this.topButtons.getComponent(k).isVisible()) continue;
            if (currentSep == null) {
                before = true;
                continue;
            }
            after = true;
        }
        if (currentSep != null) {
            if (!before || !after) {
                currentSep.setVisible(false);
            } else {
                currentSep.setVisible(true);
            }
        }
    }

    public void getHelpBox() {
        final JPanel panel = new JPanel();
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 1));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel label = new JLabel("<html><p>Please click on this link for lots of tutorials and documentation</p>");
        label.setAlignmentX(0.0f);
        labelPanel.add(label);
        labelPanel.add(Box.createHorizontalGlue());
        top.add(labelPanel);
        JPanel linkPanel = new JPanel();
        linkPanel.setLayout(new BoxLayout(linkPanel, 0));
        linkPanel.add(Box.createHorizontalGlue());
        linkPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        final JLabel url = new JLabel("<html><center>http://www.idrsolutions.com/java-pdf-library-support/");
        url.setAlignmentX(0.0f);
        url.setForeground(Color.blue);
        url.setHorizontalAlignment(0);
        url.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SingleDisplay.allowChangeCursor) {
                    panel.getTopLevelAncestor().setCursor(new Cursor(12));
                }
                url.setText("<html><center><a>http://www.jpedal.org/support.php</a></center>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (SingleDisplay.allowChangeCursor) {
                    panel.getTopLevelAncestor().setCursor(new Cursor(0));
                }
                url.setText("<html><center>http://www.jpedal.org/support.php");
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    BrowserLauncher.openURL("http://www.idrsolutions.com/java-pdf-library-support/");
                }
                catch (IOException e1) {
                    JPanel errorPanel = new JPanel();
                    errorPanel.setLayout(new BoxLayout(errorPanel, 1));
                    JLabel errorMessage = new JLabel("Your web browser could not be successfully loaded.  Please copy and paste the URL below, manually into your web browser.");
                    errorMessage.setAlignmentX(0.0f);
                    errorMessage.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    JTextArea textArea = new JTextArea("http://www.idrsolutions.com/java-pdf-library-support/");
                    textArea.setEditable(false);
                    textArea.setRows(5);
                    textArea.setBorder(BorderFactory.createBevelBorder(1));
                    textArea.setAlignmentX(0.0f);
                    errorPanel.add(errorMessage);
                    errorPanel.add(textArea);
                    SwingGUI.this.showMessageDialog((Object)errorPanel, "Error loading web browser", -1);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        linkPanel.add(url);
        linkPanel.add(Box.createHorizontalGlue());
        top.add(linkPanel);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(top);
        this.showMessageDialog((Object)panel, "JPedal Tutorials and documentation", -1);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.pageTitle = null;
        this.bookmarksTitle = null;
        this.signaturesTitle = null;
        this.layersTitle = null;
        this.layoutGroup = null;
        this.searchLayoutGroup = null;
        this.borderGroup = null;
        this.currentCommandListener = null;
        if (this.topButtons != null) {
            this.topButtons.removeAll();
        }
        this.topButtons = null;
        if (this.navButtons != null) {
            this.navButtons.removeAll();
        }
        this.navButtons = null;
        if (this.comboBoxBar != null) {
            this.comboBoxBar.removeAll();
        }
        this.comboBoxBar = null;
        if (this.currentMenu != null) {
            this.currentMenu.removeAll();
        }
        this.currentMenu = null;
        if (this.coords != null) {
            this.coords.removeAll();
        }
        this.coords = null;
        if (this.frame != null) {
            this.frame.removeAll();
        }
        this.frame = null;
        if (this.desktopPane != null) {
            this.desktopPane.removeAll();
        }
        this.desktopPane = null;
        if (this.navOptionsPanel != null) {
            this.navOptionsPanel.removeAll();
        }
        this.navOptionsPanel = null;
        if (this.scrollPane != null) {
            this.scrollPane.removeAll();
        }
        this.scrollPane = null;
        this.headFont = null;
        this.textFont = null;
        this.statusBar = null;
        this.downloadBar = null;
        this.pageCounter2 = null;
        this.pageCounter3 = null;
        this.optimizationLabel = null;
        if (this.signaturesTree != null) {
            this.signaturesTree.setCellRenderer(null);
            this.signaturesTree.removeAll();
        }
        this.signaturesTree = null;
        if (this.layersPanel != null) {
            this.layersPanel.removeAll();
        }
        this.layersPanel = null;
        this.user_dir = null;
        if (this.navToolBar != null) {
            this.navToolBar.removeAll();
        }
        this.navToolBar = null;
        if (this.pagesToolBar != null) {
            this.pagesToolBar.removeAll();
        }
        this.pagesToolBar = null;
        this.nextSearch = null;
        this.previousSearch = null;
        this.layersObject = null;
        if (this.memoryMonitor != null) {
            this.memoryMonitor.stop();
        }
    }

    public Map getHotspots() {
        return this.objs;
    }

    public Point convertPDFto2D(int cx, int cy) {
        float scaling = this.getScaling();
        int inset = SwingGUI.getPDFDisplayInset();
        int rotation = this.getRotation();
        if (this.decode_pdf.getDisplayView() == 1) {
            int tmp;
            if (rotation == 90) {
                tmp = cx - this.cropY;
                cx = cy - this.cropX;
                cy = tmp;
            } else if (rotation == 180) {
                cx = -cx - (this.cropW + this.cropX);
                cy -= this.cropY;
            } else if (rotation == 270) {
                tmp = -(this.cropH + this.cropY) - cx;
                cx = this.cropW + this.cropX + cy;
                cy = tmp;
            } else {
                cx -= this.cropX;
                cy = this.cropH + this.cropY - cy;
            }
        }
        cx = (int)((float)cx * scaling);
        cy = (int)((float)cy * scaling);
        if (this.decode_pdf.getPageAlignment() == 2) {
            int width = this.decode_pdf.getBounds().width;
            int pdfWidth = this.decode_pdf.getPDFWidth();
            if (this.decode_pdf.getDisplayView() != 1) {
                pdfWidth = (int)this.decode_pdf.getMaximumSize().getWidth();
            }
            if (width > pdfWidth) {
                cx += (width - pdfWidth) / 2;
            }
        }
        return new Point(cx += inset, cy += inset);
    }

    public boolean getFormsDirtyFlag() {
        return this.commonValues.isFormsChanged();
    }

    public void setFormsDirtyFlag(boolean dirty) {
        this.commonValues.setFormsChanged(dirty);
    }

    public int getCurrentPage() {
        return this.commonValues.getCurrentPage();
    }

    public boolean getPageTurnScalingAppropriate() {
        return this.pageTurnScalingAppropriate;
    }

    public boolean getDragLeft() {
        return this.dragLeft;
    }

    public boolean getDragTop() {
        return this.dragTop;
    }

    public void setDragCorner(int a) {
        this.dragLeft = a == 998 || a == 996 || a == 995;
        this.dragTop = a == 996 || a == 997;
    }

    public void setCursor(int type) {
        this.decode_pdf.setCursor(this.getCursor(type));
    }

    public BufferedImage getCursorImageForFX(int type) {
        switch (type) {
            case 1: {
                try {
                    return ImageIO.read(this.getURLForImage(this.iconLocation + "grab32.png"));
                }
                catch (Exception e) {
                    return null;
                }
            }
            case 2: {
                try {
                    return ImageIO.read(this.getURLForImage(this.iconLocation + "grabbing32.png"));
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    public Cursor getCursor(int type) {
        switch (type) {
            case 1: {
                if (this.grabCursor == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "grab32.png"));
                    this.grabCursor = kit.createCustomCursor(img, new Point(8, 8), "grab");
                }
                return this.grabCursor;
            }
            case 2: {
                if (this.grabbingCursor == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "grabbing32.png"));
                    this.grabbingCursor = kit.createCustomCursor(img, new Point(8, 8), "grabbing");
                }
                return this.grabbingCursor;
            }
            case 4: {
                if (this.panCursor == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "pan32.png"));
                    this.panCursor = kit.createCustomCursor(img, new Point(10, 10), "pan");
                }
                return this.panCursor;
            }
            case 5: {
                if (this.panCursorL == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "panl32.png"));
                    this.panCursorL = kit.createCustomCursor(img, new Point(11, 10), "panl");
                }
                return this.panCursorL;
            }
            case 6: {
                if (this.panCursorTL == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "pantl32.png"));
                    this.panCursorTL = kit.createCustomCursor(img, new Point(10, 10), "pantl");
                }
                return this.panCursorTL;
            }
            case 7: {
                if (this.panCursorT == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "pant32.png"));
                    this.panCursorT = kit.createCustomCursor(img, new Point(10, 11), "pant");
                }
                return this.panCursorT;
            }
            case 8: {
                if (this.panCursorTR == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "pantr32.png"));
                    this.panCursorTR = kit.createCustomCursor(img, new Point(10, 10), "pantr");
                }
                return this.panCursorTR;
            }
            case 9: {
                if (this.panCursorR == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "panr32.png"));
                    this.panCursorR = kit.createCustomCursor(img, new Point(10, 10), "panr");
                }
                return this.panCursorR;
            }
            case 10: {
                if (this.panCursorBR == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "panbr32.png"));
                    this.panCursorBR = kit.createCustomCursor(img, new Point(10, 10), "panbr");
                }
                return this.panCursorBR;
            }
            case 11: {
                if (this.panCursorB == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "panb32.png"));
                    this.panCursorB = kit.createCustomCursor(img, new Point(10, 10), "panb");
                }
                return this.panCursorB;
            }
            case 12: {
                if (this.panCursorBL == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "panbl32.png"));
                    this.panCursorBL = kit.createCustomCursor(img, new Point(10, 10), "panbl");
                }
                return this.panCursorBL;
            }
        }
        return Cursor.getDefaultCursor();
    }

    public void rescanPdfLayers() {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.syncTreeDisplay(this.topLayer, true);
                this.layersPanel.invalidate();
                this.layersPanel.repaint();
            } else {
                Runnable doPaintComponent = new Runnable(){

                    @Override
                    public void run() {
                        SwingGUI.this.syncTreeDisplay(SwingGUI.this.topLayer, true);
                        SwingGUI.this.layersPanel.invalidate();
                        SwingGUI.this.layersPanel.repaint();
                    }
                };
                SwingUtilities.invokeAndWait(doPaintComponent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ScrollListener
    implements AdjustmentListener {
        java.util.Timer t = null;
        int pNum = -1;
        int lastPageSent = -1;
        boolean usingMouseClick = false;
        boolean mousePressed = false;
        boolean showLast = false;
        public BufferedImage lastImage;
        public boolean ignoreChange = false;

        private ScrollListener() {
        }

        private void startTimer() {
            if (this.t != null) {
                this.t.cancel();
            }
            if (SwingGUI.this.thumbnails.isShownOnscreen()) {
                long delay = 175L;
                if (!this.usingMouseClick) {
                    delay = 500L;
                }
                PageListener listener = new PageListener();
                this.t = new java.util.Timer();
                this.t.schedule((TimerTask)listener, delay);
            }
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            this.pNum = e.getAdjustable().getValue() + 1;
            if (!this.mousePressed) {
                this.showLast = false;
                this.lastImage = null;
            }
            if (this.showLast) {
                ((SingleDisplay)SwingGUI.this.decode_pdf.getExternalHandler(16)).setPreviewThumbnail(this.lastImage, "Page " + this.pNum + " of " + SwingGUI.this.decode_pdf.getPageCount());
                SwingGUI.this.decode_pdf.repaint();
            } else if (this.lastImage != null) {
                BufferedImage img = new BufferedImage(this.lastImage.getWidth(), this.lastImage.getHeight(), this.lastImage.getType());
                Graphics2D g2 = (Graphics2D)img.getGraphics();
                g2.drawImage((Image)this.lastImage, 0, 0, null);
                g2.setPaint(new Color(0, 0, 0, 130));
                g2.fillRect(0, 0, this.lastImage.getWidth(), this.lastImage.getHeight());
                String l = "Loading...";
                int textW = g2.getFontMetrics().stringWidth(l);
                int textH = g2.getFontMetrics().getHeight();
                g2.setPaint(Color.WHITE);
                g2.drawString(l, this.lastImage.getWidth() / 2 - textW / 2, this.lastImage.getHeight() / 2 + textH / 2);
                this.lastImage = img;
                this.showLast = true;
                ((SingleDisplay)SwingGUI.this.decode_pdf.getExternalHandler(16)).setPreviewThumbnail(img, "Page " + this.pNum + " of " + SwingGUI.this.decode_pdf.getPageCount());
                SwingGUI.this.decode_pdf.repaint();
            }
            this.startTimer();
            this.ignoreChange = false;
        }

        public synchronized void setThumbnail() {
            if (this.lastPageSent != this.pNum) {
                this.lastPageSent = this.pNum;
                try {
                    BufferedImage image = SwingGUI.this.thumbnails.getImage(this.pNum);
                    if (SwingGUI.this.debugThumbnail) {
                        System.out.println(this.pNum + " " + image);
                    }
                    this.lastImage = image;
                    this.showLast = false;
                    ((SingleDisplay)SwingGUI.this.decode_pdf.getExternalHandler(16)).setPreviewThumbnail(image, "Page " + this.pNum + " of " + SwingGUI.this.decode_pdf.getPageCount());
                    SwingGUI.this.decode_pdf.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void releaseAndUpdate() {
            if (this.usingMouseClick) {
                this.usingMouseClick = false;
            }
            if (this.t != null) {
                this.t.cancel();
            }
            if (SwingGUI.this.decode_pdf.getDisplayView() != 5) {
                ((SingleDisplay)SwingGUI.this.decode_pdf.getExternalHandler(16)).setPreviewThumbnail(null, "Page " + this.pNum + " of " + SwingGUI.this.decode_pdf.getPageCount());
            }
            SwingGUI.this.currentCommands.gotoPage(Integer.toString(this.pNum));
            SwingGUI.this.decode_pdf.repaint();
        }

        class PageListener
        extends TimerTask {
            PageListener() {
            }

            @Override
            public void run() {
                if (ScrollListener.this.mousePressed) {
                    ScrollListener.this.setThumbnail();
                } else {
                    ScrollListener.this.usingMouseClick = false;
                    ScrollListener.this.releaseAndUpdate();
                }
            }
        }
    }

    private class ScrollMouseListener
    extends MouseAdapter {
        private ScrollMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingGUI.this.debugThumbnail) {
                System.out.println("pressed");
            }
            SwingGUI.this.scrollListener.mousePressed = true;
            SwingGUI.this.scrollListener.usingMouseClick = true;
            SwingGUI.this.scrollListener.startTimer();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingGUI.this.debugThumbnail) {
                System.out.println("release");
            }
            if (SwingGUI.this.scrollListener.mousePressed) {
                SwingGUI.this.scrollListener.releaseAndUpdate();
            }
            SwingGUI.this.scrollListener.mousePressed = false;
        }
    }

    private class PageChanger
    implements ActionListener {
        int page;

        public PageChanger(int i) {
            this.page = ++i;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Values.isProcessing() && SwingGUI.this.commonValues.getCurrentPage() != this.page) {
                if (!SwingGUI.this.decode_pdf.isPageAvailable(this.page)) {
                    SwingGUI.this.showMessageDialog("Page " + this.page + " is not yet loaded");
                    return;
                }
                SwingGUI.this.statusBar.resetStatus("");
                SwingGUI.this.currentCommands.gotoPage(Integer.toString(this.page));
            }
        }
    }
}

