/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.jpedal.PdfDecoder;
import org.jpedal.SingleDisplay;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.gui.generic.GUIButton;
import org.jpedal.examples.viewer.gui.generic.GUICombo;
import org.jpedal.examples.viewer.gui.generic.GUIOutline;
import org.jpedal.examples.viewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.viewer.gui.swing.SwingOutline;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.utils.Messages;

public class GUI {
    public GUIButton first;
    public GUIButton fback;
    public GUIButton back;
    public GUIButton forward;
    public GUIButton fforward;
    public GUIButton end;
    public GUIButton singleButton;
    public GUIButton continuousButton;
    public GUIButton continuousFacingButton;
    public GUIButton facingButton;
    public GUIButton pageFlowButton;
    private String[] annotTypes = new String[]{"Other", "Text", "FileAttachment"};
    protected boolean hiResPrinting = false;
    protected Map objs;
    protected boolean bookmarksGenerated = false;
    protected PdfDecoder decode_pdf;
    protected static final int thumbLocation = 200;
    protected static final int minimumScreenWidth = 700;
    protected HashMap pagesDecoded = new HashMap();
    public GUIButton snapshotButton;
    public int cropX;
    public int cropW;
    public int cropH;
    protected int mediaX;
    protected int mediaY;
    public int mediaW;
    public int cropY;
    public int mediaH;
    protected boolean useDownloadWindow = true;
    protected boolean hasOutlinesDrawn = false;
    protected GUIOutline tree = new SwingOutline();
    protected boolean allowScrolling = true;
    protected boolean confirmClose = false;
    protected int divLocation = 170;
    protected boolean showOutlines = true;
    protected float[] scalingFloatValues = new float[]{1.0f, 1.0f, 1.0f, 0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 2.5f, 5.0f, 7.5f, 10.0f};
    protected float scaling = 1.0f;
    protected static int inset = 25;
    protected int rotation = 0;
    protected String[] rotationValues = new String[]{"0", "90", "180", "270"};
    protected GUICombo rotationBox;
    protected GUICombo qualityBox;
    protected GUICombo scalingBox;
    protected static int defaultSelection = 0;
    protected String titleMessage = null;
    protected Values commonValues;
    protected GUIThumbnailPanel thumbnails;
    protected PropertiesFile properties;

    public boolean useHiResPrinting() {
        return this.hiResPrinting;
    }

    public void setHiResPrinting(boolean hiResPrinting) {
        this.hiResPrinting = hiResPrinting;
    }

    public String getPropertiesFileLocation() {
        return this.properties.getConfigFile();
    }

    public void setPropertiesFileLocation(String file) {
        this.properties.loadProperties(file);
    }

    public void setProperties(String item, boolean value) {
        this.properties.setValue(item, String.valueOf(value));
    }

    public void setPreferences(int dpi, int search, int border, boolean scroll, int pageMode, boolean updateDefaultValue, int maxNoOfMultiViewers, boolean showDownloadWindow, boolean useHiResPrinting) {
        SingleDisplay.CURRENT_BORDER_STYLE = border;
        this.properties.setValue("borderType", String.valueOf(border));
        this.allowScrolling = scroll;
        this.properties.setValue("autoScroll", String.valueOf(scroll));
        this.decode_pdf.getDPIFactory().setDpi(dpi);
        this.properties.setValue("resolution", String.valueOf(dpi));
        if (pageMode < 1 || pageMode > 4) {
            pageMode = 1;
        }
        this.decode_pdf.setPageMode(pageMode);
        this.properties.setValue("pageMode", String.valueOf(pageMode));
        this.decode_pdf.repaint();
        String propValue = this.properties.getValue("searchWindowType");
        if (propValue.length() > 0 && !propValue.equals(String.valueOf(search)) && Viewer.showMessages) {
            JOptionPane.showMessageDialog(null, Messages.getMessage("PageLayoutViewMenu.ResetSearch"));
        }
        this.properties.setValue("searchWindowType", String.valueOf(search));
        this.properties.setValue("automaticupdate", String.valueOf(updateDefaultValue));
        this.commonValues.setMaxMiltiViewers(maxNoOfMultiViewers);
        this.properties.setValue("maxmultiviewers", String.valueOf(maxNoOfMultiViewers));
        this.useDownloadWindow = showDownloadWindow;
        this.properties.setValue("showDownloadWindow", String.valueOf(showDownloadWindow));
        this.hiResPrinting = useHiResPrinting;
        this.properties.setValue("useHiResPrinting", String.valueOf(showDownloadWindow));
    }

    public boolean allowScrolling() {
        return this.allowScrolling;
    }

    public boolean confirmClose() {
        return this.confirmClose;
    }

    public String[] getAnnotTypes() {
        return this.annotTypes;
    }

    public void setAutoScrolling(boolean allowScrolling) {
        this.allowScrolling = allowScrolling;
    }

    public void toogleAutoScrolling() {
        this.allowScrolling = !this.allowScrolling;
    }

    public int getRotation() {
        return this.rotation;
    }

    public float getScaling() {
        return this.scaling;
    }

    public void setScaling(float s) {
        this.scaling = s;
        this.scalingBox.setSelectedIndex((int)this.scaling);
    }

    public static int getPDFDisplayInset() {
        return inset;
    }

    public void createUniqueAnnotationIcons() {
    }

    public void setDpi(int dpi) {
        this.decode_pdf.getDPIFactory().setDpi(dpi);
    }

    public boolean isUseDownloadWindow() {
        return this.useDownloadWindow;
    }

    public void setUseDownloadWindow(boolean useDownloadWindow) {
        this.useDownloadWindow = useDownloadWindow;
    }

    public PropertiesFile getProperties() {
        return this.properties;
    }

    public void dispose() {
        this.first = null;
        this.fback = null;
        this.back = null;
        this.forward = null;
        this.fforward = null;
        this.end = null;
        this.singleButton = null;
        this.continuousButton = null;
        this.continuousFacingButton = null;
        this.facingButton = null;
        this.pageFlowButton = null;
        this.annotTypes = null;
        this.pagesDecoded = null;
        this.snapshotButton = null;
        this.tree = null;
        this.pagesDecoded = null;
        this.snapshotButton = null;
        this.scalingFloatValues = null;
        this.rotationValues = null;
        this.rotationBox = null;
        this.qualityBox = null;
        this.scalingBox = null;
        this.titleMessage = null;
    }
}

