/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.utils.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BaseTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -597466738767831075L;
    protected Commands currentCommands;
    protected SwingGUI currentGUI;
    protected GUIThumbnailPanel thumbnails;
    protected Values commonValues;

    public BaseTransferHandler(Values commonValues, GUIThumbnailPanel thumbnails, SwingGUI currentGUI, Commands currentCommands) {
        this.commonValues = commonValues;
        this.thumbnails = thumbnails;
        this.currentGUI = currentGUI;
        this.currentCommands = currentCommands;
    }

    @Override
    public boolean canImport(JComponent dest, DataFlavor[] flavors) {
        return true;
    }

    protected Object getImport(Transferable transferable) throws Exception {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        DataFlavor listFlavor = null;
        int lastFlavor = flavors.length - 1;
        for (int f = 0; f <= lastFlavor; ++f) {
            if (!flavors[f].isFlavorJavaFileListType()) continue;
            listFlavor = flavors[f];
        }
        try {
            DataFlavor bestTextFlavor = DataFlavor.selectBestTextFlavor(flavors);
            if (bestTextFlavor != null) {
                Reader r = bestTextFlavor.getReaderForText(transferable);
                String textData = BaseTransferHandler.readTextDate(r);
                if ((textData = BaseTransferHandler.removeChar(textData, '\u0000')).contains("ftp:/")) {
                    this.currentGUI.showMessageDialog("Files cannot be opened via FTP");
                    return null;
                }
                textData = BaseTransferHandler.getURL(textData);
                textData = textData.replaceAll("%20", " ");
                return textData;
            }
            if (listFlavor != null) {
                return transferable.getTransferData(listFlavor);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static String removeChar(String s, char c) {
        String r = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            r = r + s.charAt(i);
        }
        return r;
    }

    private static String getURL(String textData) throws ParserConfigurationException, SAXException, IOException {
        if (!textData.startsWith("http://") && !textData.startsWith("file://")) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(StringUtils.toBytes(textData)));
            Element a = (Element)doc.getElementsByTagName("a").item(0);
            textData = BaseTransferHandler.getHrefAttribute(a);
        }
        return textData;
    }

    private static String readTextDate(Reader r) throws IOException {
        BufferedReader br = new BufferedReader(r);
        String textData = "";
        String line = br.readLine();
        while (line != null) {
            textData = textData + line;
            line = br.readLine();
        }
        br.close();
        return textData;
    }

    private static String getHrefAttribute(Element element) {
        NamedNodeMap attrs = element.getAttributes();
        Node nameNode = attrs.getNamedItem("href");
        if (nameNode != null) {
            return nameNode.getNodeValue();
        }
        return null;
    }
}

