/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.LogWriter;

public class ThumbnailDecoder {
    private PdfDecoder decode_pdf;

    public ThumbnailDecoder(PdfDecoder decode_pdf) {
        this.decode_pdf = decode_pdf;
    }

    public final synchronized BufferedImage getPageAsThumbnail(int pageNumber, int height) {
        BufferedImage newImg;
        block2: {
            newImg = null;
            try {
                BufferedImage pageImage = this.decode_pdf.getPageAsImage(pageNumber);
                int imgHeight = pageImage.getHeight();
                double scale = (double)height / (double)imgHeight;
                int width = (int)((double)pageImage.getWidth() * scale);
                newImg = new BufferedImage(width, height, 2);
                Graphics g = newImg.getGraphics();
                g.drawImage(pageImage, 0, 0, width, height, null);
                g.dispose();
            }
            catch (PdfException e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return newImg;
    }
}

