/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorSpaces;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.DecoderResults;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.PdfStreamDecoderForSampling;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.ImageDisplay;

public class PDFtoImageConvertor {
    public static Boolean allowPagesSmallerThanPageSize = Boolean.FALSE;
    public static Integer bestQualityMaxScaling = null;
    private float multiplyer = 1.0f;
    Boolean instance_allowPagesSmallerThanPageSize;
    DynamicVectorRenderer htmlDisplay;
    DecoderOptions options = null;
    private Integer instance_bestQualityMaxScaling = null;

    public PDFtoImageConvertor(float multiplyer, DecoderOptions options) {
        this.multiplyer = multiplyer;
        this.instance_allowPagesSmallerThanPageSize = options.getInstance_allowPagesSmallerThanPageSize();
        this.instance_bestQualityMaxScaling = options.getInstance_bestQualityMaxScaling();
        this.options = options;
    }

    public BufferedImage convert(DecoderResults resultsFromDecode, int displayRotation, PdfResources res, int displayView, ExternalHandlers externalHandlers, int renderMode, PdfPageData pageData, AcroRenderer formRenderer, float scaling, PdfObjectReader currentPdfFile, int pageIndex, boolean imageIsTransparent, String currentPageOffset) throws PdfException {
        int w;
        int h;
        PageObject pdfObject = new PageObject(currentPageOffset);
        currentPdfFile.readObject(pdfObject);
        currentPdfFile.checkParentForResources(pdfObject);
        PdfObject Resources = ((PdfObject)pdfObject).getDictionary(2004251818);
        ObjectStore localStore = new ObjectStore(null);
        ImageDisplay imageDisplay = new ImageDisplay(pageIndex, true, 5000, localStore);
        if (imageDisplay.getType() != 4 && imageDisplay.getType() != 5 && imageDisplay.getType() != 6) {
            if (this.options.getPageColor() != null) {
                imageDisplay.setValue(1, this.options.getPageColor().getRGB());
            }
            if (this.options.getTextColor() != null) {
                imageDisplay.setValue(2, this.options.getTextColor().getRGB());
                if (this.options.getChangeTextAndLine()) {
                    imageDisplay.setValue(3, 1);
                } else {
                    imageDisplay.setValue(3, 0);
                }
                imageDisplay.setValue(4, this.options.getReplacementColorThreshold());
            }
        }
        if (this.htmlDisplay != null) {
            imageDisplay.writeCustom(24, this.htmlDisplay);
        }
        PdfStreamDecoder currentImageDecoder = new PdfStreamDecoder(currentPdfFile);
        if (this.htmlDisplay == null) {
            currentImageDecoder.setParameters(true, true, renderMode, 0);
        } else {
            currentImageDecoder.setParameters(true, true, renderMode, 1);
        }
        externalHandlers.addHandlers(currentImageDecoder);
        currentImageDecoder.setObjectValue(-8, localStore);
        currentImageDecoder.setFloatValue(17, this.multiplyer);
        currentImageDecoder.setObjectValue(-18, pageData);
        currentImageDecoder.setIntValue(-10, pageIndex);
        currentImageDecoder.setObjectValue(23, imageDisplay);
        res.setupResources(currentImageDecoder, true, Resources, pageIndex, currentPdfFile);
        if (this.multiplyer == -2.0f) {
            this.multiplyer = -1.0f;
            currentImageDecoder.setFloatValue(17, this.multiplyer);
            PdfStreamDecoderForSampling currentImageDecoder2 = new PdfStreamDecoderForSampling(currentPdfFile);
            currentImageDecoder2.setParameters(true, true, renderMode, 0);
            currentImageDecoder2.setObjectValue(-8, localStore);
            currentImageDecoder2.setFloatValue(17, this.multiplyer);
            currentImageDecoder2.setObjectValue(-18, pageData);
            currentImageDecoder2.setIntValue(-10, pageIndex);
            currentImageDecoder2.setObjectValue(23, imageDisplay);
            res.setupResources(currentImageDecoder2, true, Resources, pageIndex, currentPdfFile);
            this.multiplyer = currentImageDecoder2.decodePageContentForImageSampling(pdfObject);
            int bestQualityMaxScalingToUse = 0;
            if (this.instance_bestQualityMaxScaling != null) {
                bestQualityMaxScalingToUse = this.instance_bestQualityMaxScaling;
            } else if (bestQualityMaxScaling != null) {
                bestQualityMaxScalingToUse = bestQualityMaxScaling;
            }
            if (bestQualityMaxScalingToUse > 0 && this.multiplyer > (float)bestQualityMaxScalingToUse) {
                this.multiplyer = bestQualityMaxScalingToUse;
            }
            currentImageDecoder2.setFloatValue(17, this.multiplyer);
            currentImageDecoder.setFloatValue(17, this.multiplyer);
        }
        if (!allowPagesSmallerThanPageSize.booleanValue() && !this.instance_allowPagesSmallerThanPageSize.booleanValue() && this.multiplyer < 1.0f && this.multiplyer > 0.0f) {
            this.multiplyer = 1.0f;
        }
        if (this.multiplyer == -1.0f) {
            this.multiplyer = 1.0f;
        }
        AffineTransform imageScaling = PDFtoImageConvertor.setPageParametersForImage(scaling * this.multiplyer, pageIndex, pageData);
        int mediaH = (int)(scaling * (float)pageData.getMediaBoxHeight(pageIndex));
        int rotation = pageData.getRotation(pageIndex);
        int crw = (int)(scaling * (float)pageData.getCropBoxWidth(pageIndex));
        int crh = (int)(scaling * (float)pageData.getCropBoxHeight(pageIndex));
        int crx = (int)(scaling * (float)pageData.getCropBoxX(pageIndex));
        int cry = (int)(scaling * (float)pageData.getCropBoxY(pageIndex));
        boolean rotated = false;
        if (rotation == 90 || rotation == 270) {
            h = (int)((float)crw * this.multiplyer);
            w = (int)((float)crh * this.multiplyer);
            rotated = true;
        } else {
            w = (int)((float)crw * this.multiplyer);
            h = (int)((float)crh * this.multiplyer);
        }
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics graphics = image.getGraphics();
        Graphics2D g2 = (Graphics2D)graphics;
        if (!imageIsTransparent) {
            g2.setColor(Color.white);
            g2.fillRect(0, 0, w, h);
        }
        if (rotation == 180) {
            g2.translate((float)(crx * 2) * this.multiplyer, -((float)(cry * 2) * this.multiplyer));
        }
        ((DynamicVectorRenderer)currentImageDecoder.getObjectValue(23)).setScalingValues((float)crx * this.multiplyer, (float)crh * this.multiplyer + (float)cry, this.multiplyer * scaling);
        g2.setRenderingHints(ColorSpaces.hints);
        g2.transform(imageScaling);
        if (rotated) {
            if (rotation == 90) {
                if (this.multiplyer < 1.0f) {
                    cry = (int)(imageScaling.getTranslateX() + (double)cry);
                    crx = (int)(imageScaling.getTranslateY() + (double)crx);
                } else {
                    cry = (int)(imageScaling.getTranslateX() / (double)this.multiplyer + (double)cry);
                    crx = (int)(imageScaling.getTranslateY() / (double)this.multiplyer + (double)crx);
                }
                g2.translate(-crx, -cry);
            } else if (cry < 0) {
                g2.translate(-crx, mediaH - crh + cry);
            } else {
                g2.translate(-crx, mediaH - crh - cry);
            }
        }
        currentImageDecoder.setObjectValue(-7, g2);
        imageDisplay.setG2(g2);
        if (pdfObject != null) {
            currentImageDecoder.setObjectValue(24, this.htmlDisplay);
            currentImageDecoder.decodePageContent(pdfObject);
        }
        g2.setClip(null);
        resultsFromDecode.update(currentImageDecoder, false);
        if (formRenderer != null && formRenderer.hasFormsOnPage(pageIndex) && !formRenderer.ignoreForms()) {
            resultsFromDecode.resetColorSpaces();
            formRenderer.createDisplayComponentsForPage(pageIndex, currentImageDecoder);
            formRenderer.getCompData().renderFormsOntoG2(g2, pageIndex, scaling, 0, displayRotation, null, null, currentPdfFile, pageData.getMediaBoxHeight(pageIndex));
        }
        localStore.flush();
        return image;
    }

    public float getMultiplyer() {
        return this.multiplyer;
    }

    private static AffineTransform setPageParametersForImage(float scaling, int pageNumber, PdfPageData pageData) {
        AffineTransform imageScaling = new AffineTransform();
        int crw = pageData.getCropBoxWidth(pageNumber);
        int crh = pageData.getCropBoxHeight(pageNumber);
        int crx = pageData.getCropBoxX(pageNumber);
        int cry = pageData.getCropBoxY(pageNumber);
        int image_x_size = (int)((float)crw * scaling);
        int image_y_size = (int)((float)crh * scaling);
        int raw_rotation = pageData.getRotation(pageNumber);
        imageScaling.translate((float)(-crx) * scaling, (float)cry * scaling);
        if (raw_rotation == 270) {
            imageScaling.rotate(-1.5707963267948966, image_x_size / 2, image_y_size / 2);
            double x_change = imageScaling.getTranslateX();
            double y_change = imageScaling.getTranslateY();
            imageScaling.translate((double)image_y_size - y_change, -x_change);
            imageScaling.translate((float)(2 * cry) * scaling, 0.0);
            imageScaling.translate(0.0, -scaling * (float)(pageData.getCropBoxHeight(pageNumber) - pageData.getMediaBoxHeight(pageNumber)));
        } else if (raw_rotation == 180) {
            imageScaling.rotate(Math.PI, image_x_size / 2, image_y_size / 2);
        } else if (raw_rotation == 90) {
            imageScaling.rotate(1.5707963267948966, image_x_size / 2, image_y_size / 2);
            double x_change = imageScaling.getTranslateX();
            double y_change = imageScaling.getTranslateY();
            imageScaling.translate(-y_change, (double)image_x_size - x_change);
        }
        if (scaling < 1.0f) {
            imageScaling.translate(image_x_size, image_y_size);
            imageScaling.scale(1.0, -1.0);
            imageScaling.translate(-image_x_size, 0.0);
            imageScaling.scale(scaling, scaling);
        } else {
            imageScaling.translate(image_x_size, image_y_size);
            imageScaling.scale(1.0, -1.0);
            imageScaling.translate(-image_x_size, 0.0);
            imageScaling.scale(scaling, scaling);
        }
        return imageScaling;
    }

    public void setHTMLInvisibleTextHandler(DynamicVectorRenderer htmlDisplay) {
        this.htmlDisplay = htmlDisplay;
    }
}

