/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import org.jpedal.color.GenericColorSpace;

public class CoonsPatch {
    private final double[] points = new double[24];
    protected int pointsAdded;
    protected int colorCompCount;
    protected int colorCompsAdded;
    protected float[][] colors;
    protected ArrayList actualColors;
    protected GeneralPath patchShape;
    protected ArrayList shapes = new ArrayList();
    protected double[][][] calculationPoints;
    protected boolean checkCellBounds;
    protected boolean colorsInitialised;
    private final HashMap bezCacheX;
    private final HashMap bezCacheY;
    protected GenericColorSpace shadingColorSpace;
    private static final int C1 = 3;
    private static final int C2 = 1;
    private static final int D1 = 0;
    private static final int D2 = 2;

    public CoonsPatch(int colorCompCount, GenericColorSpace shadingColorSpace) {
        this.colorCompCount = colorCompCount;
        this.colors = new float[4][colorCompCount];
        this.shadingColorSpace = shadingColorSpace;
        this.bezCacheX = new HashMap();
        this.bezCacheY = new HashMap();
    }

    public void addPoint(double x, double y) {
        if (this.pointsAdded * 2 < this.points.length) {
            this.points[this.pointsAdded * 2] = x;
            this.points[this.pointsAdded * 2 + 1] = y;
        }
        ++this.pointsAdded;
    }

    public void addColorValue(float c) {
        this.colors[this.colorCompsAdded / this.colorCompCount][this.colorCompsAdded % this.colorCompCount] = c;
        ++this.colorCompsAdded;
    }

    private void initialiseColors() {
        this.actualColors = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            float[] values = new float[this.colors[i].length];
            System.arraycopy(this.colors[i], 0, values, 0, this.colors[i].length);
            this.shadingColorSpace.setColor(values, values.length);
            Color c = (Color)((Object)this.shadingColorSpace.getColor());
            this.actualColors.add(c);
        }
    }

    private double[] bezier(double t, int fp) {
        Double key = (double)(2 * fp) + t;
        if (this.bezCacheX.containsKey(key)) {
            return new double[]{(Double)this.bezCacheX.get(key), (Double)this.bezCacheY.get(key)};
        }
        if (fp == 3 || fp == 2) {
            t = 1.0 - t;
        }
        int b = 6 * fp;
        double[] result = new double[2];
        double pow1t3 = Math.pow(1.0 - t, 3.0);
        double pow1t2 = 3.0 * t * Math.pow(1.0 - t, 2.0);
        double powt2 = 3.0 * Math.pow(t, 2.0) * (1.0 - t);
        double powt3 = Math.pow(t, 3.0);
        result[0] = pow1t3 * this.points[b] + pow1t2 * this.points[b + 2] + powt2 * this.points[b + 4] + powt3 * this.points[(b + 6) % 24];
        result[1] = pow1t3 * this.points[b + 1] + pow1t2 * this.points[b + 3] + powt2 * this.points[b + 5] + powt3 * this.points[(b + 7) % 24];
        this.bezCacheX.put(key, result[0]);
        this.bezCacheY.put(key, result[1]);
        return result;
    }

    public void printOntoG2(Graphics2D g2, Rectangle2D bounds, boolean printBack) {
        if (this.shapes.isEmpty()) {
            this.calculate();
        }
        if (printBack) {
            g2.setPaint((Color)this.actualColors.get(0));
            g2.fill(this.patchShape);
        }
        if (this.checkCellBounds) {
            for (Object shape1 : this.shapes) {
                ColorShape shape = (ColorShape)shape1;
                if (!shape.getShape().getBounds2D().intersects(bounds)) continue;
                g2.setPaint(shape.getColor());
                g2.fill(shape.getShape());
            }
        } else {
            for (Object shape1 : this.shapes) {
                ColorShape shape = (ColorShape)shape1;
                g2.setPaint(shape.getColor());
                g2.fill(shape.getShape());
            }
        }
    }

    private double[] mapping(double u, double v) {
        double[] result = new double[2];
        double[] bezC1u = this.bezier(u, 3);
        double[] bezC2u = this.bezier(u, 1);
        result[0] = (1.0 - v) * bezC1u[0] + v * bezC2u[0];
        result[1] = (1.0 - v) * bezC1u[1] + v * bezC2u[1];
        double[] bezD1v = this.bezier(v, 0);
        double[] bezD2v = this.bezier(v, 2);
        result[0] = result[0] + ((1.0 - u) * bezD1v[0] + u * bezD2v[0]);
        result[1] = result[1] + ((1.0 - u) * bezD1v[1] + u * bezD2v[1]);
        double[] bezC10 = this.bezier(0.0, 3);
        double[] bezC11 = this.bezier(1.0, 3);
        double[] bezC20 = this.bezier(0.0, 1);
        double[] bezC21 = this.bezier(1.0, 1);
        result[0] = result[0] - ((1.0 - v) * ((1.0 - u) * bezC10[0] + u * bezC11[0]) + v * ((1.0 - u) * bezC20[0] + u * bezC21[0]));
        result[1] = result[1] - ((1.0 - v) * ((1.0 - u) * bezC10[1] + u * bezC11[1]) + v * ((1.0 - u) * bezC20[1] + u * bezC21[1]));
        return result;
    }

    protected Color calculateColor(double x, double y) {
        if (!this.colorsInitialised) {
            this.initialiseColors();
        }
        double a = (1.0 - x) * y;
        double b = x * y;
        double c = (1.0 - x) * (1.0 - y);
        double d = x * (1.0 - y);
        Color c1 = (Color)this.actualColors.get(1);
        Color c2 = (Color)this.actualColors.get(2);
        Color c3 = (Color)this.actualColors.get(0);
        Color c4 = (Color)this.actualColors.get(3);
        double red = (double)c1.getRed() * a + (double)c2.getRed() * b + (double)c3.getRed() * c + (double)c4.getRed() * d;
        double green = (double)c1.getGreen() * a + (double)c2.getGreen() * b + (double)c3.getGreen() * c + (double)c4.getGreen() * d;
        double blue = (double)c1.getBlue() * a + (double)c2.getBlue() * b + (double)c3.getBlue() * c + (double)c4.getBlue() * d;
        return new Color((int)red, (int)green, (int)blue);
    }

    public void calculate() {
        Rectangle2D patchRect;
        int res;
        if (this.patchShape == null) {
            this.initialiseShape();
        }
        if ((res = (int)(30.0 * ((patchRect = this.patchShape.getBounds2D()).getWidth() + patchRect.getHeight()))) < 4) {
            res = 4;
        }
        if (res > 40) {
            res = 40;
        }
        double div = 1.0 / (double)res;
        this.checkCellBounds = res > 7;
        this.calculationPoints = new double[res + 1][res + 1][2];
        for (int x = 0; x < res + 1; ++x) {
            for (int y = 0; y < res + 1; ++y) {
                double[] m = this.mapping((double)x * div, (double)y * div);
                this.calculationPoints[x][y] = m;
            }
        }
        for (int i = 0; i < res; ++i) {
            for (int j = 0; j < res; ++j) {
                ColorShape shape = new ColorShape(i, j, this.calculateColor(div * (double)i, div * (double)j));
                this.shapes.add(shape);
            }
        }
    }

    private void initialiseShape() {
        this.patchShape = new GeneralPath();
        this.patchShape.moveTo((float)this.points[0], (float)this.points[1]);
        this.patchShape.curveTo((float)this.points[2], (float)this.points[3], (float)this.points[4], (float)this.points[5], (float)this.points[6], (float)this.points[7]);
        this.patchShape.curveTo((float)this.points[8], (float)this.points[9], (float)this.points[10], (float)this.points[11], (float)this.points[12], (float)this.points[13]);
        this.patchShape.curveTo((float)this.points[14], (float)this.points[15], (float)this.points[16], (float)this.points[17], (float)this.points[18], (float)this.points[19]);
        this.patchShape.curveTo((float)this.points[20], (float)this.points[21], (float)this.points[22], (float)this.points[23], (float)this.points[0], (float)this.points[1]);
    }

    public Rectangle2D getBounds2D() {
        if (this.patchShape == null) {
            this.initialiseShape();
        }
        return this.patchShape.getBounds2D();
    }

    public double[] getPoints() {
        return this.points;
    }

    public float[][] getColors() {
        return this.colors;
    }

    protected class ColorShape {
        private final GeneralPath p = new GeneralPath();
        private final Color c;

        ColorShape(int x, int y, Color c) {
            this.p.moveTo((float)CoonsPatch.this.calculationPoints[x][y][0], (float)CoonsPatch.this.calculationPoints[x][y][1]);
            this.p.lineTo((float)CoonsPatch.this.calculationPoints[x + 1][y][0], (float)CoonsPatch.this.calculationPoints[x + 1][y][1]);
            this.p.lineTo((float)CoonsPatch.this.calculationPoints[x + 1][y + 1][0], (float)CoonsPatch.this.calculationPoints[x + 1][y + 1][1]);
            this.p.lineTo((float)CoonsPatch.this.calculationPoints[x][y + 1][0], (float)CoonsPatch.this.calculationPoints[x][y + 1][1]);
            this.p.lineTo((float)CoonsPatch.this.calculationPoints[x][y][0], (float)CoonsPatch.this.calculationPoints[x][y][1]);
            this.c = c;
        }

        public Shape getShape() {
            return this.p;
        }

        public Color getColor() {
            return this.c;
        }
    }
}

