/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import com.idrsolutions.pdf.acroforms.xfa.XFAFormObject;
import com.idrsolutions.pdf.acroforms.xfa.XFAPageContent;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.utils.ConvertToString;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.StreamObject;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XFAFormStream
extends FormStream {
    private static boolean showBug = false;
    private static final boolean debugXFAstream = false;
    private static final boolean showXFAdata = false;
    private boolean calledOnce = false;
    private Node config;
    private Node dataset;
    private Node template;
    private XFAFormObject formObject;
    private LinkedList<XFAFormObject> xfaFormList;
    private String pagenum;
    private int contentX;
    private int contentH;
    private Map<String, String> valueMap = new HashMap<String, String>();
    private static final int UNKNOWN = -1;
    private static final int PAGESET = 1;
    private static final int PAGEAREA = 2;
    private static final int SUBFORM = 3;
    private static final int BREAK = 4;
    private static final int BREAKBEFORE = 5;
    private static final int BREAKAFTER = 6;
    public HashMap<Integer, XFAPageContent> pageMap = new HashMap();
    public ArrayList<Node> pageAreaList = new ArrayList();

    public XFAFormStream(PdfObject acroFormObj, PdfObjectReader inCurrentPdfFile) {
        this.currentPdfFile = inCurrentPdfFile;
        this.readXFA(acroFormObj);
    }

    private Node toDocument(int type, byte[] xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document content = null;
        try {
            content = factory.newDocumentBuilder().parse(new ByteArrayInputStream(xmlString));
        }
        catch (Exception e) {
            content = null;
        }
        return content;
    }

    @Override
    public Node getXFA(int type) {
        Node returnValue = null;
        switch (type) {
            case 1043741046: {
                returnValue = this.config;
                break;
            }
            case 1130793076: {
                returnValue = this.dataset;
                break;
            }
            case 1013350773: {
                returnValue = this.template;
                break;
            }
            case 1031041382: {
                break;
            }
            case 1951819392: {
                break;
            }
            case 1701743524: {
                break;
            }
            case 1026916721: {
                break;
            }
            case 0x363436: {
                break;
            }
            case 2088075366: {
                break;
            }
        }
        return returnValue;
    }

    private void readXFA(PdfObject acroFormObj) {
        PdfObject XFAasStream = null;
        PdfArrayIterator XFAasArray = null;
        XFAasStream = acroFormObj.getDictionary(2627089);
        if (XFAasStream == null && (XFAasArray = acroFormObj.getMixedArray(2627089)) != null && XFAasArray.getTokenCount() == 0) {
            XFAasArray = null;
        }
        if (XFAasStream != null) {
            byte[] decodedStream = XFAasStream.getDecodedStream();
            this.template = XFAFormStream.xmlToNode(1013350773, decodedStream);
        } else {
            StreamObject obj = null;
            int type = 0;
            while (XFAasArray != null && XFAasArray.hasMoreTokens()) {
                type = XFAasArray.getNextValueAsConstant(true);
                obj = new StreamObject(XFAasArray.getNextValueAsString(true));
                this.currentPdfFile.readObject(obj);
                byte[] objData = obj.getDecodedStream();
                switch (type) {
                    case 1043741046: {
                        this.config = this.toDocument(1043741046, objData);
                        break;
                    }
                    case 1130793076: {
                        this.dataset = this.toDocument(1130793076, objData);
                        break;
                    }
                    case 1013350773: {
                        this.template = this.toDocument(1013350773, objData);
                        break;
                    }
                    case 1031041382: {
                        break;
                    }
                    case 1951819392: {
                        break;
                    }
                    case 1701743524: {
                        break;
                    }
                    case 1026916721: {
                        break;
                    }
                    case 0x363436: {
                        break;
                    }
                    case 2088075366: {
                        break;
                    }
                }
            }
        }
    }

    private static Node xmlToNode(int xfaConfig, byte[] decodedStream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            document = factory.newDocumentBuilder().parse(new ByteArrayInputStream(decodedStream));
        }
        catch (Exception e) {
            document = null;
        }
        switch (xfaConfig) {
            case 1043741046: {
                NodeList nodes = document.getElementsByTagName("config");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element element = (Element)nodes.item(i);
                    String att = element.getAttribute("xmlns");
                    if (att.length() <= 0) continue;
                    return element;
                }
                break;
            }
            case 1130793076: {
                NodeList nodes = document.getElementsByTagName("xfa:datasets");
                Element element = (Element)nodes.item(0);
                return element;
            }
            case 1013350773: {
                NodeList nodes = document.getElementsByTagName("template");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element element = (Element)nodes.item(i);
                    String att = element.getAttribute("xmlns:xfa");
                    if (att.length() <= 0) continue;
                    return element;
                }
                break;
            }
        }
        return null;
    }

    @Override
    public boolean hasXFADataSet() {
        return this.dataset != null;
    }

    public FormObject[] createAppearanceString(FormObject[] forms) {
        if (this.calledOnce) {
            return null;
        }
        this.calledOnce = true;
        return this.oldXFA(forms);
    }

    private FormObject[] oldXFA(FormObject[] forms) {
        int i;
        this.xfaFormList = new LinkedList();
        this.parseStream();
        int xfaListSize = this.xfaFormList.size();
        int listSize = forms.length < xfaListSize ? forms.length : xfaListSize;
        FormObject[][] matchedforms = new FormObject[listSize][2];
        for (i = 0; i < listSize; ++i) {
            String newVal;
            String formName;
            matchedforms[i][0] = forms[i];
            if (forms[i] != null) {
                formName = forms[i].getTextStreamValue(36);
                if (formName != null) {
                    int index2 = formName.lastIndexOf("[0]");
                    int n = formName.lastIndexOf(46, index2 - 1);
                    if (n != -1) {
                        formName = index2 != -1 ? formName.substring(n + 1, index2) : formName.substring(n + 1);
                    } else if (index2 != -1) {
                        formName = formName.substring(0, index2);
                    }
                }
            } else {
                formName = null;
            }
            for (Object e : this.xfaFormList) {
                String xfaName;
                XFAFormObject xfaForm = (XFAFormObject)e;
                if (xfaForm == null || !(xfaName = xfaForm.getTextStreamValue(36)).equals(formName)) continue;
                matchedforms[i][1] = xfaForm;
                break;
            }
            if (formName == null || (newVal = this.valueMap.get(formName.toLowerCase())) == null) continue;
            matchedforms[i][0].setTextValue(newVal);
        }
        forms = new FormObject[listSize];
        for (i = 0; i < listSize; ++i) {
            if (matchedforms[i][1] != null) {
                matchedforms[i][1].overwriteWith(matchedforms[i][0]);
                forms[i] = matchedforms[i][1];
                if (showBug) {
                    System.out.println("wrong " + i);
                }
            } else {
                forms[i] = matchedforms[i][0];
                if (showBug) {
                    System.out.println("correct " + i);
                }
            }
            if (!showBug) continue;
            System.out.println(i + " " + forms[i].getTextString());
        }
        return forms;
    }

    protected void parseStream() {
        ArrayList<Node> nodelist = new ArrayList<Node>();
        XFAFormStream.parseNode(this.template, nodelist);
        this.setupTemplate(nodelist.iterator());
        ArrayList<Node> datalist = new ArrayList<Node>();
        XFAFormStream.parseNode(this.dataset, datalist);
        this.setupDataSet(datalist.iterator());
    }

    private void setupDataSet(Iterator<Node> nodeIterator) {
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.next();
            String nodeName = node.getNodeName();
            if (!nodeName.equals("xfa:data")) continue;
            this.data(node, nodeIterator);
        }
    }

    private void data(Node node, Iterator<Node> nodeIterator) {
        NodeList childs = node.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node chnode = childs.item(i);
            NodeList kidNodes = chnode.getChildNodes();
            if (kidNodes.getLength() <= 0) continue;
            Node kidNode = kidNodes.item(0);
            kidNodes = kidNode.getChildNodes();
            String nodeName = kidNode.getNodeName();
            if (kidNodes.getLength() <= 0) continue;
            Node valueNd = kidNodes.item(0);
            this.valueMap.put(nodeName.toLowerCase(), valueNd.getNodeValue());
        }
    }

    private void nextFormObject() {
        if (this.formObject != null) {
            this.xfaFormList.add(this.formObject);
        }
        this.formObject = new XFAFormObject();
    }

    private static void parseNode(Node nodeToParse, ArrayList<Node> nodeList) {
        nodeList.add(nodeToParse);
        NodeList setOfNodes = nodeToParse.getChildNodes();
        for (int i = 0; i < setOfNodes.getLength(); ++i) {
            XFAFormStream.parseNode(setOfNodes.item(i), nodeList);
        }
    }

    private void setupTemplate(Iterator<Node> nodeIterator) {
        while (nodeIterator.hasNext()) {
            Node tmp;
            NamedNodeMap att;
            Node node = nodeIterator.next();
            String nodeName = node.getNodeName();
            if (nodeName.equals("field")) {
                this.field(node, nodeIterator);
                continue;
            }
            if (nodeName.equals("pageArea")) {
                att = node.getAttributes();
                tmp = att.getNamedItem("id");
                this.pagenum = tmp.getNodeValue();
                this.pagenum = this.pagenum.substring(this.pagenum.indexOf("Page") + 4);
                continue;
            }
            if (nodeName.equals("contentArea")) {
                att = node.getAttributes();
                if (att == null) continue;
                tmp = att.getNamedItem("x");
                if (tmp != null) {
                    this.contentX = XFAFormStream.resolveMeasurementToPoints(tmp.getNodeValue());
                }
                if ((tmp = att.getNamedItem("h")) == null) continue;
                this.contentH = XFAFormStream.resolveMeasurementToPoints(tmp.getNodeValue());
                continue;
            }
            if (!nodeName.equals("#document") && !nodeName.equals("templateDesigner")) continue;
        }
        this.nextFormObject();
    }

    private static int resolveMeasurementToPoints(String attValue) {
        int val = 0;
        if (attValue.endsWith("pt")) {
            val = new Double(attValue.substring(0, attValue.indexOf("pt"))).intValue();
        } else if (attValue.endsWith("in")) {
            val = (int)(72.0 * Double.parseDouble(attValue.substring(0, attValue.indexOf("in"))));
        } else if (attValue.endsWith("cm")) {
            val = (int)(28.35 * Double.parseDouble(attValue.substring(0, attValue.indexOf("cm"))));
        } else if (attValue.endsWith("mm")) {
            val = (int)(2.835 * Double.parseDouble(attValue.substring(0, attValue.indexOf("mm"))));
        } else {
            LogWriter.writeFormLog("UNIMPLEMENTED type of y size=" + attValue, false);
        }
        return val;
    }

    private void field(Node nodeToParse, Iterator<Node> nodeIterator) {
        this.nextFormObject();
        this.formObject.setPageNumber(this.pagenum);
        NamedNodeMap att = nodeToParse.getAttributes();
        if (att != null) {
            Node tmp = att.getNamedItem("x");
            if (tmp != null) {
                this.formObject.setX(this.contentX + XFAFormStream.resolveMeasurementToPoints(tmp.getNodeValue()));
            }
            if ((tmp = att.getNamedItem("y")) != null) {
                this.formObject.setY(this.contentH - XFAFormStream.resolveMeasurementToPoints(tmp.getNodeValue()));
            }
            if ((tmp = att.getNamedItem("w")) != null) {
                this.formObject.setWidth(XFAFormStream.resolveMeasurementToPoints(tmp.getNodeValue()));
            }
            if ((tmp = att.getNamedItem("h")) != null) {
                this.formObject.setHeight(XFAFormStream.resolveMeasurementToPoints(tmp.getNodeValue()));
            }
            if ((tmp = att.getNamedItem("name")) != null) {
                this.formObject.setTextStreamValue(36, tmp.getNodeValue());
            } else {
                this.formObject.setTextStreamValue(36, "");
            }
        }
        Node uiNode = null;
        while (nodeIterator.hasNext() && !(uiNode = nodeIterator.next()).getNodeName().equals("ui")) {
            uiNode = null;
        }
        if (uiNode == null) {
            System.out.println("ERROR ERROR  ERROR no ui in field=" + ConvertToString.convertDocumentToString(nodeToParse));
        } else {
            Node tmpNode = null;
            String nodeName = null;
            while (nodeIterator.hasNext()) {
                tmpNode = nodeIterator.next();
                nodeName = tmpNode.getNodeName();
                if (nodeName.equals("checkButton")) {
                    this.checkButton(tmpNode, nodeIterator);
                    continue;
                }
                if (nodeName.equals("button")) {
                    this.button(tmpNode, nodeIterator);
                    continue;
                }
                if (nodeName.equals("choiceList")) {
                    this.choiceList(tmpNode, nodeIterator);
                    continue;
                }
                if (nodeName.equals("textEdit")) {
                    this.textEdit(tmpNode, nodeIterator);
                    continue;
                }
                LogWriter.writeFormLog("node not implemented nodename=" + nodeName, false);
            }
        }
    }

    private void textEdit(Node nodeToParse, Iterator<Node> nodeIterator) {
        this.formObject.setType(9288, true);
        this.formObject.setFlag(13, true);
        this.formObject.setFlag(14, false);
        String nodeName = nodeToParse.getNodeName();
        String nodeValue = nodeToParse.getNodeValue();
        NamedNodeMap att = nodeToParse.getAttributes();
        if (att != null) {
            // empty if block
        }
        while (nodeIterator.hasNext()) {
            Node tmp;
            Node tmpNode = nodeIterator.next();
            String nodename = tmpNode.getNodeName();
            if (nodename.equals("templateDesigner")) continue;
            if (nodename.equals("field")) {
                this.field(tmpNode, nodeIterator);
                continue;
            }
            if (nodename.equals("value") || nodename.equals("caption")) continue;
            if (nodename.equals("text")) {
                if (!nodeIterator.hasNext()) continue;
                Node node = nodeIterator.next();
                continue;
            }
            if (nodename.equals("para")) {
                NamedNodeMap var = tmpNode.getAttributes();
                Node tmp2 = var.getNamedItem("hAlign");
                if (tmp2 != null) {
                    this.formObject.setHorizontalAlign(tmp2.getNodeValue());
                }
                if ((tmp2 = var.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(tmp2.getNodeValue());
                continue;
            }
            if (nodename.equals("font")) {
                tmp = tmpNode.getAttributes().getNamedItem("typeface");
                if (tmp == null) continue;
            }
            if (nodename.equals("edge")) {
                tmp = tmpNode.getAttributes().getNamedItem("stroke");
                if (tmp == null) continue;
                this.formObject.setBorderStroke(tmp.getNodeValue());
                continue;
            }
            if (nodename.equals("border") || nodename.equals("margin") || nodename.equals("proto")) continue;
            LogWriter.writeFormLog("node name not implemented in textEdit name=" + nodename, false);
        }
    }

    private void choiceList(Node nodeToParse, Iterator<Node> nodeIterator) {
        Node tmp;
        this.formObject.setType(4920, true);
        this.formObject.setFlag(18, false);
        String nodeName = nodeToParse.getNodeName();
        String nodeValue = nodeToParse.getNodeValue();
        NamedNodeMap att = nodeToParse.getAttributes();
        if (att != null && (tmp = att.getNamedItem("open")) != null) {
            this.formObject.setChoiceOpening(tmp.getNodeValue());
        }
        while (nodeIterator.hasNext()) {
            Node tmp2;
            Node tmpNode = nodeIterator.next();
            String nodename = tmpNode.getNodeName();
            if (nodename.equals("templateDesigner")) continue;
            if (nodename.equals("field")) {
                this.field(tmpNode, nodeIterator);
                continue;
            }
            if (nodename.equals("value") || nodename.equals("caption") || nodename.equals("items")) continue;
            if (nodename.equals("text")) {
                if (!nodeIterator.hasNext()) continue;
                tmp2 = nodeIterator.next();
                this.formObject.setTextValue(tmp2.getNodeValue());
                continue;
            }
            if (nodename.equals("para")) {
                NamedNodeMap var = tmpNode.getAttributes();
                Node tmp3 = var.getNamedItem("hAlign");
                if (tmp3 != null) {
                    this.formObject.setHorizontalAlign(tmp3.getNodeValue());
                }
                if ((tmp3 = var.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(tmp3.getNodeValue());
                continue;
            }
            if (nodename.equals("font")) {
                tmp2 = tmpNode.getAttributes().getNamedItem("typeface");
                if (tmp2 == null) continue;
            }
            if (nodename.equals("edge")) {
                tmp2 = tmpNode.getAttributes().getNamedItem("stroke");
                if (tmp2 == null) continue;
                this.formObject.setBorderStroke(tmp2.getNodeValue());
                continue;
            }
            if (nodename.equals("border") || nodename.equals("margin") || nodename.equals("draw") || nodename.equals("rectangle")) continue;
            LogWriter.writeFormLog("node name not implemented in choiceList name=" + nodename, false);
        }
    }

    private void button(Node nodeToParse, Iterator<Node> nodeIterator) {
        this.formObject.setType(1197118, true);
        this.formObject.setFlag(17, true);
        String nodeName = nodeToParse.getNodeName();
        String nodeValue = nodeToParse.getNodeValue();
        NamedNodeMap att = nodeToParse.getAttributes();
        if (att != null) {
            // empty if block
        }
        while (nodeIterator.hasNext()) {
            Node tmp;
            Node tmp2;
            Node tmpNode = nodeIterator.next();
            String nodename = tmpNode.getNodeName();
            if (nodename.equals("templateDesigner")) continue;
            if (nodename.equals("field")) {
                this.field(tmpNode, nodeIterator);
                continue;
            }
            if (nodename.equals("edge")) {
                tmp2 = tmpNode.getAttributes().getNamedItem("stroke");
                if (tmp2 == null) continue;
                this.formObject.setBorderStroke(tmp2.getNodeValue());
                continue;
            }
            if (nodename.equals("caption") || nodename.equals("value")) continue;
            if (nodename.equals("text")) {
                if (!nodeIterator.hasNext()) continue;
                tmp2 = nodeIterator.next();
                this.formObject.setNormalCaption(tmp2.getNodeValue());
                continue;
            }
            if (nodename.equals("para")) {
                NamedNodeMap var = tmpNode.getAttributes();
                tmp = var.getNamedItem("hAlign");
                if (tmp != null) {
                    this.formObject.setHorizontalAlign(tmp.getNodeValue());
                }
                if ((tmp = var.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(tmp.getNodeValue());
                continue;
            }
            if (nodename.equals("font")) {
                tmp2 = tmpNode.getAttributes().getNamedItem("typeface");
                if (tmp2 == null) continue;
            }
            if (nodename.equals("border") || nodename.equals("fill")) continue;
            if (nodename.equals("color")) {
                tmp2 = tmpNode.getAttributes().getNamedItem("value");
                if (tmp2 == null) continue;
                this.formObject.setBackgroundColor(tmp2.getNodeValue());
                continue;
            }
            if (nodename.equals("bind")) continue;
            if (nodename.equals("event")) {
                tmp2 = tmpNode.getAttributes().getNamedItem("activity");
                this.formObject.setEventAction(tmp2.getNodeValue());
                continue;
            }
            if (nodename.equals("script")) {
                Node contentType;
                NamedNodeMap tmpatt = tmpNode.getAttributes();
                if (tmpatt != null && (contentType = tmpatt.getNamedItem("contentType")) != null) {
                    this.formObject.setScriptType(contentType.getNodeValue());
                }
                if (!nodeIterator.hasNext() || (tmp = nodeIterator.next()) == null) continue;
                this.formObject.setScript(tmp.getNodeValue());
                continue;
            }
            if (nodename.equals("submit")) {
                Node textEncoding;
                Node target;
                NamedNodeMap subAtt = tmpNode.getAttributes();
                Node format = subAtt.getNamedItem("format");
                if (format != null) {
                    this.formObject.setSubmitFormat(format.getNodeValue());
                }
                if ((target = subAtt.getNamedItem("target")) != null) {
                    this.formObject.setSubmitURL(target.getNodeValue());
                }
                if ((textEncoding = subAtt.getNamedItem("textEncoding")) == null) continue;
                this.formObject.setSubmitTextEncoding(textEncoding.getNodeValue());
                continue;
            }
            LogWriter.writeFormLog("node name not implemented in button name=" + nodename, false);
        }
    }

    private void checkButton(Node nodeToParse, Iterator<Node> nodeIterator) {
        this.formObject.setType(4920, true);
        this.formObject.setFlag(18, true);
        String nodeName = nodeToParse.getNodeName();
        String nodeValue = nodeToParse.getNodeValue();
        NamedNodeMap att = nodeToParse.getAttributes();
        if (att != null) {
            // empty if block
        }
        while (nodeIterator.hasNext()) {
            Node tmp;
            Node tmpNode = nodeIterator.next();
            String nodename = tmpNode.getNodeName();
            if (nodename.equals("templateDesigner")) continue;
            if (nodename.equals("field")) {
                this.field(tmpNode, nodeIterator);
                continue;
            }
            if (nodename.equals("value") || nodename.equals("caption")) continue;
            if (nodename.equals("text")) {
                if (!nodeIterator.hasNext()) continue;
                tmp = nodeIterator.next();
                this.formObject.setTextValue(tmp.getNodeValue());
                continue;
            }
            if (nodename.equals("integer")) {
                if (!nodeIterator.hasNext()) continue;
                tmp = nodeIterator.next();
                this.formObject.setIntegerValue(tmp.getNodeValue());
                continue;
            }
            if (nodename.equals("para")) {
                NamedNodeMap var = tmpNode.getAttributes();
                Node tmp2 = var.getNamedItem("hAlign");
                if (tmp2 != null) {
                    this.formObject.setHorizontalAlign(tmp2.getNodeValue());
                }
                if ((tmp2 = var.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(tmp2.getNodeValue());
                continue;
            }
            if (nodename.equals("font")) {
                tmp = tmpNode.getAttributes().getNamedItem("typeface");
                if (tmp == null) continue;
            }
            if (nodename.equals("edge")) {
                tmp = tmpNode.getAttributes().getNamedItem("stroke");
                if (tmp == null) continue;
                this.formObject.setBorderStroke(tmp.getNodeValue());
                continue;
            }
            if (nodename.equals("border") || nodename.equals("fill") || nodename.equals("margin") || nodename.equals("event") || nodename.equals("items") || nodename.equals("exclGroup") || nodename.equals("proto")) continue;
            LogWriter.writeFormLog("node name not implemented in checkbutton name=" + nodename, false);
        }
    }

    public Map getRefToFormArray() {
        return null;
    }

    private Node getPageAreaNodeById(String strID) {
        for (Node n : this.pageAreaList) {
            Node attr = n.getAttributes().getNamedItem("id");
            if (attr == null || !attr.getNodeValue().equals(strID)) continue;
            return n;
        }
        return null;
    }

    private Node getPageAreaNodeByName(String strName) {
        for (Node n : this.pageAreaList) {
            Node attr = n.getAttributes().getNamedItem("name");
            if (attr == null || !attr.getNodeValue().equals(strName)) continue;
            return n;
        }
        return null;
    }

    private void allocatePagesWithContents(Node node, int depth) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node currentNode = nodeList.item(i);
            int nodeType = this.getNodeType(currentNode.getNodeName());
            if (nodeType == 1) {
                NodeList pageSetChildList = currentNode.getChildNodes();
                for (int z = 0; z < pageSetChildList.getLength(); ++z) {
                    if (this.getNodeType(pageSetChildList.item(z).getNodeName()) != 2) continue;
                    this.pageAreaList.add(pageSetChildList.item(z));
                }
                NodeList childList = currentNode.getParentNode().getChildNodes();
                ArrayList<Node> pageSetSiblings = new ArrayList<Node>();
                for (int z = 0; z < childList.getLength(); ++z) {
                    if (this.getNodeType(childList.item(z).getNodeName()) != 3) continue;
                    pageSetSiblings.add(childList.item(z));
                }
                if (this.pageAreaList.size() == 1 && pageSetSiblings.size() == 1) {
                    XFAPageContent pCont = new XFAPageContent();
                    pCont.setPageAreaNode(this.pageAreaList.get(0));
                    pCont.getNodeList().add((Node)pageSetSiblings.get(0));
                    this.pageMap.put(1, pCont);
                    break;
                }
                int pageCount = 1;
                Node currentPageArea = this.pageAreaList.get(0);
                block3: for (int z = 0; z < pageSetSiblings.size(); ++z) {
                    Node sibNode = (Node)pageSetSiblings.get(z);
                    NodeList sibChildList = sibNode.getChildNodes();
                    for (int q = 0; q < sibChildList.getLength(); ++q) {
                        Node startNewAttr;
                        Node formChild = sibChildList.item(q);
                        int type = this.getNodeType(formChild.getNodeName());
                        if (type == 4) {
                            Node beforeTargetAttr = formChild.getAttributes().getNamedItem("beforeTarget");
                            startNewAttr = formChild.getAttributes().getNamedItem("startNew");
                            if (startNewAttr != null) {
                                if (this.pageAreaList.size() > 1 && pageCount < this.pageAreaList.size()) {
                                    ++pageCount;
                                }
                                if (beforeTargetAttr != null) {
                                    currentPageArea = this.getPageAreaNodeById(beforeTargetAttr.getNodeValue());
                                    break;
                                }
                                currentPageArea = this.pageAreaList.get(pageCount - 1);
                                break;
                            }
                            if (this.pageMap.get(pageCount) == null) break;
                            ++pageCount;
                            break;
                        }
                        if (type == 5) {
                            Node targetAttr = formChild.getAttributes().getNamedItem("target");
                            startNewAttr = formChild.getAttributes().getNamedItem("startNew");
                            if (startNewAttr != null) {
                                if (this.pageAreaList.size() > 1 && pageCount < this.pageAreaList.size()) {
                                    ++pageCount;
                                }
                                if (targetAttr != null) {
                                    currentPageArea = this.getPageAreaNodeById(targetAttr.getNodeValue());
                                    break;
                                }
                                currentPageArea = this.pageAreaList.get(pageCount - 1);
                                break;
                            }
                            if (this.pageMap.get(pageCount) == null) break;
                            ++pageCount;
                            break;
                        }
                        if (type != 6) continue;
                        if (formChild.getAttributes().getNamedItem("startNew") == null) continue block3;
                        if (this.pageMap.get(pageCount) == null) {
                            XFAPageContent pc = new XFAPageContent();
                            pc.setPageAreaNode(currentPageArea);
                            pc.getNodeList().add(sibNode);
                            this.pageMap.put(pageCount, pc);
                        } else {
                            this.pageMap.get(pageCount).getNodeList().add(sibNode);
                        }
                        ++pageCount;
                        continue block3;
                    }
                    if (this.pageMap.get(pageCount) == null) {
                        XFAPageContent pc = new XFAPageContent();
                        pc.setPageAreaNode(currentPageArea);
                        pc.getNodeList().add(sibNode);
                        this.pageMap.put(pageCount, pc);
                        continue;
                    }
                    this.pageMap.get(pageCount).getNodeList().add(sibNode);
                }
                break;
            }
            this.allocatePagesWithContents(currentNode, depth++);
        }
    }

    private int getNodeType(String nodeName) {
        int nodeType = -1;
        String name = nodeName.toLowerCase();
        if (name.equals("pagearea")) {
            nodeType = 2;
        } else if (name.equals("subform")) {
            nodeType = 3;
        } else if (name.equals("pageset")) {
            nodeType = 1;
        } else if (name.equals("break")) {
            nodeType = 4;
        } else if (name.equals("breakbefore")) {
            nodeType = 5;
        } else if (name.equals("breakafter")) {
            nodeType = 6;
        }
        return nodeType;
    }
}

