/*
 * Decompiled with CFR 0.152.
 */
package com.github.kvnxiao.jsonequals;

import com.github.kvnxiao.jsonequals.JsonChildren;
import com.github.kvnxiao.jsonequals.JsonCompareResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.doubledutch.lazyjson.LazyArray;
import me.doubledutch.lazyjson.LazyElement;
import me.doubledutch.lazyjson.LazyObject;
import me.doubledutch.lazyjson.LazyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonEquals {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonEquals.class);
    private static boolean debugMode = false;
    private final LazyType rootType;
    private LazyElement source = null;
    private LazyElement comparate = null;
    private Map<String, String> pruneFields;
    private Set<String> ignoreFields;
    private List<String> successMessages;
    private List<String> inequalityMessages;

    private JsonEquals(LazyType rootType) {
        this.rootType = rootType;
        this.successMessages = new ArrayList<String>();
        this.inequalityMessages = new ArrayList<String>();
    }

    public static JsonEquals ofType(LazyType rootType) {
        return new JsonEquals(rootType);
    }

    public static JsonEquals between(LazyObject source, LazyObject comparate) {
        return new JsonEquals(LazyType.OBJECT).withSource((LazyElement)source).withComparate((LazyElement)comparate);
    }

    public static JsonEquals between(LazyArray source, LazyArray comparate) {
        return new JsonEquals(LazyType.ARRAY).withSource((LazyElement)source).withComparate((LazyElement)comparate);
    }

    public JsonEquals withSource(LazyElement source) {
        this.source = source;
        return this;
    }

    public JsonEquals withComparate(LazyElement comparate) {
        this.comparate = comparate;
        return this;
    }

    public JsonEquals withIgnoreFields(Set<String> ignoreFields) {
        this.ignoreFields = ignoreFields;
        return this;
    }

    public JsonEquals withPruneFields(Map<String, String> pruneFields) {
        this.pruneFields = pruneFields;
        return this;
    }

    public JsonCompareResult compare() {
        if (this.rootType == LazyType.OBJECT) {
            this.compareNode((LazyObject)this.source, (LazyObject)this.comparate);
        } else {
            this.compareNode((LazyArray)this.source, (LazyArray)this.comparate);
        }
        return JsonCompareResult.of(this.inequalityMessages.isEmpty(), this.successMessages, this.inequalityMessages);
    }

    public void compareNode(LazyObject a, LazyObject b) {
        this.compareNode(a, b, "$");
    }

    public void compareNode(LazyArray a, LazyArray b) {
        this.compareNode(a, b, "$");
    }

    public void compareNode(LazyObject a, LazyObject b, String currentPath) {
        Set fieldsB;
        if (this.pathIsIgnoreField(currentPath)) {
            return;
        }
        Set fieldsA = a.keySet();
        if (fieldsA.equals(fieldsB = b.keySet())) {
            for (String fieldName : fieldsA) {
                if (JsonEquals.childIsObject(a, fieldName) && JsonEquals.childIsObject(b, fieldName)) {
                    this.compareNode(a.getJSONObject(fieldName), b.getJSONObject(fieldName), JsonEquals.getChildPath(currentPath, fieldName));
                    continue;
                }
                if (JsonEquals.childIsArray(a, fieldName) && JsonEquals.childIsArray(b, fieldName)) {
                    this.compareNode(a.getJSONArray(fieldName), b.getJSONArray(fieldName), JsonEquals.getChildPath(currentPath, fieldName));
                    continue;
                }
                this.compareValues(a, b, fieldName, JsonEquals.getChildPath(currentPath, fieldName));
            }
        } else {
            this.inequalityMessages.add("JSON objects do not have the same child key names! " + fieldsA + " vs. " + fieldsB);
        }
    }

    public void compareNode(LazyArray a, LazyArray b, String currentPath) {
        if (this.pathIsIgnoreField(currentPath)) {
            return;
        }
        JsonChildren childrenA = this.getChildList(a);
        JsonChildren childrenB = this.getChildList(b);
        if (this.pruneFields != null && !this.pruneFields.isEmpty()) {
            this.prune(childrenA, currentPath, "source");
            this.prune(childrenB, currentPath, "comparate");
        }
        if (!childrenA.isEmpty() && !childrenB.isEmpty()) {
            if (childrenA.objectCount() == childrenB.objectCount() && childrenA.arrayCount() == childrenB.arrayCount() && childrenA.valueCount() == childrenB.valueCount()) {
                for (int i = 0; i < childrenA.size(); ++i) {
                    if (childrenA.getType(i) == JsonChildren.Type.OBJECT && childrenB.getType(i) == JsonChildren.Type.OBJECT) {
                        this.compareNode(childrenA.getObj(i), childrenB.getObj(i), currentPath + "[" + i + "]");
                        continue;
                    }
                    if (childrenA.getType(i) == JsonChildren.Type.ARRAY && childrenB.getType(i) == JsonChildren.Type.ARRAY) {
                        this.compareNode(childrenA.getArr(i), childrenB.getArr(i), currentPath + "[" + i + "]");
                        continue;
                    }
                    if (childrenA.getType(i) == JsonChildren.Type.VALUE && childrenB.getType(i) == JsonChildren.Type.VALUE) {
                        if (debugMode) {
                            LOGGER.debug("Checking array value: {}", (Object)(currentPath + "[" + i + "]"));
                        }
                        if (!childrenA.get(i).equals(childrenB.get(i))) {
                            this.inequalityMessages.add(currentPath + " JSON array value expected to be " + childrenA.get(i) + " but got " + childrenB.get(i));
                            continue;
                        }
                        this.successMessages.add(currentPath + "[" + i + "]" + "==" + childrenA.get(i));
                        continue;
                    }
                    this.inequalityMessages.add(currentPath + "[" + i + "]" + " types were not the same! Expected " + (Object)((Object)childrenA.getType(i)) + " but got " + (Object)((Object)childrenB.getType(i)));
                }
            } else {
                this.inequalityMessages.add(currentPath + " JSON array not equal in length! " + childrenA.size() + " vs " + childrenB.size());
            }
        }
    }

    public void compareValues(LazyObject a, LazyObject b, String fieldName, String currentPath) {
        if (this.pathIsIgnoreField(currentPath)) {
            return;
        }
        if (debugMode) {
            LOGGER.debug("Checking leaf object: {}", (Object)currentPath);
        }
        if (a.getType(fieldName) == LazyType.STRING && b.getType(fieldName) == LazyType.STRING) {
            if (a.getString(fieldName).equals(b.getString(fieldName))) {
                this.successMessages.add(currentPath + "==" + a.getString(fieldName));
            } else {
                this.logInequality(a.getString(fieldName), b.getString(fieldName), currentPath);
            }
        } else if (a.getType(fieldName) == LazyType.INTEGER && b.getType(fieldName) == LazyType.INTEGER) {
            if (a.getInt(fieldName) == b.getInt(fieldName)) {
                this.successMessages.add(currentPath + "==" + a.getString(fieldName));
            } else {
                this.logInequality(a.getString(fieldName), b.getString(fieldName), currentPath);
            }
        } else if (a.getType(fieldName) == LazyType.BOOLEAN && b.getType(fieldName) == LazyType.BOOLEAN) {
            if (a.getBoolean(fieldName) == b.getBoolean(fieldName)) {
                this.successMessages.add(currentPath + "==" + a.getString(fieldName));
            } else {
                this.logInequality(a.getString(fieldName), b.getString(fieldName), currentPath);
            }
        } else if (a.getType(fieldName) == LazyType.FLOAT && b.getType(fieldName) == LazyType.FLOAT) {
            if (a.getString(fieldName).equals(b.getString(fieldName))) {
                this.successMessages.add(currentPath + "==" + a.getString(fieldName));
            } else {
                this.logInequality(a.getString(fieldName), b.getString(fieldName), currentPath);
            }
        } else if (a.getType(fieldName) == LazyType.NULL && b.getType(fieldName) == LazyType.NULL) {
            this.successMessages.add(currentPath + "==" + a.getString(fieldName));
        } else {
            this.inequalityMessages.add(currentPath + " were not of the same type! Expected type " + a.getType(fieldName) + " but got type " + b.getType(fieldName));
        }
    }

    private JsonChildren getChildList(LazyArray parent) {
        JsonChildren jsonChildren = JsonChildren.create();
        block8: for (int i = 0; i < parent.length(); ++i) {
            switch (parent.getType(i)) {
                case OBJECT: {
                    jsonChildren.addChildObject(parent.getJSONObject(i));
                    continue block8;
                }
                case ARRAY: {
                    jsonChildren.addChildArray(parent.getJSONArray(i));
                    continue block8;
                }
                case STRING: {
                    jsonChildren.addChildValue(parent.getString(i));
                    continue block8;
                }
                case INTEGER: {
                    jsonChildren.addChildValue(parent.getInt(i));
                    continue block8;
                }
                case BOOLEAN: {
                    jsonChildren.addChildValue(parent.getBoolean(i));
                    continue block8;
                }
                case FLOAT: {
                    jsonChildren.addChildValue(parent.getDouble(i));
                    continue block8;
                }
                default: {
                    jsonChildren.addChildValue(null);
                }
            }
        }
        return jsonChildren;
    }

    private void prune(JsonChildren children, String currentPath, String identifier) {
        List<Object> childNodes = children.getChildren();
        List<JsonChildren.Type> childTypes = children.getChildrenTypes();
        Iterator<Object> childIterator = childNodes.iterator();
        Iterator<JsonChildren.Type> childTypesIterator = childTypes.iterator();
        int i = 0;
        while (childIterator.hasNext() && childTypesIterator.hasNext()) {
            Object child = childIterator.next();
            JsonChildren.Type childType = childTypesIterator.next();
            if (childType == JsonChildren.Type.OBJECT && this.pathIsPruneField(currentPath + "[" + i + "]", (LazyObject)child)) {
                if (debugMode) {
                    LOGGER.debug("Pruning {} {}{}{}{}", new Object[]{identifier, currentPath, "[", i, "]"});
                }
                childIterator.remove();
                childTypesIterator.remove();
                children.decrementObjCount();
            }
            ++i;
        }
    }

    private boolean pathIsPruneField(String currentPath, LazyObject node) {
        for (Map.Entry<String, String> pruneEntry : this.pruneFields.entrySet()) {
            String key = pruneEntry.getKey();
            String value = pruneEntry.getValue();
            String[] fields = key.split(":");
            if (fields.length == 0 || fields.length > 2) {
                return false;
            }
            if (!JsonEquals.pathEquals(currentPath, fields[0])) continue;
            LazyObject currentNode = node;
            String[] childNodes = fields[1].split("\\.");
            for (int i = 0; i < childNodes.length - 1; ++i) {
                if (currentNode == null || currentNode.getType() != LazyType.OBJECT) {
                    return false;
                }
                currentNode = currentNode.getJSONObject(childNodes[i]);
            }
            if (currentNode == null) continue;
            return this.getValueAsString(currentNode, childNodes[childNodes.length - 1]).equals(value);
        }
        return false;
    }

    private String getValueAsString(LazyObject jsonNode, String fieldName) {
        switch (jsonNode.getType(fieldName)) {
            case STRING: {
                return jsonNode.getString(fieldName);
            }
            case INTEGER: {
                return Integer.toString(jsonNode.getInt(fieldName));
            }
            case BOOLEAN: {
                return Boolean.toString(jsonNode.getBoolean(fieldName));
            }
            case FLOAT: {
                return Double.toString(jsonNode.getDouble(fieldName));
            }
        }
        return "null";
    }

    private String getValueAsString(LazyArray jsonNode, int i) {
        switch (jsonNode.getType(i)) {
            case STRING: {
                return jsonNode.getString(i);
            }
            case INTEGER: {
                return Integer.toString(jsonNode.getInt(i));
            }
            case BOOLEAN: {
                return Boolean.toString(jsonNode.getBoolean(i));
            }
            case FLOAT: {
                return Double.toString(jsonNode.getDouble(i));
            }
        }
        return "null";
    }

    private boolean pathIsIgnoreField(String currentPath) {
        if (this.ignoreFields != null && !this.ignoreFields.isEmpty()) {
            for (String ignoreField : this.ignoreFields) {
                if (!JsonEquals.pathEquals(currentPath, ignoreField)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean pathEquals(String path, String patternedPath) {
        String[] ignorePathArr;
        String[] pathArr = path.split("\\.");
        if (pathArr.length != (ignorePathArr = patternedPath.split("\\.")).length) {
            return false;
        }
        for (int i = 0; i < pathArr.length; ++i) {
            String nodePath = pathArr[i];
            String ignoreNodeArr = ignorePathArr[i];
            boolean nodeIsArray = nodePath.endsWith("]");
            boolean ignoreNodeIsArray = ignoreNodeArr.endsWith("]");
            if (nodeIsArray && ignoreNodeIsArray) {
                String ignoreIndex;
                String pathIndex = pathArr[i].substring(pathArr[i].lastIndexOf("[") + 1, pathArr[i].length() - 1);
                if (!pathIndex.equals(ignoreIndex = ignorePathArr[i].substring(ignorePathArr[i].lastIndexOf("[") + 1, ignorePathArr[i].length() - 1)) && !ignoreIndex.equals("*")) {
                    return false;
                }
                nodePath = nodePath.substring(0, nodePath.length() - pathIndex.length() - 2);
                ignoreNodeArr = ignoreNodeArr.substring(0, ignoreNodeArr.length() - ignoreIndex.length() - 2);
            }
            if (nodePath.equals(ignoreNodeArr)) continue;
            return false;
        }
        return true;
    }

    private void logInequality(String valueA, String valueB, String currentPath) {
        this.inequalityMessages.add(currentPath + " values were not the same! Expected " + valueA + " but got " + valueB);
    }

    private static String getChildPath(String currentPath, String childName) {
        return currentPath + "." + childName;
    }

    private static boolean childIsObject(LazyObject parent, String fieldName) {
        return parent.getType(fieldName) == LazyType.OBJECT;
    }

    private static boolean childIsObject(LazyArray parent, int index) {
        return parent.getType(index) == LazyType.OBJECT;
    }

    private static boolean childIsArray(LazyObject parent, String fieldName) {
        return parent.getType(fieldName) == LazyType.ARRAY;
    }

    private static boolean childIsArray(LazyArray parent, int index) {
        return parent.getType(index) == LazyType.ARRAY;
    }

    public static void setDebugMode(boolean debugMode) {
        JsonEquals.debugMode = debugMode;
    }
}

