/*
 * Decompiled with CFR 0.152.
 */
package com.github.kvnxiao.jsonequals;

import java.util.List;

public class JsonCompareResult {
    private final boolean isEqual;
    private final List<String> successMessages;
    private final List<String> inequalityMessages;

    private JsonCompareResult(boolean isEqual, List<String> successMessages, List<String> inequalityMessages) {
        this.isEqual = isEqual;
        this.successMessages = successMessages;
        this.inequalityMessages = inequalityMessages;
    }

    public static JsonCompareResult of(boolean isEqual, List<String> successMessages, List<String> inequalityMessages) {
        return new JsonCompareResult(isEqual, successMessages, inequalityMessages);
    }

    public List<String> getSuccessMessages() {
        return this.successMessages;
    }

    public List<String> getInequalityMessages() {
        return this.inequalityMessages;
    }

    public boolean isEqual() {
        return this.isEqual;
    }

    public int getSuccessCount() {
        return this.successMessages.size();
    }

    public int getInequalityCount() {
        return this.inequalityMessages.size();
    }

    public int getTotalMessageCount() {
        return this.successMessages.size() + this.inequalityMessages.size();
    }
}

