/*
 * Decompiled with CFR 0.152.
 */
package com.github.kubode.rx.android.schedulers;

import android.os.Looper;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action0;
import rx.schedulers.Schedulers;
import rx.subscriptions.CompositeSubscription;

public class ImmediateLooperScheduler
extends Scheduler {
    private final Looper looper;
    private final Scheduler looperScheduler;
    private final Scheduler immediateScheduler;

    public ImmediateLooperScheduler(Looper looper) {
        this.looper = looper;
        this.looperScheduler = AndroidSchedulers.from((Looper)looper);
        this.immediateScheduler = Schedulers.immediate();
    }

    public Scheduler.Worker createWorker() {
        return new ImmediatelyWorker(this.looper, this.looperScheduler.createWorker(), this.immediateScheduler.createWorker());
    }

    private static class ImmediatelyWorker
    extends Scheduler.Worker {
        private final Looper looper;
        private final Scheduler.Worker looperWorker;
        private final Scheduler.Worker immediateWorker;
        private final Subscription subscription;

        private ImmediatelyWorker(Looper looper, Scheduler.Worker looperWorker, Scheduler.Worker immediateWorker) {
            this.looper = looper;
            this.looperWorker = looperWorker;
            this.immediateWorker = immediateWorker;
            this.subscription = new CompositeSubscription(new Subscription[]{looperWorker, immediateWorker});
        }

        public void unsubscribe() {
            this.subscription.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.subscription.isUnsubscribed();
        }

        public Subscription schedule(Action0 action) {
            return this.getWorker().schedule(action);
        }

        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            return this.getWorker().schedule(action, delayTime, unit);
        }

        private Scheduler.Worker getWorker() {
            if (Looper.myLooper() == this.looper) {
                return this.immediateWorker;
            }
            return this.looperWorker;
        }
    }
}

