/*
 * Decompiled with CFR 0.152.
 */
package com.natasa.progressviews;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import com.natasa.progressviews.ProgressView;
import com.natasa.progressviews.utils.ProgressLineOrientation;
import com.natasa.progressviews.utils.ShapeType;

public class LineProgressBar
extends ProgressView {
    protected int lineOrientation = ProgressLineOrientation.HORIZONTAL.getValue();
    private boolean isGradientColor;

    public LineProgressBar(Context context) {
        super(context);
    }

    public LineProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public LineProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    void init() {
        this.initForegroundColor();
        this.initBackgroundColor();
    }

    public void onDraw(Canvas canvas) {
        if (this.getLineOrientation() == ProgressLineOrientation.HORIZONTAL.getValue()) {
            this.drawLineProgress(canvas);
            if (this.isGradientColor) {
                this.setGradientColorHorizontal(this.gradColors);
            }
        } else {
            this.drawLineProgressVertical(canvas);
            if (this.isGradientColor) {
                this.setGradientColorVertical(this.gradColors);
            }
        }
        this.drawText(canvas);
    }

    private void drawLineProgressVertical(Canvas canvas) {
        int nMiddle = this.width / 2;
        float progressY = (float)this.height / this.maximum_progress * this.maximum_progress;
        canvas.drawLine((float)nMiddle, (float)this.height - progressY, (float)nMiddle, (float)this.height, this.backgroundPaint);
        float progressX = (float)this.height / this.maximum_progress * this.progress;
        canvas.drawLine((float)nMiddle, (float)this.height, (float)nMiddle, (float)this.height - progressX, this.foregroundPaint);
    }

    private void drawLineProgress(Canvas canvas) {
        int nMiddle = this.height / 2;
        canvas.drawLine(0.0f, (float)nMiddle, (float)this.width, (float)nMiddle, this.backgroundPaint);
        int progressX = (int)((float)this.width * this.progress / this.maximum_progress);
        canvas.drawLine(0.0f, (float)nMiddle, (float)progressX, (float)nMiddle, this.foregroundPaint);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.height = LineProgressBar.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        this.width = LineProgressBar.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        this.setMeasuredDimension(this.width, this.height);
    }

    public int getLineOrientation() {
        return this.lineOrientation;
    }

    public void setLineOrientation(ProgressLineOrientation position) {
        this.lineOrientation = position.getValue();
    }

    @Override
    public ShapeType setType(ShapeType type) {
        return ShapeType.LINE;
    }

    public void setLinearGradientProgress(boolean isGradientColor) {
        this.isGradientColor = isGradientColor;
    }

    public void setLinearGradientProgress(boolean isGradientColor, int[] colors) {
        this.isGradientColor = isGradientColor;
        this.gradColors = colors;
    }

    private void setGradientColorVertical(int[] gradColors) {
        if (gradColors != null) {
            this.colorHelper.setGradientPaint(this.foregroundPaint, 0.0f, this.height, 0.0f, 0.0f, gradColors);
        } else {
            this.colorHelper.setGradientPaint(this.foregroundPaint, 0.0f, this.height, 0.0f, 0.0f);
        }
    }

    private void setGradientColorHorizontal(int[] gradColors) {
        if (gradColors != null) {
            this.colorHelper.setGradientPaint(this.foregroundPaint, 0.0f, 0.0f, this.width, 0.0f, gradColors);
        } else {
            this.colorHelper.setGradientPaint(this.foregroundPaint, 0.0f, 0.0f, this.width, 0.0f);
        }
    }
}

