/*
 * Decompiled with CFR 0.152.
 */
package com.natasa.progressviews;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.SweepGradient;

class ColorsHelper {
    static int[] colors2 = new int[]{Color.parseColor((String)"#fb0000"), Color.parseColor((String)"#fbf400"), Color.parseColor((String)"#00FF00")};
    private boolean isAllowedMatchParent;
    static int[] colors1;

    protected ColorsHelper() {
    }

    public int[] getColors2() {
        return colors2;
    }

    public static void setColors2(int[] colors) {
        colors1 = colors;
    }

    public void setGradientPaint(Paint paint, float left, float top, float right, float bottom) {
        this.setGradientPaint(paint, left, top, right, bottom, colors2);
    }

    public void setGradientPaint(Paint paint, float left, float top, float right, float bottom, int[] colors2) {
        LinearGradient linearGradient = new LinearGradient(left, top, right, bottom, colors2, null, Shader.TileMode.CLAMP);
        paint.setShader((Shader)linearGradient);
        paint.setAntiAlias(true);
    }

    public void setSweepGradientPaint(Paint paint, float width, float height, int colorStart, int colorEnd) {
        ColorsHelper.setSweepGradientGradientPaint(paint, width, height, colorStart, colorEnd);
    }

    protected static void setSweepGradientGradientPaint(Paint paint, float width, float height, int colorStart, int colorEnd) {
        paint.setShader((Shader)new SweepGradient(width, height, colorStart, colorEnd));
        paint.setAntiAlias(true);
    }

    public void drawTextCenter(Canvas canvas, String text, int color2, int size, int min) {
        Paint innerPaint = new Paint();
        innerPaint.setAntiAlias(true);
        innerPaint.setStyle(Paint.Style.FILL);
        innerPaint.setColor(color2);
        innerPaint.setTextSize((float)size);
        Rect r = new Rect();
        innerPaint.setTextAlign(Paint.Align.LEFT);
        innerPaint.getTextBounds(text, 0, text.length(), r);
        float x = (float)min / 2.0f - (float)r.width() / 2.0f - (float)r.left;
        float y = (float)min / 2.0f + (float)r.height() / 2.0f - (float)r.bottom;
        canvas.drawText(text, x, y, innerPaint);
    }

    private void setTextMatchParent(String text, Paint paint, float desiredWidth) {
        this.calculateTextlength(text);
        if (this.isAllowedMatchParent) {
            ColorsHelper.setTextSizeForWidth(text, paint, desiredWidth);
        }
    }

    private void calculateTextlength(String text) {
        int textLength = text.length();
        if (textLength > 4) {
            this.isAllowedMatchParent = true;
        } else {
            float f = 38.0f;
        }
    }

    private static void setTextSizeForWidth(String text, Paint paint, float desiredWidth) {
        float testTextSize = 48.0f;
        paint.setTextSize(48.0f);
        Rect bounds = new Rect();
        paint.getTextBounds(text, 0, text.length(), bounds);
        float desiredTextSize = 48.0f * desiredWidth / (float)bounds.width();
        paint.setTextSize(desiredTextSize);
    }

    @Deprecated
    private void drawText(String text, Canvas canvas) {
        Paint innerPaint = new Paint();
        innerPaint.setAntiAlias(true);
        innerPaint.setStyle(Paint.Style.FILL);
        innerPaint.setColor(-16777216);
        int xPos = canvas.getWidth() / 2;
        int yPos = (int)((float)(canvas.getHeight() / 2) - (innerPaint.descent() + innerPaint.ascent()) / 2.0f);
        canvas.drawText(text, (float)xPos, (float)yPos, innerPaint);
    }
}

