/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import androidx.annotation.Nullable;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.ProgressViewInterface;
import com.kongzue.dialogx.util.DialogXValueAnimator;

public class ProgressView
extends View
implements ProgressViewInterface {
    public static long TIP_ANIMATOR_DURATION = 300L;
    public static long PROGRESSING_ANIMATOR_DURATION = 1000L;
    public static final int STATUS_LOADING = 0;
    public static final int STATUS_SUCCESS = 1;
    public static final int STATUS_WARNING = 2;
    public static final int STATUS_ERROR = 3;
    public static final int STATUS_PROGRESSING = 4;
    private int status = 0;
    private int width = this.dip2px(2.0f);
    private int color = -1;
    private DialogXValueAnimator rotateAnimator;
    private DialogXValueAnimator followAnimator;
    private float currentRotateDegrees;
    private float followRotateDegrees;
    private float halfSweepAMaxValue = 180.0f;
    private float halfSweepAMinValue = 80.0f;
    private float halfSweepA;
    Paint mPaint = new Paint();
    private boolean isInited = false;
    private float mCenterX;
    private float mCenterY;
    private float mRadius = 100.0f;
    private RectF oval;
    private int successStep = 0;
    private float nowLoadingProgressValue;
    private float nowLoadingProgressEndAngle;
    private float changeStatusAngle;
    private int line1X = 0;
    private int line1Y = 0;
    private int line2X = 0;
    private int line2Y = 0;
    private ValueAnimator tickAnimator;
    private float tickAnimatorValue;
    private Interpolator interpolator;
    Runnable waitArticulationAnimationRunnable;
    private Runnable tickShowRunnable;
    private boolean noShowLoading;

    public ProgressView(Context context) {
        super(context);
        this.init(null);
    }

    public ProgressView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public ProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs) {
        Class<ProgressView> clazz = ProgressView.class;
        synchronized (ProgressView.class) {
            if (this.isInited) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.isInited = true;
            if (attrs != null) {
                TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ProgressView);
                this.width = a.getDimensionPixelSize(R.styleable.ProgressView_progressStrokeWidth, this.dip2px(2.0f));
                this.color = a.getDimensionPixelSize(R.styleable.ProgressView_progressStrokeColor, this.color);
                a.recycle();
            }
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth((float)this.width);
            this.mPaint.setStrokeCap(Paint.Cap.ROUND);
            this.mPaint.setColor(this.color);
            if (!this.isInEditMode()) {
                int refreshInterval = (int)this.calculateMillisPerFrame(this.getContext());
                this.halfSweepA = (this.halfSweepAMaxValue - this.halfSweepAMinValue) / 2.0f;
                this.rotateAnimator = DialogXValueAnimator.ofFloat(0.0f, 365.0f);
                this.rotateAnimator.setDuration(1000L);
                this.rotateAnimator.setInterpolator((Interpolator)new LinearInterpolator());
                this.rotateAnimator.setRepeatCount(-1);
                this.rotateAnimator.setRefreshInterval(refreshInterval);
                this.rotateAnimator.addUpdateListener(new DialogXValueAnimator.ValueUpdateListener(){

                    @Override
                    public void onValueUpdate(float animatedValue) {
                        if (!ProgressView.this.isAttachedToWindow()) {
                            return;
                        }
                        ProgressView.this.currentRotateDegrees = animatedValue;
                        ProgressView.this.invalidate();
                    }
                });
                this.followAnimator = DialogXValueAnimator.ofFloat(0.0f, 365.0f);
                this.followAnimator.setDuration(1500L);
                this.followAnimator.setRefreshInterval(refreshInterval);
                this.followAnimator.setInterpolator((Interpolator)new LinearInterpolator());
                this.followAnimator.setRepeatCount(-1);
                this.followAnimator.addUpdateListener(new DialogXValueAnimator.ValueUpdateListener(){

                    @Override
                    public void onValueUpdate(float animatedValue) {
                        ProgressView.this.followRotateDegrees = animatedValue;
                    }
                });
                this.followAnimator.start();
                this.rotateAnimator.start();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mCenterX = (float)w * 1.0f / 2.0f;
        this.mCenterY = (float)h * 1.0f / 2.0f;
        this.mRadius = Math.min(this.getWidth(), this.getHeight()) / 2 - this.width / 2;
        this.oval = new RectF(this.mCenterX - this.mRadius, this.mCenterY - this.mRadius, this.mCenterX + this.mRadius, this.mCenterY + this.mRadius);
    }

    protected void onDraw(Canvas canvas) {
        block18: {
            if (this.isInEditMode()) {
                canvas.drawArc(this.oval, 0.0f, 365.0f, false, this.mPaint);
                return;
            }
            if (this.noShowLoading) {
                canvas.drawArc(this.oval, 0.0f, 365.0f, false, this.mPaint);
                this.successStep = 2;
                this.drawDoneMark(this.status, canvas);
                return;
            }
            block0 : switch (this.status) {
                case 0: {
                    float sweepAngle = (float)((double)this.halfSweepA * Math.sin(Math.toRadians(this.followRotateDegrees))) + this.halfSweepA + this.halfSweepAMinValue / 2.0f;
                    this.nowLoadingProgressValue = this.currentRotateDegrees - sweepAngle;
                    if (this.nowLoadingProgressValue < 0.0f) {
                        this.nowLoadingProgressValue = 360.0f + this.nowLoadingProgressValue;
                    }
                    this.nowLoadingProgressEndAngle = sweepAngle;
                    this.changeStatusAngle = sweepAngle < 0.0f ? 360.0f - sweepAngle : sweepAngle;
                    canvas.drawArc(this.oval, this.currentRotateDegrees, -sweepAngle, false, this.mPaint);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    switch (this.successStep) {
                        case 0: {
                            this.nowLoadingProgressEndAngle += 5.0f;
                            canvas.drawArc(this.oval, this.nowLoadingProgressValue, this.nowLoadingProgressEndAngle, false, this.mPaint);
                            if (!(this.nowLoadingProgressEndAngle - (360.0f - this.changeStatusAngle) >= this.nowLoadingProgressValue)) break;
                            this.successStep = 1;
                            if (this.waitArticulationAnimationRunnable == null) break;
                            this.waitArticulationAnimationRunnable.run();
                            this.waitArticulationAnimationRunnable = null;
                            break;
                        }
                        case 1: {
                            canvas.drawArc(this.oval, 0.0f, 360.0f, false, this.mPaint);
                            this.drawDoneMark(this.status, canvas);
                        }
                    }
                    break;
                }
                case 4: {
                    switch (this.successStep) {
                        case 0: {
                            canvas.drawArc(this.oval, -90.0f, this.currentRotateDegrees, false, this.mPaint);
                            if (this.currentRotateDegrees == 365.0f) {
                                this.successStep = 1;
                                if (this.waitArticulationAnimationRunnable != null) {
                                    this.waitArticulationAnimationRunnable.run();
                                    this.waitArticulationAnimationRunnable = null;
                                    break block0;
                                }
                            }
                            break block18;
                        }
                        case 1: {
                            canvas.drawArc(this.oval, 0.0f, 360.0f, false, this.mPaint);
                            this.drawDoneMark(this.status, canvas);
                        }
                    }
                }
            }
        }
    }

    private void drawDoneMark(int status, Canvas canvas) {
        if (this.rotateAnimator.getInterpolator() != this.interpolator) {
            this.rotateAnimator.setInterpolator(this.interpolator);
        }
        if (this.tickShowRunnable != null) {
            this.tickShowRunnable.run();
            this.tickShowRunnable = null;
            if (DialogX.useHaptic) {
                switch (status) {
                    case 1: {
                        this.performHapticFeedback(3);
                        break;
                    }
                    case 2: {
                        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                ProgressView.this.performHapticFeedback(0);
                            }
                        }, (long)((float)TIP_ANIMATOR_DURATION * 0.8f));
                        break;
                    }
                    case 3: {
                        this.performHapticFeedback(3);
                        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                ProgressView.this.performHapticFeedback(3);
                            }
                        }, (long)((float)TIP_ANIMATOR_DURATION * 0.5f));
                    }
                }
            }
        }
        switch (status) {
            case 1: {
                this.showSuccessTick(canvas);
                break;
            }
            case 2: {
                this.showWarningTick(canvas);
                break;
            }
            case 3: {
                this.showErrorTick(canvas);
            }
        }
    }

    private void showSuccessTick(Canvas canvas) {
        int verticalAxisOffset = (int)(this.mRadius / 20.0f);
        int tickTurnLeftPoint = (int)(this.mCenterX - this.mRadius / 10.0f - (float)verticalAxisOffset);
        int startX = (int)(this.mCenterX - this.mRadius / 2.0f);
        int startY = (int)(this.mCenterY + (float)verticalAxisOffset);
        int endX = (int)(this.mCenterX + this.mRadius / 2.0f);
        int tickAnimatorX = (int)((float)startX + (float)(endX - startX) * this.tickAnimatorValue);
        Path path = new Path();
        path.moveTo((float)startX, (float)startY);
        if (tickAnimatorX < tickTurnLeftPoint) {
            this.line1X = tickAnimatorX;
            this.line1Y = startY + (tickAnimatorX - startX);
            path.lineTo((float)this.line1X, (float)this.line1Y);
        } else {
            this.line1X = tickTurnLeftPoint;
            this.line1Y = startY + (this.line1X - startX);
            path.lineTo((float)this.line1X, (float)this.line1Y);
            this.line2X = tickAnimatorX;
            this.line2Y = this.line1Y - (tickAnimatorX - this.line1X);
            path.lineTo((float)this.line2X, (float)this.line2Y);
        }
        canvas.drawPath(path, this.mPaint);
    }

    private void showWarningTick(Canvas canvas) {
        int x = (int)this.mCenterX;
        int startY = (int)(this.mCenterY - this.mRadius * 1.0f / 2.0f);
        int endY = (int)(this.mCenterY + this.mRadius * 1.0f / 8.0f);
        int line2Y = (int)(this.mCenterY + this.mRadius * 3.0f / 7.0f);
        if (this.tickAnimatorValue < 0.9f) {
            canvas.drawLine((float)x, (float)startY, (float)x, (float)startY + (float)(endY - startY) * this.tickAnimatorValue, this.mPaint);
        } else {
            canvas.drawLine((float)x, (float)startY, (float)x, (float)endY, this.mPaint);
            canvas.drawLine((float)x, (float)line2Y, (float)x, (float)(line2Y + 1), this.mPaint);
        }
    }

    private void showErrorTick(Canvas canvas) {
        int start = (int)(this.mCenterY - this.mRadius * 4.0f / 10.0f);
        int end = (int)(this.mCenterX + this.mRadius * 4.0f / 10.0f);
        if (this.tickAnimatorValue < 0.5f) {
            this.line1X = (int)((float)start + this.tickAnimatorValue * 2.0f * (float)(end - start));
            this.line1Y = (int)((float)start + this.tickAnimatorValue * 2.0f * (float)(end - start));
            canvas.drawLine((float)start, (float)start, (float)this.line1X, (float)this.line1Y, this.mPaint);
        } else {
            this.line1X = (int)((float)start + this.tickAnimatorValue * 2.0f * (float)(end - start));
            this.line1Y = (int)((float)start + this.tickAnimatorValue * 2.0f * (float)(end - start));
            canvas.drawLine((float)start, (float)start, (float)end, (float)end, this.mPaint);
            this.line2X = (int)((float)end - (this.tickAnimatorValue - 0.5f) * 2.0f * (float)(end - start));
            this.line2Y = (int)((float)start + (this.tickAnimatorValue - 0.5f) * 2.0f * (float)(end - start));
            canvas.drawLine((float)end, (float)start, (float)this.line2X, (float)this.line2Y, this.mPaint);
        }
    }

    public void success() {
        if (this.status == 4) {
            this.progress(1.0f);
            this.waitArticulationAnimationRunnable = new Runnable(){

                @Override
                public void run() {
                    ProgressView.this.initTipAnimator(1, (Interpolator)new AccelerateDecelerateInterpolator());
                }
            };
            return;
        }
        this.initTipAnimator(1, (Interpolator)new AccelerateDecelerateInterpolator());
    }

    public void warning() {
        if (this.status == 4) {
            this.progress(1.0f);
            this.waitArticulationAnimationRunnable = new Runnable(){

                @Override
                public void run() {
                    ProgressView.this.initTipAnimator(2, (Interpolator)new AccelerateInterpolator(2.0f));
                }
            };
            return;
        }
        this.initTipAnimator(2, (Interpolator)new AccelerateInterpolator(2.0f));
    }

    public void error() {
        if (this.status == 4) {
            this.progress(1.0f);
            this.waitArticulationAnimationRunnable = new Runnable(){

                @Override
                public void run() {
                    ProgressView.this.initTipAnimator(3, (Interpolator)new DecelerateInterpolator(2.0f));
                }
            };
            return;
        }
        this.initTipAnimator(3, (Interpolator)new DecelerateInterpolator(2.0f));
    }

    private void initTipAnimator(int s, Interpolator i) {
        this.interpolator = i;
        this.status = s;
        if (this.successStep == 0) {
            this.waitArticulationAnimationRunnable = new Runnable(){

                @Override
                public void run() {
                    ProgressView.this.initTipAnimator(ProgressView.this.status, ProgressView.this.interpolator);
                }
            };
            return;
        }
        if (this.tickAnimator != null) {
            this.tickAnimator.cancel();
            this.tickAnimator = null;
        }
        this.tickAnimatorValue = 0.0f;
        this.tickAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.tickAnimator.setDuration(TIP_ANIMATOR_DURATION);
        this.tickAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ProgressView.this.tickAnimatorValue = ((Float)animation.getAnimatedValue()).floatValue();
                ProgressView.this.invalidate();
            }
        });
        this.tickAnimator.start();
    }

    public void progress(float progress) {
        if (this.rotateAnimator != null) {
            this.rotateAnimator.cancel();
        }
        if (this.followAnimator != null) {
            this.followAnimator.cancel();
        }
        if (this.status != 4) {
            this.currentRotateDegrees = 0.0f;
        }
        this.noShowLoading = false;
        this.status = 4;
        this.rotateAnimator = DialogXValueAnimator.ofFloat(this.currentRotateDegrees, 365.0f * progress);
        this.rotateAnimator.setDuration(PROGRESSING_ANIMATOR_DURATION);
        this.rotateAnimator.setInterpolator((Interpolator)new DecelerateInterpolator(2.0f));
        this.rotateAnimator.setRepeatCount(0);
        this.rotateAnimator.addUpdateListener(new DialogXValueAnimator.ValueUpdateListener(){

            @Override
            public void onValueUpdate(float animatedValue) {
                ProgressView.this.currentRotateDegrees = animatedValue;
                ProgressView.this.invalidate();
            }
        });
        this.rotateAnimator.start();
    }

    public ProgressView whenShowTick(Runnable runnable) {
        this.tickShowRunnable = runnable;
        return this;
    }

    public void loading() {
        this.noShowLoading = false;
        this.successStep = 0;
        this.line1X = 0;
        this.line1Y = 0;
        this.line2X = 0;
        this.line2Y = 0;
        this.status = 0;
        if (this.rotateAnimator != null) {
            this.rotateAnimator.cancel();
        }
        if (this.followAnimator != null) {
            this.followAnimator.cancel();
        }
        this.isInited = false;
        this.init(null);
    }

    public int getStatus() {
        return this.status;
    }

    protected void onDetachedFromWindow() {
        if (this.rotateAnimator != null) {
            this.rotateAnimator.cancel();
        }
        if (this.followAnimator != null) {
            this.followAnimator.cancel();
        }
        super.onDetachedFromWindow();
    }

    public int getStrokeWidth() {
        return this.width;
    }

    public ProgressView setStrokeWidth(int width) {
        this.width = width;
        if (this.mPaint != null) {
            this.mPaint.setStrokeWidth((float)width);
        }
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public ProgressView setColor(int color2) {
        this.color = color2;
        if (this.mPaint != null) {
            this.mPaint.setColor(color2);
        }
        return this;
    }

    public void noLoading() {
        this.noShowLoading = true;
    }

    private int dip2px(float dpValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    private float getRefreshRate(Context context) {
        float refreshRate = 60.0f;
        if (Build.VERSION.SDK_INT >= 30) {
            Display display = ((WindowManager)context.getSystemService(WindowManager.class)).getDefaultDisplay();
            Display.Mode mode = display.getMode();
            refreshRate = mode.getRefreshRate();
        } else if (Build.VERSION.SDK_INT >= 23) {
            Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            refreshRate = display.getRefreshRate();
        }
        return refreshRate;
    }

    private long calculateMillisPerFrame(Context context) {
        float refreshRate = this.getRefreshRate(context);
        if (refreshRate > 0.0f) {
            return (long)(1000.0 / (double)refreshRate);
        }
        return 16L;
    }
}

