/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.DialogXSafetyModeInterface;

public class MaxRelativeLayout
extends RelativeLayout
implements DialogXSafetyModeInterface {
    private int maxWidth;
    private int maxHeight;
    private int minWidth;
    private int minHeight;
    private boolean lockWidth;
    private boolean interceptTouch = true;
    private View contentView;
    private int dialogXSafetyMode;
    private float startAnimValue = 0.0f;
    private float endAnimValue = 0.0f;
    private int preWidth = -1;
    private OnYChanged onYChangedListener;
    int navBarHeight;
    Paint navBarPaint;
    private View.OnTouchListener onTouchListener;
    boolean reInterceptTouch;

    public MaxRelativeLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public MaxRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MaxRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DialogXMaxLayout);
            this.maxWidth = a.getDimensionPixelSize(R.styleable.DialogXMaxLayout_maxLayoutWidth, 0);
            this.maxHeight = a.getDimensionPixelSize(R.styleable.DialogXMaxLayout_maxLayoutHeight, 0);
            this.minWidth = a.getDimensionPixelSize(R.styleable.DialogXMaxLayout_minLayoutWidth, 0);
            this.minHeight = a.getDimensionPixelSize(R.styleable.DialogXMaxLayout_minLayoutHeight, 0);
            this.lockWidth = a.getBoolean(R.styleable.DialogXMaxLayout_lockWidth, false);
            this.interceptTouch = a.getBoolean(R.styleable.DialogXMaxLayout_interceptTouch, true);
            this.dialogXSafetyMode = a.getInt(R.styleable.DialogXMaxLayout_dialogXSafetyMode, 0);
            a.recycle();
        }
        this.minWidth = this.minWidth == 0 ? this.getMinimumWidth() : this.minWidth;
        int n = this.minHeight = this.minHeight == 0 ? this.getMinimumHeight() : this.minHeight;
        if (!this.isInEditMode() && Build.VERSION.SDK_INT >= 19) {
            this.animate().setUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float progress = ((Float)animation.getAnimatedValue()).floatValue();
                    long value = (long)(MaxRelativeLayout.this.startAnimValue + (MaxRelativeLayout.this.endAnimValue - MaxRelativeLayout.this.startAnimValue) * progress);
                    if (MaxRelativeLayout.this.onYChangedListener != null) {
                        MaxRelativeLayout.this.onYChangedListener.y(value);
                    }
                }
            });
        }
    }

    public MaxRelativeLayout setMaxHeight(int maxHeight) {
        if (maxHeight > 0) {
            this.maxHeight = maxHeight;
        }
        return this;
    }

    public MaxRelativeLayout setMaxWidth(int maxWidth) {
        if (maxWidth > 0) {
            this.maxWidth = maxWidth;
        }
        return this;
    }

    public void setMinHeight(int minHeight) {
        if (minHeight > 0) {
            this.minHeight = minHeight;
        }
    }

    public void setMinWidth(int minWidth) {
        if (minWidth > 0) {
            this.minWidth = minWidth;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.preWidth == -1 && widthSize != 0) {
            this.preWidth = widthSize;
        }
        if (this.lockWidth) {
            this.maxWidth = Math.min(this.maxWidth, Math.min(widthSize, this.preWidth));
        }
        if (heightSize > this.maxHeight && this.maxHeight != 0) {
            heightSize = this.maxHeight + this.getPaddingBottom() + this.getPaddingTop();
        }
        if (widthSize > this.maxWidth && this.maxWidth != 0) {
            widthSize = this.maxWidth + this.getPaddingLeft() + this.getPaddingRight();
        }
        int maxHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
        int maxWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)widthMode);
        super.onMeasure(maxWidthMeasureSpec, maxHeightMeasureSpec);
    }

    public int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public boolean isLockWidth() {
        return this.lockWidth;
    }

    public MaxRelativeLayout setLockWidth(boolean lockWidth) {
        this.lockWidth = lockWidth;
        return this;
    }

    public void setNavBarHeight(int height) {
        this.navBarHeight = height;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.navBarHeight != 0 && DialogX.bottomDialogNavbarColor != 0) {
            if (this.navBarPaint == null) {
                this.navBarPaint = new Paint();
                this.navBarPaint.setColor(DialogX.bottomDialogNavbarColor);
            }
            canvas.drawRect(0.0f, (float)(this.getHeight() - this.navBarHeight), (float)this.getWidth(), (float)this.getHeight(), this.navBarPaint);
        }
    }

    public void setContentView(View contentView) {
        this.contentView = contentView;
    }

    public void setY(float y) {
        super.setY(y);
    }

    public OnYChanged getOnYChanged() {
        return this.onYChangedListener;
    }

    public MaxRelativeLayout setOnYChanged(OnYChanged onYChanged) {
        this.onYChangedListener = onYChanged;
        return this;
    }

    public void setTranslationY(float translationY) {
        super.setTranslationY(translationY);
        if (this.onYChangedListener != null) {
            this.onYChangedListener.y(translationY);
        }
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.onTouchListener = l;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.onTouchListener != null) {
            this.reInterceptTouch = this.onTouchListener.onTouch((View)this, ev);
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.reInterceptTouch;
    }

    @Override
    public int getDialogXSafetyMode() {
        return this.dialogXSafetyMode;
    }

    public MaxRelativeLayout setDialogXSafetyMode(int dialogXSafetyMode) {
        this.dialogXSafetyMode = dialogXSafetyMode;
        return this;
    }

    public static interface OnYChanged {
        public void y(float var1);
    }
}

