/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.kongzue.dialogx.R;

public class MaxLinearLayout
extends LinearLayout {
    private int maxWidth;
    private int maxHeight;
    private int minWidth;
    private int minHeight;
    private int preWidth = -1;

    public MaxLinearLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public MaxLinearLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MaxLinearLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DialogXMaxLayout);
            this.maxWidth = a.getDimensionPixelSize(R.styleable.DialogXMaxLayout_maxLayoutWidth, 0);
            this.maxHeight = a.getDimensionPixelSize(R.styleable.DialogXMaxLayout_maxLayoutHeight, 0);
            this.minWidth = a.getDimensionPixelSize(R.styleable.DialogXMaxLayout_minLayoutWidth, 0);
            this.minHeight = a.getDimensionPixelSize(R.styleable.DialogXMaxLayout_minLayoutHeight, 0);
            a.recycle();
        }
        this.minWidth = this.minWidth == 0 ? this.getMinimumWidth() : this.minWidth;
        this.minHeight = this.minHeight == 0 ? this.getMinimumHeight() : this.minHeight;
    }

    public MaxLinearLayout setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public MaxLinearLayout setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.preWidth == -1 && widthSize != 0) {
            this.preWidth = widthSize;
        }
        if (heightSize > this.maxHeight && this.maxHeight != 0) {
            heightSize = this.maxHeight;
        }
        if (widthSize > this.maxWidth && this.maxWidth != 0) {
            widthSize = this.maxWidth;
        }
        int maxHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
        int maxWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)widthMode);
        super.onMeasure(maxWidthMeasureSpec, maxHeightMeasureSpec);
    }

    public int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public void setMinimumHeight(int minHeight) {
        this.minHeight = minHeight;
        super.setMinimumHeight(minHeight);
    }

    public void setMinimumWidth(int minWidth) {
        this.minWidth = minWidth;
        super.setMinimumWidth(minWidth);
    }
}

