/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import androidx.annotation.NonNull;
import androidx.core.graphics.Insets;
import androidx.core.view.DisplayCutoutCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsAnimationCompat;
import androidx.core.view.WindowInsetsCompat;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.util.views.DialogXBaseRelativeLayout;
import java.util.List;

public class FitSystemBarUtils {
    private boolean inSmoothingPadding = false;
    public boolean safeCutOutPadding = true;
    public boolean smoothPadding = true;
    private View contentView;
    private CallBack callBack;
    View.OnLayoutChangeListener rootViewLayoutChangeListener;
    RelativePadding relativePaddingCache;
    private int specialModeImeHeight;
    private boolean specialMode;
    private ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;

    public boolean isInSmoothingPadding() {
        return this.inSmoothingPadding;
    }

    public static FitSystemBarUtils attachView(View view) {
        return FitSystemBarUtils.attachView(view, new CallBack(){

            @Override
            public boolean isEnable(Orientation orientation) {
                return true;
            }

            @Override
            public void unsafeRect(int start, int top, int end, int bottom) {
            }

            @Override
            public int initialPadding(Orientation orientation) {
                return 0;
            }
        });
    }

    public static FitSystemBarUtils attachView(View view, CallBack callBack) {
        return new FitSystemBarUtils(view, callBack);
    }

    public static FitSystemBarUtils attachView(View view, final boolean start, final boolean top, final boolean end, final boolean bottom) {
        return FitSystemBarUtils.attachView(view, new CallBack(){

            @Override
            public boolean isEnable(Orientation orientation) {
                switch (orientation) {
                    case Start: {
                        return start;
                    }
                    case Top: {
                        return top;
                    }
                    case End: {
                        return end;
                    }
                    case Bottom: {
                        return bottom;
                    }
                }
                return false;
            }

            @Override
            public void unsafeRect(int start2, int top2, int end2, int bottom2) {
            }

            @Override
            public int initialPadding(Orientation orientation) {
                return 0;
            }
        });
    }

    private FitSystemBarUtils() {
    }

    public FitSystemBarUtils(View view, CallBack callBack) {
        this.contentView = view;
        this.callBack = callBack;
        this.applyWindowInsets();
    }

    public void applyWindowInsets() {
        final RelativePadding initialPadding = new RelativePadding(ViewCompat.getPaddingStart((View)this.contentView), this.contentView.getPaddingTop(), ViewCompat.getPaddingEnd((View)this.contentView), this.contentView.getPaddingBottom());
        ViewCompat.setOnApplyWindowInsetsListener((View)this.contentView, (view, insets) -> {
            if (this.inSmoothingPadding) {
                return insets;
            }
            this.formatInsets(insets, new RelativePadding(initialPadding));
            return insets;
        });
        if (Build.VERSION.SDK_INT >= 30) {
            this.log("FitSystemBarUtils: setWindowInsetsAnimationCallback");
            ViewCompat.setWindowInsetsAnimationCallback((View)this.contentView, (WindowInsetsAnimationCompat.Callback)new WindowInsetsAnimationCompat.Callback(1){

                @NonNull
                public WindowInsetsCompat onProgress(@NonNull WindowInsetsCompat insets, @NonNull List<WindowInsetsAnimationCompat> runningAnimations) {
                    FitSystemBarUtils.this.log("FitSystemBarUtils: setWindowInsetsAnimationCallback#onProgress: " + insets);
                    if (FitSystemBarUtils.this.smoothPadding) {
                        FitSystemBarUtils.this.formatInsets(insets, new RelativePadding(initialPadding));
                    }
                    return insets;
                }

                public void onEnd(@NonNull WindowInsetsAnimationCompat animation) {
                    FitSystemBarUtils.this.log("FitSystemBarUtils: setWindowInsetsAnimationCallback#onEnd ");
                    FitSystemBarUtils.this.inSmoothingPadding = false;
                    super.onEnd(animation);
                }

                public void onPrepare(@NonNull WindowInsetsAnimationCompat animation) {
                    FitSystemBarUtils.this.inSmoothingPadding = FitSystemBarUtils.this.smoothPadding;
                    super.onPrepare(animation);
                }
            });
        }
        if (ViewCompat.isAttachedToWindow((View)this.contentView)) {
            this.log("FitSystemBarUtils: AttachedToWindow ok");
            ViewCompat.requestApplyInsets((View)this.contentView);
        } else {
            this.log("FitSystemBarUtils: wait AttachedToWindow");
            this.contentView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View view) {
                    view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    FitSystemBarUtils.this.log("FitSystemBarUtils: onViewAttachedToWindow");
                    if (Build.VERSION.SDK_INT >= 20 && (Build.VERSION.SDK_INT < 30 || FitSystemBarUtils.this.getAppTargetSDKVersion() < 30)) {
                        if (Build.VERSION.SDK_INT >= 23) {
                            final View parentView = (View)view.getParent();
                            if (FitSystemBarUtils.this.rootViewLayoutChangeListener != null) {
                                parentView.removeOnLayoutChangeListener(FitSystemBarUtils.this.rootViewLayoutChangeListener);
                            }
                            FitSystemBarUtils.this.rootViewLayoutChangeListener = new View.OnLayoutChangeListener(){

                                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                                    WindowInsets windowInsets = v.getRootView().getRootWindowInsets();
                                    if (windowInsets != null) {
                                        FitSystemBarUtils.this.log("    FitSystemBarUtils: RootView get Insets");
                                        FitSystemBarUtils.this.formatInsets(WindowInsetsCompat.toWindowInsetsCompat((WindowInsets)windowInsets), new RelativePadding(initialPadding));
                                    } else {
                                        FitSystemBarUtils.this.log("    FitSystemBarUtils: RootView not get Insets");
                                    }
                                }
                            };
                            parentView.addOnLayoutChangeListener(FitSystemBarUtils.this.rootViewLayoutChangeListener);
                            parentView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                                public void onViewAttachedToWindow(View v) {
                                }

                                public void onViewDetachedFromWindow(View v) {
                                    parentView.removeOnLayoutChangeListener(FitSystemBarUtils.this.rootViewLayoutChangeListener);
                                }
                            });
                        } else {
                            final View parentView = (View)view.getParent();
                            ViewTreeObserver.OnPreDrawListener preDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                                public boolean onPreDraw() {
                                    Rect insets = new Rect();
                                    parentView.getWindowVisibleDisplayFrame(insets);
                                    int statusBarHeight = insets.top;
                                    int navigationBarHeight = 0;
                                    Resources resources = parentView.getResources();
                                    int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
                                    if (resourceId > 0) {
                                        navigationBarHeight = resources.getDimensionPixelSize(resourceId);
                                    }
                                    FitSystemBarUtils.this.log("FitSystemBarUtils: below Android M use support mode: statusBarHeight=" + statusBarHeight + ", navigationBarHeight=" + navigationBarHeight);
                                    int deviceOrientation = FitSystemBarUtils.this.checkOrientationAndStatusBarSide();
                                    FitSystemBarUtils.this.log("    FitSystemBarUtils: deviceOrientation = " + deviceOrientation);
                                    switch (deviceOrientation) {
                                        case -1: 
                                        case 1: {
                                            initialPadding.end = navigationBarHeight;
                                            initialPadding.start = 0;
                                            break;
                                        }
                                        default: {
                                            initialPadding.top = statusBarHeight;
                                            initialPadding.bottom = navigationBarHeight;
                                        }
                                    }
                                    FitSystemBarUtils.this.applyCallBack(initialPadding);
                                    parentView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                                    return true;
                                }
                            };
                            parentView.getViewTreeObserver().addOnPreDrawListener(preDrawListener);
                        }
                    }
                    ViewCompat.requestApplyInsets((View)view);
                }

                public void onViewDetachedFromWindow(View view) {
                }
            });
        }
    }

    private void formatInsets(WindowInsetsCompat insetsCompat, RelativePadding initialPadding) {
        DisplayCutoutCompat displayCutout;
        this.relativePaddingCache = initialPadding;
        int cutoutPaddingLeft = 0;
        int cutoutPaddingTop = 0;
        int cutoutPaddingRight = 0;
        int cutoutPaddingBottom = 0;
        int systemWindowInsetLeft = 0;
        int systemWindowInsetTop = 0;
        int systemWindowInsetRight = 0;
        int systemWindowInsetBottom = 0;
        if (this.safeCutOutPadding && null != (displayCutout = insetsCompat.getDisplayCutout())) {
            cutoutPaddingTop = displayCutout.getSafeInsetTop();
            cutoutPaddingLeft = displayCutout.getSafeInsetLeft();
            cutoutPaddingRight = displayCutout.getSafeInsetRight();
            cutoutPaddingBottom = displayCutout.getSafeInsetRight();
        }
        Insets systemBars = insetsCompat.getInsets(WindowInsetsCompat.Type.ime() | WindowInsetsCompat.Type.systemBars());
        systemWindowInsetLeft = systemBars.left;
        systemWindowInsetRight = systemBars.right;
        int suv = this.contentView.getRootView().getWindowSystemUiVisibility();
        boolean statusBar = true;
        if (Build.VERSION.SDK_INT < 30) {
            statusBar = (suv & 4) == 0;
        }
        boolean naviBar = true;
        if (Build.VERSION.SDK_INT < 30) {
            boolean bl = naviBar = (suv & 2) == 0;
        }
        if (naviBar && (insetsCompat.isVisible(WindowInsetsCompat.Type.ime()) || insetsCompat.isVisible(WindowInsetsCompat.Type.navigationBars()))) {
            systemWindowInsetBottom = systemBars.bottom;
        }
        if (statusBar && insetsCompat.isVisible(WindowInsetsCompat.Type.statusBars())) {
            systemWindowInsetTop = systemBars.top;
        }
        if (this.isWrongInsets(systemBars)) {
            this.log("    FitSystemBarUtils: isWrongInsets try special mode...");
            int deviceOrientation = this.checkOrientationAndStatusBarSide();
            this.log("    FitSystemBarUtils: deviceOrientation = " + deviceOrientation);
            switch (deviceOrientation) {
                case 1: {
                    initialPadding.end = this.getStatusBarHeight();
                    initialPadding.start = this.getNavigationBarHeight();
                    break;
                }
                default: {
                    initialPadding.top = this.getStatusBarHeight();
                    initialPadding.bottom = this.getNavigationBarHeight();
                }
            }
            this.addListenerWhenImeHeightChanged();
        } else {
            boolean isRtl;
            this.specialMode = false;
            if (this.callBack.isEnable(Orientation.Top)) {
                initialPadding.top += Math.max(systemWindowInsetTop, cutoutPaddingTop);
            }
            if (this.callBack.isEnable(Orientation.Bottom)) {
                initialPadding.bottom += Math.max(systemWindowInsetBottom, cutoutPaddingBottom);
            }
            boolean bl = isRtl = ViewCompat.getLayoutDirection((View)this.contentView) == 1;
            if (this.callBack.isEnable(Orientation.Start)) {
                initialPadding.start = isRtl ? (initialPadding.start += Math.max(systemWindowInsetRight, cutoutPaddingRight)) : (initialPadding.start += Math.max(systemWindowInsetLeft, cutoutPaddingLeft));
            }
            if (this.callBack.isEnable(Orientation.End)) {
                initialPadding.end = isRtl ? (initialPadding.end += Math.max(systemWindowInsetLeft, cutoutPaddingLeft)) : (initialPadding.end += Math.max(systemWindowInsetRight, cutoutPaddingRight));
            }
        }
        this.applyCallBack(initialPadding);
    }

    private void applyCallBack() {
        if (this.relativePaddingCache != null) {
            this.applyCallBack(this.relativePaddingCache);
        }
    }

    private void applyCallBack(RelativePadding initialPadding) {
        if (this.callBack == null) {
            return;
        }
        initialPadding.start += this.callBack.initialPadding(Orientation.Start);
        initialPadding.top += this.callBack.initialPadding(Orientation.Top);
        initialPadding.end += this.callBack.initialPadding(Orientation.End);
        initialPadding.bottom += this.callBack.initialPadding(Orientation.Bottom);
        initialPadding.applyToView(this.contentView);
        this.log("    KONGZUE DEBUG DIALOGX FitSystemBarUtils callBack: left=" + initialPadding.start + " top=" + initialPadding.top + " right=" + initialPadding.end + " bottom=" + initialPadding.bottom + " specialMode=" + this.specialMode + " specialModeImeHeight=" + this.specialModeImeHeight);
        this.callBack.unsafeRect(initialPadding.start, initialPadding.top, initialPadding.end, initialPadding.bottom + (this.specialMode ? this.specialModeImeHeight : 0));
    }

    private boolean isWrongInsets(Insets systemBars) {
        return systemBars.top == 0 && systemBars.bottom == 0 && systemBars.left == 0 && systemBars.right == 0;
    }

    protected void log(String s) {
        if (DialogXBaseRelativeLayout.debugMode && DialogX.DEBUGMODE) {
            Log.e((String)">>>", (String)s);
        }
    }

    private int getStatusBarHeight() {
        WindowInsetsController insetsController;
        if (this.isFullScreen() || this.getDecorView() == null) {
            return 0;
        }
        WindowInsetsController windowInsetsController = insetsController = Build.VERSION.SDK_INT >= 30 ? this.getDecorView().getWindowInsetsController() : null;
        if (Build.VERSION.SDK_INT >= 30 && insetsController != null && (insetsController.getSystemBarsBehavior() & 0x2000) == 0) {
            return 0;
        }
        Resources res = this.contentView == null || this.contentView.getContext() == null ? Resources.getSystem() : this.contentView.getContext().getResources();
        int result = 0;
        int resourceId = res.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = res.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    private int getNavigationBarHeight() {
        WindowInsetsController insetsController;
        if (this.isFullScreen() || this.getDecorView() == null) {
            return 0;
        }
        WindowInsetsController windowInsetsController = insetsController = Build.VERSION.SDK_INT >= 30 ? this.getDecorView().getWindowInsetsController() : null;
        if (Build.VERSION.SDK_INT >= 30 && insetsController != null && (insetsController.getSystemBarsBehavior() & 0x10) == 0) {
            this.log("getNavigationBarHeight =0");
            return 0;
        }
        Resources res = this.contentView == null || this.contentView.getContext() == null ? Resources.getSystem() : this.contentView.getContext().getResources();
        int result = 0;
        int resourceId = res.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = res.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    private boolean isFullScreen() {
        Activity activity = BaseDialog.getTopActivity();
        if (activity == null) {
            return false;
        }
        int flags = activity.getWindow().getAttributes().flags;
        if ((flags & 0x400) != 0) {
            return true;
        }
        int uiOptions = activity.getWindow().getDecorView().getSystemUiVisibility();
        return (uiOptions & 4) != 0;
    }

    private int checkOrientationAndStatusBarSide() {
        Activity activity = BaseDialog.getTopActivity();
        if (activity == null) {
            return 0;
        }
        if (activity.getResources().getConfiguration().orientation == 2) {
            int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
            switch (rotation) {
                case 1: {
                    return -1;
                }
                case 3: {
                    return 1;
                }
            }
            return 0;
        }
        return 0;
    }

    private View getDecorView() {
        Activity activity = BaseDialog.getTopActivity();
        if (activity == null) {
            return null;
        }
        return activity.getWindow().getDecorView();
    }

    private void addListenerWhenImeHeightChanged() {
        this.specialMode = true;
        final View decorView = this.getDecorView();
        if (decorView == null) {
            return;
        }
        if (this.onGlobalLayoutListener != null) {
            decorView.getViewTreeObserver().removeOnGlobalLayoutListener(this.onGlobalLayoutListener);
        }
        this.onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                int keypadHeight;
                WindowInsetsController insetsController;
                Rect r = new Rect();
                decorView.getWindowVisibleDisplayFrame(r);
                int screenHeight = decorView.getHeight();
                WindowInsetsController windowInsetsController = insetsController = Build.VERSION.SDK_INT >= 30 ? FitSystemBarUtils.this.getDecorView().getWindowInsetsController() : null;
                if (Build.VERSION.SDK_INT >= 30 && insetsController != null && (insetsController.getSystemBarsBehavior() & 0x10) == 0) {
                    r.bottom = screenHeight;
                }
                if ((keypadHeight = screenHeight - r.bottom) != FitSystemBarUtils.this.specialModeImeHeight) {
                    FitSystemBarUtils.this.specialModeImeHeight = keypadHeight;
                    FitSystemBarUtils.this.log("    FitSystemBarUtils: specialModeImeHeight=" + FitSystemBarUtils.this.specialModeImeHeight);
                    FitSystemBarUtils.this.applyCallBack();
                }
            }
        };
        decorView.getViewTreeObserver().addOnGlobalLayoutListener(this.onGlobalLayoutListener);
    }

    private int getAppTargetSDKVersion() {
        try {
            Context context = BaseDialog.getApplicationContext();
            if (context == null) {
                return -1;
            }
            PackageManager pm = context.getPackageManager();
            ApplicationInfo applicationInfo = pm.getApplicationInfo(context.getPackageName(), 0);
            int targetSdkVersion = applicationInfo.targetSdkVersion;
            return targetSdkVersion;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
    }

    static enum Orientation {
        Start,
        Top,
        End,
        Bottom;

    }

    public static class RelativePadding {
        int start;
        int top;
        int end;
        int bottom;

        public RelativePadding(int start, int top, int end, int bottom) {
            this.start = start;
            this.top = top;
            this.end = end;
            this.bottom = bottom;
        }

        public RelativePadding(RelativePadding other) {
            this.start = other.start;
            this.top = other.top;
            this.end = other.end;
            this.bottom = other.bottom;
        }

        public void applyToView(View view) {
            if (!(view instanceof DialogXBaseRelativeLayout)) {
                ViewCompat.setPaddingRelative((View)view, (int)this.start, (int)this.top, (int)this.end, (int)this.bottom);
            }
        }
    }

    public static interface CallBack {
        public boolean isEnable(Orientation var1);

        public void unsafeRect(int var1, int var2, int var3, int var4);

        public int initialPadding(Orientation var1);
    }
}

