/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.impl.ActivityLifecycleImpl;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.util.DialogXFloatingWindowActivity;
import java.lang.ref.WeakReference;
import java.util.Objects;

@SuppressLint(value={"AppCompatCustomView"})
public class ActivityScreenShotImageView
extends ImageView {
    public boolean hideActivityContentView;
    float width;
    float height;
    float mRadius;
    public static boolean useHardwareRenderingMode = true;
    boolean readyDraw = false;
    private int screenWidth;
    private int screenHeight;
    private boolean inited = false;
    private boolean isScreenshotSuccess;
    private WeakReference<View> contentView;
    public static boolean hideContentView = false;
    BaseDialog dialog;

    public ActivityScreenShotImageView(Context context) {
        super(context);
        this.init(null);
    }

    public ActivityScreenShotImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public ActivityScreenShotImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.requestLayoutType();
    }

    private void requestLayoutType() {
        this.setLayerType(useHardwareRenderingMode ? 2 : 1, null);
    }

    public void setRadius(float mRadius) {
        this.mRadius = mRadius;
        this.invalidate();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.width != (float)this.getWidth() || this.height != (float)this.getHeight()) {
            this.refreshImage();
        }
        this.width = this.getWidth();
        this.height = this.getHeight();
    }

    protected void onDraw(Canvas canvas) {
        if (!this.readyDraw) {
            super.onDraw(canvas);
        }
        if (this.width >= this.mRadius && this.height > this.mRadius) {
            if (this.isScreenshotSuccess) {
                canvas.drawColor(-16777216);
            }
            Path path = new Path();
            path.moveTo(this.mRadius, 0.0f);
            path.lineTo(this.width - this.mRadius, 0.0f);
            path.quadTo(this.width, 0.0f, this.width, this.mRadius);
            path.lineTo(this.width, this.height - this.mRadius);
            path.quadTo(this.width, this.height, this.width - this.mRadius, this.height);
            path.lineTo(this.mRadius, this.height);
            path.quadTo(0.0f, this.height, 0.0f, this.height - this.mRadius);
            path.lineTo(0.0f, this.mRadius);
            path.quadTo(0.0f, 0.0f, this.mRadius, 0.0f);
            canvas.clipPath(path);
        }
        canvas.drawColor(-1);
        super.onDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.isScreenshotSuccess) {
            this.refreshImage();
        }
    }

    private void refreshImage() {
        if (!this.isAttachedToWindow()) {
            return;
        }
        if (this.screenWidth != this.getMeasuredWidth() || this.screenHeight != this.getMeasuredHeight()) {
            this.screenWidth = this.getMeasuredWidth();
            this.screenHeight = this.getMeasuredHeight();
            this.doScreenshotActivityAndZoom();
        }
    }

    private void doScreenshotActivityAndZoom() {
        ViewGroup decorView = this.getDecorView();
        if (decorView == null) {
            return;
        }
        this.drawViewImage((View)decorView);
        this.setVisibility(0);
        this.inited = true;
    }

    private ViewGroup getDecorView() {
        if (this.dialog != null) {
            Activity ownActivity = this.dialog.getOwnActivity();
            return (ViewGroup)ownActivity.getWindow().getDecorView();
        }
        Activity topActivity = ActivityLifecycleImpl.getTopActivity();
        if (topActivity != null) {
            if (topActivity instanceof DialogXFloatingWindowActivity) {
                return (ViewGroup)((DialogXFloatingWindowActivity)topActivity).getFromActivity().getWindow().getDecorView();
            }
            return (ViewGroup)topActivity.getWindow().getDecorView();
        }
        return null;
    }

    private void drawViewImage(View view) {
        Bitmap bitmap;
        block5: {
            if (view.getWidth() == 0 || view.getHeight() == 0) {
                return;
            }
            this.dialog.getDialogView().setVisibility(8);
            this.setContentViewVisibility(true);
            if (view.getWidth() + view.getHeight() == 0) {
                view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
            }
            int viewWidth = view.getWidth();
            int viewHeight = view.getHeight();
            bitmap = Bitmap.createBitmap((int)viewWidth, (int)viewHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            try {
                view.draw(canvas);
            }
            catch (Exception e) {
                if (DialogX.DEBUGMODE) {
                    e.printStackTrace();
                }
                if (!useHardwareRenderingMode) break block5;
                useHardwareRenderingMode = false;
                this.requestLayoutType();
                this.drawViewImage(view);
            }
        }
        this.setImageBitmap(Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)view.getWidth(), (int)view.getHeight()));
        this.isScreenshotSuccess = true;
        this.setContentViewVisibility(false);
        this.dialog.getDialogView().setVisibility(0);
        this.dialog.getDialogView().requestFocus();
    }

    protected void setContentViewVisibility(boolean show) {
        if (hideContentView || this.hideActivityContentView) {
            if (show) {
                if (this.contentView != null && this.contentView.get() != null) {
                    ((View)this.contentView.get()).setVisibility(0);
                }
            } else {
                View userContentView = Objects.requireNonNull(this.getDecorView()).getChildAt(0);
                if (userContentView != null) {
                    userContentView.setVisibility(8);
                    this.contentView = new WeakReference<View>(userContentView);
                }
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.setContentViewVisibility(true);
        if (this.contentView != null) {
            this.contentView.clear();
        }
    }

    public void setScale(float scale) {
        this.setScaleX(scale);
        this.setScaleY(scale);
        this.readyDraw = true;
    }

    public void bindDialog(BaseDialog dialog) {
        this.dialog = dialog;
    }
}

