/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.provider.Settings;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.Toast;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.NoTouchInterface;

public class WindowUtil {
    public static void show(final Activity activity, final View dialogView, final boolean touchEnable) {
        block4: {
            try {
                if (activity.getWindow().getDecorView().isAttachedToWindow()) {
                    WindowUtil.showNow(activity, dialogView, touchEnable);
                } else {
                    activity.getWindow().getDecorView().post(new Runnable(){

                        @Override
                        public void run() {
                            WindowUtil.showNow(activity, dialogView, touchEnable);
                        }
                    });
                }
            }
            catch (Exception e) {
                if (activity == null || activity.isDestroyed()) break block4;
                WindowUtil.showNow(activity, dialogView, touchEnable);
            }
        }
    }

    private static void showNow(final Activity activity, View dialogView, boolean touchEnable) {
        if (DialogX.globalHoverWindow && Build.VERSION.SDK_INT >= 23 && !Settings.canDrawOverlays((Context)activity)) {
            Toast.makeText((Context)activity, (CharSequence)"\u4f7f\u7528 DialogX.globalHoverWindow \u5fc5\u987b\u5f00\u542f\u60ac\u6d6e\u7a97\u6743\u9650", (int)1).show();
            Intent intent = new Intent();
            intent.setAction("android.settings.action.MANAGE_OVERLAY_PERMISSION");
            activity.startActivity(intent);
            return;
        }
        FrameLayout rootLayout = new FrameLayout((Context)activity);
        if (dialogView.getParent() != null) {
            ((ViewGroup)dialogView.getParent()).removeView(dialogView);
        }
        rootLayout.addView(dialogView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        WindowManager manager = (WindowManager)activity.getSystemService("window");
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        layoutParams.gravity = 16;
        layoutParams.format = -2;
        layoutParams.type = DialogX.globalHoverWindow ? (Build.VERSION.SDK_INT >= 26 ? 2038 : 2002) : 1003;
        layoutParams.flags = 0xC000500;
        layoutParams.softInputMode = 16;
        if (!touchEnable) {
            dialogView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    for (int i = BaseDialog.getRunningDialogList().size() - 1; i >= 0; --i) {
                        BaseDialog baseDialog = BaseDialog.getRunningDialogList().get(i);
                        if (baseDialog instanceof NoTouchInterface || baseDialog.getOwnActivity() != activity) continue;
                        if (baseDialog.getDialogView() == null) {
                            return false;
                        }
                        return baseDialog.getOwnActivity().dispatchTouchEvent(event);
                    }
                    return activity.dispatchTouchEvent(event);
                }
            });
        }
        if (Build.VERSION.SDK_INT >= 28) {
            layoutParams.layoutInDisplayCutoutMode = 1;
        }
        manager.addView((View)rootLayout, (ViewGroup.LayoutParams)layoutParams);
    }

    public static void dismiss(View dialogView) {
        BaseDialog baseDialog = (BaseDialog)dialogView.getTag();
        if (baseDialog != null && baseDialog.getOwnActivity() != null) {
            WindowManager manager = (WindowManager)baseDialog.getOwnActivity().getSystemService("window");
            manager.removeViewImmediate((View)dialogView.getParent());
        }
    }
}

