/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.Space;
import android.widget.TextView;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.dialogs.MessageMenu;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.SELECT_MODE;
import com.kongzue.dialogx.util.TextInfo;
import java.util.List;

public class MessageMenuArrayAdapter
extends BaseAdapter {
    private MessageMenu messageMenu;
    public List<CharSequence> objects;
    public Context context;
    TextInfo defaultMenuTextInfo;

    public MessageMenuArrayAdapter(MessageMenu messageMenu, Context context, List<CharSequence> objects) {
        this.objects = objects;
        this.context = context;
        this.messageMenu = messageMenu;
    }

    public int getCount() {
        return this.objects.size();
    }

    public CharSequence getItem(int position) {
        return this.objects.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int textColor;
        ViewHolder viewHolder = null;
        if (convertView == null) {
            viewHolder = new ViewHolder();
            LayoutInflater mInflater = LayoutInflater.from((Context)this.context);
            int resourceId = R.layout.item_dialogx_material_bottom_menu_normal_text;
            if (this.messageMenu.getStyle().overrideBottomDialogRes() != null) {
                resourceId = this.messageMenu.getStyle().overrideBottomDialogRes().overrideMenuItemLayout(this.messageMenu.isLightTheme(), position, this.getCount(), false);
                if (resourceId == 0) {
                    resourceId = R.layout.item_dialogx_material_bottom_menu_normal_text;
                } else if (!(BaseDialog.isNull(this.messageMenu.getTitle()) && BaseDialog.isNull(this.messageMenu.getMessage()) && this.messageMenu.getCustomView() == null || position != 0)) {
                    resourceId = this.messageMenu.getStyle().overrideBottomDialogRes().overrideMenuItemLayout(this.messageMenu.isLightTheme(), position, this.getCount(), true);
                }
            }
            convertView = mInflater.inflate(resourceId, null);
            viewHolder.imgDialogxMenuIcon = (ImageView)convertView.findViewById(R.id.img_dialogx_menu_icon);
            viewHolder.imgDialogxMenuSelection = (ImageView)convertView.findViewById(R.id.img_dialogx_menu_selection);
            viewHolder.txtDialogxMenuText = (TextView)convertView.findViewById(R.id.txt_dialogx_menu_text);
            viewHolder.spaceDialogxRightPadding = (Space)convertView.findViewById(R.id.space_dialogx_right_padding);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        if (!this.messageMenu.isMenuItemEnable(position)) {
            convertView.setAlpha(0.4f);
        } else {
            convertView.setAlpha(1.0f);
        }
        if (this.messageMenu.getSelectMode() == SELECT_MODE.SINGLE) {
            if (viewHolder.imgDialogxMenuSelection != null) {
                if (this.messageMenu.getSelection() == position) {
                    viewHolder.imgDialogxMenuSelection.setVisibility(0);
                    int overrideSelectionImageResId = this.messageMenu.getStyle().overrideBottomDialogRes().overrideSelectionImage(this.messageMenu.isLightTheme(), true);
                    if (overrideSelectionImageResId != 0) {
                        viewHolder.imgDialogxMenuSelection.setImageResource(overrideSelectionImageResId);
                    }
                } else {
                    int overrideSelectionImageResId = this.messageMenu.getStyle().overrideBottomDialogRes().overrideSelectionImage(this.messageMenu.isLightTheme(), false);
                    if (overrideSelectionImageResId != 0) {
                        viewHolder.imgDialogxMenuSelection.setVisibility(0);
                        viewHolder.imgDialogxMenuSelection.setImageResource(overrideSelectionImageResId);
                    } else {
                        viewHolder.imgDialogxMenuSelection.setVisibility(4);
                    }
                }
            }
        } else if (this.messageMenu.getSelectMode() == SELECT_MODE.MULTIPLE) {
            if (viewHolder.imgDialogxMenuSelection != null) {
                if (this.messageMenu.getSelectionList().contains(position)) {
                    viewHolder.imgDialogxMenuSelection.setVisibility(0);
                    int overrideSelectionImageResId = this.messageMenu.getStyle().overrideBottomDialogRes().overrideMultiSelectionImage(this.messageMenu.isLightTheme(), true);
                    if (overrideSelectionImageResId != 0) {
                        viewHolder.imgDialogxMenuSelection.setImageResource(overrideSelectionImageResId);
                    }
                } else {
                    int overrideSelectionImageResId = this.messageMenu.getStyle().overrideBottomDialogRes().overrideMultiSelectionImage(this.messageMenu.isLightTheme(), false);
                    if (overrideSelectionImageResId != 0) {
                        viewHolder.imgDialogxMenuSelection.setVisibility(0);
                        viewHolder.imgDialogxMenuSelection.setImageResource(overrideSelectionImageResId);
                    } else {
                        viewHolder.imgDialogxMenuSelection.setVisibility(4);
                    }
                }
            }
        } else {
            viewHolder.imgDialogxMenuSelection.setVisibility(8);
        }
        int overrideSelectionBackgroundColorRes = 0;
        if (this.messageMenu.getStyle().overrideBottomDialogRes() != null) {
            overrideSelectionBackgroundColorRes = this.messageMenu.getStyle().overrideBottomDialogRes().overrideSelectionMenuBackgroundColor(this.messageMenu.isLightTheme());
        }
        if (this.messageMenu.getSelection() == position && overrideSelectionBackgroundColorRes != 0 && Build.VERSION.SDK_INT >= 21) {
            convertView.setBackgroundTintList(ColorStateList.valueOf((int)this.context.getResources().getColor(overrideSelectionBackgroundColorRes)));
        }
        CharSequence text = this.objects.get(position);
        int n = textColor = this.messageMenu.isLightTheme() ? R.color.black90 : R.color.white90;
        if (this.messageMenu.getStyle().overrideBottomDialogRes() != null && this.messageMenu.getStyle().overrideBottomDialogRes().overrideMenuTextColor(this.messageMenu.isLightTheme()) != 0) {
            textColor = this.messageMenu.getStyle().overrideBottomDialogRes().overrideMenuTextColor(this.messageMenu.isLightTheme());
        }
        if (null != text) {
            if (this.defaultMenuTextInfo == null) {
                this.defaultMenuTextInfo = new TextInfo().setShowEllipsis(viewHolder.txtDialogxMenuText.getEllipsize() == TextUtils.TruncateAt.END).setFontColor(viewHolder.txtDialogxMenuText.getTextColors().getDefaultColor()).setBold(viewHolder.txtDialogxMenuText.getPaint().isFakeBoldText()).setFontSize(this.px2dip(viewHolder.txtDialogxMenuText.getTextSize())).setGravity(viewHolder.txtDialogxMenuText.getGravity()).setMaxLines(viewHolder.txtDialogxMenuText.getMaxLines());
            }
            viewHolder.txtDialogxMenuText.setText(text);
            viewHolder.txtDialogxMenuText.setTextColor(this.context.getResources().getColor(textColor));
            if (this.messageMenu.getMenuItemTextInfoInterceptor() != null) {
                TextInfo textInfo = this.messageMenu.getMenuItemTextInfoInterceptor().menuItemTextInfo(this.messageMenu, position, text.toString());
                if (textInfo != null) {
                    BaseDialog.useTextInfo(viewHolder.txtDialogxMenuText, textInfo);
                } else if (this.messageMenu.getMenuTextInfo() != null) {
                    BaseDialog.useTextInfo(viewHolder.txtDialogxMenuText, this.messageMenu.getMenuTextInfo());
                } else {
                    BaseDialog.useTextInfo(viewHolder.txtDialogxMenuText, this.defaultMenuTextInfo);
                }
            } else if (this.messageMenu.getMenuTextInfo() != null) {
                BaseDialog.useTextInfo(viewHolder.txtDialogxMenuText, this.messageMenu.getMenuTextInfo());
            }
            if (Build.VERSION.SDK_INT >= 21 && viewHolder.imgDialogxMenuSelection != null) {
                if (this.messageMenu.getStyle().overrideBottomDialogRes() != null && this.messageMenu.getStyle().overrideBottomDialogRes().selectionImageTint(this.messageMenu.isLightTheme())) {
                    viewHolder.imgDialogxMenuSelection.setImageTintList(ColorStateList.valueOf((int)this.context.getResources().getColor(textColor)));
                } else {
                    viewHolder.imgDialogxMenuSelection.setImageTintList(null);
                }
            }
            if (this.messageMenu.getOnIconChangeCallBack() != null) {
                boolean autoTintIconInLightOrDarkMode;
                int resId = this.messageMenu.getOnIconChangeCallBack().getIcon(this.messageMenu, position, text.toString());
                boolean bl = autoTintIconInLightOrDarkMode = this.messageMenu.getOnIconChangeCallBack().isAutoTintIconInLightOrDarkMode() == null ? this.messageMenu.isAutoTintIconInLightOrDarkMode() : this.messageMenu.getOnIconChangeCallBack().isAutoTintIconInLightOrDarkMode().booleanValue();
                if (resId != 0) {
                    viewHolder.imgDialogxMenuIcon.setVisibility(0);
                    viewHolder.imgDialogxMenuIcon.setImageResource(resId);
                    if (viewHolder.spaceDialogxRightPadding != null) {
                        viewHolder.spaceDialogxRightPadding.setVisibility(0);
                    }
                    if (Build.VERSION.SDK_INT >= 21 && autoTintIconInLightOrDarkMode) {
                        viewHolder.imgDialogxMenuIcon.setImageTintList(ColorStateList.valueOf((int)this.context.getResources().getColor(textColor)));
                    }
                } else {
                    viewHolder.imgDialogxMenuIcon.setVisibility(8);
                    if (viewHolder.spaceDialogxRightPadding != null) {
                        viewHolder.spaceDialogxRightPadding.setVisibility(8);
                    }
                }
            } else if (this.messageMenu.getIconResIds() != null) {
                int resId = this.messageMenu.getIconResIds(position);
                boolean autoTintIconInLightOrDarkMode = this.messageMenu.isAutoTintIconInLightOrDarkMode();
                if (resId != 0) {
                    viewHolder.imgDialogxMenuIcon.setVisibility(0);
                    viewHolder.imgDialogxMenuIcon.setImageResource(resId);
                    if (viewHolder.spaceDialogxRightPadding != null) {
                        viewHolder.spaceDialogxRightPadding.setVisibility(0);
                    }
                    if (Build.VERSION.SDK_INT >= 21 && autoTintIconInLightOrDarkMode) {
                        viewHolder.imgDialogxMenuIcon.setImageTintList(ColorStateList.valueOf((int)this.context.getResources().getColor(textColor)));
                    }
                } else {
                    viewHolder.imgDialogxMenuIcon.setVisibility(8);
                    if (viewHolder.spaceDialogxRightPadding != null) {
                        viewHolder.spaceDialogxRightPadding.setVisibility(8);
                    }
                }
            } else {
                viewHolder.imgDialogxMenuIcon.setVisibility(8);
                if (viewHolder.spaceDialogxRightPadding != null) {
                    viewHolder.spaceDialogxRightPadding.setVisibility(8);
                }
            }
        }
        if (this.messageMenu.getMenuMenuItemLayoutRefreshCallback() != null) {
            this.messageMenu.getMenuMenuItemLayoutRefreshCallback().getView(this.messageMenu, position, convertView, parent);
        }
        return convertView;
    }

    private int px2dip(float pxValue) {
        float scale = this.context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    class ViewHolder {
        ImageView imgDialogxMenuIcon;
        ImageView imgDialogxMenuSelection;
        TextView txtDialogxMenuText;
        Space spaceDialogxRightPadding;

        ViewHolder() {
        }
    }
}

