/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util;

import android.animation.ObjectAnimator;
import android.content.res.Resources;
import android.graphics.RectF;
import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.dialogs.FullScreenDialog;
import com.kongzue.dialogx.interfaces.ScrollController;

public class FullScreenDialogTouchEventInterceptor {
    private boolean isBkgTouched = false;
    private float bkgTouchDownY;
    private float bkgOldY;

    public FullScreenDialogTouchEventInterceptor(FullScreenDialog me, FullScreenDialog.DialogImpl impl) {
        this.refresh(me, impl);
    }

    public void refresh(final FullScreenDialog me, final FullScreenDialog.DialogImpl impl) {
        if (me == null || impl == null || impl.bkg == null) {
            return;
        }
        if (me.isAllowInterceptTouch()) {
            RelativeLayout touchView = impl.boxCustom;
            if (impl.scrollView != null) {
                touchView = impl.bkg;
            }
            touchView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    switch (event.getAction()) {
                        case 0: {
                            FullScreenDialogTouchEventInterceptor.this.bkgTouchDownY = event.getY();
                            FullScreenDialogTouchEventInterceptor.this.isBkgTouched = true;
                            FullScreenDialogTouchEventInterceptor.this.bkgOldY = impl.bkg.getY();
                            break;
                        }
                        case 2: {
                            if (!FullScreenDialogTouchEventInterceptor.this.isBkgTouched) break;
                            float aimY = impl.bkg.getY() + event.getY() - FullScreenDialogTouchEventInterceptor.this.bkgTouchDownY;
                            if (impl.scrollView != null && impl.scrollView.isCanScroll() && FullScreenDialogTouchEventInterceptor.this.touchInScrollView(v, impl.scrollView, event)) {
                                if (aimY > me.getDialogImpl().getEnterY()) {
                                    if (impl.scrollView.getScrollDistance() == 0) {
                                        if (impl.scrollView instanceof ScrollController) {
                                            impl.scrollView.lockScroll(true);
                                        }
                                        impl.bkg.setY(aimY);
                                        break;
                                    }
                                    FullScreenDialogTouchEventInterceptor.this.bkgTouchDownY = event.getY();
                                    break;
                                }
                                if (impl.scrollView instanceof ScrollController) {
                                    impl.scrollView.lockScroll(false);
                                }
                                aimY = me.getDialogImpl().getEnterY();
                                impl.bkg.setY(aimY);
                                break;
                            }
                            if (aimY < me.getDialogImpl().getEnterY()) {
                                aimY = me.getDialogImpl().getEnterY();
                            }
                            impl.bkg.setY(aimY);
                            break;
                        }
                        case 1: 
                        case 3: {
                            FullScreenDialogTouchEventInterceptor.this.isBkgTouched = false;
                            if (FullScreenDialogTouchEventInterceptor.this.bkgOldY == me.getDialogImpl().getEnterY()) {
                                if (impl.bkg.getY() < (float)DialogX.touchSlideTriggerThreshold) {
                                    ObjectAnimator enterAnim = ObjectAnimator.ofFloat((Object)impl.bkg, (String)"y", (float[])new float[]{impl.bkg.getY(), me.getDialogImpl().getEnterY()});
                                    enterAnim.setDuration(300L);
                                    enterAnim.start();
                                } else if (impl.bkg.getY() > impl.getEnterY() + (float)DialogX.touchSlideTriggerThreshold) {
                                    impl.preDismiss();
                                } else {
                                    ObjectAnimator enterAnim = ObjectAnimator.ofFloat((Object)impl.bkg, (String)"y", (float[])new float[]{impl.bkg.getY(), impl.getEnterY()});
                                    enterAnim.setDuration(300L);
                                    enterAnim.start();
                                }
                            } else if (impl.bkg.getY() < FullScreenDialogTouchEventInterceptor.this.bkgOldY - (float)DialogX.touchSlideTriggerThreshold) {
                                ObjectAnimator enterAnim = ObjectAnimator.ofFloat((Object)impl.bkg, (String)"y", (float[])new float[]{impl.bkg.getY(), me.getDialogImpl().getEnterY()});
                                enterAnim.setDuration(300L);
                                enterAnim.start();
                            } else if (impl.bkg.getY() > FullScreenDialogTouchEventInterceptor.this.bkgOldY + (float)DialogX.touchSlideTriggerThreshold) {
                                impl.preDismiss();
                            } else {
                                ObjectAnimator enterAnim = ObjectAnimator.ofFloat((Object)impl.bkg, (String)"y", (float[])new float[]{impl.bkg.getY(), impl.getEnterY()});
                                enterAnim.setDuration(300L);
                                enterAnim.start();
                            }
                            if (!(impl.scrollView instanceof ScrollController)) break;
                            impl.scrollView.lockScroll(false);
                        }
                    }
                    return false;
                }
            });
        } else {
            RelativeLayout touchView = impl.boxCustom;
            if (impl.scrollView != null) {
                touchView = impl.bkg;
            }
            if (impl.scrollView instanceof ScrollController) {
                impl.scrollView.lockScroll(false);
            }
            touchView.setOnTouchListener(null);
        }
    }

    private boolean touchInScrollView(View slideView, ScrollController scrollView, MotionEvent event) {
        View scrollViewImpl = (View)scrollView;
        RectF scrollViewLocation = new RectF();
        int[] scrollViewScreenLoc = new int[2];
        int[] rootViewScreenLoc = new int[2];
        scrollViewImpl.getLocationInWindow(scrollViewScreenLoc);
        slideView.getLocationInWindow(rootViewScreenLoc);
        scrollViewLocation.left = scrollViewScreenLoc[0] - rootViewScreenLoc[0];
        scrollViewLocation.top = scrollViewScreenLoc[1] - rootViewScreenLoc[1];
        scrollViewLocation.right = scrollViewLocation.left + (float)scrollViewImpl.getWidth();
        scrollViewLocation.bottom = scrollViewLocation.top + (float)scrollViewImpl.getHeight();
        return event.getX() >= scrollViewLocation.left && event.getX() <= scrollViewLocation.right && event.getY() >= scrollViewLocation.top && event.getY() <= scrollViewLocation.bottom;
    }

    private int dip2px(float dpValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

