/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util;

import android.os.Handler;
import android.os.Looper;
import android.view.animation.Interpolator;

public class DialogXValueAnimator {
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;
    Handler handler = new Handler(Looper.getMainLooper());
    private long duration;
    private long startTime;
    private boolean isRunning = false;
    private ValueUpdateListener listener;
    private Interpolator interpolator;
    private float startValue;
    private float endValue;
    private int repeatCount = 0;
    private int currentRepeatCount = 0;
    private int refreshInterval = 16;

    public static DialogXValueAnimator ofFloat(float start, float end) {
        return new DialogXValueAnimator(start, end);
    }

    public DialogXValueAnimator(float startValue, float endValue) {
        this.startValue = startValue;
        this.endValue = endValue;
    }

    public void setFloatValues(float start, float end) {
        this.startValue = start;
        this.endValue = end;
    }

    public void addUpdateListener(ValueUpdateListener listener) {
        this.listener = listener;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.startTime = System.currentTimeMillis();
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (DialogXValueAnimator.this.isRunning) {
                    long currentTime = System.currentTimeMillis();
                    long elapsed = currentTime - DialogXValueAnimator.this.startTime;
                    if (elapsed < DialogXValueAnimator.this.duration) {
                        float fraction = (float)elapsed / (float)DialogXValueAnimator.this.duration;
                        if (DialogXValueAnimator.this.interpolator != null) {
                            fraction = DialogXValueAnimator.this.interpolator.getInterpolation(fraction);
                        }
                        final float animatedValue = DialogXValueAnimator.this.startValue + fraction * (DialogXValueAnimator.this.endValue - DialogXValueAnimator.this.startValue);
                        if (DialogXValueAnimator.this.listener != null) {
                            DialogXValueAnimator.this.getHandler().post(new Runnable(){

                                @Override
                                public void run() {
                                    DialogXValueAnimator.this.listener.onValueUpdate(animatedValue);
                                }
                            });
                        }
                    } else {
                        DialogXValueAnimator.this.isRunning = false;
                        DialogXValueAnimator.this.onAnimationEnd();
                        if (DialogXValueAnimator.this.repeatCount == -1 || DialogXValueAnimator.this.currentRepeatCount < DialogXValueAnimator.this.repeatCount) {
                            DialogXValueAnimator.this.currentRepeatCount++;
                            DialogXValueAnimator.this.startTime = System.currentTimeMillis();
                            DialogXValueAnimator.this.isRunning = true;
                        }
                    }
                    try {
                        Thread.sleep(DialogXValueAnimator.this.refreshInterval);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler(Looper.getMainLooper());
        }
        return this.handler;
    }

    private void onAnimationEnd() {
    }

    public long getDuration() {
        return this.duration;
    }

    public DialogXValueAnimator setDuration(long duration) {
        this.duration = duration;
        return this;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public DialogXValueAnimator setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public ValueUpdateListener getListener() {
        return this.listener;
    }

    public DialogXValueAnimator setListener(ValueUpdateListener listener) {
        this.listener = listener;
        return this;
    }

    public float getStartValue() {
        return this.startValue;
    }

    public DialogXValueAnimator setStartValue(float startValue) {
        this.startValue = startValue;
        return this;
    }

    public float getEndValue() {
        return this.endValue;
    }

    public DialogXValueAnimator setEndValue(float endValue) {
        this.endValue = endValue;
        return this;
    }

    public void cancel() {
        this.isRunning = false;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public int getCurrentRepeatCount() {
        return this.currentRepeatCount;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public DialogXValueAnimator setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
        return this;
    }

    public static interface ValueUpdateListener {
        public void onValueUpdate(float var1);
    }
}

