/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util;

import android.animation.ObjectAnimator;
import android.content.res.Resources;
import android.graphics.RectF;
import android.view.MotionEvent;
import android.view.View;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.dialogs.BottomDialog;
import com.kongzue.dialogx.interfaces.BottomDialogSlideEventLifecycleCallback;
import com.kongzue.dialogx.interfaces.ScrollController;
import com.kongzue.dialogx.util.views.MaxRelativeLayout;

public class BottomDialogTouchEventInterceptor {
    private boolean isBkgTouched = false;
    private float bkgTouchDownY;
    private float scrolledY;
    private float bkgOldY;
    private boolean onlyRestrictingSlideTouchEventsToScrollLayoutAreas = false;
    private int oldMode;

    public BottomDialogTouchEventInterceptor(BottomDialog me, BottomDialog.DialogImpl impl) {
        this.refresh(me, impl);
    }

    public void refresh(final BottomDialog me, final BottomDialog.DialogImpl impl) {
        if (me == null || impl == null || impl.bkg == null || impl.scrollView == null) {
            return;
        }
        MaxRelativeLayout interceptTouchView = impl.bkg;
        if (me.isAllowInterceptTouch()) {
            if (this.isOnlyRestrictingSlideTouchEventsToScrollLayoutAreas()) {
                impl.bkg.setOnTouchListener(null);
                interceptTouchView = (View)impl.scrollView;
            }
            MaxRelativeLayout finalInterceptTouchView = interceptTouchView;
            interceptTouchView.setOnTouchListener(new View.OnTouchListener((View)finalInterceptTouchView){
                final /* synthetic */ View val$finalInterceptTouchView;
                {
                    this.val$finalInterceptTouchView = view;
                }

                public boolean onTouch(View v, MotionEvent event) {
                    if (me.getDialogLifecycleCallback() instanceof BottomDialogSlideEventLifecycleCallback && ((BottomDialogSlideEventLifecycleCallback)me.getDialogLifecycleCallback()).onSlideTouchEvent(me, v, event)) {
                        return true;
                    }
                    switch (event.getAction()) {
                        case 0: {
                            BottomDialogTouchEventInterceptor.this.bkgTouchDownY = event.getY();
                            BottomDialogTouchEventInterceptor.this.isBkgTouched = true;
                            BottomDialogTouchEventInterceptor.this.bkgOldY = impl.boxBkg.getY();
                            break;
                        }
                        case 2: {
                            if (!BottomDialogTouchEventInterceptor.this.isBkgTouched || !me.isAllowInterceptTouch()) break;
                            float aimY = impl.boxBkg.getY() + event.getY() - BottomDialogTouchEventInterceptor.this.bkgTouchDownY;
                            if (impl.scrollView.isCanScroll() && BottomDialogTouchEventInterceptor.this.touchInScrollView(this.val$finalInterceptTouchView, impl.scrollView, event)) {
                                if (aimY > (float)impl.boxRoot.getUnsafePlace().top) {
                                    if (impl.scrollView.getScrollDistance() == 0) {
                                        impl.scrollView.lockScroll(true);
                                        impl.boxBkg.setY(aimY);
                                        break;
                                    }
                                    BottomDialogTouchEventInterceptor.this.bkgTouchDownY = event.getY();
                                    break;
                                }
                                impl.scrollView.lockScroll(false);
                                impl.boxBkg.setY((float)impl.boxRoot.getUnsafePlace().top);
                                break;
                            }
                            if (aimY > (float)impl.boxRoot.getUnsafePlace().top) {
                                impl.boxBkg.setY(aimY);
                                return true;
                            }
                            impl.boxBkg.setY((float)impl.boxRoot.getUnsafePlace().top);
                            break;
                        }
                        case 1: 
                        case 3: {
                            BottomDialogTouchEventInterceptor.this.scrolledY = impl.scrollView.getScrollDistance();
                            BottomDialogTouchEventInterceptor.this.isBkgTouched = false;
                            if (BottomDialogTouchEventInterceptor.this.bkgOldY == (float)impl.boxRoot.getUnsafePlace().top) {
                                if (impl.boxBkg.getY() > (float)impl.boxRoot.getUnsafePlace().top + impl.bkgEnterAimY + (float)DialogX.touchSlideTriggerThreshold) {
                                    impl.preDismiss();
                                } else if (impl.boxBkg.getY() != BottomDialogTouchEventInterceptor.this.bkgOldY) {
                                    ObjectAnimator enterAnim = ObjectAnimator.ofFloat((Object)impl.boxBkg, (String)"y", (float[])new float[]{impl.boxBkg.getY(), impl.bkgEnterAimY});
                                    enterAnim.setDuration(300L);
                                    enterAnim.start();
                                }
                            } else if (impl.boxBkg.getY() > BottomDialogTouchEventInterceptor.this.bkgOldY + (float)DialogX.touchSlideTriggerThreshold) {
                                impl.preDismiss();
                            } else if (impl.boxBkg.getY() != BottomDialogTouchEventInterceptor.this.bkgOldY) {
                                ObjectAnimator enterAnim = ObjectAnimator.ofFloat((Object)impl.boxBkg, (String)"y", (float[])new float[]{impl.boxBkg.getY(), impl.boxRoot.getUnsafePlace().top});
                                enterAnim.setDuration(300L);
                                enterAnim.start();
                            }
                            if (!(impl.scrollView instanceof ScrollController)) break;
                            impl.scrollView.lockScroll(false);
                        }
                    }
                    return false;
                }
            });
        } else {
            if (impl.scrollView instanceof ScrollController) {
                impl.scrollView.lockScroll(false);
            }
            interceptTouchView.setOnTouchListener(null);
        }
    }

    private boolean touchInScrollView(View slideView, ScrollController scrollView, MotionEvent event) {
        View scrollViewImpl = (View)scrollView;
        RectF scrollViewLocation = new RectF();
        int[] scrollViewScreenLoc = new int[2];
        int[] rootViewScreenLoc = new int[2];
        scrollViewImpl.getLocationInWindow(scrollViewScreenLoc);
        slideView.getLocationInWindow(rootViewScreenLoc);
        scrollViewLocation.left = scrollViewScreenLoc[0] - rootViewScreenLoc[0];
        scrollViewLocation.top = scrollViewScreenLoc[1] - rootViewScreenLoc[1];
        scrollViewLocation.right = scrollViewLocation.left + (float)scrollViewImpl.getWidth();
        scrollViewLocation.bottom = scrollViewLocation.top + (float)scrollViewImpl.getHeight();
        return event.getX() >= scrollViewLocation.left && event.getX() <= scrollViewLocation.right && event.getY() >= scrollViewLocation.top && event.getY() <= scrollViewLocation.bottom;
    }

    private int dip2px(float dpValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public boolean isOnlyRestrictingSlideTouchEventsToScrollLayoutAreas() {
        return this.onlyRestrictingSlideTouchEventsToScrollLayoutAreas;
    }

    public BottomDialogTouchEventInterceptor setOnlyRestrictingSlideTouchEventsToScrollLayoutAreas(boolean onlyRestrictingSlideTouchEventsToScrollLayoutAreas) {
        this.onlyRestrictingSlideTouchEventsToScrollLayoutAreas = onlyRestrictingSlideTouchEventsToScrollLayoutAreas;
        return this;
    }
}

