/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.impl;

import android.app.Activity;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.NoTouchInterface;
import java.lang.ref.WeakReference;

public class DialogFragmentImpl
extends DialogFragment {
    private View dialogView;
    private BaseDialog baseDialog;
    WeakReference<Activity> activityWeakReference = null;

    public DialogFragmentImpl() {
    }

    public DialogFragmentImpl(BaseDialog baseDialog, View dialogView) {
        this.dialogView = dialogView;
        this.baseDialog = baseDialog;
        this.activityWeakReference = new WeakReference<Activity>(baseDialog.getOwnActivity());
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return this.dialogView;
    }

    public void onStart() {
        super.onStart();
        final Activity activity = (Activity)this.activityWeakReference.get();
        if (this.getDialog() == null) {
            return;
        }
        Window dialogWindow = this.getDialog().getWindow();
        if (dialogWindow == null) {
            return;
        }
        dialogWindow.clearFlags(8);
        dialogWindow.setSoftInputMode(16);
        WindowManager.LayoutParams lp = dialogWindow.getAttributes();
        lp.width = -1;
        lp.height = -1;
        lp.dimAmount = 0.0f;
        lp.format = -2;
        this.dialogView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                for (BaseDialog dialog : BaseDialog.getRunningDialogList()) {
                    if (dialog.getOwnActivity() != activity || dialog == DialogFragmentImpl.this.baseDialog || dialog instanceof NoTouchInterface || dialog.getDialogView() == null) continue;
                    dialog.getDialogView().dispatchTouchEvent(event);
                    return true;
                }
                if (DialogFragmentImpl.this.baseDialog instanceof NoTouchInterface) {
                    return activity.dispatchTouchEvent(event);
                }
                return false;
            }
        });
        dialogWindow.setAttributes(lp);
        dialogWindow.addFlags(0x4000000);
        dialogWindow.getDecorView().setPadding(0, 0, 0, 0);
        if (Build.VERSION.SDK_INT >= 28) {
            lp.layoutInDisplayCutoutMode = 1;
        }
        dialogWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        if (Build.VERSION.SDK_INT >= 21) {
            int visibility = 1280;
            if (activity != null && (activity.getWindow().getDecorView().getSystemUiVisibility() & 0x2000) == 8192) {
                visibility |= 0x2000;
            }
            dialogWindow.getDecorView().setSystemUiVisibility(visibility);
            dialogWindow.addFlags(-2013265920);
            dialogWindow.setStatusBarColor(0);
            dialogWindow.setNavigationBarColor(0);
        } else {
            dialogWindow.addFlags(0x4000000);
        }
    }

    public void show(FragmentManager manager, @Nullable String tag) {
        if (manager == null) {
            DialogX.error("DialogX.DialogFragment \u6a21\u5f0f\u65e0\u6cd5\u652f\u6301\u975e AppCompatActivity \u542f\u52a8\u3002");
            return;
        }
        FragmentTransaction ft = manager.beginTransaction();
        ft.add((Fragment)this, tag);
        ft.commitAllowingStateLoss();
    }

    public void dismiss() {
        this.dismissAllowingStateLoss();
    }
}

