/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.dialogs;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Outline;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.BlurViewType;
import com.kongzue.dialogx.interfaces.DialogConvertViewInterface;
import com.kongzue.dialogx.interfaces.DialogLifecycleCallback;
import com.kongzue.dialogx.interfaces.DialogXAnimInterface;
import com.kongzue.dialogx.interfaces.DialogXRunnable;
import com.kongzue.dialogx.interfaces.DialogXStyle;
import com.kongzue.dialogx.interfaces.OnBackPressedListener;
import com.kongzue.dialogx.interfaces.OnBackgroundMaskClickListener;
import com.kongzue.dialogx.interfaces.OnBindView;
import com.kongzue.dialogx.interfaces.ProgressViewInterface;
import com.kongzue.dialogx.util.TextInfo;
import com.kongzue.dialogx.util.views.DialogXBaseRelativeLayout;
import com.kongzue.dialogx.util.views.MaxRelativeLayout;
import com.kongzue.dialogx.util.views.ProgressView;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class WaitDialog
extends BaseDialog {
    public static int overrideEnterDuration = -1;
    public static int overrideExitDuration = -1;
    public static int overrideEnterAnimRes = 0;
    public static int overrideExitAnimRes = 0;
    public static BaseDialog.BOOLEAN overrideCancelable;
    protected boolean bkgInterceptTouch = true;
    protected OnBindView<WaitDialog> onBindView;
    protected int customEnterAnimResId;
    protected int customExitAnimResId;
    protected float backgroundRadius = DialogX.defaultWaitAndTipDialogBackgroundRadius;
    protected DialogXAnimInterface<WaitDialog> dialogXAnimImpl;
    protected OnBackPressedListener<WaitDialog> onBackPressedListener;
    protected static WeakReference<WaitDialog> me;
    protected CharSequence message;
    protected long tipShowDuration = 1500L;
    protected float waitProgress = -1.0f;
    protected int showType = -1;
    protected TextInfo messageTextInfo;
    protected Integer maskColor = null;
    protected BaseDialog.BOOLEAN privateCancelable;
    protected DialogLifecycleCallback<WaitDialog> dialogLifecycleCallback;
    protected OnBackgroundMaskClickListener<WaitDialog> onBackgroundMaskClickListener;
    private WeakReference<View> dialogView;
    protected WeakReference<DialogImpl> dialogImpl;
    protected static Timer delayDismissTimer;
    protected TYPE readyTipType;

    protected WaitDialog() {
        this.cancelable = DialogX.cancelableTipDialog;
    }

    protected static WaitDialog instanceBuild() {
        me = new WeakReference<WaitDialog>(new WaitDialog());
        return (WaitDialog)me.get();
    }

    public static WaitDialog build() {
        return new WaitDialog();
    }

    public static WaitDialog show(CharSequence message) {
        boolean noInstance = WaitDialog.noInstance();
        if (noInstance) {
            WaitDialog.instanceBuild();
        }
        WaitDialog.me().setTip(message, TYPE.NONE);
        WaitDialog.showWithInstance(noInstance);
        return WaitDialog.me();
    }

    public static WaitDialog show(Activity activity, CharSequence message) {
        boolean noInstance = WaitDialog.noInstance(activity);
        if (noInstance) {
            WaitDialog.instanceBuild();
        }
        WaitDialog instance = WaitDialog.getInstanceNotNull(activity);
        instance.setTip(message, TYPE.NONE);
        if (noInstance) {
            WaitDialog.showWithInstance(instance, activity);
        }
        return instance;
    }

    public static WaitDialog show(int messageResId) {
        boolean noInstance = WaitDialog.noInstance();
        if (noInstance) {
            WaitDialog.instanceBuild();
        }
        WaitDialog.me().setTip(messageResId, TYPE.NONE);
        WaitDialog.showWithInstance(noInstance);
        return WaitDialog.me();
    }

    public static WaitDialog show(Activity activity, int messageResId) {
        boolean noInstance = WaitDialog.noInstance(activity);
        if (noInstance) {
            WaitDialog.instanceBuild();
        }
        WaitDialog instance = WaitDialog.getInstanceNotNull(activity);
        instance.setTip(messageResId, TYPE.PROGRESSING);
        if (noInstance) {
            WaitDialog.showWithInstance(instance, activity);
        }
        return instance;
    }

    public static WaitDialog show(CharSequence message, float progress) {
        boolean noInstance = WaitDialog.noInstance();
        if (noInstance) {
            WaitDialog.instanceBuild();
        }
        WaitDialog.me().setTip(message, TYPE.PROGRESSING);
        WaitDialog.me().setProgress(progress);
        WaitDialog.showWithInstance(noInstance);
        return WaitDialog.me();
    }

    public static WaitDialog show(Activity activity, CharSequence message, float progress) {
        boolean noInstance = WaitDialog.noInstance(activity);
        if (noInstance) {
            WaitDialog.instanceBuild();
        }
        WaitDialog instance = WaitDialog.getInstanceNotNull(activity);
        instance.setTip(message, TYPE.PROGRESSING);
        instance.setProgress(progress);
        if (noInstance) {
            WaitDialog.showWithInstance(instance, activity);
        }
        return instance;
    }

    public static WaitDialog show(int messageResId, float progress) {
        boolean noInstance = WaitDialog.noInstance();
        if (noInstance) {
            WaitDialog.instanceBuild();
        }
        WaitDialog.me().setTip(messageResId, TYPE.PROGRESSING);
        WaitDialog.me().setProgress(progress);
        WaitDialog.showWithInstance(noInstance);
        return WaitDialog.me();
    }

    public static WaitDialog show(Activity activity, int messageResId, float progress) {
        boolean noInstance = WaitDialog.noInstance(activity);
        if (noInstance) {
            WaitDialog.instanceBuild();
        }
        WaitDialog instance = WaitDialog.getInstanceNotNull(activity);
        instance.setTip(messageResId, TYPE.PROGRESSING);
        instance.setProgress(progress);
        if (noInstance) {
            WaitDialog.showWithInstance(instance, activity);
        }
        return instance;
    }

    public static WaitDialog show(Activity activity, float progress) {
        boolean noInstance = WaitDialog.noInstance(activity);
        if (noInstance) {
            WaitDialog.instanceBuild();
        }
        WaitDialog instance = WaitDialog.getInstanceNotNull(activity);
        instance.setTip(TYPE.PROGRESSING);
        instance.setProgress(progress);
        if (noInstance) {
            WaitDialog.showWithInstance(instance, activity);
        }
        return instance;
    }

    public static WaitDialog show(float progress) {
        boolean noInstance = WaitDialog.noInstance();
        if (noInstance) {
            WaitDialog.instanceBuild();
        }
        WaitDialog.me().setTip(TYPE.PROGRESSING);
        WaitDialog.me().setProgress(progress);
        WaitDialog.showWithInstance(noInstance);
        return WaitDialog.me();
    }

    public float getProgress() {
        return this.waitProgress;
    }

    public WaitDialog setProgress(float waitProgress) {
        this.waitProgress = waitProgress;
        this.refreshUI();
        return this;
    }

    protected View getWaitDialogView() {
        if (this.dialogView == null) {
            return null;
        }
        return (View)this.dialogView.get();
    }

    protected void setWaitDialogView(View v) {
        this.dialogView = new WeakReference<View>(v);
        this.setDialogView(v);
    }

    public WaitDialog show() {
        super.beforeShow();
        WaitDialog.runOnMain(new Runnable(){

            @Override
            public void run() {
                int layoutResId = R.layout.layout_dialogx_wait;
                if (WaitDialog.this.style.overrideWaitTipRes() != null && WaitDialog.this.style.overrideWaitTipRes().overrideWaitLayout(WaitDialog.this.isLightTheme()) != 0) {
                    layoutResId = WaitDialog.this.style.overrideWaitTipRes().overrideWaitLayout(WaitDialog.this.isLightTheme());
                }
                WaitDialog.this.dialogImpl = new WeakReference<DialogImpl>(new DialogImpl(layoutResId));
                if (WaitDialog.this.getDialogImpl() != null) {
                    WaitDialog.this.getDialogImpl().lazyCreate();
                    if (WaitDialog.this.getWaitDialogView() != null) {
                        WaitDialog.this.getWaitDialogView().setTag((Object)WaitDialog.this);
                        WaitDialog.show(WaitDialog.this.getWaitDialogView());
                    }
                }
            }
        });
        return this;
    }

    public WaitDialog show(final Activity activity) {
        super.beforeShow();
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                int layoutResId = R.layout.layout_dialogx_wait;
                if (WaitDialog.this.style.overrideWaitTipRes() != null && WaitDialog.this.style.overrideWaitTipRes().overrideWaitLayout(WaitDialog.this.isLightTheme()) != 0) {
                    layoutResId = WaitDialog.this.style.overrideWaitTipRes().overrideWaitLayout(WaitDialog.this.isLightTheme());
                }
                WaitDialog.this.dialogImpl = new WeakReference<DialogImpl>(new DialogImpl(layoutResId));
                if (WaitDialog.this.getDialogImpl() != null) {
                    WaitDialog.this.getDialogImpl().lazyCreate();
                    if (WaitDialog.this.getWaitDialogView() != null) {
                        WaitDialog.this.getWaitDialogView().setTag((Object)WaitDialog.this);
                        WaitDialog.show(activity, WaitDialog.this.getWaitDialogView());
                    }
                }
            }
        });
        return this;
    }

    public void cleanInstance() {
        this.isShow = false;
        this.getDialogLifecycleCallback().onDismiss(this);
        if (this.dialogImpl != null) {
            this.dialogImpl.clear();
        }
        this.dialogImpl = null;
        if (this.dialogView != null) {
            this.dialogView.clear();
        }
        this.dialogView = null;
        this.dialogLifecycleCallback = null;
        if (me != null) {
            me.clear();
        }
        me = null;
        this.setLifecycleState(Lifecycle.State.DESTROYED);
        System.gc();
    }

    private void setDialogImpl(DialogImpl d) {
        if (this.dialogImpl != null && this.dialogImpl.get() != d) {
            this.dialogImpl = new WeakReference<DialogImpl>(d);
        }
    }

    @Override
    public String dialogKey() {
        return this.getClass().getSimpleName() + "(" + Integer.toHexString(this.hashCode()) + ")";
    }

    @Override
    public boolean isLightTheme() {
        if (DialogX.tipTheme == null) {
            return super.isLightTheme();
        }
        return DialogX.tipTheme == DialogX.THEME.LIGHT;
    }

    @Override
    public void refreshUI() {
        if (this.getDialogImpl() == null) {
            return;
        }
        WaitDialog.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (WaitDialog.this.getDialogImpl() != null) {
                    WaitDialog.this.getDialogImpl().refreshView();
                }
            }
        });
    }

    public void doDismiss() {
        this.isShow = false;
        WaitDialog.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (WaitDialog.this.getDialogImpl() != null) {
                    WaitDialog.this.getDialogImpl().doDismiss(null);
                }
            }
        });
    }

    public static void dismiss() {
        WaitDialog.me().doDismiss();
    }

    public static void dismiss(Activity activity) {
        WaitDialog instance = WaitDialog.getInstance(activity);
        if (instance != null) {
            instance.doDismiss();
        }
    }

    public static void dismiss(long delayTime) {
        if (delayDismissTimer != null) {
            delayDismissTimer.cancel();
        }
        delayDismissTimer = new Timer();
        delayDismissTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                WaitDialog.dismiss();
            }
        }, delayTime);
    }

    protected static WaitDialog me() {
        for (BaseDialog baseDialog : WaitDialog.getRunningDialogList()) {
            if (!(baseDialog instanceof WaitDialog) || !baseDialog.isShow() || baseDialog.getOwnActivity() != WaitDialog.getTopActivity()) continue;
            return (WaitDialog)baseDialog;
        }
        if (me == null || me.get() == null) {
            return WaitDialog.instanceBuild();
        }
        return (WaitDialog)me.get();
    }

    protected void showTip(CharSequence message, TYPE type) {
        this.showType = type.ordinal();
        this.message = message;
        this.readyTipType = type;
        this.show();
    }

    protected void showTip(Activity activity, CharSequence message, TYPE type) {
        this.showType = type.ordinal();
        this.message = message;
        this.readyTipType = type;
        this.show(activity);
    }

    protected void showTip(int messageResId, TYPE type) {
        this.showType = type.ordinal();
        this.message = this.getString(messageResId);
        this.readyTipType = type;
        this.show();
    }

    protected void showTip(Activity activity, int messageResId, TYPE type) {
        this.showType = type.ordinal();
        this.message = this.getString(messageResId);
        this.readyTipType = type;
        this.show(activity);
    }

    protected void showTip(TYPE type) {
        if (this.readyTipType == type) {
            return;
        }
        this.showType = type.ordinal();
        this.readyTipType = type;
        if (this.getDialogImpl() != null) {
            this.getDialogImpl().showTip(type);
        }
    }

    protected void setTip(TYPE type) {
        this.showTip(type);
    }

    protected void setTip(CharSequence message, TYPE type) {
        this.message = message;
        this.showTip(type);
        this.refreshUI();
    }

    protected void setTip(int messageResId, TYPE type) {
        this.message = this.getString(messageResId);
        this.showTip(type);
        this.refreshUI();
    }

    protected void setTipShowDuration(long tipShowDuration) {
        this.tipShowDuration = tipShowDuration;
        this.showTip(this.readyTipType);
    }

    public static CharSequence getMessage() {
        return WaitDialog.me().message;
    }

    public static WaitDialog setMessage(CharSequence message) {
        WaitDialog.me().preMessage(message);
        WaitDialog.me().refreshUI();
        return WaitDialog.me();
    }

    public static WaitDialog setMessage(int messageResId) {
        WaitDialog.me().preMessage(messageResId);
        WaitDialog.me().refreshUI();
        return WaitDialog.me();
    }

    @Override
    public boolean isCancelable() {
        if (this.privateCancelable != null) {
            return this.privateCancelable == BaseDialog.BOOLEAN.TRUE;
        }
        if (overrideCancelable != null) {
            return overrideCancelable == BaseDialog.BOOLEAN.TRUE;
        }
        return DialogX.cancelableTipDialog;
    }

    public WaitDialog setCancelable(boolean cancelable) {
        this.privateCancelable = cancelable ? BaseDialog.BOOLEAN.TRUE : BaseDialog.BOOLEAN.FALSE;
        this.refreshUI();
        return this;
    }

    protected WaitDialog preMessage(CharSequence message) {
        this.message = message;
        return this;
    }

    protected WaitDialog preMessage(int messageResId) {
        this.message = this.getString(messageResId);
        return this;
    }

    public DialogLifecycleCallback<WaitDialog> getDialogLifecycleCallback() {
        return this.dialogLifecycleCallback == null ? new DialogLifecycleCallback<WaitDialog>(){} : this.dialogLifecycleCallback;
    }

    public WaitDialog setDialogLifecycleCallback(DialogLifecycleCallback<WaitDialog> dialogLifecycleCallback) {
        this.dialogLifecycleCallback = dialogLifecycleCallback;
        if (this.isShow) {
            dialogLifecycleCallback.onShow(WaitDialog.me());
        }
        return this;
    }

    public DialogImpl getDialogImpl() {
        if (this.dialogImpl == null) {
            return null;
        }
        return (DialogImpl)this.dialogImpl.get();
    }

    public WaitDialog setCustomView(OnBindView<WaitDialog> onBindView) {
        this.onBindView = onBindView;
        this.refreshUI();
        return this;
    }

    public View getCustomView() {
        if (this.onBindView == null) {
            return null;
        }
        return this.onBindView.getCustomView();
    }

    public WaitDialog removeCustomView() {
        this.onBindView.clean();
        this.refreshUI();
        return this;
    }

    public OnBackPressedListener<WaitDialog> getOnBackPressedListener() {
        return this.onBackPressedListener;
    }

    public WaitDialog setOnBackPressedListener(OnBackPressedListener<WaitDialog> onBackPressedListener) {
        this.onBackPressedListener = onBackPressedListener;
        this.refreshUI();
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public WaitDialog setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.refreshUI();
        return this;
    }

    public WaitDialog setBackgroundColorRes(@ColorRes int backgroundColorResId) {
        this.backgroundColor = this.getColor(backgroundColorResId);
        this.refreshUI();
        return this;
    }

    public WaitDialog setMaskColor(@ColorInt int maskColor) {
        this.maskColor = maskColor;
        this.refreshUI();
        return this;
    }

    public WaitDialog setEnterAnimDuration(long enterAnimDuration) {
        this.enterAnimDuration = enterAnimDuration;
        return this;
    }

    public long getExitAnimDuration() {
        return this.exitAnimDuration;
    }

    public WaitDialog setExitAnimDuration(long exitAnimDuration) {
        this.exitAnimDuration = exitAnimDuration;
        return this;
    }

    @Override
    public void restartDialog() {
        this.refreshUI();
    }

    public static WaitDialog getInstance() {
        return WaitDialog.me();
    }

    public static int getType() {
        return WaitDialog.me().showType;
    }

    public WaitDialog setAnimResId(int enterResId, int exitResId) {
        this.customEnterAnimResId = enterResId;
        this.customExitAnimResId = exitResId;
        return this;
    }

    public WaitDialog setEnterAnimResId(int enterResId) {
        this.customEnterAnimResId = enterResId;
        return this;
    }

    public WaitDialog setExitAnimResId(int exitResId) {
        this.customExitAnimResId = exitResId;
        return this;
    }

    protected static boolean noInstance() {
        if (WaitDialog.getTopActivity() != null && WaitDialog.getInstance(WaitDialog.getTopActivity()) != null) {
            return false;
        }
        return me == null || me.get() == null || ((WaitDialog)me.get()).getOwnActivity() == null || ((WaitDialog)me.get()).getOwnActivity() != WaitDialog.getTopActivity() || !((WaitDialog)WaitDialog.me.get()).isShow;
    }

    protected static boolean noInstance(Activity activity) {
        if (WaitDialog.getTopActivity() != null && WaitDialog.getInstance(activity) != null) {
            return false;
        }
        return me == null || me.get() == null || ((WaitDialog)me.get()).getOwnActivity() == null || ((WaitDialog)me.get()).getOwnActivity() != activity || !((WaitDialog)WaitDialog.me.get()).isShow;
    }

    public static WaitDialog getInstanceNotNull(Activity activity) {
        for (BaseDialog baseDialog : WaitDialog.getRunningDialogList()) {
            if (!(baseDialog instanceof WaitDialog) || !baseDialog.isShow() || baseDialog.getOwnActivity() != activity) continue;
            return (WaitDialog)baseDialog;
        }
        return WaitDialog.instanceBuild();
    }

    public static WaitDialog getInstance(Activity activity) {
        for (BaseDialog baseDialog : WaitDialog.getRunningDialogList()) {
            if (!(baseDialog instanceof WaitDialog) || !baseDialog.isShow() || baseDialog.getOwnActivity() != activity) continue;
            return (WaitDialog)baseDialog;
        }
        return null;
    }

    protected static void showWithInstance(boolean noInstance) {
        if (delayDismissTimer != null) {
            delayDismissTimer.cancel();
        }
        if (noInstance) {
            WaitDialog.me().show();
        } else {
            WaitDialog.me().refreshUI();
        }
    }

    protected static void showWithInstance(WaitDialog instance, Activity activity) {
        if (delayDismissTimer != null) {
            delayDismissTimer.cancel();
        }
        if (activity == null) {
            instance.show();
        } else {
            instance.show(activity);
        }
    }

    @Override
    protected void shutdown() {
        WaitDialog.dismiss();
    }

    public WaitDialog setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.refreshUI();
        return this;
    }

    public WaitDialog setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        this.refreshUI();
        return this;
    }

    public WaitDialog setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        this.refreshUI();
        return this;
    }

    public WaitDialog setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        this.refreshUI();
        return this;
    }

    public WaitDialog setDialogImplMode(DialogX.IMPL_MODE dialogImplMode) {
        this.dialogImplMode = dialogImplMode;
        return this;
    }

    public boolean isBkgInterceptTouch() {
        return this.bkgInterceptTouch;
    }

    public WaitDialog setBkgInterceptTouch(boolean bkgInterceptTouch) {
        this.bkgInterceptTouch = bkgInterceptTouch;
        return this;
    }

    public OnBackgroundMaskClickListener<WaitDialog> getOnBackgroundMaskClickListener() {
        return this.onBackgroundMaskClickListener;
    }

    public WaitDialog setOnBackgroundMaskClickListener(OnBackgroundMaskClickListener<WaitDialog> onBackgroundMaskClickListener) {
        this.onBackgroundMaskClickListener = onBackgroundMaskClickListener;
        return this;
    }

    public WaitDialog setStyle(DialogXStyle style2) {
        this.style = style2;
        return this;
    }

    public WaitDialog setTheme(DialogX.THEME theme) {
        this.theme = theme;
        return this;
    }

    public TextInfo getMessageTextInfo() {
        return this.messageTextInfo;
    }

    public WaitDialog setMessageTextInfo(TextInfo messageTextInfo) {
        this.messageTextInfo = messageTextInfo;
        this.refreshUI();
        return this;
    }

    public WaitDialog setMessageContent(CharSequence message) {
        this.message = message;
        this.refreshUI();
        return this;
    }

    public WaitDialog setMessageContent(int messageResId) {
        this.message = this.getString(messageResId);
        this.refreshUI();
        return this;
    }

    public CharSequence getMessageContent() {
        return this.message;
    }

    public WaitDialog setTipType(TYPE type) {
        this.showTip(type);
        return this;
    }

    public WaitDialog setRadius(float radiusPx) {
        this.backgroundRadius = radiusPx;
        this.refreshUI();
        return this;
    }

    public float getRadius() {
        return this.backgroundRadius < 0.0f ? (float)this.dip2px(15.0f) : this.backgroundRadius;
    }

    public DialogXAnimInterface<WaitDialog> getDialogXAnimImpl() {
        return this.dialogXAnimImpl;
    }

    public WaitDialog setDialogXAnimImpl(DialogXAnimInterface<WaitDialog> dialogXAnimImpl) {
        this.dialogXAnimImpl = dialogXAnimImpl;
        return this;
    }

    public WaitDialog setRootPadding(int padding) {
        this.screenPaddings = new int[]{padding, padding, padding, padding};
        this.refreshUI();
        return this;
    }

    public WaitDialog setRootPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.screenPaddings = new int[]{paddingLeft, paddingTop, paddingRight, paddingBottom};
        this.refreshUI();
        return this;
    }

    public WaitDialog onShow(DialogXRunnable<WaitDialog> dialogXRunnable) {
        this.onShowRunnable = dialogXRunnable;
        if (this.isShow() && this.onShowRunnable != null) {
            this.onShowRunnable.run(this);
        }
        return this;
    }

    public WaitDialog onDismiss(DialogXRunnable<WaitDialog> dialogXRunnable) {
        this.onDismissRunnable = dialogXRunnable;
        return this;
    }

    @Override
    public WaitDialog setData(String key, Object obj) {
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.data.put(key, obj);
        return this;
    }

    @Override
    public WaitDialog setEnableImmersiveMode(boolean enableImmersiveMode) {
        this.enableImmersiveMode = enableImmersiveMode;
        this.refreshUI();
        return this;
    }

    public WaitDialog appendMessage(CharSequence message) {
        this.message = TextUtils.concat((CharSequence[])new CharSequence[]{this.message, message});
        this.refreshUI();
        return this;
    }

    @Override
    public WaitDialog setThisOrderIndex(int orderIndex) {
        this.thisOrderIndex = orderIndex;
        if (this.getDialogView() != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.getDialogView().setTranslationZ((float)orderIndex);
            } else {
                WaitDialog.error("DialogX: " + this.dialogKey() + " \u6267\u884c .setThisOrderIndex(" + orderIndex + ") \u5931\u8d25\uff1a\u7cfb\u7edf\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0cSDK-API \u7248\u672c\u5fc5\u987b\u5927\u4e8e 21\uff08LOLLIPOP\uff09");
            }
        }
        return this;
    }

    public WaitDialog bringToFront() {
        this.setThisOrderIndex(this.getHighestOrderIndex());
        return this;
    }

    public class DialogImpl
    implements DialogConvertViewInterface {
        private List<View> blurViews;
        public DialogXBaseRelativeLayout boxRoot;
        public MaxRelativeLayout bkg;
        public RelativeLayout boxProgress;
        public ProgressViewInterface progressView;
        public RelativeLayout boxCustomView;
        public TextView txtInfo;
        private int layoutResId;
        private float oldProgress;

        public DialogImpl(int layoutResId) {
            this.layoutResId = layoutResId;
        }

        public void lazyCreate() {
            View dialogView = WaitDialog.this.createView(this.layoutResId);
            if (dialogView == null) {
                return;
            }
            WaitDialog.this.setWaitDialogView(dialogView);
            this.boxRoot = (DialogXBaseRelativeLayout)dialogView.findViewById(R.id.box_root);
            this.bkg = (MaxRelativeLayout)dialogView.findViewById(R.id.bkg);
            this.boxProgress = (RelativeLayout)dialogView.findViewById(R.id.box_progress);
            View progressViewCache = (View)WaitDialog.this.style.overrideWaitTipRes().overrideWaitView((Context)WaitDialog.this.getOwnActivity(), WaitDialog.this.isLightTheme());
            if (progressViewCache == null) {
                progressViewCache = new ProgressView((Context)WaitDialog.this.getOwnActivity());
            }
            this.progressView = (ProgressViewInterface)progressViewCache;
            this.boxProgress.addView(progressViewCache, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
            this.boxCustomView = (RelativeLayout)dialogView.findViewById(R.id.box_customView);
            this.txtInfo = (TextView)dialogView.findViewById(R.id.txt_info);
            this.blurViews = WaitDialog.this.findAllBlurView(dialogView);
            this.init();
            WaitDialog.this.setDialogImpl(this);
            this.refreshView();
        }

        public DialogImpl(View convertView) {
            if (convertView == null) {
                return;
            }
            WaitDialog.this.setDialogView(convertView);
            this.boxRoot = (DialogXBaseRelativeLayout)convertView.findViewById(R.id.box_root);
            this.bkg = (MaxRelativeLayout)convertView.findViewById(R.id.bkg);
            this.boxProgress = (RelativeLayout)convertView.findViewById(R.id.box_progress);
            View progressViewCache = (View)WaitDialog.this.style.overrideWaitTipRes().overrideWaitView((Context)WaitDialog.this.getOwnActivity(), WaitDialog.this.isLightTheme());
            if (progressViewCache == null) {
                progressViewCache = new ProgressView((Context)WaitDialog.this.getOwnActivity());
            }
            this.progressView = (ProgressViewInterface)progressViewCache;
            this.boxProgress.addView(progressViewCache, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
            this.boxCustomView = (RelativeLayout)convertView.findViewById(R.id.box_customView);
            this.txtInfo = (TextView)convertView.findViewById(R.id.txt_info);
            this.init();
            WaitDialog.this.setDialogImpl(this);
            this.refreshView();
        }

        @Override
        public void init() {
            if (Build.VERSION.SDK_INT >= 21 && WaitDialog.this.getDialogView() != null) {
                WaitDialog.this.getDialogView().setTranslationZ((float)WaitDialog.this.getThisOrderIndex());
            }
            if (WaitDialog.this.messageTextInfo == null) {
                WaitDialog.this.messageTextInfo = DialogX.tipTextInfo;
            }
            if (WaitDialog.this.backgroundColor == null) {
                WaitDialog.this.backgroundColor = DialogX.tipBackgroundColor;
            }
            this.blurViews = WaitDialog.this.findAllBlurView((View)WaitDialog.this.dialogView.get());
            Integer blurFrontColor = WaitDialog.this.getColor(WaitDialog.this.isLightTheme() ? R.color.dialogxWaitBkgDark : R.color.dialogxWaitBkgLight);
            Float dialogXRadius = Float.valueOf(WaitDialog.this.dip2px(15.0f));
            if (WaitDialog.this.style.overrideWaitTipRes() != null) {
                dialogXRadius = WaitDialog.this.getFloatStyleAttr(Float.valueOf(WaitDialog.this.style.overrideWaitTipRes().overrideRadiusPx()), dialogXRadius);
                blurFrontColor = WaitDialog.this.getColorNullable(WaitDialog.this.getIntStyleAttr(WaitDialog.this.style.overrideWaitTipRes().overrideBackgroundColorRes(WaitDialog.this.isLightTheme()), WaitDialog.this.isLightTheme() ? R.color.dialogxWaitBkgDark : R.color.dialogxWaitBkgLight), blurFrontColor);
            }
            if (this.blurViews != null) {
                for (View blurView : this.blurViews) {
                    ((BlurViewType)blurView).setOverlayColor(WaitDialog.this.backgroundColor == null ? blurFrontColor : WaitDialog.this.backgroundColor);
                    ((BlurViewType)blurView).setRadiusPx(dialogXRadius);
                }
            } else {
                GradientDrawable gradientDrawable = (GradientDrawable)WaitDialog.this.getResources().getDrawable(R.drawable.rect_dialogx_material_wait_bkg);
                gradientDrawable.setColor(blurFrontColor.intValue());
                gradientDrawable.setCornerRadius(dialogXRadius.floatValue());
                this.bkg.setBackground((Drawable)gradientDrawable);
            }
            this.boxRoot.setClickable(true);
            this.boxRoot.setParentDialog(WaitDialog.me());
            this.boxRoot.setOnLifecycleCallBack(new DialogXBaseRelativeLayout.OnLifecycleCallBack(){

                @Override
                public void onShow() {
                    WaitDialog.this.isShow = true;
                    WaitDialog.this.preShow = false;
                    WaitDialog.this.setLifecycleState(Lifecycle.State.CREATED);
                    DialogImpl.this.boxRoot.setAlpha(0.0f);
                    DialogImpl.this.bkg.post(new Runnable(){

                        @Override
                        public void run() {
                            if (WaitDialog.this.getOwnActivity() == null) {
                                return;
                            }
                            DialogImpl.this.getDialogXAnimImpl().doShowAnim(WaitDialog.this, (ViewGroup)DialogImpl.this.bkg);
                            WaitDialog.this.onDialogShow();
                            WaitDialog.this.getDialogLifecycleCallback().onShow(WaitDialog.this);
                            WaitDialog.this.setLifecycleState(Lifecycle.State.RESUMED);
                        }
                    });
                }

                @Override
                public void onDismiss() {
                    WaitDialog.this.cleanInstance();
                }
            });
            if (WaitDialog.this.readyTipType != null && WaitDialog.this.readyTipType != TYPE.NONE) {
                this.progressView.noLoading();
                ((View)this.progressView).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        DialogImpl.this.showTip(WaitDialog.this.readyTipType);
                    }
                }, 100L);
            }
            this.boxRoot.setOnBackPressedListener(new DialogXBaseRelativeLayout.PrivateBackPressedListener(){

                @Override
                public boolean onBackPressed() {
                    if (WaitDialog.this.onBackPressedListener != null) {
                        if (WaitDialog.this.onBackPressedListener.onBackPressed(WaitDialog.this)) {
                            WaitDialog.dismiss();
                        }
                    } else if (WaitDialog.this.isCancelable()) {
                        WaitDialog.dismiss();
                    }
                    return true;
                }
            });
            WaitDialog.this.onDialogInit();
        }

        @Override
        public void refreshView() {
            int overrideTextColorRes;
            if (this.boxRoot == null || WaitDialog.this.getOwnActivity() == null) {
                return;
            }
            this.boxRoot.setAutoUnsafePlacePadding(WaitDialog.this.isEnableImmersiveMode());
            this.boxRoot.setRootPadding(WaitDialog.this.screenPaddings[0], WaitDialog.this.screenPaddings[1], WaitDialog.this.screenPaddings[2], WaitDialog.this.screenPaddings[3]);
            this.bkg.setMaxWidth(WaitDialog.this.getMaxWidth());
            this.bkg.setMaxHeight(WaitDialog.this.getMaxHeight());
            this.bkg.setMinWidth(WaitDialog.this.getMinWidth());
            this.bkg.setMinHeight(WaitDialog.this.getMinHeight());
            if (WaitDialog.this.backgroundColor != null) {
                if (this.blurViews != null) {
                    for (View blurView : this.blurViews) {
                        ((BlurViewType)blurView).setOverlayColor(WaitDialog.this.backgroundColor);
                    }
                } else {
                    GradientDrawable gradientDrawable = (GradientDrawable)WaitDialog.this.getResources().getDrawable(R.drawable.rect_dialogx_material_wait_bkg);
                    gradientDrawable.setColor(WaitDialog.this.getBackgroundColor());
                    gradientDrawable.setCornerRadius(WaitDialog.this.getRadius());
                    this.bkg.setBackground((Drawable)gradientDrawable);
                }
            }
            if (WaitDialog.this.style.overrideWaitTipRes() != null) {
                overrideTextColorRes = WaitDialog.this.getIntStyleAttr(WaitDialog.this.style.overrideWaitTipRes().overrideTextColorRes(WaitDialog.this.isLightTheme()), WaitDialog.this.isLightTheme() ? R.color.white : R.color.black);
                this.txtInfo.setTextColor(WaitDialog.this.getResources().getColor(overrideTextColorRes));
                this.progressView.setColor(WaitDialog.this.getResources().getColor(overrideTextColorRes));
            } else {
                overrideTextColorRes = WaitDialog.this.isLightTheme() ? R.color.white : R.color.black;
                this.txtInfo.setTextColor(WaitDialog.this.getResources().getColor(overrideTextColorRes));
                this.progressView.setColor(WaitDialog.this.getResources().getColor(overrideTextColorRes));
            }
            if (DialogX.tipProgressColor != null) {
                this.progressView.setColor(DialogX.tipProgressColor.intValue());
            }
            if (WaitDialog.this.waitProgress >= 0.0f && WaitDialog.this.waitProgress <= 1.0f && this.oldProgress != WaitDialog.this.waitProgress) {
                this.progressView.progress(WaitDialog.this.waitProgress);
                this.oldProgress = WaitDialog.this.waitProgress;
            }
            if (WaitDialog.this.backgroundRadius > -1.0f) {
                if (Build.VERSION.SDK_INT >= 21) {
                    this.bkg.setOutlineProvider(new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), WaitDialog.this.backgroundRadius);
                        }
                    });
                    this.bkg.setClipToOutline(true);
                }
                if (this.blurViews != null) {
                    for (View blurView : this.blurViews) {
                        ((BlurViewType)blurView).setRadiusPx(Float.valueOf(WaitDialog.this.backgroundRadius));
                    }
                }
            }
            WaitDialog.this.showText(this.txtInfo, WaitDialog.this.message);
            BaseDialog.useTextInfo(this.txtInfo, WaitDialog.this.messageTextInfo);
            if (WaitDialog.this.maskColor != null) {
                this.boxRoot.setBackgroundColor(WaitDialog.this.maskColor);
            }
            if (WaitDialog.this.onBindView != null && WaitDialog.this.onBindView.getCustomView() != null) {
                WaitDialog.this.onBindView.bindParent((ViewGroup)this.boxCustomView, WaitDialog.this);
                this.boxCustomView.setVisibility(0);
                this.boxProgress.setVisibility(8);
            } else {
                this.boxCustomView.setVisibility(8);
                this.boxProgress.setVisibility(0);
            }
            if (WaitDialog.this.bkgInterceptTouch) {
                if (WaitDialog.this.isCancelable()) {
                    this.boxRoot.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (WaitDialog.this.onBackgroundMaskClickListener == null || !WaitDialog.this.onBackgroundMaskClickListener.onClick(WaitDialog.this, v)) {
                                DialogImpl.this.doDismiss(v);
                            }
                        }
                    });
                } else {
                    this.boxRoot.setOnClickListener(null);
                }
            } else {
                this.boxRoot.setClickable(false);
            }
            WaitDialog.this.onDialogRefreshUI();
        }

        @Override
        public void doDismiss(final View v) {
            if (WaitDialog.this.preDismiss(WaitDialog.this)) {
                return;
            }
            if (this.boxRoot == null) {
                return;
            }
            if (WaitDialog.this.getOwnActivity() == null) {
                return;
            }
            if (!WaitDialog.this.dismissAnimFlag && this.boxRoot != null) {
                WaitDialog.this.dismissAnimFlag = true;
                this.boxRoot.post(new Runnable(){

                    @Override
                    public void run() {
                        if (v != null) {
                            v.setEnabled(false);
                        }
                        DialogImpl.this.getDialogXAnimImpl().doExitAnim(WaitDialog.this, (ViewGroup)DialogImpl.this.bkg);
                        WaitDialog.runOnMainDelay(new Runnable(){

                            @Override
                            public void run() {
                                if (DialogImpl.this.boxRoot != null) {
                                    DialogImpl.this.boxRoot.setVisibility(8);
                                }
                                WaitDialog.dismiss(WaitDialog.this.getWaitDialogView());
                            }
                        }, DialogImpl.this.getExitAnimationDuration(null));
                    }
                });
            }
        }

        protected DialogXAnimInterface<WaitDialog> getDialogXAnimImpl() {
            if (WaitDialog.this.dialogXAnimImpl == null) {
                WaitDialog.this.dialogXAnimImpl = new DialogXAnimInterface<WaitDialog>(){

                    @Override
                    public void doShowAnim(WaitDialog dialog, ViewGroup dialogBodyView) {
                        int enterAnimResId = R.anim.anim_dialogx_default_enter;
                        if (overrideEnterAnimRes != 0) {
                            enterAnimResId = overrideEnterAnimRes;
                        }
                        if (WaitDialog.this.customEnterAnimResId != 0) {
                            enterAnimResId = WaitDialog.this.customEnterAnimResId;
                        }
                        Animation enterAnim = AnimationUtils.loadAnimation((Context)WaitDialog.this.getOwnActivity(), (int)enterAnimResId);
                        long enterAnimDurationTemp = DialogImpl.this.getEnterAnimationDuration(enterAnim);
                        enterAnim.setInterpolator((Interpolator)new DecelerateInterpolator());
                        enterAnim.setDuration(enterAnimDurationTemp);
                        DialogImpl.this.bkg.startAnimation(enterAnim);
                        ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                        bkgAlpha.setDuration(enterAnimDurationTemp);
                        bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                DialogImpl.this.boxRoot.setBkgAlpha(((Float)animation.getAnimatedValue()).floatValue());
                            }
                        });
                        bkgAlpha.start();
                        DialogImpl.this.boxRoot.animate().setDuration(enterAnimDurationTemp).alpha(1.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setListener(null);
                    }

                    @Override
                    public void doExitAnim(WaitDialog dialog, ViewGroup dialogBodyView) {
                        Activity context = WaitDialog.this.getOwnActivity();
                        if (context == null) {
                            context = DialogImpl.this.boxRoot.getContext();
                        }
                        if (context == null) {
                            return;
                        }
                        int exitAnimResId = R.anim.anim_dialogx_default_exit;
                        if (overrideExitAnimRes != 0) {
                            exitAnimResId = overrideExitAnimRes;
                        }
                        if (WaitDialog.this.customExitAnimResId != 0) {
                            exitAnimResId = WaitDialog.this.customExitAnimResId;
                        }
                        Animation exitAnim = AnimationUtils.loadAnimation((Context)context, (int)exitAnimResId);
                        long exitAnimDurationTemp = DialogImpl.this.getExitAnimationDuration(exitAnim);
                        exitAnim.setDuration(exitAnimDurationTemp);
                        exitAnim.setInterpolator((Interpolator)new AccelerateInterpolator());
                        DialogImpl.this.bkg.startAnimation(exitAnim);
                        DialogImpl.this.boxRoot.animate().alpha(0.0f).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration(exitAnimDurationTemp);
                        ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
                        bkgAlpha.setDuration(exitAnimDurationTemp);
                        bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                if (DialogImpl.this.boxRoot != null) {
                                    DialogImpl.this.boxRoot.setBkgAlpha(((Float)animation.getAnimatedValue()).floatValue());
                                }
                            }
                        });
                        bkgAlpha.start();
                    }
                };
            }
            return WaitDialog.this.dialogXAnimImpl;
        }

        public long getExitAnimationDuration(@Nullable Animation defaultExitAnim) {
            long exitAnimDurationTemp;
            if (defaultExitAnim == null && this.bkg.getAnimation() != null) {
                defaultExitAnim = this.bkg.getAnimation();
            }
            long l = exitAnimDurationTemp = defaultExitAnim == null || defaultExitAnim.getDuration() == 0L ? 300L : defaultExitAnim.getDuration();
            if (overrideExitDuration >= 0) {
                exitAnimDurationTemp = overrideExitDuration;
            }
            if (WaitDialog.this.exitAnimDuration != -1L) {
                exitAnimDurationTemp = WaitDialog.this.exitAnimDuration;
            }
            return exitAnimDurationTemp;
        }

        public long getEnterAnimationDuration(@Nullable Animation defaultEnterAnim) {
            long enterAnimDurationTemp;
            if (defaultEnterAnim == null && this.bkg.getAnimation() != null) {
                defaultEnterAnim = this.bkg.getAnimation();
            }
            long l = enterAnimDurationTemp = defaultEnterAnim == null || defaultEnterAnim.getDuration() == 0L ? 300L : defaultEnterAnim.getDuration();
            if (overrideEnterDuration >= 0) {
                enterAnimDurationTemp = overrideEnterDuration;
            }
            if (WaitDialog.this.enterAnimDuration >= 0L) {
                enterAnimDurationTemp = WaitDialog.this.enterAnimDuration;
            }
            return enterAnimDurationTemp;
        }

        public void showTip(final TYPE tip) {
            WaitDialog.runOnMain(new Runnable(){

                @Override
                public void run() {
                    WaitDialog.this.showType = tip.ordinal();
                    if (DialogImpl.this.progressView == null) {
                        return;
                    }
                    switch (tip) {
                        case NONE: {
                            DialogImpl.this.progressView.loading();
                            return;
                        }
                        case SUCCESS: {
                            DialogImpl.this.progressView.success();
                            break;
                        }
                        case WARNING: {
                            DialogImpl.this.progressView.warning();
                            break;
                        }
                        case ERROR: {
                            DialogImpl.this.progressView.error();
                        }
                    }
                    if (DialogImpl.this.boxProgress != null && DialogImpl.this.boxProgress.getVisibility() == 0) {
                        DialogImpl.this.progressView.whenShowTick(new Runnable(){

                            @Override
                            public void run() {
                                WaitDialog.this.getDialogLifecycleCallback().onShow(WaitDialog.this);
                                DialogImpl.this.refreshView();
                                if (WaitDialog.this.tipShowDuration > 0L) {
                                    ((View)DialogImpl.this.progressView).postDelayed(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (WaitDialog.this.showType > -1) {
                                                DialogImpl.this.doDismiss(null);
                                            }
                                        }
                                    }, WaitDialog.this.tipShowDuration);
                                }
                            }
                        });
                    } else {
                        WaitDialog.this.getDialogLifecycleCallback().onShow(WaitDialog.this);
                        DialogImpl.this.refreshView();
                        if (WaitDialog.this.tipShowDuration > 0L) {
                            WaitDialog.runOnMainDelay(new Runnable(){

                                @Override
                                public void run() {
                                    if (WaitDialog.this.showType > -1) {
                                        DialogImpl.this.doDismiss(null);
                                    }
                                }
                            }, WaitDialog.this.tipShowDuration);
                        }
                    }
                }
            });
        }
    }

    public static enum TYPE {
        NONE,
        SUCCESS,
        WARNING,
        ERROR,
        PROGRESSING;

    }
}

