/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.dialogs;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Outline;
import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.BlurViewType;
import com.kongzue.dialogx.interfaces.DialogConvertViewInterface;
import com.kongzue.dialogx.interfaces.DialogLifecycleCallback;
import com.kongzue.dialogx.interfaces.DialogXAnimInterface;
import com.kongzue.dialogx.interfaces.DialogXRunnable;
import com.kongzue.dialogx.interfaces.DialogXStyle;
import com.kongzue.dialogx.interfaces.NoTouchInterface;
import com.kongzue.dialogx.interfaces.OnBindView;
import com.kongzue.dialogx.interfaces.OnDialogButtonClickListener;
import com.kongzue.dialogx.interfaces.OnSafeInsetsChangeListener;
import com.kongzue.dialogx.util.TextInfo;
import com.kongzue.dialogx.util.views.DialogXBaseRelativeLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;

public class PopTip
extends BaseDialog
implements NoTouchInterface {
    public static final int TIME_NO_AUTO_DISMISS_DELAY = -1;
    protected static List<PopTip> popTipList;
    public static long overrideEnterDuration;
    public static long overrideExitDuration;
    public static int overrideEnterAnimRes;
    public static int overrideExitAnimRes;
    protected OnBindView<PopTip> onBindView;
    protected DialogLifecycleCallback<PopTip> dialogLifecycleCallback;
    protected PopTip me = this;
    protected DialogImpl dialogImpl;
    protected int enterAnimResId = 0;
    protected int exitAnimResId = 0;
    protected DialogXStyle.PopTipSettings.ALIGN align;
    protected OnDialogButtonClickListener<PopTip> onButtonClickListener;
    protected OnDialogButtonClickListener<PopTip> onPopTipClickListener;
    protected BaseDialog.BOOLEAN tintIcon;
    protected float backgroundRadius = DialogX.defaultPopTipBackgroundRadius;
    protected DialogXAnimInterface<PopTip> dialogXAnimImpl;
    protected int iconResId;
    protected CharSequence message;
    protected CharSequence buttonText;
    protected TextInfo messageTextInfo;
    protected TextInfo buttonTextInfo = new TextInfo().setBold(true);
    protected int[] bodyMargin = new int[]{-1, -1, -1, -1};
    protected Timer autoDismissTimer;
    protected long autoDismissDelay;
    protected boolean preRecycle = false;

    protected PopTip() {
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    public static PopTip build() {
        return new PopTip();
    }

    public static PopTip build(DialogXStyle style2) {
        return new PopTip().setStyle(style2);
    }

    public static PopTip build(OnBindView<PopTip> onBindView) {
        return new PopTip().setCustomView(onBindView);
    }

    public PopTip(OnBindView<PopTip> onBindView) {
        this.onBindView = onBindView;
    }

    public PopTip(CharSequence message) {
        this.message = message;
    }

    public PopTip(int messageResId) {
        this.message = this.getString(messageResId);
    }

    public static PopTip tip(String message) {
        return PopTip.show(message);
    }

    public static PopTip tip(int messageResId) {
        return PopTip.show(messageResId);
    }

    public static PopTip tip(String message, String buttonText) {
        return PopTip.show((CharSequence)message, (CharSequence)buttonText);
    }

    public static PopTip tip(int messageResId, int buttonTextResId) {
        return PopTip.show(messageResId, buttonTextResId);
    }

    public static PopTip tip(int iconResId, String message) {
        return PopTip.show(iconResId, (CharSequence)message);
    }

    public static PopTip tip(int iconResId, String message, String buttonText) {
        return PopTip.show(iconResId, (CharSequence)message, buttonText);
    }

    public PopTip(int iconResId, CharSequence message) {
        this.iconResId = iconResId;
        this.message = message;
    }

    public PopTip(int iconResId, CharSequence message, CharSequence buttonText) {
        this.iconResId = iconResId;
        this.message = message;
        this.buttonText = buttonText;
    }

    public PopTip(int iconResId, int messageResId, int buttonTextResId) {
        this.iconResId = iconResId;
        this.message = this.getString(messageResId);
        this.buttonText = this.getString(buttonTextResId);
    }

    public PopTip(CharSequence message, CharSequence buttonText) {
        this.message = message;
        this.buttonText = buttonText;
    }

    public PopTip(int messageResId, int buttonTextResId) {
        this.message = this.getString(messageResId);
        this.buttonText = this.getString(buttonTextResId);
    }

    public PopTip(CharSequence message, OnBindView<PopTip> onBindView) {
        this.message = message;
        this.onBindView = onBindView;
    }

    public PopTip(int messageResId, OnBindView<PopTip> onBindView) {
        this.message = this.getString(messageResId);
        this.onBindView = onBindView;
    }

    public PopTip(int iconResId, CharSequence message, OnBindView<PopTip> onBindView) {
        this.iconResId = iconResId;
        this.message = message;
        this.onBindView = onBindView;
    }

    public PopTip(int iconResId, CharSequence message, CharSequence buttonText, OnBindView<PopTip> onBindView) {
        this.iconResId = iconResId;
        this.message = message;
        this.buttonText = buttonText;
        this.onBindView = onBindView;
    }

    public PopTip(int iconResId, int messageResId, int buttonTextResId, OnBindView<PopTip> onBindView) {
        this.iconResId = iconResId;
        this.message = this.getString(messageResId);
        this.buttonText = this.getString(buttonTextResId);
        this.onBindView = onBindView;
    }

    public PopTip(CharSequence message, CharSequence buttonText, OnBindView<PopTip> onBindView) {
        this.message = message;
        this.buttonText = buttonText;
        this.onBindView = onBindView;
    }

    public PopTip(int messageResId, int buttonTextResId, OnBindView<PopTip> onBindView) {
        this.message = this.getString(messageResId);
        this.buttonText = this.getString(buttonTextResId);
        this.onBindView = onBindView;
    }

    public static PopTip show(OnBindView<PopTip> onBindView) {
        PopTip popTip = new PopTip(onBindView);
        popTip.show();
        return popTip;
    }

    public static PopTip show(CharSequence message) {
        PopTip popTip = new PopTip(message);
        popTip.show();
        return popTip;
    }

    public static PopTip show(int messageResId) {
        PopTip popTip = new PopTip(messageResId);
        popTip.show();
        return popTip;
    }

    public static PopTip show(CharSequence message, OnBindView<PopTip> onBindView) {
        PopTip popTip = new PopTip(message, onBindView);
        popTip.show();
        return popTip;
    }

    public static PopTip show(int messageResId, OnBindView<PopTip> onBindView) {
        PopTip popTip = new PopTip(messageResId, onBindView);
        popTip.show();
        return popTip;
    }

    public static PopTip show(CharSequence message, CharSequence buttonText) {
        PopTip popTip = new PopTip(message, buttonText);
        popTip.show();
        return popTip;
    }

    public static PopTip show(int messageResId, int buttonTextResId) {
        PopTip popTip = new PopTip(messageResId, buttonTextResId);
        popTip.show();
        return popTip;
    }

    public static PopTip show(int iconResId, CharSequence message, OnBindView<PopTip> onBindView) {
        PopTip popTip = new PopTip(iconResId, message, onBindView);
        popTip.show();
        return popTip;
    }

    public static PopTip show(int iconResId, CharSequence message) {
        PopTip popTip = new PopTip(iconResId, message);
        popTip.show();
        return popTip;
    }

    public static PopTip show(int iconResId, CharSequence message, CharSequence buttonText) {
        PopTip popTip = new PopTip(iconResId, message, buttonText);
        popTip.show();
        return popTip;
    }

    public static PopTip show(int iconResId, CharSequence message, CharSequence buttonText, OnBindView<PopTip> onBindView) {
        PopTip popTip = new PopTip(iconResId, message, buttonText, onBindView);
        popTip.show();
        return popTip;
    }

    public static PopTip show(int iconResId, int messageResId, int buttonTextResId, OnBindView<PopTip> onBindView) {
        PopTip popTip = new PopTip(iconResId, messageResId, buttonTextResId, onBindView);
        popTip.show();
        return popTip;
    }

    public static PopTip show(CharSequence message, CharSequence buttonText, OnBindView<PopTip> onBindView) {
        PopTip popTip = new PopTip(message, buttonText, onBindView);
        popTip.show();
        return popTip;
    }

    public static PopTip show(int messageResId, int buttonTextResId, OnBindView<PopTip> onBindView) {
        PopTip popTip = new PopTip(messageResId, buttonTextResId, onBindView);
        popTip.show();
        return popTip;
    }

    public PopTip show() {
        if (this.isHide && this.getDialogView() != null) {
            this.getDialogView().setVisibility(0);
            return this;
        }
        super.beforeShow();
        if (this.getDialogView() == null) {
            int layoutResId;
            if (DialogX.onlyOnePopTip) {
                PopTip oldInstance = null;
                if (popTipList != null && !popTipList.isEmpty()) {
                    oldInstance = popTipList.get(popTipList.size() - 1);
                }
                if (oldInstance != null) {
                    oldInstance.dismiss();
                }
            } else if (popTipList != null) {
                for (int i = 0; i < popTipList.size(); ++i) {
                    PopTip popInstance = popTipList.get(i);
                    popInstance.moveUp();
                }
            }
            if (popTipList == null) {
                popTipList = new ArrayList<PopTip>();
            }
            popTipList.add(this);
            int n = layoutResId = this.isLightTheme() ? R.layout.layout_dialogx_poptip_material : R.layout.layout_dialogx_poptip_material_dark;
            if (this.style.popTipSettings() != null) {
                if (this.style.popTipSettings().layout(this.isLightTheme()) != 0) {
                    layoutResId = this.style.popTipSettings().layout(this.isLightTheme());
                }
                if (this.align == null) {
                    this.align = this.style.popTipSettings().align() == null ? DialogXStyle.PopTipSettings.ALIGN.BOTTOM : this.style.popTipSettings().align();
                }
                int styleEnterAnimResId = this.style.popTipSettings().enterAnimResId(this.isLightTheme());
                int styleExitAnimResId = this.style.popTipSettings().exitAnimResId(this.isLightTheme());
                int n2 = this.enterAnimResId == 0 ? (overrideEnterAnimRes == 0 ? (styleEnterAnimResId != 0 ? styleEnterAnimResId : R.anim.anim_dialogx_default_enter) : overrideEnterAnimRes) : (this.enterAnimResId = this.enterAnimResId);
                this.exitAnimResId = this.exitAnimResId == 0 ? (overrideExitAnimRes == 0 ? (styleExitAnimResId != 0 ? styleExitAnimResId : R.anim.anim_dialogx_default_exit) : overrideExitAnimRes) : this.exitAnimResId;
                this.enterAnimDuration = this.enterAnimDuration == -1L ? overrideEnterDuration : this.enterAnimDuration;
                this.exitAnimDuration = this.exitAnimDuration == -1L ? overrideExitDuration : this.exitAnimDuration;
            }
            View dialogView = this.createView(layoutResId);
            this.dialogImpl = new DialogImpl(dialogView);
            if (dialogView != null) {
                dialogView.setTag((Object)this.me);
            }
            PopTip.show(dialogView);
        } else {
            PopTip.show(this.getDialogView());
        }
        return this;
    }

    public PopTip show(Activity activity) {
        super.beforeShow();
        if (this.getDialogView() != null) {
            int layoutResId;
            if (DialogX.onlyOnePopTip) {
                PopTip oldInstance = null;
                if (popTipList != null && !popTipList.isEmpty()) {
                    oldInstance = popTipList.get(popTipList.size() - 1);
                }
                if (oldInstance != null) {
                    oldInstance.dismiss();
                }
            } else if (popTipList != null) {
                for (int i = 0; i < popTipList.size(); ++i) {
                    PopTip popInstance = popTipList.get(i);
                    popInstance.moveUp();
                }
            }
            if (popTipList == null) {
                popTipList = new ArrayList<PopTip>();
            }
            popTipList.add(this);
            int n = layoutResId = this.isLightTheme() ? R.layout.layout_dialogx_poptip_material : R.layout.layout_dialogx_poptip_material_dark;
            if (this.style.popTipSettings() != null) {
                if (this.style.popTipSettings().layout(this.isLightTheme()) != 0) {
                    layoutResId = this.style.popTipSettings().layout(this.isLightTheme());
                }
                if (this.align == null) {
                    this.align = this.style.popTipSettings().align() == null ? DialogXStyle.PopTipSettings.ALIGN.BOTTOM : this.style.popTipSettings().align();
                }
                int styleEnterAnimResId = this.style.popTipSettings().enterAnimResId(this.isLightTheme());
                int styleExitAnimResId = this.style.popTipSettings().exitAnimResId(this.isLightTheme());
                int n2 = this.enterAnimResId == 0 ? (overrideEnterAnimRes == 0 ? (styleEnterAnimResId != 0 ? styleEnterAnimResId : R.anim.anim_dialogx_default_enter) : overrideEnterAnimRes) : (this.enterAnimResId = this.enterAnimResId);
                this.exitAnimResId = this.exitAnimResId == 0 ? (overrideExitAnimRes == 0 ? (styleExitAnimResId != 0 ? styleExitAnimResId : R.anim.anim_dialogx_default_exit) : overrideExitAnimRes) : this.exitAnimResId;
                this.enterAnimDuration = this.enterAnimDuration == -1L ? overrideEnterDuration : this.enterAnimDuration;
                this.exitAnimDuration = this.exitAnimDuration == -1L ? overrideExitDuration : this.exitAnimDuration;
            }
            View dialogView = this.createView(layoutResId);
            this.dialogImpl = new DialogImpl(dialogView);
            if (dialogView != null) {
                dialogView.setTag((Object)this.me);
            }
            PopTip.show(activity, dialogView);
        } else {
            PopTip.show(activity, this.getDialogView());
        }
        return this;
    }

    @Override
    public String dialogKey() {
        return this.getClass().getSimpleName() + "(" + Integer.toHexString(this.hashCode()) + ")";
    }

    public PopTip autoDismiss(long delay) {
        this.autoDismissDelay = delay;
        if (this.autoDismissTimer != null) {
            this.autoDismissTimer.cancel();
        }
        if (delay < 0L) {
            return this;
        }
        this.autoDismissTimer = new Timer();
        this.autoDismissTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                PopTip.this.dismiss();
            }
        }, delay);
        return this;
    }

    public void resetAutoDismissTimer() {
        this.autoDismiss(this.autoDismissDelay);
    }

    public PopTip showShort() {
        this.autoDismiss(2000L);
        if (!this.preShow && !this.isShow) {
            this.show();
        }
        return this;
    }

    public PopTip showLong() {
        this.autoDismiss(3500L);
        if (!this.preShow && !this.isShow) {
            this.show();
        }
        return this;
    }

    public PopTip showAlways() {
        return this.noAutoDismiss();
    }

    public PopTip noAutoDismiss() {
        this.autoDismiss(-1L);
        return this;
    }

    private void waitForDismiss() {
        this.preRecycle = true;
        if (popTipList != null) {
            CopyOnWriteArrayList<PopTip> copyPopTipList = new CopyOnWriteArrayList<PopTip>(popTipList);
            for (PopTip popTip : copyPopTipList) {
                if (popTip.preRecycle) continue;
                return;
            }
            for (PopTip popTip : copyPopTipList) {
                PopTip.dismiss(popTip.getDialogView());
            }
        }
    }

    private void moveUp() {
        if (this.getDialogImpl() != null && this.getDialogImpl().boxBody != null) {
            if (this.getDialogImpl() == null || this.getDialogImpl().boxBody == null) {
                return;
            }
            LinearLayout bodyView = this.getDialogImpl().boxBody;
            bodyView.post(new Runnable((View)bodyView){
                final /* synthetic */ View val$bodyView;
                {
                    this.val$bodyView = view;
                }

                @Override
                public void run() {
                    if (PopTip.this.getDialogImpl() == null) {
                        return;
                    }
                    if (PopTip.this.style.popTipSettings() != null) {
                        PopTip.this.align = PopTip.this.style.popTipSettings().align();
                    }
                    if (PopTip.this.align == null) {
                        PopTip.this.align = DialogXStyle.PopTipSettings.ALIGN.TOP;
                    }
                    float moveAimTop = 0.0f;
                    switch (PopTip.this.align) {
                        case TOP: {
                            moveAimTop = this.val$bodyView.getY() + (float)this.val$bodyView.getHeight() * 1.3f;
                            break;
                        }
                        case TOP_INSIDE: {
                            moveAimTop = this.val$bodyView.getY() + (float)this.val$bodyView.getHeight() - (float)this.val$bodyView.getPaddingTop();
                            break;
                        }
                        case BOTTOM: 
                        case CENTER: 
                        case BOTTOM_INSIDE: {
                            moveAimTop = this.val$bodyView.getY() - (float)this.val$bodyView.getHeight() * 1.3f;
                        }
                    }
                    if (this.val$bodyView.getTag() instanceof ValueAnimator) {
                        ((ValueAnimator)this.val$bodyView.getTag()).end();
                    }
                    PopTip.log("#Animation from:" + this.val$bodyView.getY() + " to:" + moveAimTop);
                    ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.val$bodyView.getY(), moveAimTop});
                    this.val$bodyView.setTag((Object)valueAnimator);
                    valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            if (PopTip.this.getDialogImpl() == null || !PopTip.this.isShow) {
                                animation.cancel();
                                return;
                            }
                            LinearLayout bodyView = PopTip.this.getDialogImpl().boxBody;
                            if (bodyView != null && bodyView.isAttachedToWindow()) {
                                bodyView.setY(((Float)animation.getAnimatedValue()).floatValue());
                            }
                        }
                    });
                    valueAnimator.setDuration(PopTip.this.enterAnimDuration == -1L ? 300L : PopTip.this.enterAnimDuration).setInterpolator((TimeInterpolator)new DecelerateInterpolator(2.0f));
                    valueAnimator.start();
                }
            });
        }
    }

    @Override
    public void refreshUI() {
        if (this.getDialogImpl() == null) {
            return;
        }
        PopTip.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (PopTip.this.dialogImpl != null) {
                    PopTip.this.dialogImpl.refreshView();
                }
            }
        });
    }

    public void dismiss() {
        PopTip.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (PopTip.this.dialogImpl == null) {
                    return;
                }
                PopTip.this.dialogImpl.doDismiss(null);
            }
        });
    }

    public DialogLifecycleCallback<PopTip> getDialogLifecycleCallback() {
        return this.dialogLifecycleCallback == null ? new DialogLifecycleCallback<PopTip>(){} : this.dialogLifecycleCallback;
    }

    public PopTip setDialogLifecycleCallback(DialogLifecycleCallback<PopTip> dialogLifecycleCallback) {
        this.dialogLifecycleCallback = dialogLifecycleCallback;
        if (this.isShow) {
            dialogLifecycleCallback.onShow(this.me);
        }
        return this;
    }

    public PopTip setStyle(DialogXStyle style2) {
        this.style = style2;
        return this;
    }

    public PopTip setTheme(DialogX.THEME theme) {
        this.theme = theme;
        return this;
    }

    public DialogImpl getDialogImpl() {
        return this.dialogImpl;
    }

    public PopTip setCustomView(OnBindView<PopTip> onBindView) {
        this.onBindView = onBindView;
        this.refreshUI();
        return this;
    }

    public View getCustomView() {
        if (this.onBindView == null) {
            return null;
        }
        return this.onBindView.getCustomView();
    }

    public PopTip removeCustomView() {
        this.onBindView.clean();
        this.refreshUI();
        return this;
    }

    public DialogXStyle.PopTipSettings.ALIGN getAlign() {
        return this.align;
    }

    @Deprecated
    public PopTip setAlign(DialogXStyle.PopTipSettings.ALIGN align) {
        this.align = align;
        return this;
    }

    public int getIconResId() {
        return this.iconResId;
    }

    public PopTip setIconResId(int iconResId) {
        this.iconResId = iconResId;
        this.refreshUI();
        return this;
    }

    public CharSequence getMessage() {
        return this.message;
    }

    public PopTip setMessage(CharSequence message) {
        this.message = message;
        this.refreshUI();
        return this;
    }

    public PopTip setMessage(int messageResId) {
        this.message = this.getString(messageResId);
        this.refreshUI();
        return this;
    }

    public CharSequence getButtonText() {
        return this.buttonText;
    }

    public PopTip setButton(CharSequence buttonText) {
        this.buttonText = buttonText;
        this.refreshUI();
        return this;
    }

    public PopTip setButton(int buttonTextResId) {
        this.buttonText = this.getString(buttonTextResId);
        this.refreshUI();
        return this;
    }

    public PopTip setButton(CharSequence buttonText, OnDialogButtonClickListener<PopTip> onButtonClickListener) {
        this.buttonText = buttonText;
        this.onButtonClickListener = onButtonClickListener;
        this.refreshUI();
        return this;
    }

    public PopTip setButton(int buttonTextResId, OnDialogButtonClickListener<PopTip> onButtonClickListener) {
        this.buttonText = this.getString(buttonTextResId);
        this.onButtonClickListener = onButtonClickListener;
        this.refreshUI();
        return this;
    }

    public PopTip setButton(OnDialogButtonClickListener<PopTip> onButtonClickListener) {
        this.onButtonClickListener = onButtonClickListener;
        return this;
    }

    public TextInfo getMessageTextInfo() {
        return this.messageTextInfo;
    }

    public PopTip setMessageTextInfo(TextInfo messageTextInfo) {
        this.messageTextInfo = messageTextInfo;
        this.refreshUI();
        return this;
    }

    public TextInfo getButtonTextInfo() {
        return this.buttonTextInfo;
    }

    public PopTip setButtonTextInfo(TextInfo buttonTextInfo) {
        this.buttonTextInfo = buttonTextInfo;
        this.refreshUI();
        return this;
    }

    public OnDialogButtonClickListener<PopTip> getOnButtonClickListener() {
        return this.onButtonClickListener;
    }

    public PopTip setOnButtonClickListener(OnDialogButtonClickListener<PopTip> onButtonClickListener) {
        this.onButtonClickListener = onButtonClickListener;
        return this;
    }

    @Deprecated
    public boolean isAutoTintIconInLightOrDarkMode() {
        return this.isTintIcon();
    }

    @Deprecated
    public PopTip setAutoTintIconInLightOrDarkMode(boolean autoTintIconInLightOrDarkMode) {
        this.setTintIcon(autoTintIconInLightOrDarkMode);
        return this;
    }

    public OnDialogButtonClickListener<PopTip> getOnPopTipClickListener() {
        return this.onPopTipClickListener;
    }

    public PopTip setOnPopTipClickListener(OnDialogButtonClickListener<PopTip> onPopTipClickListener) {
        this.onPopTipClickListener = onPopTipClickListener;
        this.refreshUI();
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public PopTip setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.refreshUI();
        return this;
    }

    public PopTip setBackgroundColorRes(@ColorRes int backgroundColorResId) {
        this.backgroundColor = this.getColor(backgroundColorResId);
        this.refreshUI();
        return this;
    }

    public long getEnterAnimDuration() {
        return this.enterAnimDuration;
    }

    public PopTip setEnterAnimDuration(long enterAnimDuration) {
        this.enterAnimDuration = enterAnimDuration;
        return this;
    }

    public long getExitAnimDuration() {
        return this.exitAnimDuration;
    }

    public PopTip setExitAnimDuration(long exitAnimDuration) {
        this.exitAnimDuration = exitAnimDuration;
        return this;
    }

    @Override
    public void restartDialog() {
        int layoutResId;
        if (this.getDialogView() != null) {
            PopTip.dismiss(this.getDialogView());
            this.isShow = false;
        }
        if (this.getDialogImpl().boxCustom != null) {
            this.getDialogImpl().boxCustom.removeAllViews();
        }
        if (DialogX.onlyOnePopTip) {
            PopTip oldInstance = null;
            if (popTipList != null && !popTipList.isEmpty()) {
                oldInstance = popTipList.get(popTipList.size() - 1);
            }
            if (oldInstance != null) {
                oldInstance.dismiss();
            }
        } else if (popTipList != null) {
            for (int i = 0; i < popTipList.size(); ++i) {
                PopTip popInstance = popTipList.get(i);
                popInstance.moveUp();
            }
        }
        if (popTipList == null) {
            popTipList = new ArrayList<PopTip>();
        }
        popTipList.add(this);
        int n = layoutResId = this.isLightTheme() ? R.layout.layout_dialogx_poptip_material : R.layout.layout_dialogx_poptip_material_dark;
        if (this.style.popTipSettings() != null) {
            if (this.style.popTipSettings().layout(this.isLightTheme()) != 0) {
                layoutResId = this.style.popTipSettings().layout(this.isLightTheme());
            }
            if (this.align == null) {
                this.align = this.style.popTipSettings().align() == null ? DialogXStyle.PopTipSettings.ALIGN.BOTTOM : this.style.popTipSettings().align();
            }
            int styleEnterAnimResId = this.style.popTipSettings().enterAnimResId(this.isLightTheme());
            int styleExitAnimResId = this.style.popTipSettings().exitAnimResId(this.isLightTheme());
            int n2 = this.enterAnimResId == 0 ? (overrideEnterAnimRes == 0 ? (styleEnterAnimResId != 0 ? styleEnterAnimResId : R.anim.anim_dialogx_default_enter) : overrideEnterAnimRes) : (this.enterAnimResId = this.enterAnimResId);
            this.exitAnimResId = this.exitAnimResId == 0 ? (overrideExitAnimRes == 0 ? (styleExitAnimResId != 0 ? styleExitAnimResId : R.anim.anim_dialogx_default_exit) : overrideExitAnimRes) : this.exitAnimResId;
            this.enterAnimDuration = this.enterAnimDuration == -1L ? overrideEnterDuration : this.enterAnimDuration;
            this.exitAnimDuration = this.exitAnimDuration == -1L ? overrideExitDuration : this.exitAnimDuration;
        }
        this.enterAnimDuration = 0L;
        View dialogView = this.createView(layoutResId);
        this.dialogImpl = new DialogImpl(dialogView);
        if (dialogView != null) {
            dialogView.setTag((Object)this.me);
        }
        PopTip.show(dialogView);
    }

    public void hide() {
        this.isHide = true;
        if (this.getDialogView() != null) {
            this.getDialogView().setVisibility(8);
        }
    }

    public PopTip setAnimResId(int enterResId, int exitResId) {
        this.enterAnimResId = enterResId;
        this.exitAnimResId = exitResId;
        return this;
    }

    public PopTip setEnterAnimResId(int enterResId) {
        this.enterAnimResId = enterResId;
        return this;
    }

    public PopTip setExitAnimResId(int exitResId) {
        this.exitAnimResId = exitResId;
        return this;
    }

    public PopTip setHapticFeedbackEnabled(boolean isHapticFeedbackEnabled) {
        this.isHapticFeedbackEnabled = isHapticFeedbackEnabled ? 1 : 0;
        return this;
    }

    @Override
    protected void shutdown() {
        this.dismiss();
    }

    public PopTip setDialogImplMode(DialogX.IMPL_MODE dialogImplMode) {
        this.dialogImplMode = dialogImplMode;
        return this;
    }

    public PopTip setMargin(int left, int top, int right, int bottom) {
        this.bodyMargin[0] = left;
        this.bodyMargin[1] = top;
        this.bodyMargin[2] = right;
        this.bodyMargin[3] = bottom;
        this.refreshUI();
        return this;
    }

    public PopTip setMarginLeft(int left) {
        this.bodyMargin[0] = left;
        this.refreshUI();
        return this;
    }

    public PopTip setMarginTop(int top) {
        this.bodyMargin[1] = top;
        this.refreshUI();
        return this;
    }

    public PopTip setMarginRight(int right) {
        this.bodyMargin[2] = right;
        this.refreshUI();
        return this;
    }

    public PopTip setMarginBottom(int bottom) {
        this.bodyMargin[3] = bottom;
        this.refreshUI();
        return this;
    }

    public int getMarginLeft() {
        return this.bodyMargin[0];
    }

    public int getMarginTop() {
        return this.bodyMargin[1];
    }

    public int getMarginRight() {
        return this.bodyMargin[2];
    }

    public int getMarginBottom() {
        return this.bodyMargin[3];
    }

    public PopTip iconSuccess() {
        this.setTintIcon(false);
        int resId = R.mipmap.ico_dialogx_success;
        if (this.getStyle().popTipSettings() != null && this.getStyle().popTipSettings().defaultIconSuccess() != 0) {
            resId = this.getStyle().popTipSettings().defaultIconSuccess();
        }
        this.setIconResId(resId);
        return this;
    }

    public PopTip iconWarning() {
        this.setTintIcon(false);
        int resId = R.mipmap.ico_dialogx_warning;
        if (this.getStyle().popTipSettings() != null && this.getStyle().popTipSettings().defaultIconWarning() != 0) {
            resId = this.getStyle().popTipSettings().defaultIconWarning();
        }
        this.setIconResId(resId);
        return this;
    }

    public PopTip iconError() {
        this.setTintIcon(false);
        int resId = R.mipmap.ico_dialogx_error;
        if (this.getStyle().popTipSettings() != null && this.getStyle().popTipSettings().defaultIconError() != 0) {
            resId = this.getStyle().popTipSettings().defaultIconError();
        }
        this.setIconResId(resId);
        return this;
    }

    public boolean isTintIcon() {
        if (this.tintIcon == null && this.getStyle().popTipSettings() != null) {
            return this.getStyle().popTipSettings().tintIcon();
        }
        return this.tintIcon == BaseDialog.BOOLEAN.TRUE;
    }

    public PopTip setTintIcon(boolean tintIcon) {
        this.tintIcon = tintIcon ? BaseDialog.BOOLEAN.TRUE : BaseDialog.BOOLEAN.FALSE;
        this.refreshUI();
        return this;
    }

    public PopTip setRadius(float radiusPx) {
        this.backgroundRadius = radiusPx;
        this.refreshUI();
        return this;
    }

    public float getRadius() {
        return this.backgroundRadius;
    }

    public DialogXAnimInterface<PopTip> getDialogXAnimImpl() {
        return this.dialogXAnimImpl;
    }

    public PopTip setDialogXAnimImpl(DialogXAnimInterface<PopTip> dialogXAnimImpl) {
        this.dialogXAnimImpl = dialogXAnimImpl;
        return this;
    }

    public PopTip setRootPadding(int padding) {
        this.screenPaddings = new int[]{padding, padding, padding, padding};
        this.refreshUI();
        return this;
    }

    public PopTip setRootPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.screenPaddings = new int[]{paddingLeft, paddingTop, paddingRight, paddingBottom};
        this.refreshUI();
        return this;
    }

    protected void onShow(PopTip dialog) {
    }

    protected void onDismiss(PopTip dialog) {
    }

    @Override
    protected void cleanActivityContext() {
        super.cleanActivityContext();
        PopTip.dismiss(this.getDialogView());
    }

    @Override
    public PopTip setData(String key, Object obj) {
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.data.put(key, obj);
        return this;
    }

    public PopTip onShow(DialogXRunnable<PopTip> dialogXRunnable) {
        this.onShowRunnable = dialogXRunnable;
        if (this.isShow() && this.onShowRunnable != null) {
            this.onShowRunnable.run(this);
        }
        return this;
    }

    public PopTip onDismiss(DialogXRunnable<PopTip> dialogXRunnable) {
        this.onDismissRunnable = dialogXRunnable;
        return this;
    }

    public PopTip appendMessage(CharSequence message) {
        this.message = TextUtils.concat((CharSequence[])new CharSequence[]{this.message, message});
        this.refreshUI();
        return this;
    }

    @Override
    public PopTip setThisOrderIndex(int orderIndex) {
        this.thisOrderIndex = orderIndex;
        if (this.getDialogView() != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.getDialogView().setTranslationZ((float)orderIndex);
            } else {
                PopTip.error("DialogX: " + this.dialogKey() + " \u6267\u884c .setThisOrderIndex(" + orderIndex + ") \u5931\u8d25\uff1a\u7cfb\u7edf\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0cSDK-API \u7248\u672c\u5fc5\u987b\u5927\u4e8e 21\uff08LOLLIPOP\uff09");
            }
        }
        return this;
    }

    public PopTip bringToFront() {
        this.setThisOrderIndex(this.getHighestOrderIndex());
        return this;
    }

    static {
        overrideEnterDuration = -1L;
        overrideExitDuration = -1L;
        overrideEnterAnimRes = 0;
        overrideExitAnimRes = 0;
    }

    public class DialogImpl
    implements DialogConvertViewInterface {
        public DialogXBaseRelativeLayout boxRoot;
        public LinearLayout boxBody;
        public ImageView imgDialogxPopIcon;
        public TextView txtDialogxPopText;
        public RelativeLayout boxCustom;
        public TextView txtDialogxButton;
        private List<View> blurViews;

        public DialogImpl(View convertView) {
            if (convertView == null) {
                return;
            }
            PopTip.this.setDialogView(convertView);
            this.boxRoot = (DialogXBaseRelativeLayout)convertView.findViewById(R.id.box_root);
            this.boxBody = (LinearLayout)convertView.findViewById(R.id.box_body);
            this.imgDialogxPopIcon = (ImageView)convertView.findViewById(R.id.img_dialogx_pop_icon);
            this.txtDialogxPopText = (TextView)convertView.findViewById(R.id.txt_dialogx_pop_text);
            this.boxCustom = (RelativeLayout)convertView.findViewById(R.id.box_custom);
            this.txtDialogxButton = (TextView)convertView.findViewById(R.id.txt_dialogx_button);
            this.blurViews = PopTip.this.findAllBlurView(convertView);
            this.init();
            PopTip.this.dialogImpl = this;
            this.refreshView();
        }

        @Override
        public void init() {
            if (Build.VERSION.SDK_INT >= 21) {
                PopTip.this.getDialogView().setTranslationZ((float)PopTip.this.getThisOrderIndex());
            }
            if (PopTip.this.messageTextInfo == null) {
                PopTip.this.messageTextInfo = DialogX.popTextInfo;
            }
            if (PopTip.this.buttonTextInfo == null) {
                PopTip.this.buttonTextInfo = DialogX.buttonTextInfo;
            }
            if (PopTip.this.backgroundColor == null) {
                PopTip.this.backgroundColor = DialogX.backgroundColor;
            }
            if (PopTip.this.autoDismissTimer == null) {
                PopTip.this.showShort();
            }
            this.boxRoot.setParentDialog(PopTip.this.me);
            this.boxRoot.setAutoUnsafePlacePadding(true);
            this.boxRoot.setOnLifecycleCallBack(new DialogXBaseRelativeLayout.OnLifecycleCallBack(){

                @Override
                public void onShow() {
                    PopTip.this.isShow = true;
                    PopTip.this.preShow = false;
                    PopTip.this.setLifecycleState(Lifecycle.State.CREATED);
                    DialogImpl.this.boxRoot.setAlpha(0.0f);
                    PopTip.this.onDialogShow();
                    PopTip.this.getDialogLifecycleCallback().onShow(PopTip.this.me);
                    PopTip.this.onShow(PopTip.this.me);
                }

                @Override
                public void onDismiss() {
                    if (popTipList != null) {
                        popTipList.remove(PopTip.this);
                        if (popTipList.isEmpty()) {
                            popTipList = null;
                        }
                    }
                    PopTip.this.isShow = false;
                    if (PopTip.this.autoDismissTimer != null) {
                        PopTip.this.autoDismissTimer.cancel();
                    }
                    PopTip.this.getDialogLifecycleCallback().onDismiss(PopTip.this.me);
                    PopTip.this.onDismiss(PopTip.this.me);
                    PopTip.this.dialogImpl = null;
                    PopTip.this.setLifecycleState(Lifecycle.State.DESTROYED);
                    System.gc();
                }
            });
            RelativeLayout.LayoutParams rlp = (RelativeLayout.LayoutParams)this.boxBody.getLayoutParams();
            if (PopTip.this.align == null) {
                PopTip.this.align = DialogXStyle.PopTipSettings.ALIGN.BOTTOM;
            }
            switch (PopTip.this.align) {
                case TOP: {
                    rlp.removeRule(13);
                    rlp.addRule(10);
                    break;
                }
                case BOTTOM: {
                    rlp.removeRule(13);
                    rlp.addRule(12);
                    break;
                }
                case CENTER: {
                    rlp.removeRule(10);
                    rlp.removeRule(12);
                    rlp.addRule(13);
                }
            }
            this.boxBody.setLayoutParams((ViewGroup.LayoutParams)rlp);
            this.boxRoot.setOnSafeInsetsChangeListener(new OnSafeInsetsChangeListener(){

                @Override
                public void onChange(Rect unsafeRect) {
                    if (PopTip.this.align == DialogXStyle.PopTipSettings.ALIGN.TOP_INSIDE) {
                        DialogImpl.this.boxBody.setPadding(0, unsafeRect.top, 0, 0);
                    }
                }
            });
            this.boxRoot.setOnBackPressedListener(new DialogXBaseRelativeLayout.PrivateBackPressedListener(){

                @Override
                public boolean onBackPressed() {
                    return false;
                }
            });
            this.boxRoot.post(new Runnable(){

                @Override
                public void run() {
                    DialogImpl.this.getDialogXAnimImpl().doShowAnim(PopTip.this.me, (ViewGroup)DialogImpl.this.boxBody);
                    PopTip.this.setLifecycleState(Lifecycle.State.RESUMED);
                }
            });
            this.txtDialogxButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PopTip.this.haptic(v);
                    if (PopTip.this.onButtonClickListener != null) {
                        if (!PopTip.this.onButtonClickListener.onClick(PopTip.this.me, v)) {
                            DialogImpl.this.doDismiss(v);
                        }
                    } else {
                        DialogImpl.this.doDismiss(v);
                    }
                }
            });
            PopTip.this.onDialogInit();
        }

        @Override
        public void refreshView() {
            if (this.boxRoot == null || PopTip.this.getOwnActivity() == null) {
                return;
            }
            this.boxRoot.setRootPadding(PopTip.this.screenPaddings[0], PopTip.this.screenPaddings[1], PopTip.this.screenPaddings[2], PopTip.this.screenPaddings[3]);
            if (PopTip.this.backgroundColor != null) {
                PopTip.this.tintColor((View)this.boxBody, PopTip.this.backgroundColor);
                if (this.blurViews != null) {
                    for (View blurView : this.blurViews) {
                        ((BlurViewType)blurView).setOverlayColor(PopTip.this.backgroundColor);
                    }
                }
            }
            if (PopTip.this.onBindView != null && PopTip.this.onBindView.getCustomView() != null) {
                PopTip.this.onBindView.bindParent((ViewGroup)this.boxCustom, PopTip.this.me);
                this.boxCustom.setVisibility(0);
            } else {
                this.boxCustom.setVisibility(8);
            }
            PopTip.this.showText(this.txtDialogxPopText, PopTip.this.message);
            PopTip.this.showText(this.txtDialogxButton, PopTip.this.buttonText);
            BaseDialog.useTextInfo(this.txtDialogxPopText, PopTip.this.messageTextInfo);
            BaseDialog.useTextInfo(this.txtDialogxButton, PopTip.this.buttonTextInfo);
            if (PopTip.this.iconResId != 0) {
                this.imgDialogxPopIcon.setVisibility(0);
                this.imgDialogxPopIcon.setImageResource(PopTip.this.iconResId);
                if (Build.VERSION.SDK_INT >= 21) {
                    if (PopTip.this.isTintIcon()) {
                        this.imgDialogxPopIcon.setImageTintList(this.txtDialogxPopText.getTextColors());
                    } else {
                        this.imgDialogxPopIcon.setImageTintList(null);
                    }
                }
            } else {
                this.imgDialogxPopIcon.setVisibility(8);
            }
            if (PopTip.this.backgroundRadius > -1.0f) {
                Object gradientDrawable;
                if (this.boxBody.getBackground() instanceof GradientDrawable && (gradientDrawable = (GradientDrawable)this.boxBody.getBackground()) != null) {
                    gradientDrawable.setCornerRadius(PopTip.this.backgroundRadius);
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    this.boxBody.setOutlineProvider(new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), PopTip.this.backgroundRadius);
                        }
                    });
                    this.boxBody.setClipToOutline(true);
                }
                if (this.blurViews != null) {
                    for (View blurView : this.blurViews) {
                        ((BlurViewType)blurView).setRadiusPx(Float.valueOf(PopTip.this.backgroundRadius));
                    }
                }
            }
            if (PopTip.this.onPopTipClickListener != null) {
                this.boxBody.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (!PopTip.this.onPopTipClickListener.onClick(PopTip.this.me, v)) {
                            PopTip.this.haptic(v);
                            PopTip.this.dismiss();
                        }
                    }
                });
            } else {
                this.boxBody.setOnClickListener(null);
                this.boxBody.setClickable(false);
            }
            RelativeLayout.LayoutParams rlp = (RelativeLayout.LayoutParams)this.boxBody.getLayoutParams();
            if (PopTip.this.bodyMargin[0] != -1) {
                rlp.leftMargin = PopTip.this.bodyMargin[0];
            }
            if (PopTip.this.bodyMargin[1] != -1) {
                rlp.topMargin = PopTip.this.bodyMargin[1];
            }
            if (PopTip.this.bodyMargin[2] != -1) {
                rlp.rightMargin = PopTip.this.bodyMargin[2];
            }
            if (PopTip.this.bodyMargin[3] != -1) {
                rlp.bottomMargin = PopTip.this.bodyMargin[3];
            }
            this.boxBody.setLayoutParams((ViewGroup.LayoutParams)rlp);
            PopTip.this.onDialogRefreshUI();
        }

        @Override
        public void doDismiss(View v) {
            if (PopTip.this.preDismiss(PopTip.this)) {
                return;
            }
            if (v != null) {
                v.setEnabled(false);
            }
            if (!PopTip.this.dismissAnimFlag && this.boxRoot != null) {
                PopTip.this.dismissAnimFlag = true;
                this.boxRoot.post(new Runnable(){

                    @Override
                    public void run() {
                        DialogImpl.this.getDialogXAnimImpl().doExitAnim(PopTip.this.me, (ViewGroup)DialogImpl.this.boxBody);
                        PopTip.runOnMainDelay(new Runnable(){

                            @Override
                            public void run() {
                                PopTip.this.waitForDismiss();
                            }
                        }, DialogImpl.this.getExitAnimationDuration(null));
                    }
                });
            }
        }

        protected DialogXAnimInterface<PopTip> getDialogXAnimImpl() {
            if (PopTip.this.dialogXAnimImpl == null) {
                PopTip.this.dialogXAnimImpl = new DialogXAnimInterface<PopTip>(){

                    @Override
                    public void doShowAnim(PopTip dialog, ViewGroup dialogBodyView) {
                        Animation enterAnim = AnimationUtils.loadAnimation((Context)PopTip.this.getOwnActivity(), (int)(PopTip.this.enterAnimResId == 0 ? R.anim.anim_dialogx_default_enter : PopTip.this.enterAnimResId));
                        long enterAnimDuration = DialogImpl.this.getEnterAnimationDuration(enterAnim);
                        enterAnim.setInterpolator((Interpolator)new DecelerateInterpolator(2.0f));
                        enterAnim.setDuration(enterAnimDuration);
                        enterAnim.setFillAfter(true);
                        DialogImpl.this.boxBody.startAnimation(enterAnim);
                        DialogImpl.this.boxRoot.animate().setDuration(enterAnimDuration).alpha(1.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setListener(null);
                    }

                    @Override
                    public void doExitAnim(PopTip dialog, ViewGroup dialogBodyView) {
                        Animation exitAnim = AnimationUtils.loadAnimation((Context)(PopTip.this.getOwnActivity() == null ? DialogImpl.this.boxRoot.getContext() : PopTip.this.getOwnActivity()), (int)(PopTip.this.exitAnimResId == 0 ? R.anim.anim_dialogx_default_exit : PopTip.this.exitAnimResId));
                        long exitAnimDuration = DialogImpl.this.getExitAnimationDuration(exitAnim);
                        exitAnim.setDuration(exitAnimDuration);
                        exitAnim.setFillAfter(true);
                        DialogImpl.this.boxBody.startAnimation(exitAnim);
                        DialogImpl.this.boxRoot.animate().alpha(0.0f).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration(exitAnimDuration);
                    }
                };
            }
            return PopTip.this.dialogXAnimImpl;
        }

        public long getExitAnimationDuration(@Nullable Animation defaultExitAnim) {
            long exitAnimDurationTemp;
            if (defaultExitAnim == null && this.boxBody.getAnimation() != null) {
                defaultExitAnim = this.boxBody.getAnimation();
            }
            long l = exitAnimDurationTemp = defaultExitAnim == null || defaultExitAnim.getDuration() == 0L ? 300L : defaultExitAnim.getDuration();
            if (overrideExitDuration >= 0L) {
                exitAnimDurationTemp = overrideExitDuration;
            }
            if (PopTip.this.exitAnimDuration != -1L) {
                exitAnimDurationTemp = PopTip.this.exitAnimDuration;
            }
            return exitAnimDurationTemp;
        }

        public long getEnterAnimationDuration(@Nullable Animation defaultEnterAnim) {
            long enterAnimDurationTemp;
            if (defaultEnterAnim == null && this.boxBody.getAnimation() != null) {
                defaultEnterAnim = this.boxBody.getAnimation();
            }
            long l = enterAnimDurationTemp = defaultEnterAnim == null || defaultEnterAnim.getDuration() == 0L ? 300L : defaultEnterAnim.getDuration();
            if (overrideEnterDuration >= 0L) {
                enterAnimDurationTemp = overrideEnterDuration;
            }
            if (PopTip.this.enterAnimDuration >= 0L) {
                enterAnimDurationTemp = PopTip.this.enterAnimDuration;
            }
            return enterAnimDurationTemp;
        }
    }
}

