/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.dialogs;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Outline;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.BlurViewType;
import com.kongzue.dialogx.interfaces.DialogConvertViewInterface;
import com.kongzue.dialogx.interfaces.DialogLifecycleCallback;
import com.kongzue.dialogx.interfaces.DialogXAnimInterface;
import com.kongzue.dialogx.interfaces.DialogXRunnable;
import com.kongzue.dialogx.interfaces.DialogXStyle;
import com.kongzue.dialogx.interfaces.NoTouchInterface;
import com.kongzue.dialogx.interfaces.OnBindView;
import com.kongzue.dialogx.interfaces.OnDialogButtonClickListener;
import com.kongzue.dialogx.interfaces.OnSafeInsetsChangeListener;
import com.kongzue.dialogx.util.PopValueAnimator;
import com.kongzue.dialogx.util.TextInfo;
import com.kongzue.dialogx.util.views.DialogXBaseRelativeLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;

public class PopNotification
extends BaseDialog
implements NoTouchInterface {
    public static final int TIME_NO_AUTO_DISMISS_DELAY = -1;
    protected static List<PopNotification> popNotificationList;
    public static long overrideEnterDuration;
    public static long overrideExitDuration;
    public static int overrideEnterAnimRes;
    public static int overrideExitAnimRes;
    protected OnBindView<PopNotification> onBindView;
    protected DialogLifecycleCallback<PopNotification> dialogLifecycleCallback;
    protected PopNotification me = this;
    protected DialogImpl dialogImpl;
    protected int enterAnimResId = 0;
    protected int exitAnimResId = 0;
    protected DialogXStyle.PopNotificationSettings.ALIGN align;
    protected OnDialogButtonClickListener<PopNotification> onButtonClickListener;
    protected OnDialogButtonClickListener<PopNotification> onPopNotificationClickListener;
    protected boolean autoTintIconInLightOrDarkMode = true;
    protected BaseDialog.BOOLEAN tintIcon;
    protected float backgroundRadius = DialogX.defaultPopNotificationBackgroundRadius;
    protected DialogXAnimInterface<PopNotification> dialogXAnimImpl;
    protected int iconResId;
    protected Bitmap iconBitmap;
    protected Drawable iconDrawable;
    protected CharSequence title;
    protected CharSequence message;
    protected CharSequence buttonText;
    protected int iconSize;
    protected boolean slideToClose = true;
    protected TextInfo titleTextInfo;
    protected TextInfo messageTextInfo;
    protected TextInfo buttonTextInfo = new TextInfo().setBold(true);
    protected int[] bodyMargin = new int[]{-1, -1, -1, -1};
    protected Timer autoDismissTimer;
    protected long autoDismissDelay = Long.MIN_VALUE;
    private float defaultTop;
    protected boolean preRecycle = false;

    protected PopNotification() {
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    public static PopNotification build() {
        return new PopNotification();
    }

    public static PopNotification build(DialogXStyle style2) {
        return new PopNotification().setStyle(style2);
    }

    public static PopNotification build(OnBindView<PopNotification> onBindView) {
        return new PopNotification().setCustomView(onBindView);
    }

    public PopNotification(OnBindView<PopNotification> onBindView) {
        this.onBindView = onBindView;
    }

    public PopNotification(CharSequence title) {
        this.title = title;
    }

    public PopNotification(CharSequence title, CharSequence message) {
        this.title = title;
        this.message = message;
    }

    public PopNotification(int titleResId) {
        this.title = this.getString(titleResId);
    }

    public PopNotification(int titleResId, int messageResId) {
        this.title = this.getString(titleResId);
        this.message = this.getString(messageResId);
    }

    public PopNotification(int iconResId, CharSequence title) {
        this.iconResId = iconResId;
        this.title = title;
    }

    public PopNotification(int iconResId, CharSequence title, CharSequence message) {
        this.iconResId = iconResId;
        this.title = title;
        this.message = message;
    }

    public PopNotification(int iconResId, int titleResId, int messageResId) {
        this.iconResId = iconResId;
        this.title = this.getString(titleResId);
        this.message = this.getString(messageResId);
    }

    public PopNotification(CharSequence title, OnBindView<PopNotification> onBindView) {
        this.title = title;
        this.onBindView = onBindView;
    }

    public PopNotification(CharSequence title, CharSequence message, OnBindView<PopNotification> onBindView) {
        this.title = title;
        this.message = message;
        this.onBindView = onBindView;
    }

    public PopNotification(int titleResId, OnBindView<PopNotification> onBindView) {
        this.title = this.getString(titleResId);
        this.onBindView = onBindView;
    }

    public PopNotification(int titleResId, int messageResId, OnBindView<PopNotification> onBindView) {
        this.title = this.getString(titleResId);
        this.message = this.getString(messageResId);
        this.onBindView = onBindView;
    }

    public PopNotification(int iconResId, CharSequence title, OnBindView<PopNotification> onBindView) {
        this.iconResId = iconResId;
        this.title = title;
        this.onBindView = onBindView;
    }

    public PopNotification(int iconResId, CharSequence title, CharSequence message, OnBindView<PopNotification> onBindView) {
        this.iconResId = iconResId;
        this.title = title;
        this.message = message;
        this.onBindView = onBindView;
    }

    public PopNotification(int iconResId, int titleResId, int messageResId, OnBindView<PopNotification> onBindView) {
        this.iconResId = iconResId;
        this.title = this.getString(titleResId);
        this.message = this.getString(messageResId);
        this.onBindView = onBindView;
    }

    public PopNotification(int iconResId, int titleResId, int messageResId, int buttonTextResId) {
        this.iconResId = iconResId;
        this.title = this.getString(titleResId);
        this.message = this.getString(messageResId);
        this.buttonText = this.getString(buttonTextResId);
    }

    public PopNotification(int iconResId, int titleResId, int messageResId, int buttonTextResId, OnBindView<PopNotification> onBindView) {
        this.iconResId = iconResId;
        this.title = this.getString(titleResId);
        this.message = this.getString(messageResId);
        this.buttonText = this.getString(buttonTextResId);
        this.onBindView = onBindView;
    }

    public PopNotification(int iconResId, CharSequence title, CharSequence message, CharSequence buttonText) {
        this.iconResId = iconResId;
        this.title = title;
        this.message = message;
        this.buttonText = buttonText;
    }

    public PopNotification(int iconResId, CharSequence title, CharSequence message, CharSequence buttonText, OnBindView<PopNotification> onBindView) {
        this.iconResId = iconResId;
        this.title = title;
        this.message = message;
        this.buttonText = buttonText;
        this.onBindView = onBindView;
    }

    public static PopNotification show(OnBindView<PopNotification> onBindView) {
        PopNotification popNotification = new PopNotification(onBindView);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(CharSequence title) {
        PopNotification popNotification = new PopNotification(title);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(CharSequence title, CharSequence message) {
        PopNotification popNotification = new PopNotification(title, message);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(int titleResId) {
        PopNotification popNotification = new PopNotification(titleResId);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(int titleResId, int messageResId) {
        PopNotification popNotification = new PopNotification(titleResId, messageResId);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(CharSequence title, OnBindView<PopNotification> onBindView) {
        PopNotification popNotification = new PopNotification(title, onBindView);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(CharSequence title, CharSequence message, OnBindView<PopNotification> onBindView) {
        PopNotification popNotification = new PopNotification(title, message, onBindView);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(int titleResId, OnBindView<PopNotification> onBindView) {
        PopNotification popNotification = new PopNotification(titleResId, onBindView);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(int titleResId, int messageResId, OnBindView<PopNotification> onBindView) {
        PopNotification popNotification = new PopNotification(titleResId, messageResId, onBindView);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(int iconResId, CharSequence title, OnBindView<PopNotification> onBindView) {
        PopNotification popNotification = new PopNotification(iconResId, title, onBindView);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(int iconResId, CharSequence title, CharSequence message, OnBindView<PopNotification> onBindView) {
        PopNotification popNotification = new PopNotification(iconResId, title, message, onBindView);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(int iconResId, CharSequence title) {
        PopNotification popNotification = new PopNotification(iconResId, title);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(int iconResId, CharSequence title, CharSequence message) {
        PopNotification popNotification = new PopNotification(iconResId, title, message);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(int iconResId, int titleResId, int messageResId) {
        PopNotification popNotification = new PopNotification(iconResId, titleResId, messageResId);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(int iconResId, int titleResId, int messageResId, OnBindView<PopNotification> onBindView) {
        PopNotification popNotification = new PopNotification(iconResId, titleResId, messageResId, onBindView);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(int iconResId, int titleResId, int messageResId, int buttonTextResId) {
        PopNotification popNotification = new PopNotification(iconResId, titleResId, messageResId, buttonTextResId);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(int iconResId, int titleResId, int messageResId, int buttonTextResId, OnBindView<PopNotification> onBindView) {
        PopNotification popNotification = new PopNotification(iconResId, titleResId, messageResId, buttonTextResId, onBindView);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(int iconResId, CharSequence title, CharSequence message, CharSequence buttonText) {
        PopNotification popNotification = new PopNotification(iconResId, title, message, buttonText);
        popNotification.show();
        return popNotification;
    }

    public static PopNotification show(int iconResId, CharSequence title, CharSequence message, CharSequence buttonText, OnBindView<PopNotification> onBindView) {
        PopNotification popNotification = new PopNotification(iconResId, title, message, buttonText, onBindView);
        popNotification.show();
        return popNotification;
    }

    public PopNotification show() {
        if (this.isHide && this.getDialogView() != null) {
            this.getDialogView().setVisibility(0);
            return this;
        }
        super.beforeShow();
        if (this.getDialogView() == null) {
            int layoutResId;
            if (DialogX.onlyOnePopNotification) {
                PopNotification oldInstance = null;
                if (popNotificationList != null && !popNotificationList.isEmpty()) {
                    oldInstance = popNotificationList.get(popNotificationList.size() - 1);
                }
                if (oldInstance != null) {
                    oldInstance.dismiss();
                }
            }
            if (popNotificationList == null) {
                popNotificationList = new ArrayList<PopNotification>();
            }
            popNotificationList.add(this);
            int n = layoutResId = this.isLightTheme() ? R.layout.layout_dialogx_popnotification_material : R.layout.layout_dialogx_popnotification_material_dark;
            if (this.style.popNotificationSettings() != null) {
                if (this.style.popNotificationSettings().layout(this.isLightTheme()) != 0) {
                    layoutResId = this.style.popNotificationSettings().layout(this.isLightTheme());
                }
                this.align = this.style.popNotificationSettings().align();
                if (this.align == null) {
                    this.align = DialogXStyle.PopNotificationSettings.ALIGN.TOP;
                }
                int styleEnterAnimResId = this.style.popNotificationSettings().enterAnimResId(this.isLightTheme());
                int styleExitAnimResId = this.style.popNotificationSettings().exitAnimResId(this.isLightTheme());
                int n2 = this.enterAnimResId == 0 ? (overrideEnterAnimRes == 0 ? (styleEnterAnimResId != 0 ? styleEnterAnimResId : R.anim.anim_dialogx_notification_enter) : overrideEnterAnimRes) : (this.enterAnimResId = this.enterAnimResId);
                this.exitAnimResId = this.exitAnimResId == 0 ? (overrideExitAnimRes == 0 ? (styleExitAnimResId != 0 ? styleExitAnimResId : R.anim.anim_dialogx_notification_exit) : overrideExitAnimRes) : this.exitAnimResId;
                this.enterAnimDuration = this.enterAnimDuration == -1L ? overrideEnterDuration : this.enterAnimDuration;
                this.exitAnimDuration = this.exitAnimDuration == -1L ? overrideExitDuration : this.exitAnimDuration;
            }
            View dialogView = this.createView(layoutResId);
            this.dialogImpl = new DialogImpl(dialogView);
            if (dialogView != null) {
                dialogView.setTag((Object)this.me);
            }
            PopNotification.show(dialogView);
        } else {
            PopNotification.show(this.getDialogView());
        }
        return this;
    }

    public PopNotification show(Activity activity) {
        super.beforeShow();
        if (this.getDialogView() != null) {
            int layoutResId;
            if (DialogX.onlyOnePopNotification) {
                PopNotification oldInstance = null;
                if (popNotificationList != null && !popNotificationList.isEmpty()) {
                    oldInstance = popNotificationList.get(popNotificationList.size() - 1);
                }
                if (oldInstance != null) {
                    oldInstance.dismiss();
                }
            }
            if (popNotificationList == null) {
                popNotificationList = new ArrayList<PopNotification>();
            }
            popNotificationList.add(this);
            int n = layoutResId = this.isLightTheme() ? R.layout.layout_dialogx_popnotification_material : R.layout.layout_dialogx_popnotification_material_dark;
            if (this.style.popNotificationSettings() != null) {
                if (this.style.popNotificationSettings().layout(this.isLightTheme()) != 0) {
                    layoutResId = this.style.popNotificationSettings().layout(this.isLightTheme());
                }
                this.align = this.style.popNotificationSettings().align();
                if (this.align == null) {
                    this.align = DialogXStyle.PopNotificationSettings.ALIGN.TOP;
                }
                int styleEnterAnimResId = this.style.popNotificationSettings().enterAnimResId(this.isLightTheme());
                int styleExitAnimResId = this.style.popNotificationSettings().exitAnimResId(this.isLightTheme());
                int n2 = this.enterAnimResId == 0 ? (overrideEnterAnimRes == 0 ? (styleEnterAnimResId != 0 ? styleEnterAnimResId : R.anim.anim_dialogx_notification_enter) : overrideEnterAnimRes) : (this.enterAnimResId = this.enterAnimResId);
                this.exitAnimResId = this.exitAnimResId == 0 ? (overrideExitAnimRes == 0 ? (styleExitAnimResId != 0 ? styleExitAnimResId : R.anim.anim_dialogx_notification_exit) : overrideExitAnimRes) : this.exitAnimResId;
                this.enterAnimDuration = this.enterAnimDuration == -1L ? overrideEnterDuration : this.enterAnimDuration;
                this.exitAnimDuration = this.exitAnimDuration == -1L ? overrideExitDuration : this.exitAnimDuration;
            }
            View dialogView = this.createView(layoutResId);
            this.dialogImpl = new DialogImpl(dialogView);
            if (dialogView != null) {
                dialogView.setTag((Object)this.me);
            }
            PopNotification.show(activity, dialogView);
        } else {
            PopNotification.show(activity, this.getDialogView());
        }
        return this;
    }

    @Override
    public String dialogKey() {
        return this.getClass().getSimpleName() + "(" + Integer.toHexString(this.hashCode()) + ")";
    }

    public PopNotification autoDismiss(long delay) {
        this.autoDismissDelay = delay;
        if (this.autoDismissTimer != null) {
            this.autoDismissTimer.cancel();
        }
        if (delay < 0L) {
            return this;
        }
        this.autoDismissTimer = new Timer();
        this.autoDismissTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                PopNotification.this.dismiss();
            }
        }, delay);
        return this;
    }

    public void resetAutoDismissTimer() {
        this.autoDismiss(this.autoDismissDelay);
    }

    private boolean isNoSetCustomDelay() {
        return this.autoDismissDelay == Long.MIN_VALUE;
    }

    public PopNotification showShort() {
        if (this.isNoSetCustomDelay()) {
            this.autoDismiss(2000L);
        }
        if (!this.preShow && !this.isShow) {
            this.show();
        }
        return this;
    }

    public PopNotification showLong() {
        this.autoDismiss(3500L);
        if (!this.preShow && !this.isShow) {
            this.show();
        }
        return this;
    }

    public PopNotification showAlways() {
        return this.noAutoDismiss();
    }

    public PopNotification noAutoDismiss() {
        this.autoDismiss(-1L);
        return this;
    }

    private void waitForDismiss() {
        this.preRecycle = true;
        if (popNotificationList != null) {
            for (PopNotification popNotification : popNotificationList) {
                if (popNotification.preRecycle) continue;
                return;
            }
            for (PopNotification popNotification : new CopyOnWriteArrayList<PopNotification>(popNotificationList)) {
                PopNotification.dismiss(popNotification.getDialogView());
            }
        }
    }

    private void moveUp(int newDialogHeight) {
        if (this.getDialogImpl() != null && this.getDialogImpl().boxBody != null) {
            ViewGroup bodyView = this.getDialogImpl().boxBody;
            if (this.getDialogImpl() == null || bodyView == null) {
                return;
            }
            if (this.style.popNotificationSettings() != null) {
                this.align = this.style.popNotificationSettings().align();
            }
            if (this.align == null) {
                this.align = DialogXStyle.PopNotificationSettings.ALIGN.TOP;
            }
            float moveAimTop = 0.0f;
            float y = bodyView.getY();
            if (bodyView.getTag() instanceof PopValueAnimator) {
                ((PopValueAnimator)((Object)bodyView.getTag())).end();
                y = ((PopValueAnimator)((Object)bodyView.getTag())).getEndValue();
            }
            switch (this.align) {
                case TOP: {
                    moveAimTop = y + (float)newDialogHeight * 1.1f;
                    break;
                }
                case TOP_INSIDE: {
                    moveAimTop = y + (float)newDialogHeight - (float)bodyView.getPaddingTop();
                    break;
                }
                case BOTTOM: 
                case CENTER: 
                case BOTTOM_INSIDE: {
                    moveAimTop = y - (float)newDialogHeight * 1.1f;
                }
            }
            PopValueAnimator valueAnimator = PopValueAnimator.ofFloat(bodyView.getY(), moveAimTop);
            bodyView.setTag((Object)valueAnimator);
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    if (PopNotification.this.getDialogImpl() == null || !PopNotification.this.isShow) {
                        animation.cancel();
                        return;
                    }
                    ViewGroup bodyView = PopNotification.this.getDialogImpl().boxBody;
                    if (bodyView != null && bodyView.isAttachedToWindow()) {
                        bodyView.setY(PopNotification.this.defaultTop = ((Float)animation.getAnimatedValue()).floatValue());
                    }
                }
            });
            valueAnimator.setDuration(this.enterAnimDuration == -1L ? 300L : this.enterAnimDuration).setInterpolator((TimeInterpolator)new DecelerateInterpolator(2.0f));
            valueAnimator.start();
        }
    }

    @Override
    public void refreshUI() {
        if (this.getDialogImpl() == null) {
            return;
        }
        PopNotification.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (PopNotification.this.dialogImpl != null) {
                    PopNotification.this.dialogImpl.refreshView();
                }
            }
        });
    }

    public void dismiss() {
        PopNotification.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (PopNotification.this.dialogImpl == null) {
                    return;
                }
                PopNotification.this.dialogImpl.doDismiss(null);
            }
        });
    }

    public DialogLifecycleCallback<PopNotification> getDialogLifecycleCallback() {
        return this.dialogLifecycleCallback == null ? new DialogLifecycleCallback<PopNotification>(){} : this.dialogLifecycleCallback;
    }

    public PopNotification setDialogLifecycleCallback(DialogLifecycleCallback<PopNotification> dialogLifecycleCallback) {
        this.dialogLifecycleCallback = dialogLifecycleCallback;
        if (this.isShow) {
            dialogLifecycleCallback.onShow(this.me);
        }
        return this;
    }

    public PopNotification setStyle(DialogXStyle style2) {
        this.style = style2;
        return this;
    }

    public PopNotification setTheme(DialogX.THEME theme) {
        this.theme = theme;
        return this;
    }

    public DialogImpl getDialogImpl() {
        return this.dialogImpl;
    }

    public PopNotification setCustomView(OnBindView<PopNotification> onBindView) {
        this.onBindView = onBindView;
        this.refreshUI();
        return this;
    }

    public View getCustomView() {
        if (this.onBindView == null) {
            return null;
        }
        return this.onBindView.getCustomView();
    }

    public PopNotification removeCustomView() {
        this.onBindView.clean();
        this.refreshUI();
        return this;
    }

    public DialogXStyle.PopNotificationSettings.ALIGN getAlign() {
        return this.align;
    }

    public PopNotification setAlign(DialogXStyle.PopNotificationSettings.ALIGN align) {
        this.align = align;
        return this;
    }

    public int getIconResId() {
        return this.iconResId;
    }

    public PopNotification setIconResId(int iconResId) {
        this.iconResId = iconResId;
        this.refreshUI();
        return this;
    }

    public PopNotification setIcon(Bitmap bitmap) {
        this.iconBitmap = bitmap;
        this.refreshUI();
        return this;
    }

    public PopNotification setIcon(Drawable iconDrawable) {
        this.iconDrawable = iconDrawable;
        return this;
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public PopNotification setIconSize(int iconSize) {
        this.iconSize = iconSize;
        this.refreshUI();
        return this;
    }

    public CharSequence getMessage() {
        return this.message;
    }

    public PopNotification setMessage(CharSequence message) {
        this.message = message;
        this.refreshUI();
        return this;
    }

    public PopNotification setMessage(int messageResId) {
        this.message = this.getString(messageResId);
        this.refreshUI();
        return this;
    }

    public CharSequence getButtonText() {
        return this.buttonText;
    }

    public PopNotification setButton(CharSequence buttonText) {
        this.buttonText = buttonText;
        this.refreshUI();
        return this;
    }

    public PopNotification setButton(int buttonTextResId) {
        this.buttonText = this.getString(buttonTextResId);
        this.refreshUI();
        return this;
    }

    public PopNotification setButton(CharSequence buttonText, OnDialogButtonClickListener<PopNotification> onButtonClickListener) {
        this.buttonText = buttonText;
        this.onButtonClickListener = onButtonClickListener;
        this.refreshUI();
        return this;
    }

    public PopNotification setButton(int buttonTextResId, OnDialogButtonClickListener<PopNotification> onButtonClickListener) {
        this.buttonText = this.getString(buttonTextResId);
        this.onButtonClickListener = onButtonClickListener;
        this.refreshUI();
        return this;
    }

    public PopNotification setButton(OnDialogButtonClickListener<PopNotification> onButtonClickListener) {
        this.onButtonClickListener = onButtonClickListener;
        return this;
    }

    public TextInfo getMessageTextInfo() {
        return this.messageTextInfo;
    }

    public PopNotification setMessageTextInfo(TextInfo messageTextInfo) {
        this.messageTextInfo = messageTextInfo;
        this.refreshUI();
        return this;
    }

    public TextInfo getButtonTextInfo() {
        return this.buttonTextInfo;
    }

    public PopNotification setButtonTextInfo(TextInfo buttonTextInfo) {
        this.buttonTextInfo = buttonTextInfo;
        this.refreshUI();
        return this;
    }

    public OnDialogButtonClickListener<PopNotification> getOnButtonClickListener() {
        return this.onButtonClickListener;
    }

    public PopNotification setOnButtonClickListener(OnDialogButtonClickListener<PopNotification> onButtonClickListener) {
        this.onButtonClickListener = onButtonClickListener;
        return this;
    }

    public boolean isAutoTintIconInLightOrDarkMode() {
        return this.autoTintIconInLightOrDarkMode;
    }

    public PopNotification setAutoTintIconInLightOrDarkMode(boolean autoTintIconInLightOrDarkMode) {
        this.autoTintIconInLightOrDarkMode = autoTintIconInLightOrDarkMode;
        this.refreshUI();
        return this;
    }

    public OnDialogButtonClickListener<PopNotification> getOnPopNotificationClickListener() {
        return this.onPopNotificationClickListener;
    }

    public PopNotification setOnPopNotificationClickListener(OnDialogButtonClickListener<PopNotification> onPopNotificationClickListener) {
        this.onPopNotificationClickListener = onPopNotificationClickListener;
        this.refreshUI();
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public PopNotification setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.refreshUI();
        return this;
    }

    public PopNotification setBackgroundColorRes(@ColorRes int backgroundColorResId) {
        this.backgroundColor = this.getColor(backgroundColorResId);
        this.refreshUI();
        return this;
    }

    public long getEnterAnimDuration() {
        return this.enterAnimDuration;
    }

    public PopNotification setEnterAnimDuration(long enterAnimDuration) {
        this.enterAnimDuration = enterAnimDuration;
        return this;
    }

    public long getExitAnimDuration() {
        return this.exitAnimDuration;
    }

    public PopNotification setExitAnimDuration(long exitAnimDuration) {
        this.exitAnimDuration = exitAnimDuration;
        return this;
    }

    @Override
    public void restartDialog() {
        int layoutResId;
        if (this.getDialogView() != null) {
            PopNotification.dismiss(this.getDialogView());
            this.isShow = false;
        }
        if (this.getDialogImpl().boxCustom != null) {
            this.getDialogImpl().boxCustom.removeAllViews();
        }
        if (DialogX.onlyOnePopNotification) {
            PopNotification oldInstance = null;
            if (popNotificationList != null && !popNotificationList.isEmpty()) {
                oldInstance = popNotificationList.get(popNotificationList.size() - 1);
            }
            if (oldInstance != null) {
                oldInstance.dismiss();
            }
        }
        if (popNotificationList == null) {
            popNotificationList = new ArrayList<PopNotification>();
        }
        popNotificationList.add(this);
        int n = layoutResId = this.isLightTheme() ? R.layout.layout_dialogx_popnotification_material : R.layout.layout_dialogx_popnotification_material_dark;
        if (this.style.popNotificationSettings() != null) {
            if (this.style.popNotificationSettings().layout(this.isLightTheme()) != 0) {
                layoutResId = this.style.popNotificationSettings().layout(this.isLightTheme());
            }
            this.align = this.style.popNotificationSettings().align();
            if (this.align == null) {
                this.align = DialogXStyle.PopNotificationSettings.ALIGN.TOP;
            }
            int styleEnterAnimResId = this.style.popNotificationSettings().enterAnimResId(this.isLightTheme());
            int styleExitAnimResId = this.style.popNotificationSettings().exitAnimResId(this.isLightTheme());
            int n2 = this.enterAnimResId == 0 ? (overrideEnterAnimRes == 0 ? (styleEnterAnimResId != 0 ? styleEnterAnimResId : R.anim.anim_dialogx_notification_enter) : overrideEnterAnimRes) : (this.enterAnimResId = this.enterAnimResId);
            this.exitAnimResId = this.exitAnimResId == 0 ? (overrideExitAnimRes == 0 ? (styleExitAnimResId != 0 ? styleExitAnimResId : R.anim.anim_dialogx_notification_exit) : overrideExitAnimRes) : this.exitAnimResId;
            this.enterAnimDuration = this.enterAnimDuration == -1L ? overrideEnterDuration : this.enterAnimDuration;
            this.exitAnimDuration = this.exitAnimDuration == -1L ? overrideExitDuration : this.exitAnimDuration;
        }
        this.enterAnimDuration = 0L;
        View dialogView = this.createView(layoutResId);
        this.dialogImpl = new DialogImpl(dialogView);
        if (dialogView != null) {
            dialogView.setTag((Object)this.me);
        }
        PopNotification.show(dialogView);
    }

    public void hide() {
        this.isHide = true;
        if (this.getDialogView() != null) {
            this.getDialogView().setVisibility(8);
        }
    }

    public PopNotification setAnimResId(int enterResId, int exitResId) {
        this.enterAnimResId = enterResId;
        this.exitAnimResId = exitResId;
        return this;
    }

    public PopNotification setEnterAnimResId(int enterResId) {
        this.enterAnimResId = enterResId;
        return this;
    }

    public PopNotification setExitAnimResId(int exitResId) {
        this.exitAnimResId = exitResId;
        return this;
    }

    @Override
    protected void shutdown() {
        this.dismiss();
    }

    public PopNotification setDialogImplMode(DialogX.IMPL_MODE dialogImplMode) {
        this.dialogImplMode = dialogImplMode;
        return this;
    }

    public PopNotification setMargin(int left, int top, int right, int bottom) {
        this.bodyMargin[0] = left;
        this.bodyMargin[1] = top;
        this.bodyMargin[2] = right;
        this.bodyMargin[3] = bottom;
        this.refreshUI();
        return this;
    }

    public PopNotification setMarginLeft(int left) {
        this.bodyMargin[0] = left;
        this.refreshUI();
        return this;
    }

    public PopNotification setMarginTop(int top) {
        this.bodyMargin[1] = top;
        this.refreshUI();
        return this;
    }

    public PopNotification setMarginRight(int right) {
        this.bodyMargin[2] = right;
        this.refreshUI();
        return this;
    }

    public PopNotification setMarginBottom(int bottom) {
        this.bodyMargin[3] = bottom;
        this.refreshUI();
        return this;
    }

    public int getMarginLeft() {
        return this.bodyMargin[0];
    }

    public int getMarginTop() {
        return this.bodyMargin[1];
    }

    public int getMarginRight() {
        return this.bodyMargin[2];
    }

    public int getMarginBottom() {
        return this.bodyMargin[3];
    }

    public PopNotification iconSuccess() {
        this.setTintIcon(false);
        int resId = R.mipmap.ico_dialogx_success;
        if (this.getStyle().popNotificationSettings() != null && this.getStyle().popNotificationSettings().defaultIconSuccess() != 0) {
            resId = this.getStyle().popNotificationSettings().defaultIconSuccess();
        }
        this.setIconSize(this.dip2px(26.0f));
        this.setIconResId(resId);
        return this;
    }

    public PopNotification iconWarning() {
        this.setTintIcon(false);
        int resId = R.mipmap.ico_dialogx_warning;
        if (this.getStyle().popNotificationSettings() != null && this.getStyle().popNotificationSettings().defaultIconWarning() != 0) {
            resId = this.getStyle().popNotificationSettings().defaultIconWarning();
        }
        this.setIconSize(this.dip2px(26.0f));
        this.setIconResId(resId);
        return this;
    }

    public PopNotification iconError() {
        this.setTintIcon(false);
        int resId = R.mipmap.ico_dialogx_error;
        if (this.getStyle().popNotificationSettings() != null && this.getStyle().popNotificationSettings().defaultIconError() != 0) {
            resId = this.getStyle().popNotificationSettings().defaultIconError();
        }
        this.setIconSize(this.dip2px(26.0f));
        this.setIconResId(resId);
        return this;
    }

    public boolean getTintIcon() {
        return this.tintIcon == BaseDialog.BOOLEAN.TRUE;
    }

    public PopNotification setTintIcon(boolean tintIcon) {
        this.tintIcon = tintIcon ? BaseDialog.BOOLEAN.TRUE : BaseDialog.BOOLEAN.FALSE;
        this.refreshUI();
        return this;
    }

    public Drawable getIconDrawable() {
        return this.iconDrawable;
    }

    public Bitmap getIconBitmap() {
        return this.iconBitmap;
    }

    public CharSequence getTitle() {
        return this.title;
    }

    public PopNotification setTitle(CharSequence title) {
        this.title = title;
        this.refreshUI();
        return this;
    }

    public TextInfo getTitleTextInfo() {
        return this.titleTextInfo;
    }

    public PopNotification setTitleTextInfo(TextInfo titleTextInfo) {
        this.titleTextInfo = titleTextInfo;
        this.refreshUI();
        return this;
    }

    public PopNotification setRadius(float radiusPx) {
        this.backgroundRadius = radiusPx;
        this.refreshUI();
        return this;
    }

    public float getRadius() {
        return this.backgroundRadius;
    }

    public DialogXAnimInterface<PopNotification> getDialogXAnimImpl() {
        return this.dialogXAnimImpl;
    }

    public PopNotification setDialogXAnimImpl(DialogXAnimInterface<PopNotification> dialogXAnimImpl) {
        this.dialogXAnimImpl = dialogXAnimImpl;
        return this;
    }

    public PopNotification setRootPadding(int padding) {
        this.screenPaddings = new int[]{padding, padding, padding, padding};
        this.refreshUI();
        return this;
    }

    public PopNotification setRootPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.screenPaddings = new int[]{paddingLeft, paddingTop, paddingRight, paddingBottom};
        this.refreshUI();
        return this;
    }

    public PopNotification setHapticFeedbackEnabled(boolean isHapticFeedbackEnabled) {
        this.isHapticFeedbackEnabled = isHapticFeedbackEnabled ? 1 : 0;
        return this;
    }

    public boolean isSlideToClose() {
        return this.slideToClose;
    }

    public PopNotification setSlideToClose(boolean slideToClose) {
        this.slideToClose = slideToClose;
        this.refreshUI();
        return this;
    }

    protected void onShow(PopNotification dialog) {
    }

    protected void onDismiss(PopNotification dialog) {
    }

    @Override
    public PopNotification setData(String key, Object obj) {
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.data.put(key, obj);
        return this;
    }

    public PopNotification onShow(DialogXRunnable<PopNotification> dialogXRunnable) {
        this.onShowRunnable = dialogXRunnable;
        if (this.isShow() && this.onShowRunnable != null) {
            this.onShowRunnable.run(this);
        }
        return this;
    }

    public PopNotification onDismiss(DialogXRunnable<PopNotification> dialogXRunnable) {
        this.onDismissRunnable = dialogXRunnable;
        return this;
    }

    public PopNotification appendMessage(CharSequence message) {
        this.message = TextUtils.concat((CharSequence[])new CharSequence[]{this.message, message});
        this.refreshUI();
        return this;
    }

    @Override
    public PopNotification setThisOrderIndex(int orderIndex) {
        this.thisOrderIndex = orderIndex;
        if (this.getDialogView() != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.getDialogView().setTranslationZ((float)orderIndex);
            } else {
                PopNotification.error("DialogX: " + this.dialogKey() + " \u6267\u884c .setThisOrderIndex(" + orderIndex + ") \u5931\u8d25\uff1a\u7cfb\u7edf\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0cSDK-API \u7248\u672c\u5fc5\u987b\u5927\u4e8e 21\uff08LOLLIPOP\uff09");
            }
        }
        return this;
    }

    public PopNotification bringToFront() {
        this.setThisOrderIndex(this.getHighestOrderIndex());
        return this;
    }

    static {
        overrideEnterDuration = -1L;
        overrideExitDuration = -1L;
        overrideEnterAnimRes = 0;
        overrideExitAnimRes = 0;
    }

    public class DialogImpl
    implements DialogConvertViewInterface {
        public DialogXBaseRelativeLayout boxRoot;
        public ViewGroup boxBody;
        public ImageView imgDialogxPopIcon;
        public TextView txtDialogxPopTitle;
        public TextView txtDialogxPopMessage;
        public TextView txtDialogxButton;
        public RelativeLayout boxCustom;
        private List<View> blurViews;

        public DialogImpl(View convertView) {
            if (convertView == null) {
                return;
            }
            PopNotification.this.setDialogView(convertView);
            this.boxRoot = (DialogXBaseRelativeLayout)convertView.findViewById(R.id.box_root);
            this.boxBody = (ViewGroup)convertView.findViewById(R.id.box_body);
            this.imgDialogxPopIcon = (ImageView)convertView.findViewById(R.id.img_dialogx_pop_icon);
            this.txtDialogxPopTitle = (TextView)convertView.findViewById(R.id.txt_dialogx_pop_title);
            this.txtDialogxPopMessage = (TextView)convertView.findViewById(R.id.txt_dialogx_pop_message);
            this.txtDialogxButton = (TextView)convertView.findViewById(R.id.txt_dialogx_button);
            this.boxCustom = (RelativeLayout)convertView.findViewById(R.id.box_custom);
            this.blurViews = PopNotification.this.findAllBlurView(convertView);
            this.init();
            PopNotification.this.dialogImpl = this;
            this.refreshView();
        }

        @Override
        public void init() {
            if (PopNotification.this.titleTextInfo == null) {
                PopNotification.this.titleTextInfo = DialogX.titleTextInfo;
            }
            if (PopNotification.this.messageTextInfo == null) {
                PopNotification.this.messageTextInfo = DialogX.messageTextInfo;
            }
            if (PopNotification.this.buttonTextInfo == null) {
                PopNotification.this.buttonTextInfo = DialogX.buttonTextInfo;
            }
            if (PopNotification.this.backgroundColor == null) {
                PopNotification.this.backgroundColor = DialogX.backgroundColor;
            }
            if (Build.VERSION.SDK_INT >= 21) {
                PopNotification.this.getDialogView().setTranslationZ((float)PopNotification.this.getThisOrderIndex());
            }
            if (PopNotification.this.autoDismissTimer == null) {
                PopNotification.this.showShort();
            }
            this.boxRoot.setClickable(false);
            this.boxRoot.setFocusable(false);
            this.boxRoot.setParentDialog(PopNotification.this.me);
            this.boxRoot.setAutoUnsafePlacePadding(false);
            this.boxRoot.setOnLifecycleCallBack(new DialogXBaseRelativeLayout.OnLifecycleCallBack(){

                @Override
                public void onShow() {
                    PopNotification.this.isShow = true;
                    PopNotification.this.preShow = false;
                    PopNotification.this.setLifecycleState(Lifecycle.State.CREATED);
                    DialogImpl.this.boxRoot.setAlpha(0.0f);
                    PopNotification.this.onDialogShow();
                    PopNotification.this.getDialogLifecycleCallback().onShow(PopNotification.this.me);
                    PopNotification.this.onShow(PopNotification.this.me);
                }

                @Override
                public void onDismiss() {
                    if (popNotificationList != null) {
                        popNotificationList.remove(PopNotification.this);
                        if (popNotificationList.isEmpty()) {
                            popNotificationList = null;
                        }
                    }
                    if (PopNotification.this.autoDismissTimer != null) {
                        PopNotification.this.autoDismissTimer.cancel();
                    }
                    PopNotification.this.isShow = false;
                    PopNotification.this.getDialogLifecycleCallback().onDismiss(PopNotification.this.me);
                    PopNotification.this.onDismiss(PopNotification.this.me);
                    PopNotification.this.dialogImpl = null;
                    PopNotification.this.setLifecycleState(Lifecycle.State.DESTROYED);
                    System.gc();
                }
            });
            RelativeLayout.LayoutParams rlp = (RelativeLayout.LayoutParams)this.boxBody.getLayoutParams();
            if (PopNotification.this.align == null) {
                PopNotification.this.align = DialogXStyle.PopNotificationSettings.ALIGN.TOP;
            }
            switch (PopNotification.this.align) {
                case TOP: {
                    rlp.removeRule(13);
                    rlp.addRule(10);
                    break;
                }
                case BOTTOM: {
                    rlp.removeRule(13);
                    rlp.addRule(12);
                    this.boxRoot.setAutoUnsafePlacePadding(true);
                    break;
                }
                case CENTER: {
                    rlp.removeRule(10);
                    rlp.removeRule(12);
                    rlp.addRule(13);
                }
            }
            this.boxBody.setLayoutParams((ViewGroup.LayoutParams)rlp);
            this.boxRoot.setOnSafeInsetsChangeListener(new OnSafeInsetsChangeListener(){

                @Override
                public void onChange(Rect unsafeRect) {
                    if (PopNotification.this.align == DialogXStyle.PopNotificationSettings.ALIGN.TOP) {
                        DialogImpl.this.boxBody.setY(PopNotification.this.defaultTop == 0.0f ? (PopNotification.this.defaultTop = unsafeRect.top + PopNotification.this.bodyMargin[1]) : PopNotification.this.defaultTop);
                    } else if (PopNotification.this.align == DialogXStyle.PopNotificationSettings.ALIGN.TOP_INSIDE) {
                        DialogImpl.this.boxBody.setPadding(0, unsafeRect.top, 0, 0);
                    }
                }
            });
            this.boxRoot.setOnBackPressedListener(new DialogXBaseRelativeLayout.PrivateBackPressedListener(){

                @Override
                public boolean onBackPressed() {
                    return false;
                }
            });
            this.boxRoot.post(new Runnable(){

                @Override
                public void run() {
                    DialogImpl.this.getDialogXAnimImpl().doShowAnim(PopNotification.this.me, DialogImpl.this.boxBody);
                    if (!DialogX.onlyOnePopNotification && popNotificationList != null) {
                        for (int i = 0; i < popNotificationList.size() - 1; ++i) {
                            PopNotification popInstance = popNotificationList.get(i);
                            popInstance.moveUp(DialogImpl.this.boxBody.getHeight());
                        }
                    }
                    Integer blurFrontColor = null;
                    Float popNotificationRadius = null;
                    if (PopNotification.this.getStyle().popNotificationSettings() != null && PopNotification.this.getStyle().popNotificationSettings().blurBackgroundSettings() != null && PopNotification.this.getStyle().popNotificationSettings().blurBackgroundSettings().blurBackground()) {
                        blurFrontColor = PopNotification.this.backgroundColor == null ? PopNotification.this.getColorNullable(PopNotification.this.getIntStyleAttr(PopNotification.this.getStyle().popNotificationSettings().blurBackgroundSettings().blurForwardColorRes(PopNotification.this.isLightTheme()))) : PopNotification.this.backgroundColor;
                        popNotificationRadius = PopNotification.this.getFloatStyleAttr(Float.valueOf(PopNotification.this.getStyle().popNotificationSettings().blurBackgroundSettings().blurBackgroundRoundRadiusPx()));
                    }
                    if (DialogImpl.this.blurViews != null) {
                        for (View blurView : DialogImpl.this.blurViews) {
                            ((BlurViewType)blurView).setOverlayColor(PopNotification.this.backgroundColor == null ? blurFrontColor : PopNotification.this.backgroundColor);
                            ((BlurViewType)blurView).setRadiusPx(popNotificationRadius);
                        }
                    }
                    PopNotification.this.setLifecycleState(Lifecycle.State.RESUMED);
                }
            });
            this.boxBody.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PopNotification.this.haptic(v);
                    if (PopNotification.this.onPopNotificationClickListener != null) {
                        if (!PopNotification.this.onPopNotificationClickListener.onClick(PopNotification.this.me, v)) {
                            PopNotification.this.dismiss();
                        }
                    } else {
                        PopNotification.this.dismiss();
                    }
                }
            });
            this.txtDialogxButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PopNotification.this.haptic(v);
                    if (PopNotification.this.onButtonClickListener != null) {
                        if (!PopNotification.this.onButtonClickListener.onClick(PopNotification.this.me, v)) {
                            DialogImpl.this.doDismiss(v);
                        }
                    } else {
                        DialogImpl.this.doDismiss(v);
                    }
                }
            });
            PopNotification.this.onDialogInit();
        }

        @Override
        public void refreshView() {
            if (this.boxRoot == null) {
                return;
            }
            this.boxRoot.setRootPadding(PopNotification.this.screenPaddings[0], PopNotification.this.screenPaddings[1], PopNotification.this.screenPaddings[2], PopNotification.this.screenPaddings[3]);
            if (PopNotification.this.backgroundColor != null) {
                PopNotification.this.tintColor((View)this.boxBody, PopNotification.this.backgroundColor);
                if (this.blurViews != null) {
                    for (View blurView : this.blurViews) {
                        ((BlurViewType)blurView).setOverlayColor(PopNotification.this.backgroundColor);
                    }
                }
            }
            if (PopNotification.this.onBindView != null && PopNotification.this.onBindView.getCustomView() != null) {
                PopNotification.this.onBindView.bindParent((ViewGroup)this.boxCustom, PopNotification.this.me);
                this.boxCustom.setVisibility(0);
            } else {
                this.boxCustom.setVisibility(8);
            }
            if (PopNotification.this.backgroundRadius > -1.0f) {
                Object gradientDrawable;
                if (this.boxBody.getBackground() instanceof GradientDrawable && (gradientDrawable = (GradientDrawable)this.boxBody.getBackground()) != null) {
                    gradientDrawable.setCornerRadius(PopNotification.this.backgroundRadius);
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    this.boxBody.setOutlineProvider(new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), PopNotification.this.backgroundRadius);
                        }
                    });
                    this.boxBody.setClipToOutline(true);
                }
                if (this.blurViews != null) {
                    for (View blurView : this.blurViews) {
                        ((BlurViewType)blurView).setRadiusPx(Float.valueOf(PopNotification.this.backgroundRadius));
                    }
                }
            }
            PopNotification.this.showText(this.txtDialogxPopTitle, PopNotification.this.title);
            PopNotification.this.showText(this.txtDialogxPopMessage, PopNotification.this.message);
            PopNotification.this.showText(this.txtDialogxButton, PopNotification.this.buttonText);
            BaseDialog.useTextInfo(this.txtDialogxPopTitle, PopNotification.this.titleTextInfo);
            BaseDialog.useTextInfo(this.txtDialogxPopMessage, PopNotification.this.messageTextInfo);
            BaseDialog.useTextInfo(this.txtDialogxButton, PopNotification.this.buttonTextInfo);
            if (PopNotification.this.iconBitmap != null && !PopNotification.this.iconBitmap.isRecycled()) {
                this.imgDialogxPopIcon.setVisibility(0);
                this.imgDialogxPopIcon.setImageBitmap(PopNotification.this.iconBitmap);
            } else if (PopNotification.this.iconDrawable != null) {
                this.imgDialogxPopIcon.setVisibility(0);
                this.imgDialogxPopIcon.setImageDrawable(PopNotification.this.iconDrawable);
            } else if (PopNotification.this.iconResId != 0) {
                this.imgDialogxPopIcon.setVisibility(0);
                this.imgDialogxPopIcon.setImageResource(PopNotification.this.iconResId);
            } else {
                this.imgDialogxPopIcon.setVisibility(8);
            }
            if (Build.VERSION.SDK_INT >= 21 && PopNotification.this.tintIcon == BaseDialog.BOOLEAN.TRUE) {
                if (PopNotification.this.autoTintIconInLightOrDarkMode) {
                    this.imgDialogxPopIcon.setImageTintList(this.txtDialogxPopTitle.getTextColors());
                } else {
                    this.imgDialogxPopIcon.setImageTintList(null);
                }
            } else if (Build.VERSION.SDK_INT >= 21) {
                this.imgDialogxPopIcon.setImageTintList(null);
            }
            if (PopNotification.this.iconSize > 0) {
                ViewGroup.LayoutParams iLp = this.imgDialogxPopIcon.getLayoutParams();
                iLp.width = PopNotification.this.iconSize;
                iLp.height = PopNotification.this.iconSize;
                this.imgDialogxPopIcon.setLayoutParams(iLp);
            }
            if (PopNotification.this.slideToClose) {
                this.boxBody.setOnTouchListener(new View.OnTouchListener(){
                    boolean touchDown;
                    float touchY;

                    public boolean onTouch(View v, MotionEvent event) {
                        switch (event.getAction()) {
                            case 0: {
                                this.touchDown = true;
                                this.touchY = event.getY();
                                break;
                            }
                            case 2: {
                                if (!this.touchDown) break;
                                float deltaY = event.getY() - this.touchY;
                                if (DialogImpl.this.boxBody.getY() + deltaY < PopNotification.this.defaultTop) {
                                    DialogImpl.this.boxBody.setY(DialogImpl.this.boxBody.getY() + deltaY);
                                    break;
                                }
                                DialogImpl.this.boxBody.setY(PopNotification.this.defaultTop);
                                break;
                            }
                            case 1: 
                            case 3: {
                                if (DialogImpl.this.boxBody.getY() < PopNotification.this.defaultTop - (float)DialogX.touchSlideTriggerThreshold) {
                                    DialogImpl.this.doDismiss(v);
                                    break;
                                }
                                PopValueAnimator valueAnimator = PopValueAnimator.ofFloat(DialogImpl.this.boxBody.getY(), PopNotification.this.defaultTop);
                                DialogImpl.this.boxBody.setTag((Object)valueAnimator);
                                valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                                    public void onAnimationUpdate(ValueAnimator animation) {
                                        if (PopNotification.this.getDialogImpl() == null || !PopNotification.this.isShow) {
                                            animation.cancel();
                                            return;
                                        }
                                        ViewGroup bodyView = PopNotification.this.getDialogImpl().boxBody;
                                        if (bodyView != null && bodyView.isAttachedToWindow()) {
                                            bodyView.setY(((Float)animation.getAnimatedValue()).floatValue());
                                        }
                                    }
                                });
                                valueAnimator.setDuration(PopNotification.this.enterAnimDuration == -1L ? 300L : PopNotification.this.enterAnimDuration).setInterpolator((TimeInterpolator)new DecelerateInterpolator(2.0f));
                                valueAnimator.start();
                                if (!(Math.abs(DialogImpl.this.boxBody.getY() - PopNotification.this.defaultTop) <= 1.0f) || !(event.getY() <= this.touchY)) break;
                                DialogImpl.this.boxBody.callOnClick();
                            }
                        }
                        return true;
                    }
                });
            } else {
                this.boxBody.setOnTouchListener(null);
            }
            RelativeLayout.LayoutParams rlp = (RelativeLayout.LayoutParams)this.boxBody.getLayoutParams();
            if (PopNotification.this.bodyMargin[0] != -1) {
                rlp.leftMargin = PopNotification.this.bodyMargin[0];
            }
            if (PopNotification.this.bodyMargin[1] != -1) {
                rlp.topMargin = PopNotification.this.bodyMargin[1];
            }
            if (PopNotification.this.bodyMargin[2] != -1) {
                rlp.rightMargin = PopNotification.this.bodyMargin[2];
            }
            if (PopNotification.this.bodyMargin[3] != -1) {
                rlp.bottomMargin = PopNotification.this.bodyMargin[3];
            }
            this.boxBody.setLayoutParams((ViewGroup.LayoutParams)rlp);
            PopNotification.this.onDialogRefreshUI();
        }

        @Override
        public void doDismiss(View v) {
            if (PopNotification.this.preDismiss(PopNotification.this)) {
                return;
            }
            if (v != null) {
                v.setEnabled(false);
            }
            if (!PopNotification.this.dismissAnimFlag && this.boxRoot != null) {
                PopNotification.this.dismissAnimFlag = true;
                this.boxRoot.post(new Runnable(){

                    @Override
                    public void run() {
                        DialogImpl.this.getDialogXAnimImpl().doExitAnim(PopNotification.this.me, DialogImpl.this.boxBody);
                        PopNotification.runOnMainDelay(new Runnable(){

                            @Override
                            public void run() {
                                PopNotification.this.waitForDismiss();
                            }
                        }, DialogImpl.this.getExitAnimationDuration(null));
                    }
                });
            }
        }

        protected DialogXAnimInterface<PopNotification> getDialogXAnimImpl() {
            if (PopNotification.this.dialogXAnimImpl == null) {
                PopNotification.this.dialogXAnimImpl = new DialogXAnimInterface<PopNotification>(){

                    @Override
                    public void doShowAnim(PopNotification dialog, ViewGroup dialogBodyView) {
                        Animation enterAnim = AnimationUtils.loadAnimation((Context)BaseDialog.getApplicationContext(), (int)(PopNotification.this.enterAnimResId == 0 ? R.anim.anim_dialogx_notification_enter : PopNotification.this.enterAnimResId));
                        long enterAnimDuration = DialogImpl.this.getEnterAnimationDuration(enterAnim);
                        enterAnim.setInterpolator((Interpolator)new DecelerateInterpolator(2.0f));
                        enterAnim.setDuration(enterAnimDuration);
                        enterAnim.setFillAfter(true);
                        DialogImpl.this.boxBody.startAnimation(enterAnim);
                        DialogImpl.this.boxRoot.animate().setDuration(enterAnimDuration).alpha(1.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setListener(null);
                    }

                    @Override
                    public void doExitAnim(PopNotification dialog, ViewGroup dialogBodyView) {
                        Animation exitAnim = AnimationUtils.loadAnimation((Context)(BaseDialog.getApplicationContext() == null ? DialogImpl.this.boxRoot.getContext() : BaseDialog.getApplicationContext()), (int)(PopNotification.this.exitAnimResId == 0 ? R.anim.anim_dialogx_notification_exit : PopNotification.this.exitAnimResId));
                        long exitAnimDuration = DialogImpl.this.getExitAnimationDuration(exitAnim);
                        exitAnim.setDuration(exitAnimDuration);
                        exitAnim.setFillAfter(true);
                        DialogImpl.this.boxBody.startAnimation(exitAnim);
                        DialogImpl.this.boxRoot.animate().alpha(0.0f).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration(exitAnimDuration);
                    }
                };
            }
            return PopNotification.this.dialogXAnimImpl;
        }

        public long getExitAnimationDuration(@Nullable Animation defaultExitAnim) {
            long exitAnimDurationTemp;
            if (defaultExitAnim == null && this.boxBody.getAnimation() != null) {
                defaultExitAnim = this.boxBody.getAnimation();
            }
            long l = exitAnimDurationTemp = defaultExitAnim == null || defaultExitAnim.getDuration() == 0L ? 300L : defaultExitAnim.getDuration();
            if (overrideExitDuration >= 0L) {
                exitAnimDurationTemp = overrideExitDuration;
            }
            if (PopNotification.this.exitAnimDuration != -1L) {
                exitAnimDurationTemp = PopNotification.this.exitAnimDuration;
            }
            return exitAnimDurationTemp;
        }

        public long getEnterAnimationDuration(@Nullable Animation defaultEnterAnim) {
            long enterAnimDurationTemp;
            if (defaultEnterAnim == null && this.boxBody.getAnimation() != null) {
                defaultEnterAnim = this.boxBody.getAnimation();
            }
            long l = enterAnimDurationTemp = defaultEnterAnim == null || defaultEnterAnim.getDuration() == 0L ? 300L : defaultEnterAnim.getDuration();
            if (overrideEnterDuration >= 0L) {
                enterAnimDurationTemp = overrideEnterDuration;
            }
            if (PopNotification.this.enterAnimDuration >= 0L) {
                enterAnimDurationTemp = PopNotification.this.enterAnimDuration;
            }
            return enterAnimDurationTemp;
        }
    }
}

