/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.dialogs;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Outline;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.BlurViewType;
import com.kongzue.dialogx.interfaces.DialogConvertViewInterface;
import com.kongzue.dialogx.interfaces.DialogLifecycleCallback;
import com.kongzue.dialogx.interfaces.DialogXAnimInterface;
import com.kongzue.dialogx.interfaces.DialogXRunnable;
import com.kongzue.dialogx.interfaces.DialogXStyle;
import com.kongzue.dialogx.interfaces.MenuItemLayoutRefreshCallback;
import com.kongzue.dialogx.interfaces.OnBackPressedListener;
import com.kongzue.dialogx.interfaces.OnBackgroundMaskClickListener;
import com.kongzue.dialogx.interfaces.OnBindView;
import com.kongzue.dialogx.interfaces.OnIconChangeCallBack;
import com.kongzue.dialogx.interfaces.OnMenuItemClickListener;
import com.kongzue.dialogx.util.DialogXViewLoc;
import com.kongzue.dialogx.util.PopMenuArrayAdapter;
import com.kongzue.dialogx.util.TextInfo;
import com.kongzue.dialogx.util.views.DialogXBaseRelativeLayout;
import com.kongzue.dialogx.util.views.MaxRelativeLayout;
import com.kongzue.dialogx.util.views.PopMenuListView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PopMenu
extends BaseDialog {
    public static long overrideEnterDuration = -1L;
    public static long overrideExitDuration = -1L;
    protected PopMenu me = this;
    protected boolean bkgInterceptTouch = true;
    protected OnBindView<PopMenu> onBindView;
    protected DialogLifecycleCallback<PopMenu> dialogLifecycleCallback;
    protected OnBackgroundMaskClickListener<PopMenu> onBackgroundMaskClickListener;
    protected List<CharSequence> menuList;
    protected List<Integer> iconResIds;
    protected boolean autoTintIconInLightOrDarkMode = true;
    protected DialogImpl dialogImpl;
    protected WeakReference<View> baseViewWeakReference;
    protected boolean overlayBaseView = true;
    protected OnMenuItemClickListener<PopMenu> onMenuItemClickListener;
    protected OnIconChangeCallBack<PopMenu> onIconChangeCallBack;
    protected int width = -1;
    protected int height = -1;
    protected TextInfo menuTextInfo;
    protected boolean offScreen = false;
    protected float backgroundRadius = DialogX.defaultPopMenuBackgroundRadius;
    protected DialogXAnimInterface<PopMenu> dialogXAnimImpl;
    protected OnBackPressedListener<PopMenu> onBackPressedListener;
    protected MenuItemLayoutRefreshCallback<PopMenu> menuMenuItemLayoutRefreshCallback;
    protected int pressedIndex = -1;
    protected Map<Integer, Boolean> menuUsability = new HashMap<Integer, Boolean>();
    protected int alignGravity = -1;
    protected DialogXViewLoc baseViewLoc = new DialogXViewLoc();
    private int selectIndex;
    public boolean notCheckHash = false;
    public int lastHash = -1;
    private ViewTreeObserver viewTreeObserver;
    private ViewTreeObserver.OnDrawListener baseViewDrawListener;
    protected PopMenuArrayAdapter menuListAdapter;
    protected int selectItemYDeviation;
    protected boolean isEnterAnimRunning;
    private boolean closing;
    protected boolean hideWithExitAnim;

    public PopMenu() {
    }

    public PopMenu(View baseView, List<CharSequence> menuList) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(menuList);
        this.baseView(baseView);
    }

    public PopMenu(View baseView, CharSequence[] menuList) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(Arrays.asList(menuList));
        this.baseView(baseView);
    }

    public PopMenu(List<CharSequence> menuList) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(menuList);
    }

    public PopMenu(CharSequence ... menuList) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(Arrays.asList(menuList));
    }

    public PopMenu(String ... menuList) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(Arrays.asList(menuList));
    }

    public PopMenu(OnBindView<PopMenu> onBindView) {
        this.onBindView = onBindView;
    }

    public PopMenu(View baseView, OnBindView<PopMenu> onBindView) {
        this.baseView(baseView);
        this.onBindView = onBindView;
    }

    public PopMenu(View baseView, List<CharSequence> menuList, OnBindView<PopMenu> onBindView) {
        this.baseView(baseView);
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(menuList);
        this.onBindView = onBindView;
    }

    public PopMenu(View baseView, CharSequence[] menuList, OnBindView<PopMenu> onBindView) {
        this.baseView(baseView);
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(Arrays.asList(menuList));
        this.onBindView = onBindView;
    }

    public PopMenu(List<CharSequence> menuList, OnBindView<PopMenu> onBindView) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(menuList);
        this.onBindView = onBindView;
    }

    public PopMenu(CharSequence[] menuList, OnBindView<PopMenu> onBindView) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(Arrays.asList(menuList));
        this.onBindView = onBindView;
    }

    public static PopMenu build() {
        return new PopMenu();
    }

    public static PopMenu build(DialogXStyle style2) {
        return new PopMenu().setStyle(style2);
    }

    public static PopMenu show(CharSequence ... menus) {
        PopMenu popMenu = new PopMenu(menus);
        popMenu.show();
        return popMenu;
    }

    public static PopMenu show(String ... menus) {
        PopMenu popMenu = new PopMenu(menus);
        popMenu.show();
        return popMenu;
    }

    public static PopMenu show(List<CharSequence> menuList) {
        PopMenu popMenu = new PopMenu(menuList);
        popMenu.show();
        return popMenu;
    }

    public static PopMenu show(View baseView, CharSequence[] menus) {
        PopMenu popMenu = new PopMenu(baseView, menus);
        popMenu.show();
        return popMenu;
    }

    public static PopMenu show(View baseView, List<CharSequence> menuList) {
        PopMenu popMenu = new PopMenu(baseView, menuList);
        popMenu.show();
        return popMenu;
    }

    public static PopMenu show(View baseView, CharSequence[] menus, OnBindView<PopMenu> onBindView) {
        PopMenu popMenu = new PopMenu(baseView, menus, onBindView);
        popMenu.show();
        return popMenu;
    }

    public static PopMenu show(View baseView, List<CharSequence> menuList, OnBindView<PopMenu> onBindView) {
        PopMenu popMenu = new PopMenu(baseView, menuList, onBindView);
        popMenu.show();
        return popMenu;
    }

    public static PopMenu show(CharSequence[] menus, OnBindView<PopMenu> onBindView) {
        PopMenu popMenu = new PopMenu(menus, onBindView);
        popMenu.show();
        return popMenu;
    }

    public static PopMenu show(List<CharSequence> menuList, OnBindView<PopMenu> onBindView) {
        PopMenu popMenu = new PopMenu(menuList, onBindView);
        popMenu.show();
        return popMenu;
    }

    public PopMenu show() {
        if (this.isHide && this.getDialogView() != null && this.isShow) {
            if (this.hideWithExitAnim && this.getDialogImpl() != null) {
                this.getDialogImpl().boxBody.clearAnimation();
                this.getDialogView().setVisibility(0);
                this.getDialogImpl().boxRoot.animate().alpha(1.0f);
                this.getDialogImpl().getDialogXAnimImpl().doShowAnim(this.me, (ViewGroup)this.getDialogImpl().boxBody);
            } else {
                this.getDialogView().setVisibility(0);
            }
            return this;
        }
        super.beforeShow();
        if (this.getDialogView() == null) {
            int layoutId;
            int n = layoutId = this.isLightTheme() ? R.layout.layout_dialogx_popmenu_material : R.layout.layout_dialogx_popmenu_material_dark;
            if (this.getStyle().popMenuSettings() != null && this.getStyle().popMenuSettings().layout(this.isLightTheme()) != 0) {
                layoutId = this.getStyle().popMenuSettings().layout(this.isLightTheme());
            }
            View dialogView = this.createView(layoutId);
            this.dialogImpl = new DialogImpl(dialogView);
            if (dialogView != null) {
                dialogView.setTag((Object)this.me);
            }
            PopMenu.show(dialogView);
        } else {
            PopMenu.show(this.getDialogView());
        }
        if (this.baseView() != null) {
            this.viewTreeObserver = this.baseView().getViewTreeObserver();
            this.baseViewDrawListener = new ViewTreeObserver.OnDrawListener(){

                public void onDraw() {
                    int[] baseViewLocCache = new int[2];
                    if (PopMenu.this.baseView() != null) {
                        PopMenu.this.baseView().getLocationInWindow(baseViewLocCache);
                        if (PopMenu.this.getDialogImpl() != null && !PopMenu.this.baseViewLoc.isSameLoc(baseViewLocCache) && PopMenu.this.baseView().getVisibility() == 0) {
                            PopMenu.this.baseViewLoc.set(baseViewLocCache);
                            PopMenu.this.refreshMenuLoc();
                        }
                    } else if (PopMenu.this.viewTreeObserver != null) {
                        PopMenu.this.removeDrawListener(PopMenu.this.viewTreeObserver, this);
                        PopMenu.this.viewTreeObserver = null;
                        PopMenu.this.baseViewDrawListener = null;
                    }
                }
            };
            this.viewTreeObserver.addOnDrawListener(this.baseViewDrawListener);
        }
        return this;
    }

    private void refreshMenuLoc() {
        if (this.getDialogImpl() == null || this.getDialogImpl().boxRoot == null) {
            return;
        }
        this.getDialogImpl().boxBody.setTag(null);
        DialogXViewLoc loc = this.getMenuLoc();
        this.getDialogImpl().boxBody.setTag(loc);
        if (!this.isEnterAnimRunning) {
            if (loc.getX() != this.getDialogImpl().boxBody.getX()) {
                this.getDialogImpl().boxBody.setX(loc.getX());
            }
            if (loc.getY() != this.getDialogImpl().boxBody.getY()) {
                this.getDialogImpl().boxBody.setY(loc.getY());
            }
        }
        if ((float)this.getDialogImpl().boxBody.getWidth() != loc.getW()) {
            RelativeLayout.LayoutParams rLp = new RelativeLayout.LayoutParams((int)loc.getW(), -2);
            this.getDialogImpl().boxBody.setLayoutParams((ViewGroup.LayoutParams)rLp);
        }
    }

    protected DialogXViewLoc getMenuLoc() {
        if (this.getDialogImpl().boxBody.getTag() instanceof DialogXViewLoc) {
            return (DialogXViewLoc)this.getDialogImpl().boxBody.getTag();
        }
        DialogXViewLoc result = new DialogXViewLoc();
        MaxRelativeLayout boxBody = this.getDialogImpl().boxBody;
        DialogXBaseRelativeLayout boxRoot = this.getDialogImpl().boxRoot;
        int baseViewLeft = (int)this.baseViewLoc.getX();
        int baseViewTop = (int)this.baseViewLoc.getY();
        int calX = 0;
        int calY = 0;
        if (this.alignGravity != -1) {
            if (this.isAlignGravity(16)) {
                calY = Math.max(0, baseViewTop + this.baseView().getMeasuredHeight() / 2 - boxBody.getHeight() / 2);
            }
            if (this.isAlignGravity(1)) {
                calX = Math.max(0, baseViewLeft + (this.getWidth() > 0 ? this.baseView().getMeasuredWidth() / 2 - this.getWidth() / 2 : 0));
            }
            if (this.isAlignGravity(17)) {
                calX = Math.max(0, baseViewLeft + (this.getWidth() > 0 ? this.baseView().getMeasuredWidth() / 2 - this.getWidth() / 2 : 0));
                calY = Math.max(0, baseViewTop + this.baseView().getMeasuredHeight() / 2 - boxBody.getHeight() / 2);
            }
            if (this.overlayBaseView) {
                if (this.isAlignGravity(48)) {
                    calY = baseViewTop + this.baseView().getMeasuredHeight() - boxBody.getHeight();
                    if (calX == 0) {
                        calX = Math.max(0, baseViewLeft + (this.getWidth() > 0 ? this.baseView().getMeasuredWidth() / 2 - this.getWidth() / 2 : 0));
                    }
                }
                if (this.isAlignGravity(3)) {
                    calX = Math.max(0, baseViewLeft + this.baseView().getMeasuredWidth() - boxBody.getWidth());
                    if (calY == 0) {
                        calY = Math.max(0, baseViewTop + this.baseView().getMeasuredHeight() / 2 - boxBody.getHeight() / 2);
                    }
                }
                if (this.isAlignGravity(5)) {
                    calX = baseViewLeft;
                    if (calY == 0) {
                        calY = Math.max(0, baseViewTop + this.baseView().getMeasuredHeight() / 2 - boxBody.getHeight() / 2);
                    }
                }
                if (this.isAlignGravity(80)) {
                    calY = baseViewTop;
                    if (calX == 0) {
                        calX = Math.max(0, baseViewLeft + (this.getWidth() > 0 ? this.baseView().getMeasuredWidth() / 2 - this.getWidth() / 2 : 0));
                    }
                }
            } else {
                if (this.isAlignGravity(48)) {
                    calY = Math.max(0, baseViewTop - boxBody.getHeight());
                    if (calX == 0) {
                        calX = Math.max(0, baseViewLeft + (this.getWidth() > 0 ? this.baseView().getMeasuredWidth() / 2 - this.getWidth() / 2 : 0));
                    }
                }
                if (this.isAlignGravity(3)) {
                    calX = Math.max(0, baseViewLeft - boxBody.getWidth());
                    if (calY == 0) {
                        calY = Math.max(0, baseViewTop + this.baseView().getMeasuredHeight() / 2 - boxBody.getHeight() / 2);
                    }
                }
                if (this.isAlignGravity(5)) {
                    calX = Math.max(0, baseViewLeft + this.baseView().getWidth());
                    if (calY == 0) {
                        calY = Math.max(0, baseViewTop + this.baseView().getMeasuredHeight() / 2 - boxBody.getHeight() / 2);
                    }
                }
                if (this.isAlignGravity(80)) {
                    calY = Math.max(0, baseViewTop + this.baseView().getHeight());
                    if (calX == 0) {
                        calX = Math.max(0, baseViewLeft + (this.getWidth() > 0 ? this.baseView().getMeasuredWidth() / 2 - this.getWidth() / 2 : 0));
                    }
                }
            }
            if (!this.offScreen) {
                if (calX < 0) {
                    calX = 0;
                }
                if (calX + boxBody.getWidth() > boxRoot.getUseAreaWidth()) {
                    calX = boxRoot.getUseAreaWidth() - boxBody.getWidth();
                }
                if (calY < 0) {
                    calY = 0;
                }
                if (calY + boxBody.getHeight() > boxRoot.getUseAreaHeight()) {
                    calY = boxRoot.getUseAreaHeight() - boxBody.getHeight();
                }
            }
            result.setX(calX).setY(calY);
        } else {
            int mHeight = this.height == -1 ? this.baseView().getHeight() : this.height;
            int left = (int)this.baseViewLoc.getX();
            int top = (int)(this.baseViewLoc.getY() + (float)(this.overlayBaseView ? 0 : mHeight) + (float)this.selectItemYDeviation);
            if (!this.offScreen) {
                if (left < 0) {
                    left = 0;
                }
                if (left + boxBody.getWidth() > boxRoot.getUseAreaWidth()) {
                    left = boxRoot.getUseAreaWidth() - boxBody.getWidth();
                }
                if (top < 0) {
                    top = 0;
                }
                if (top + boxBody.getHeight() > boxRoot.getUseAreaHeight()) {
                    top = boxRoot.getUseAreaHeight() - boxBody.getHeight();
                }
            }
            result.setX(left).setY(top);
        }
        int mWidth = this.width == -1 ? this.baseView().getWidth() : this.width;
        int mHeight = this.height == -1 ? this.baseView().getHeight() : this.height;
        result.setW(mWidth).setH(mHeight);
        return result;
    }

    private void removeDrawListener(ViewTreeObserver viewTreeObserver, ViewTreeObserver.OnDrawListener listener) {
        if (viewTreeObserver == null || listener == null || !viewTreeObserver.isAlive()) {
            return;
        }
        try {
            viewTreeObserver.removeOnDrawListener(listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getBodyRealHeight() {
        if (this.getDialogImpl() == null) {
            return 0;
        }
        int matchParentMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((View)this.getDialogImpl().boxBody.getParent()).getWidth(), (int)0x40000000);
        int wrapContentMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((View)this.getDialogImpl().boxBody.getParent()).getHeight(), (int)Integer.MIN_VALUE);
        this.getDialogImpl().boxBody.measure(matchParentMeasureSpec, wrapContentMeasureSpec);
        return this.getDialogImpl().boxBody.getMeasuredHeight();
    }

    public void dismiss() {
        this.closing = true;
        PopMenu.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (PopMenu.this.dialogImpl == null) {
                    return;
                }
                PopMenu.this.dialogImpl.doDismiss(null);
            }
        });
    }

    @Override
    public void restartDialog() {
        if (this.getDialogView() != null) {
            if (this.baseViewDrawListener != null) {
                if (this.viewTreeObserver != null) {
                    this.removeDrawListener(this.viewTreeObserver, this.baseViewDrawListener);
                } else if (this.baseView() != null) {
                    this.removeDrawListener(this.baseView().getViewTreeObserver(), this.baseViewDrawListener);
                }
                this.baseViewDrawListener = null;
            }
            PopMenu.dismiss(this.getDialogView());
            this.isShow = false;
        }
        if (this.getDialogImpl().boxCustom != null) {
            this.getDialogImpl().boxCustom.removeAllViews();
        }
        this.show();
    }

    @Override
    protected void shutdown() {
    }

    public List<CharSequence> getMenuList() {
        return this.menuList;
    }

    public PopMenu setMenuList(List<CharSequence> menuList) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(menuList);
        this.refreshUI();
        return this;
    }

    public PopMenu setMenuList(String[] menuList) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(Arrays.asList(menuList));
        this.refreshUI();
        return this;
    }

    public PopMenu setMenuList(CharSequence[] menuList) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(Arrays.asList(menuList));
        this.refreshUI();
        return this;
    }

    public PopMenu setMenus(String ... menuList) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(Arrays.asList(menuList));
        this.refreshUI();
        return this;
    }

    public PopMenu setMenus(CharSequence ... menuList) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(Arrays.asList(menuList));
        this.refreshUI();
        return this;
    }

    @Override
    public void refreshUI() {
        if (this.getDialogImpl() == null) {
            return;
        }
        PopMenu.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (PopMenu.this.dialogImpl != null) {
                    PopMenu.this.dialogImpl.refreshView();
                }
            }
        });
    }

    @Override
    public boolean isCancelable() {
        return true;
    }

    public DialogImpl getDialogImpl() {
        return this.dialogImpl;
    }

    @Override
    public String dialogKey() {
        return this.getClass().getSimpleName() + "(" + Integer.toHexString(this.hashCode()) + ")";
    }

    public DialogLifecycleCallback<PopMenu> getDialogLifecycleCallback() {
        return this.dialogLifecycleCallback == null ? new DialogLifecycleCallback<PopMenu>(){} : this.dialogLifecycleCallback;
    }

    public PopMenu setDialogLifecycleCallback(DialogLifecycleCallback<PopMenu> dialogLifecycleCallback) {
        this.dialogLifecycleCallback = dialogLifecycleCallback;
        if (this.isShow) {
            dialogLifecycleCallback.onShow(this.me);
        }
        return this;
    }

    public boolean isOverlayBaseView() {
        return this.overlayBaseView;
    }

    public PopMenu setOverlayBaseView(boolean overlayBaseView) {
        this.overlayBaseView = overlayBaseView;
        this.refreshUI();
        return this;
    }

    public OnMenuItemClickListener<PopMenu> getOnMenuItemClickListener() {
        return this.onMenuItemClickListener == null ? new OnMenuItemClickListener<PopMenu>(){

            @Override
            public boolean onClick(PopMenu dialog, CharSequence text, int index) {
                return false;
            }
        } : this.onMenuItemClickListener;
    }

    public PopMenu setOnMenuItemClickListener(OnMenuItemClickListener<PopMenu> onMenuItemClickListener) {
        this.onMenuItemClickListener = onMenuItemClickListener;
        return this;
    }

    public OnIconChangeCallBack<PopMenu> getOnIconChangeCallBack() {
        return this.onIconChangeCallBack;
    }

    public PopMenu setOnIconChangeCallBack(OnIconChangeCallBack<PopMenu> onIconChangeCallBack) {
        this.onIconChangeCallBack = onIconChangeCallBack;
        return this;
    }

    public PopMenu setCustomView(OnBindView<PopMenu> onBindView) {
        this.onBindView = onBindView;
        this.refreshUI();
        return this;
    }

    public View getCustomView() {
        if (this.onBindView == null) {
            return null;
        }
        return this.onBindView.getCustomView();
    }

    public PopMenu removeCustomView() {
        this.onBindView.clean();
        this.refreshUI();
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public PopMenu setWidth(int width) {
        this.width = width;
        this.refreshUI();
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public PopMenu setHeight(int height) {
        this.height = height;
        this.refreshUI();
        return this;
    }

    public int getAlignGravity() {
        return this.alignGravity;
    }

    public boolean isAlignGravity(int gravity) {
        return (this.alignGravity & gravity) == gravity;
    }

    public PopMenu setAlignGravity(int alignGravity) {
        this.alignGravity = alignGravity;
        this.refreshMenuLoc();
        return this;
    }

    public PopMenu setDialogImplMode(DialogX.IMPL_MODE dialogImplMode) {
        this.dialogImplMode = dialogImplMode;
        return this;
    }

    public TextInfo getMenuTextInfo() {
        if (this.menuTextInfo == null) {
            return DialogX.menuTextInfo;
        }
        return this.menuTextInfo;
    }

    public PopMenu setMenuTextInfo(TextInfo menuTextInfo) {
        this.menuTextInfo = menuTextInfo;
        return this;
    }

    public boolean isOffScreen() {
        return this.offScreen;
    }

    public PopMenu setOffScreen(boolean offScreen) {
        this.offScreen = offScreen;
        return this;
    }

    public boolean isBkgInterceptTouch() {
        return this.bkgInterceptTouch;
    }

    public PopMenu setBkgInterceptTouch(boolean bkgInterceptTouch) {
        this.bkgInterceptTouch = bkgInterceptTouch;
        return this;
    }

    public OnBackgroundMaskClickListener<PopMenu> getOnBackgroundMaskClickListener() {
        return this.onBackgroundMaskClickListener;
    }

    public PopMenu setOnBackgroundMaskClickListener(OnBackgroundMaskClickListener<PopMenu> onBackgroundMaskClickListener) {
        this.onBackgroundMaskClickListener = onBackgroundMaskClickListener;
        this.refreshUI();
        return this;
    }

    public PopMenu setStyle(DialogXStyle style2) {
        this.style = style2;
        return this;
    }

    public PopMenu setTheme(DialogX.THEME theme) {
        this.theme = theme;
        return this;
    }

    public PopMenu setRadius(float radiusPx) {
        this.backgroundRadius = radiusPx;
        this.refreshUI();
        return this;
    }

    public PopMenu setHapticFeedbackEnabled(boolean isHapticFeedbackEnabled) {
        this.isHapticFeedbackEnabled = isHapticFeedbackEnabled ? 1 : 0;
        return this;
    }

    public float getRadius() {
        return this.backgroundRadius;
    }

    public void hide() {
        this.isHide = true;
        this.hideWithExitAnim = false;
        if (this.getDialogView() != null) {
            this.getDialogView().setVisibility(8);
        }
    }

    public void hideWithExitAnim() {
        this.hideWithExitAnim = true;
        this.isHide = true;
        if (this.getDialogImpl() != null) {
            this.getDialogImpl().getDialogXAnimImpl().doExitAnim(this.me, (ViewGroup)this.getDialogImpl().boxBody);
            PopMenu.runOnMainDelay(new Runnable(){

                @Override
                public void run() {
                    if (PopMenu.this.getDialogView() != null) {
                        PopMenu.this.getDialogView().setVisibility(8);
                    }
                }
            }, this.getDialogImpl().getExitAnimationDuration(null));
        }
    }

    public DialogXAnimInterface<PopMenu> getDialogXAnimImpl() {
        return this.dialogXAnimImpl;
    }

    public PopMenu setDialogXAnimImpl(DialogXAnimInterface<PopMenu> dialogXAnimImpl) {
        this.dialogXAnimImpl = dialogXAnimImpl;
        return this;
    }

    public OnBackPressedListener<PopMenu> getOnBackPressedListener() {
        return this.onBackPressedListener;
    }

    public PopMenu setOnBackPressedListener(OnBackPressedListener<PopMenu> onBackPressedListener) {
        this.onBackPressedListener = onBackPressedListener;
        return this;
    }

    public View getBaseView() {
        return this.baseView();
    }

    public PopMenu setBaseView(View baseView) {
        this.baseView(baseView);
        this.refreshUI();
        return this;
    }

    public PopMenu setRootPadding(int padding) {
        this.screenPaddings = new int[]{padding, padding, padding, padding};
        this.refreshUI();
        return this;
    }

    public PopMenu setRootPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.screenPaddings = new int[]{paddingLeft, paddingTop, paddingRight, paddingBottom};
        this.refreshUI();
        return this;
    }

    public int getPressedIndex() {
        return this.pressedIndex;
    }

    public PopMenu setPressedIndex(int pressedIndex) {
        this.pressedIndex = pressedIndex;
        this.refreshUI();
        return this;
    }

    public int getSelectIndex() {
        return this.selectIndex;
    }

    public CharSequence getSelectMenuText() {
        if (this.menuList == null) {
            return "";
        }
        return this.menuList.get(this.selectIndex);
    }

    protected void onShow(PopMenu dialog) {
    }

    protected void onDismiss(PopMenu dialog) {
    }

    public MenuItemLayoutRefreshCallback<PopMenu> getMenuMenuItemLayoutRefreshCallback() {
        return this.menuMenuItemLayoutRefreshCallback;
    }

    public PopMenu setMenuMenuItemLayoutRefreshCallback(MenuItemLayoutRefreshCallback<PopMenu> menuMenuItemLayoutRefreshCallback) {
        this.menuMenuItemLayoutRefreshCallback = menuMenuItemLayoutRefreshCallback;
        return this;
    }

    protected PopMenu baseView(View view) {
        if (view == null && this.baseViewWeakReference != null) {
            this.baseViewWeakReference.clear();
            this.baseViewWeakReference = null;
        } else {
            this.baseViewWeakReference = new WeakReference<View>(view);
        }
        return this;
    }

    protected View baseView() {
        return this.baseViewWeakReference == null ? null : (View)this.baseViewWeakReference.get();
    }

    @Override
    public PopMenu setData(String key, Object obj) {
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.data.put(key, obj);
        return this;
    }

    public PopMenu onShow(DialogXRunnable<PopMenu> dialogXRunnable) {
        this.onShowRunnable = dialogXRunnable;
        if (this.isShow() && this.onShowRunnable != null) {
            this.onShowRunnable.run(this);
        }
        return this;
    }

    public PopMenu onDismiss(DialogXRunnable<PopMenu> dialogXRunnable) {
        this.onDismissRunnable = dialogXRunnable;
        return this;
    }

    @Override
    public PopMenu setEnableImmersiveMode(boolean enableImmersiveMode) {
        this.enableImmersiveMode = enableImmersiveMode;
        this.refreshUI();
        return this;
    }

    public List<Integer> getIconResIds() {
        return this.iconResIds;
    }

    public int getIconResIds(int position) {
        if (this.iconResIds != null && position >= 0 && position < this.iconResIds.size()) {
            return this.iconResIds.get(position);
        }
        return 0;
    }

    public PopMenu setIconResIds(int ... resIds) {
        if (this.iconResIds == null) {
            this.iconResIds = new ArrayList<Integer>();
        }
        for (int id2 : resIds) {
            this.iconResIds.add(id2);
        }
        this.refreshUI();
        return this;
    }

    public PopMenu setIconResIds(List<Integer> iconResIds) {
        this.iconResIds = iconResIds;
        this.refreshUI();
        return this;
    }

    public boolean isAutoTintIconInLightOrDarkMode() {
        return this.autoTintIconInLightOrDarkMode;
    }

    public PopMenu setAutoTintIconInLightOrDarkMode(boolean autoTintIconInLightOrDarkMode) {
        this.autoTintIconInLightOrDarkMode = autoTintIconInLightOrDarkMode;
        return this;
    }

    @Override
    public PopMenu setThisOrderIndex(int orderIndex) {
        this.thisOrderIndex = orderIndex;
        if (this.getDialogView() != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.getDialogView().setTranslationZ((float)orderIndex);
            } else {
                PopMenu.error("DialogX: " + this.dialogKey() + " \u6267\u884c .setThisOrderIndex(" + orderIndex + ") \u5931\u8d25\uff1a\u7cfb\u7edf\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0cSDK-API \u7248\u672c\u5fc5\u987b\u5927\u4e8e 21\uff08LOLLIPOP\uff09");
            }
        }
        return this;
    }

    public PopMenu bringToFront() {
        this.setThisOrderIndex(this.getHighestOrderIndex());
        return this;
    }

    public PopMenu enableMenu(int ... menuIndex) {
        for (int i : menuIndex) {
            this.menuUsability.put(i, true);
        }
        return this;
    }

    public PopMenu enableMenu(CharSequence ... menuText) {
        if (this.menuList != null && !this.menuList.isEmpty()) {
            for (CharSequence c : menuText) {
                int index = this.menuList.indexOf(c);
                this.menuUsability.put(index, true);
            }
        } else {
            PopMenu.error("DialogX: " + this.dialogKey() + " .enableMenu(" + menuText + ")\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u5148\u521d\u59cb\u5316\u83dc\u5355\u9879 menuList");
        }
        return this;
    }

    public PopMenu enableMenu(String ... menuText) {
        if (this.menuList != null && !this.menuList.isEmpty()) {
            for (String c : menuText) {
                int index = this.menuList.indexOf(c);
                this.menuUsability.put(index, true);
            }
        } else {
            PopMenu.error("DialogX: " + this.dialogKey() + " .enableMenu(" + menuText + ")\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u5148\u521d\u59cb\u5316\u83dc\u5355\u9879 menuList");
        }
        return this;
    }

    public PopMenu disableMenu(int ... menuIndex) {
        for (int i : menuIndex) {
            this.menuUsability.put(i, false);
        }
        return this;
    }

    public PopMenu disableMenu(CharSequence ... menuText) {
        if (this.menuList != null && !this.menuList.isEmpty()) {
            for (CharSequence c : menuText) {
                int index = this.menuList.indexOf(c);
                this.menuUsability.put(index, false);
            }
        } else {
            PopMenu.error("DialogX: " + this.dialogKey() + " .disableMenu(" + menuText + ")\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u5148\u521d\u59cb\u5316\u83dc\u5355\u9879 menuList");
        }
        return this;
    }

    public PopMenu disableMenu(String ... menuText) {
        if (this.menuList != null && !this.menuList.isEmpty()) {
            for (String c : menuText) {
                int index = this.menuList.indexOf(c);
                this.menuUsability.put(index, false);
            }
        } else {
            PopMenu.error("DialogX: " + this.dialogKey() + " .disableMenu(" + menuText + ")\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u5148\u521d\u59cb\u5316\u83dc\u5355\u9879 menuList");
        }
        return this;
    }

    public boolean isMenuItemEnable(int index) {
        Boolean enabled = this.menuUsability.get(index);
        if (enabled == null) {
            return true;
        }
        return enabled;
    }

    public class DialogImpl
    implements DialogConvertViewInterface {
        private List<View> blurViews;
        public DialogXBaseRelativeLayout boxRoot;
        public MaxRelativeLayout boxBody;
        public RelativeLayout boxCustom;
        public PopMenuListView listMenu;

        public DialogImpl(View convertView) {
            if (convertView == null) {
                return;
            }
            PopMenu.this.setDialogView(convertView);
            this.boxRoot = (DialogXBaseRelativeLayout)convertView.findViewById(R.id.box_root);
            this.boxBody = (MaxRelativeLayout)convertView.findViewById(R.id.box_body);
            this.boxCustom = (RelativeLayout)convertView.findViewById(R.id.box_custom);
            this.listMenu = (PopMenuListView)convertView.findViewById(R.id.listMenu);
            this.boxBody.setVisibility(4);
            this.blurViews = PopMenu.this.findAllBlurView(convertView);
            this.boxBody.setX(-1.0f);
            this.boxBody.setY(-1.0f);
            this.init();
        }

        @Override
        public void init() {
            PopMenu.this.closing = false;
            if (PopMenu.this.menuListAdapter == null) {
                PopMenu.this.menuListAdapter = new PopMenuArrayAdapter(PopMenu.this.me, (Context)PopMenu.this.getOwnActivity(), PopMenu.this.menuList);
            }
            this.boxRoot.setParentDialog(PopMenu.this.me);
            this.boxRoot.setOnLifecycleCallBack(new DialogXBaseRelativeLayout.OnLifecycleCallBack(){

                @Override
                public void onShow() {
                    PopMenu.this.isShow = true;
                    PopMenu.this.preShow = false;
                    PopMenu.this.setLifecycleState(Lifecycle.State.CREATED);
                    PopMenu.this.onDialogShow();
                    PopMenu.this.getDialogLifecycleCallback().onShow(PopMenu.this.me);
                    PopMenu.this.onShow(PopMenu.this.me);
                    PopMenu.this.refreshUI();
                }

                @Override
                public void onDismiss() {
                    PopMenu.this.isShow = false;
                    PopMenu.this.getDialogLifecycleCallback().onDismiss(PopMenu.this.me);
                    PopMenu.this.onDismiss(PopMenu.this.me);
                    PopMenu.this.menuListAdapter = null;
                    PopMenu.this.dialogImpl = null;
                    PopMenu.this.baseView(null);
                    PopMenu.this.dialogLifecycleCallback = null;
                    PopMenu.this.setLifecycleState(Lifecycle.State.DESTROYED);
                    System.gc();
                }
            });
            this.boxRoot.setOnBackPressedListener(new DialogXBaseRelativeLayout.PrivateBackPressedListener(){

                @Override
                public boolean onBackPressed() {
                    if (PopMenu.this.onBackPressedListener != null) {
                        if (PopMenu.this.onBackPressedListener.onBackPressed(PopMenu.this.me)) {
                            PopMenu.this.dismiss();
                        }
                    } else if (PopMenu.this.isCancelable()) {
                        PopMenu.this.dismiss();
                    }
                    return true;
                }
            });
            this.listMenu.setMaxHeight(PopMenu.this.getRootFrameLayout() == null ? (float)PopMenu.this.dip2px(500.0f) : (float)(PopMenu.this.getRootFrameLayout().getMeasuredHeight() - PopMenu.this.dip2px(150.0f)));
            this.boxBody.setVisibility(4);
            this.boxBody.post(new Runnable(){

                @Override
                public void run() {
                    DialogImpl.this.getDialogXAnimImpl().doShowAnim(PopMenu.this.me, (ViewGroup)DialogImpl.this.boxBody);
                    PopMenu.this.setLifecycleState(Lifecycle.State.RESUMED);
                    Integer blurFrontColor = null;
                    Float dialogXRadius = null;
                    if (PopMenu.this.style.popMenuSettings() != null && PopMenu.this.style.popMenuSettings().blurBackgroundSettings() != null) {
                        blurFrontColor = PopMenu.this.getColorNullable(PopMenu.this.getIntStyleAttr(PopMenu.this.style.popMenuSettings().blurBackgroundSettings().blurForwardColorRes(PopMenu.this.isLightTheme())));
                        dialogXRadius = PopMenu.this.getFloatStyleAttr(Float.valueOf(PopMenu.this.style.popMenuSettings().blurBackgroundSettings().blurBackgroundRoundRadiusPx()));
                    }
                    if (DialogImpl.this.blurViews != null) {
                        for (View blurView : DialogImpl.this.blurViews) {
                            ((BlurViewType)blurView).setOverlayColor(PopMenu.this.backgroundColor == null ? blurFrontColor : PopMenu.this.backgroundColor);
                            ((BlurViewType)blurView).setRadiusPx(dialogXRadius);
                        }
                    }
                }
            });
            int dividerDrawableResId = 0;
            int dividerHeight = 0;
            if (PopMenu.this.style.popMenuSettings() != null) {
                dividerDrawableResId = PopMenu.this.style.popMenuSettings().overrideMenuDividerDrawableRes(PopMenu.this.isLightTheme());
                dividerHeight = PopMenu.this.style.popMenuSettings().overrideMenuDividerHeight(PopMenu.this.isLightTheme());
            }
            if (dividerDrawableResId == 0) {
                dividerDrawableResId = PopMenu.this.isLightTheme() ? R.drawable.rect_dialogx_material_menu_split_divider : R.drawable.rect_dialogx_material_menu_split_divider_night;
            }
            this.listMenu.setOverScrollMode(2);
            this.listMenu.setVerticalScrollBarEnabled(false);
            this.listMenu.setDivider(PopMenu.this.getResources().getDrawable(dividerDrawableResId));
            this.listMenu.setDividerHeight(dividerHeight);
            this.listMenu.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    if (!PopMenu.this.isMenuItemEnable(position)) {
                        return;
                    }
                    PopMenu.this.haptic(view);
                    PopMenu.this.selectIndex = position;
                    if (!PopMenu.this.closing) {
                        PopMenu.this.lastHash = PopMenu.this.menuList.hashCode();
                        boolean callBack = PopMenu.this.getOnMenuItemClickListener().onClick(PopMenu.this.me, PopMenu.this.menuList.get(position), position);
                        if (!PopMenu.this.notCheckHash && PopMenu.this.lastHash == PopMenu.this.menuList.hashCode() && callBack) {
                            callBack = false;
                        }
                        if (!callBack) {
                            PopMenu.this.dismiss();
                        }
                    }
                }
            });
            PopMenu.this.onDialogInit();
        }

        @Override
        public void refreshView() {
            if (this.boxRoot == null || PopMenu.this.getOwnActivity() == null) {
                return;
            }
            this.boxRoot.setAutoUnsafePlacePadding(PopMenu.this.isEnableImmersiveMode());
            this.boxRoot.setRootPadding(PopMenu.this.screenPaddings[0], PopMenu.this.screenPaddings[1], PopMenu.this.screenPaddings[2], PopMenu.this.screenPaddings[3]);
            if (this.listMenu.getAdapter() == null) {
                this.listMenu.setAdapter((ListAdapter)PopMenu.this.menuListAdapter);
            } else if (PopMenu.this.menuListAdapter.getMenuList() != PopMenu.this.menuList) {
                PopMenu.this.menuListAdapter = new PopMenuArrayAdapter(PopMenu.this.me, (Context)PopMenu.this.getOwnActivity(), PopMenu.this.menuList);
                this.listMenu.setAdapter((ListAdapter)PopMenu.this.menuListAdapter);
            } else {
                PopMenu.this.menuListAdapter.notifyDataSetChanged();
            }
            if (PopMenu.this.bkgInterceptTouch) {
                if (PopMenu.this.isCancelable()) {
                    this.boxRoot.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (PopMenu.this.onBackgroundMaskClickListener == null || !PopMenu.this.onBackgroundMaskClickListener.onClick(PopMenu.this.me, v)) {
                                DialogImpl.this.doDismiss(v);
                            }
                        }
                    });
                } else {
                    this.boxRoot.setOnClickListener(null);
                }
            } else {
                this.boxRoot.setClickable(false);
            }
            if (PopMenu.this.backgroundRadius > -1.0f) {
                GradientDrawable gradientDrawable;
                if (this.boxBody.getBackground() instanceof GradientDrawable && (gradientDrawable = (GradientDrawable)this.boxBody.getBackground()) != null) {
                    gradientDrawable.setCornerRadius(PopMenu.this.backgroundRadius);
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    this.boxBody.setOutlineProvider(new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), PopMenu.this.backgroundRadius);
                        }
                    });
                    this.boxBody.setClipToOutline(true);
                }
                if (this.blurViews != null) {
                    for (View blurView : this.blurViews) {
                        ((BlurViewType)blurView).setRadiusPx(Float.valueOf(PopMenu.this.backgroundRadius));
                    }
                }
            }
            if (PopMenu.this.onBindView != null && PopMenu.this.onBindView.getCustomView() != null) {
                PopMenu.this.onBindView.bindParent((ViewGroup)this.boxCustom, PopMenu.this.me);
                this.boxCustom.setVisibility(0);
            } else {
                this.boxCustom.setVisibility(8);
            }
            if (PopMenu.this.width != -1) {
                this.boxBody.setMaxWidth(PopMenu.this.width);
                this.boxBody.setMinimumWidth(PopMenu.this.width);
            }
            if (PopMenu.this.height != -1) {
                this.boxBody.setMaxHeight(PopMenu.this.height);
                this.boxBody.setMinimumHeight(PopMenu.this.height);
            }
            if (PopMenu.this.backgroundColor != null) {
                PopMenu.this.tintColor((View)this.boxBody, PopMenu.this.backgroundColor);
                if (this.blurViews != null) {
                    for (View blurView : this.blurViews) {
                        ((BlurViewType)blurView).setOverlayColor(PopMenu.this.backgroundColor);
                    }
                }
            }
            PopMenu.this.onDialogRefreshUI();
        }

        @Override
        public void doDismiss(View v) {
            if (PopMenu.this.preDismiss(PopMenu.this)) {
                return;
            }
            if (v != null) {
                v.setEnabled(false);
            }
            if (!PopMenu.this.dismissAnimFlag && this.boxRoot != null) {
                PopMenu.this.dismissAnimFlag = true;
                this.boxRoot.post(new Runnable(){

                    @Override
                    public void run() {
                        DialogImpl.this.getDialogXAnimImpl().doExitAnim(PopMenu.this.me, (ViewGroup)DialogImpl.this.boxBody);
                        PopMenu.runOnMainDelay(new Runnable(){

                            @Override
                            public void run() {
                                if (PopMenu.this.baseViewDrawListener != null) {
                                    if (PopMenu.this.viewTreeObserver != null) {
                                        PopMenu.this.removeDrawListener(PopMenu.this.viewTreeObserver, PopMenu.this.baseViewDrawListener);
                                    } else if (PopMenu.this.baseView() != null) {
                                        PopMenu.this.removeDrawListener(PopMenu.this.baseView().getViewTreeObserver(), PopMenu.this.baseViewDrawListener);
                                    }
                                    PopMenu.this.baseViewDrawListener = null;
                                    PopMenu.this.viewTreeObserver = null;
                                }
                                PopMenu.dismiss(PopMenu.this.getDialogView());
                            }
                        }, DialogImpl.this.getExitAnimationDuration(null));
                    }
                });
            }
        }

        protected DialogXAnimInterface<PopMenu> getDialogXAnimImpl() {
            if (PopMenu.this.dialogXAnimImpl == null) {
                PopMenu.this.dialogXAnimImpl = new DialogXAnimInterface<PopMenu>(){
                    int selectMenuIndex = -1;

                    @Override
                    public void doShowAnim(PopMenu dialog, ViewGroup dialogBodyView) {
                        long enterAnimDurationTemp = DialogImpl.this.getEnterAnimationDuration(null);
                        if (PopMenu.this.baseView() != null) {
                            final int targetHeight = PopMenu.this.getBodyRealHeight();
                            DialogImpl.this.boxBody.getLayoutParams().height = 1;
                            if (PopMenu.this.overlayBaseView && !DialogImpl.this.listMenu.isCanScroll()) {
                                if (PopMenu.this.baseView() instanceof TextView) {
                                    String baseText = ((TextView)PopMenu.this.baseView()).getText().toString();
                                    for (CharSequence c : PopMenu.this.menuList) {
                                        if (!TextUtils.equals((CharSequence)c.toString(), (CharSequence)baseText)) continue;
                                        this.selectMenuIndex = PopMenu.this.menuList.indexOf(c);
                                        break;
                                    }
                                }
                                if (this.selectMenuIndex != -1) {
                                    int[] viewLoc = new int[2];
                                    if (DialogImpl.this.listMenu.getChildAt(this.selectMenuIndex) != null) {
                                        int itemHeight = DialogImpl.this.listMenu.getChildAt(this.selectMenuIndex).getMeasuredHeight();
                                        DialogImpl.this.listMenu.getChildAt(this.selectMenuIndex).getLocationInWindow(viewLoc);
                                        PopMenu.this.selectItemYDeviation = (int)((float)PopMenu.this.baseView().getMeasuredHeight() / 2.0f - ((float)viewLoc[1] - DialogImpl.this.boxBody.getY()) - (float)itemHeight / 2.0f);
                                    }
                                }
                            }
                            PopMenu.this.refreshMenuLoc();
                            PopMenu.this.selectItemYDeviation = (int)(PopMenu.this.getMenuLoc().getY() - PopMenu.this.baseViewLoc.getY());
                            ValueAnimator enterAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                            enterAnim.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                            enterAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                                public void onAnimationUpdate(ValueAnimator animation) {
                                    int aimHeight;
                                    if (!PopMenu.this.isShow || PopMenu.this.getDialogImpl() == null || PopMenu.this.getDialogImpl().boxBody == null) {
                                        return;
                                    }
                                    float animatedValue = ((Float)animation.getAnimatedValue()).floatValue();
                                    PopMenu.this.isEnterAnimRunning = animatedValue != 1.0f;
                                    DialogXViewLoc loc = PopMenu.this.getMenuLoc();
                                    DialogImpl.this.boxBody.getLayoutParams().height = aimHeight = animatedValue == 1.0f ? -2 : (int)((float)targetHeight * animatedValue);
                                    int n = DialogImpl.this.boxBody.getLayoutParams().width = PopMenu.this.getWidth() == -1 ? PopMenu.this.baseView().getWidth() : PopMenu.this.getWidth();
                                    if (DialogImpl.this.boxBody.getY() + (float)aimHeight > DialogImpl.this.boxRoot.getSafeHeight()) {
                                        DialogImpl.this.boxBody.setY(DialogImpl.this.boxRoot.getSafeHeight() - (float)aimHeight);
                                    }
                                    float calX = loc.getX() != -1.0f ? loc.getX() : PopMenu.this.baseViewLoc.getX();
                                    float calY = PopMenu.this.baseViewLoc.getY() + (float)PopMenu.this.selectItemYDeviation * animatedValue;
                                    if (!PopMenu.this.offScreen) {
                                        if (calX < 0.0f) {
                                            calX = 0.0f;
                                        }
                                        if (calY < 0.0f) {
                                            calY = 0.0f;
                                        }
                                        if (calX + (float)DialogImpl.this.boxBody.getWidth() > (float)DialogImpl.this.boxRoot.getUseAreaWidth()) {
                                            calX = DialogImpl.this.boxRoot.getUseAreaWidth() - DialogImpl.this.boxBody.getWidth();
                                        }
                                        if (calY + (float)DialogImpl.this.boxBody.getHeight() > (float)DialogImpl.this.boxRoot.getUseAreaHeight()) {
                                            calY = DialogImpl.this.boxRoot.getUseAreaHeight() - DialogImpl.this.boxBody.getHeight();
                                        }
                                    }
                                    DialogImpl.this.boxBody.setX(calX);
                                    DialogImpl.this.boxBody.setY(calY);
                                    DialogImpl.this.boxBody.requestLayout();
                                    if (DialogImpl.this.boxBody.getVisibility() != 0) {
                                        DialogImpl.this.boxBody.setVisibility(0);
                                    }
                                    if (DialogImpl.this.isUseBlurBackground()) {
                                        DialogImpl.this.boxRoot.setBkgAlpha(((Float)animation.getAnimatedValue()).floatValue());
                                    }
                                }
                            });
                            enterAnim.setInterpolator((TimeInterpolator)new DecelerateInterpolator(2.0f));
                            enterAnim.setDuration(enterAnimDurationTemp);
                            enterAnim.start();
                        } else {
                            RelativeLayout.LayoutParams rLp = (RelativeLayout.LayoutParams)DialogImpl.this.boxBody.getLayoutParams();
                            rLp.addRule(13);
                            rLp.width = PopMenu.this.getWidth() == -1 ? -1 : PopMenu.this.getWidth();
                            rLp.leftMargin = PopMenu.this.dip2px(50.0f);
                            rLp.rightMargin = PopMenu.this.dip2px(50.0f);
                            DialogImpl.this.boxBody.setLayoutParams((ViewGroup.LayoutParams)rLp);
                            DialogImpl.this.boxBody.setAlpha(0.0f);
                            if (Build.VERSION.SDK_INT >= 21 && !DialogImpl.this.isUseBlurBackground()) {
                                DialogImpl.this.boxBody.setElevation(PopMenu.this.dip2px(20.0f));
                            }
                            DialogImpl.this.boxBody.setVisibility(0);
                            DialogImpl.this.boxBody.animate().alpha(1.0f).setDuration(enterAnimDurationTemp);
                            ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                            bkgAlpha.setDuration(enterAnimDurationTemp);
                            bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                                public void onAnimationUpdate(ValueAnimator animation) {
                                    DialogImpl.this.boxRoot.setBkgAlpha(((Float)animation.getAnimatedValue()).floatValue());
                                }
                            });
                            bkgAlpha.start();
                        }
                    }

                    @Override
                    public void doExitAnim(PopMenu dialog, ViewGroup dialogBodyView) {
                        Animation exitAnim = AnimationUtils.loadAnimation((Context)(PopMenu.this.getOwnActivity() == null ? DialogImpl.this.boxRoot.getContext() : PopMenu.this.getOwnActivity()), (int)R.anim.anim_dialogx_default_exit);
                        long exitAnimDuration = DialogImpl.this.getExitAnimationDuration(exitAnim);
                        exitAnim.setDuration(exitAnimDuration);
                        DialogImpl.this.boxBody.startAnimation(exitAnim);
                        DialogImpl.this.boxRoot.animate().alpha(0.0f).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration(exitAnimDuration);
                        ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
                        bkgAlpha.setDuration(exitAnimDuration);
                        bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                if (DialogImpl.this.boxRoot != null && PopMenu.this.baseView() == null) {
                                    DialogImpl.this.boxRoot.setBkgAlpha(((Float)animation.getAnimatedValue()).floatValue());
                                }
                            }
                        });
                        bkgAlpha.start();
                    }
                };
            }
            return PopMenu.this.dialogXAnimImpl;
        }

        private boolean isUseBlurBackground() {
            return PopMenu.this.style.popMenuSettings() != null && PopMenu.this.style.popMenuSettings().blurBackgroundSettings() != null && PopMenu.this.style.popMenuSettings().blurBackgroundSettings().blurBackground();
        }

        public long getExitAnimationDuration(@Nullable Animation defaultExitAnim) {
            long exitAnimDurationTemp;
            if (defaultExitAnim == null && this.boxBody.getAnimation() != null) {
                defaultExitAnim = this.boxBody.getAnimation();
            }
            long l = exitAnimDurationTemp = defaultExitAnim == null || defaultExitAnim.getDuration() == 0L ? 150L : defaultExitAnim.getDuration();
            if (overrideExitDuration >= 0L) {
                exitAnimDurationTemp = overrideExitDuration;
            }
            if (PopMenu.this.exitAnimDuration != -1L) {
                exitAnimDurationTemp = PopMenu.this.exitAnimDuration;
            }
            return exitAnimDurationTemp;
        }

        public long getEnterAnimationDuration(@Nullable Animation defaultEnterAnim) {
            long enterAnimDurationTemp;
            if (defaultEnterAnim == null && this.boxBody.getAnimation() != null) {
                defaultEnterAnim = this.boxBody.getAnimation();
            }
            long l = enterAnimDurationTemp = defaultEnterAnim == null || defaultEnterAnim.getDuration() == 0L ? 150L : defaultEnterAnim.getDuration();
            if (overrideEnterDuration >= 0L) {
                enterAnimDurationTemp = overrideEnterDuration;
            }
            if (PopMenu.this.enterAnimDuration >= 0L) {
                enterAnimDurationTemp = PopMenu.this.enterAnimDuration;
            }
            return enterAnimDurationTemp;
        }
    }
}

