/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.dialogs;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Space;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.dialogs.InputDialog;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.BaseOnDialogClickCallback;
import com.kongzue.dialogx.interfaces.BlurViewType;
import com.kongzue.dialogx.interfaces.DialogConvertViewInterface;
import com.kongzue.dialogx.interfaces.DialogLifecycleCallback;
import com.kongzue.dialogx.interfaces.DialogXAnimInterface;
import com.kongzue.dialogx.interfaces.DialogXRunnable;
import com.kongzue.dialogx.interfaces.DialogXStyle;
import com.kongzue.dialogx.interfaces.OnBackPressedListener;
import com.kongzue.dialogx.interfaces.OnBackgroundMaskClickListener;
import com.kongzue.dialogx.interfaces.OnBindView;
import com.kongzue.dialogx.interfaces.OnDialogButtonClickListener;
import com.kongzue.dialogx.interfaces.OnInputDialogButtonClickListener;
import com.kongzue.dialogx.interfaces.OnMenuButtonClickListener;
import com.kongzue.dialogx.interfaces.ScrollController;
import com.kongzue.dialogx.style.MaterialStyle;
import com.kongzue.dialogx.util.InputInfo;
import com.kongzue.dialogx.util.TextInfo;
import com.kongzue.dialogx.util.views.DialogScrollView;
import com.kongzue.dialogx.util.views.DialogXBaseRelativeLayout;
import com.kongzue.dialogx.util.views.MaxRelativeLayout;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;

public class MessageDialog
extends BaseDialog {
    public static int overrideEnterDuration = -1;
    public static int overrideExitDuration = -1;
    public static int overrideEnterAnimRes = 0;
    public static int overrideExitAnimRes = 0;
    public static BaseDialog.BOOLEAN overrideCancelable;
    protected boolean bkgInterceptTouch = true;
    protected OnBindView<MessageDialog> onBindView;
    protected MessageDialog me = this;
    protected BaseDialog.BOOLEAN privateCancelable;
    protected int customEnterAnimResId;
    protected int customExitAnimResId;
    protected DialogXAnimInterface<MessageDialog> dialogXAnimImpl;
    protected OnBackPressedListener<MessageDialog> onBackPressedListener;
    protected BaseDialog.BUTTON_SELECT_RESULT buttonSelectResult = BaseDialog.BUTTON_SELECT_RESULT.NONE;
    protected DialogLifecycleCallback<MessageDialog> dialogLifecycleCallback;
    protected OnBackgroundMaskClickListener<MessageDialog> onBackgroundMaskClickListener;
    protected CharSequence title;
    protected CharSequence message;
    protected CharSequence okText;
    protected CharSequence cancelText;
    protected CharSequence otherText;
    protected String inputText;
    protected String inputHintText;
    protected Integer maskColor = null;
    protected float backgroundRadius = DialogX.defaultMessageDialogBackgroundRadius;
    protected Drawable titleIcon;
    protected TextInfo titleTextInfo;
    protected TextInfo messageTextInfo;
    protected TextInfo okTextInfo;
    protected TextInfo cancelTextInfo;
    protected TextInfo otherTextInfo;
    protected InputInfo inputInfo;
    protected BaseOnDialogClickCallback okButtonClickListener;
    protected BaseOnDialogClickCallback cancelButtonClickListener;
    protected BaseOnDialogClickCallback otherButtonClickListener;
    protected int buttonOrientation;
    protected DialogImpl dialogImpl;
    protected boolean hideWithExitAnim;

    protected MessageDialog() {
    }

    public static MessageDialog build() {
        return new MessageDialog();
    }

    public static MessageDialog build(DialogXStyle style2) {
        return new MessageDialog().setStyle(style2);
    }

    public static MessageDialog build(OnBindView<MessageDialog> onBindView) {
        return new MessageDialog().setCustomView(onBindView);
    }

    public MessageDialog(CharSequence title, CharSequence message) {
        this.title = title;
        this.message = message;
    }

    public MessageDialog(CharSequence title, CharSequence message, CharSequence okText) {
        this.title = title;
        this.message = message;
        this.okText = okText;
    }

    public MessageDialog(int titleResId, int messageResId, int okTextResId) {
        this.title = this.getString(titleResId);
        this.message = this.getString(messageResId);
        this.okText = this.getString(okTextResId);
    }

    public MessageDialog(int titleResId, int messageResId) {
        this.title = this.getString(titleResId);
        this.message = this.getString(messageResId);
    }

    public static MessageDialog show(CharSequence title, CharSequence message, CharSequence okText) {
        MessageDialog messageDialog = new MessageDialog(title, message, okText);
        messageDialog.show();
        return messageDialog;
    }

    public static MessageDialog show(int titleResId, int messageResId, int okTextResId) {
        MessageDialog messageDialog = new MessageDialog(titleResId, messageResId, okTextResId);
        messageDialog.show();
        return messageDialog;
    }

    public static MessageDialog show(CharSequence title, CharSequence message) {
        MessageDialog messageDialog = new MessageDialog(title, message);
        messageDialog.show();
        return messageDialog;
    }

    public static MessageDialog show(int titleResId, int messageResId) {
        MessageDialog messageDialog = new MessageDialog(titleResId, messageResId);
        messageDialog.show();
        return messageDialog;
    }

    public MessageDialog(CharSequence title, CharSequence message, CharSequence okText, CharSequence cancelText) {
        this.title = title;
        this.message = message;
        this.okText = okText;
        this.cancelText = cancelText;
    }

    public MessageDialog(int titleResId, int messageResId, int okTextResId, int cancelTextResId) {
        this.title = this.getString(titleResId);
        this.message = this.getString(messageResId);
        this.okText = this.getString(okTextResId);
        this.cancelText = this.getString(cancelTextResId);
    }

    public static MessageDialog show(CharSequence title, CharSequence message, CharSequence okText, CharSequence cancelText) {
        MessageDialog messageDialog = new MessageDialog(title, message, okText, cancelText);
        messageDialog.show();
        return messageDialog;
    }

    public static MessageDialog show(int titleResId, int messageResId, int okTextResId, int cancelTextResId) {
        MessageDialog messageDialog = new MessageDialog(titleResId, messageResId, okTextResId, cancelTextResId);
        messageDialog.show();
        return messageDialog;
    }

    public MessageDialog(CharSequence title, CharSequence message, CharSequence okText, CharSequence cancelText, CharSequence otherText) {
        this.title = title;
        this.message = message;
        this.okText = okText;
        this.cancelText = cancelText;
        this.otherText = otherText;
    }

    public MessageDialog(int titleResId, int messageResId, int okTextResId, int cancelTextResId, int otherTextResId) {
        this.title = this.getString(titleResId);
        this.message = this.getString(messageResId);
        this.okText = this.getString(okTextResId);
        this.cancelText = this.getString(cancelTextResId);
        this.otherText = this.getString(otherTextResId);
    }

    public static MessageDialog show(CharSequence title, CharSequence message, CharSequence okText, CharSequence cancelText, CharSequence otherText) {
        MessageDialog messageDialog = new MessageDialog(title, message, okText, cancelText, otherText);
        messageDialog.show();
        return messageDialog;
    }

    public static MessageDialog show(int titleResId, int messageResId, int okTextResId, int cancelTextResId, int otherTextResId) {
        MessageDialog messageDialog = new MessageDialog(titleResId, messageResId, okTextResId, cancelTextResId, otherTextResId);
        messageDialog.show();
        return messageDialog;
    }

    public MessageDialog show() {
        if (this.isHide && this.getDialogView() != null && this.isShow) {
            if (this.hideWithExitAnim && this.getDialogImpl() != null) {
                this.getDialogView().setVisibility(0);
                this.getDialogImpl().getDialogXAnimImpl().doShowAnim(this.me, (ViewGroup)this.getDialogImpl().bkg);
            } else {
                this.getDialogView().setVisibility(0);
            }
            return this;
        }
        super.beforeShow();
        if (this.getDialogView() == null) {
            int layoutId = this.style.layout(this.isLightTheme());
            layoutId = layoutId == 0 ? (this.isLightTheme() ? R.layout.layout_dialogx_material : R.layout.layout_dialogx_material_dark) : layoutId;
            View dialogView = this.createView(layoutId);
            this.dialogImpl = new DialogImpl(dialogView);
            if (dialogView != null) {
                dialogView.setTag((Object)this.me);
            }
            MessageDialog.show(dialogView);
        } else {
            MessageDialog.show(this.getDialogView());
        }
        return this;
    }

    public void show(Activity activity) {
        super.beforeShow();
        if (this.getDialogView() == null) {
            int layoutId = this.style.layout(this.isLightTheme());
            layoutId = layoutId == 0 ? (this.isLightTheme() ? R.layout.layout_dialogx_material : R.layout.layout_dialogx_material_dark) : layoutId;
            View dialogView = this.createView(layoutId);
            this.dialogImpl = new DialogImpl(dialogView);
            if (dialogView != null) {
                dialogView.setTag((Object)this.me);
            }
            MessageDialog.show(activity, dialogView);
        } else {
            MessageDialog.show(activity, this.getDialogView());
        }
    }

    @Override
    public void refreshUI() {
        if (this.getDialogImpl() == null) {
            return;
        }
        MessageDialog.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (MessageDialog.this.dialogImpl != null) {
                    MessageDialog.this.dialogImpl.refreshView();
                }
            }
        });
    }

    @Override
    public String dialogKey() {
        return this.getClass().getSimpleName() + "(" + Integer.toHexString(this.hashCode()) + ")";
    }

    public void dismiss() {
        MessageDialog.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (MessageDialog.this.dialogImpl == null) {
                    return;
                }
                MessageDialog.this.dialogImpl.doDismiss((View)MessageDialog.this.dialogImpl.bkg);
            }
        });
    }

    public DialogLifecycleCallback<MessageDialog> getDialogLifecycleCallback() {
        return this.dialogLifecycleCallback == null ? new DialogLifecycleCallback<MessageDialog>(){} : this.dialogLifecycleCallback;
    }

    public MessageDialog setDialogLifecycleCallback(DialogLifecycleCallback<MessageDialog> dialogLifecycleCallback) {
        this.dialogLifecycleCallback = dialogLifecycleCallback;
        if (this.isShow) {
            dialogLifecycleCallback.onShow(this.me);
        }
        return this;
    }

    public MessageDialog setStyle(DialogXStyle style2) {
        this.style = style2;
        return this;
    }

    public MessageDialog setTheme(DialogX.THEME theme) {
        this.theme = theme;
        return this;
    }

    public CharSequence getOkButton() {
        return this.okText;
    }

    public MessageDialog setOkButton(CharSequence okText) {
        this.okText = okText;
        this.refreshUI();
        return this;
    }

    public MessageDialog setOkButton(int okTextRedId) {
        this.okText = this.getString(okTextRedId);
        this.refreshUI();
        return this;
    }

    public MessageDialog setOkButton(OnDialogButtonClickListener<MessageDialog> okButtonClickListener) {
        this.okButtonClickListener = okButtonClickListener;
        return this;
    }

    public MessageDialog setOkButton(CharSequence okText, OnDialogButtonClickListener<MessageDialog> okButtonClickListener) {
        this.okText = okText;
        this.okButtonClickListener = okButtonClickListener;
        this.refreshUI();
        return this;
    }

    public MessageDialog setOkButton(int okTextRedId, OnDialogButtonClickListener<MessageDialog> okButtonClickListener) {
        this.okText = this.getString(okTextRedId);
        this.okButtonClickListener = okButtonClickListener;
        this.refreshUI();
        return this;
    }

    public CharSequence getCancelButton() {
        return this.cancelText;
    }

    public MessageDialog setCancelButton(CharSequence cancelText) {
        this.cancelText = cancelText;
        this.refreshUI();
        return this;
    }

    public MessageDialog setCancelButton(int cancelTextResId) {
        this.cancelText = this.getString(cancelTextResId);
        this.refreshUI();
        return this;
    }

    public MessageDialog setCancelButton(OnDialogButtonClickListener<MessageDialog> cancelButtonClickListener) {
        this.cancelButtonClickListener = cancelButtonClickListener;
        return this;
    }

    public MessageDialog setCancelButton(CharSequence cancelText, OnDialogButtonClickListener<MessageDialog> cancelButtonClickListener) {
        this.cancelText = cancelText;
        this.cancelButtonClickListener = cancelButtonClickListener;
        this.refreshUI();
        return this;
    }

    public MessageDialog setCancelButton(int cancelTextResId, OnDialogButtonClickListener<MessageDialog> cancelButtonClickListener) {
        this.cancelText = this.getString(cancelTextResId);
        this.cancelButtonClickListener = cancelButtonClickListener;
        this.refreshUI();
        return this;
    }

    public CharSequence getOtherButton() {
        return this.otherText;
    }

    public MessageDialog setOtherButton(CharSequence otherText) {
        this.otherText = otherText;
        this.refreshUI();
        return this;
    }

    public MessageDialog setOtherButton(int otherTextResId) {
        this.otherText = this.getString(otherTextResId);
        this.refreshUI();
        return this;
    }

    public MessageDialog setOtherButton(OnDialogButtonClickListener<MessageDialog> otherButtonClickListener) {
        this.otherButtonClickListener = otherButtonClickListener;
        return this;
    }

    public MessageDialog setOtherButton(CharSequence otherText, OnDialogButtonClickListener<MessageDialog> otherButtonClickListener) {
        this.otherText = otherText;
        this.otherButtonClickListener = otherButtonClickListener;
        this.refreshUI();
        return this;
    }

    public MessageDialog setOtherButton(int otherTextResId, OnDialogButtonClickListener<MessageDialog> otherButtonClickListener) {
        this.otherText = this.getString(otherTextResId);
        this.otherButtonClickListener = otherButtonClickListener;
        this.refreshUI();
        return this;
    }

    public OnDialogButtonClickListener<MessageDialog> getOkButtonClickListener() {
        return (OnDialogButtonClickListener)this.okButtonClickListener;
    }

    public MessageDialog setOkButtonClickListener(OnDialogButtonClickListener<MessageDialog> okButtonClickListener) {
        this.okButtonClickListener = okButtonClickListener;
        return this;
    }

    public OnDialogButtonClickListener<MessageDialog> getCancelButtonClickListener() {
        return (OnDialogButtonClickListener)this.cancelButtonClickListener;
    }

    public MessageDialog setCancelButtonClickListener(OnDialogButtonClickListener<MessageDialog> cancelButtonClickListener) {
        this.cancelButtonClickListener = cancelButtonClickListener;
        return this;
    }

    public OnDialogButtonClickListener<MessageDialog> getOtherButtonClickListener() {
        return (OnDialogButtonClickListener)this.otherButtonClickListener;
    }

    public MessageDialog setOtherButtonClickListener(OnDialogButtonClickListener<MessageDialog> otherButtonClickListener) {
        this.otherButtonClickListener = otherButtonClickListener;
        return this;
    }

    public CharSequence getTitle() {
        return this.title;
    }

    public MessageDialog setTitle(CharSequence title) {
        this.title = title;
        this.refreshUI();
        return this;
    }

    public MessageDialog setTitle(int titleResId) {
        this.title = this.getString(titleResId);
        this.refreshUI();
        return this;
    }

    public CharSequence getMessage() {
        return this.message;
    }

    public MessageDialog setMessage(CharSequence message) {
        this.message = message;
        this.refreshUI();
        return this;
    }

    public MessageDialog setMessage(int messageResId) {
        this.message = this.getString(messageResId);
        this.refreshUI();
        return this;
    }

    public TextInfo getTitleTextInfo() {
        return this.titleTextInfo;
    }

    public MessageDialog setTitleTextInfo(TextInfo titleTextInfo) {
        this.titleTextInfo = titleTextInfo;
        this.refreshUI();
        return this;
    }

    public TextInfo getMessageTextInfo() {
        return this.messageTextInfo;
    }

    public MessageDialog setMessageTextInfo(TextInfo messageTextInfo) {
        this.messageTextInfo = messageTextInfo;
        this.refreshUI();
        return this;
    }

    public TextInfo getOkTextInfo() {
        return this.okTextInfo;
    }

    public MessageDialog setOkTextInfo(TextInfo okTextInfo) {
        this.okTextInfo = okTextInfo;
        this.refreshUI();
        return this;
    }

    public MessageDialog setHapticFeedbackEnabled(boolean isHapticFeedbackEnabled) {
        this.isHapticFeedbackEnabled = isHapticFeedbackEnabled ? 1 : 0;
        return this;
    }

    public TextInfo getCancelTextInfo() {
        return this.cancelTextInfo;
    }

    public MessageDialog setCancelTextInfo(TextInfo cancelTextInfo) {
        this.cancelTextInfo = cancelTextInfo;
        this.refreshUI();
        return this;
    }

    public TextInfo getOtherTextInfo() {
        return this.otherTextInfo;
    }

    public MessageDialog setOtherTextInfo(TextInfo otherTextInfo) {
        this.otherTextInfo = otherTextInfo;
        this.refreshUI();
        return this;
    }

    public int getButtonOrientation() {
        return this.buttonOrientation;
    }

    public MessageDialog setButtonOrientation(int buttonOrientation) {
        this.buttonOrientation = buttonOrientation;
        this.refreshUI();
        return this;
    }

    @Override
    public boolean isCancelable() {
        if (this.privateCancelable != null) {
            return this.privateCancelable == BaseDialog.BOOLEAN.TRUE;
        }
        if (overrideCancelable != null) {
            return overrideCancelable == BaseDialog.BOOLEAN.TRUE;
        }
        return this.cancelable;
    }

    public MessageDialog setCancelable(boolean cancelable) {
        this.privateCancelable = cancelable ? BaseDialog.BOOLEAN.TRUE : BaseDialog.BOOLEAN.FALSE;
        this.refreshUI();
        return this;
    }

    public OnBackPressedListener<MessageDialog> getOnBackPressedListener() {
        return this.onBackPressedListener;
    }

    public MessageDialog setOnBackPressedListener(OnBackPressedListener<MessageDialog> onBackPressedListener) {
        this.onBackPressedListener = onBackPressedListener;
        return this;
    }

    public DialogImpl getDialogImpl() {
        return this.dialogImpl;
    }

    public MessageDialog setCustomView(OnBindView<MessageDialog> onBindView) {
        this.onBindView = onBindView;
        this.refreshUI();
        return this;
    }

    public View getCustomView() {
        if (this.onBindView == null) {
            return null;
        }
        return this.onBindView.getCustomView();
    }

    public MessageDialog removeCustomView() {
        this.onBindView.clean();
        this.refreshUI();
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public MessageDialog setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.refreshUI();
        return this;
    }

    public String getInputText() {
        if (this.dialogImpl.txtInput != null) {
            return this.dialogImpl.txtInput.getText().toString();
        }
        return "";
    }

    public MessageDialog setBackgroundColorRes(@ColorRes int backgroundColorResId) {
        this.backgroundColor = this.getColor(backgroundColorResId);
        this.refreshUI();
        return this;
    }

    public MessageDialog setMaskColor(@ColorInt int maskColor) {
        this.maskColor = maskColor;
        this.refreshUI();
        return this;
    }

    public long getEnterAnimDuration() {
        return this.enterAnimDuration;
    }

    public MessageDialog setEnterAnimDuration(long enterAnimDuration) {
        this.enterAnimDuration = enterAnimDuration;
        return this;
    }

    public long getExitAnimDuration() {
        return this.exitAnimDuration;
    }

    public MessageDialog setExitAnimDuration(long exitAnimDuration) {
        this.exitAnimDuration = exitAnimDuration;
        return this;
    }

    @Override
    public void restartDialog() {
        int layoutId;
        if (this.getDialogView() != null) {
            MessageDialog.dismiss(this.getDialogView());
            this.isShow = false;
        }
        if (this.getDialogImpl().boxCustom != null) {
            this.getDialogImpl().boxCustom.removeAllViews();
        }
        if (this.getDialogImpl().boxList != null) {
            this.getDialogImpl().boxList.removeAllViews();
        }
        layoutId = (layoutId = this.style.layout(this.isLightTheme())) == 0 ? (this.isLightTheme() ? R.layout.layout_dialogx_material : R.layout.layout_dialogx_material_dark) : layoutId;
        this.enterAnimDuration = 0L;
        View dialogView = this.createView(layoutId);
        this.dialogImpl = new DialogImpl(dialogView);
        if (dialogView != null) {
            dialogView.setTag((Object)this.me);
        }
        MessageDialog.show(dialogView);
    }

    public void hide() {
        this.isHide = true;
        this.hideWithExitAnim = false;
        if (this.getDialogView() != null) {
            this.getDialogView().setVisibility(8);
        }
    }

    public void hideWithExitAnim() {
        this.hideWithExitAnim = true;
        this.isHide = true;
        if (this.getDialogImpl() != null) {
            this.getDialogImpl().getDialogXAnimImpl().doExitAnim(this.me, (ViewGroup)this.getDialogImpl().bkg);
            MessageDialog.runOnMainDelay(new Runnable(){

                @Override
                public void run() {
                    if (MessageDialog.this.getDialogView() != null) {
                        MessageDialog.this.getDialogView().setVisibility(8);
                    }
                }
            }, this.getDialogImpl().getExitAnimationDuration(null));
        }
    }

    public MessageDialog setAnimResId(int enterResId, int exitResId) {
        this.customEnterAnimResId = enterResId;
        this.customExitAnimResId = exitResId;
        return this;
    }

    public MessageDialog setEnterAnimResId(int enterResId) {
        this.customEnterAnimResId = enterResId;
        return this;
    }

    public MessageDialog setExitAnimResId(int exitResId) {
        this.customExitAnimResId = exitResId;
        return this;
    }

    @Override
    protected void shutdown() {
        this.dismiss();
    }

    public MessageDialog setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.refreshUI();
        return this;
    }

    public MessageDialog setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        this.refreshUI();
        return this;
    }

    public MessageDialog setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        this.refreshUI();
        return this;
    }

    public MessageDialog setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        this.refreshUI();
        return this;
    }

    public MessageDialog setDialogImplMode(DialogX.IMPL_MODE dialogImplMode) {
        this.dialogImplMode = dialogImplMode;
        return this;
    }

    public boolean isBkgInterceptTouch() {
        return this.bkgInterceptTouch;
    }

    public MessageDialog setBkgInterceptTouch(boolean bkgInterceptTouch) {
        this.bkgInterceptTouch = bkgInterceptTouch;
        return this;
    }

    public OnBackgroundMaskClickListener<MessageDialog> getOnBackgroundMaskClickListener() {
        return this.onBackgroundMaskClickListener;
    }

    public MessageDialog setOnBackgroundMaskClickListener(OnBackgroundMaskClickListener<MessageDialog> onBackgroundMaskClickListener) {
        this.onBackgroundMaskClickListener = onBackgroundMaskClickListener;
        return this;
    }

    public MessageDialog setRadius(float radiusPx) {
        this.backgroundRadius = radiusPx;
        this.refreshUI();
        return this;
    }

    public float getRadius() {
        return this.backgroundRadius;
    }

    public Drawable getTitleIcon() {
        return this.titleIcon;
    }

    public MessageDialog setTitleIcon(Bitmap titleIcon) {
        this.titleIcon = new BitmapDrawable(this.getResources(), titleIcon);
        this.refreshUI();
        return this;
    }

    public MessageDialog setTitleIcon(int titleIconResId) {
        this.titleIcon = this.getResources().getDrawable(titleIconResId);
        this.refreshUI();
        return this;
    }

    public MessageDialog setTitleIcon(Drawable titleIcon) {
        this.titleIcon = titleIcon;
        this.refreshUI();
        return this;
    }

    public DialogXAnimInterface<MessageDialog> getDialogXAnimImpl() {
        return this.dialogXAnimImpl;
    }

    public MessageDialog setDialogXAnimImpl(DialogXAnimInterface<MessageDialog> dialogXAnimImpl) {
        this.dialogXAnimImpl = dialogXAnimImpl;
        return this;
    }

    public MessageDialog setRootPadding(int padding) {
        this.screenPaddings = new int[]{padding, padding, padding, padding};
        this.refreshUI();
        return this;
    }

    public MessageDialog setRootPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.screenPaddings = new int[]{paddingLeft, paddingTop, paddingRight, paddingBottom};
        this.refreshUI();
        return this;
    }

    public BaseDialog.BUTTON_SELECT_RESULT getButtonSelectResult() {
        return this.buttonSelectResult;
    }

    protected void onShow(MessageDialog dialog) {
    }

    protected void onDismiss(MessageDialog dialog) {
    }

    @Override
    public MessageDialog setData(String key, Object obj) {
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.data.put(key, obj);
        return this;
    }

    public MessageDialog onShow(DialogXRunnable<MessageDialog> dialogXRunnable) {
        this.onShowRunnable = dialogXRunnable;
        if (this.isShow() && this.onShowRunnable != null) {
            this.onShowRunnable.run(this);
        }
        return this;
    }

    public MessageDialog onDismiss(DialogXRunnable<MessageDialog> dialogXRunnable) {
        this.onDismissRunnable = dialogXRunnable;
        return this;
    }

    @Override
    public MessageDialog setEnableImmersiveMode(boolean enableImmersiveMode) {
        this.enableImmersiveMode = enableImmersiveMode;
        this.refreshUI();
        return this;
    }

    public MessageDialog appendMessage(CharSequence message) {
        this.message = TextUtils.concat((CharSequence[])new CharSequence[]{this.message, message});
        this.refreshUI();
        return this;
    }

    @Override
    public MessageDialog setThisOrderIndex(int orderIndex) {
        this.thisOrderIndex = orderIndex;
        if (this.getDialogView() != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.getDialogView().setTranslationZ((float)orderIndex);
            } else {
                MessageDialog.error("DialogX: " + this.dialogKey() + " \u6267\u884c .setThisOrderIndex(" + orderIndex + ") \u5931\u8d25\uff1a\u7cfb\u7edf\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0cSDK-API \u7248\u672c\u5fc5\u987b\u5927\u4e8e 21\uff08LOLLIPOP\uff09");
            }
        }
        return this;
    }

    public MessageDialog bringToFront() {
        this.setThisOrderIndex(this.getHighestOrderIndex());
        return this;
    }

    public class DialogImpl
    implements DialogConvertViewInterface {
        private List<View> blurViews;
        public DialogXBaseRelativeLayout boxRoot;
        public MaxRelativeLayout bkg;
        public TextView txtDialogTitle;
        public ScrollController scrollView;
        public TextView txtDialogTip;
        public ViewGroup boxList;
        public RelativeLayout boxCustom;
        public EditText txtInput;
        public LinearLayout boxButton;
        public TextView btnSelectOther;
        public View spaceOtherButton;
        public View splitHorizontal;
        public TextView btnSelectNegative;
        public TextView btnSelectPositive;

        public DialogImpl(View convertView) {
            if (convertView == null) {
                return;
            }
            MessageDialog.this.setDialogView(convertView);
            this.boxRoot = (DialogXBaseRelativeLayout)convertView.findViewById(R.id.box_root);
            this.bkg = (MaxRelativeLayout)convertView.findViewById(R.id.bkg);
            this.txtDialogTitle = (TextView)convertView.findViewById(R.id.txt_dialog_title);
            this.scrollView = (ScrollController)convertView.findViewById(R.id.scrollView);
            this.txtDialogTip = (TextView)convertView.findViewById(R.id.txt_dialog_tip);
            this.boxList = (ViewGroup)convertView.findViewById(R.id.box_list);
            this.boxCustom = (RelativeLayout)convertView.findViewById(R.id.box_custom);
            this.txtInput = (EditText)convertView.findViewById(R.id.txt_input);
            this.boxButton = (LinearLayout)convertView.findViewById(R.id.box_button);
            this.btnSelectOther = (TextView)convertView.findViewById(R.id.btn_selectOther);
            this.spaceOtherButton = convertView.findViewById(R.id.space_other_button);
            this.splitHorizontal = convertView.findViewWithTag((Object)"split");
            this.btnSelectNegative = (TextView)convertView.findViewById(R.id.btn_selectNegative);
            this.btnSelectPositive = (TextView)convertView.findViewById(R.id.btn_selectPositive);
            this.blurViews = MessageDialog.this.findAllBlurView(convertView);
            this.init();
            MessageDialog.this.dialogImpl = this;
            this.refreshView();
        }

        @Override
        public void init() {
            MessageDialog.this.buttonSelectResult = BaseDialog.BUTTON_SELECT_RESULT.NONE;
            if (Build.VERSION.SDK_INT >= 21) {
                MessageDialog.this.getDialogView().setTranslationZ((float)MessageDialog.this.getThisOrderIndex());
            }
            if (MessageDialog.this.titleTextInfo == null) {
                MessageDialog.this.titleTextInfo = DialogX.titleTextInfo;
            }
            if (MessageDialog.this.messageTextInfo == null) {
                MessageDialog.this.messageTextInfo = DialogX.messageTextInfo;
            }
            if (MessageDialog.this.okTextInfo == null) {
                MessageDialog.this.okTextInfo = DialogX.okButtonTextInfo;
            }
            if (MessageDialog.this.okTextInfo == null) {
                MessageDialog.this.okTextInfo = DialogX.buttonTextInfo;
            }
            if (MessageDialog.this.cancelTextInfo == null) {
                MessageDialog.this.cancelTextInfo = DialogX.buttonTextInfo;
            }
            if (MessageDialog.this.otherTextInfo == null) {
                MessageDialog.this.otherTextInfo = DialogX.buttonTextInfo;
            }
            if (MessageDialog.this.inputInfo == null) {
                MessageDialog.this.inputInfo = DialogX.inputInfo;
            }
            if (MessageDialog.this.backgroundColor == null) {
                MessageDialog.this.backgroundColor = DialogX.backgroundColor;
            }
            this.txtDialogTitle.getPaint().setFakeBoldText(true);
            this.btnSelectNegative.getPaint().setFakeBoldText(true);
            this.btnSelectPositive.getPaint().setFakeBoldText(true);
            this.btnSelectOther.getPaint().setFakeBoldText(true);
            this.txtDialogTip.setMovementMethod(LinkMovementMethod.getInstance());
            this.boxRoot.setBkgAlpha(0.0f);
            this.boxRoot.setParentDialog(MessageDialog.this.me);
            this.boxRoot.setOnLifecycleCallBack(new DialogXBaseRelativeLayout.OnLifecycleCallBack(){

                @Override
                public void onShow() {
                    MessageDialog.this.isShow = true;
                    MessageDialog.this.preShow = false;
                    MessageDialog.this.setLifecycleState(Lifecycle.State.CREATED);
                    MessageDialog.this.onDialogShow();
                    MessageDialog.this.getDialogLifecycleCallback().onShow(MessageDialog.this.me);
                    MessageDialog.this.onShow(MessageDialog.this.me);
                    DialogImpl.this.getDialogXAnimImpl().doShowAnim(MessageDialog.this.me, (ViewGroup)DialogImpl.this.bkg);
                    if (MessageDialog.this.style.messageDialogBlurSettings() != null && MessageDialog.this.style.messageDialogBlurSettings().blurBackground()) {
                        DialogImpl.this.bkg.post(new Runnable(){

                            @Override
                            public void run() {
                                Integer blurFrontColor = null;
                                Float dialogXRadius = null;
                                if (MessageDialog.this.style.messageDialogBlurSettings() != null) {
                                    blurFrontColor = MessageDialog.this.getColorNullable(MessageDialog.this.getIntStyleAttr(MessageDialog.this.style.messageDialogBlurSettings().blurForwardColorRes(MessageDialog.this.isLightTheme())));
                                    dialogXRadius = MessageDialog.this.getFloatStyleAttr(Float.valueOf(MessageDialog.this.style.messageDialogBlurSettings().blurBackgroundRoundRadiusPx()));
                                }
                                if (DialogImpl.this.blurViews != null) {
                                    for (View blurView : DialogImpl.this.blurViews) {
                                        ((BlurViewType)blurView).setOverlayColor(MessageDialog.this.backgroundColor == null ? blurFrontColor : MessageDialog.this.backgroundColor);
                                        ((BlurViewType)blurView).setRadiusPx(dialogXRadius);
                                    }
                                }
                                MessageDialog.this.setLifecycleState(Lifecycle.State.RESUMED);
                            }
                        });
                    }
                    if (MessageDialog.this.autoShowInputKeyboard) {
                        DialogImpl.this.txtInput.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                if (DialogImpl.this.txtInput == null) {
                                    return;
                                }
                                DialogImpl.this.txtInput.requestFocus();
                                DialogImpl.this.txtInput.setFocusableInTouchMode(true);
                                MessageDialog.this.imeShow(DialogImpl.this.txtInput, true);
                                DialogImpl.this.txtInput.setSelection(DialogImpl.this.txtInput.getText().length());
                                if (MessageDialog.this.inputInfo != null && MessageDialog.this.inputInfo.isSelectAllText()) {
                                    DialogImpl.this.txtInput.selectAll();
                                }
                            }
                        }, 300L);
                    } else if (MessageDialog.this.inputInfo != null && MessageDialog.this.inputInfo.isSelectAllText()) {
                        DialogImpl.this.txtInput.clearFocus();
                        DialogImpl.this.txtInput.requestFocus();
                        DialogImpl.this.txtInput.selectAll();
                    }
                }

                @Override
                public void onDismiss() {
                    MessageDialog.this.isShow = false;
                    MessageDialog.this.getDialogLifecycleCallback().onDismiss(MessageDialog.this.me);
                    MessageDialog.this.onDismiss(MessageDialog.this.me);
                    MessageDialog.this.dialogLifecycleCallback = null;
                    MessageDialog.this.setLifecycleState(Lifecycle.State.DESTROYED);
                    System.gc();
                }
            });
            this.boxRoot.setOnBackPressedListener(new DialogXBaseRelativeLayout.PrivateBackPressedListener(){

                @Override
                public boolean onBackPressed() {
                    if (MessageDialog.this.onBackPressedListener != null) {
                        if (MessageDialog.this.onBackPressedListener.onBackPressed(MessageDialog.this.me)) {
                            MessageDialog.this.dismiss();
                        }
                    } else if (MessageDialog.this.isCancelable()) {
                        MessageDialog.this.dismiss();
                    }
                    return true;
                }
            });
            this.btnSelectPositive.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MessageDialog.this.buttonSelectResult = BaseDialog.BUTTON_SELECT_RESULT.BUTTON_OK;
                    if (DialogImpl.this.txtInput != null) {
                        MessageDialog.this.imeShow(DialogImpl.this.txtInput, false);
                    }
                    MessageDialog.this.haptic(v);
                    if (MessageDialog.this.okButtonClickListener != null) {
                        if (MessageDialog.this.okButtonClickListener instanceof OnInputDialogButtonClickListener) {
                            String s;
                            String string = s = DialogImpl.this.txtInput == null ? "" : DialogImpl.this.txtInput.getText().toString();
                            if (!((OnInputDialogButtonClickListener)MessageDialog.this.okButtonClickListener).onClick(MessageDialog.this.me, v, s)) {
                                DialogImpl.this.doDismiss(v);
                            }
                        } else if (MessageDialog.this.okButtonClickListener instanceof OnDialogButtonClickListener) {
                            if (!((OnDialogButtonClickListener)MessageDialog.this.okButtonClickListener).onClick(MessageDialog.this.me, v)) {
                                DialogImpl.this.doDismiss(v);
                            }
                        } else if (MessageDialog.this.okButtonClickListener instanceof OnMenuButtonClickListener && !((OnMenuButtonClickListener)MessageDialog.this.okButtonClickListener).onClick(MessageDialog.this.me, v)) {
                            DialogImpl.this.doDismiss(v);
                        }
                    } else {
                        DialogImpl.this.doDismiss(v);
                    }
                }
            });
            this.btnSelectNegative.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MessageDialog.this.buttonSelectResult = BaseDialog.BUTTON_SELECT_RESULT.BUTTON_CANCEL;
                    if (DialogImpl.this.txtInput != null) {
                        MessageDialog.this.imeShow(DialogImpl.this.txtInput, false);
                    }
                    MessageDialog.this.haptic(v);
                    if (MessageDialog.this.cancelButtonClickListener != null) {
                        if (MessageDialog.this.cancelButtonClickListener instanceof OnInputDialogButtonClickListener) {
                            String s;
                            String string = s = DialogImpl.this.txtInput == null ? "" : DialogImpl.this.txtInput.getText().toString();
                            if (!((OnInputDialogButtonClickListener)MessageDialog.this.cancelButtonClickListener).onClick(MessageDialog.this.me, v, s)) {
                                DialogImpl.this.doDismiss(v);
                            }
                        } else if (MessageDialog.this.cancelButtonClickListener instanceof OnMenuButtonClickListener) {
                            if (!((OnMenuButtonClickListener)MessageDialog.this.cancelButtonClickListener).onClick(MessageDialog.this.me, v)) {
                                DialogImpl.this.doDismiss(v);
                            }
                        } else if (!((OnDialogButtonClickListener)MessageDialog.this.cancelButtonClickListener).onClick(MessageDialog.this.me, v)) {
                            DialogImpl.this.doDismiss(v);
                        }
                    } else {
                        DialogImpl.this.doDismiss(v);
                    }
                }
            });
            this.btnSelectOther.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MessageDialog.this.buttonSelectResult = BaseDialog.BUTTON_SELECT_RESULT.BUTTON_OTHER;
                    if (DialogImpl.this.txtInput != null) {
                        MessageDialog.this.imeShow(DialogImpl.this.txtInput, false);
                    }
                    MessageDialog.this.haptic(v);
                    if (MessageDialog.this.otherButtonClickListener != null) {
                        if (MessageDialog.this.otherButtonClickListener instanceof OnInputDialogButtonClickListener) {
                            String s;
                            String string = s = DialogImpl.this.txtInput == null ? "" : DialogImpl.this.txtInput.getText().toString();
                            if (!((OnInputDialogButtonClickListener)MessageDialog.this.otherButtonClickListener).onClick(MessageDialog.this.me, v, s)) {
                                DialogImpl.this.doDismiss(v);
                            }
                        } else if (MessageDialog.this.otherButtonClickListener instanceof OnMenuButtonClickListener) {
                            if (!((OnMenuButtonClickListener)MessageDialog.this.otherButtonClickListener).onClick(MessageDialog.this.me, v)) {
                                DialogImpl.this.doDismiss(v);
                            }
                        } else if (!((OnDialogButtonClickListener)MessageDialog.this.otherButtonClickListener).onClick(MessageDialog.this.me, v)) {
                            DialogImpl.this.doDismiss(v);
                        }
                    } else {
                        DialogImpl.this.doDismiss(v);
                    }
                }
            });
            MessageDialog.this.onDialogInit();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void refreshView() {
            block68: {
                block67: {
                    block64: {
                        LinearLayout.LayoutParams spaceLp;
                        Space space;
                        int n;
                        int[] blurView22;
                        int n2;
                        block66: {
                            int n3;
                            int[] blurView22;
                            block65: {
                                block63: {
                                    int n4;
                                    int n5;
                                    block60: {
                                        int cursorColor;
                                        block62: {
                                            if (this.boxRoot == null || MessageDialog.this.getOwnActivity() == null) {
                                                return;
                                            }
                                            this.boxRoot.setAutoUnsafePlacePadding(MessageDialog.this.isEnableImmersiveMode());
                                            if (MessageDialog.this.inputInfo != null && MessageDialog.this.inputInfo.getBottomLineColor() != null) {
                                                this.txtInput.getBackground().mutate().setColorFilter(MessageDialog.this.inputInfo.getBottomLineColor().intValue(), PorterDuff.Mode.SRC_ATOP);
                                            }
                                            if (MessageDialog.this.inputInfo == null || MessageDialog.this.inputInfo.getCursorColor() == null) break block60;
                                            cursorColor = MessageDialog.this.inputInfo.getCursorColor();
                                            if (Build.VERSION.SDK_INT < 29) break block62;
                                            if (this.txtInput.getTextCursorDrawable() != null) {
                                                this.txtInput.getTextCursorDrawable().mutate().setColorFilter((ColorFilter)new PorterDuffColorFilter(cursorColor, PorterDuff.Mode.SRC_ATOP));
                                                break block60;
                                            } else {
                                                try {
                                                    Field field = TextView.class.getDeclaredField("mCursorDrawableRes");
                                                    field.setAccessible(true);
                                                    field.set(this.txtInput, R.drawable.rect_dialogx_defalut_edittxt_cursor);
                                                    this.txtInput.getTextCursorDrawable().mutate().setColorFilter((ColorFilter)new PorterDuffColorFilter(cursorColor, PorterDuff.Mode.SRC_ATOP));
                                                }
                                                catch (Throwable throwable) {
                                                    MessageDialog.log("DialogX: \u5728\u5bf9\u8bdd\u6846" + MessageDialog.this.dialogKey() + "\u4e2d\u8bbe\u7f6e\u5149\u6807\u989c\u8272\u65f6\u53d1\u751f\u9519\u8bef\uff01");
                                                    if (DialogX.DEBUGMODE) {
                                                        throwable.printStackTrace();
                                                    }
                                                    break block60;
                                                }
                                            }
                                        }
                                        try {
                                            Field field = TextView.class.getDeclaredField("mCursorDrawableRes");
                                            field.setAccessible(true);
                                            int mCursorDrawableRes = field.getInt(this.txtInput);
                                            Field fEditor = TextView.class.getDeclaredField("mEditor");
                                            fEditor.setAccessible(true);
                                            Object editor = fEditor.get(this.txtInput);
                                            Class<?> clazz = editor.getClass();
                                            Field fCursorDrawable = clazz.getDeclaredField("mCursorDrawable");
                                            fCursorDrawable.setAccessible(true);
                                            Drawable[] drawables = new Drawable[]{this.txtInput.getContext().getResources().getDrawable(mCursorDrawableRes), this.txtInput.getContext().getResources().getDrawable(mCursorDrawableRes)};
                                            drawables[0].setColorFilter(cursorColor, PorterDuff.Mode.SRC_IN);
                                            drawables[1].setColorFilter(cursorColor, PorterDuff.Mode.SRC_IN);
                                            fCursorDrawable.set(editor, drawables);
                                        }
                                        catch (Throwable throwable) {
                                            MessageDialog.log("DialogX: \u5728\u5bf9\u8bdd\u6846" + MessageDialog.this.dialogKey() + "\u4e2d\u8bbe\u7f6e\u5149\u6807\u989c\u8272\u65f6\u53d1\u751f\u9519\u8bef\uff01");
                                            if (!DialogX.DEBUGMODE) break block60;
                                            throwable.printStackTrace();
                                        }
                                    }
                                    this.boxRoot.setRootPadding(MessageDialog.this.screenPaddings[0], MessageDialog.this.screenPaddings[1], MessageDialog.this.screenPaddings[2], MessageDialog.this.screenPaddings[3]);
                                    if (MessageDialog.this.backgroundColor != null) {
                                        MessageDialog.this.tintColor((View)this.bkg, MessageDialog.this.backgroundColor);
                                        if (MessageDialog.this.style instanceof MaterialStyle) {
                                            MessageDialog.this.tintColor((View)this.btnSelectOther, MessageDialog.this.backgroundColor);
                                            MessageDialog.this.tintColor((View)this.btnSelectNegative, MessageDialog.this.backgroundColor);
                                            MessageDialog.this.tintColor((View)this.btnSelectPositive, MessageDialog.this.backgroundColor);
                                        }
                                        if (this.blurViews != null) {
                                            MessageDialog.log("#blurViews != null");
                                            for (View view : this.blurViews) {
                                                MessageDialog.log("#blurView: " + view);
                                                ((BlurViewType)view).setOverlayColor(MessageDialog.this.backgroundColor);
                                            }
                                        }
                                    }
                                    this.bkg.setMaxWidth(MessageDialog.this.getMaxWidth());
                                    this.bkg.setMaxHeight(MessageDialog.this.getMaxHeight());
                                    this.bkg.setMinimumWidth(MessageDialog.this.getMinWidth());
                                    this.bkg.setMinimumHeight(MessageDialog.this.getMinHeight());
                                    View inputBoxView = this.boxRoot.findViewWithTag("dialogx_editbox");
                                    if (MessageDialog.this.me instanceof InputDialog) {
                                        if (inputBoxView != null) {
                                            inputBoxView.setVisibility(0);
                                        }
                                        this.txtInput.setVisibility(0);
                                        this.boxRoot.bindFocusView((View)this.txtInput);
                                    } else {
                                        if (inputBoxView != null) {
                                            inputBoxView.setVisibility(8);
                                        }
                                        this.txtInput.setVisibility(8);
                                    }
                                    this.boxRoot.setClickable(true);
                                    if (MessageDialog.this.maskColor != null) {
                                        this.boxRoot.setBackgroundColor(MessageDialog.this.maskColor);
                                    }
                                    if (MessageDialog.this.backgroundRadius > -1.0f) {
                                        if (Build.VERSION.SDK_INT >= 21) {
                                            this.bkg.setOutlineProvider(new ViewOutlineProvider(){

                                                public void getOutline(View view, Outline outline) {
                                                    outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), MessageDialog.this.backgroundRadius);
                                                }
                                            });
                                            this.bkg.setClipToOutline(true);
                                        }
                                        if (this.blurViews != null) {
                                            for (View blurView22 : this.blurViews) {
                                                ((BlurViewType)blurView22).setRadiusPx(Float.valueOf(MessageDialog.this.backgroundRadius));
                                            }
                                        }
                                    }
                                    MessageDialog.this.showText(this.txtDialogTitle, MessageDialog.this.title);
                                    MessageDialog.this.showText(this.txtDialogTip, MessageDialog.this.message);
                                    MessageDialog.this.showText(this.btnSelectPositive, MessageDialog.this.okText);
                                    MessageDialog.this.showText(this.btnSelectNegative, MessageDialog.this.cancelText);
                                    MessageDialog.this.showText(this.btnSelectOther, MessageDialog.this.otherText);
                                    this.txtInput.setText((CharSequence)MessageDialog.this.inputText);
                                    this.txtInput.setHint((CharSequence)MessageDialog.this.inputHintText);
                                    if (this.spaceOtherButton != null) {
                                        if (MessageDialog.this.otherText == null) {
                                            this.spaceOtherButton.setVisibility(8);
                                        } else {
                                            this.spaceOtherButton.setVisibility(0);
                                        }
                                    }
                                    BaseDialog.useTextInfo(this.txtDialogTitle, MessageDialog.this.titleTextInfo);
                                    BaseDialog.useTextInfo(this.txtDialogTip, MessageDialog.this.messageTextInfo);
                                    BaseDialog.useTextInfo(this.btnSelectPositive, MessageDialog.this.okTextInfo);
                                    BaseDialog.useTextInfo(this.btnSelectNegative, MessageDialog.this.cancelTextInfo);
                                    BaseDialog.useTextInfo(this.btnSelectOther, MessageDialog.this.otherTextInfo);
                                    if (MessageDialog.this.titleIcon != null) {
                                        int n6 = (int)this.txtDialogTitle.getTextSize();
                                        MessageDialog.this.titleIcon.setBounds(0, 0, n6, n6);
                                        this.txtDialogTitle.setCompoundDrawablePadding(MessageDialog.this.dip2px(10.0f));
                                        this.txtDialogTitle.setCompoundDrawables(MessageDialog.this.titleIcon, null, null, null);
                                    }
                                    if (MessageDialog.this.inputInfo != null) {
                                        int n7;
                                        if (MessageDialog.this.inputInfo.getMAX_LENGTH() != -1) {
                                            this.txtInput.setFilters(new InputFilter[]{new InputFilter.LengthFilter(MessageDialog.this.inputInfo.getMAX_LENGTH())});
                                        }
                                        int n8 = 1 | MessageDialog.this.inputInfo.getInputType();
                                        if (MessageDialog.this.inputInfo.isMultipleLines()) {
                                            n7 = n8 | 0x20000;
                                        }
                                        this.txtInput.setInputType(n7);
                                        if (MessageDialog.this.inputInfo.getTextInfo() != null) {
                                            BaseDialog.useTextInfo((TextView)this.txtInput, MessageDialog.this.inputInfo.getTextInfo());
                                        }
                                        if (MessageDialog.this.inputInfo.getInputFilters() != null && MessageDialog.this.inputInfo.getInputFilters().length > 0) {
                                            this.txtInput.setFilters(MessageDialog.this.inputInfo.getInputFilters());
                                        }
                                    }
                                    int n9 = 0;
                                    if (!BaseDialog.isNull(MessageDialog.this.okText)) {
                                        n5 = n9 + 1;
                                    }
                                    if (!BaseDialog.isNull(MessageDialog.this.cancelText)) {
                                        n4 = n5 + 1;
                                    }
                                    if (!BaseDialog.isNull(MessageDialog.this.otherText)) {
                                        n2 = n4 + 1;
                                    }
                                    if (this.splitHorizontal != null) {
                                        this.splitHorizontal.setBackgroundColor(MessageDialog.this.getColor(MessageDialog.this.style.splitColorRes(MessageDialog.this.isLightTheme())));
                                    }
                                    this.boxButton.setOrientation(MessageDialog.this.buttonOrientation);
                                    if (MessageDialog.this.buttonOrientation != 1) break block63;
                                    if (MessageDialog.this.style.verticalButtonOrder() == null || MessageDialog.this.style.verticalButtonOrder().length == 0) break block64;
                                    this.boxButton.removeAllViews();
                                    blurView22 = MessageDialog.this.style.verticalButtonOrder();
                                    n3 = blurView22.length;
                                    break block65;
                                }
                                if (MessageDialog.this.style.horizontalButtonOrder() == null || MessageDialog.this.style.horizontalButtonOrder().length == 0) break block64;
                                this.boxButton.removeAllViews();
                                blurView22 = MessageDialog.this.style.horizontalButtonOrder();
                                n = blurView22.length;
                                break block66;
                            }
                            block20: for (int i = 0; i < n3; ++i) {
                                int buttonType = blurView22[i];
                                switch (buttonType) {
                                    case 1: {
                                        this.boxButton.addView((View)this.btnSelectPositive);
                                        if (MessageDialog.this.style.overrideVerticalButtonRes() == null) continue block20;
                                        this.btnSelectPositive.setBackgroundResource(MessageDialog.this.style.overrideVerticalButtonRes().overrideVerticalOkButtonBackgroundRes(n2, MessageDialog.this.isLightTheme()));
                                        continue block20;
                                    }
                                    case 3: {
                                        this.boxButton.addView((View)this.btnSelectOther);
                                        if (MessageDialog.this.style.overrideVerticalButtonRes() == null) continue block20;
                                        this.btnSelectOther.setBackgroundResource(MessageDialog.this.style.overrideVerticalButtonRes().overrideVerticalOtherButtonBackgroundRes(n2, MessageDialog.this.isLightTheme()));
                                        continue block20;
                                    }
                                    case 2: {
                                        this.boxButton.addView((View)this.btnSelectNegative);
                                        if (MessageDialog.this.style.overrideVerticalButtonRes() == null) continue block20;
                                        this.btnSelectNegative.setBackgroundResource(MessageDialog.this.style.overrideVerticalButtonRes().overrideVerticalCancelButtonBackgroundRes(n2, MessageDialog.this.isLightTheme()));
                                        continue block20;
                                    }
                                    case 4: {
                                        space = new Space((Context)MessageDialog.this.getOwnActivity());
                                        spaceLp = new LinearLayout.LayoutParams(-1, -1);
                                        spaceLp.weight = 1.0f;
                                        this.boxButton.addView((View)space, (ViewGroup.LayoutParams)spaceLp);
                                        continue block20;
                                    }
                                    case 5: {
                                        View splitView = new View((Context)MessageDialog.this.getOwnActivity());
                                        splitView.setBackgroundColor(MessageDialog.this.getResources().getColor(MessageDialog.this.style.splitColorRes(MessageDialog.this.isLightTheme())));
                                        LinearLayout.LayoutParams viewLp = new LinearLayout.LayoutParams(-1, MessageDialog.this.style.splitWidthPx());
                                        this.boxButton.addView(splitView, (ViewGroup.LayoutParams)viewLp);
                                        continue block20;
                                    }
                                }
                            }
                            break block64;
                        }
                        block21: for (int i = 0; i < n; ++i) {
                            int buttonType = blurView22[i];
                            switch (buttonType) {
                                case 1: {
                                    this.boxButton.addView((View)this.btnSelectPositive);
                                    if (MessageDialog.this.style.overrideHorizontalButtonRes() == null) continue block21;
                                    this.btnSelectPositive.setBackgroundResource(MessageDialog.this.style.overrideHorizontalButtonRes().overrideHorizontalOkButtonBackgroundRes(n2, MessageDialog.this.isLightTheme()));
                                    continue block21;
                                }
                                case 3: {
                                    this.boxButton.addView((View)this.btnSelectOther);
                                    if (MessageDialog.this.style.overrideHorizontalButtonRes() == null) continue block21;
                                    this.btnSelectOther.setBackgroundResource(MessageDialog.this.style.overrideHorizontalButtonRes().overrideHorizontalOtherButtonBackgroundRes(n2, MessageDialog.this.isLightTheme()));
                                    continue block21;
                                }
                                case 2: {
                                    this.boxButton.addView((View)this.btnSelectNegative);
                                    if (MessageDialog.this.style.overrideHorizontalButtonRes() == null) continue block21;
                                    this.btnSelectNegative.setBackgroundResource(MessageDialog.this.style.overrideHorizontalButtonRes().overrideHorizontalCancelButtonBackgroundRes(n2, MessageDialog.this.isLightTheme()));
                                    continue block21;
                                }
                                case 4: {
                                    if (this.boxButton.getChildCount() < 1 || this.boxButton.getChildAt(this.boxButton.getChildCount() - 1).getVisibility() == 8) continue block21;
                                    space = new Space((Context)MessageDialog.this.getOwnActivity());
                                    spaceLp = new LinearLayout.LayoutParams(-1, -2);
                                    spaceLp.weight = 1.0f;
                                    this.boxButton.addView((View)space, (ViewGroup.LayoutParams)spaceLp);
                                    continue block21;
                                }
                                case 5: {
                                    if (this.boxButton.getChildCount() < 1 || this.boxButton.getChildAt(this.boxButton.getChildCount() - 1).getVisibility() == 8) continue block21;
                                    View splitView = new View((Context)MessageDialog.this.getOwnActivity());
                                    splitView.setBackgroundColor(MessageDialog.this.getResources().getColor(MessageDialog.this.style.splitColorRes(MessageDialog.this.isLightTheme())));
                                    LinearLayout.LayoutParams viewLp = new LinearLayout.LayoutParams(MessageDialog.this.style.splitWidthPx(), -1);
                                    this.boxButton.addView(splitView, (ViewGroup.LayoutParams)viewLp);
                                    continue block21;
                                }
                            }
                        }
                    }
                    if (MessageDialog.this.bkgInterceptTouch) {
                        if (MessageDialog.this.isCancelable()) {
                            this.boxRoot.setOnClickListener(new View.OnClickListener(){

                                public void onClick(View v) {
                                    if (MessageDialog.this.onBackgroundMaskClickListener == null || !MessageDialog.this.onBackgroundMaskClickListener.onClick(MessageDialog.this.me, v)) {
                                        DialogImpl.this.doDismiss(v);
                                    }
                                }
                            });
                        } else {
                            this.boxRoot.setOnClickListener(null);
                        }
                    } else {
                        this.boxRoot.setClickable(false);
                    }
                    if (MessageDialog.this.onBindView == null || MessageDialog.this.onBindView.getCustomView() == null) break block67;
                    MessageDialog.this.onBindView.bindParent((ViewGroup)this.boxCustom, MessageDialog.this.me);
                    this.boxCustom.setVisibility(0);
                    if (MessageDialog.this.onBindView.getCustomView() instanceof ScrollController) {
                        if (this.scrollView instanceof DialogScrollView) {
                            ((DialogScrollView)this.scrollView).setVerticalScrollBarEnabled(false);
                        }
                        this.scrollView = (ScrollController)MessageDialog.this.onBindView.getCustomView();
                        break block68;
                    } else {
                        View scrollController = MessageDialog.this.onBindView.getCustomView().findViewWithTag((Object)"ScrollController");
                        if (scrollController instanceof ScrollController) {
                            if (this.scrollView instanceof DialogScrollView) {
                                ((DialogScrollView)this.scrollView).setVerticalScrollBarEnabled(false);
                            }
                            this.scrollView = (ScrollController)scrollController;
                        }
                    }
                    break block68;
                }
                this.boxCustom.setVisibility(8);
            }
            MessageDialog.this.onDialogRefreshUI();
        }

        @Override
        public void doDismiss(View v) {
            if (MessageDialog.this.preDismiss(MessageDialog.this)) {
                return;
            }
            if (v != null) {
                v.setEnabled(false);
            }
            if (MessageDialog.this.getOwnActivity() == null) {
                return;
            }
            if (!MessageDialog.this.dismissAnimFlag && this.getDialogXAnimImpl() != null) {
                MessageDialog.this.dismissAnimFlag = true;
                this.getDialogXAnimImpl().doExitAnim(MessageDialog.this, (ViewGroup)this.bkg);
                MessageDialog.runOnMainDelay(new Runnable(){

                    @Override
                    public void run() {
                        if (DialogImpl.this.boxRoot != null) {
                            DialogImpl.this.boxRoot.setVisibility(8);
                        }
                        MessageDialog.dismiss(MessageDialog.this.getDialogView());
                    }
                }, this.getExitAnimationDuration(null));
            }
        }

        protected DialogXAnimInterface<MessageDialog> getDialogXAnimImpl() {
            if (MessageDialog.this.dialogXAnimImpl == null) {
                MessageDialog.this.dialogXAnimImpl = new DialogXAnimInterface<MessageDialog>(){

                    @Override
                    public void doShowAnim(MessageDialog dialog, ViewGroup dialogBodyView) {
                        int enterAnimResId;
                        int n = enterAnimResId = MessageDialog.this.style.enterAnimResId() == 0 ? R.anim.anim_dialogx_default_enter : MessageDialog.this.style.enterAnimResId();
                        if (overrideEnterAnimRes != 0) {
                            enterAnimResId = overrideEnterAnimRes;
                        }
                        if (MessageDialog.this.customEnterAnimResId != 0) {
                            enterAnimResId = MessageDialog.this.customEnterAnimResId;
                        }
                        Animation enterAnim = AnimationUtils.loadAnimation((Context)MessageDialog.this.getOwnActivity(), (int)enterAnimResId);
                        long enterAnimationDuration = DialogImpl.this.getEnterAnimationDuration(enterAnim);
                        enterAnim.setDuration(enterAnimationDuration);
                        enterAnim.setInterpolator((Interpolator)new DecelerateInterpolator());
                        DialogImpl.this.bkg.startAnimation(enterAnim);
                        ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                        bkgAlpha.setDuration(enterAnimationDuration);
                        bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                DialogImpl.this.boxRoot.setBkgAlpha(((Float)animation.getAnimatedValue()).floatValue());
                            }
                        });
                        bkgAlpha.start();
                    }

                    @Override
                    public void doExitAnim(MessageDialog dialog, ViewGroup dialogBodyView) {
                        int exitAnimResId;
                        int n = exitAnimResId = MessageDialog.this.style.exitAnimResId() == 0 ? R.anim.anim_dialogx_default_exit : MessageDialog.this.style.exitAnimResId();
                        if (overrideExitAnimRes != 0) {
                            exitAnimResId = overrideExitAnimRes;
                        }
                        if (MessageDialog.this.customExitAnimResId != 0) {
                            exitAnimResId = MessageDialog.this.customExitAnimResId;
                        }
                        Animation exitAnim = AnimationUtils.loadAnimation((Context)MessageDialog.this.getOwnActivity(), (int)exitAnimResId);
                        long exitAnimationDuration = DialogImpl.this.getExitAnimationDuration(exitAnim);
                        exitAnim.setInterpolator((Interpolator)new AccelerateInterpolator());
                        exitAnim.setDuration(exitAnimationDuration);
                        DialogImpl.this.bkg.startAnimation(exitAnim);
                        ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
                        bkgAlpha.setDuration(exitAnimationDuration);
                        bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                DialogImpl.this.boxRoot.setBkgAlpha(((Float)animation.getAnimatedValue()).floatValue());
                            }
                        });
                        bkgAlpha.start();
                    }
                };
            }
            return MessageDialog.this.dialogXAnimImpl;
        }

        public long getExitAnimationDuration(@Nullable Animation defaultExitAnim) {
            long exitAnimDurationTemp;
            if (defaultExitAnim == null && this.bkg.getAnimation() != null) {
                defaultExitAnim = this.bkg.getAnimation();
            }
            long l = exitAnimDurationTemp = defaultExitAnim == null || defaultExitAnim.getDuration() == 0L ? 300L : defaultExitAnim.getDuration();
            if (overrideExitDuration >= 0) {
                exitAnimDurationTemp = overrideExitDuration;
            }
            if (MessageDialog.this.exitAnimDuration != -1L) {
                exitAnimDurationTemp = MessageDialog.this.exitAnimDuration;
            }
            return exitAnimDurationTemp;
        }

        public long getEnterAnimationDuration(@Nullable Animation defaultEnterAnim) {
            long enterAnimDurationTemp;
            if (defaultEnterAnim == null && this.bkg.getAnimation() != null) {
                defaultEnterAnim = this.bkg.getAnimation();
            }
            long l = enterAnimDurationTemp = defaultEnterAnim == null || defaultEnterAnim.getDuration() == 0L ? 300L : defaultEnterAnim.getDuration();
            if (overrideEnterDuration >= 0) {
                enterAnimDurationTemp = overrideEnterDuration;
            }
            if (MessageDialog.this.enterAnimDuration >= 0L) {
                enterAnimDurationTemp = MessageDialog.this.enterAnimDuration;
            }
            return enterAnimDurationTemp;
        }
    }
}

