/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.dialogs;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.graphics.Outline;
import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.RoundedCorner;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.WindowInsets;
import android.view.animation.DecelerateInterpolator;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.lifecycle.Lifecycle;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.DialogConvertViewInterface;
import com.kongzue.dialogx.interfaces.DialogLifecycleCallback;
import com.kongzue.dialogx.interfaces.DialogXAnimInterface;
import com.kongzue.dialogx.interfaces.DialogXBaseBottomDialog;
import com.kongzue.dialogx.interfaces.DialogXRunnable;
import com.kongzue.dialogx.interfaces.DialogXStyle;
import com.kongzue.dialogx.interfaces.OnBackPressedListener;
import com.kongzue.dialogx.interfaces.OnBackgroundMaskClickListener;
import com.kongzue.dialogx.interfaces.OnBindView;
import com.kongzue.dialogx.interfaces.OnSafeInsetsChangeListener;
import com.kongzue.dialogx.interfaces.ScrollController;
import com.kongzue.dialogx.util.FullScreenDialogTouchEventInterceptor;
import com.kongzue.dialogx.util.views.ActivityScreenShotImageView;
import com.kongzue.dialogx.util.views.DialogXBaseRelativeLayout;
import com.kongzue.dialogx.util.views.MaxRelativeLayout;
import java.util.HashMap;

public class FullScreenDialog
extends BaseDialog
implements DialogXBaseBottomDialog {
    public static final int ACTIVITY_CONTENT_RADIUS_KEEP = -2;
    public static final int ACTIVITY_CONTENT_RADIUS_DEFAULT = -1;
    public static int overrideEnterDuration = -1;
    public static int overrideExitDuration = -1;
    public static BaseDialog.BOOLEAN overrideCancelable;
    protected OnBindView<FullScreenDialog> onBindView;
    protected OnBackPressedListener<FullScreenDialog> onBackPressedListener;
    protected BaseDialog.BOOLEAN privateCancelable;
    protected boolean hideZoomBackground;
    protected float backgroundRadius = DialogX.defaultFullScreenDialogBackgroundRadius;
    protected float activityContentRadius = -1.0f;
    protected boolean allowInterceptTouch = true;
    protected DialogXAnimInterface<FullScreenDialog> dialogXAnimImpl;
    protected boolean bottomNonSafetyAreaBySelf = false;
    protected boolean hideActivityContentView;
    protected Integer maskColor = null;
    protected DialogLifecycleCallback<FullScreenDialog> dialogLifecycleCallback;
    protected OnBackgroundMaskClickListener<FullScreenDialog> onBackgroundMaskClickListener;
    protected FullScreenDialog me = this;
    protected DialogImpl dialogImpl;
    protected boolean hideWithExitAnim;
    private Integer deviceRadiusCache;

    protected FullScreenDialog() {
    }

    public static FullScreenDialog build() {
        return new FullScreenDialog();
    }

    public static FullScreenDialog build(OnBindView<FullScreenDialog> onBindView) {
        return new FullScreenDialog(onBindView);
    }

    public FullScreenDialog(OnBindView<FullScreenDialog> onBindView) {
        this.onBindView = onBindView;
    }

    public static FullScreenDialog show(OnBindView<FullScreenDialog> onBindView) {
        FullScreenDialog FullScreenDialog2 = new FullScreenDialog(onBindView);
        FullScreenDialog2.show();
        return FullScreenDialog2;
    }

    public FullScreenDialog show() {
        if (this.isHide && this.getDialogView() != null && this.isShow) {
            if (this.hideWithExitAnim && this.getDialogImpl() != null) {
                this.getDialogView().setVisibility(0);
                this.getDialogImpl().getDialogXAnimImpl().doShowAnim(this.me, (ViewGroup)this.getDialogImpl().bkg);
            } else {
                this.getDialogView().setVisibility(0);
            }
            return this;
        }
        super.beforeShow();
        if (this.getDialogView() == null) {
            View dialogView = this.createView(this.isLightTheme() ? R.layout.layout_dialogx_fullscreen : R.layout.layout_dialogx_fullscreen_dark);
            this.dialogImpl = new DialogImpl(dialogView);
            if (dialogView != null) {
                dialogView.setTag((Object)this.me);
            }
            FullScreenDialog.show(dialogView);
        } else {
            FullScreenDialog.show(this.getDialogView());
        }
        return this;
    }

    public void show(Activity activity) {
        super.beforeShow();
        if (this.getDialogView() == null) {
            View dialogView = this.createView(this.isLightTheme() ? R.layout.layout_dialogx_fullscreen : R.layout.layout_dialogx_fullscreen_dark);
            this.dialogImpl = new DialogImpl(dialogView);
            if (dialogView != null) {
                dialogView.setTag((Object)this.me);
            }
            FullScreenDialog.show(activity, dialogView);
        } else {
            FullScreenDialog.show(activity, this.getDialogView());
        }
    }

    @Override
    public String dialogKey() {
        return this.getClass().getSimpleName() + "(" + Integer.toHexString(this.hashCode()) + ")";
    }

    @Override
    public void refreshUI() {
        if (this.getDialogImpl() == null) {
            return;
        }
        FullScreenDialog.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (FullScreenDialog.this.dialogImpl != null) {
                    FullScreenDialog.this.dialogImpl.refreshView();
                }
            }
        });
    }

    public void dismiss() {
        FullScreenDialog.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (FullScreenDialog.this.dialogImpl == null) {
                    return;
                }
                FullScreenDialog.this.dialogImpl.doDismiss(null);
            }
        });
    }

    public DialogLifecycleCallback<FullScreenDialog> getDialogLifecycleCallback() {
        return this.dialogLifecycleCallback == null ? new DialogLifecycleCallback<FullScreenDialog>(){} : this.dialogLifecycleCallback;
    }

    public FullScreenDialog setDialogLifecycleCallback(DialogLifecycleCallback<FullScreenDialog> dialogLifecycleCallback) {
        this.dialogLifecycleCallback = dialogLifecycleCallback;
        if (this.isShow) {
            dialogLifecycleCallback.onShow(this.me);
        }
        return this;
    }

    public OnBackPressedListener<FullScreenDialog> getOnBackPressedListener() {
        return this.onBackPressedListener;
    }

    public FullScreenDialog setOnBackPressedListener(OnBackPressedListener<FullScreenDialog> onBackPressedListener) {
        this.onBackPressedListener = onBackPressedListener;
        this.refreshUI();
        return this;
    }

    public FullScreenDialog setStyle(DialogXStyle style2) {
        this.style = style2;
        return this;
    }

    public FullScreenDialog setTheme(DialogX.THEME theme) {
        this.theme = theme;
        return this;
    }

    @Override
    public boolean isCancelable() {
        if (this.privateCancelable != null) {
            return this.privateCancelable == BaseDialog.BOOLEAN.TRUE;
        }
        if (overrideCancelable != null) {
            return overrideCancelable == BaseDialog.BOOLEAN.TRUE;
        }
        return this.cancelable;
    }

    public FullScreenDialog setCancelable(boolean cancelable) {
        this.privateCancelable = cancelable ? BaseDialog.BOOLEAN.TRUE : BaseDialog.BOOLEAN.FALSE;
        this.refreshUI();
        return this;
    }

    public DialogImpl getDialogImpl() {
        return this.dialogImpl;
    }

    public FullScreenDialog setCustomView(OnBindView<FullScreenDialog> onBindView) {
        this.onBindView = onBindView;
        this.refreshUI();
        return this;
    }

    public View getCustomView() {
        if (this.onBindView == null) {
            return null;
        }
        return this.onBindView.getCustomView();
    }

    public FullScreenDialog removeCustomView() {
        this.onBindView.clean();
        this.refreshUI();
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public FullScreenDialog setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.refreshUI();
        return this;
    }

    public FullScreenDialog setBackgroundColorRes(@ColorRes int backgroundColorRes) {
        this.backgroundColor = this.getColor(backgroundColorRes);
        this.refreshUI();
        return this;
    }

    public long getEnterAnimDuration() {
        return this.enterAnimDuration;
    }

    public FullScreenDialog setEnterAnimDuration(long enterAnimDuration) {
        this.enterAnimDuration = enterAnimDuration;
        return this;
    }

    public long getExitAnimDuration() {
        return this.exitAnimDuration;
    }

    public FullScreenDialog setExitAnimDuration(long exitAnimDuration) {
        this.exitAnimDuration = exitAnimDuration;
        return this;
    }

    public boolean isHideZoomBackground() {
        return this.hideZoomBackground;
    }

    public FullScreenDialog setHideZoomBackground(boolean hideZoomBackground) {
        this.hideZoomBackground = hideZoomBackground;
        this.refreshUI();
        return this;
    }

    @Override
    public void restartDialog() {
        if (this.getDialogView() != null) {
            FullScreenDialog.dismiss(this.getDialogView());
            this.isShow = false;
        }
        if (this.getDialogImpl().boxCustom != null) {
            this.getDialogImpl().boxCustom.removeAllViews();
        }
        this.enterAnimDuration = 0L;
        View dialogView = this.createView(this.isLightTheme() ? R.layout.layout_dialogx_fullscreen : R.layout.layout_dialogx_fullscreen_dark);
        this.dialogImpl = new DialogImpl(dialogView);
        if (dialogView != null) {
            dialogView.setTag((Object)this.me);
        }
        FullScreenDialog.show(dialogView);
    }

    public void hide() {
        this.isHide = true;
        this.hideWithExitAnim = false;
        if (this.getDialogView() != null) {
            this.getDialogView().setVisibility(8);
        }
    }

    public void hideWithExitAnim() {
        this.hideWithExitAnim = true;
        this.isHide = true;
        if (this.getDialogImpl() != null) {
            this.getDialogImpl().getDialogXAnimImpl().doExitAnim(this.me, (ViewGroup)this.getDialogImpl().bkg);
            FullScreenDialog.runOnMainDelay(new Runnable(){

                @Override
                public void run() {
                    if (FullScreenDialog.this.getDialogView() != null) {
                        FullScreenDialog.this.getDialogView().setVisibility(8);
                    }
                }
            }, this.getDialogImpl().getExitAnimationDuration());
        }
    }

    @Override
    protected void shutdown() {
        this.dismiss();
    }

    public FullScreenDialog setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.refreshUI();
        return this;
    }

    public FullScreenDialog setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        this.refreshUI();
        return this;
    }

    public FullScreenDialog setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        this.refreshUI();
        return this;
    }

    public FullScreenDialog setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        this.refreshUI();
        return this;
    }

    public FullScreenDialog setDialogImplMode(DialogX.IMPL_MODE dialogImplMode) {
        this.dialogImplMode = dialogImplMode;
        return this;
    }

    public OnBackgroundMaskClickListener<FullScreenDialog> getOnBackgroundMaskClickListener() {
        return this.onBackgroundMaskClickListener;
    }

    public FullScreenDialog setOnBackgroundMaskClickListener(OnBackgroundMaskClickListener<FullScreenDialog> onBackgroundMaskClickListener) {
        this.onBackgroundMaskClickListener = onBackgroundMaskClickListener;
        return this;
    }

    public FullScreenDialog setRadius(float radiusPx) {
        this.backgroundRadius = radiusPx;
        this.refreshUI();
        return this;
    }

    public float getRadius() {
        return this.backgroundRadius;
    }

    public boolean isAllowInterceptTouch() {
        return this.allowInterceptTouch;
    }

    public FullScreenDialog setAllowInterceptTouch(boolean allowInterceptTouch) {
        this.allowInterceptTouch = allowInterceptTouch;
        this.refreshUI();
        return this;
    }

    public DialogXAnimInterface<FullScreenDialog> getDialogXAnimImpl() {
        return this.dialogXAnimImpl;
    }

    public FullScreenDialog setDialogXAnimImpl(DialogXAnimInterface<FullScreenDialog> dialogXAnimImpl) {
        this.dialogXAnimImpl = dialogXAnimImpl;
        return this;
    }

    public FullScreenDialog setRootPadding(int padding) {
        this.screenPaddings = new int[]{padding, padding, padding, padding};
        this.refreshUI();
        return this;
    }

    public FullScreenDialog setRootPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.screenPaddings = new int[]{paddingLeft, paddingTop, paddingRight, paddingBottom};
        this.refreshUI();
        return this;
    }

    protected void onShow(FullScreenDialog dialog) {
    }

    protected void onDismiss(FullScreenDialog dialog) {
    }

    @Override
    public boolean isBottomNonSafetyAreaBySelf() {
        return this.bottomNonSafetyAreaBySelf;
    }

    public FullScreenDialog setBottomNonSafetyAreaBySelf(boolean bottomNonSafetyAreaBySelf) {
        this.bottomNonSafetyAreaBySelf = bottomNonSafetyAreaBySelf;
        return this;
    }

    public FullScreenDialog hideActivityContentView(boolean hideActivityContentView) {
        this.hideActivityContentView = hideActivityContentView;
        return this;
    }

    public FullScreenDialog setMaskColor(@ColorInt int maskColor) {
        this.maskColor = maskColor;
        this.refreshUI();
        return this;
    }

    public float getActivityContentRadius() {
        return this.activityContentRadius >= 0.0f ? this.activityContentRadius : (this.activityContentRadius == -2.0f ? (float)this.getDeviceRadius() : (this.getRadius() >= 0.0f ? this.getRadius() : (float)this.dip2px(15.0f)));
    }

    public int getDeviceRadius() {
        if (this.deviceRadiusCache == null) {
            this.deviceRadiusCache = 0;
            if (Build.VERSION.SDK_INT >= 31) {
                WindowInsets rootInsets = this.getRootFrameLayout().getRootWindowInsets();
                RoundedCorner lT = rootInsets.getRoundedCorner(0);
                RoundedCorner rT = rootInsets.getRoundedCorner(1);
                if (lT != null && rT != null) {
                    this.deviceRadiusCache = Math.max(lT.getRadius(), rT.getRadius());
                }
            }
        }
        return this.deviceRadiusCache;
    }

    public FullScreenDialog setDeviceRadius(int deviceRadiusPx) {
        this.deviceRadiusCache = deviceRadiusPx;
        return this;
    }

    public FullScreenDialog setActivityContentRadius(float activityContentRadius) {
        this.activityContentRadius = activityContentRadius;
        return this;
    }

    private float getActivityZoomRadius(float startValue, float endValue, float progressValue) {
        return startValue + progressValue * (endValue - startValue);
    }

    @Override
    public FullScreenDialog setData(String key, Object obj) {
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.data.put(key, obj);
        return this;
    }

    public FullScreenDialog onShow(DialogXRunnable<FullScreenDialog> dialogXRunnable) {
        this.onShowRunnable = dialogXRunnable;
        if (this.isShow() && this.onShowRunnable != null) {
            this.onShowRunnable.run(this);
        }
        return this;
    }

    public FullScreenDialog onDismiss(DialogXRunnable<FullScreenDialog> dialogXRunnable) {
        this.onDismissRunnable = dialogXRunnable;
        return this;
    }

    @Override
    public FullScreenDialog setEnableImmersiveMode(boolean enableImmersiveMode) {
        this.enableImmersiveMode = enableImmersiveMode;
        this.refreshUI();
        return this;
    }

    @Override
    public FullScreenDialog setThisOrderIndex(int orderIndex) {
        this.thisOrderIndex = orderIndex;
        if (this.getDialogView() != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.getDialogView().setTranslationZ((float)orderIndex);
            } else {
                FullScreenDialog.error("DialogX: " + this.dialogKey() + " \u6267\u884c .setThisOrderIndex(" + orderIndex + ") \u5931\u8d25\uff1a\u7cfb\u7edf\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0cSDK-API \u7248\u672c\u5fc5\u987b\u5927\u4e8e 21\uff08LOLLIPOP\uff09");
            }
        }
        return this;
    }

    public FullScreenDialog bringToFront() {
        this.setThisOrderIndex(this.getHighestOrderIndex());
        return this;
    }

    public class DialogImpl
    implements DialogConvertViewInterface {
        private FullScreenDialogTouchEventInterceptor fullScreenDialogTouchEventInterceptor;
        public ActivityScreenShotImageView imgZoomActivity;
        public DialogXBaseRelativeLayout boxRoot;
        public RelativeLayout boxBkg;
        public MaxRelativeLayout bkg;
        public RelativeLayout boxCustom;
        public ScrollController scrollView;
        public float bkgEnterAimY = -1.0f;
        protected int enterY;
        private Rect mUnsafeRect = new Rect(0, 0, 0, 0);
        private boolean enterAnimRunning = true;

        public DialogImpl setScrollView(ScrollController scrollView) {
            this.scrollView = scrollView;
            return this;
        }

        public DialogImpl(View convertView) {
            if (convertView == null) {
                return;
            }
            FullScreenDialog.this.setDialogView(convertView);
            this.imgZoomActivity = (ActivityScreenShotImageView)convertView.findViewById(R.id.img_zoom_activity);
            this.boxRoot = (DialogXBaseRelativeLayout)convertView.findViewById(R.id.box_root);
            this.boxBkg = (RelativeLayout)convertView.findViewById(R.id.box_bkg);
            this.bkg = (MaxRelativeLayout)convertView.findViewById(R.id.bkg);
            this.boxCustom = (RelativeLayout)convertView.findViewById(R.id.box_custom);
            this.imgZoomActivity.hideActivityContentView = FullScreenDialog.this.hideActivityContentView;
            this.imgZoomActivity.bindDialog(FullScreenDialog.this);
            if (FullScreenDialog.this.hideZoomBackground) {
                convertView.setBackgroundResource(R.color.black20);
                this.imgZoomActivity.setVisibility(8);
            } else {
                convertView.setBackgroundResource(R.color.black);
                this.imgZoomActivity.setVisibility(0);
            }
            this.init();
            FullScreenDialog.this.dialogImpl = this;
            this.refreshView();
        }

        public float getEnterY() {
            return Math.max(0.0f, this.boxRoot.getSafeHeight() - (float)this.enterY);
        }

        @Override
        public void init() {
            this.boxRoot.setParentDialog(FullScreenDialog.this.me);
            if (Build.VERSION.SDK_INT >= 21) {
                FullScreenDialog.this.getDialogView().setTranslationZ((float)FullScreenDialog.this.getThisOrderIndex());
            }
            this.boxRoot.setOnLifecycleCallBack(new DialogXBaseRelativeLayout.OnLifecycleCallBack(){

                @Override
                public void onShow() {
                    FullScreenDialog.this.isShow = true;
                    FullScreenDialog.this.preShow = false;
                    FullScreenDialog.this.setLifecycleState(Lifecycle.State.CREATED);
                    FullScreenDialog.this.onDialogShow();
                    FullScreenDialog.this.getDialogLifecycleCallback().onShow(FullScreenDialog.this.me);
                    FullScreenDialog.this.onShow(FullScreenDialog.this.me);
                }

                @Override
                public void onDismiss() {
                    FullScreenDialog.this.isShow = false;
                    FullScreenDialog.this.getDialogLifecycleCallback().onDismiss(FullScreenDialog.this.me);
                    FullScreenDialog.this.onDismiss(FullScreenDialog.this.me);
                    DialogImpl.this.fullScreenDialogTouchEventInterceptor = null;
                    FullScreenDialog.this.dialogImpl = null;
                    FullScreenDialog.this.dialogLifecycleCallback = null;
                    FullScreenDialog.this.setLifecycleState(Lifecycle.State.DESTROYED);
                    System.gc();
                }
            });
            this.boxRoot.setOnBackPressedListener(new DialogXBaseRelativeLayout.PrivateBackPressedListener(){

                @Override
                public boolean onBackPressed() {
                    if (FullScreenDialog.this.onBackPressedListener != null) {
                        if (FullScreenDialog.this.onBackPressedListener.onBackPressed(FullScreenDialog.this.me)) {
                            FullScreenDialog.this.dismiss();
                        }
                    } else if (FullScreenDialog.this.isCancelable()) {
                        FullScreenDialog.this.dismiss();
                    }
                    return true;
                }
            });
            this.fullScreenDialogTouchEventInterceptor = new FullScreenDialogTouchEventInterceptor(FullScreenDialog.this.me, FullScreenDialog.this.dialogImpl);
            this.boxRoot.setBkgAlpha(0.0f);
            this.bkg.setY(this.boxRoot.getHeight());
            this.boxRoot.post(new Runnable(){

                @Override
                public void run() {
                    DialogImpl.this.getDialogXAnimImpl().doShowAnim(FullScreenDialog.this.me, (ViewGroup)DialogImpl.this.bkg);
                    FullScreenDialog.this.setLifecycleState(Lifecycle.State.RESUMED);
                }
            });
            this.boxRoot.setOnSafeInsetsChangeListener(new OnSafeInsetsChangeListener(){

                @Override
                public void onChange(Rect unsafeRect) {
                    DialogImpl.this.mUnsafeRect.set(unsafeRect);
                    DialogImpl.this.makeEnterY();
                    if (!DialogImpl.this.enterAnimRunning) {
                        DialogImpl.this.bkg.setY(DialogImpl.this.getEnterY());
                    }
                }
            });
            this.bkg.setOnYChanged(new MaxRelativeLayout.OnYChanged(){

                @Override
                public void y(float y) {
                    float realY = y + (float)DialogImpl.this.bkg.getTop();
                    float zoomScale = 1.0f - ((float)DialogImpl.this.boxRoot.getHeight() - realY) * 2.0E-5f;
                    if (zoomScale > 1.0f) {
                        zoomScale = 1.0f;
                    }
                    if (!FullScreenDialog.this.hideZoomBackground) {
                        DialogImpl.this.imgZoomActivity.setScale(zoomScale);
                        DialogImpl.this.imgZoomActivity.setRadius(FullScreenDialog.this.getActivityZoomRadius(FullScreenDialog.this.getDeviceRadius(), FullScreenDialog.this.getActivityContentRadius(), ((float)DialogImpl.this.boxRoot.getHeight() - realY) / (float)DialogImpl.this.boxRoot.getHeight()));
                    }
                }
            });
            this.boxCustom.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    int oldHeight = oldBottom - oldTop;
                    int newHeight = bottom - top;
                    if (oldHeight != newHeight && !DialogImpl.this.enterAnimRunning && !DialogImpl.this.boxRoot.getFitSystemBarUtils().isInSmoothingPadding()) {
                        DialogImpl.this.makeEnterY();
                        float newBkgEnterAimY = DialogImpl.this.boxRoot.getSafeHeight() - (float)((DialogImpl)DialogImpl.this).mUnsafeRect.bottom - (float)DialogImpl.this.enterY - (float)DialogImpl.this.boxRoot.getUnsafePlace().top;
                        if (newBkgEnterAimY < 0.0f) {
                            newBkgEnterAimY = 0.0f;
                        }
                        if (newBkgEnterAimY != DialogImpl.this.bkgEnterAimY && DialogImpl.this.bkg.getY() != newBkgEnterAimY) {
                            float oldVal = DialogImpl.this.bkgEnterAimY;
                            DialogImpl.this.bkgEnterAimY = newBkgEnterAimY;
                            DialogImpl.this.doShowAnimRepeat((int)oldVal, (int)newBkgEnterAimY, true);
                        } else if (DialogImpl.this.bkg.getY() != newBkgEnterAimY) {
                            DialogImpl.this.bkg.setY(newBkgEnterAimY);
                        }
                    }
                }
            });
            FullScreenDialog.this.onDialogInit();
        }

        private boolean isMatchParentHeightCustomView() {
            ViewGroup.LayoutParams lp;
            if (FullScreenDialog.this.onBindView != null && FullScreenDialog.this.onBindView.getCustomView() != null && (lp = FullScreenDialog.this.onBindView.getCustomView().getLayoutParams()) != null) {
                return lp.height == -1;
            }
            return false;
        }

        private void makeEnterY() {
            int customViewHeight = this.boxCustom.getHeight();
            if (customViewHeight == 0 || this.isMatchParentHeightCustomView()) {
                customViewHeight = (int)this.boxRoot.getSafeHeight();
            }
            this.enterY = customViewHeight;
        }

        @Override
        public void refreshView() {
            if (this.boxRoot == null || FullScreenDialog.this.getOwnActivity() == null) {
                return;
            }
            this.boxRoot.setAutoUnsafePlacePadding(FullScreenDialog.this.isEnableImmersiveMode());
            this.boxRoot.setRootPadding(FullScreenDialog.this.screenPaddings[0], FullScreenDialog.this.screenPaddings[1], FullScreenDialog.this.screenPaddings[2], FullScreenDialog.this.screenPaddings[3]);
            if (FullScreenDialog.this.backgroundColor != null) {
                FullScreenDialog.this.tintColor((View)this.bkg, FullScreenDialog.this.backgroundColor);
            }
            this.bkg.setMaxWidth(FullScreenDialog.this.getMaxWidth());
            this.bkg.setMaxHeight(FullScreenDialog.this.getMaxHeight());
            this.bkg.setMinimumWidth(FullScreenDialog.this.getMinWidth());
            this.bkg.setMinimumHeight(FullScreenDialog.this.getMinHeight());
            if (FullScreenDialog.this.isCancelable()) {
                this.boxRoot.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (FullScreenDialog.this.onBackgroundMaskClickListener == null || !FullScreenDialog.this.onBackgroundMaskClickListener.onClick(FullScreenDialog.this.me, v)) {
                            DialogImpl.this.doDismiss(v);
                        }
                    }
                });
            } else {
                this.boxRoot.setOnClickListener(null);
            }
            if (FullScreenDialog.this.backgroundRadius > -1.0f) {
                GradientDrawable gradientDrawable;
                if (this.bkg.getBackground() instanceof GradientDrawable && (gradientDrawable = (GradientDrawable)this.bkg.getBackground()) != null) {
                    gradientDrawable.setCornerRadii(new float[]{FullScreenDialog.this.backgroundRadius, FullScreenDialog.this.backgroundRadius, FullScreenDialog.this.backgroundRadius, FullScreenDialog.this.backgroundRadius, 0.0f, 0.0f, 0.0f, 0.0f});
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    this.bkg.setOutlineProvider(new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            outline.setRoundRect(0, 0, view.getWidth(), (int)((float)view.getHeight() + FullScreenDialog.this.backgroundRadius), FullScreenDialog.this.backgroundRadius);
                        }
                    });
                    this.bkg.setClipToOutline(true);
                }
            }
            if (FullScreenDialog.this.maskColor != null) {
                this.boxRoot.setBackgroundColor(FullScreenDialog.this.maskColor);
            }
            if (FullScreenDialog.this.onBindView != null) {
                FullScreenDialog.this.onBindView.bindParent((ViewGroup)this.boxCustom, FullScreenDialog.this.me);
                if (FullScreenDialog.this.onBindView.getCustomView() instanceof ScrollController) {
                    this.scrollView = (ScrollController)FullScreenDialog.this.onBindView.getCustomView();
                } else {
                    View scrollController = FullScreenDialog.this.onBindView.getCustomView().findViewWithTag((Object)"ScrollController");
                    if (scrollController instanceof ScrollController) {
                        this.scrollView = (ScrollController)scrollController;
                    }
                }
            }
            if (FullScreenDialog.this.hideZoomBackground) {
                FullScreenDialog.this.getDialogView().setBackgroundResource(R.color.black20);
                this.imgZoomActivity.setVisibility(8);
            } else {
                FullScreenDialog.this.getDialogView().setBackgroundResource(R.color.black);
                this.imgZoomActivity.setVisibility(0);
            }
            this.fullScreenDialogTouchEventInterceptor.refresh(FullScreenDialog.this.me, this);
            FullScreenDialog.this.onDialogRefreshUI();
        }

        @Override
        public void doDismiss(View v) {
            if (FullScreenDialog.this.preDismiss(FullScreenDialog.this)) {
                return;
            }
            if (v != null) {
                v.setEnabled(false);
            }
            if (FullScreenDialog.this.getOwnActivity() == null) {
                return;
            }
            if (!FullScreenDialog.this.dismissAnimFlag && this.getDialogXAnimImpl() != null) {
                FullScreenDialog.this.dismissAnimFlag = true;
                this.getDialogXAnimImpl().doExitAnim(FullScreenDialog.this.me, (ViewGroup)this.bkg);
                FullScreenDialog.runOnMainDelay(new Runnable(){

                    @Override
                    public void run() {
                        if (DialogImpl.this.boxRoot != null) {
                            DialogImpl.this.boxRoot.setVisibility(8);
                        }
                        FullScreenDialog.dismiss(FullScreenDialog.this.getDialogView());
                    }
                }, this.getExitAnimationDuration());
            }
        }

        public void preDismiss() {
            if (FullScreenDialog.this.isCancelable()) {
                this.doDismiss((View)this.boxRoot);
            } else {
                long exitAnimDurationTemp = 300L;
                if (overrideExitDuration >= 0) {
                    exitAnimDurationTemp = overrideExitDuration;
                }
                if (FullScreenDialog.this.exitAnimDuration >= 0L) {
                    exitAnimDurationTemp = FullScreenDialog.this.exitAnimDuration;
                }
                ObjectAnimator exitAnim = ObjectAnimator.ofFloat((Object)this.bkg, (String)"y", (float[])new float[]{this.bkg.getY(), this.bkgEnterAimY});
                exitAnim.setDuration(exitAnimDurationTemp);
                exitAnim.start();
            }
        }

        private void doShowAnimRepeat(int start, int end, boolean isRepeat) {
            this.enterAnimRunning = true;
            long enterAnimDurationTemp = this.getEnterAnimationDuration();
            ValueAnimator enterAnimVal = ValueAnimator.ofInt((int[])new int[]{start, end});
            enterAnimVal.setDuration(enterAnimDurationTemp);
            enterAnimVal.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            enterAnimVal.addUpdateListener(animation -> {
                int thisVal = (Integer)animation.getAnimatedValue();
                this.bkg.setY(thisVal);
                this.makeEnterY();
                float newBkgEnterAimY = this.boxRoot.getSafeHeight() - (float)this.enterY;
                if (newBkgEnterAimY < 0.0f) {
                    newBkgEnterAimY = 0.0f;
                }
                if (newBkgEnterAimY != this.bkgEnterAimY) {
                    this.bkgEnterAimY = newBkgEnterAimY;
                    animation.cancel();
                    this.doShowAnimRepeat(thisVal, (int)newBkgEnterAimY, true);
                } else if (thisVal >= end) {
                    this.enterAnimRunning = false;
                }
            });
            enterAnimVal.start();
            this.bkg.setVisibility(0);
            if (!isRepeat) {
                ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                bkgAlpha.setDuration(enterAnimDurationTemp);
                bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        float value = ((Float)animation.getAnimatedValue()).floatValue();
                        DialogImpl.this.boxRoot.setBkgAlpha(value);
                    }
                });
                bkgAlpha.start();
            }
        }

        protected DialogXAnimInterface<FullScreenDialog> getDialogXAnimImpl() {
            if (FullScreenDialog.this.dialogXAnimImpl == null) {
                FullScreenDialog.this.dialogXAnimImpl = new DialogXAnimInterface<FullScreenDialog>(){

                    @Override
                    public void doShowAnim(FullScreenDialog dialog, ViewGroup dialogBodyView) {
                        DialogImpl.this.makeEnterY();
                        DialogImpl.this.bkgEnterAimY = DialogImpl.this.boxRoot.getSafeHeight() - (float)DialogImpl.this.enterY;
                        if (DialogImpl.this.bkgEnterAimY < 0.0f) {
                            DialogImpl.this.bkgEnterAimY = 0.0f;
                        }
                        DialogImpl.this.doShowAnimRepeat(DialogImpl.this.boxRoot.getHeight(), (int)DialogImpl.this.bkgEnterAimY, false);
                    }

                    @Override
                    public void doExitAnim(FullScreenDialog dialog, ViewGroup dialogBodyView) {
                        long exitAnimDurationTemp = DialogImpl.this.getExitAnimationDuration();
                        ObjectAnimator exitAnim = ObjectAnimator.ofFloat((Object)DialogImpl.this.bkg, (String)"y", (float[])new float[]{DialogImpl.this.bkg.getY(), DialogImpl.this.boxBkg.getHeight()});
                        exitAnim.setDuration(exitAnimDurationTemp);
                        exitAnim.start();
                        ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
                        bkgAlpha.setDuration(exitAnimDurationTemp);
                        bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                float value = ((Float)animation.getAnimatedValue()).floatValue();
                                DialogImpl.this.boxRoot.setBkgAlpha(value);
                                DialogImpl.this.enterAnimRunning = value != 1.0f;
                            }
                        });
                        bkgAlpha.start();
                    }
                };
            }
            return FullScreenDialog.this.dialogXAnimImpl;
        }

        public long getExitAnimationDuration() {
            long exitAnimDurationTemp = 300L;
            if (overrideExitDuration >= 0) {
                exitAnimDurationTemp = overrideExitDuration;
            }
            if (FullScreenDialog.this.exitAnimDuration != -1L) {
                exitAnimDurationTemp = FullScreenDialog.this.exitAnimDuration;
            }
            return exitAnimDurationTemp;
        }

        public long getEnterAnimationDuration() {
            long enterAnimDurationTemp = 300L;
            if (overrideEnterDuration >= 0) {
                enterAnimDurationTemp = overrideEnterDuration;
            }
            if (FullScreenDialog.this.enterAnimDuration >= 0L) {
                enterAnimDurationTemp = FullScreenDialog.this.enterAnimDuration;
            }
            return enterAnimDurationTemp;
        }
    }
}

