/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.dialogs;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.DialogConvertViewInterface;
import com.kongzue.dialogx.interfaces.DialogLifecycleCallback;
import com.kongzue.dialogx.interfaces.DialogXAnimInterface;
import com.kongzue.dialogx.interfaces.DialogXRunnable;
import com.kongzue.dialogx.interfaces.DialogXStyle;
import com.kongzue.dialogx.interfaces.OnBackPressedListener;
import com.kongzue.dialogx.interfaces.OnBackgroundMaskClickListener;
import com.kongzue.dialogx.interfaces.OnBindView;
import com.kongzue.dialogx.util.views.DialogXBaseRelativeLayout;
import com.kongzue.dialogx.util.views.MaxRelativeLayout;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class CustomDialog
extends BaseDialog {
    public static int overrideEnterDuration = -1;
    public static int overrideExitDuration = -1;
    public static int overrideEnterAnimRes = 0;
    public static int overrideExitAnimRes = 0;
    public static BaseDialog.BOOLEAN overrideCancelable;
    protected OnBindView<CustomDialog> onBindView;
    protected DialogLifecycleCallback<CustomDialog> dialogLifecycleCallback;
    protected OnBackPressedListener<CustomDialog> onBackPressedListener;
    protected CustomDialog me = this;
    protected DialogImpl dialogImpl;
    protected int enterAnimResId = R.anim.anim_dialogx_default_enter;
    protected int exitAnimResId = R.anim.anim_dialogx_default_exit;
    protected ALIGN align = ALIGN.CENTER;
    protected int maskColor = 0;
    protected BaseDialog.BOOLEAN privateCancelable;
    protected boolean bkgInterceptTouch = true;
    protected OnBackgroundMaskClickListener<CustomDialog> onBackgroundMaskClickListener;
    protected DialogXAnimInterface<CustomDialog> dialogXAnimImpl;
    protected WeakReference<View> baseViewWeakReference;
    protected int alignViewGravity = -1;
    protected int width = -1;
    protected int height = -1;
    protected int[] baseViewLoc;
    protected int[] marginRelativeBaseView = new int[4];
    private ViewTreeObserver viewTreeObserver;
    private ViewTreeObserver.OnDrawListener baseViewDrawListener;
    protected boolean hideWithExitAnim;

    protected CustomDialog() {
    }

    public static CustomDialog build() {
        return new CustomDialog();
    }

    public static CustomDialog build(OnBindView<CustomDialog> onBindView) {
        return new CustomDialog().setCustomView(onBindView);
    }

    public CustomDialog(OnBindView<CustomDialog> onBindView) {
        this.onBindView = onBindView;
    }

    public static CustomDialog show(OnBindView<CustomDialog> onBindView) {
        CustomDialog customDialog = new CustomDialog(onBindView);
        customDialog.show();
        return customDialog;
    }

    public static CustomDialog show(OnBindView<CustomDialog> onBindView, ALIGN align) {
        CustomDialog customDialog = new CustomDialog(onBindView);
        customDialog.align = align;
        customDialog.show();
        return customDialog;
    }

    public CustomDialog show() {
        if (this.isHide && this.getDialogView() != null && this.isShow) {
            if (this.hideWithExitAnim && this.getDialogImpl() != null && this.getDialogImpl().boxCustom != null) {
                this.getDialogView().setVisibility(0);
                this.getDialogImpl().getDialogXAnimImpl().doShowAnim(this, (ViewGroup)this.getDialogImpl().boxCustom);
                this.getDialogImpl().boxCustom.setVisibility(0);
                this.getDialogImpl().boxCustom.startAnimation(this.getEnterAnimation());
            } else {
                this.getDialogView().setVisibility(0);
            }
            return this;
        }
        super.beforeShow();
        if (this.getDialogView() == null) {
            View dialogView = this.createView(R.layout.layout_dialogx_custom);
            this.dialogImpl = new DialogImpl(dialogView);
            if (dialogView != null) {
                dialogView.setTag((Object)this.me);
            }
            CustomDialog.show(dialogView);
        } else {
            CustomDialog.show(this.getDialogView());
        }
        return this;
    }

    public CustomDialog show(Activity activity) {
        super.beforeShow();
        if (this.getDialogView() == null) {
            View dialogView = this.createView(R.layout.layout_dialogx_custom);
            this.dialogImpl = new DialogImpl(dialogView);
            if (dialogView != null) {
                dialogView.setTag((Object)this.me);
            }
            CustomDialog.show(activity, dialogView);
        } else {
            CustomDialog.show(activity, this.getDialogView());
        }
        return this;
    }

    private void removeDrawListener(ViewTreeObserver viewTreeObserver, ViewTreeObserver.OnDrawListener listener) {
        if (viewTreeObserver == null || listener == null || !viewTreeObserver.isAlive()) {
            return;
        }
        try {
            viewTreeObserver.removeOnDrawListener(listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Animation getEnterAnimation() {
        Animation enterAnim;
        if (this.enterAnimResId == R.anim.anim_dialogx_default_enter && this.exitAnimResId == R.anim.anim_dialogx_default_exit && this.baseView() == null) {
            switch (this.align) {
                case TOP_LEFT: 
                case TOP: 
                case TOP_CENTER: 
                case TOP_RIGHT: {
                    this.enterAnimResId = R.anim.anim_dialogx_top_enter;
                    this.exitAnimResId = R.anim.anim_dialogx_top_exit;
                    break;
                }
                case BOTTOM_LEFT: 
                case BOTTOM: 
                case BOTTOM_CENTER: 
                case BOTTOM_RIGHT: {
                    this.enterAnimResId = R.anim.anim_dialogx_bottom_enter;
                    this.exitAnimResId = R.anim.anim_dialogx_bottom_exit;
                    break;
                }
                case LEFT_TOP: 
                case LEFT_BOTTOM: 
                case LEFT: 
                case LEFT_CENTER: {
                    this.enterAnimResId = R.anim.anim_dialogx_left_enter;
                    this.exitAnimResId = R.anim.anim_dialogx_left_exit;
                    break;
                }
                case RIGHT_TOP: 
                case RIGHT_BOTTOM: 
                case RIGHT: 
                case RIGHT_CENTER: {
                    this.enterAnimResId = R.anim.anim_dialogx_right_enter;
                    this.exitAnimResId = R.anim.anim_dialogx_right_exit;
                }
            }
            enterAnim = AnimationUtils.loadAnimation((Context)this.getOwnActivity(), (int)this.enterAnimResId);
            enterAnim.setInterpolator((Interpolator)new DecelerateInterpolator(2.0f));
        } else {
            int enterAnimResIdTemp = R.anim.anim_dialogx_default_enter;
            if (overrideEnterAnimRes != 0) {
                enterAnimResIdTemp = overrideEnterAnimRes;
            }
            if (this.enterAnimResId != 0) {
                enterAnimResIdTemp = this.enterAnimResId;
            }
            enterAnim = AnimationUtils.loadAnimation((Context)this.getOwnActivity(), (int)enterAnimResIdTemp);
        }
        long enterAnimDurationTemp = enterAnim.getDuration();
        if (overrideEnterDuration >= 0) {
            enterAnimDurationTemp = overrideEnterDuration;
        }
        if (this.enterAnimDuration >= 0L) {
            enterAnimDurationTemp = this.enterAnimDuration;
        }
        enterAnim.setDuration(enterAnimDurationTemp);
        return enterAnim;
    }

    protected void onGetBaseViewLoc(int[] baseViewLoc) {
    }

    @Override
    public String dialogKey() {
        return this.getClass().getSimpleName() + "(" + Integer.toHexString(this.hashCode()) + ")";
    }

    @Override
    public void refreshUI() {
        if (this.getDialogImpl() == null) {
            return;
        }
        CustomDialog.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (CustomDialog.this.dialogImpl != null) {
                    CustomDialog.this.dialogImpl.refreshView();
                }
            }
        });
    }

    public void dismiss() {
        CustomDialog.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (CustomDialog.this.dialogImpl == null) {
                    return;
                }
                CustomDialog.this.dialogImpl.doDismiss(null);
            }
        });
    }

    public DialogLifecycleCallback<CustomDialog> getDialogLifecycleCallback() {
        return this.dialogLifecycleCallback == null ? new DialogLifecycleCallback<CustomDialog>(){} : this.dialogLifecycleCallback;
    }

    public CustomDialog setDialogLifecycleCallback(DialogLifecycleCallback<CustomDialog> dialogLifecycleCallback) {
        this.dialogLifecycleCallback = dialogLifecycleCallback;
        if (this.isShow) {
            dialogLifecycleCallback.onShow(this.me);
        }
        return this;
    }

    public OnBackPressedListener<CustomDialog> getOnBackPressedListener() {
        return this.onBackPressedListener;
    }

    public CustomDialog setOnBackPressedListener(OnBackPressedListener<CustomDialog> onBackPressedListener) {
        this.onBackPressedListener = onBackPressedListener;
        this.refreshUI();
        return this;
    }

    public CustomDialog setStyle(DialogXStyle style2) {
        this.style = style2;
        return this;
    }

    public CustomDialog setTheme(DialogX.THEME theme) {
        this.theme = theme;
        return this;
    }

    @Override
    public boolean isCancelable() {
        if (this.privateCancelable != null) {
            return this.privateCancelable == BaseDialog.BOOLEAN.TRUE;
        }
        if (overrideCancelable != null) {
            return overrideCancelable == BaseDialog.BOOLEAN.TRUE;
        }
        return this.cancelable;
    }

    public CustomDialog setCancelable(boolean cancelable) {
        this.privateCancelable = cancelable ? BaseDialog.BOOLEAN.TRUE : BaseDialog.BOOLEAN.FALSE;
        this.refreshUI();
        return this;
    }

    public DialogImpl getDialogImpl() {
        return this.dialogImpl;
    }

    public CustomDialog setCustomView(OnBindView<CustomDialog> onBindView) {
        this.onBindView = onBindView;
        this.refreshUI();
        return this;
    }

    public View getCustomView() {
        if (this.onBindView == null) {
            return null;
        }
        return this.onBindView.getCustomView();
    }

    public CustomDialog removeCustomView() {
        this.onBindView.clean();
        this.refreshUI();
        return this;
    }

    public int getEnterAnimResId() {
        return this.enterAnimResId;
    }

    public CustomDialog setEnterAnimResId(int enterAnimResId) {
        this.enterAnimResId = enterAnimResId;
        return this;
    }

    public int getExitAnimResId() {
        return this.exitAnimResId;
    }

    public CustomDialog setExitAnimResId(int exitAnimResId) {
        this.exitAnimResId = exitAnimResId;
        return this;
    }

    public CustomDialog setAnimResId(int enterAnimResId, int exitAnimResId) {
        this.enterAnimResId = enterAnimResId;
        this.exitAnimResId = exitAnimResId;
        return this;
    }

    public ALIGN getAlign() {
        return this.align;
    }

    public CustomDialog setAlign(ALIGN align) {
        this.align = align;
        this.refreshUI();
        return this;
    }

    public boolean isAutoUnsafePlacePadding() {
        return this.isEnableImmersiveMode();
    }

    @Deprecated
    public CustomDialog setAutoUnsafePlacePadding(boolean autoUnsafePlacePadding) {
        this.setEnableImmersiveMode(autoUnsafePlacePadding);
        return this;
    }

    @Deprecated
    public CustomDialog setFullScreen(boolean fullscreen) {
        this.setEnableImmersiveMode(!fullscreen);
        return this;
    }

    public CustomDialog setMaskColor(@ColorInt int maskColor) {
        this.maskColor = maskColor;
        this.refreshUI();
        return this;
    }

    public int getMaskColor() {
        return this.maskColor;
    }

    public long getEnterAnimDuration() {
        return this.enterAnimDuration;
    }

    public CustomDialog setEnterAnimDuration(long enterAnimDuration) {
        this.enterAnimDuration = enterAnimDuration;
        return this;
    }

    public long getExitAnimDuration() {
        return this.exitAnimDuration;
    }

    public CustomDialog setExitAnimDuration(long exitAnimDuration) {
        this.exitAnimDuration = exitAnimDuration;
        return this;
    }

    @Override
    public void restartDialog() {
        if (this.getDialogView() != null) {
            if (this.getDialogImpl() != null && this.getDialogImpl().boxCustom != null && this.baseViewDrawListener != null) {
                if (this.viewTreeObserver != null) {
                    this.removeDrawListener(this.viewTreeObserver, this.baseViewDrawListener);
                } else if (this.getDialogImpl().boxCustom != null) {
                    this.removeDrawListener(this.getDialogImpl().boxCustom.getViewTreeObserver(), this.baseViewDrawListener);
                }
                this.baseViewDrawListener = null;
                this.viewTreeObserver = null;
            }
            CustomDialog.dismiss(this.getDialogView());
            this.isShow = false;
        }
        if (this.getDialogImpl() != null && this.getDialogImpl().boxCustom != null) {
            this.getDialogImpl().boxCustom.removeAllViews();
        }
        this.enterAnimDuration = 0L;
        View dialogView = this.createView(R.layout.layout_dialogx_custom);
        this.dialogImpl = new DialogImpl(dialogView);
        if (dialogView != null) {
            dialogView.setTag((Object)this.me);
        }
        CustomDialog.show(dialogView);
    }

    public void hide() {
        this.isHide = true;
        this.hideWithExitAnim = false;
        if (this.getDialogView() != null) {
            this.getDialogView().setVisibility(8);
        }
    }

    public void hideWithExitAnim() {
        this.hideWithExitAnim = true;
        this.isHide = true;
        if (this.getDialogImpl() != null) {
            this.getDialogImpl().getDialogXAnimImpl().doExitAnim(this, (ViewGroup)this.getDialogImpl().boxCustom);
            CustomDialog.runOnMainDelay(new Runnable(){

                @Override
                public void run() {
                    if (CustomDialog.this.getDialogView() != null) {
                        CustomDialog.this.getDialogView().setVisibility(8);
                    }
                }
            }, this.getDialogImpl().getExitAnimationDuration(null));
        }
    }

    @Override
    protected void shutdown() {
        this.dismiss();
    }

    public CustomDialog setDialogImplMode(DialogX.IMPL_MODE dialogImplMode) {
        this.dialogImplMode = dialogImplMode;
        return this;
    }

    public boolean isBkgInterceptTouch() {
        return this.bkgInterceptTouch;
    }

    public CustomDialog setBkgInterceptTouch(boolean bkgInterceptTouch) {
        this.bkgInterceptTouch = bkgInterceptTouch;
        this.refreshUI();
        return this;
    }

    public int getAlignBaseViewGravity() {
        return this.alignViewGravity;
    }

    public boolean isAlignBaseViewGravity(int gravity) {
        return (this.alignViewGravity & gravity) == gravity;
    }

    public CustomDialog setAlignBaseViewGravity(View baseView, int alignGravity) {
        this.baseView(baseView);
        this.alignViewGravity = alignGravity;
        this.baseViewLoc = new int[4];
        baseView.getLocationInWindow(this.baseViewLoc);
        this.setFullScreen(true);
        return this;
    }

    public CustomDialog setAlignBaseView(View baseView) {
        this.baseView(baseView);
        this.baseViewLoc = new int[4];
        baseView.getLocationInWindow(this.baseViewLoc);
        this.setFullScreen(true);
        return this;
    }

    public CustomDialog setAlignBaseViewGravity(int alignGravity) {
        this.alignViewGravity = alignGravity;
        if (this.baseView() != null) {
            this.baseViewLoc = new int[4];
            this.baseView().getLocationInWindow(this.baseViewLoc);
        }
        this.setFullScreen(true);
        return this;
    }

    public CustomDialog setAlignBaseViewGravity(View baseView, int alignGravity, int marginLeft, int marginTop, int marginRight, int marginBottom) {
        this.marginRelativeBaseView = new int[]{marginLeft, marginTop, marginRight, marginBottom};
        this.refreshUI();
        return this.setAlignBaseViewGravity(baseView, alignGravity);
    }

    public int[] getBaseViewMargin() {
        return this.marginRelativeBaseView;
    }

    public CustomDialog setBaseViewMargin(int[] marginRelativeBaseView) {
        this.marginRelativeBaseView = marginRelativeBaseView;
        this.refreshUI();
        return this;
    }

    public CustomDialog setBaseViewMargin(int marginLeft, int marginTop, int marginRight, int marginBottom) {
        this.marginRelativeBaseView = new int[]{marginLeft, marginTop, marginRight, marginBottom};
        this.refreshUI();
        return this;
    }

    public CustomDialog setBaseViewMarginLeft(int marginLeft) {
        this.marginRelativeBaseView[0] = marginLeft;
        this.refreshUI();
        return this;
    }

    public CustomDialog setBaseViewMarginTop(int marginTop) {
        this.marginRelativeBaseView[1] = marginTop;
        this.refreshUI();
        return this;
    }

    public CustomDialog setBaseViewMarginRight(int marginRight) {
        this.marginRelativeBaseView[2] = marginRight;
        this.refreshUI();
        return this;
    }

    public CustomDialog setBaseViewMarginBottom(int marginBottom) {
        this.marginRelativeBaseView[3] = marginBottom;
        this.refreshUI();
        return this;
    }

    public int getBaseViewMarginLeft(int marginLeft) {
        return this.marginRelativeBaseView[0];
    }

    public int getBaseViewMarginTop(int marginLeft) {
        return this.marginRelativeBaseView[1];
    }

    public int getBaseViewMarginRight(int marginLeft) {
        return this.marginRelativeBaseView[2];
    }

    public int getBaseViewMarginBottom(int marginLeft) {
        return this.marginRelativeBaseView[3];
    }

    public View getBaseView() {
        return this.baseView();
    }

    public int getWidth() {
        return this.width;
    }

    public CustomDialog setWidth(int width) {
        this.width = width;
        this.refreshUI();
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public CustomDialog setHeight(int height) {
        this.height = height;
        this.refreshUI();
        return this;
    }

    public OnBackgroundMaskClickListener<CustomDialog> getOnBackgroundMaskClickListener() {
        return this.onBackgroundMaskClickListener;
    }

    public CustomDialog setOnBackgroundMaskClickListener(OnBackgroundMaskClickListener<CustomDialog> onBackgroundMaskClickListener) {
        this.onBackgroundMaskClickListener = onBackgroundMaskClickListener;
        return this;
    }

    public DialogXAnimInterface<CustomDialog> getDialogXAnimImpl() {
        return this.dialogXAnimImpl;
    }

    public CustomDialog setDialogXAnimImpl(DialogXAnimInterface<CustomDialog> dialogXAnimImpl) {
        this.dialogXAnimImpl = dialogXAnimImpl;
        return this;
    }

    public CustomDialog setRootPadding(int padding) {
        this.screenPaddings = new int[]{padding, padding, padding, padding};
        this.refreshUI();
        return this;
    }

    public CustomDialog setRootPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.screenPaddings = new int[]{paddingLeft, paddingTop, paddingRight, paddingBottom};
        this.refreshUI();
        return this;
    }

    protected void onShow(CustomDialog dialog) {
    }

    protected void onDismiss(CustomDialog dialog) {
    }

    protected CustomDialog baseView(View view) {
        if (view == null && this.baseViewWeakReference != null) {
            this.baseViewWeakReference.clear();
            this.baseViewWeakReference = null;
        } else {
            this.baseViewWeakReference = new WeakReference<View>(view);
        }
        return this;
    }

    protected View baseView() {
        return this.baseViewWeakReference == null ? null : (View)this.baseViewWeakReference.get();
    }

    @Override
    public CustomDialog setData(String key, Object obj) {
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.data.put(key, obj);
        return this;
    }

    public CustomDialog onShow(DialogXRunnable<CustomDialog> dialogXRunnable) {
        this.onShowRunnable = dialogXRunnable;
        if (this.isShow() && this.onShowRunnable != null) {
            this.onShowRunnable.run(this);
        }
        return this;
    }

    public CustomDialog onDismiss(DialogXRunnable<CustomDialog> dialogXRunnable) {
        this.onDismissRunnable = dialogXRunnable;
        return this;
    }

    @Override
    public CustomDialog setEnableImmersiveMode(boolean enableImmersiveMode) {
        this.enableImmersiveMode = enableImmersiveMode;
        this.refreshUI();
        return this;
    }

    @Override
    public CustomDialog setThisOrderIndex(int orderIndex) {
        this.thisOrderIndex = orderIndex;
        if (this.getDialogView() != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.getDialogView().setTranslationZ((float)orderIndex);
            } else {
                CustomDialog.error("DialogX: " + this.dialogKey() + " \u6267\u884c .setThisOrderIndex(" + orderIndex + ") \u5931\u8d25\uff1a\u7cfb\u7edf\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0cSDK-API \u7248\u672c\u5fc5\u987b\u5927\u4e8e 21\uff08LOLLIPOP\uff09");
            }
        }
        return this;
    }

    public CustomDialog bringToFront() {
        this.setThisOrderIndex(this.getHighestOrderIndex());
        return this;
    }

    public class DialogImpl
    implements DialogConvertViewInterface {
        public DialogXBaseRelativeLayout boxRoot;
        public MaxRelativeLayout boxCustom;
        boolean initSetCustomViewLayoutListener = false;
        ALIGN alignCache;

        public DialogImpl(View convertView) {
            if (convertView == null) {
                return;
            }
            CustomDialog.this.setDialogView(convertView);
            this.boxRoot = (DialogXBaseRelativeLayout)convertView.findViewById(R.id.box_root);
            this.boxCustom = (MaxRelativeLayout)convertView.findViewById(R.id.box_custom);
            this.init();
            CustomDialog.this.dialogImpl = this;
            this.refreshView();
        }

        @Override
        public void init() {
            if (CustomDialog.this.baseViewLoc == null && CustomDialog.this.baseView() != null) {
                CustomDialog.this.baseViewLoc = new int[4];
                CustomDialog.this.baseView().getLocationInWindow(CustomDialog.this.baseViewLoc);
                CustomDialog.this.baseViewLoc[2] = CustomDialog.this.baseView().getWidth();
                CustomDialog.this.baseViewLoc[3] = CustomDialog.this.baseView().getHeight();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                CustomDialog.this.getDialogView().setTranslationZ((float)CustomDialog.this.getThisOrderIndex());
            }
            this.boxRoot.setParentDialog(CustomDialog.this.me);
            this.boxRoot.setOnLifecycleCallBack(new DialogXBaseRelativeLayout.OnLifecycleCallBack(){

                @Override
                public void onShow() {
                    CustomDialog.this.isShow = true;
                    CustomDialog.this.preShow = false;
                    CustomDialog.this.setLifecycleState(Lifecycle.State.CREATED);
                    CustomDialog.this.getDialogLifecycleCallback().onShow(CustomDialog.this.me);
                    CustomDialog.this.onShow(CustomDialog.this.me);
                    CustomDialog.this.onDialogShow();
                    DialogImpl.this.boxCustom.setVisibility(8);
                }

                @Override
                public void onDismiss() {
                    CustomDialog.this.isShow = false;
                    CustomDialog.this.getDialogLifecycleCallback().onDismiss(CustomDialog.this.me);
                    CustomDialog.this.onDismiss(CustomDialog.this.me);
                    CustomDialog.this.dialogImpl = null;
                    CustomDialog.this.dialogLifecycleCallback = null;
                    CustomDialog.this.setLifecycleState(Lifecycle.State.DESTROYED);
                    System.gc();
                }
            });
            this.boxRoot.setOnBackPressedListener(new DialogXBaseRelativeLayout.PrivateBackPressedListener(){

                @Override
                public boolean onBackPressed() {
                    if (CustomDialog.this.onBackPressedListener != null) {
                        if (CustomDialog.this.onBackPressedListener.onBackPressed(CustomDialog.this.me)) {
                            CustomDialog.this.dismiss();
                        }
                    } else if (CustomDialog.this.isCancelable()) {
                        CustomDialog.this.dismiss();
                    }
                    return true;
                }
            });
            this.boxRoot.post(new Runnable(){

                @Override
                public void run() {
                    if (DialogImpl.this.getDialogXAnimImpl() != null) {
                        DialogImpl.this.getDialogXAnimImpl().doShowAnim(CustomDialog.this, (ViewGroup)DialogImpl.this.boxCustom);
                    }
                    if (CustomDialog.this.getDialogImpl() != null && CustomDialog.this.getDialogImpl().boxCustom != null) {
                        CustomDialog.this.getDialogImpl().boxCustom.setVisibility(0);
                    }
                    CustomDialog.this.setLifecycleState(Lifecycle.State.RESUMED);
                }
            });
            CustomDialog.this.onDialogInit();
        }

        @Override
        public void refreshView() {
            if (this.boxRoot == null || CustomDialog.this.getOwnActivity() == null) {
                return;
            }
            this.boxRoot.setAutoUnsafePlacePadding(CustomDialog.this.isEnableImmersiveMode());
            this.boxRoot.setRootPadding(CustomDialog.this.screenPaddings[0], CustomDialog.this.screenPaddings[1], CustomDialog.this.screenPaddings[2], CustomDialog.this.screenPaddings[3]);
            if (CustomDialog.this.baseView() != null) {
                if (!this.initSetCustomViewLayoutListener) {
                    if (this.boxCustom != null) {
                        RelativeLayout.LayoutParams rlp = new RelativeLayout.LayoutParams(-2, -2);
                        this.boxCustom.setLayoutParams((ViewGroup.LayoutParams)rlp);
                    }
                    final Runnable onLayoutChangeRunnable = new Runnable(){

                        @Override
                        public void run() {
                            int baseViewLeft = CustomDialog.this.baseViewLoc[0] - (int)DialogImpl.this.boxRoot.getX();
                            int baseViewTop = CustomDialog.this.baseViewLoc[1] - (int)DialogImpl.this.boxRoot.getY();
                            int calX = 0;
                            int calY = 0;
                            if (CustomDialog.this.alignViewGravity != -1) {
                                if (CustomDialog.this.isAlignBaseViewGravity(16)) {
                                    calY = baseViewTop + CustomDialog.this.baseView().getMeasuredHeight() / 2 - DialogImpl.this.boxCustom.getHeight() / 2;
                                }
                                if (CustomDialog.this.isAlignBaseViewGravity(1)) {
                                    calX = baseViewLeft + CustomDialog.this.baseView().getMeasuredWidth() / 2 - DialogImpl.this.boxCustom.getWidth() / 2;
                                }
                                if (CustomDialog.this.isAlignBaseViewGravity(17)) {
                                    calX = baseViewLeft + CustomDialog.this.baseView().getMeasuredWidth() / 2 - DialogImpl.this.boxCustom.getWidth() / 2;
                                    calY = baseViewTop + CustomDialog.this.baseView().getMeasuredHeight() / 2 - DialogImpl.this.boxCustom.getHeight() / 2;
                                }
                                if (CustomDialog.this.isAlignBaseViewGravity(48)) {
                                    calY = baseViewTop - DialogImpl.this.boxCustom.getHeight() - CustomDialog.this.marginRelativeBaseView[3];
                                }
                                if (CustomDialog.this.isAlignBaseViewGravity(3)) {
                                    calX = baseViewLeft - DialogImpl.this.boxCustom.getWidth() - CustomDialog.this.marginRelativeBaseView[2];
                                }
                                if (CustomDialog.this.isAlignBaseViewGravity(5)) {
                                    calX = baseViewLeft + CustomDialog.this.baseView().getWidth() + CustomDialog.this.marginRelativeBaseView[0];
                                }
                                if (CustomDialog.this.isAlignBaseViewGravity(80)) {
                                    calY = baseViewTop + CustomDialog.this.baseView().getHeight() + CustomDialog.this.marginRelativeBaseView[1];
                                }
                                int widthCache = CustomDialog.this.width == 0 ? CustomDialog.this.baseView().getWidth() : CustomDialog.this.width;
                                int heightCache = CustomDialog.this.height == 0 ? CustomDialog.this.baseView().getHeight() : CustomDialog.this.height;
                                CustomDialog.this.baseViewLoc[2] = widthCache > 0 ? widthCache : CustomDialog.this.baseViewLoc[2];
                                int n = CustomDialog.this.baseViewLoc[3] = heightCache > 0 ? heightCache : CustomDialog.this.baseViewLoc[3];
                                if (calX != 0 && (float)calX != DialogImpl.this.boxCustom.getX()) {
                                    DialogImpl.this.boxCustom.setX(calX);
                                }
                                if (calY != 0 && (float)calY != DialogImpl.this.boxCustom.getY()) {
                                    DialogImpl.this.boxCustom.setY(calY);
                                }
                                CustomDialog.this.onGetBaseViewLoc(CustomDialog.this.baseViewLoc);
                            }
                        }
                    };
                    CustomDialog.this.viewTreeObserver = this.boxCustom.getViewTreeObserver();
                    CustomDialog.this.viewTreeObserver.addOnDrawListener(CustomDialog.this.baseViewDrawListener = new ViewTreeObserver.OnDrawListener(){

                        public void onDraw() {
                            int[] baseViewLocCache = new int[2];
                            if (CustomDialog.this.baseView() != null) {
                                CustomDialog.this.baseView().getLocationInWindow(baseViewLocCache);
                                if (CustomDialog.this.getDialogImpl() != null && CustomDialog.this.isShow && CustomDialog.this.baseView().getVisibility() == 0) {
                                    if (baseViewLocCache[0] != 0) {
                                        CustomDialog.this.baseViewLoc[0] = baseViewLocCache[0];
                                    }
                                    if (baseViewLocCache[1] != 0) {
                                        CustomDialog.this.baseViewLoc[1] = baseViewLocCache[1];
                                    }
                                    onLayoutChangeRunnable.run();
                                }
                            } else {
                                CustomDialog.this.removeDrawListener(CustomDialog.this.viewTreeObserver, this);
                                CustomDialog.this.viewTreeObserver = null;
                                CustomDialog.this.baseViewDrawListener = null;
                            }
                        }
                    });
                    this.initSetCustomViewLayoutListener = true;
                }
            } else if (this.boxCustom != null) {
                RelativeLayout.LayoutParams rlp = (RelativeLayout.LayoutParams)this.boxCustom.getLayoutParams();
                if (rlp == null || this.alignCache != null && this.alignCache != CustomDialog.this.align) {
                    rlp = new RelativeLayout.LayoutParams(-2, -2);
                }
                switch (CustomDialog.this.align) {
                    case TOP_LEFT: 
                    case LEFT_TOP: {
                        rlp.removeRule(13);
                        rlp.addRule(10);
                        rlp.addRule(9);
                        break;
                    }
                    case TOP: 
                    case TOP_CENTER: {
                        rlp.removeRule(13);
                        rlp.addRule(10);
                        rlp.addRule(14);
                        break;
                    }
                    case TOP_RIGHT: 
                    case RIGHT_TOP: {
                        rlp.removeRule(13);
                        rlp.addRule(10);
                        rlp.addRule(11);
                        break;
                    }
                    case BOTTOM_LEFT: 
                    case LEFT_BOTTOM: {
                        rlp.removeRule(13);
                        rlp.addRule(12);
                        break;
                    }
                    case BOTTOM: 
                    case BOTTOM_CENTER: {
                        rlp.removeRule(13);
                        rlp.addRule(12);
                        rlp.addRule(14);
                        break;
                    }
                    case BOTTOM_RIGHT: 
                    case RIGHT_BOTTOM: {
                        rlp.removeRule(13);
                        rlp.addRule(12);
                        rlp.addRule(11);
                        break;
                    }
                    case CENTER: {
                        rlp.removeRule(10);
                        rlp.removeRule(12);
                        rlp.addRule(13);
                        break;
                    }
                    case LEFT: 
                    case LEFT_CENTER: {
                        rlp.removeRule(13);
                        rlp.addRule(10);
                        rlp.addRule(15);
                        break;
                    }
                    case RIGHT: 
                    case RIGHT_CENTER: {
                        rlp.removeRule(13);
                        rlp.addRule(11);
                        rlp.addRule(15);
                    }
                }
                this.alignCache = CustomDialog.this.align;
                this.boxCustom.setLayoutParams((ViewGroup.LayoutParams)rlp);
            }
            if (CustomDialog.this.bkgInterceptTouch) {
                if (CustomDialog.this.isCancelable()) {
                    this.boxRoot.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (CustomDialog.this.onBackgroundMaskClickListener == null || !CustomDialog.this.onBackgroundMaskClickListener.onClick(CustomDialog.this.me, v)) {
                                DialogImpl.this.doDismiss(v);
                            }
                        }
                    });
                } else {
                    this.boxRoot.setOnClickListener(null);
                }
            } else {
                this.boxRoot.setClickable(false);
            }
            if (CustomDialog.this.onBindView != null && CustomDialog.this.onBindView.getCustomView() != null && this.boxCustom != null) {
                CustomDialog.this.onBindView.bindParent((ViewGroup)this.boxCustom, CustomDialog.this.me);
            }
            if (this.boxCustom != null) {
                if (CustomDialog.this.width != -1) {
                    this.boxCustom.setMaxWidth(CustomDialog.this.width);
                    this.boxCustom.setMinimumWidth(CustomDialog.this.width);
                }
                if (CustomDialog.this.height != -1) {
                    this.boxCustom.setMaxHeight(CustomDialog.this.height);
                    this.boxCustom.setMinimumHeight(CustomDialog.this.height);
                }
            }
            this.boxRoot.setBackgroundColor(CustomDialog.this.getMaskColor());
            CustomDialog.this.onDialogRefreshUI();
        }

        @Override
        public void doDismiss(View v) {
            if (CustomDialog.this.preDismiss(CustomDialog.this)) {
                return;
            }
            if (v != null) {
                v.setEnabled(false);
            }
            if (!CustomDialog.this.dismissAnimFlag && this.boxCustom != null) {
                CustomDialog.this.dismissAnimFlag = true;
                this.boxCustom.post(new Runnable(){

                    @Override
                    public void run() {
                        DialogImpl.this.getDialogXAnimImpl().doExitAnim(CustomDialog.this, (ViewGroup)DialogImpl.this.boxCustom);
                        CustomDialog.runOnMainDelay(new Runnable(){

                            @Override
                            public void run() {
                                if (DialogImpl.this.boxRoot != null) {
                                    DialogImpl.this.boxRoot.setVisibility(8);
                                }
                                if (CustomDialog.this.baseViewDrawListener != null) {
                                    if (CustomDialog.this.viewTreeObserver != null) {
                                        CustomDialog.this.removeDrawListener(CustomDialog.this.viewTreeObserver, CustomDialog.this.baseViewDrawListener);
                                    } else if (DialogImpl.this.boxCustom != null) {
                                        CustomDialog.this.removeDrawListener(DialogImpl.this.boxCustom.getViewTreeObserver(), CustomDialog.this.baseViewDrawListener);
                                    }
                                    CustomDialog.this.baseViewDrawListener = null;
                                    CustomDialog.this.viewTreeObserver = null;
                                }
                                CustomDialog.dismiss(CustomDialog.this.getDialogView());
                            }
                        }, DialogImpl.this.getExitAnimationDuration(null));
                    }
                });
            }
        }

        protected DialogXAnimInterface<CustomDialog> getDialogXAnimImpl() {
            if (CustomDialog.this.dialogXAnimImpl == null) {
                CustomDialog.this.dialogXAnimImpl = new DialogXAnimInterface<CustomDialog>(){

                    @Override
                    public void doShowAnim(CustomDialog customDialog, ViewGroup dialogBodyView) {
                        if (CustomDialog.this.getDialogImpl() == null || CustomDialog.this.getDialogImpl().boxCustom == null) {
                            return;
                        }
                        Animation enterAnim = CustomDialog.this.getEnterAnimation();
                        long enterAnimationDuration = DialogImpl.this.getEnterAnimationDuration(enterAnim);
                        enterAnim.setDuration(enterAnimationDuration);
                        if (DialogImpl.this.boxCustom != null) {
                            DialogImpl.this.boxCustom.setVisibility(0);
                            DialogImpl.this.boxCustom.startAnimation(enterAnim);
                        }
                        if (CustomDialog.this.maskColor != 0) {
                            DialogImpl.this.boxRoot.setBackgroundColor(CustomDialog.this.maskColor);
                        }
                        ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                        bkgAlpha.setDuration(enterAnimationDuration);
                        bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                DialogImpl.this.boxRoot.setBkgAlpha(((Float)animation.getAnimatedValue()).floatValue());
                            }
                        });
                        bkgAlpha.start();
                    }

                    @Override
                    public void doExitAnim(CustomDialog customDialog, ViewGroup dialogBodyView) {
                        long exitAnimDurationTemp;
                        if (CustomDialog.this.getDialogImpl() == null || CustomDialog.this.getDialogImpl().boxCustom == null) {
                            return;
                        }
                        int exitAnimResIdTemp = R.anim.anim_dialogx_default_exit;
                        if (overrideExitAnimRes != 0) {
                            exitAnimResIdTemp = overrideExitAnimRes;
                        }
                        if (CustomDialog.this.exitAnimResId != 0) {
                            exitAnimResIdTemp = CustomDialog.this.exitAnimResId;
                        }
                        if (DialogImpl.this.boxCustom != null) {
                            Animation exitAnim = AnimationUtils.loadAnimation((Context)(CustomDialog.this.getOwnActivity() == null ? DialogImpl.this.boxCustom.getContext() : CustomDialog.this.getOwnActivity()), (int)exitAnimResIdTemp);
                            exitAnimDurationTemp = DialogImpl.this.getExitAnimationDuration(exitAnim);
                            exitAnim.setDuration(exitAnimDurationTemp);
                            DialogImpl.this.boxCustom.startAnimation(exitAnim);
                        } else {
                            exitAnimDurationTemp = DialogImpl.this.getExitAnimationDuration(null);
                        }
                        ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
                        bkgAlpha.setDuration(exitAnimDurationTemp);
                        bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                DialogImpl.this.boxRoot.setBkgAlpha(((Float)animation.getAnimatedValue()).floatValue());
                            }
                        });
                        bkgAlpha.start();
                    }
                };
            }
            return CustomDialog.this.dialogXAnimImpl;
        }

        public long getExitAnimationDuration(@Nullable Animation defaultExitAnim) {
            long exitAnimDurationTemp;
            if (defaultExitAnim == null && this.boxCustom.getAnimation() != null) {
                defaultExitAnim = this.boxCustom.getAnimation();
            }
            long l = exitAnimDurationTemp = defaultExitAnim == null || defaultExitAnim.getDuration() == 0L ? 300L : defaultExitAnim.getDuration();
            if (overrideExitDuration >= 0) {
                exitAnimDurationTemp = overrideExitDuration;
            }
            if (CustomDialog.this.exitAnimDuration != -1L) {
                exitAnimDurationTemp = CustomDialog.this.exitAnimDuration;
            }
            return exitAnimDurationTemp;
        }

        public long getEnterAnimationDuration(@Nullable Animation defaultEnterAnim) {
            long enterAnimDurationTemp;
            if (defaultEnterAnim == null && this.boxCustom.getAnimation() != null) {
                defaultEnterAnim = this.boxCustom.getAnimation();
            }
            long l = enterAnimDurationTemp = defaultEnterAnim == null || defaultEnterAnim.getDuration() == 0L ? 300L : defaultEnterAnim.getDuration();
            if (overrideEnterDuration >= 0) {
                enterAnimDurationTemp = overrideEnterDuration;
            }
            if (CustomDialog.this.enterAnimDuration >= 0L) {
                enterAnimDurationTemp = CustomDialog.this.enterAnimDuration;
            }
            return enterAnimDurationTemp;
        }
    }

    public static enum ALIGN {
        CENTER,
        TOP,
        TOP_CENTER,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM,
        BOTTOM_CENTER,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        LEFT,
        LEFT_CENTER,
        LEFT_TOP,
        LEFT_BOTTOM,
        RIGHT,
        RIGHT_CENTER,
        RIGHT_TOP,
        RIGHT_BOTTOM;

    }
}

