/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx;

import android.content.Context;
import android.content.res.Resources;
import android.util.Log;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.DialogLifecycleCallback;
import com.kongzue.dialogx.interfaces.DialogXStyle;
import com.kongzue.dialogx.style.MaterialStyle;
import com.kongzue.dialogx.util.DialogListBuilder;
import com.kongzue.dialogx.util.InputInfo;
import com.kongzue.dialogx.util.TextInfo;

public class DialogX {
    public static final String ERROR_INIT_TIPS = "DialogX.init: \u521d\u59cb\u5316\u5f02\u5e38\uff0ccontext \u4e3a null \u6216\u672a\u521d\u59cb\u5316\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b https://github.com/kongzue/DialogX/wiki";
    public static boolean DEBUGMODE = true;
    public static DialogXStyle globalStyle = MaterialStyle.style();
    public static THEME globalTheme = THEME.LIGHT;
    public static THEME tipTheme;
    public static IMPL_MODE implIMPLMode;
    public static int dialogMaxWidth;
    public static int dialogMaxHeight;
    public static int dialogMinWidth;
    public static int dialogMinHeight;
    public static boolean autoShowInputKeyboard;
    public static boolean onlyOnePopTip;
    public static boolean onlyOnePopNotification;
    public static TextInfo buttonTextInfo;
    public static TextInfo okButtonTextInfo;
    public static TextInfo titleTextInfo;
    public static TextInfo messageTextInfo;
    public static TextInfo tipTextInfo;
    public static InputInfo inputInfo;
    public static TextInfo menuTitleInfo;
    public static TextInfo menuTextInfo;
    public static Integer backgroundColor;
    public static Integer tipBackgroundColor;
    public static Integer tipProgressColor;
    public static boolean cancelable;
    public static boolean cancelableTipDialog;
    public static String cancelButtonText;
    public static TextInfo popTextInfo;
    public static long enterAnimDuration;
    public static long exitAnimDuration;
    public static DialogLifecycleCallback<BaseDialog> dialogLifeCycleListener;
    public static boolean autoRunOnUIThread;
    public static boolean useHaptic;
    @Deprecated
    public static boolean useActivityLayoutTranslationNavigationBar;
    public static int bottomDialogNavbarColor;
    public static int touchSlideTriggerThreshold;
    public static boolean globalHoverWindow;
    public static String[] unsupportedActivitiesPackageNames;
    public static int defaultMessageDialogBackgroundRadius;
    public static int defaultBottomDialogBackgroundRadius;
    public static int defaultFullScreenDialogBackgroundRadius;
    public static int defaultWaitAndTipDialogBackgroundRadius;
    public static int defaultPopMenuBackgroundRadius;
    public static int defaultPopTipBackgroundRadius;
    public static int defaultPopNotificationBackgroundRadius;
    public static boolean enableImmersiveMode;
    public static boolean ignoreUnsafeInsetsHorizontal;

    public static void init(Context context) {
        if (context == null) {
            DialogX.error(ERROR_INIT_TIPS);
            return;
        }
        BaseDialog.init(context);
    }

    public static void error(Object o) {
        if (DEBUGMODE) {
            Log.e((String)">>>", (String)o.toString());
        }
    }

    private static int dip2px(float dpValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static DialogListBuilder showDialogList(BaseDialog ... dialogs) {
        return DialogListBuilder.create(dialogs).show();
    }

    static {
        implIMPLMode = IMPL_MODE.VIEW;
        autoShowInputKeyboard = true;
        onlyOnePopTip = false;
        onlyOnePopNotification = true;
        backgroundColor = null;
        tipBackgroundColor = null;
        tipProgressColor = null;
        cancelable = true;
        cancelableTipDialog = false;
        enterAnimDuration = -1L;
        exitAnimDuration = -1L;
        autoRunOnUIThread = true;
        useHaptic = true;
        useActivityLayoutTranslationNavigationBar = false;
        bottomDialogNavbarColor = 0;
        touchSlideTriggerThreshold = DialogX.dip2px(35.0f);
        globalHoverWindow = false;
        unsupportedActivitiesPackageNames = new String[]{"com.bytedance.sdk.openadsdk.stub.activity", "com.mobile.auth.gatewayauth", "com.google.android.gms.ads"};
        defaultMessageDialogBackgroundRadius = -1;
        defaultBottomDialogBackgroundRadius = -1;
        defaultFullScreenDialogBackgroundRadius = -1;
        defaultWaitAndTipDialogBackgroundRadius = -1;
        defaultPopMenuBackgroundRadius = -1;
        defaultPopTipBackgroundRadius = -1;
        defaultPopNotificationBackgroundRadius = -1;
        enableImmersiveMode = true;
        ignoreUnsafeInsetsHorizontal = false;
    }

    public static enum IMPL_MODE {
        VIEW,
        WINDOW,
        DIALOG_FRAGMENT,
        FLOATING_ACTIVITY;

    }

    public static enum THEME {
        LIGHT,
        DARK,
        AUTO;

    }
}

