/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.view.inputmethod.InputMethodManager;
import android.widget.RelativeLayout;
import androidx.core.view.ViewCompat;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.OnBackPressedListener;
import com.kongzue.dialogx.interfaces.OnSafeInsetsChangeListener;
import com.kongzue.dialogx.util.views.MaxRelativeLayout;
import java.lang.ref.WeakReference;

public class DialogXBaseRelativeLayout
extends RelativeLayout {
    private OnSafeInsetsChangeListener onSafeInsetsChangeListener;
    private BaseDialog parentDialog;
    private boolean autoUnsafePlacePadding = true;
    private boolean focusable = true;
    private boolean interceptBack = true;
    private OnLifecycleCallBack onLifecycleCallBack;
    private OnBackPressedListener onBackPressedListener;
    private boolean isInited = false;
    private ViewTreeObserver.OnGlobalLayoutListener decorViewLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            if (Build.VERSION.SDK_INT >= 23) {
                DialogXBaseRelativeLayout.this.paddingView(DialogXBaseRelativeLayout.this.getRootWindowInsets());
            } else {
                if (BaseDialog.getTopActivity() == null) {
                    return;
                }
                DisplayMetrics displayMetrics = new DisplayMetrics();
                BaseDialog.getTopActivity().getWindowManager().getDefaultDisplay().getRealMetrics(displayMetrics);
                Rect rect = new Rect();
                BaseDialog.getTopActivity().getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
                DialogXBaseRelativeLayout.this.paddingView(rect.left, rect.top, displayMetrics.widthPixels - rect.right, displayMetrics.heightPixels - rect.bottom);
            }
        }
    };
    private WeakReference<View> requestFocusView;
    protected Rect unsafePlace = new Rect();
    boolean isLightMode = true;

    public DialogXBaseRelativeLayout(Context context) {
        super(context);
        this.init(null);
    }

    public DialogXBaseRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public DialogXBaseRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (Build.VERSION.SDK_INT >= 29) {
            this.setForceDarkAllowed(false);
        }
        if (!this.isInited) {
            if (attrs != null) {
                TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.DialogXBaseRelativeLayout);
                this.focusable = a.getBoolean(R.styleable.DialogXBaseRelativeLayout_baseFocusable, true);
                this.autoUnsafePlacePadding = a.getBoolean(R.styleable.DialogXBaseRelativeLayout_autoSafeArea, true);
                this.interceptBack = a.getBoolean(R.styleable.DialogXBaseRelativeLayout_interceptBack, true);
                a.recycle();
                this.isInited = true;
            }
            if (this.focusable) {
                this.setFocusable(true);
                this.setFocusableInTouchMode(true);
                this.requestFocus();
            }
            this.setBkgAlpha(0.0f);
            if (this.parentDialog != null && this.parentDialog.getDialogImplMode() != DialogX.IMPL_MODE.VIEW) {
                this.setFitsSystemWindows(true);
            }
        }
    }

    protected boolean fitSystemWindows(Rect insets) {
        if (DialogX.useActivityLayoutTranslationNavigationBar) {
            this.paddingView(insets.left, insets.top, insets.right, insets.bottom);
        }
        return super.fitSystemWindows(insets);
    }

    public WindowInsets dispatchApplyWindowInsets(WindowInsets insets) {
        if (Build.VERSION.SDK_INT >= 21 && DialogX.useActivityLayoutTranslationNavigationBar) {
            this.paddingView(insets.getSystemWindowInsetLeft(), insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight(), insets.getSystemWindowInsetBottom());
        }
        return super.dispatchApplyWindowInsets(insets);
    }

    public void paddingView(WindowInsets insets) {
        if (insets == null) {
            if (BaseDialog.publicWindowInsets() != null) {
                insets = BaseDialog.publicWindowInsets();
            } else {
                return;
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.paddingView(insets.getSystemWindowInsetLeft(), insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight(), insets.getSystemWindowInsetBottom());
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.isAttachedToWindow() && event.getAction() == 1 && event.getKeyCode() == 4 && this.interceptBack) {
            if (this.onBackPressedListener != null) {
                this.onBackPressedListener.onBackPressed();
            }
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.getWindowToken(), 2);
        return super.onTouchEvent(event);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            ViewParent parent = this.getParent();
            if (parent instanceof View) {
                ViewCompat.setFitsSystemWindows((View)this, (boolean)ViewCompat.getFitsSystemWindows((View)((View)parent)));
            }
            ViewCompat.requestApplyInsets((View)this);
            if (BaseDialog.getTopActivity() == null) {
                return;
            }
            BaseDialog.getTopActivity().getWindow().getDecorView().getViewTreeObserver().addOnGlobalLayoutListener(this.decorViewLayoutListener);
            this.decorViewLayoutListener.onGlobalLayout();
            if (this.onLifecycleCallBack != null) {
                this.onLifecycleCallBack.onShow();
            }
            this.isLightMode = (this.getResources().getConfiguration().uiMode & 0x30) == 16;
        }
    }

    protected void onDetachedFromWindow() {
        if (this.decorViewLayoutListener != null && BaseDialog.getTopActivity() != null) {
            BaseDialog.getTopActivity().getWindow().getDecorView().getViewTreeObserver().removeOnGlobalLayoutListener(this.decorViewLayoutListener);
        }
        if (this.onLifecycleCallBack != null) {
            this.onLifecycleCallBack.onDismiss();
        }
        this.onSafeInsetsChangeListener = null;
        super.onDetachedFromWindow();
    }

    public boolean performClick() {
        if (!this.isEnabled()) {
            return false;
        }
        return super.performClick();
    }

    public boolean callOnClick() {
        if (!this.isEnabled()) {
            return false;
        }
        return super.callOnClick();
    }

    public DialogXBaseRelativeLayout setOnLifecycleCallBack(OnLifecycleCallBack onLifecycleCallBack) {
        this.onLifecycleCallBack = onLifecycleCallBack;
        return this;
    }

    public float getSafeHeight() {
        return this.getMeasuredHeight() - this.unsafePlace.bottom - this.unsafePlace.top;
    }

    public void bindFocusView(View view) {
        this.requestFocusView = new WeakReference<View>(view);
    }

    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        if (direction == 130 && this.requestFocusView != null && this.requestFocusView.get() != null) {
            return ((View)this.requestFocusView.get()).requestFocus();
        }
        return super.requestFocus(direction, previouslyFocusedRect);
    }

    private void paddingView(int left, int top, int right, int bottom) {
        RelativeLayout.LayoutParams bkgLp;
        MaxRelativeLayout bkgView;
        this.unsafePlace = new Rect(left, top, right, bottom);
        if (this.onSafeInsetsChangeListener != null) {
            this.onSafeInsetsChangeListener.onChange(this.unsafePlace);
        }
        if ((bkgView = (MaxRelativeLayout)this.findViewById(R.id.bkg)) != null && bkgView.getLayoutParams() instanceof RelativeLayout.LayoutParams && (bkgLp = (RelativeLayout.LayoutParams)bkgView.getLayoutParams()).getRules()[12] == -1 && this.isAutoUnsafePlacePadding()) {
            bkgView.setPadding(0, 0, 0, bottom);
            bkgView.setNavBarHeight(bottom);
            this.setPadding(left, top, right, 0);
            return;
        }
        if (this.isAutoUnsafePlacePadding()) {
            this.setPadding(left, top, right, bottom);
        }
    }

    public DialogXBaseRelativeLayout setOnBackPressedListener(OnBackPressedListener onBackPressedListener) {
        this.onBackPressedListener = onBackPressedListener;
        return this;
    }

    public OnSafeInsetsChangeListener getOnSafeInsetsChangeListener() {
        return this.onSafeInsetsChangeListener;
    }

    public DialogXBaseRelativeLayout setOnSafeInsetsChangeListener(OnSafeInsetsChangeListener onSafeInsetsChangeListener) {
        this.onSafeInsetsChangeListener = onSafeInsetsChangeListener;
        return this;
    }

    public boolean isAutoUnsafePlacePadding() {
        return this.autoUnsafePlacePadding;
    }

    public Rect getUnsafePlace() {
        return this.unsafePlace;
    }

    public DialogXBaseRelativeLayout setAutoUnsafePlacePadding(boolean autoUnsafePlacePadding) {
        this.autoUnsafePlacePadding = autoUnsafePlacePadding;
        if (!autoUnsafePlacePadding) {
            this.setPadding(0, 0, 0, 0);
        }
        return this;
    }

    public BaseDialog getParentDialog() {
        return this.parentDialog;
    }

    public DialogXBaseRelativeLayout setParentDialog(BaseDialog parentDialog) {
        this.parentDialog = parentDialog;
        if (parentDialog.getDialogImplMode() != DialogX.IMPL_MODE.VIEW) {
            this.setFitsSystemWindows(true);
            if (Build.VERSION.SDK_INT >= 23) {
                this.paddingView(this.getRootWindowInsets());
            }
        }
        return this;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        boolean newLightStatus;
        super.onConfigurationChanged(newConfig);
        boolean bl = newLightStatus = (newConfig.uiMode & 0x30) == 16;
        if (this.isLightMode != newLightStatus && DialogX.globalTheme == DialogX.THEME.AUTO) {
            this.getParentDialog().restartDialog();
        }
    }

    public DialogXBaseRelativeLayout setBkgAlpha(float alpha) {
        if (this.getBackground() != null) {
            this.getBackground().mutate().setAlpha((int)(alpha * 255.0f));
        }
        return this;
    }

    public boolean isBaseFocusable() {
        return this.focusable;
    }

    public boolean isInterceptBack() {
        return this.interceptBack;
    }

    public DialogXBaseRelativeLayout setInterceptBack(boolean interceptBack) {
        this.interceptBack = interceptBack;
        return this;
    }

    public static abstract class OnLifecycleCallBack {
        public void onShow() {
        }

        public abstract void onDismiss();
    }
}

