/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.appcompat.widget.AppCompatImageView;
import com.kongzue.dialogx.impl.ActivityLifecycleImpl;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.util.DialogXFloatingWindowActivity;
import java.lang.ref.WeakReference;

public class ActivityScreenShotImageView
extends AppCompatImageView {
    float width;
    float height;
    float mRadius;
    private int screenWidth;
    private int screenHeight;
    private boolean inited = false;
    private boolean isScreenshotSuccess;
    private WeakReference<View> contentView;
    public static boolean hideContentView = false;

    public ActivityScreenShotImageView(Context context) {
        super(context);
        this.init(null);
    }

    public ActivityScreenShotImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public ActivityScreenShotImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(2, null);
        }
    }

    public void setRadius(float mRadius) {
        this.mRadius = mRadius;
        this.invalidate();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.width = this.getWidth();
        this.height = this.getHeight();
    }

    protected void onDraw(Canvas canvas) {
        if (this.width >= this.mRadius && this.height > this.mRadius) {
            if (this.isScreenshotSuccess) {
                canvas.drawColor(-16777216);
            }
            Path path = new Path();
            path.moveTo(this.mRadius, 0.0f);
            path.lineTo(this.width - this.mRadius, 0.0f);
            path.quadTo(this.width, 0.0f, this.width, this.mRadius);
            path.lineTo(this.width, this.height - this.mRadius);
            path.quadTo(this.width, this.height, this.width - this.mRadius, this.height);
            path.lineTo(this.mRadius, this.height);
            path.quadTo(0.0f, this.height, 0.0f, this.height - this.mRadius);
            path.lineTo(0.0f, this.mRadius);
            path.quadTo(0.0f, 0.0f, this.mRadius, 0.0f);
            canvas.clipPath(path);
        }
        try {
            canvas.drawColor(-1);
            super.onDraw(canvas);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.isAttachedToWindow() && !this.isScreenshotSuccess) {
            this.refreshImage();
        }
    }

    private void refreshImage() {
        if (this.screenWidth != this.getMeasuredWidth() || this.screenHeight != this.getMeasuredHeight()) {
            this.screenWidth = this.getMeasuredWidth();
            this.screenHeight = this.getMeasuredHeight();
            this.doScreenshotActivityAndZoom();
        }
    }

    private void doScreenshotActivityAndZoom() {
        final View contentView = this.getContentView();
        if (contentView == null) {
            return;
        }
        if (!this.inited) {
            this.drawViewImage(contentView);
        }
        contentView.post(new Runnable(){

            @Override
            public void run() {
                ActivityScreenShotImageView.this.drawViewImage(contentView);
                ActivityScreenShotImageView.this.inited = true;
            }
        });
    }

    private View getContentView() {
        Activity screenshotActivity = ActivityLifecycleImpl.getTopActivity();
        if (screenshotActivity == null) {
            return null;
        }
        if (screenshotActivity instanceof DialogXFloatingWindowActivity) {
            if (((DialogXFloatingWindowActivity)screenshotActivity).isScreenshot()) {
                return (FrameLayout)screenshotActivity.getWindow().getDecorView();
            }
            ((DialogXFloatingWindowActivity)screenshotActivity).setScreenshot(true);
            return BaseDialog.getRootFrameLayout();
        }
        return BaseDialog.getRootFrameLayout();
    }

    private void drawViewImage(View view) {
        if (view.getWidth() == 0 || view.getHeight() == 0) {
            return;
        }
        view.buildDrawingCache();
        Rect rect = new Rect();
        view.getWindowVisibleDisplayFrame(rect);
        view.setDrawingCacheEnabled(true);
        this.setImageBitmap(Bitmap.createBitmap((Bitmap)view.getDrawingCache(), (int)0, (int)0, (int)view.getWidth(), (int)view.getHeight()));
        view.destroyDrawingCache();
        if (hideContentView) {
            if (this.contentView != null && this.contentView.get() != null) {
                ((View)this.contentView.get()).setVisibility(0);
            }
            View childView = ((ViewGroup)view).getChildAt(0);
            childView.setVisibility(8);
            this.contentView = new WeakReference<View>(childView);
        }
        this.isScreenshotSuccess = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.contentView != null && this.contentView.get() != null && hideContentView) {
            ((View)this.contentView.get()).setVisibility(0);
            this.contentView.clear();
        }
    }
}

