/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.Space;
import android.widget.TextView;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.dialogs.PopMenu;
import com.kongzue.dialogx.interfaces.BaseDialog;
import java.util.List;

public class PopMenuArrayAdapter
extends BaseAdapter {
    public List<CharSequence> menuList;
    public Context context;
    private PopMenu popMenu;
    LayoutInflater mInflater;

    public PopMenuArrayAdapter(PopMenu popMenu, Context context, List<CharSequence> menuList) {
        this.popMenu = popMenu;
        this.menuList = menuList;
        this.context = context;
        this.mInflater = LayoutInflater.from((Context)context);
    }

    public int getCount() {
        return this.menuList.size();
    }

    public Object getItem(int position) {
        return this.menuList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int customBackgroundRes;
        ViewHolder viewHolder;
        if (convertView == null) {
            int customItemLayout;
            viewHolder = new ViewHolder();
            int resourceId = R.layout.item_dialogx_material_context_menu_normal_text;
            if (this.popMenu.getStyle().popMenuSettings() != null && (customItemLayout = this.popMenu.getStyle().popMenuSettings().overrideMenuItemLayoutRes(this.popMenu.isLightTheme())) != 0) {
                resourceId = customItemLayout;
            }
            convertView = this.mInflater.inflate(resourceId, null);
            viewHolder.imgDialogxMenuIcon = (ImageView)convertView.findViewById(R.id.img_dialogx_menu_icon);
            viewHolder.txtDialogxMenuText = (TextView)convertView.findViewById(R.id.txt_dialogx_menu_text);
            viewHolder.spaceRightPadding = (Space)convertView.findViewById(R.id.space_dialogx_right_padding);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        int n = customBackgroundRes = this.popMenu.getStyle().popMenuSettings() == null ? 0 : this.popMenu.getStyle().popMenuSettings().overrideMenuItemBackgroundRes(this.popMenu.isLightTheme(), position, this.getCount(), false);
        if (customBackgroundRes != 0) {
            convertView.setBackgroundResource(customBackgroundRes);
        }
        viewHolder.imgDialogxMenuIcon.setVisibility(8);
        viewHolder.txtDialogxMenuText.setText(this.menuList.get(position));
        if (this.popMenu.getStyle().popMenuSettings() != null && this.popMenu.getStyle().popMenuSettings().paddingVertical() != 0) {
            if (position == 0) {
                convertView.setPadding(0, this.popMenu.getStyle().popMenuSettings().paddingVertical(), 0, 0);
            } else if (position == this.getCount() - 1) {
                convertView.setPadding(0, 0, 0, this.popMenu.getStyle().popMenuSettings().paddingVertical());
            } else {
                convertView.setPadding(0, 0, 0, 0);
            }
        }
        if (this.popMenu.getMenuTextInfo() != null) {
            BaseDialog.useTextInfo(viewHolder.txtDialogxMenuText, this.popMenu.getMenuTextInfo());
        }
        int textColor = this.popMenu.isLightTheme() ? R.color.black90 : R.color.white90;
        viewHolder.txtDialogxMenuText.setTextColor(this.context.getResources().getColor(textColor));
        if (this.popMenu.getOnIconChangeCallBack() != null) {
            int resId = this.popMenu.getOnIconChangeCallBack().getIcon(this.popMenu, position, this.menuList.get(position).toString());
            boolean autoTintIconInLightOrDarkMode = this.popMenu.getOnIconChangeCallBack().isAutoTintIconInLightOrDarkMode();
            if (resId != 0) {
                viewHolder.imgDialogxMenuIcon.setVisibility(0);
                viewHolder.imgDialogxMenuIcon.setImageResource(resId);
                if ((this.isHaveProperties(viewHolder.txtDialogxMenuText.getGravity(), 17) || this.isHaveProperties(viewHolder.txtDialogxMenuText.getGravity(), 1)) && viewHolder.spaceRightPadding != null) {
                    viewHolder.spaceRightPadding.setVisibility(0);
                }
                if (Build.VERSION.SDK_INT >= 21 && autoTintIconInLightOrDarkMode) {
                    viewHolder.imgDialogxMenuIcon.setImageTintList(ColorStateList.valueOf((int)this.context.getResources().getColor(textColor)));
                }
            } else {
                viewHolder.imgDialogxMenuIcon.setVisibility(8);
                if (viewHolder.spaceRightPadding != null) {
                    viewHolder.spaceRightPadding.setVisibility(8);
                }
            }
        } else {
            viewHolder.imgDialogxMenuIcon.setVisibility(8);
            if (viewHolder.spaceRightPadding != null) {
                viewHolder.spaceRightPadding.setVisibility(8);
            }
        }
        return convertView;
    }

    private boolean isHaveProperties(int gravity, int property) {
        return (gravity & property) == property;
    }

    class ViewHolder {
        ImageView imgDialogxMenuIcon;
        TextView txtDialogxMenuText;
        Space spaceRightPadding;

        ViewHolder() {
        }
    }
}

