/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util;

import android.animation.ObjectAnimator;
import android.content.res.Resources;
import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;
import com.kongzue.dialogx.dialogs.FullScreenDialog;
import com.kongzue.dialogx.interfaces.ScrollController;

public class FullScreenDialogTouchEventInterceptor {
    private boolean isBkgTouched = false;
    private float bkgTouchDownY;
    private float bkgOldY;

    public FullScreenDialogTouchEventInterceptor(FullScreenDialog me, FullScreenDialog.DialogImpl impl) {
        this.refresh(me, impl);
    }

    public void refresh(FullScreenDialog me, final FullScreenDialog.DialogImpl impl) {
        if (me == null || impl == null || impl.bkg == null) {
            return;
        }
        RelativeLayout touchView = impl.boxCustom;
        if (impl.scrollView != null) {
            touchView = impl.bkg;
        }
        touchView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        FullScreenDialogTouchEventInterceptor.this.bkgTouchDownY = event.getY();
                        FullScreenDialogTouchEventInterceptor.this.isBkgTouched = true;
                        FullScreenDialogTouchEventInterceptor.this.bkgOldY = impl.bkg.getY();
                        break;
                    }
                    case 2: {
                        if (!FullScreenDialogTouchEventInterceptor.this.isBkgTouched) break;
                        float aimY = impl.bkg.getY() + event.getY() - FullScreenDialogTouchEventInterceptor.this.bkgTouchDownY;
                        if (impl.scrollView != null && impl.scrollView.isCanScroll()) {
                            if (aimY > 0.0f) {
                                if (impl.scrollView.getScrollDistance() == 0) {
                                    if (impl.scrollView instanceof ScrollController) {
                                        impl.scrollView.lockScroll(true);
                                    }
                                    impl.bkg.setY(aimY);
                                    break;
                                }
                                FullScreenDialogTouchEventInterceptor.this.bkgTouchDownY = event.getY();
                                break;
                            }
                            if (impl.scrollView instanceof ScrollController) {
                                impl.scrollView.lockScroll(false);
                            }
                            impl.bkg.setY(0.0f);
                            break;
                        }
                        if (aimY < 0.0f) {
                            aimY = 0.0f;
                        }
                        impl.bkg.setY(aimY);
                        break;
                    }
                    case 1: 
                    case 3: {
                        FullScreenDialogTouchEventInterceptor.this.isBkgTouched = false;
                        if (FullScreenDialogTouchEventInterceptor.this.bkgOldY == 0.0f) {
                            if (impl.bkg.getY() < (float)FullScreenDialogTouchEventInterceptor.this.dip2px(35.0f)) {
                                ObjectAnimator enterAnim = ObjectAnimator.ofFloat((Object)((Object)impl.bkg), (String)"y", (float[])new float[]{impl.bkg.getY(), 0.0f});
                                enterAnim.setDuration(300L);
                                enterAnim.start();
                                break;
                            }
                            if (impl.bkg.getY() > impl.bkgEnterAimY + (float)FullScreenDialogTouchEventInterceptor.this.dip2px(35.0f)) {
                                impl.preDismiss();
                                break;
                            }
                            ObjectAnimator enterAnim = ObjectAnimator.ofFloat((Object)((Object)impl.bkg), (String)"y", (float[])new float[]{impl.bkg.getY(), impl.bkgEnterAimY});
                            enterAnim.setDuration(300L);
                            enterAnim.start();
                            break;
                        }
                        if (impl.bkg.getY() < FullScreenDialogTouchEventInterceptor.this.bkgOldY - (float)FullScreenDialogTouchEventInterceptor.this.dip2px(35.0f)) {
                            ObjectAnimator enterAnim = ObjectAnimator.ofFloat((Object)((Object)impl.bkg), (String)"y", (float[])new float[]{impl.bkg.getY(), 0.0f});
                            enterAnim.setDuration(300L);
                            enterAnim.start();
                            break;
                        }
                        if (impl.bkg.getY() > FullScreenDialogTouchEventInterceptor.this.bkgOldY + (float)FullScreenDialogTouchEventInterceptor.this.dip2px(35.0f)) {
                            impl.preDismiss();
                            break;
                        }
                        ObjectAnimator enterAnim = ObjectAnimator.ofFloat((Object)((Object)impl.bkg), (String)"y", (float[])new float[]{impl.bkg.getY(), impl.bkgEnterAimY});
                        enterAnim.setDuration(300L);
                        enterAnim.start();
                    }
                }
                return false;
            }
        });
    }

    private int dip2px(float dpValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

