/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.Space;
import android.widget.TextView;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.dialogs.BottomMenu;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.util.TextInfo;
import java.util.List;

public class BottomMenuArrayAdapter
extends BaseAdapter {
    private BottomMenu bottomMenu;
    public List<CharSequence> objects;
    public Context context;
    TextInfo defaultMenuTextInfo;

    public BottomMenuArrayAdapter(BottomMenu bottomMenu, Context context, List<CharSequence> objects) {
        this.objects = objects;
        this.context = context;
        this.bottomMenu = bottomMenu;
    }

    public int getCount() {
        return this.objects.size();
    }

    public CharSequence getItem(int position) {
        return this.objects.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int textColor;
        ViewHolder viewHolder = null;
        if (convertView == null) {
            viewHolder = new ViewHolder();
            LayoutInflater mInflater = LayoutInflater.from((Context)this.context);
            int resourceId = R.layout.item_dialogx_material_bottom_menu_normal_text;
            if (this.bottomMenu.getStyle().overrideBottomDialogRes() != null) {
                resourceId = this.bottomMenu.getStyle().overrideBottomDialogRes().overrideMenuItemLayout(this.bottomMenu.isLightTheme(), position, this.getCount(), false);
                if (resourceId == 0) {
                    resourceId = R.layout.item_dialogx_material_bottom_menu_normal_text;
                } else if (!(BaseDialog.isNull(this.bottomMenu.getTitle()) && BaseDialog.isNull(this.bottomMenu.getMessage()) && this.bottomMenu.getCustomView() == null || position != 0)) {
                    resourceId = this.bottomMenu.getStyle().overrideBottomDialogRes().overrideMenuItemLayout(this.bottomMenu.isLightTheme(), position, this.getCount(), true);
                }
            }
            convertView = mInflater.inflate(resourceId, null);
            viewHolder.imgDialogxMenuIcon = (ImageView)convertView.findViewById(R.id.img_dialogx_menu_icon);
            viewHolder.imgDialogxMenuSelection = (ImageView)convertView.findViewById(R.id.img_dialogx_menu_selection);
            viewHolder.txtDialogxMenuText = (TextView)convertView.findViewById(R.id.txt_dialogx_menu_text);
            viewHolder.spaceDialogxRightPadding = (Space)convertView.findViewById(R.id.space_dialogx_right_padding);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        if (this.bottomMenu.getSelectMode() == BottomMenu.SELECT_MODE.SINGLE) {
            if (viewHolder.imgDialogxMenuSelection != null) {
                if (this.bottomMenu.getSelection() == position) {
                    viewHolder.imgDialogxMenuSelection.setVisibility(0);
                    int overrideSelectionImageResId = this.bottomMenu.getStyle().overrideBottomDialogRes().overrideSelectionImage(this.bottomMenu.isLightTheme(), true);
                    if (overrideSelectionImageResId != 0) {
                        viewHolder.imgDialogxMenuSelection.setImageResource(overrideSelectionImageResId);
                    }
                } else {
                    int overrideSelectionImageResId = this.bottomMenu.getStyle().overrideBottomDialogRes().overrideSelectionImage(this.bottomMenu.isLightTheme(), false);
                    if (overrideSelectionImageResId != 0) {
                        viewHolder.imgDialogxMenuSelection.setVisibility(0);
                        viewHolder.imgDialogxMenuSelection.setImageResource(overrideSelectionImageResId);
                    } else {
                        viewHolder.imgDialogxMenuSelection.setVisibility(4);
                    }
                }
            }
        } else if (this.bottomMenu.getSelectMode() == BottomMenu.SELECT_MODE.MULTIPLE) {
            if (viewHolder.imgDialogxMenuSelection != null) {
                if (this.bottomMenu.getSelectionList().contains(position)) {
                    viewHolder.imgDialogxMenuSelection.setVisibility(0);
                    int overrideSelectionImageResId = this.bottomMenu.getStyle().overrideBottomDialogRes().overrideMultiSelectionImage(this.bottomMenu.isLightTheme(), true);
                    if (overrideSelectionImageResId != 0) {
                        viewHolder.imgDialogxMenuSelection.setImageResource(overrideSelectionImageResId);
                    }
                } else {
                    int overrideSelectionImageResId = this.bottomMenu.getStyle().overrideBottomDialogRes().overrideMultiSelectionImage(this.bottomMenu.isLightTheme(), false);
                    if (overrideSelectionImageResId != 0) {
                        viewHolder.imgDialogxMenuSelection.setVisibility(0);
                        viewHolder.imgDialogxMenuSelection.setImageResource(overrideSelectionImageResId);
                    } else {
                        viewHolder.imgDialogxMenuSelection.setVisibility(4);
                    }
                }
            }
        } else {
            viewHolder.imgDialogxMenuSelection.setVisibility(8);
        }
        int overrideSelectionBackgroundColorRes = 0;
        if (this.bottomMenu.getStyle().overrideBottomDialogRes() != null) {
            overrideSelectionBackgroundColorRes = this.bottomMenu.getStyle().overrideBottomDialogRes().overrideSelectionMenuBackgroundColor(this.bottomMenu.isLightTheme());
        }
        if (this.bottomMenu.getSelection() == position && overrideSelectionBackgroundColorRes != 0 && Build.VERSION.SDK_INT >= 21) {
            convertView.setBackgroundTintList(ColorStateList.valueOf((int)this.context.getResources().getColor(overrideSelectionBackgroundColorRes)));
        }
        CharSequence text = this.objects.get(position);
        int n = textColor = this.bottomMenu.isLightTheme() ? R.color.black90 : R.color.white90;
        if (this.bottomMenu.getStyle().overrideBottomDialogRes() != null && this.bottomMenu.getStyle().overrideBottomDialogRes().overrideMenuTextColor(this.bottomMenu.isLightTheme()) != 0) {
            textColor = this.bottomMenu.getStyle().overrideBottomDialogRes().overrideMenuTextColor(this.bottomMenu.isLightTheme());
        }
        if (null != text) {
            if (this.defaultMenuTextInfo == null) {
                this.defaultMenuTextInfo = new TextInfo().setShowEllipsis(viewHolder.txtDialogxMenuText.getEllipsize() == TextUtils.TruncateAt.END).setFontColor(viewHolder.txtDialogxMenuText.getTextColors().getDefaultColor()).setBold(viewHolder.txtDialogxMenuText.getPaint().isFakeBoldText()).setFontSize(this.px2dip(viewHolder.txtDialogxMenuText.getTextSize())).setGravity(viewHolder.txtDialogxMenuText.getGravity()).setMaxLines(viewHolder.txtDialogxMenuText.getMaxLines());
            }
            viewHolder.txtDialogxMenuText.setText(text);
            viewHolder.txtDialogxMenuText.setTextColor(this.context.getResources().getColor(textColor));
            if (this.bottomMenu.getMenuItemTextInfoInterceptor() != null) {
                TextInfo textInfo = this.bottomMenu.getMenuItemTextInfoInterceptor().menuItemTextInfo(this.bottomMenu, position, text.toString());
                if (textInfo != null) {
                    BaseDialog.useTextInfo(viewHolder.txtDialogxMenuText, textInfo);
                } else if (this.bottomMenu.getMenuTextInfo() != null) {
                    BaseDialog.useTextInfo(viewHolder.txtDialogxMenuText, this.bottomMenu.getMenuTextInfo());
                } else {
                    BaseDialog.useTextInfo(viewHolder.txtDialogxMenuText, this.defaultMenuTextInfo);
                }
            } else if (this.bottomMenu.getMenuTextInfo() != null) {
                BaseDialog.useTextInfo(viewHolder.txtDialogxMenuText, this.bottomMenu.getMenuTextInfo());
            }
            if (Build.VERSION.SDK_INT >= 21 && viewHolder.imgDialogxMenuSelection != null) {
                if (this.bottomMenu.getStyle().overrideBottomDialogRes() != null && this.bottomMenu.getStyle().overrideBottomDialogRes().selectionImageTint(this.bottomMenu.isLightTheme())) {
                    viewHolder.imgDialogxMenuSelection.setImageTintList(ColorStateList.valueOf((int)this.context.getResources().getColor(textColor)));
                } else {
                    viewHolder.imgDialogxMenuSelection.setImageTintList(null);
                }
            }
            if (this.bottomMenu.getOnIconChangeCallBack() != null) {
                int resId = this.bottomMenu.getOnIconChangeCallBack().getIcon(this.bottomMenu, position, text.toString());
                boolean autoTintIconInLightOrDarkMode = this.bottomMenu.getOnIconChangeCallBack().isAutoTintIconInLightOrDarkMode();
                if (resId != 0) {
                    viewHolder.imgDialogxMenuIcon.setVisibility(0);
                    viewHolder.imgDialogxMenuIcon.setImageResource(resId);
                    if (viewHolder.spaceDialogxRightPadding != null) {
                        viewHolder.spaceDialogxRightPadding.setVisibility(0);
                    }
                    if (Build.VERSION.SDK_INT >= 21 && autoTintIconInLightOrDarkMode) {
                        viewHolder.imgDialogxMenuIcon.setImageTintList(ColorStateList.valueOf((int)this.context.getResources().getColor(textColor)));
                    }
                } else {
                    viewHolder.imgDialogxMenuIcon.setVisibility(8);
                    if (viewHolder.spaceDialogxRightPadding != null) {
                        viewHolder.spaceDialogxRightPadding.setVisibility(8);
                    }
                }
            } else {
                viewHolder.imgDialogxMenuIcon.setVisibility(8);
                if (viewHolder.spaceDialogxRightPadding != null) {
                    viewHolder.spaceDialogxRightPadding.setVisibility(8);
                }
            }
        }
        return convertView;
    }

    private int px2dip(float pxValue) {
        float scale = this.context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    class ViewHolder {
        ImageView imgDialogxMenuIcon;
        ImageView imgDialogxMenuSelection;
        TextView txtDialogxMenuText;
        Space spaceDialogxRightPadding;

        ViewHolder() {
        }
    }
}

