/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.interfaces;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.BaseDialog;

public abstract class OnBindView<D> {
    int layoutResId;
    View customView;
    private androidx.fragment.app.Fragment fragment;
    private Fragment supportFragment;
    private Runnable waitBindRunnable;

    public OnBindView(int layoutResId) {
        if (BaseDialog.getTopActivity() == null) {
            DialogX.error("DialogX.init: \u521d\u59cb\u5316\u5f02\u5e38\uff0ccontext \u4e3a null \u6216\u672a\u521d\u59cb\u5316\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b https://github.com/kongzue/DialogX/wiki");
            return;
        }
        this.layoutResId = layoutResId;
        this.customView = LayoutInflater.from((Context)BaseDialog.getTopActivity()).inflate(layoutResId, (ViewGroup)new RelativeLayout((Context)BaseDialog.getTopActivity()), false);
    }

    public OnBindView(final int layoutResId, boolean async) {
        if (BaseDialog.getTopActivity() == null) {
            DialogX.error("DialogX.init: \u521d\u59cb\u5316\u5f02\u5e38\uff0ccontext \u4e3a null \u6216\u672a\u521d\u59cb\u5316\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b https://github.com/kongzue/DialogX/wiki");
            return;
        }
        this.layoutResId = layoutResId;
        if (async) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    super.run();
                    OnBindView onBindView = OnBindView.this;
                    synchronized (onBindView) {
                        OnBindView.this.customView = LayoutInflater.from((Context)BaseDialog.getTopActivity()).inflate(layoutResId, (ViewGroup)new RelativeLayout((Context)BaseDialog.getTopActivity()), false);
                        if (OnBindView.this.waitBindRunnable != null) {
                            OnBindView.this.waitBindRunnable.run();
                            OnBindView.this.waitBindRunnable = null;
                        }
                    }
                }
            }.start();
        } else {
            this.customView = LayoutInflater.from((Context)BaseDialog.getTopActivity()).inflate(layoutResId, (ViewGroup)new RelativeLayout((Context)BaseDialog.getTopActivity()), false);
        }
    }

    public OnBindView(View customView) {
        this.customView = customView;
    }

    public OnBindView(androidx.fragment.app.Fragment fragment) {
        if (BaseDialog.getTopActivity() == null) {
            return;
        }
        this.customView = new FrameLayout((Context)BaseDialog.getTopActivity());
        this.customView.setId(R.id.id_frame_layout_custom);
        this.fragment = fragment;
        this.supportFragment = null;
    }

    public OnBindView(Fragment supportFragment) {
        if (BaseDialog.getTopActivity() == null) {
            return;
        }
        this.customView = new FrameLayout((Context)BaseDialog.getTopActivity());
        this.customView.setId(R.id.id_frame_layout_custom);
        this.supportFragment = supportFragment;
        this.fragment = null;
    }

    public abstract void onBind(D var1, View var2);

    public void onFragmentBind(D dialog, View frameLayout, androidx.fragment.app.Fragment fragment, FragmentManager fragmentManager) {
    }

    public void onFragmentBind(D dialog, View frameLayout, Fragment fragment, android.app.FragmentManager fragmentManager) {
    }

    public int getLayoutResId() {
        return this.layoutResId;
    }

    public OnBindView<D> setLayoutResId(int layoutResId) {
        this.layoutResId = layoutResId;
        return this;
    }

    public View getCustomView() {
        if (this.customView == null) {
            this.customView = LayoutInflater.from((Context)BaseDialog.getTopActivity()).inflate(this.layoutResId, (ViewGroup)new RelativeLayout((Context)BaseDialog.getTopActivity()), false);
            this.customView.setId(R.id.id_frame_layout_custom);
        }
        return this.customView;
    }

    public OnBindView<D> setCustomView(View customView) {
        this.customView = customView;
        return this;
    }

    public void clean() {
        this.layoutResId = 0;
        this.customView = null;
    }

    @Deprecated
    public void bindParent(ViewGroup parentView) {
        ViewGroup.LayoutParams lp;
        if (this.getCustomView() == null) {
            this.waitBind(parentView, null);
            return;
        }
        if (this.getCustomView().getParent() != null) {
            if (this.getCustomView().getParent() == parentView) {
                return;
            }
            ((ViewGroup)this.getCustomView().getParent()).removeView(this.getCustomView());
        }
        if ((lp = parentView.getLayoutParams()) == null) {
            lp = new RelativeLayout.LayoutParams(-1, -2);
        }
        parentView.addView(this.getCustomView(), lp);
    }

    public void bindParent(ViewGroup parentView, final BaseDialog dialog) {
        ViewGroup.LayoutParams lp;
        if (this.getCustomView() == null) {
            this.waitBind(parentView, null);
            return;
        }
        if (this.getCustomView().getParent() != null) {
            if (this.getCustomView().getParent() == parentView) {
                return;
            }
            ((ViewGroup)this.getCustomView().getParent()).removeView(this.getCustomView());
        }
        if ((lp = this.getCustomView().getLayoutParams()) == null) {
            lp = new RelativeLayout.LayoutParams(-1, -2);
        }
        parentView.addView(this.getCustomView(), lp);
        this.onBind(dialog, this.getCustomView());
        if (this.fragment != null || this.supportFragment != null) {
            this.getCustomView().post(new Runnable(){

                @Override
                public void run() {
                    FragmentTransaction transaction;
                    if (OnBindView.this.fragment != null && OnBindView.this.getCustomView() instanceof FrameLayout && BaseDialog.getTopActivity() instanceof AppCompatActivity) {
                        AppCompatActivity appCompatActivity = (AppCompatActivity)BaseDialog.getTopActivity();
                        transaction = appCompatActivity.getSupportFragmentManager().beginTransaction();
                        transaction.add(R.id.id_frame_layout_custom, OnBindView.this.fragment);
                        transaction.commit();
                        OnBindView.this.onFragmentBind(dialog, OnBindView.this.getCustomView(), OnBindView.this.fragment, appCompatActivity.getSupportFragmentManager());
                    }
                    if (OnBindView.this.supportFragment != null && OnBindView.this.getCustomView() instanceof FrameLayout && BaseDialog.getTopActivity() instanceof Activity) {
                        Activity activity = BaseDialog.getTopActivity();
                        transaction = activity.getFragmentManager().beginTransaction();
                        transaction.add(R.id.id_frame_layout_custom, OnBindView.this.supportFragment);
                        transaction.commit();
                        OnBindView.this.onFragmentBind(dialog, OnBindView.this.getCustomView(), OnBindView.this.supportFragment, activity.getFragmentManager());
                    }
                }
            });
        }
    }

    private void waitBind(final ViewGroup parentView, final BaseDialog dialog) {
        this.waitBindRunnable = new Runnable(){

            @Override
            public void run() {
                if (OnBindView.this.getCustomView() == null) {
                    if (dialog == null) {
                        OnBindView.this.bindParent(parentView);
                    } else {
                        OnBindView.this.bindParent(parentView, dialog);
                    }
                }
            }
        };
    }
}

