/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.interfaces;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.dialogs.PopTip;
import com.kongzue.dialogx.impl.ActivityLifecycleImpl;
import com.kongzue.dialogx.impl.DialogFragmentImpl;
import com.kongzue.dialogx.interfaces.DialogXStyle;
import com.kongzue.dialogx.interfaces.OnBackPressedListener;
import com.kongzue.dialogx.util.ActivityRunnable;
import com.kongzue.dialogx.util.DialogXFloatingWindowActivity;
import com.kongzue.dialogx.util.TextInfo;
import com.kongzue.dialogx.util.WindowUtil;
import com.kongzue.dialogx.util.views.DialogXBaseRelativeLayout;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class BaseDialog {
    protected static Thread uiThread;
    private static WeakReference<FrameLayout> rootFrameLayout;
    private static WeakReference<Activity> activityWeakReference;
    protected WeakReference<Activity> ownActivity;
    private static List<BaseDialog> runningDialogList;
    private WeakReference<View> dialogView;
    protected WeakReference<DialogFragmentImpl> ownDialogFragmentImpl;
    protected DialogX.IMPL_MODE dialogImplMode = DialogX.implIMPLMode;
    protected WeakReference<DialogXFloatingWindowActivity> floatingWindowActivity;
    private static Map<String, ActivityRunnable> waitRunDialogX;
    protected boolean cancelable = DialogX.cancelable;
    protected OnBackPressedListener onBackPressedListener;
    protected boolean isShow;
    protected DialogXStyle style = DialogX.globalStyle;
    protected DialogX.THEME theme = DialogX.globalTheme;
    protected boolean autoShowInputKeyboard;
    protected int backgroundColor = -1;
    protected long enterAnimDuration = DialogX.enterAnimDuration;
    protected long exitAnimDuration = DialogX.exitAnimDuration;
    protected int maxWidth;
    protected boolean dismissAnimFlag;
    protected static WindowInsets windowInsets;
    static WeakReference<Handler> mMainHandler;

    public static void init(Context context) {
        if (context == null) {
            context = ActivityLifecycleImpl.getTopActivity();
        }
        if (context instanceof Activity) {
            BaseDialog.initActivityContext((Activity)context);
        }
        ActivityLifecycleImpl.init(context, new ActivityLifecycleImpl.onActivityResumeCallBack(){

            @Override
            public void getActivity(Activity activity) {
                BaseDialog.initActivityContext(activity);
            }
        });
    }

    private static void initActivityContext(Activity activity) {
        try {
            uiThread = Thread.currentThread();
            activityWeakReference = new WeakReference<Activity>(activity);
            rootFrameLayout = new WeakReference<FrameLayout>((FrameLayout)activity.getWindow().getDecorView());
            if (Build.VERSION.SDK_INT >= 23) {
                BaseDialog.publicWindowInsets(((FrameLayout)rootFrameLayout.get()).getRootWindowInsets());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseDialog.error("DialogX.init: \u521d\u59cb\u5316\u5f02\u5e38\uff0c\u627e\u4e0d\u5230Activity\u7684\u6839\u5e03\u5c40");
        }
    }

    protected static void log(Object o) {
        if (DialogX.DEBUGMODE) {
            Log.i((String)">>>", (String)o.toString());
        }
    }

    protected static void error(Object o) {
        if (DialogX.DEBUGMODE) {
            Log.e((String)">>>", (String)o.toString());
        }
    }

    public static void onActivityResume(Activity activity) {
        if (runningDialogList != null) {
            CopyOnWriteArrayList<BaseDialog> copyOnWriteList = new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
            for (int i = copyOnWriteList.size() - 1; i >= 0; --i) {
                View boxRoot;
                BaseDialog baseDialog = copyOnWriteList.get(i);
                if (baseDialog.getOwnActivity() != activity || !baseDialog.isShow || baseDialog.getDialogView() == null || !((boxRoot = baseDialog.getDialogView().findViewById(R.id.box_root)) instanceof DialogXBaseRelativeLayout) || !((DialogXBaseRelativeLayout)boxRoot).isBaseFocusable()) continue;
                boxRoot.requestFocus();
                return;
            }
        }
    }

    private static void requestDialogFocus() {
        if (BaseDialog.getTopActivity() instanceof Activity) {
            BaseDialog.onActivityResume(BaseDialog.getTopActivity());
        }
    }

    public abstract void restartDialog();

    protected static void show(final View view) {
        if (view == null) {
            return;
        }
        final BaseDialog baseDialog = (BaseDialog)view.getTag();
        if (baseDialog != null) {
            if (baseDialog.isShow) {
                if (baseDialog.getDialogView() != null) {
                    baseDialog.getDialogView().setVisibility(0);
                    return;
                }
                BaseDialog.error(((BaseDialog)view.getTag()).dialogKey() + "\u5df2\u5904\u4e8e\u663e\u793a\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c show() \u6307\u4ee4\u3002");
                return;
            }
            baseDialog.ownActivity = new WeakReference(activityWeakReference.get());
            baseDialog.dialogView = new WeakReference<View>(view);
            BaseDialog.log(baseDialog.dialogKey() + ".show");
            BaseDialog.addDialogToRunningList(baseDialog);
            switch (baseDialog.dialogImplMode) {
                case WINDOW: {
                    BaseDialog.runOnMain(new Runnable(){

                        @Override
                        public void run() {
                            WindowUtil.show((Activity)activityWeakReference.get(), view, !(baseDialog instanceof PopTip));
                        }
                    });
                    break;
                }
                case DIALOG_FRAGMENT: {
                    DialogFragmentImpl dialogFragment = new DialogFragmentImpl(baseDialog, view);
                    dialogFragment.show(BaseDialog.getSupportFragmentManager((Activity)activityWeakReference.get()), "DialogX");
                    baseDialog.ownDialogFragmentImpl = new WeakReference<DialogFragmentImpl>(dialogFragment);
                    break;
                }
                case FLOATING_ACTIVITY: {
                    if (waitRunDialogX == null) {
                        waitRunDialogX = new HashMap<String, ActivityRunnable>();
                    }
                    waitRunDialogX.put(baseDialog.dialogKey(), new ActivityRunnable(){

                        @Override
                        public void run(Activity activity) {
                            baseDialog.floatingWindowActivity = new WeakReference<DialogXFloatingWindowActivity>((DialogXFloatingWindowActivity)activity);
                            final FrameLayout activityRootView = (FrameLayout)activity.getWindow().getDecorView();
                            if (activityRootView == null) {
                                return;
                            }
                            BaseDialog.runOnMain(new Runnable(){

                                @Override
                                public void run() {
                                    if (view.getParent() == rootFrameLayout.get()) {
                                        BaseDialog.error(((BaseDialog)view.getTag()).dialogKey() + "\u5df2\u5904\u4e8e\u663e\u793a\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c show() \u6307\u4ee4\u3002");
                                        return;
                                    }
                                    if (view.getParent() != null) {
                                        ((ViewGroup)view.getParent()).removeView(view);
                                    }
                                    activityRootView.addView(view);
                                }
                            });
                        }
                    });
                    DialogXFloatingWindowActivity dialogXFloatingWindowActivity = DialogXFloatingWindowActivity.getDialogXFloatingWindowActivity();
                    if (dialogXFloatingWindowActivity != null && dialogXFloatingWindowActivity.isSameFrom(((Activity)activityWeakReference.get()).hashCode())) {
                        dialogXFloatingWindowActivity.showDialogX(baseDialog.dialogKey());
                        return;
                    }
                    Intent intent = new Intent((Context)activityWeakReference.get(), DialogXFloatingWindowActivity.class);
                    intent.putExtra("dialogXKey", baseDialog.dialogKey());
                    intent.putExtra("fromActivityUiStatus", ((Activity)activityWeakReference.get()).getWindow().getDecorView().getSystemUiVisibility());
                    intent.putExtra("from", ((Activity)activityWeakReference.get()).hashCode());
                    ((Activity)activityWeakReference.get()).startActivity(intent);
                    int version = Build.VERSION.SDK_INT;
                    if (version <= 5) break;
                    ((Activity)activityWeakReference.get()).overridePendingTransition(0, 0);
                    break;
                }
                default: {
                    if (rootFrameLayout == null || rootFrameLayout.get() == null) {
                        return;
                    }
                    BaseDialog.runOnMain(new Runnable(){

                        @Override
                        public void run() {
                            if (view.getParent() == rootFrameLayout.get()) {
                                BaseDialog.error(((BaseDialog)view.getTag()).dialogKey() + "\u5df2\u5904\u4e8e\u663e\u793a\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c show() \u6307\u4ee4\u3002");
                                return;
                            }
                            if (view.getParent() != null) {
                                ((ViewGroup)view.getParent()).removeView(view);
                            }
                            ((FrameLayout)rootFrameLayout.get()).addView(view);
                        }
                    });
                }
            }
        }
    }

    private static FragmentManager getSupportFragmentManager(Activity activity) {
        return activity instanceof AppCompatActivity ? ((AppCompatActivity)activity).getSupportFragmentManager() : null;
    }

    public static ActivityRunnable getActivityRunnable(String dialogXKey) {
        if (dialogXKey == null) {
            return null;
        }
        return waitRunDialogX.get(dialogXKey);
    }

    protected static void show(final Activity activity, final View view) {
        BaseDialog baseDialog;
        if (activity == null || view == null) {
            return;
        }
        if (activityWeakReference == null || activityWeakReference.get() == null) {
            BaseDialog.initActivityContext(activity);
        }
        if ((baseDialog = (BaseDialog)view.getTag()) != null) {
            if (baseDialog.getDialogView() != null) {
                baseDialog.getDialogView().setVisibility(0);
            }
            if (baseDialog.isShow) {
                BaseDialog.error(((BaseDialog)view.getTag()).dialogKey() + "\u5df2\u5904\u4e8e\u663e\u793a\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c show() \u6307\u4ee4\u3002");
                return;
            }
            if (activity.isDestroyed()) {
                BaseDialog.error(((BaseDialog)view.getTag()).dialogKey() + ".show ERROR: activity is Destroyed.");
                return;
            }
            baseDialog.ownActivity = new WeakReference<Activity>(activity);
            baseDialog.dialogView = new WeakReference<View>(view);
            BaseDialog.log(baseDialog + ".show");
            BaseDialog.addDialogToRunningList(baseDialog);
            switch (baseDialog.dialogImplMode) {
                case WINDOW: {
                    BaseDialog.runOnMain(new Runnable(){

                        @Override
                        public void run() {
                            WindowUtil.show(activity, view, !(baseDialog instanceof PopTip));
                        }
                    });
                    break;
                }
                case DIALOG_FRAGMENT: {
                    DialogFragmentImpl dialogFragment = new DialogFragmentImpl(baseDialog, view);
                    dialogFragment.show(BaseDialog.getSupportFragmentManager(activity), "DialogX");
                    baseDialog.ownDialogFragmentImpl = new WeakReference<DialogFragmentImpl>(dialogFragment);
                    break;
                }
                case FLOATING_ACTIVITY: {
                    if (waitRunDialogX == null) {
                        waitRunDialogX = new HashMap<String, ActivityRunnable>();
                    }
                    waitRunDialogX.put(baseDialog.dialogKey(), new ActivityRunnable(){

                        @Override
                        public void run(Activity activity) {
                            baseDialog.floatingWindowActivity = new WeakReference<DialogXFloatingWindowActivity>((DialogXFloatingWindowActivity)activity);
                            final FrameLayout activityRootView = (FrameLayout)activity.getWindow().getDecorView();
                            if (activityRootView == null) {
                                return;
                            }
                            BaseDialog.runOnMain(new Runnable(){

                                @Override
                                public void run() {
                                    if (view.getParent() == rootFrameLayout.get()) {
                                        BaseDialog.error(((BaseDialog)view.getTag()).dialogKey() + "\u5df2\u5904\u4e8e\u663e\u793a\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c show() \u6307\u4ee4\u3002");
                                        return;
                                    }
                                    if (view.getParent() != null) {
                                        ((ViewGroup)view.getParent()).removeView(view);
                                    }
                                    activityRootView.addView(view);
                                }
                            });
                        }
                    });
                    DialogXFloatingWindowActivity dialogXFloatingWindowActivity = DialogXFloatingWindowActivity.getDialogXFloatingWindowActivity();
                    if (dialogXFloatingWindowActivity != null && dialogXFloatingWindowActivity.isSameFrom(activity.hashCode())) {
                        dialogXFloatingWindowActivity.showDialogX(baseDialog.dialogKey());
                        return;
                    }
                    Intent intent = new Intent((Context)activity, DialogXFloatingWindowActivity.class);
                    intent.putExtra("dialogXKey", baseDialog.dialogKey());
                    intent.putExtra("from", activity.hashCode());
                    intent.putExtra("fromActivityUiStatus", activity.getWindow().getDecorView().getSystemUiVisibility());
                    activity.startActivity(intent);
                    int version = Build.VERSION.SDK_INT;
                    if (version <= 5) break;
                    activity.overridePendingTransition(0, 0);
                    break;
                }
                default: {
                    final FrameLayout activityRootView = (FrameLayout)activity.getWindow().getDecorView();
                    if (activityRootView == null) {
                        return;
                    }
                    BaseDialog.runOnMain(new Runnable(){

                        @Override
                        public void run() {
                            if (view.getParent() == rootFrameLayout.get()) {
                                BaseDialog.error(((BaseDialog)view.getTag()).dialogKey() + "\u5df2\u5904\u4e8e\u663e\u793a\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c show() \u6307\u4ee4\u3002");
                                return;
                            }
                            if (view.getParent() != null) {
                                ((ViewGroup)view.getParent()).removeView(view);
                            }
                            activityRootView.addView(view);
                        }
                    });
                }
            }
        }
    }

    protected static void dismiss(final View dialogView) {
        if (dialogView == null) {
            return;
        }
        BaseDialog baseDialog = (BaseDialog)dialogView.getTag();
        BaseDialog.log(baseDialog.dialogKey() + ".dismiss");
        BaseDialog.removeDialogToRunningList(baseDialog);
        if (baseDialog.dialogView != null) {
            baseDialog.dialogView.clear();
        }
        switch (baseDialog.dialogImplMode) {
            case WINDOW: {
                BaseDialog.runOnMain(new Runnable(){

                    @Override
                    public void run() {
                        WindowUtil.dismiss(dialogView);
                    }
                });
                break;
            }
            case DIALOG_FRAGMENT: {
                if (baseDialog.ownDialogFragmentImpl == null || baseDialog.ownDialogFragmentImpl.get() == null) break;
                ((DialogFragmentImpl)((Object)baseDialog.ownDialogFragmentImpl.get())).dismiss();
                break;
            }
            case FLOATING_ACTIVITY: {
                if (baseDialog.floatingWindowActivity == null || baseDialog.floatingWindowActivity.get() == null) break;
                FrameLayout rootView = (FrameLayout)((DialogXFloatingWindowActivity)((Object)baseDialog.floatingWindowActivity.get())).getWindow().getDecorView();
                if (rootView != null) {
                    rootView.removeView(dialogView);
                }
                ((DialogXFloatingWindowActivity)((Object)baseDialog.floatingWindowActivity.get())).finish(baseDialog.dialogKey());
                BaseDialog.requestDialogFocus();
                break;
            }
            default: {
                BaseDialog.runOnMain(new Runnable(){

                    @Override
                    public void run() {
                        if (dialogView.getParent() == null || !(dialogView.getParent() instanceof ViewGroup)) {
                            if (rootFrameLayout == null) {
                                return;
                            }
                            ((FrameLayout)rootFrameLayout.get()).removeView(dialogView);
                        } else {
                            ((ViewGroup)dialogView.getParent()).removeView(dialogView);
                        }
                        BaseDialog.requestDialogFocus();
                    }
                }, true);
            }
        }
    }

    private static void addDialogToRunningList(BaseDialog baseDialog) {
        if (runningDialogList == null) {
            runningDialogList = new CopyOnWriteArrayList<BaseDialog>();
        }
        runningDialogList.add(baseDialog);
    }

    private static void removeDialogToRunningList(BaseDialog baseDialog) {
        if (runningDialogList != null) {
            runningDialogList.remove(baseDialog);
        }
    }

    public static Activity getTopActivity() {
        if (activityWeakReference == null) {
            BaseDialog.init(null);
            if (activityWeakReference == null) {
                return ActivityLifecycleImpl.getTopActivity();
            }
            return (Activity)activityWeakReference.get();
        }
        return (Activity)activityWeakReference.get();
    }

    public static Context getContext() {
        Activity activity = BaseDialog.getTopActivity();
        if (activity == null) {
            Context applicationContext = BaseDialog.getApplicationContext();
            if (applicationContext == null) {
                BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
                return null;
            }
            return applicationContext;
        }
        return activity;
    }

    public static Context getApplicationContext() {
        return ActivityLifecycleImpl.getApplicationContext();
    }

    public static void cleanContext() {
        if (activityWeakReference != null) {
            activityWeakReference.clear();
        }
        activityWeakReference = null;
        System.gc();
    }

    protected abstract void shutdown();

    public BaseDialog() {
        this.autoShowInputKeyboard = DialogX.autoShowInputKeyboard;
    }

    public abstract boolean isCancelable();

    public View createView(int layoutId) {
        if (BaseDialog.getApplicationContext() == null) {
            BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
            return null;
        }
        return LayoutInflater.from((Context)BaseDialog.getApplicationContext()).inflate(layoutId, null);
    }

    public boolean isShow() {
        return this.isShow;
    }

    public DialogXStyle getStyle() {
        return this.style;
    }

    public DialogX.THEME getTheme() {
        return this.theme;
    }

    public static void useTextInfo(TextView textView, TextInfo textInfo) {
        if (textInfo == null) {
            return;
        }
        if (textView == null) {
            return;
        }
        if (textInfo.getFontSize() > 0) {
            textView.setTextSize(textInfo.getFontSizeComplexUnit(), (float)textInfo.getFontSize());
        }
        if (textInfo.getFontColor() != 1) {
            textView.setTextColor(textInfo.getFontColor());
        }
        if (textInfo.getGravity() != -1) {
            textView.setGravity(textInfo.getGravity());
        }
        if (textInfo.isShowEllipsis()) {
            textView.setEllipsize(TextUtils.TruncateAt.END);
        } else {
            textView.setEllipsize(null);
        }
        if (textInfo.getMaxLines() != -1) {
            textView.setMaxLines(textInfo.getMaxLines());
        } else {
            textView.setMaxLines(Integer.MAX_VALUE);
        }
        textView.getPaint().setFakeBoldText(textInfo.isBold());
    }

    protected void showText(TextView textView, CharSequence text) {
        if (textView == null) {
            return;
        }
        if (BaseDialog.isNull(text)) {
            textView.setVisibility(8);
            textView.setText((CharSequence)"");
        } else {
            textView.setVisibility(0);
            textView.setText(text);
        }
    }

    public static boolean isNull(String s) {
        return s == null || s.trim().isEmpty() || "null".equals(s) || "(null)".equals(s);
    }

    public static boolean isNull(CharSequence c) {
        String s = String.valueOf(c);
        return c == null || s.trim().isEmpty() || "null".equals(s) || "(null)".equals(s);
    }

    public Resources getResources() {
        if (BaseDialog.getApplicationContext() == null) {
            return Resources.getSystem();
        }
        return BaseDialog.getApplicationContext().getResources();
    }

    public int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public boolean isLightTheme() {
        if (this.theme == DialogX.THEME.AUTO) {
            if (BaseDialog.getApplicationContext() == null) {
                return this.theme == DialogX.THEME.LIGHT;
            }
            return (this.getResources().getConfiguration().uiMode & 0x30) == 16;
        }
        return this.theme == DialogX.THEME.LIGHT;
    }

    public static FrameLayout getRootFrameLayout() {
        if (rootFrameLayout == null) {
            BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
            return null;
        }
        return (FrameLayout)rootFrameLayout.get();
    }

    public void tintColor(View view, int color2) {
        if (view == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            view.setBackgroundTintList(ColorStateList.valueOf((int)color2));
        }
    }

    protected void beforeShow() {
        View view;
        this.dismissAnimFlag = false;
        if (BaseDialog.getTopActivity() == null) {
            BaseDialog.init(null);
            if (BaseDialog.getTopActivity() == null) {
                BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
                return;
            }
        }
        if (4 != 4) {
            BaseDialog.error("DialogX \u6240\u5f15\u7528\u7684 Style \u4e0d\u7b26\u5408\u5f53\u524d\u9002\u7528\u7248\u672c\uff1a4 \u5f15\u5165\u7684 Style(" + this.style.getClass().getSimpleName() + ") \u7248\u672c" + 4);
        }
        if (this.dialogImplMode != DialogX.IMPL_MODE.VIEW && BaseDialog.getTopActivity() instanceof LifecycleOwner) {
            Lifecycle lifecycle = ((LifecycleOwner)BaseDialog.getTopActivity()).getLifecycle();
            lifecycle.addObserver((LifecycleObserver)new LifecycleEventObserver(){

                public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
                    if (event == Lifecycle.Event.ON_DESTROY) {
                        BaseDialog.recycleDialog(BaseDialog.getTopActivity());
                    }
                }
            });
        }
        if ((view = BaseDialog.getTopActivity().getCurrentFocus()) != null) {
            InputMethodManager imm = (InputMethodManager)BaseDialog.getTopActivity().getSystemService("input_method");
            imm.hideSoftInputFromWindow(view.getWindowToken(), 2);
        }
    }

    protected String getString(int titleResId) {
        if (BaseDialog.getApplicationContext() == null) {
            BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
            return null;
        }
        return this.getResources().getString(titleResId);
    }

    protected int getColor(int backgroundRes) {
        if (BaseDialog.getApplicationContext() == null) {
            BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
            return -16777216;
        }
        return this.getResources().getColor(backgroundRes);
    }

    public abstract String dialogKey();

    protected static void runOnMain(Runnable runnable) {
        if (!DialogX.autoRunOnUIThread || uiThread != null && Thread.currentThread() == uiThread) {
            runnable.run();
            return;
        }
        BaseDialog.runOnMain(runnable, true);
    }

    protected static void runOnMain(Runnable runnable, boolean needWaitMainLooper) {
        BaseDialog.getMainHandler().post(runnable);
    }

    protected static void runOnMainDelay(Runnable runnable, long delay) {
        if (!DialogX.autoRunOnUIThread) {
            runnable.run();
        }
        BaseDialog.getMainHandler().postDelayed(runnable, delay);
    }

    public View getDialogView() {
        if (this.dialogView == null) {
            return null;
        }
        return (View)this.dialogView.get();
    }

    public Activity getOwnActivity() {
        return this.ownActivity == null ? null : (Activity)this.ownActivity.get();
    }

    protected void cleanActivityContext() {
        if (this.ownActivity != null) {
            this.ownActivity.clear();
        }
        this.ownActivity = null;
    }

    public static void cleanAll() {
        if (runningDialogList != null) {
            CopyOnWriteArrayList<BaseDialog> copyOnWriteList = new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
            for (BaseDialog baseDialog : copyOnWriteList) {
                if (baseDialog.isShow()) {
                    baseDialog.shutdown();
                }
                baseDialog.cleanActivityContext();
                runningDialogList.remove(baseDialog);
            }
        }
    }

    public static void recycleDialog(Activity activity) {
        switch (DialogX.implIMPLMode) {
            case WINDOW: {
                if (runningDialogList == null) break;
                CopyOnWriteArrayList<BaseDialog> copyOnWriteList = new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
                for (BaseDialog baseDialog : copyOnWriteList) {
                    if (baseDialog.getOwnActivity() != activity || baseDialog.dialogView == null) continue;
                    WindowUtil.dismiss((View)baseDialog.dialogView.get());
                }
                break;
            }
            case DIALOG_FRAGMENT: {
                if (runningDialogList == null) break;
                CopyOnWriteArrayList<BaseDialog> copyOnWriteList = new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
                for (BaseDialog baseDialog : copyOnWriteList) {
                    if (baseDialog.getOwnActivity() != activity || baseDialog.ownDialogFragmentImpl == null || baseDialog.ownDialogFragmentImpl.get() == null) continue;
                    ((DialogFragmentImpl)((Object)baseDialog.ownDialogFragmentImpl.get())).dismiss();
                }
                break;
            }
            case FLOATING_ACTIVITY: {
                break;
            }
            default: {
                if (runningDialogList == null) break;
                CopyOnWriteArrayList<BaseDialog> copyOnWriteList = new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
                for (BaseDialog baseDialog : copyOnWriteList) {
                    if (baseDialog.getOwnActivity() != activity) continue;
                    baseDialog.cleanActivityContext();
                    runningDialogList.remove(baseDialog);
                }
            }
        }
        if (activity == BaseDialog.getTopActivity()) {
            BaseDialog.cleanContext();
        }
    }

    public static List<BaseDialog> getRunningDialogList() {
        if (runningDialogList == null) {
            return new ArrayList<BaseDialog>();
        }
        return new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
    }

    protected void imeShow(EditText editText, boolean show) {
        if (BaseDialog.getTopActivity() == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)BaseDialog.getTopActivity().getSystemService("input_method");
        if (show) {
            imm.showSoftInput((View)editText, 0);
        } else {
            imm.hideSoftInputFromWindow(editText.getWindowToken(), 0);
        }
    }

    public int getMaxWidth() {
        if (this.maxWidth == 0) {
            return DialogX.dialogMaxWidth;
        }
        return this.maxWidth;
    }

    public DialogX.IMPL_MODE getDialogImplMode() {
        return this.dialogImplMode;
    }

    public static WindowInsets publicWindowInsets() {
        return windowInsets;
    }

    public static void publicWindowInsets(WindowInsets windowInsets) {
        if (windowInsets != null) {
            BaseDialog.windowInsets = windowInsets;
        }
        if (runningDialogList != null) {
            CopyOnWriteArrayList<BaseDialog> copyOnWriteList = new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
            for (int i = copyOnWriteList.size() - 1; i >= 0; --i) {
                View boxRoot;
                BaseDialog baseDialog = copyOnWriteList.get(i);
                if (!baseDialog.isShow || baseDialog.getDialogView() == null || !((boxRoot = baseDialog.getDialogView().findViewById(R.id.box_root)) instanceof DialogXBaseRelativeLayout)) continue;
                BaseDialog.log("publicWindowInsets");
                ((DialogXBaseRelativeLayout)boxRoot).paddingView(windowInsets);
            }
        }
    }

    protected void bindFloatingActivity(DialogXFloatingWindowActivity activity) {
        this.floatingWindowActivity = new WeakReference<DialogXFloatingWindowActivity>(activity);
    }

    private static Handler getMainHandler() {
        if (mMainHandler != null && mMainHandler.get() != null) {
            return (Handler)mMainHandler.get();
        }
        mMainHandler = new WeakReference<Handler>(new Handler(Looper.getMainLooper()));
        return (Handler)mMainHandler.get();
    }

    public static enum BOOLEAN {
        TRUE,
        FALSE;

    }
}

