/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.dialogs;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.DialogConvertViewInterface;
import com.kongzue.dialogx.interfaces.DialogLifecycleCallback;
import com.kongzue.dialogx.interfaces.OnBackPressedListener;
import com.kongzue.dialogx.interfaces.OnBindView;
import com.kongzue.dialogx.interfaces.OnIconChangeCallBack;
import com.kongzue.dialogx.interfaces.OnMenuItemClickListener;
import com.kongzue.dialogx.util.PopMenuArrayAdapter;
import com.kongzue.dialogx.util.TextInfo;
import com.kongzue.dialogx.util.views.BlurView;
import com.kongzue.dialogx.util.views.DialogXBaseRelativeLayout;
import com.kongzue.dialogx.util.views.MaxRelativeLayout;
import com.kongzue.dialogx.util.views.PopMenuListView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PopMenu
extends BaseDialog {
    public static long overrideEnterDuration = -1L;
    public static long overrideExitDuration = -1L;
    protected PopMenu me = this;
    protected boolean bkgInterceptTouch = true;
    protected OnBindView<PopMenu> onBindView;
    protected DialogLifecycleCallback<PopMenu> dialogLifecycleCallback;
    protected View dialogView;
    protected List<CharSequence> menuList;
    protected DialogImpl dialogImpl;
    protected View baseView;
    protected boolean overlayBaseView = true;
    protected OnMenuItemClickListener<PopMenu> onMenuItemClickListener;
    protected OnIconChangeCallBack<PopMenu> onIconChangeCallBack;
    protected int width = -1;
    protected int height = -1;
    protected TextInfo menuTextInfo;
    protected boolean offScreen = false;
    protected int alignGravity = -1;
    protected int[] baseViewLoc = new int[2];
    protected PopMenuArrayAdapter menuListAdapter;

    public PopMenu() {
    }

    public PopMenu(View baseView, List<CharSequence> menuList) {
        this.menuList = menuList;
        this.baseView = baseView;
    }

    public PopMenu(View baseView, CharSequence[] menuList) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(Arrays.asList(menuList));
        this.baseView = baseView;
    }

    public PopMenu(List<CharSequence> menuList) {
        this.menuList = menuList;
    }

    public PopMenu(CharSequence[] menuList) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(Arrays.asList(menuList));
    }

    public PopMenu(OnBindView<PopMenu> onBindView) {
        this.onBindView = onBindView;
    }

    public PopMenu(View baseView, OnBindView<PopMenu> onBindView) {
        this.baseView = baseView;
        this.onBindView = onBindView;
    }

    public PopMenu(View baseView, List<CharSequence> menuList, OnBindView<PopMenu> onBindView) {
        this.baseView = baseView;
        this.menuList = menuList;
        this.onBindView = onBindView;
    }

    public PopMenu(View baseView, CharSequence[] menuList, OnBindView<PopMenu> onBindView) {
        this.baseView = baseView;
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(Arrays.asList(menuList));
        this.onBindView = onBindView;
    }

    public PopMenu(List<CharSequence> menuList, OnBindView<PopMenu> onBindView) {
        this.menuList = menuList;
        this.onBindView = onBindView;
    }

    public PopMenu(CharSequence[] menuList, OnBindView<PopMenu> onBindView) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(Arrays.asList(menuList));
        this.onBindView = onBindView;
    }

    public static PopMenu build() {
        return new PopMenu();
    }

    public static PopMenu show(CharSequence[] menus) {
        PopMenu popMenu = new PopMenu(menus);
        popMenu.show();
        return popMenu;
    }

    public static PopMenu show(List<CharSequence> menuList) {
        PopMenu popMenu = new PopMenu(menuList);
        popMenu.show();
        return popMenu;
    }

    public static PopMenu show(View baseView, CharSequence[] menus) {
        PopMenu popMenu = new PopMenu(baseView, menus);
        popMenu.show();
        return popMenu;
    }

    public static PopMenu show(View baseView, List<CharSequence> menuList) {
        PopMenu popMenu = new PopMenu(baseView, menuList);
        popMenu.show();
        return popMenu;
    }

    public static PopMenu show(View baseView, CharSequence[] menus, OnBindView<PopMenu> onBindView) {
        PopMenu popMenu = new PopMenu(baseView, menus, onBindView);
        popMenu.show();
        return popMenu;
    }

    public static PopMenu show(View baseView, List<CharSequence> menuList, OnBindView<PopMenu> onBindView) {
        PopMenu popMenu = new PopMenu(baseView, menuList, onBindView);
        popMenu.show();
        return popMenu;
    }

    public static PopMenu show(CharSequence[] menus, OnBindView<PopMenu> onBindView) {
        PopMenu popMenu = new PopMenu(menus, onBindView);
        popMenu.show();
        return popMenu;
    }

    public static PopMenu show(List<CharSequence> menuList, OnBindView<PopMenu> onBindView) {
        PopMenu popMenu = new PopMenu(menuList, onBindView);
        popMenu.show();
        return popMenu;
    }

    public void show() {
        super.beforeShow();
        if (this.getDialogView() == null) {
            int layoutId;
            int n = layoutId = this.isLightTheme() ? R.layout.layout_dialogx_popmenu_material : R.layout.layout_dialogx_popmenu_material_dark;
            if (this.getStyle().popMenuSettings() != null && this.getStyle().popMenuSettings().layout(this.isLightTheme()) != 0) {
                layoutId = this.getStyle().popMenuSettings().layout(this.isLightTheme());
            }
            this.dialogView = this.createView(layoutId);
            this.dialogImpl = new DialogImpl(this.dialogView);
            if (this.dialogView != null) {
                this.dialogView.setTag((Object)this.me);
            }
        }
        PopMenu.show(this.dialogView);
        if (this.baseView != null) {
            this.baseView.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    if (PopMenu.this.getDialogImpl() != null) {
                        PopMenu.this.baseViewLoc = new int[2];
                        PopMenu.this.baseView.getLocationOnScreen(PopMenu.this.baseViewLoc);
                        int width = PopMenu.this.baseView.getWidth();
                        int height = PopMenu.this.baseView.getHeight();
                        int left = PopMenu.this.baseViewLoc[0];
                        int top = PopMenu.this.baseViewLoc[1] + (PopMenu.this.overlayBaseView ? 0 : height);
                        PopMenu.this.getDialogImpl().boxBody.setX(left);
                        PopMenu.this.getDialogImpl().boxBody.setY(top);
                        if (width != 0 && PopMenu.this.getDialogImpl().boxBody.getWidth() != width) {
                            RelativeLayout.LayoutParams rLp = new RelativeLayout.LayoutParams(width, -2);
                            PopMenu.this.getDialogImpl().boxBody.setLayoutParams((ViewGroup.LayoutParams)rLp);
                        }
                        PopMenu.this.baseView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    }
                    return true;
                }
            });
        }
    }

    private int getBodyRealHeight() {
        if (this.getDialogImpl() == null) {
            return 0;
        }
        int matchParentMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((View)this.getDialogImpl().boxBody.getParent()).getWidth(), (int)0x40000000);
        int wrapContentMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((View)this.getDialogImpl().boxBody.getParent()).getHeight(), (int)Integer.MIN_VALUE);
        this.getDialogImpl().boxBody.measure(matchParentMeasureSpec, wrapContentMeasureSpec);
        return this.getDialogImpl().boxBody.getMeasuredHeight();
    }

    public void dismiss() {
        PopMenu.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (PopMenu.this.dialogImpl == null) {
                    return;
                }
                PopMenu.this.dialogImpl.doDismiss(null);
            }
        });
    }

    @Override
    public void restartDialog() {
        if (this.dialogView != null) {
            PopMenu.dismiss(this.dialogView);
            this.isShow = false;
        }
        if (this.getDialogImpl().boxCustom != null) {
            this.getDialogImpl().boxCustom.removeAllViews();
        }
        this.show();
    }

    @Override
    protected void shutdown() {
    }

    @Override
    public View getDialogView() {
        if (this.dialogView == null) {
            return null;
        }
        return this.dialogView;
    }

    public List<CharSequence> getMenuList() {
        return this.menuList;
    }

    public PopMenu setMenuList(List<CharSequence> menuList) {
        this.menuList = menuList;
        return this;
    }

    public PopMenu setMenuList(String[] menuList) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(Arrays.asList(menuList));
        this.refreshUI();
        return this;
    }

    public PopMenu setMenuList(CharSequence[] menuList) {
        this.menuList = new ArrayList<CharSequence>();
        this.menuList.addAll(Arrays.asList(menuList));
        this.refreshUI();
        return this;
    }

    public void refreshUI() {
        if (this.getDialogImpl() == null) {
            return;
        }
        PopMenu.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (PopMenu.this.dialogImpl != null) {
                    PopMenu.this.dialogImpl.refreshView();
                }
            }
        });
    }

    @Override
    public boolean isCancelable() {
        return true;
    }

    public DialogImpl getDialogImpl() {
        return this.dialogImpl;
    }

    @Override
    public String dialogKey() {
        return this.getClass().getSimpleName() + "(" + Integer.toHexString(this.hashCode()) + ")";
    }

    public DialogLifecycleCallback<PopMenu> getDialogLifecycleCallback() {
        return this.dialogLifecycleCallback == null ? new DialogLifecycleCallback<PopMenu>(){} : this.dialogLifecycleCallback;
    }

    public PopMenu setDialogLifecycleCallback(DialogLifecycleCallback<PopMenu> dialogLifecycleCallback) {
        this.dialogLifecycleCallback = dialogLifecycleCallback;
        if (this.isShow) {
            dialogLifecycleCallback.onShow(this.me);
        }
        return this;
    }

    public boolean isOverlayBaseView() {
        return this.overlayBaseView;
    }

    public PopMenu setOverlayBaseView(boolean overlayBaseView) {
        this.overlayBaseView = overlayBaseView;
        this.refreshUI();
        return this;
    }

    public OnMenuItemClickListener<PopMenu> getOnMenuItemClickListener() {
        return this.onMenuItemClickListener == null ? new OnMenuItemClickListener<PopMenu>(){

            @Override
            public boolean onClick(PopMenu dialog, CharSequence text, int index) {
                return false;
            }
        } : this.onMenuItemClickListener;
    }

    public PopMenu setOnMenuItemClickListener(OnMenuItemClickListener<PopMenu> onMenuItemClickListener) {
        this.onMenuItemClickListener = onMenuItemClickListener;
        return this;
    }

    public OnIconChangeCallBack<PopMenu> getOnIconChangeCallBack() {
        return this.onIconChangeCallBack;
    }

    public PopMenu setOnIconChangeCallBack(OnIconChangeCallBack<PopMenu> onIconChangeCallBack) {
        this.onIconChangeCallBack = onIconChangeCallBack;
        return this;
    }

    public PopMenu setCustomView(OnBindView<PopMenu> onBindView) {
        this.onBindView = onBindView;
        this.refreshUI();
        return this;
    }

    public View getCustomView() {
        if (this.onBindView == null) {
            return null;
        }
        return this.onBindView.getCustomView();
    }

    public PopMenu removeCustomView() {
        this.onBindView.clean();
        this.refreshUI();
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public PopMenu setWidth(int width) {
        this.width = width;
        this.refreshUI();
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public PopMenu setHeight(int height) {
        this.height = height;
        this.refreshUI();
        return this;
    }

    public int getAlignGravity() {
        return this.alignGravity;
    }

    public boolean isAlignGravity(int gravity) {
        return (this.alignGravity & gravity) == gravity;
    }

    public PopMenu setAlignGravity(int alignGravity) {
        this.alignGravity = alignGravity;
        return this;
    }

    public PopMenu setDialogImplMode(DialogX.IMPL_MODE dialogImplMode) {
        this.dialogImplMode = dialogImplMode;
        return this;
    }

    public TextInfo getMenuTextInfo() {
        if (this.menuTextInfo == null) {
            return DialogX.menuTextInfo;
        }
        return this.menuTextInfo;
    }

    public PopMenu setMenuTextInfo(TextInfo menuTextInfo) {
        this.menuTextInfo = menuTextInfo;
        return this;
    }

    public boolean isOffScreen() {
        return this.offScreen;
    }

    public PopMenu setOffScreen(boolean offScreen) {
        this.offScreen = offScreen;
        return this;
    }

    public boolean isBkgInterceptTouch() {
        return this.bkgInterceptTouch;
    }

    public PopMenu setBkgInterceptTouch(boolean bkgInterceptTouch) {
        this.bkgInterceptTouch = bkgInterceptTouch;
        return this;
    }

    public class DialogImpl
    implements DialogConvertViewInterface {
        private DialogXBaseRelativeLayout boxRoot;
        private MaxRelativeLayout boxBody;
        private RelativeLayout boxCustom;
        private PopMenuListView listMenu;
        private BlurView blurView;

        public DialogImpl(View convertView) {
            this.boxRoot = (DialogXBaseRelativeLayout)convertView.findViewById(R.id.box_root);
            this.boxBody = (MaxRelativeLayout)convertView.findViewById(R.id.box_body);
            this.boxCustom = (RelativeLayout)convertView.findViewById(R.id.box_custom);
            this.listMenu = (PopMenuListView)convertView.findViewById(R.id.listMenu);
            this.init();
        }

        @Override
        public void init() {
            if (PopMenu.this.menuListAdapter == null) {
                PopMenu.this.menuListAdapter = new PopMenuArrayAdapter(PopMenu.this.me, (Context)BaseDialog.getTopActivity(), PopMenu.this.menuList);
            }
            this.boxRoot.setParentDialog(PopMenu.this.me);
            this.boxRoot.setOnLifecycleCallBack(new DialogXBaseRelativeLayout.OnLifecycleCallBack(){

                @Override
                public void onShow() {
                    PopMenu.this.isShow = true;
                    PopMenu.this.getDialogLifecycleCallback().onShow(PopMenu.this.me);
                    PopMenu.this.refreshUI();
                }

                @Override
                public void onDismiss() {
                    PopMenu.this.isShow = false;
                    PopMenu.this.getDialogLifecycleCallback().onDismiss(PopMenu.this.me);
                    PopMenu.this.menuListAdapter = null;
                    PopMenu.this.dialogImpl = null;
                    PopMenu.this.baseView = null;
                    PopMenu.this.dialogLifecycleCallback = null;
                    System.gc();
                }
            });
            this.boxRoot.setOnBackPressedListener(new OnBackPressedListener(){

                @Override
                public boolean onBackPressed() {
                    if (PopMenu.this.onBackPressedListener != null) {
                        if (PopMenu.this.onBackPressedListener.onBackPressed()) {
                            PopMenu.this.dismiss();
                        }
                        return false;
                    }
                    if (PopMenu.this.isCancelable()) {
                        PopMenu.this.dismiss();
                    }
                    return false;
                }
            });
            this.listMenu.setMaxHeight(BaseDialog.getRootFrameLayout() == null ? (float)PopMenu.this.dip2px(500.0f) : (float)(BaseDialog.getRootFrameLayout().getMeasuredHeight() - PopMenu.this.dip2px(150.0f)));
            this.boxBody.setVisibility(4);
            this.boxBody.post(new Runnable(){
                int selectMenuIndex = -1;

                @Override
                public void run() {
                    long enterAnimDurationTemp;
                    long l = PopMenu.this.enterAnimDuration != -1L ? PopMenu.this.enterAnimDuration : (enterAnimDurationTemp = overrideEnterDuration == -1L ? 150L : overrideEnterDuration);
                    if (PopMenu.this.baseView != null) {
                        final int targetHeight = PopMenu.this.getBodyRealHeight();
                        ((DialogImpl)DialogImpl.this).boxBody.getLayoutParams().height = 1;
                        if (PopMenu.this.overlayBaseView && !DialogImpl.this.listMenu.isCanScroll()) {
                            if (PopMenu.this.baseView instanceof TextView) {
                                String baseText = ((TextView)PopMenu.this.baseView).getText().toString();
                                for (CharSequence c : PopMenu.this.menuList) {
                                    if (!TextUtils.equals((CharSequence)c.toString(), (CharSequence)baseText)) continue;
                                    this.selectMenuIndex = PopMenu.this.menuList.indexOf(c);
                                    break;
                                }
                            }
                            if (this.selectMenuIndex != -1) {
                                int[] viewLoc = new int[2];
                                if (DialogImpl.this.listMenu.getChildAt(this.selectMenuIndex) != null) {
                                    int itemHeight = DialogImpl.this.listMenu.getChildAt(this.selectMenuIndex).getMeasuredHeight();
                                    DialogImpl.this.listMenu.getChildAt(this.selectMenuIndex).getLocationOnScreen(viewLoc);
                                    DialogImpl.this.boxBody.setY((float)PopMenu.this.baseViewLoc[1] + (float)PopMenu.this.baseView.getMeasuredHeight() / 2.0f - ((float)viewLoc[1] - DialogImpl.this.boxBody.getY()) - (float)itemHeight / 2.0f);
                                }
                            }
                        }
                        int baseViewLeft = PopMenu.this.baseViewLoc[0];
                        int baseViewTop = PopMenu.this.baseViewLoc[1];
                        int calX = 0;
                        int calY = 0;
                        if (PopMenu.this.alignGravity != -1) {
                            if (PopMenu.this.isAlignGravity(16)) {
                                calY = Math.max(0, baseViewTop + PopMenu.this.baseView.getMeasuredHeight() / 2 - DialogImpl.this.boxBody.getHeight() / 2);
                            }
                            if (PopMenu.this.isAlignGravity(1)) {
                                calX = Math.max(0, baseViewLeft + (PopMenu.this.getWidth() > 0 ? PopMenu.this.baseView.getMeasuredWidth() / 2 - PopMenu.this.getWidth() / 2 : 0));
                            }
                            if (PopMenu.this.isAlignGravity(17)) {
                                calX = Math.max(0, baseViewLeft + (PopMenu.this.getWidth() > 0 ? PopMenu.this.baseView.getMeasuredWidth() / 2 - PopMenu.this.getWidth() / 2 : 0));
                                calY = Math.max(0, baseViewTop + PopMenu.this.baseView.getMeasuredHeight() / 2 - DialogImpl.this.boxBody.getHeight() / 2);
                            }
                            if (PopMenu.this.overlayBaseView) {
                                if (PopMenu.this.isAlignGravity(48)) {
                                    calY = baseViewTop - DialogImpl.this.boxBody.getHeight() + PopMenu.this.baseView.getHeight();
                                }
                                if (PopMenu.this.isAlignGravity(3)) {
                                    calX = baseViewLeft;
                                }
                                if (PopMenu.this.isAlignGravity(5)) {
                                    calX = baseViewLeft + (PopMenu.this.getWidth() > 0 ? PopMenu.this.baseView.getMeasuredWidth() - PopMenu.this.width : 0);
                                }
                                if (PopMenu.this.isAlignGravity(80)) {
                                    calY = baseViewTop;
                                }
                            } else {
                                if (PopMenu.this.isAlignGravity(48)) {
                                    calY = Math.max(0, baseViewTop - DialogImpl.this.boxBody.getHeight());
                                }
                                if (PopMenu.this.isAlignGravity(3)) {
                                    calX = Math.max(0, baseViewLeft - DialogImpl.this.boxBody.getWidth());
                                }
                                if (PopMenu.this.isAlignGravity(5)) {
                                    calX = Math.max(0, baseViewLeft + PopMenu.this.baseView.getWidth());
                                }
                                if (PopMenu.this.isAlignGravity(80)) {
                                    calY = Math.max(0, baseViewTop + PopMenu.this.baseView.getHeight());
                                }
                            }
                            if (!PopMenu.this.offScreen) {
                                if (calX < 0) {
                                    calX = 0;
                                }
                                if (calX + DialogImpl.this.boxBody.getWidth() > DialogImpl.this.boxRoot.getWidth()) {
                                    calX = DialogImpl.this.boxRoot.getWidth() - DialogImpl.this.boxBody.getWidth();
                                }
                                if (calY < 0) {
                                    calY = 0;
                                }
                                if (calY + DialogImpl.this.boxBody.getHeight() > DialogImpl.this.boxRoot.getHeight()) {
                                    calY = DialogImpl.this.boxRoot.getHeight() - DialogImpl.this.boxBody.getHeight();
                                }
                            }
                            if (calX != 0) {
                                DialogImpl.this.boxBody.setX(calX);
                            }
                            if (calY != 0) {
                                DialogImpl.this.boxBody.setY(calY);
                            }
                        }
                        Animation enterAnim = new Animation(){

                            protected void applyTransformation(float interpolatedTime, Transformation t) {
                                int aimHeight;
                                ((DialogImpl)DialogImpl.this).boxBody.getLayoutParams().height = aimHeight = interpolatedTime == 1.0f ? -2 : (int)((float)targetHeight * interpolatedTime);
                                int n = ((DialogImpl)DialogImpl.this).boxBody.getLayoutParams().width = PopMenu.this.getWidth() == -1 ? PopMenu.this.baseView.getWidth() : PopMenu.this.getWidth();
                                if (DialogImpl.this.boxBody.getY() + (float)aimHeight > DialogImpl.this.boxRoot.getSafeHeight()) {
                                    DialogImpl.this.boxBody.setY(DialogImpl.this.boxRoot.getSafeHeight() - (float)aimHeight);
                                }
                                if (!PopMenu.this.offScreen) {
                                    float calX = DialogImpl.this.boxBody.getX();
                                    float calY = DialogImpl.this.boxBody.getY();
                                    if (calX < 0.0f) {
                                        calX = 0.0f;
                                    }
                                    if (calX + (float)DialogImpl.this.boxBody.getWidth() > (float)DialogImpl.this.boxRoot.getWidth()) {
                                        calX = DialogImpl.this.boxRoot.getWidth() - DialogImpl.this.boxBody.getWidth();
                                    }
                                    if (calY < 0.0f) {
                                        calY = 0.0f;
                                    }
                                    if (calY + (float)DialogImpl.this.boxBody.getHeight() > (float)DialogImpl.this.boxRoot.getHeight()) {
                                        calY = DialogImpl.this.boxRoot.getHeight() - DialogImpl.this.boxBody.getHeight();
                                    }
                                    DialogImpl.this.boxBody.setX(calX);
                                    DialogImpl.this.boxBody.setY(calY);
                                }
                                DialogImpl.this.boxBody.requestLayout();
                            }

                            public boolean willChangeBounds() {
                                return true;
                            }
                        };
                        enterAnim.setInterpolator((Interpolator)new DecelerateInterpolator(2.0f));
                        enterAnim.setDuration(enterAnimDurationTemp);
                        DialogImpl.this.boxBody.startAnimation(enterAnim);
                        DialogImpl.this.boxBody.setVisibility(0);
                        if (PopMenu.this.getStyle().popMenuSettings() != null && PopMenu.this.getStyle().popMenuSettings().blurBackgroundSettings() != null && PopMenu.this.getStyle().popMenuSettings().blurBackgroundSettings().blurBackground()) {
                            int blurFrontColor = PopMenu.this.getResources().getColor(PopMenu.this.getStyle().popMenuSettings().blurBackgroundSettings().blurForwardColorRes(PopMenu.this.isLightTheme()));
                            DialogImpl.this.blurView = new BlurView(DialogImpl.this.boxBody.getContext(), null);
                            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(DialogImpl.this.boxBody.getWidth(), targetHeight);
                            DialogImpl.this.blurView.setOverlayColor(PopMenu.this.backgroundColor == -1 ? blurFrontColor : PopMenu.this.backgroundColor);
                            DialogImpl.this.blurView.setTag("blurView");
                            DialogImpl.this.blurView.setRadiusPx(PopMenu.this.getStyle().popMenuSettings().blurBackgroundSettings().blurBackgroundRoundRadiusPx());
                            DialogImpl.this.boxBody.addView(DialogImpl.this.blurView, 0, (ViewGroup.LayoutParams)params);
                        }
                        if (PopMenu.this.getStyle().popMenuSettings() != null && PopMenu.this.getStyle().popMenuSettings().backgroundMaskColorRes() != 0) {
                            ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                            bkgAlpha.setDuration(enterAnimDurationTemp);
                            bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                                public void onAnimationUpdate(ValueAnimator animation) {
                                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                                    DialogImpl.this.boxRoot.setBkgAlpha(value);
                                }
                            });
                            bkgAlpha.start();
                        }
                    } else {
                        RelativeLayout.LayoutParams rLp = (RelativeLayout.LayoutParams)DialogImpl.this.boxBody.getLayoutParams();
                        rLp.addRule(13);
                        rLp.width = PopMenu.this.getWidth() == -1 ? -1 : PopMenu.this.getWidth();
                        rLp.leftMargin = PopMenu.this.dip2px(50.0f);
                        rLp.rightMargin = PopMenu.this.dip2px(50.0f);
                        DialogImpl.this.boxBody.setLayoutParams((ViewGroup.LayoutParams)rLp);
                        DialogImpl.this.boxBody.setAlpha(0.0f);
                        if (Build.VERSION.SDK_INT >= 21) {
                            DialogImpl.this.boxBody.setElevation(PopMenu.this.dip2px(20.0f));
                        }
                        DialogImpl.this.boxBody.setVisibility(0);
                        DialogImpl.this.boxBody.animate().alpha(1.0f).setDuration(enterAnimDurationTemp);
                        DialogImpl.this.boxBody.post(new Runnable(){

                            @Override
                            public void run() {
                                if (PopMenu.this.getStyle().popMenuSettings() != null && PopMenu.this.getStyle().popMenuSettings().blurBackgroundSettings() != null && PopMenu.this.getStyle().popMenuSettings().blurBackgroundSettings().blurBackground()) {
                                    int blurFrontColor = PopMenu.this.getResources().getColor(PopMenu.this.getStyle().popMenuSettings().blurBackgroundSettings().blurForwardColorRes(PopMenu.this.isLightTheme()));
                                    DialogImpl.this.blurView = new BlurView(DialogImpl.this.boxBody.getContext(), null);
                                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(DialogImpl.this.boxBody.getWidth(), DialogImpl.this.boxBody.getHeight());
                                    DialogImpl.this.blurView.setOverlayColor(PopMenu.this.backgroundColor == -1 ? blurFrontColor : PopMenu.this.backgroundColor);
                                    DialogImpl.this.blurView.setTag("blurView");
                                    DialogImpl.this.blurView.setRadiusPx(PopMenu.this.getStyle().popMenuSettings().blurBackgroundSettings().blurBackgroundRoundRadiusPx());
                                    DialogImpl.this.boxBody.addView(DialogImpl.this.blurView, 0, (ViewGroup.LayoutParams)params);
                                    ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                                    bkgAlpha.setDuration(enterAnimDurationTemp);
                                    bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                                        public void onAnimationUpdate(ValueAnimator animation) {
                                            float value = ((Float)animation.getAnimatedValue()).floatValue();
                                            DialogImpl.this.boxRoot.setBkgAlpha(value);
                                        }
                                    });
                                    bkgAlpha.start();
                                }
                            }
                        });
                        ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                        bkgAlpha.setDuration(enterAnimDurationTemp);
                        bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                float value = ((Float)animation.getAnimatedValue()).floatValue();
                                DialogImpl.this.boxRoot.setBkgAlpha(value);
                            }
                        });
                        bkgAlpha.start();
                    }
                }
            });
            int dividerDrawableResId = 0;
            int dividerHeight = 0;
            if (PopMenu.this.style.popMenuSettings() != null) {
                dividerDrawableResId = PopMenu.this.style.popMenuSettings().overrideMenuDividerDrawableRes(PopMenu.this.isLightTheme());
                dividerHeight = PopMenu.this.style.popMenuSettings().overrideMenuDividerHeight(PopMenu.this.isLightTheme());
            }
            if (dividerDrawableResId == 0) {
                dividerDrawableResId = PopMenu.this.isLightTheme() ? R.drawable.rect_dialogx_material_menu_split_divider : R.drawable.rect_dialogx_material_menu_split_divider_night;
            }
            this.listMenu.setOverScrollMode(2);
            this.listMenu.setVerticalScrollBarEnabled(false);
            this.listMenu.setDivider(PopMenu.this.getResources().getDrawable(dividerDrawableResId));
            this.listMenu.setDividerHeight(dividerHeight);
            this.listMenu.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    if (!PopMenu.this.getOnMenuItemClickListener().onClick(PopMenu.this.me, PopMenu.this.menuList.get(position), position)) {
                        PopMenu.this.dismiss();
                    }
                }
            });
        }

        @Override
        public void refreshView() {
            if (this.boxRoot == null || BaseDialog.getTopActivity() == null) {
                return;
            }
            if (this.listMenu.getAdapter() == null) {
                this.listMenu.setAdapter((ListAdapter)PopMenu.this.menuListAdapter);
            } else {
                PopMenu.this.menuListAdapter.notifyDataSetChanged();
            }
            if (PopMenu.this.bkgInterceptTouch) {
                if (PopMenu.this.isCancelable()) {
                    this.boxRoot.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            DialogImpl.this.doDismiss(v);
                        }
                    });
                } else {
                    this.boxRoot.setOnClickListener(null);
                }
            } else {
                this.boxRoot.setClickable(false);
            }
            if (PopMenu.this.onBindView != null && PopMenu.this.onBindView.getCustomView() != null) {
                PopMenu.this.onBindView.bindParent((ViewGroup)this.boxCustom, PopMenu.this.me);
                this.boxCustom.setVisibility(0);
            } else {
                this.boxCustom.setVisibility(8);
            }
            if (PopMenu.this.width != -1) {
                this.boxBody.setMaxWidth(PopMenu.this.width);
                this.boxBody.setMinimumWidth(PopMenu.this.width);
            }
            if (PopMenu.this.height != -1) {
                this.boxBody.setMaxHeight(PopMenu.this.height);
                this.boxBody.setMinimumHeight(PopMenu.this.height);
            }
        }

        @Override
        public void doDismiss(View v) {
            if (v != null) {
                v.setEnabled(false);
            }
            if (!PopMenu.this.dismissAnimFlag) {
                PopMenu.this.dismissAnimFlag = true;
                this.boxRoot.post(new Runnable(){

                    @Override
                    public void run() {
                        if (overrideExitDuration != -1L) {
                            PopMenu.this.exitAnimDuration = overrideExitDuration;
                        }
                        Animation exitAnim = AnimationUtils.loadAnimation((Context)(BaseDialog.getTopActivity() == null ? DialogImpl.this.boxRoot.getContext() : BaseDialog.getTopActivity()), (int)R.anim.anim_dialogx_default_exit);
                        if (PopMenu.this.exitAnimDuration != -1L) {
                            exitAnim.setDuration(PopMenu.this.exitAnimDuration);
                        }
                        DialogImpl.this.boxBody.startAnimation(exitAnim);
                        DialogImpl.this.boxRoot.animate().alpha(0.0f).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration(PopMenu.this.exitAnimDuration == -1L ? exitAnim.getDuration() : PopMenu.this.exitAnimDuration);
                        if (PopMenu.this.baseView == null) {
                            ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
                            bkgAlpha.setDuration(PopMenu.this.exitAnimDuration == -1L ? exitAnim.getDuration() : PopMenu.this.exitAnimDuration);
                            bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                                public void onAnimationUpdate(ValueAnimator animation) {
                                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                                    DialogImpl.this.boxRoot.setBkgAlpha(value);
                                }
                            });
                            bkgAlpha.start();
                        }
                        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                PopMenu.dismiss(PopMenu.this.dialogView);
                            }
                        }, PopMenu.this.exitAnimDuration == -1L ? exitAnim.getDuration() : PopMenu.this.exitAnimDuration);
                    }
                });
            }
        }
    }
}

