/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.dialogs;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.DialogConvertViewInterface;
import com.kongzue.dialogx.interfaces.DialogLifecycleCallback;
import com.kongzue.dialogx.interfaces.DialogXStyle;
import com.kongzue.dialogx.interfaces.OnBackPressedListener;
import com.kongzue.dialogx.interfaces.OnBindView;
import com.kongzue.dialogx.util.views.DialogXBaseRelativeLayout;

public class CustomDialog
extends BaseDialog {
    public static int overrideEnterDuration = -1;
    public static int overrideExitDuration = -1;
    public static int overrideEnterAnimRes = 0;
    public static int overrideExitAnimRes = 0;
    public static int overrideMaskEnterAnimRes = R.anim.anim_dialogx_default_alpha_enter;
    public static int overrideMaskExitAnimRes = R.anim.anim_dialogx_default_exit;
    public static BaseDialog.BOOLEAN overrideCancelable;
    protected OnBindView<CustomDialog> onBindView;
    protected DialogLifecycleCallback<CustomDialog> dialogLifecycleCallback;
    protected CustomDialog me = this;
    protected DialogImpl dialogImpl;
    protected int enterAnimResId = R.anim.anim_dialogx_default_enter;
    protected int exitAnimResId = R.anim.anim_dialogx_default_exit;
    protected ALIGN align = ALIGN.CENTER;
    protected boolean autoUnsafePlacePadding = true;
    private View dialogView;
    protected int maskColor = 0;
    protected BaseDialog.BOOLEAN privateCancelable;
    protected boolean bkgInterceptTouch = true;

    protected CustomDialog() {
    }

    public static CustomDialog build() {
        return new CustomDialog();
    }

    public static CustomDialog build(OnBindView<CustomDialog> onBindView) {
        return new CustomDialog().setCustomView(onBindView);
    }

    public CustomDialog(OnBindView<CustomDialog> onBindView) {
        this.onBindView = onBindView;
    }

    public static CustomDialog show(OnBindView<CustomDialog> onBindView) {
        CustomDialog customDialog = new CustomDialog(onBindView);
        customDialog.show();
        return customDialog;
    }

    public static CustomDialog show(OnBindView<CustomDialog> onBindView, ALIGN align) {
        CustomDialog customDialog = new CustomDialog(onBindView);
        customDialog.align = align;
        customDialog.show();
        return customDialog;
    }

    public void show() {
        super.beforeShow();
        if (this.getDialogView() == null) {
            this.dialogView = this.createView(R.layout.layout_dialogx_custom);
            this.dialogImpl = new DialogImpl(this.dialogView);
            if (this.dialogView != null) {
                this.dialogView.setTag((Object)this.me);
            }
        }
        CustomDialog.show(this.dialogView);
    }

    public void show(Activity activity) {
        super.beforeShow();
        if (this.getDialogView() == null) {
            this.dialogView = this.createView(R.layout.layout_dialogx_custom);
            this.dialogImpl = new DialogImpl(this.dialogView);
            if (this.dialogView != null) {
                this.dialogView.setTag((Object)this.me);
            }
        }
        CustomDialog.show(activity, this.dialogView);
    }

    @Override
    public String dialogKey() {
        return this.getClass().getSimpleName() + "(" + Integer.toHexString(this.hashCode()) + ")";
    }

    public void refreshUI() {
        if (this.getDialogImpl() == null) {
            return;
        }
        CustomDialog.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (CustomDialog.this.dialogImpl != null) {
                    CustomDialog.this.dialogImpl.refreshView();
                }
            }
        });
    }

    public void dismiss() {
        CustomDialog.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (CustomDialog.this.dialogImpl == null) {
                    return;
                }
                CustomDialog.this.dialogImpl.doDismiss(null);
            }
        });
    }

    public DialogLifecycleCallback<CustomDialog> getDialogLifecycleCallback() {
        return this.dialogLifecycleCallback == null ? new DialogLifecycleCallback<CustomDialog>(){} : this.dialogLifecycleCallback;
    }

    public CustomDialog setDialogLifecycleCallback(DialogLifecycleCallback<CustomDialog> dialogLifecycleCallback) {
        this.dialogLifecycleCallback = dialogLifecycleCallback;
        if (this.isShow) {
            dialogLifecycleCallback.onShow(this.me);
        }
        return this;
    }

    public OnBackPressedListener getOnBackPressedListener() {
        return this.onBackPressedListener;
    }

    public CustomDialog setOnBackPressedListener(OnBackPressedListener onBackPressedListener) {
        this.onBackPressedListener = onBackPressedListener;
        this.refreshUI();
        return this;
    }

    public CustomDialog setStyle(DialogXStyle style2) {
        this.style = style2;
        return this;
    }

    public CustomDialog setTheme(DialogX.THEME theme) {
        this.theme = theme;
        return this;
    }

    @Override
    public boolean isCancelable() {
        if (this.privateCancelable != null) {
            return this.privateCancelable == BaseDialog.BOOLEAN.TRUE;
        }
        if (overrideCancelable != null) {
            return overrideCancelable == BaseDialog.BOOLEAN.TRUE;
        }
        return this.cancelable;
    }

    public CustomDialog setCancelable(boolean cancelable) {
        this.privateCancelable = cancelable ? BaseDialog.BOOLEAN.TRUE : BaseDialog.BOOLEAN.FALSE;
        this.refreshUI();
        return this;
    }

    public DialogImpl getDialogImpl() {
        return this.dialogImpl;
    }

    public CustomDialog setCustomView(OnBindView<CustomDialog> onBindView) {
        this.onBindView = onBindView;
        this.refreshUI();
        return this;
    }

    public View getCustomView() {
        if (this.onBindView == null) {
            return null;
        }
        return this.onBindView.getCustomView();
    }

    public CustomDialog removeCustomView() {
        this.onBindView.clean();
        this.refreshUI();
        return this;
    }

    public int getEnterAnimResId() {
        return this.enterAnimResId;
    }

    public CustomDialog setEnterAnimResId(int enterAnimResId) {
        this.enterAnimResId = enterAnimResId;
        return this;
    }

    public int getExitAnimResId() {
        return this.exitAnimResId;
    }

    public CustomDialog setExitAnimResId(int exitAnimResId) {
        this.exitAnimResId = exitAnimResId;
        return this;
    }

    public CustomDialog setAnimResId(int enterAnimResId, int exitAnimResId) {
        this.enterAnimResId = enterAnimResId;
        this.exitAnimResId = exitAnimResId;
        return this;
    }

    public ALIGN getAlign() {
        return this.align;
    }

    public CustomDialog setAlign(ALIGN align) {
        this.align = align;
        return this;
    }

    public boolean isAutoUnsafePlacePadding() {
        return this.autoUnsafePlacePadding;
    }

    public CustomDialog setAutoUnsafePlacePadding(boolean autoUnsafePlacePadding) {
        this.autoUnsafePlacePadding = autoUnsafePlacePadding;
        this.refreshUI();
        return this;
    }

    public CustomDialog setFullScreen(boolean fullscreen) {
        this.autoUnsafePlacePadding = !this.autoUnsafePlacePadding;
        this.refreshUI();
        return this;
    }

    public CustomDialog setMaskColor(@ColorInt int maskColor) {
        this.maskColor = maskColor;
        this.refreshUI();
        return this;
    }

    public long getEnterAnimDuration() {
        return this.enterAnimDuration;
    }

    public CustomDialog setEnterAnimDuration(long enterAnimDuration) {
        this.enterAnimDuration = enterAnimDuration;
        return this;
    }

    public long getExitAnimDuration() {
        return this.exitAnimDuration;
    }

    public CustomDialog setExitAnimDuration(long exitAnimDuration) {
        this.exitAnimDuration = exitAnimDuration;
        return this;
    }

    @Override
    public void restartDialog() {
        if (this.dialogView != null) {
            CustomDialog.dismiss(this.dialogView);
            this.isShow = false;
        }
        if (this.getDialogImpl().boxCustom != null) {
            this.getDialogImpl().boxCustom.removeAllViews();
        }
        this.enterAnimDuration = 0L;
        this.dialogView = this.createView(R.layout.layout_dialogx_custom);
        this.dialogImpl = new DialogImpl(this.dialogView);
        if (this.dialogView != null) {
            this.dialogView.setTag((Object)this.me);
        }
        CustomDialog.show(this.dialogView);
    }

    public void hide() {
        if (this.getDialogView() != null) {
            this.getDialogView().setVisibility(8);
        }
    }

    @Override
    protected void shutdown() {
        this.dismiss();
    }

    public CustomDialog setDialogImplMode(DialogX.IMPL_MODE dialogImplMode) {
        this.dialogImplMode = dialogImplMode;
        return this;
    }

    public boolean isBkgInterceptTouch() {
        return this.bkgInterceptTouch;
    }

    public CustomDialog setBkgInterceptTouch(boolean bkgInterceptTouch) {
        this.bkgInterceptTouch = bkgInterceptTouch;
        return this;
    }

    public class DialogImpl
    implements DialogConvertViewInterface {
        public DialogXBaseRelativeLayout boxRoot;
        public RelativeLayout boxCustom;

        public DialogImpl(View convertView) {
            if (convertView == null) {
                return;
            }
            this.boxRoot = (DialogXBaseRelativeLayout)convertView.findViewById(R.id.box_root);
            this.boxCustom = (RelativeLayout)convertView.findViewById(R.id.box_custom);
            this.init();
            CustomDialog.this.dialogImpl = this;
            this.refreshView();
        }

        @Override
        public void init() {
            this.boxRoot.setParentDialog(CustomDialog.this.me);
            this.boxRoot.setOnLifecycleCallBack(new DialogXBaseRelativeLayout.OnLifecycleCallBack(){

                @Override
                public void onShow() {
                    CustomDialog.this.isShow = true;
                    CustomDialog.this.getDialogLifecycleCallback().onShow(CustomDialog.this.me);
                    DialogImpl.this.boxCustom.setVisibility(8);
                }

                @Override
                public void onDismiss() {
                    CustomDialog.this.isShow = false;
                    CustomDialog.this.getDialogLifecycleCallback().onDismiss(CustomDialog.this.me);
                    CustomDialog.this.dialogImpl = null;
                    CustomDialog.this.dialogLifecycleCallback = null;
                    System.gc();
                }
            });
            this.boxRoot.setOnBackPressedListener(new OnBackPressedListener(){

                @Override
                public boolean onBackPressed() {
                    if (CustomDialog.this.onBackPressedListener != null) {
                        if (CustomDialog.this.onBackPressedListener.onBackPressed()) {
                            CustomDialog.this.dismiss();
                        }
                        return false;
                    }
                    if (CustomDialog.this.isCancelable()) {
                        CustomDialog.this.dismiss();
                    }
                    return false;
                }
            });
            this.boxRoot.post(new Runnable(){

                @Override
                public void run() {
                    Animation enterAnim;
                    if (CustomDialog.this.enterAnimResId == R.anim.anim_dialogx_default_enter && CustomDialog.this.exitAnimResId == R.anim.anim_dialogx_default_exit) {
                        switch (CustomDialog.this.align) {
                            case TOP: {
                                CustomDialog.this.enterAnimResId = R.anim.anim_dialogx_top_enter;
                                CustomDialog.this.exitAnimResId = R.anim.anim_dialogx_top_exit;
                                break;
                            }
                            case BOTTOM: {
                                CustomDialog.this.enterAnimResId = R.anim.anim_dialogx_bottom_enter;
                                CustomDialog.this.exitAnimResId = R.anim.anim_dialogx_bottom_exit;
                                break;
                            }
                            case LEFT: {
                                CustomDialog.this.enterAnimResId = R.anim.anim_dialogx_left_enter;
                                CustomDialog.this.exitAnimResId = R.anim.anim_dialogx_left_exit;
                                break;
                            }
                            case RIGHT: {
                                CustomDialog.this.enterAnimResId = R.anim.anim_dialogx_right_enter;
                                CustomDialog.this.exitAnimResId = R.anim.anim_dialogx_right_exit;
                            }
                        }
                        enterAnim = AnimationUtils.loadAnimation((Context)BaseDialog.getTopActivity(), (int)CustomDialog.this.enterAnimResId);
                        enterAnim.setInterpolator((Interpolator)new DecelerateInterpolator(2.0f));
                    } else {
                        int enterAnimResIdTemp = R.anim.anim_dialogx_default_enter;
                        if (overrideEnterAnimRes != 0) {
                            enterAnimResIdTemp = overrideEnterAnimRes;
                        }
                        if (CustomDialog.this.enterAnimResId != 0) {
                            enterAnimResIdTemp = CustomDialog.this.enterAnimResId;
                        }
                        enterAnim = AnimationUtils.loadAnimation((Context)BaseDialog.getTopActivity(), (int)enterAnimResIdTemp);
                    }
                    long enterAnimDurationTemp = enterAnim.getDuration();
                    if (overrideEnterDuration >= 0) {
                        enterAnimDurationTemp = overrideEnterDuration;
                    }
                    if (CustomDialog.this.enterAnimDuration >= 0L) {
                        enterAnimDurationTemp = CustomDialog.this.enterAnimDuration;
                    }
                    enterAnim.setDuration(enterAnimDurationTemp);
                    DialogImpl.this.boxCustom.setVisibility(0);
                    DialogImpl.this.boxCustom.startAnimation(enterAnim);
                    DialogImpl.this.boxRoot.setBackgroundColor(CustomDialog.this.maskColor);
                    if (overrideMaskEnterAnimRes != 0) {
                        Animation maskEnterAnim = AnimationUtils.loadAnimation((Context)BaseDialog.getTopActivity(), (int)overrideMaskEnterAnimRes);
                        maskEnterAnim.setInterpolator((Interpolator)new DecelerateInterpolator(2.0f));
                        maskEnterAnim.setDuration(enterAnimDurationTemp);
                        DialogImpl.this.boxRoot.startAnimation(maskEnterAnim);
                    }
                    ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                    bkgAlpha.setDuration(enterAnimDurationTemp);
                    bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            float value = ((Float)animation.getAnimatedValue()).floatValue();
                            DialogImpl.this.boxRoot.setBkgAlpha(value);
                        }
                    });
                    bkgAlpha.start();
                }
            });
        }

        @Override
        public void refreshView() {
            if (this.boxRoot == null || BaseDialog.getTopActivity() == null) {
                return;
            }
            RelativeLayout.LayoutParams rlp = (RelativeLayout.LayoutParams)this.boxCustom.getLayoutParams();
            if (rlp == null) {
                rlp = new RelativeLayout.LayoutParams(-2, -2);
            }
            switch (CustomDialog.this.align) {
                case TOP: {
                    rlp.removeRule(13);
                    rlp.addRule(10);
                    break;
                }
                case BOTTOM: {
                    rlp.removeRule(13);
                    rlp.addRule(12);
                    break;
                }
                case CENTER: {
                    rlp.removeRule(10);
                    rlp.removeRule(12);
                    rlp.addRule(13);
                    break;
                }
                case LEFT: {
                    rlp.removeRule(13);
                    rlp.addRule(10);
                    rlp.addRule(9);
                    break;
                }
                case RIGHT: {
                    rlp.removeRule(13);
                    rlp.addRule(10);
                    rlp.addRule(11);
                }
            }
            this.boxCustom.setLayoutParams((ViewGroup.LayoutParams)rlp);
            this.boxRoot.setAutoUnsafePlacePadding(CustomDialog.this.autoUnsafePlacePadding);
            if (CustomDialog.this.bkgInterceptTouch) {
                if (CustomDialog.this.isCancelable()) {
                    this.boxRoot.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            DialogImpl.this.doDismiss(v);
                        }
                    });
                } else {
                    this.boxRoot.setOnClickListener(null);
                }
            } else {
                this.boxRoot.setClickable(false);
            }
            if (CustomDialog.this.onBindView != null && CustomDialog.this.onBindView.getCustomView() != null) {
                CustomDialog.this.onBindView.bindParent((ViewGroup)this.boxCustom, CustomDialog.this.me);
            }
        }

        @Override
        public void doDismiss(View v) {
            if (v != null) {
                v.setEnabled(false);
            }
            if (!CustomDialog.this.dismissAnimFlag) {
                CustomDialog.this.dismissAnimFlag = true;
                this.boxCustom.post(new Runnable(){

                    @Override
                    public void run() {
                        int exitAnimResIdTemp = R.anim.anim_dialogx_default_exit;
                        if (overrideExitAnimRes != 0) {
                            exitAnimResIdTemp = overrideExitAnimRes;
                        }
                        if (CustomDialog.this.exitAnimResId != 0) {
                            exitAnimResIdTemp = CustomDialog.this.exitAnimResId;
                        }
                        Animation exitAnim = AnimationUtils.loadAnimation((Context)(BaseDialog.getTopActivity() == null ? DialogImpl.this.boxCustom.getContext() : BaseDialog.getTopActivity()), (int)exitAnimResIdTemp);
                        long exitAnimDurationTemp = exitAnim.getDuration();
                        if (overrideExitDuration >= 0) {
                            exitAnimDurationTemp = overrideExitDuration;
                        }
                        if (CustomDialog.this.exitAnimDuration >= 0L) {
                            exitAnimDurationTemp = CustomDialog.this.exitAnimDuration;
                        }
                        exitAnim.setDuration(exitAnimDurationTemp);
                        exitAnim.setAnimationListener(new Animation.AnimationListener(){

                            public void onAnimationStart(Animation animation) {
                            }

                            public void onAnimationEnd(Animation animation) {
                                CustomDialog.dismiss(CustomDialog.this.dialogView);
                            }

                            public void onAnimationRepeat(Animation animation) {
                            }
                        });
                        DialogImpl.this.boxCustom.startAnimation(exitAnim);
                        if (overrideMaskExitAnimRes != 0) {
                            Animation maskExitAnim = AnimationUtils.loadAnimation((Context)BaseDialog.getTopActivity(), (int)overrideMaskExitAnimRes);
                            maskExitAnim.setDuration(exitAnimDurationTemp);
                            maskExitAnim.setInterpolator((Interpolator)new DecelerateInterpolator(2.0f));
                            DialogImpl.this.boxRoot.startAnimation(maskExitAnim);
                        }
                        ValueAnimator bkgAlpha = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
                        bkgAlpha.setDuration(exitAnimDurationTemp);
                        bkgAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                if (DialogImpl.this.boxRoot != null) {
                                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                                    DialogImpl.this.boxRoot.setBkgAlpha(value);
                                    if (value == 0.0f) {
                                        DialogImpl.this.boxRoot.setVisibility(8);
                                    }
                                }
                            }
                        });
                        bkgAlpha.start();
                    }
                });
            }
        }
    }

    public static enum ALIGN {
        CENTER,
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

