/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.view.inputmethod.InputMethodManager;
import android.widget.RelativeLayout;
import androidx.core.view.ViewCompat;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.OnBackPressedListener;
import com.kongzue.dialogx.interfaces.OnSafeInsetsChangeListener;
import com.kongzue.dialogx.util.views.MaxRelativeLayout;

public class DialogXBaseRelativeLayout
extends RelativeLayout {
    private OnSafeInsetsChangeListener onSafeInsetsChangeListener;
    private BaseDialog parentDialog;
    private boolean autoUnsafePlacePadding = true;
    private boolean focusable = true;
    private OnLifecycleCallBack onLifecycleCallBack;
    private OnBackPressedListener onBackPressedListener;
    private boolean isInited = false;
    private ViewTreeObserver.OnGlobalLayoutListener decorViewLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            if (Build.VERSION.SDK_INT >= 23) {
                DialogXBaseRelativeLayout.this.paddingView(DialogXBaseRelativeLayout.this.getRootWindowInsets());
            } else {
                if (BaseDialog.getContext() == null) {
                    return;
                }
                DisplayMetrics displayMetrics = new DisplayMetrics();
                ((Activity)BaseDialog.getContext()).getWindowManager().getDefaultDisplay().getRealMetrics(displayMetrics);
                Rect rect = new Rect();
                ((Activity)BaseDialog.getContext()).getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
                DialogXBaseRelativeLayout.this.paddingView(rect.left, rect.top, displayMetrics.widthPixels - rect.right, displayMetrics.heightPixels - rect.bottom);
            }
        }
    };
    protected Rect unsafePlace = new Rect();

    public DialogXBaseRelativeLayout(Context context) {
        super(context);
        this.init(null);
    }

    public DialogXBaseRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public DialogXBaseRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public DialogXBaseRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (Build.VERSION.SDK_INT >= 29) {
            this.setForceDarkAllowed(false);
        }
        if (!this.isInited) {
            if (attrs != null) {
                TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.DialogXBaseRelativeLayout);
                this.focusable = a.getBoolean(R.styleable.DialogXBaseRelativeLayout_baseFocusable, true);
                a.recycle();
            }
            if (this.focusable) {
                this.setFocusable(true);
                this.setFocusableInTouchMode(true);
                this.requestFocus();
            }
        }
    }

    protected boolean fitSystemWindows(Rect insets) {
        this.paddingView(insets.left, insets.top, insets.right, insets.bottom);
        return super.fitSystemWindows(insets);
    }

    public WindowInsets dispatchApplyWindowInsets(WindowInsets insets) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.paddingView(insets.getSystemWindowInsetLeft(), insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight(), insets.getSystemWindowInsetBottom());
        }
        return super.dispatchApplyWindowInsets(insets);
    }

    public void paddingView(WindowInsets insets) {
        if (insets == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.paddingView(insets.getSystemWindowInsetLeft(), insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight(), insets.getSystemWindowInsetBottom());
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.isAttachedToWindow() && event.getAction() == 1 && event.getKeyCode() == 4) {
            if (this.onBackPressedListener != null) {
                this.onBackPressedListener.onBackPressed();
            }
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.getWindowToken(), 2);
        return super.onTouchEvent(event);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewParent parent = this.getParent();
        if (parent instanceof View) {
            ViewCompat.setFitsSystemWindows((View)this, (boolean)ViewCompat.getFitsSystemWindows((View)((View)parent)));
        }
        ViewCompat.requestApplyInsets((View)this);
        if (BaseDialog.getContext() == null) {
            return;
        }
        if (!this.isInEditMode()) {
            ((Activity)BaseDialog.getContext()).getWindow().getDecorView().getViewTreeObserver().addOnGlobalLayoutListener(this.decorViewLayoutListener);
        }
        if (this.onLifecycleCallBack != null) {
            this.onLifecycleCallBack.onShow();
        }
    }

    protected void onDetachedFromWindow() {
        if (this.decorViewLayoutListener != null && (Activity)BaseDialog.getContext() != null) {
            ((Activity)BaseDialog.getContext()).getWindow().getDecorView().getViewTreeObserver().removeOnGlobalLayoutListener(this.decorViewLayoutListener);
        }
        if (this.onLifecycleCallBack != null) {
            this.onLifecycleCallBack.onDismiss();
        }
        super.onDetachedFromWindow();
    }

    public boolean performClick() {
        return super.performClick();
    }

    public DialogXBaseRelativeLayout setOnLifecycleCallBack(OnLifecycleCallBack onLifecycleCallBack) {
        this.onLifecycleCallBack = onLifecycleCallBack;
        return this;
    }

    public float getSafeHeight() {
        return this.getMeasuredHeight() - this.unsafePlace.bottom - this.unsafePlace.top;
    }

    private void paddingView(int left, int top, int right, int bottom) {
        RelativeLayout.LayoutParams bkgLp;
        MaxRelativeLayout bkgView;
        this.unsafePlace = new Rect(left, top, right, bottom);
        if (this.onSafeInsetsChangeListener != null) {
            this.onSafeInsetsChangeListener.onChange(this.unsafePlace);
        }
        if ((bkgView = (MaxRelativeLayout)this.findViewById(R.id.bkg)) != null && bkgView.getLayoutParams() instanceof RelativeLayout.LayoutParams && (bkgLp = (RelativeLayout.LayoutParams)bkgView.getLayoutParams()).getRules()[12] == -1 && this.isAutoUnsafePlacePadding()) {
            bkgView.setPadding(0, 0, 0, bottom);
            this.setPadding(left, top, right, 0);
            return;
        }
        if (this.isAutoUnsafePlacePadding()) {
            this.setPadding(left, top, right, bottom);
        }
    }

    public DialogXBaseRelativeLayout setOnBackPressedListener(OnBackPressedListener onBackPressedListener) {
        this.onBackPressedListener = onBackPressedListener;
        return this;
    }

    public OnSafeInsetsChangeListener getOnSafeInsetsChangeListener() {
        return this.onSafeInsetsChangeListener;
    }

    public DialogXBaseRelativeLayout setOnSafeInsetsChangeListener(OnSafeInsetsChangeListener onSafeInsetsChangeListener) {
        this.onSafeInsetsChangeListener = onSafeInsetsChangeListener;
        return this;
    }

    public boolean isAutoUnsafePlacePadding() {
        return this.autoUnsafePlacePadding;
    }

    public DialogXBaseRelativeLayout setAutoUnsafePlacePadding(boolean autoUnsafePlacePadding) {
        this.autoUnsafePlacePadding = autoUnsafePlacePadding;
        return this;
    }

    public BaseDialog getParentDialog() {
        return this.parentDialog;
    }

    public DialogXBaseRelativeLayout setParentDialog(BaseDialog parentDialog) {
        this.parentDialog = parentDialog;
        return this;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.getParentDialog().onUIModeChange(newConfig);
    }

    public static abstract class OnLifecycleCallBack {
        public void onShow() {
        }

        public abstract void onDismiss();
    }
}

