/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import androidx.appcompat.widget.AppCompatImageView;
import com.kongzue.dialogx.interfaces.BaseDialog;

public class ActivityScreenShotImageView
extends AppCompatImageView {
    float width;
    float height;
    float mRadius;
    private int screenWidth;
    private int screenHeight;

    public ActivityScreenShotImageView(Context context) {
        super(context);
        this.init(null);
    }

    public ActivityScreenShotImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public ActivityScreenShotImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(2, null);
        }
    }

    public void setRadius(float mRadius) {
        this.mRadius = mRadius;
        this.invalidate();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.width = this.getWidth();
        this.height = this.getHeight();
    }

    protected void onDraw(Canvas canvas) {
        if (this.width >= this.mRadius && this.height > this.mRadius) {
            Path path = new Path();
            path.moveTo(this.mRadius, 0.0f);
            path.lineTo(this.width - this.mRadius, 0.0f);
            path.quadTo(this.width, 0.0f, this.width, this.mRadius);
            path.lineTo(this.width, this.height - this.mRadius);
            path.quadTo(this.width, this.height, this.width - this.mRadius, this.height);
            path.lineTo(this.mRadius, this.height);
            path.quadTo(0.0f, this.height, 0.0f, this.height - this.mRadius);
            path.lineTo(0.0f, this.mRadius);
            path.quadTo(0.0f, 0.0f, this.mRadius, 0.0f);
            canvas.clipPath(path);
        }
        try {
            super.onDraw(canvas);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.refreshImage();
    }

    private void refreshImage() {
        if (this.screenWidth != this.getMeasuredWidth() || this.screenHeight != this.getMeasuredHeight()) {
            this.screenWidth = this.getMeasuredWidth();
            this.screenHeight = this.getMeasuredHeight();
            this.doScreenshotActivityAndZoom();
        }
    }

    private void doScreenshotActivityAndZoom() {
        if (BaseDialog.getRootFrameLayout() == null) {
            return;
        }
        final View view = BaseDialog.getRootFrameLayout().getChildAt(0);
        this.drawViewImage(view);
        view.post(new Runnable(){

            @Override
            public void run() {
                ActivityScreenShotImageView.this.drawViewImage(view);
            }
        });
    }

    private void drawViewImage(View view) {
        view.destroyDrawingCache();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bmp = view.getDrawingCache();
        this.setImageBitmap(bmp);
    }
}

