/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.interfaces;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.interfaces.BaseDialog;

public abstract class OnBindView<D> {
    int layoutResId;
    View customView;

    public OnBindView(int layoutResId) {
        if (BaseDialog.getContext() == null) {
            DialogX.error("DialogX.init: \u521d\u59cb\u5316\u5f02\u5e38\uff0ccontext \u4e3a null \u6216\u672a\u521d\u59cb\u5316\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b https://github.com/kongzue/DialogX/wiki");
            return;
        }
        this.layoutResId = layoutResId;
        this.customView = LayoutInflater.from((Context)BaseDialog.getContext()).inflate(layoutResId, (ViewGroup)new RelativeLayout(BaseDialog.getContext()), false);
    }

    public OnBindView(View customView) {
        this.customView = customView;
    }

    public abstract void onBind(D var1, View var2);

    public int getLayoutResId() {
        return this.layoutResId;
    }

    public OnBindView<D> setLayoutResId(int layoutResId) {
        this.layoutResId = layoutResId;
        return this;
    }

    public View getCustomView() {
        return this.customView;
    }

    public OnBindView<D> setCustomView(View customView) {
        this.customView = customView;
        return this;
    }

    public void clean() {
        this.layoutResId = 0;
        this.customView = null;
    }

    public OnBindView<D> bindParent(ViewGroup parentView) {
        ViewGroup.LayoutParams lp;
        if (this.customView == null) {
            return this;
        }
        if (this.customView.getParent() != null) {
            if (this.customView.getParent() == parentView) {
                return this;
            }
            ((ViewGroup)this.customView.getParent()).removeView(this.customView);
        }
        if ((lp = parentView.getLayoutParams()) == null) {
            lp = new RelativeLayout.LayoutParams(-1, -2);
        }
        parentView.addView(this.customView, lp);
        return this;
    }

    public OnBindView<D> bindParent(ViewGroup parentView, BaseDialog dialog) {
        ViewGroup.LayoutParams lp;
        if (this.customView == null) {
            return this;
        }
        if (this.customView.getParent() != null) {
            if (this.customView.getParent() == parentView) {
                return this;
            }
            ((ViewGroup)this.customView.getParent()).removeView(this.customView);
        }
        if ((lp = this.customView.getLayoutParams()) == null) {
            lp = new RelativeLayout.LayoutParams(-1, -2);
        }
        parentView.addView(this.customView, lp);
        this.onBind(dialog, this.customView);
        return this;
    }
}

