/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.interfaces;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.dialogs.PopTip;
import com.kongzue.dialogx.impl.ActivityLifecycleImpl;
import com.kongzue.dialogx.interfaces.DialogXStyle;
import com.kongzue.dialogx.interfaces.OnBackPressedListener;
import com.kongzue.dialogx.util.TextInfo;
import com.kongzue.dialogx.util.WindowUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class BaseDialog {
    private static WeakReference<FrameLayout> rootFrameLayout;
    private static WeakReference<Activity> contextWeakReference;
    protected WeakReference<Activity> ownActivity;
    private static List<BaseDialog> runningDialogList;
    private WeakReference<View> dialogView;
    protected boolean cancelable = DialogX.cancelable;
    protected OnBackPressedListener onBackPressedListener;
    protected boolean isShow;
    protected DialogXStyle style = DialogX.globalStyle;
    protected DialogX.THEME theme = DialogX.globalTheme;
    protected boolean autoShowInputKeyboard;
    protected int backgroundColor = -1;
    protected long enterAnimDuration = DialogX.enterAnimDuration;
    protected long exitAnimDuration = DialogX.exitAnimDuration;

    public static void init(Context context) {
        if (context == null) {
            context = ActivityLifecycleImpl.getTopActivity();
        }
        if (context instanceof Activity) {
            BaseDialog.initActivityContext((Activity)context);
        }
        ActivityLifecycleImpl.init(context, new ActivityLifecycleImpl.onActivityResumeCallBack(){

            @Override
            public void getActivity(Activity activity) {
                BaseDialog.initActivityContext(activity);
            }
        });
    }

    private static void initActivityContext(Activity activity) {
        try {
            contextWeakReference = new WeakReference<Activity>(activity);
            rootFrameLayout = new WeakReference<FrameLayout>((FrameLayout)activity.getWindow().getDecorView());
        }
        catch (Exception e) {
            BaseDialog.error("DialogX.init: \u521d\u59cb\u5316\u5f02\u5e38\uff0c\u627e\u4e0d\u5230Activity\u7684\u6839\u5e03\u5c40");
        }
    }

    protected static void log(Object o) {
        if (DialogX.DEBUGMODE) {
            Log.i((String)">>>", (String)o.toString());
        }
    }

    protected static void error(Object o) {
        if (DialogX.DEBUGMODE) {
            Log.e((String)">>>", (String)o.toString());
        }
    }

    public abstract void onUIModeChange(Configuration var1);

    protected static void show(final View view) {
        if (view == null) {
            return;
        }
        final BaseDialog baseDialog = (BaseDialog)view.getTag();
        baseDialog.ownActivity = new WeakReference(contextWeakReference.get());
        baseDialog.dialogView = new WeakReference<View>(view);
        BaseDialog.log(baseDialog.dialogKey() + ".show");
        BaseDialog.addDialogToRunningList(baseDialog);
        if (DialogX.implIMPLMode == DialogX.IMPL_MODE.VIEW) {
            if (rootFrameLayout == null || rootFrameLayout.get() == null) {
                return;
            }
            BaseDialog.runOnMain(new Runnable(){

                @Override
                public void run() {
                    ((FrameLayout)rootFrameLayout.get()).addView(view);
                }
            });
        } else {
            BaseDialog.runOnMain(new Runnable(){

                @Override
                public void run() {
                    WindowUtil.show((Activity)contextWeakReference.get(), view, !(baseDialog instanceof PopTip));
                }
            });
        }
    }

    protected static void show(final Activity activity, final View view) {
        if (activity == null || view == null) {
            return;
        }
        if (activity.isDestroyed()) {
            BaseDialog.error(((BaseDialog)view.getTag()).dialogKey() + ".show ERROR: activity is Destroyed.");
            return;
        }
        final BaseDialog baseDialog = (BaseDialog)view.getTag();
        baseDialog.ownActivity = new WeakReference<Activity>(activity);
        baseDialog.dialogView = new WeakReference<View>(view);
        BaseDialog.log(baseDialog + ".show");
        BaseDialog.addDialogToRunningList(baseDialog);
        if (DialogX.implIMPLMode == DialogX.IMPL_MODE.VIEW) {
            final FrameLayout activityRootView = (FrameLayout)activity.getWindow().getDecorView();
            if (activityRootView == null) {
                return;
            }
            BaseDialog.runOnMain(new Runnable(){

                @Override
                public void run() {
                    activityRootView.addView(view);
                }
            });
        } else {
            BaseDialog.runOnMain(new Runnable(){

                @Override
                public void run() {
                    WindowUtil.show(activity, view, !(baseDialog instanceof PopTip));
                }
            });
        }
    }

    protected static void dismiss(final View dialogView) {
        if (dialogView == null) {
            return;
        }
        BaseDialog baseDialog = (BaseDialog)dialogView.getTag();
        BaseDialog.log(baseDialog.dialogKey() + ".dismiss");
        BaseDialog.removeDialogToRunningList(baseDialog);
        if (baseDialog.dialogView != null) {
            baseDialog.dialogView.clear();
        }
        if (DialogX.implIMPLMode == DialogX.IMPL_MODE.VIEW) {
            BaseDialog.runOnMain(new Runnable(){

                @Override
                public void run() {
                    if (dialogView.getParent() == null || !(dialogView.getParent() instanceof ViewGroup)) {
                        if (rootFrameLayout == null) {
                            return;
                        }
                        ((FrameLayout)rootFrameLayout.get()).removeView(dialogView);
                    } else {
                        ((ViewGroup)dialogView.getParent()).removeView(dialogView);
                    }
                }
            });
        } else {
            BaseDialog.runOnMain(new Runnable(){

                @Override
                public void run() {
                    WindowUtil.dismiss(dialogView);
                }
            });
        }
    }

    private static void addDialogToRunningList(BaseDialog baseDialog) {
        if (runningDialogList == null) {
            runningDialogList = new ArrayList<BaseDialog>();
        }
        runningDialogList.add(baseDialog);
    }

    private static void removeDialogToRunningList(BaseDialog baseDialog) {
        if (runningDialogList != null) {
            runningDialogList.remove(baseDialog);
        }
    }

    public static Context getContext() {
        if (contextWeakReference == null) {
            BaseDialog.init(null);
            if (contextWeakReference == null) {
                return null;
            }
            return (Context)contextWeakReference.get();
        }
        return (Context)contextWeakReference.get();
    }

    public static void cleanContext() {
        contextWeakReference.clear();
        contextWeakReference = null;
        System.gc();
    }

    public BaseDialog() {
        this.autoShowInputKeyboard = DialogX.autoShowInputKeyboard;
    }

    public abstract boolean isCancelable();

    public View createView(int layoutId) {
        if (BaseDialog.getContext() == null) {
            BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
            return null;
        }
        return LayoutInflater.from((Context)BaseDialog.getContext()).inflate(layoutId, null);
    }

    public boolean isShow() {
        return this.isShow;
    }

    public DialogXStyle getStyle() {
        return this.style;
    }

    public DialogX.THEME getTheme() {
        return this.theme;
    }

    protected void useTextInfo(TextView textView, TextInfo textInfo) {
        if (textInfo == null) {
            return;
        }
        if (textView == null) {
            return;
        }
        if (textInfo.getFontSize() > 0) {
            textView.setTextSize(1, (float)textInfo.getFontSize());
        }
        if (textInfo.getFontColor() != 1) {
            textView.setTextColor(textInfo.getFontColor());
        }
        if (textInfo.getGravity() != -1) {
            textView.setGravity(textInfo.getGravity());
        }
        textView.getPaint().setFakeBoldText(textInfo.isBold());
    }

    protected void showText(TextView textView, CharSequence text) {
        if (textView == null) {
            return;
        }
        if (BaseDialog.isNull(text)) {
            textView.setVisibility(8);
            textView.setText((CharSequence)"");
        } else {
            textView.setVisibility(0);
            textView.setText(text);
        }
    }

    protected View createHorizontalSplitView(int color2) {
        View splitView = new View(BaseDialog.getContext());
        splitView.setBackgroundColor(color2);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, 1);
        splitView.setLayoutParams((ViewGroup.LayoutParams)lp);
        return splitView;
    }

    protected View createVerticalSplitView(int color2, int height) {
        View splitView = new View(BaseDialog.getContext());
        splitView.setBackgroundColor(color2);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(1, this.dip2px(height));
        splitView.setLayoutParams((ViewGroup.LayoutParams)lp);
        return splitView;
    }

    public static boolean isNull(String s) {
        return s == null || s.trim().isEmpty() || "null".equals(s) || "(null)".equals(s);
    }

    public static boolean isNull(CharSequence c) {
        String s = String.valueOf(c);
        return c == null || s.trim().isEmpty() || "null".equals(s) || "(null)".equals(s);
    }

    public Resources getResources() {
        if (BaseDialog.getContext() == null) {
            return Resources.getSystem();
        }
        return BaseDialog.getContext().getResources();
    }

    public int dip2px(float dpValue) {
        float scale = BaseDialog.getContext().getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public boolean isLightTheme() {
        if (this.theme == DialogX.THEME.AUTO) {
            if (BaseDialog.getContext() == null) {
                return this.theme == DialogX.THEME.LIGHT;
            }
            return (BaseDialog.getContext().getApplicationContext().getResources().getConfiguration().uiMode & 0x30) == 16;
        }
        return this.theme == DialogX.THEME.LIGHT;
    }

    public static FrameLayout getRootFrameLayout() {
        if (rootFrameLayout == null) {
            BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
            return null;
        }
        return (FrameLayout)rootFrameLayout.get();
    }

    public void tintColor(View view, int color2) {
        view.setBackgroundTintList(ColorStateList.valueOf((int)color2));
    }

    protected void beforeShow() {
        if (BaseDialog.getContext() == null) {
            BaseDialog.init(null);
            if (BaseDialog.getContext() == null) {
                BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
            }
        }
        if (3 != 3) {
            BaseDialog.error("DialogX \u6240\u5f15\u7528\u7684 Style \u4e0d\u7b26\u5408\u5f53\u524d\u9002\u7528\u7248\u672c\uff1a3 \u5f15\u5165\u7684 Style(" + this.style.getClass().getSimpleName() + ") \u7248\u672c" + 3);
        }
    }

    protected String getString(int titleResId) {
        if (BaseDialog.getContext() == null) {
            BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
            return null;
        }
        return BaseDialog.getContext().getString(titleResId);
    }

    protected int getColor(int backgroundRes) {
        if (BaseDialog.getContext() == null) {
            BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
            return -16777216;
        }
        return this.getResources().getColor(backgroundRes);
    }

    public abstract String dialogKey();

    protected static void runOnMain(Runnable runnable) {
        if (!DialogX.autoRunOnUIThread) {
            runnable.run();
        }
        new Handler(Looper.getMainLooper()).post(runnable);
    }

    public View getDialogView() {
        if (this.dialogView == null) {
            return null;
        }
        return (View)this.dialogView.get();
    }

    public Activity getActivity() {
        return this.ownActivity == null ? null : (Activity)this.ownActivity.get();
    }

    protected void cleanActivityContext() {
        if (this.ownActivity != null) {
            this.ownActivity.clear();
        }
    }

    public static void recycleDialog(Activity activity) {
        if (DialogX.implIMPLMode == DialogX.IMPL_MODE.WINDOW && runningDialogList != null) {
            CopyOnWriteArrayList<BaseDialog> copyOnWriteList = new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
            for (BaseDialog baseDialog : copyOnWriteList) {
                if (baseDialog.getActivity() != activity || baseDialog.dialogView == null) continue;
                WindowUtil.dismiss((View)baseDialog.dialogView.get());
            }
        }
    }

    public static List<BaseDialog> getRunningDialogList() {
        return new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
    }

    public static enum BOOLEAN {
        TRUE,
        FALSE;

    }
}

